#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Unmechanical
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241022.3

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='unmechanical'
GAME_NAME='Unmechanical'

ARCHIVE_BASE_1_NAME='gog_unmechanical_2.1.0.5.sh'
ARCHIVE_BASE_1_MD5='a99865ecd58e895334d405523a23eee3'
ARCHIVE_BASE_1_SIZE='1600000'
ARCHIVE_BASE_1_VERSION='2.0-gog2.1.0.5'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/unmechanical'

ARCHIVE_BASE_0_NAME='gog_unmechanical_2.1.0.4.sh'
ARCHIVE_BASE_0_MD5='44453abb32e21b94e9731938486c71f7'
ARCHIVE_BASE_0_SIZE='1600000'
ARCHIVE_BASE_0_VERSION='2.0-gog2.1.0.4'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
Engine
Binaries/Linux/UDKGame-Linux'
## TODO: Check if the shipped libSDL2_mixer-2.0.so.0 could be replaced by a system-provided build
CONTENT_LIBS_BIN_PATH='data/noarch/game/Binaries/Linux/lib'
CONTENT_LIBS_BIN_FILES='
libPhysXCore.so
libPhysXExtensions.so.1
libPhysXLoader.so.1
libPhysXCooking.so
libSDL2_mixer-2.0.so.0
libtcmalloc.so.0'
## TODO: Check if the Steam library is required
CONTENT_LIBS0_BIN_PATH='data/noarch/game/Binaries/Linux/lib'
CONTENT_LIBS0_BIN_FILES='
libsteam_api.so'
CONTENT_GAME_DATA_FILES='
UDKGame
UnmechanicalIcon.bmp'

APP_MAIN_EXE='Binaries/Linux/UDKGame-Linux'
APP_MAIN_ICON='UnmechanicalIcon.bmp'
## Work around the game engine incompatibility with the wayland backend of SDL
APP_MAIN_PRERUN='
# Work around the game engine incompatibility with the wayland backend of SDL
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libogg.so.0
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libvorbis.so.0'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Run the game binary from its parent directory
game_exec_line() {
	cat <<- 'EOF'
	cd Binaries/Linux
	./UDKGame-Linux "$@"
	EOF
}

launchers_generation 'PKG_BIN'

# Build package

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
