/**
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * The list of named colors in CSS.
 */
export const NAMED_COLORS = [
  "aliceblue",
  "antiquewhite",
  "aqua",
  "aquamarine",
  "azure",
  "beige",
  "bisque",
  "black",
  "blanchedalmond",
  "blue",
  "blueviolet",
  "brown",
  "burlywood",
  "cadetblue",
  "chartreuse",
  "chocolate",
  "coral",
  "cornflowerblue",
  "cornsilk",
  "crimson",
  "cyan",
  "darkblue",
  "darkcyan",
  "darkgoldenrod",
  "darkgray",
  "darkgreen",
  "darkgrey",
  "darkkhaki",
  "darkmagenta",
  "darkolivegreen",
  "darkorange",
  "darkorchid",
  "darkred",
  "darksalmon",
  "darkseagreen",
  "darkslateblue",
  "darkslategray",
  "darkslategrey",
  "darkturquoise",
  "darkviolet",
  "deeppink",
  "deepskyblue",
  "dimgray",
  "dimgrey",
  "dodgerblue",
  "firebrick",
  "floralwhite",
  "forestgreen",
  "fuchsia",
  "gainsboro",
  "ghostwhite",
  "gold",
  "goldenrod",
  "gray",
  "green",
  "greenyellow",
  "grey",
  "honeydew",
  "hotpink",
  "indianred",
  "indigo",
  "ivory",
  "khaki",
  "lavender",
  "lavenderblush",
  "lawngreen",
  "lemonchiffon",
  "lightblue",
  "lightcoral",
  "lightcyan",
  "lightgoldenrodyellow",
  "lightgray",
  "lightgreen",
  "lightgrey",
  "lightpink",
  "lightsalmon",
  "lightseagreen",
  "lightskyblue",
  "lightslategray",
  "lightslategrey",
  "lightsteelblue",
  "lightyellow",
  "lime",
  "limegreen",
  "linen",
  "magenta",
  "maroon",
  "mediumaquamarine",
  "mediumblue",
  "mediumorchid",
  "mediumpurple",
  "mediumseagreen",
  "mediumslateblue",
  "mediumspringgreen",
  "mediumturquoise",
  "mediumvioletred",
  "midnightblue",
  "mintcream",
  "mistyrose",
  "moccasin",
  "navajowhite",
  "navy",
  "oldlace",
  "olive",
  "olivedrab",
  "orange",
  "orangered",
  "orchid",
  "palegoldenrod",
  "palegreen",
  "paleturquoise",
  "palevioletred",
  "papayawhip",
  "peachpuff",
  "peru",
  "pink",
  "plum",
  "powderblue",
  "purple",
  "rebeccapurple",
  "red",
  "rosybrown",
  "royalblue",
  "saddlebrown",
  "salmon",
  "sandybrown",
  "seagreen",
  "seashell",
  "sienna",
  "silver",
  "skyblue",
  "slateblue",
  "slategray",
  "slategrey",
  "snow",
  "springgreen",
  "steelblue",
  "tan",
  "teal",
  "thistle",
  "tomato",
  "turquoise",
  "violet",
  "wheat",
  "white",
  "whitesmoke",
  "yellow",
  "yellowgreen",
];

/**
 * The list of browser prefixed system colors.
 */
export const PREFIXED_SYSTEM_COLORS = [
  "-moz-buttondefault",
  "-moz-buttonhoverface",
  "-moz-buttonhovertext",
  "-moz-cellhighlight",
  "-moz-cellhighlighttext",
  "-moz-combobox",
  "-moz-comboboxtext",
  "-moz-dialog",
  "-moz-dialogtext",
  "-moz-dragtargetzone",
  "-moz-eventreerow",
  "-moz-field",
  "-moz-fieldtext",
  "-moz-html-cellhighlight",
  "-moz-html-cellhighlighttext",
  "-moz-mac-accentdarkestshadow",
  "-moz-mac-accentdarkshadow",
  "-moz-mac-accentface",
  "-moz-mac-accentlightesthighlight",
  "-moz-mac-accentlightshadow",
  "-moz-mac-accentregularhighlight",
  "-moz-mac-accentregularshadow",
  "-moz-mac-chrome-active",
  "-moz-mac-chrome-inactive",
  "-moz-mac-focusring",
  "-moz-mac-menuselect",
  "-moz-mac-menushadow",
  "-moz-mac-menutextselect",
  "-moz-menubarhovertext",
  "-moz-menubartext",
  "-moz-menuhover",
  "-moz-menuhovertext",
  "-moz-nativehyperlinktext",
  "-moz-oddtreerow",
  "-moz-win-accentcolor",
  "-moz-win-accentcolortext",
  "-moz-win-communicationstext",
  "-moz-win-mediatext",
  "-ms-hotlight",
];

/**
 * The list of system colors that are deprecated, but may still be in use.
 */
export const DEPRECATED_SYSTEM_COLORS = [
  "activeborder",
  "activecaption",
  "appworkspace",
  "background",
  "buttonhighlight",
  "buttonshadow",
  "captiontext",
  "inactiveborder",
  "inactivecaption",
  "inactivecaptiontext",
  "infobackground",
  "infotext",
  "menu",
  "menutext",
  "scrollbar",
  "threeddarkshadow",
  "threedface",
  "threedhighlight",
  "threedlightshadow",
  "threedshadow",
  "window",
  "windowframe",
  "windowtext",
];

/**
 * The list of system colors that are valid and intended to be used for high contrast/forced colors mode situations.
 */
export const SYSTEM_COLORS = [
  "accentcolor",
  "accentcolortext",
  "activetext",
  "buttonborder",
  "buttonface",
  "buttontext",
  "canvas",
  "canvastext",
  "field",
  "fieldtext",
  "graytext",
  "highlight",
  "highlighttext",
  "linktext",
  "mark",
  "marktext",
  "selecteditem",
  "selecteditemtext",
  "visitedtext",
];
