//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ArtifactManifestsClient contains the methods for the ArtifactManifests group.
// Don't use this type directly, use NewArtifactManifestsClient() instead.
type ArtifactManifestsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewArtifactManifestsClient creates a new instance of ArtifactManifestsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewArtifactManifestsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ArtifactManifestsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ArtifactManifestsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates a artifact manifest.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - artifactStoreName - The name of the artifact store.
//   - artifactManifestName - The name of the artifact manifest.
//   - parameters - Parameters supplied to the create or update artifact manifest operation.
//   - options - ArtifactManifestsClientBeginCreateOrUpdateOptions contains the optional parameters for the ArtifactManifestsClient.BeginCreateOrUpdate
//     method.
func (client *ArtifactManifestsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters ArtifactManifest, options *ArtifactManifestsClientBeginCreateOrUpdateOptions) (*runtime.Poller[ArtifactManifestsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ArtifactManifestsClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ArtifactManifestsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Creates or updates a artifact manifest.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *ArtifactManifestsClient) createOrUpdate(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters ArtifactManifest, options *ArtifactManifestsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "ArtifactManifestsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ArtifactManifestsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters ArtifactManifest, options *ArtifactManifestsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if artifactStoreName == "" {
		return nil, errors.New("parameter artifactStoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactStoreName}", url.PathEscape(artifactStoreName))
	if artifactManifestName == "" {
		return nil, errors.New("parameter artifactManifestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactManifestName}", url.PathEscape(artifactManifestName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes the specified artifact manifest.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - artifactStoreName - The name of the artifact store.
//   - artifactManifestName - The name of the artifact manifest.
//   - options - ArtifactManifestsClientBeginDeleteOptions contains the optional parameters for the ArtifactManifestsClient.BeginDelete
//     method.
func (client *ArtifactManifestsClient) BeginDelete(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, options *ArtifactManifestsClientBeginDeleteOptions) (*runtime.Poller[ArtifactManifestsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ArtifactManifestsClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ArtifactManifestsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes the specified artifact manifest.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *ArtifactManifestsClient) deleteOperation(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, options *ArtifactManifestsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "ArtifactManifestsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ArtifactManifestsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, options *ArtifactManifestsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if artifactStoreName == "" {
		return nil, errors.New("parameter artifactStoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactStoreName}", url.PathEscape(artifactStoreName))
	if artifactManifestName == "" {
		return nil, errors.New("parameter artifactManifestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactManifestName}", url.PathEscape(artifactManifestName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets information about a artifact manifest resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - artifactStoreName - The name of the artifact store.
//   - artifactManifestName - The name of the artifact manifest.
//   - options - ArtifactManifestsClientGetOptions contains the optional parameters for the ArtifactManifestsClient.Get method.
func (client *ArtifactManifestsClient) Get(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, options *ArtifactManifestsClientGetOptions) (ArtifactManifestsClientGetResponse, error) {
	var err error
	const operationName = "ArtifactManifestsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, options)
	if err != nil {
		return ArtifactManifestsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ArtifactManifestsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ArtifactManifestsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ArtifactManifestsClient) getCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, options *ArtifactManifestsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if artifactStoreName == "" {
		return nil, errors.New("parameter artifactStoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactStoreName}", url.PathEscape(artifactStoreName))
	if artifactManifestName == "" {
		return nil, errors.New("parameter artifactManifestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactManifestName}", url.PathEscape(artifactManifestName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ArtifactManifestsClient) getHandleResponse(resp *http.Response) (ArtifactManifestsClientGetResponse, error) {
	result := ArtifactManifestsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ArtifactManifest); err != nil {
		return ArtifactManifestsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByArtifactStorePager - Gets information about the artifact manifest.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - artifactStoreName - The name of the artifact store.
//   - options - ArtifactManifestsClientListByArtifactStoreOptions contains the optional parameters for the ArtifactManifestsClient.NewListByArtifactStorePager
//     method.
func (client *ArtifactManifestsClient) NewListByArtifactStorePager(resourceGroupName string, publisherName string, artifactStoreName string, options *ArtifactManifestsClientListByArtifactStoreOptions) *runtime.Pager[ArtifactManifestsClientListByArtifactStoreResponse] {
	return runtime.NewPager(runtime.PagingHandler[ArtifactManifestsClientListByArtifactStoreResponse]{
		More: func(page ArtifactManifestsClientListByArtifactStoreResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ArtifactManifestsClientListByArtifactStoreResponse) (ArtifactManifestsClientListByArtifactStoreResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ArtifactManifestsClient.NewListByArtifactStorePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByArtifactStoreCreateRequest(ctx, resourceGroupName, publisherName, artifactStoreName, options)
			}, nil)
			if err != nil {
				return ArtifactManifestsClientListByArtifactStoreResponse{}, err
			}
			return client.listByArtifactStoreHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByArtifactStoreCreateRequest creates the ListByArtifactStore request.
func (client *ArtifactManifestsClient) listByArtifactStoreCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, options *ArtifactManifestsClientListByArtifactStoreOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if artifactStoreName == "" {
		return nil, errors.New("parameter artifactStoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactStoreName}", url.PathEscape(artifactStoreName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByArtifactStoreHandleResponse handles the ListByArtifactStore response.
func (client *ArtifactManifestsClient) listByArtifactStoreHandleResponse(resp *http.Response) (ArtifactManifestsClientListByArtifactStoreResponse, error) {
	result := ArtifactManifestsClientListByArtifactStoreResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ArtifactManifestListResult); err != nil {
		return ArtifactManifestsClientListByArtifactStoreResponse{}, err
	}
	return result, nil
}

// ListCredential - List credential for publishing artifacts defined in artifact manifest.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - artifactStoreName - The name of the artifact store.
//   - artifactManifestName - The name of the artifact manifest.
//   - options - ArtifactManifestsClientListCredentialOptions contains the optional parameters for the ArtifactManifestsClient.ListCredential
//     method.
func (client *ArtifactManifestsClient) ListCredential(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, options *ArtifactManifestsClientListCredentialOptions) (ArtifactManifestsClientListCredentialResponse, error) {
	var err error
	const operationName = "ArtifactManifestsClient.ListCredential"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCredentialCreateRequest(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, options)
	if err != nil {
		return ArtifactManifestsClientListCredentialResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ArtifactManifestsClientListCredentialResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ArtifactManifestsClientListCredentialResponse{}, err
	}
	resp, err := client.listCredentialHandleResponse(httpResp)
	return resp, err
}

// listCredentialCreateRequest creates the ListCredential request.
func (client *ArtifactManifestsClient) listCredentialCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, options *ArtifactManifestsClientListCredentialOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}/listCredential"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if artifactStoreName == "" {
		return nil, errors.New("parameter artifactStoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactStoreName}", url.PathEscape(artifactStoreName))
	if artifactManifestName == "" {
		return nil, errors.New("parameter artifactManifestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactManifestName}", url.PathEscape(artifactManifestName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCredentialHandleResponse handles the ListCredential response.
func (client *ArtifactManifestsClient) listCredentialHandleResponse(resp *http.Response) (ArtifactManifestsClientListCredentialResponse, error) {
	result := ArtifactManifestsClientListCredentialResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result); err != nil {
		return ArtifactManifestsClientListCredentialResponse{}, err
	}
	return result, nil
}

// Update - Updates a artifact manifest resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - artifactStoreName - The name of the artifact store.
//   - artifactManifestName - The name of the artifact manifest.
//   - parameters - Parameters supplied to the create or update artifact manifest operation.
//   - options - ArtifactManifestsClientUpdateOptions contains the optional parameters for the ArtifactManifestsClient.Update
//     method.
func (client *ArtifactManifestsClient) Update(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters TagsObject, options *ArtifactManifestsClientUpdateOptions) (ArtifactManifestsClientUpdateResponse, error) {
	var err error
	const operationName = "ArtifactManifestsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, parameters, options)
	if err != nil {
		return ArtifactManifestsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ArtifactManifestsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ArtifactManifestsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ArtifactManifestsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters TagsObject, options *ArtifactManifestsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if artifactStoreName == "" {
		return nil, errors.New("parameter artifactStoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactStoreName}", url.PathEscape(artifactStoreName))
	if artifactManifestName == "" {
		return nil, errors.New("parameter artifactManifestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactManifestName}", url.PathEscape(artifactManifestName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ArtifactManifestsClient) updateHandleResponse(resp *http.Response) (ArtifactManifestsClientUpdateResponse, error) {
	result := ArtifactManifestsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ArtifactManifest); err != nil {
		return ArtifactManifestsClientUpdateResponse{}, err
	}
	return result, nil
}

// BeginUpdateState - Update state for artifact manifest.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - artifactStoreName - The name of the artifact store.
//   - artifactManifestName - The name of the artifact manifest.
//   - parameters - Parameters supplied to update the state of artifact manifest.
//   - options - ArtifactManifestsClientBeginUpdateStateOptions contains the optional parameters for the ArtifactManifestsClient.BeginUpdateState
//     method.
func (client *ArtifactManifestsClient) BeginUpdateState(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters ArtifactManifestUpdateState, options *ArtifactManifestsClientBeginUpdateStateOptions) (*runtime.Poller[ArtifactManifestsClientUpdateStateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateState(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ArtifactManifestsClientUpdateStateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ArtifactManifestsClientUpdateStateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateState - Update state for artifact manifest.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *ArtifactManifestsClient) updateState(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters ArtifactManifestUpdateState, options *ArtifactManifestsClientBeginUpdateStateOptions) (*http.Response, error) {
	var err error
	const operationName = "ArtifactManifestsClient.BeginUpdateState"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateStateCreateRequest(ctx, resourceGroupName, publisherName, artifactStoreName, artifactManifestName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateStateCreateRequest creates the UpdateState request.
func (client *ArtifactManifestsClient) updateStateCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, artifactStoreName string, artifactManifestName string, parameters ArtifactManifestUpdateState, options *ArtifactManifestsClientBeginUpdateStateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}/updateState"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if artifactStoreName == "" {
		return nil, errors.New("parameter artifactStoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactStoreName}", url.PathEscape(artifactStoreName))
	if artifactManifestName == "" {
		return nil, errors.New("parameter artifactManifestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{artifactManifestName}", url.PathEscape(artifactManifestName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
