//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorsimple1200series_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple1200series/armstorsimple1200series"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersList.json
func ExampleManagersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagerList = armstorsimple1200series.ManagerList{
		// 	Value: []*armstorsimple1200series.Manager{
		// 		{
		// 			Name: to.Ptr("AuTo1117160133591"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/GroupForArmAutomation/providers/Microsoft.StorSimple/Managers/AuTo1117160133591"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"datetime'2017-03-22T09%3A58%3A03.0020106Z'\""),
		// 			Properties: &armstorsimple1200series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple1200series.ManagerTypeHelsinkiV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple1200series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("GAuTosumanths-pc10227181824221"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/GroupForArmAutomation/providers/Microsoft.StorSimple/Managers/GAuTosumanths-pc10227181824221"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"datetime'2018-02-27T12%3A56%3A02.0580397Z'\""),
		// 			Properties: &armstorsimple1200series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple1200series.ManagerTypeGardaV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple1200series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersListByResourceGroup.json
func ExampleManagersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListByResourceGroupPager("ResourceGroupForSDKTest", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagerList = armstorsimple1200series.ManagerList{
		// 	Value: []*armstorsimple1200series.Manager{
		// 		{
		// 			Name: to.Ptr("hManagerForSDKTest"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hManagerForSDKTest"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"TagName": to.Ptr("Demo manager for SDK test"),
		// 			},
		// 			Etag: to.Ptr("W/\"datetime'2018-08-12T15%3A10%3A35.3685957Z'\""),
		// 			Properties: &armstorsimple1200series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple1200series.ManagerTypeHelsinkiV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple1200series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("hAzureSDKOperations"),
		// 			Type: to.Ptr("Microsoft.StorSimple/Managers"),
		// 			ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hAzureSDKOperations"),
		// 			Location: to.Ptr("southeastasia"),
		// 			Etag: to.Ptr("W/\"datetime'2018-08-07T16%3A06%3A24.4590789Z'\""),
		// 			Properties: &armstorsimple1200series.ManagerProperties{
		// 				CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
		// 					Type: to.Ptr(armstorsimple1200series.ManagerTypeHelsinkiV1),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				SKU: &armstorsimple1200series.ManagerSKU{
		// 					Name: to.Ptr("Standard"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersGet.json
func ExampleManagersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().Get(ctx, "ResourceGroupForSDKTest", "hManagerForSDKTest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Manager = armstorsimple1200series.Manager{
	// 	Name: to.Ptr("hManagerForSDKTest"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers"),
	// 	ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hManagerForSDKTest"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"TagName": to.Ptr("Demo manager for SDK test"),
	// 	},
	// 	Etag: to.Ptr("W/\"datetime'2018-08-12T15%3A10%3A31.6040125Z'\""),
	// 	Properties: &armstorsimple1200series.ManagerProperties{
	// 		CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
	// 			Type: to.Ptr(armstorsimple1200series.ManagerTypeHelsinkiV1),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstorsimple1200series.ManagerSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersCreateOrUpdate.json
func ExampleManagersClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().CreateOrUpdate(ctx, "ResourceGroupForSDKTest", "hManagerForSDKTest", armstorsimple1200series.Manager{
		Name:     to.Ptr("hManagerForSDKTest"),
		Location: to.Ptr("westus"),
		Properties: &armstorsimple1200series.ManagerProperties{
			CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
				Type: to.Ptr(armstorsimple1200series.ManagerTypeHelsinkiV1),
			},
			SKU: &armstorsimple1200series.ManagerSKU{
				Name: to.Ptr("Standard"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Manager = armstorsimple1200series.Manager{
	// 	Name: to.Ptr("hManagerForSDKTest"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers"),
	// 	ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hManagerForSDKTest"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"TagName": to.Ptr("Demo manager for SDK test"),
	// 	},
	// 	Etag: to.Ptr("W/\"datetime'2018-08-12T15%3A10%3A31.6040125Z'\""),
	// 	Properties: &armstorsimple1200series.ManagerProperties{
	// 		CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
	// 			Type: to.Ptr(armstorsimple1200series.ManagerTypeHelsinkiV1),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstorsimple1200series.ManagerSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersDelete.json
func ExampleManagersClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewManagersClient().Delete(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersUpdate.json
func ExampleManagersClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().Update(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", armstorsimple1200series.ManagerPatch{
		Tags: map[string]*string{
			"TagName": to.Ptr("ForSDKTest"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Manager = armstorsimple1200series.Manager{
	// 	Name: to.Ptr("ManagerForSDKTest2"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/ManagerForSDKTest2"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"TagName": to.Ptr("ForSDKTest"),
	// 	},
	// 	Etag: to.Ptr("W/\"datetime'2017-06-18T16%3A13%3A43.8476579Z'\""),
	// 	Properties: &armstorsimple1200series.ManagerProperties{
	// 		CisIntrinsicSettings: &armstorsimple1200series.ManagerIntrinsicSettings{
	// 			Type: to.Ptr(armstorsimple1200series.ManagerTypeHelsinkiV1),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		SKU: &armstorsimple1200series.ManagerSKU{
	// 			Name: to.Ptr("Standard"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersUploadRegistrationCertificate.json
func ExampleManagersClient_UploadRegistrationCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().UploadRegistrationCertificate(ctx, "windows", "ResourceGroupForSDKTest", "ManagerForSDKTest2", armstorsimple1200series.UploadCertificateRequest{
		ContractVersion: to.Ptr(armstorsimple1200series.ContractVersionsV201212),
		Properties: &armstorsimple1200series.RawCertificateData{
			AuthType:    to.Ptr(armstorsimple1200series.AuthTypeAzureActiveDirectory),
			Certificate: to.Ptr("MIIC3TCCAcWgAwIBAgIQEr0bAWD6wJtA4LIbZ9NtgzANBgkqhkiG9w0BAQUFADAeMRwwGgYDVQQDExNXaW5kb3dzIEF6dXJlIFRvb2xzMB4XDTE4MDkxMDE1MzY0MFoXDTE4MDkxMzE1NDY0MFowHjEcMBoGA1UEAxMTV2luZG93cyBBenVyZSBUb29sczCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANUsKkz2Z4fECKMyNeLb9v3pr1XF4dVe+MITDtgphjl81ng190Y0IHgCVnh4YjfplUSpMk/1xii0rI5AAPwoz3ze2qRPtnwCiTaoVLkUe6knNRPzrRvVXHB81J0/14MO0lwdByHhdccRcVJZPLt5724t4aQny82v2AayJdDDkBBWNlpcqPy6n3sygP00THMPP0O3sFqy924eHqoDj3qSw79/meaZBJt9S5odPuFoskxjHuI4lM6BmK1Ql7p8Wo9/GhTOIoMz81orKPHRDleLjutwL4mb6NnhI5rfT/MxnHD6m82c4YYqiZC3XiTyJWVCkWkp7PK92OdRp6FA87rdKDMCAwEAAaMXMBUwEwYDVR0lBAwwCgYIKwYBBQUHAwIwDQYJKoZIhvcNAQEFBQADggEBAIYlezVU68TuEblkn06vM5dfzSmHKJOQgW61nDlLnyKrmSJtzKZLCAswTE2VyJHwKNdZgW15coJFINjWBLWcLr0/GjNV4u3Z+UL3NhBFQd5xuMtKsIhuoscKtyk0JHQXpBvHNmOUCobfQfOBQfTVC7kmyWdtlGztFUVxD28s6S5gMb1FEWWN68NOOJ3/ZhaTbUEM54yw8Hk8/f0L/Zn/7BYHUyWWA3KStAaYn89C/ZFF+952ark2VaKGIjBRQzgrJEIR8dI4r46I3DoEfzGPESKvQPvVLhOX84RG0PLPOtnRbHBVew1Nh3HE9kgCubkPKK+NPWE9IHZPoRmOTWBe+zU="),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UploadCertificateResponse = armstorsimple1200series.UploadCertificateResponse{
	// 	Name: to.Ptr("windows"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/certificates"),
	// 	ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourcegroups/cleanupservice/providers/Microsoft.StorSimple/managers/res-jem-hel/certificates/windows"),
	// 	Properties: &armstorsimple1200series.ResourceCertificateAndAADDetails{
	// 		AADAuthority: to.Ptr("https://login.windows.net"),
	// 		AADTenantID: to.Ptr("625ad78b-e6ce-49ed-b9cd-29f4aa12d77e"),
	// 		AuthType: to.Ptr(armstorsimple1200series.AuthTypeAzureActiveDirectory),
	// 		AzureManagementEndpointAudience: to.Ptr("https://pod01-id1.wus.backup.windowsazure.com/restapi/"),
	// 		Certificate: to.Ptr("MIIC3TCCAcWgAwIBAgIQEr0bAWD6wJtA4LIbZ9NtgzANBgkqhkiG9w0BAQUFADAeMRwwGgYDVQQDExNXaW5kb3dzIEF6dXJlIFRvb2xzMB4XDTE4MDkxMDE1MzY0MFoXDTE4MDkxMzE1NDY0MFowHjEcMBoGA1UEAxMTV2luZG93cyBBenVyZSBUb29sczCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANUsKkz2Z4fECKMyNeLb9v3pr1XF4dVe+MITDtgphjl81ng190Y0IHgCVnh4YjfplUSpMk/1xii0rI5AAPwoz3ze2qRPtnwCiTaoVLkUe6knNRPzrRvVXHB81J0/14MO0lwdByHhdccRcVJZPLt5724t4aQny82v2AayJdDDkBBWNlpcqPy6n3sygP00THMPP0O3sFqy924eHqoDj3qSw79/meaZBJt9S5odPuFoskxjHuI4lM6BmK1Ql7p8Wo9/GhTOIoMz81orKPHRDleLjutwL4mb6NnhI5rfT/MxnHD6m82c4YYqiZC3XiTyJWVCkWkp7PK92OdRp6FA87rdKDMCAwEAAaMXMBUwEwYDVR0lBAwwCgYIKwYBBQUHAwIwDQYJKoZIhvcNAQEFBQADggEBAIYlezVU68TuEblkn06vM5dfzSmHKJOQgW61nDlLnyKrmSJtzKZLCAswTE2VyJHwKNdZgW15coJFINjWBLWcLr0/GjNV4u3Z+UL3NhBFQd5xuMtKsIhuoscKtyk0JHQXpBvHNmOUCobfQfOBQfTVC7kmyWdtlGztFUVxD28s6S5gMb1FEWWN68NOOJ3/ZhaTbUEM54yw8Hk8/f0L/Zn/7BYHUyWWA3KStAaYn89C/ZFF+952ark2VaKGIjBRQzgrJEIR8dI4r46I3DoEfzGPESKvQPvVLhOX84RG0PLPOtnRbHBVew1Nh3HE9kgCubkPKK+NPWE9IHZPoRmOTWBe+zU="),
	// 		FriendlyName: to.Ptr(""),
	// 		Issuer: to.Ptr("CN=Windows Azure Tools"),
	// 		ResourceID: to.Ptr[int64](5047111583862266000),
	// 		ServicePrincipalClientID: to.Ptr("a65f2051-51a3-4fa0-965e-76195bc73f4d"),
	// 		ServicePrincipalObjectID: to.Ptr("86d19f0e-82b7-49bf-a16e-1fbb4e5288d5"),
	// 		Subject: to.Ptr("CN=Windows Azure Tools"),
	// 		Thumbprint: to.Ptr("0526BD0123A52EABDB586AF0C080ABEEF3BB4240"),
	// 		ValidFrom: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-10T15:36:40.000Z"); return t}()),
	// 		ValidTo: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T15:46:40.000Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersGetEncryptionSettings.json
func ExampleManagersClient_GetEncryptionSettings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetEncryptionSettings(ctx, "ResourceGroupForSDKTest", "hAzureSDKOperations", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EncryptionSettings = armstorsimple1200series.EncryptionSettings{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/encryptionSettings"),
	// 	ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/hAzureSDKOperations/encryptionSettings/default"),
	// 	Properties: &armstorsimple1200series.EncryptionSettingsProperties{
	// 		EncryptionStatus: to.Ptr(armstorsimple1200series.EncryptionStatusEnabled),
	// 		KeyRolloverStatus: to.Ptr(armstorsimple1200series.KeyRolloverStatusNotRequired),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersGetExtendedInfo.json
func ExampleManagersClient_GetExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetExtendedInfo(ctx, "ResourceGroupForSDKTest", "hAzureSDKOperations", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagerExtendedInfo = armstorsimple1200series.ManagerExtendedInfo{
	// 	Name: to.Ptr("vaultExtendedInfo"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
	// 	ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hAzureSDKOperationsextendedInformation/vaultExtendedInfo"),
	// 	Etag: to.Ptr("72227c97-ecab-4f3d-8e89-7ab2e9681735"),
	// 	Properties: &armstorsimple1200series.ManagerExtendedInfoProperties{
	// 		Algorithm: to.Ptr("None"),
	// 		IntegrityKey: to.Ptr("84be7258-8d22-43ba-896a-074616e0a00c"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersCreateExtendedInfo.json
func ExampleManagersClient_CreateExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().CreateExtendedInfo(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest2", armstorsimple1200series.ManagerExtendedInfo{
		Name: to.Ptr("vaultExtendedInfo"),
		Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
		ID:   to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hManagerForSDKTestextendedInformation/vaultExtendedInfo"),
		Etag: to.Ptr("6531d5d7-3ced-4f78-83b6-804368f2ca0c"),
		Properties: &armstorsimple1200series.ManagerExtendedInfoProperties{
			Algorithm:    to.Ptr("SHA256"),
			IntegrityKey: to.Ptr("e6501980-7efe-4602-bb0e-3cb9a08a6003"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagerExtendedInfo = armstorsimple1200series.ManagerExtendedInfo{
	// 	Name: to.Ptr("vaultExtendedInfo"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
	// 	ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/cleanupservice/providers/Microsoft.StorSimple/Managers/res-jem-helextendedInformation/vaultExtendedInfo"),
	// 	Etag: to.Ptr("e096714c-e3a4-49b5-828e-1d0320b38689"),
	// 	Properties: &armstorsimple1200series.ManagerExtendedInfoProperties{
	// 		Algorithm: to.Ptr("SHA256"),
	// 		IntegrityKey: to.Ptr("b40efdf9-cd98-4409-a669-6886ad4e6005"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersDeleteExtendedInfo.json
func ExampleManagersClient_DeleteExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewManagersClient().DeleteExtendedInfo(ctx, "ResourceGroupForSDKTest", "hManagerForSDKTest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersUpdateExtendedInfo.json
func ExampleManagersClient_UpdateExtendedInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().UpdateExtendedInfo(ctx, "ResourceGroupForSDKTest", "hManagerForSDKTest", "6531d5d7-3ced-4f78-83b6-804368f2ca0c", armstorsimple1200series.ManagerExtendedInfo{
		Name: to.Ptr("vaultExtendedInfo"),
		Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
		ID:   to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hManagerForSDKTestextendedInformation/vaultExtendedInfo"),
		Etag: to.Ptr("6531d5d7-3ced-4f78-83b6-804368f2ca0c"),
		Properties: &armstorsimple1200series.ManagerExtendedInfoProperties{
			Algorithm:    to.Ptr("SHA256"),
			IntegrityKey: to.Ptr("e6501980-7efe-4602-bb0e-3cb9a08a6003"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagerExtendedInfo = armstorsimple1200series.ManagerExtendedInfo{
	// 	Name: to.Ptr("vaultExtendedInfo"),
	// 	Type: to.Ptr("Microsoft.StorSimple/Managers/extendedInformation"),
	// 	ID: to.Ptr("/subscriptions/9eb689cd-7243-43b4-b6f6-5c65cb296641/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/Managers/hManagerForSDKTestextendedInformation/vaultExtendedInfo"),
	// 	Etag: to.Ptr("85eaf93a-c415-49ad-a729-01934b3292dd"),
	// 	Properties: &armstorsimple1200series.ManagerExtendedInfoProperties{
	// 		Algorithm: to.Ptr("SHA256"),
	// 		IntegrityKey: to.Ptr("e6501980-7efe-4602-bb0e-3cb9a08a6003"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersGetEncryptionKey.json
func ExampleManagersClient_GetEncryptionKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagersClient().GetEncryptionKey(ctx, "ResourceGroupForSDKTest", "hAzureSDKOperations", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SymmetricEncryptedSecret = armstorsimple1200series.SymmetricEncryptedSecret{
	// 	EncryptionAlgorithm: to.Ptr(armstorsimple1200series.EncryptionAlgorithmAES256),
	// 	Value: to.Ptr("EAAAAEVOuLjZQYRnJxD6RjOyBWGYfyw8wqXci5WHh8QfS98ouU65SFHHVWs2MdD2KeND3ZFM989gwfMaOVwiSmdMvi30/VnoNZIu7rhGG6SKVhUSHfOSZyb2eUufvwPXNUKa/mhVPJ4SH1uHUHvG1bjWaFZ2ojo1ff7e0xQlifYWZQdSi6ScxzjI41EdIT7Hspp+xtU2y+8Q5ALDgASRdVHdHYRmSF1/uyDXoAU8spTLrm/Ug8X0cadt1w+pAX0fnx3PPyfsNRVsbWofLtm1CirKv2euA8TamgFz82/xI4vT1m2RopLFc2W6sXGeSESWK2fUlV6WLjTqPwGXSJ7ZQ5/QcIP08QC1Z3K7muemFtSx+sr8/kjQIufxjD/A7cTN77bpTBCU7l1GxmdPFMlZxsVrU23SXAdu4JWcw6KrdSlxjig6GBHCHqCtaocjpD46GkRiGye80JudJqroWz0F14X9eOa48He3K/HLZnRdmaNKHClzApW3hCZwiI1r0NhHi9mLn3Laiy920L+kLRDghRsps9gMpYbQFYNNnQMAnCdWQ36TUbQWqqqcLVpgxaKvzbsXpYzL6ntlztmIp9RZ+i2r9ZoGGg4kIkiUNhpSVZ8k05H49zc1fJKapVER1MbEKApVBiC9ck+TbNMjkzOHY39QBJK35EYz2qfkGPTIDrnpdK4GiBXEDnq9ERx0CHVz8qLIRn538pZp8jktHft5WvOWk0Zw31+lSPnLCX1qBfnqT6ulH08VozwJqidcb2fOfMJ8BRgYupP47RGUa6gdRMMUmS3KgDetX0qXaqO4krCQYsiA3PeQwuZWVGA3eeALUQsizDFS1+esWVP/z9HgJclv4ydHjrMTf+GyWVozGJui9zqMz3B2otWZmWcyWAe4iE9a2w7P1MLgGvSShhQSU7S54mR4QF7WOArpaYUqe4VoZdLaTHS9bVDBrjPbFrrjfQlYNt8CPN2KmpeGsdicNlCeq5JCG9Ys7rpjr1QM49V0yV6sfOgE8rYldebwtJGwDnuq09LrGAIfuzVQ59AjW6YScPBSNeCnsyk4bC1I1zDKdEhCHspR8/3w++dAMH3wZ6fCEbOLgTy06lHVPyKyINVcDY/TLbSz04v9gFySujzSrt1qCrL5aK4eGxsANlVVwxXIGlTcyH5MYlrnNCIToIrdfIqmkjTea9WJ4buaz3DAnDsA+4ai+3vYMwJakE2mRxW5YIQHNEgoaY460a5HRCmnjDvpAmQ6ICB7uR/JunfQ2Jc3PI889dY8YOfy8YWHqzbXMUN7eRWRTp6A1W6J2CFtKLflDu0t+ZGX4Pa27zK4pN6ml410hoYGjet3+O7bxL/z3aR9cOgmV6kMhboOhvMaj8V43zSiq9ONhZgDZmVzhwP4oaKP/O1uhWqwbhGVOeAk8hCHTiD3FUXlrJVm3IgUSn8lL5R82cwyol578BKernVBP5PT4vwyF1aWPaOyxx+kITBcALBmlQv3JanW5j9FkFP0gC5oy7KitEXYac132oe7HiOQ7t1TJCoem5kxK3bYLg=="),
	// 	ValueCertificateThumbprint: to.Ptr("D73DB57C4CDD6761E159F8D1E8A7D759424983FD"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersListMetrics.json
func ExampleManagersClient_NewListMetricsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListMetricsPager("ResourceGroupForSDKTest", "hAzureSDKOperations", &armstorsimple1200series.ManagersClientListMetricsOptions{Filter: to.Ptr("startTime%20ge%20'2018-08-04T18:30:00Z'%20and%20endTime%20le%20'2018-08-11T18:30:00Z'")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricList = armstorsimple1200series.MetricList{
		// 	Value: []*armstorsimple1200series.Metrics{
		// 		{
		// 			Name: &armstorsimple1200series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Storage Used"),
		// 				Value: to.Ptr("HostUsedStorage"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metrics"),
		// 			Dimensions: []*armstorsimple1200series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("hAzureSDKOperations"),
		// 			}},
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-11T18:30:00.000Z"); return t}()),
		// 			PrimaryAggregation: to.Ptr(armstorsimple1200series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("https://pod01-cis2.sea.storsimple.windowsazure.com/managers/4239154091695873374"),
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-04T18:30:00.000Z"); return t}()),
		// 			TimeGrain: to.Ptr("1.00:00:00"),
		// 			Unit: to.Ptr(armstorsimple1200series.MetricUnitBytes),
		// 			Values: []*armstorsimple1200series.MetricData{
		// 				{
		// 					Average: to.Ptr[float64](0),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](0),
		// 					Minimum: to.Ptr[float64](0),
		// 					Sum: to.Ptr[float64](0),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-07T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](1107165184),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](1107165184),
		// 					Minimum: to.Ptr[float64](1107165184),
		// 					Sum: to.Ptr[float64](1107165184),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-11T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](928645120),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](928645120),
		// 					Minimum: to.Ptr[float64](928645120),
		// 					Sum: to.Ptr[float64](928645120),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-10T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](0),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](0),
		// 					Minimum: to.Ptr[float64](0),
		// 					Sum: to.Ptr[float64](0),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](884342784),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](884342784),
		// 					Minimum: to.Ptr[float64](884342784),
		// 					Sum: to.Ptr[float64](884342784),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-09T00:00:00.000Z"); return t}()),
		// 			}},
		// 		},
		// 		{
		// 			Name: &armstorsimple1200series.MetricName{
		// 				LocalizedValue: to.Ptr("Cloud Storage Used"),
		// 				Value: to.Ptr("CloudConsumedStorage"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metrics"),
		// 			Dimensions: []*armstorsimple1200series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("hAzureSDKOperations"),
		// 			}},
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-11T18:30:00.000Z"); return t}()),
		// 			PrimaryAggregation: to.Ptr(armstorsimple1200series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("https://pod01-cis2.sea.storsimple.windowsazure.com/managers/4239154091695873374"),
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-04T18:30:00.000Z"); return t}()),
		// 			TimeGrain: to.Ptr("1.00:00:00"),
		// 			Unit: to.Ptr(armstorsimple1200series.MetricUnitBytes),
		// 			Values: []*armstorsimple1200series.MetricData{
		// 				{
		// 					Average: to.Ptr[float64](0),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](0),
		// 					Minimum: to.Ptr[float64](0),
		// 					Sum: to.Ptr[float64](0),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-07T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](0),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](0),
		// 					Minimum: to.Ptr[float64](0),
		// 					Sum: to.Ptr[float64](0),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](298096),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](298096),
		// 					Minimum: to.Ptr[float64](298096),
		// 					Sum: to.Ptr[float64](298096),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-11T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](274728),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](274728),
		// 					Minimum: to.Ptr[float64](274728),
		// 					Sum: to.Ptr[float64](274728),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-10T00:00:00.000Z"); return t}()),
		// 				},
		// 				{
		// 					Average: to.Ptr[float64](231725),
		// 					Count: to.Ptr[int32](1),
		// 					Maximum: to.Ptr[float64](231725),
		// 					Minimum: to.Ptr[float64](231725),
		// 					Sum: to.Ptr[float64](231725),
		// 					TimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-09T00:00:00.000Z"); return t}()),
		// 			}},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storSimple1200Series/resource-manager/Microsoft.StorSimple/stable/2016-10-01/examples/ManagersListMetricDefinition.json
func ExampleManagersClient_NewListMetricDefinitionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple1200series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagersClient().NewListMetricDefinitionPager("ResourceGroupForSDKTest", "hAzureSDKOperations", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionList = armstorsimple1200series.MetricDefinitionList{
		// 	Value: []*armstorsimple1200series.MetricDefinition{
		// 		{
		// 			Name: &armstorsimple1200series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Storage Used"),
		// 				Value: to.Ptr("HostUsedStorage"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metricsDefinitions"),
		// 			Dimensions: []*armstorsimple1200series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("hAzureSDKOperations"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple1200series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple1200series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("https://pod01-cis2.sea.storsimple.windowsazure.com/managers/4239154091695873374"),
		// 			Unit: to.Ptr(armstorsimple1200series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple1200series.MetricName{
		// 				LocalizedValue: to.Ptr("Cloud Storage Used"),
		// 				Value: to.Ptr("CloudConsumedStorage"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/metricsDefinitions"),
		// 			Dimensions: []*armstorsimple1200series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Manager"),
		// 					Value: to.Ptr("hAzureSDKOperations"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple1200series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple1200series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("https://pod01-cis2.sea.storsimple.windowsazure.com/managers/4239154091695873374"),
		// 			Unit: to.Ptr(armstorsimple1200series.MetricUnitBytes),
		// 	}},
		// }
	}
}
