--
-- Copyright 2025 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

-- Device specific device curves with 2D dependency (i.e. curve characteristics
-- are dependent on another CPU policy). See go/wattson for more info.

CREATE PERFETTO TABLE _tg5_2d_lut_1 AS
WITH
  data(device, policy, freq_khz, dep_policy, dep_freq, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("Tensor G5", 5, 177000, 7, 266000, 1.02, 14.54, 3.51, 0),
      ("Tensor G5", 5, 177000, 7, 400000, 1.25, 14.47, 3.36, 0),
      ("Tensor G5", 5, 177000, 7, 533000, 1.21, 13.41, 3.37, 0),
      ("Tensor G5", 5, 177000, 7, 800000, 1.39, 15.38, 3.52, 0),
      ("Tensor G5", 5, 177000, 7, 883000, 1.87, 15.52, 3.6, 0),
      ("Tensor G5", 5, 177000, 7, 1036000, 2.13, 16.46, 3.77, 0),
      ("Tensor G5", 5, 177000, 7, 1152000, 2.34, 16.14, 3.96, 0),
      ("Tensor G5", 5, 177000, 7, 1305000, 2.67, 18.64, 4.2, 0),
      ("Tensor G5", 5, 177000, 7, 1420000, 3.01, 19.32, 4.43, 0),
      ("Tensor G5", 5, 177000, 7, 1593000, 3.34, 20.83, 4.63, 0),
      ("Tensor G5", 5, 177000, 7, 1766000, 3.71, 22.46, 4.88, 0),
      ("Tensor G5", 5, 177000, 7, 1920000, 4.19, 22.6, 5.0, 0),
      ("Tensor G5", 5, 177000, 7, 2073000, 4.87, 23.15, 5.01, 0),
      ("Tensor G5", 5, 177000, 7, 2208000, 5.56, 25.4, 5.35, 0),
      ("Tensor G5", 5, 177000, 7, 2342000, 5.79, 26.76, 5.98, 0),
      ("Tensor G5", 5, 177000, 7, 2457000, 6.38, 29.89, 6.52, 0),
      ("Tensor G5", 5, 177000, 7, 2592000, 7.18, 31.03, 6.89, 0),
      ("Tensor G5", 5, 177000, 7, 2707000, 7.91, 33.45, 7.35, 0),
      ("Tensor G5", 5, 177000, 7, 2937000, 9.29, 37.21, 8.4, 0),
      ("Tensor G5", 5, 177000, 7, 3168000, 12.92, 46.4, 11.23, 0),
      ("Tensor G5", 5, 177000, 7, 3398000, 12.78, 59.13, 11.35, 0),
      ("Tensor G5", 5, 177000, 7, 3590000, 12.95, 79.35, 11.26, 0),
      ("Tensor G5", 5, 177000, 7, 3782000, 12.99, 119.28, 11.23, 0),
      ("Tensor G5", 5, 266000, 7, 266000, 1.11, 19.21, 3.41, 0),
      ("Tensor G5", 5, 266000, 7, 400000, 1.57, 17.67, 3.09, 0),
      ("Tensor G5", 5, 266000, 7, 533000, 1.28, 19.32, 3.31, 0),
      ("Tensor G5", 5, 266000, 7, 800000, 1.52, 20.25, 3.43, 0),
      ("Tensor G5", 5, 266000, 7, 883000, 1.96, 20.93, 3.54, 0),
      ("Tensor G5", 5, 266000, 7, 1036000, 2.28, 20.44, 3.68, 0),
      ("Tensor G5", 5, 266000, 7, 1152000, 2.5, 22.79, 3.86, 0),
      ("Tensor G5", 5, 266000, 7, 1305000, 2.76, 24.57, 4.17, 0),
      ("Tensor G5", 5, 266000, 7, 1420000, 3.16, 26.34, 4.35, 0),
      ("Tensor G5", 5, 266000, 7, 1593000, 3.54, 25.53, 4.55, 0),
      ("Tensor G5", 5, 266000, 7, 1766000, 3.94, 28.32, 4.71, 0),
      ("Tensor G5", 5, 266000, 7, 1920000, 4.35, 30.15, 4.95, 0),
      ("Tensor G5", 5, 266000, 7, 2073000, 4.63, 31.43, 5.12, 0),
      ("Tensor G5", 5, 266000, 7, 2208000, 5.25, 32.77, 5.5, 0),
      ("Tensor G5", 5, 266000, 7, 2342000, 5.87, 36.3, 5.95, 0),
      ("Tensor G5", 5, 266000, 7, 2457000, 6.53, 38.2, 6.45, 0),
      ("Tensor G5", 5, 266000, 7, 2592000, 7.25, 41.67, 6.86, 0),
      ("Tensor G5", 5, 266000, 7, 2707000, 8.02, 44.19, 7.31, 0),
      ("Tensor G5", 5, 266000, 7, 2937000, 9.46, 49.05, 8.31, 0),
      ("Tensor G5", 5, 266000, 7, 3168000, 13.0, 61.37, 11.23, 0),
      ("Tensor G5", 5, 266000, 7, 3398000, 13.05, 80.88, 11.28, 0),
      ("Tensor G5", 5, 266000, 7, 3590000, 12.82, 102.88, 11.46, 0),
      ("Tensor G5", 5, 266000, 7, 3782000, 12.98, 160.36, 11.33, 0),
      ("Tensor G5", 5, 400000, 7, 266000, 1.46, 25.15, 3.13, 0),
      ("Tensor G5", 5, 400000, 7, 400000, 1.38, 25.23, 3.19, 0),
      ("Tensor G5", 5, 400000, 7, 533000, 1.18, 25.22, 3.27, 0),
      ("Tensor G5", 5, 400000, 7, 800000, 1.56, 26.05, 3.39, 0),
      ("Tensor G5", 5, 400000, 7, 883000, 1.94, 27.7, 3.53, 0),
      ("Tensor G5", 5, 400000, 7, 1036000, 2.15, 29.7, 3.73, 0),
      ("Tensor G5", 5, 400000, 7, 1152000, 2.35, 30.09, 3.92, 0),
      ("Tensor G5", 5, 400000, 7, 1305000, 2.91, 32.61, 4.0, 0),
      ("Tensor G5", 5, 400000, 7, 1420000, 3.23, 33.57, 4.24, 0),
      ("Tensor G5", 5, 400000, 7, 1593000, 3.52, 36.51, 4.55, 0),
      ("Tensor G5", 5, 400000, 7, 1766000, 3.78, 37.98, 4.8, 0),
      ("Tensor G5", 5, 400000, 7, 1920000, 4.26, 40.01, 4.96, 0),
      ("Tensor G5", 5, 400000, 7, 2073000, 4.54, 41.65, 5.1, 0),
      ("Tensor G5", 5, 400000, 7, 2208000, 5.2, 44.69, 5.49, 0),
      ("Tensor G5", 5, 400000, 7, 2342000, 5.85, 45.53, 5.93, 0),
      ("Tensor G5", 5, 400000, 7, 2457000, 6.58, 51.21, 6.39, 0),
      ("Tensor G5", 5, 400000, 7, 2592000, 7.27, 53.96, 6.79, 0),
      ("Tensor G5", 5, 400000, 7, 2707000, 8.01, 58.64, 7.23, 0),
      ("Tensor G5", 5, 400000, 7, 2937000, 9.46, 65.75, 8.26, 0),
      ("Tensor G5", 5, 400000, 7, 3168000, 12.89, 79.34, 11.22, 0),
      ("Tensor G5", 5, 400000, 7, 3398000, 18.6, 96.14, 8.41, 0),
      ("Tensor G5", 5, 400000, 7, 3590000, 16.6, 130.76, 9.43, 0),
      ("Tensor G5", 5, 400000, 7, 3782000, 13.88, 201.2, 10.78, 0),
      ("Tensor G5", 5, 533000, 7, 266000, 1.87, 31.9, 3.22, 0),
      ("Tensor G5", 5, 533000, 7, 400000, 1.46, 11.08, 3.51, 0),
      ("Tensor G5", 5, 533000, 7, 533000, 1.68, 32.06, 3.21, 0),
      ("Tensor G5", 5, 533000, 7, 800000, 1.37, 10.16, 3.55, 0),
      ("Tensor G5", 5, 533000, 7, 883000, 2.2, 33.31, 3.34, 0),
      ("Tensor G5", 5, 533000, 7, 1036000, 2.29, 35.09, 3.61, 0),
      ("Tensor G5", 5, 533000, 7, 1152000, 2.96, 36.55, 3.56, 0),
      ("Tensor G5", 5, 533000, 7, 1305000, 3.18, 40.11, 3.91, 0),
      ("Tensor G5", 5, 533000, 7, 1420000, 3.51, 12.57, 4.17, 0),
      ("Tensor G5", 5, 533000, 7, 1593000, 3.45, 45.95, 4.57, 0),
      ("Tensor G5", 5, 533000, 7, 1766000, 4.28, 46.61, 4.57, 0),
      ("Tensor G5", 5, 533000, 7, 1920000, 4.57, 49.18, 4.91, 0),
      ("Tensor G5", 5, 533000, 7, 2073000, 4.86, 50.3, 5.09, 0),
      ("Tensor G5", 5, 533000, 7, 2208000, 5.59, 56.63, 5.31, 0),
      ("Tensor G5", 5, 533000, 7, 2342000, 6.2, 59.1, 5.87, 0),
      ("Tensor G5", 5, 533000, 7, 2457000, 6.89, 65.16, 6.35, 0),
      ("Tensor G5", 5, 533000, 7, 2592000, 7.69, 66.62, 6.72, 0),
      ("Tensor G5", 5, 533000, 7, 2707000, 8.33, 21.93, 7.28, 0),
      ("Tensor G5", 5, 533000, 7, 2937000, 9.95, 77.61, 8.16, 0),
      ("Tensor G5", 5, 533000, 7, 3168000, 13.52, 97.08, 11.11, 0),
      ("Tensor G5", 5, 533000, 7, 3398000, 13.65, 131.36, 11.04, 0),
      ("Tensor G5", 5, 533000, 7, 3590000, 13.57, 168.07, 11.03, 0),
      ("Tensor G5", 5, 533000, 7, 3782000, 13.78, 248.18, 10.99, 0),
      ("Tensor G5", 5, 652000, 7, 266000, 2.36, 37.81, 3.23, 0),
      ("Tensor G5", 5, 652000, 7, 400000, 2.35, 37.32, 3.24, 0),
      ("Tensor G5", 5, 652000, 7, 533000, 1.93, 39.06, 3.49, 0),
      ("Tensor G5", 5, 652000, 7, 800000, 2.28, 38.26, 3.27, 0),
      ("Tensor G5", 5, 652000, 7, 883000, 2.81, 37.5, 3.21, 0),
      ("Tensor G5", 5, 652000, 7, 1036000, 2.85, 41.43, 3.6, 0),
      ("Tensor G5", 5, 652000, 7, 1152000, 3.31, 42.46, 3.6, 0),
      ("Tensor G5", 5, 652000, 7, 1305000, 3.2, 45.43, 4.12, 0),
      ("Tensor G5", 5, 652000, 7, 1420000, 3.88, 48.57, 4.24, 0),
      ("Tensor G5", 5, 652000, 7, 1593000, 4.51, 49.59, 4.19, 0),
      ("Tensor G5", 5, 652000, 7, 1766000, 4.63, 53.39, 4.67, 0),
      ("Tensor G5", 5, 652000, 7, 1920000, 5.25, 55.3, 4.76, 0),
      ("Tensor G5", 5, 652000, 7, 2073000, 5.72, 58.48, 4.8, 0),
      ("Tensor G5", 5, 652000, 7, 2208000, 6.3, 64.14, 5.21, 0),
      ("Tensor G5", 5, 652000, 7, 2342000, 7.16, 66.57, 5.57, 0),
      ("Tensor G5", 5, 652000, 7, 2457000, 8.0, 70.42, 5.92, 0),
      ("Tensor G5", 5, 652000, 7, 2592000, 8.8, 78.07, 6.28, 0),
      ("Tensor G5", 5, 652000, 7, 2707000, 9.56, 79.4, 6.94, 0),
      ("Tensor G5", 5, 652000, 7, 2937000, 11.45, 90.3, 7.61, 0),
      ("Tensor G5", 5, 652000, 7, 3168000, 15.24, 108.3, 10.57, 0),
      ("Tensor G5", 5, 652000, 7, 3398000, 14.93, 155.84, 10.94, 0),
      ("Tensor G5", 5, 652000, 7, 3590000, 14.82, 199.68, 11.03, 0),
      ("Tensor G5", 5, 652000, 7, 3782000, 14.92, 318.38, 10.91, 0),
      ("Tensor G5", 5, 729000, 7, 266000, 2.63, 42.01, 3.15, 0),
      ("Tensor G5", 5, 729000, 7, 400000, 2.45, 41.83, 3.38, 0),
      ("Tensor G5", 5, 729000, 7, 533000, 2.22, 11.83, 3.36, 0),
      ("Tensor G5", 5, 729000, 7, 800000, 2.28, 42.86, 3.41, 0),
      ("Tensor G5", 5, 729000, 7, 883000, 2.95, 40.9, 3.13, 0),
      ("Tensor G5", 5, 729000, 7, 1036000, 2.99, 44.52, 3.38, 0),
      ("Tensor G5", 5, 729000, 7, 1152000, 3.24, 44.78, 3.67, 0),
      ("Tensor G5", 5, 729000, 7, 1305000, 3.55, 50.01, 3.85, 0),
      ("Tensor G5", 5, 729000, 7, 1420000, 4.16, 51.51, 4.1, 0),
      ("Tensor G5", 5, 729000, 7, 1593000, 4.7, 54.42, 4.05, 0),
      ("Tensor G5", 5, 729000, 7, 1766000, 5.2, 57.24, 4.29, 0),
      ("Tensor G5", 5, 729000, 7, 1920000, 5.29, 60.56, 4.64, 0),
      ("Tensor G5", 5, 729000, 7, 2073000, 5.74, 61.79, 4.87, 0),
      ("Tensor G5", 5, 729000, 7, 2208000, 6.66, 18.58, 5.11, 0),
      ("Tensor G5", 5, 729000, 7, 2342000, 7.08, 70.71, 5.71, 0),
      ("Tensor G5", 5, 729000, 7, 2457000, 8.06, 77.7, 6.08, 0),
      ("Tensor G5", 5, 729000, 7, 2592000, 9.37, 79.4, 6.0, 0),
      ("Tensor G5", 5, 729000, 7, 2707000, 10.27, 87.67, 6.41, 0),
      ("Tensor G5", 5, 729000, 7, 2937000, 11.04, 98.55, 7.96, 0),
      ("Tensor G5", 5, 729000, 7, 3168000, 15.34, 120.85, 10.63, 0),
      ("Tensor G5", 5, 729000, 7, 3398000, 15.34, 156.54, 10.75, 0),
      ("Tensor G5", 5, 729000, 7, 3590000, 15.55, 205.86, 10.6, 0),
      ("Tensor G5", 5, 729000, 7, 3782000, 15.44, 317.31, 10.67, 0),
      ("Tensor G5", 5, 921000, 7, 266000, 2.95, 52.8, 3.58, 0),
      ("Tensor G5", 5, 921000, 7, 400000, 2.87, 53.57, 3.56, 0),
      ("Tensor G5", 5, 921000, 7, 533000, 2.78, 53.89, 3.56, 0),
      ("Tensor G5", 5, 921000, 7, 800000, 3.41, 53.54, 3.25, 0),
      ("Tensor G5", 5, 921000, 7, 883000, 3.78, 52.99, 3.29, 0),
      ("Tensor G5", 5, 921000, 7, 1036000, 3.94, 51.59, 3.25, 0),
      ("Tensor G5", 5, 921000, 7, 1152000, 3.78, 52.54, 3.54, 0),
      ("Tensor G5", 5, 921000, 7, 1305000, 3.99, 56.51, 3.73, 0),
      ("Tensor G5", 5, 921000, 7, 1420000, 4.87, 58.65, 3.77, 0),
      ("Tensor G5", 5, 921000, 7, 1593000, 5.08, 62.89, 4.18, 0),
      ("Tensor G5", 5, 921000, 7, 1766000, 5.88, 65.67, 4.01, 0),
      ("Tensor G5", 5, 921000, 7, 1920000, 6.16, 67.33, 4.34, 0),
      ("Tensor G5", 5, 921000, 7, 2073000, 6.41, 74.21, 4.55, 0),
      ("Tensor G5", 5, 921000, 7, 2208000, 7.43, 77.51, 4.73, 0),
      ("Tensor G5", 5, 921000, 7, 2342000, 7.69, 85.15, 5.6, 0),
      ("Tensor G5", 5, 921000, 7, 2457000, 8.82, 89.98, 5.71, 0),
      ("Tensor G5", 5, 921000, 7, 2592000, 9.99, 97.28, 5.92, 0),
      ("Tensor G5", 5, 921000, 7, 2707000, 10.45, 100.97, 6.74, 0),
      ("Tensor G5", 5, 921000, 7, 2937000, 11.92, 113.9, 7.78, 0),
      ("Tensor G5", 5, 921000, 7, 3168000, 16.29, 137.18, 10.52, 0),
      ("Tensor G5", 5, 921000, 7, 3398000, 16.27, 187.48, 10.58, 0),
      ("Tensor G5", 5, 921000, 7, 3590000, 16.08, 232.56, 10.73, 0),
      ("Tensor G5", 5, 921000, 7, 3782000, 16.52, 352.5, 10.32, 0),
      ("Tensor G5", 5, 1075000, 7, 266000, 3.54, 61.34, 3.56, 0),
      ("Tensor G5", 5, 1075000, 7, 400000, 3.13, 63.53, 4.03, 0),
      ("Tensor G5", 5, 1075000, 7, 533000, 3.17, 61.23, 3.78, 0),
      ("Tensor G5", 5, 1075000, 7, 800000, 3.55, 62.84, 3.8, 0),
      ("Tensor G5", 5, 1075000, 7, 883000, 3.86, 64.23, 3.7, 0),
      ("Tensor G5", 5, 1075000, 7, 1036000, 1.88, 63.26, 5.77, 0),
      ("Tensor G5", 5, 1075000, 7, 1152000, 4.11, 61.19, 3.7, 0),
      ("Tensor G5", 5, 1075000, 7, 1305000, 4.37, 62.61, 3.6, 0),
      ("Tensor G5", 5, 1075000, 7, 1420000, 5.03, 65.08, 3.75, 0),
      ("Tensor G5", 5, 1075000, 7, 1593000, 5.63, 69.13, 3.85, 0),
      ("Tensor G5", 5, 1075000, 7, 1766000, 5.45, 71.61, 4.37, 0),
      ("Tensor G5", 5, 1075000, 7, 1920000, 6.06, 74.78, 4.82, 0),
      ("Tensor G5", 5, 1075000, 7, 2073000, 6.02, 77.55, 5.04, 0),
      ("Tensor G5", 5, 1075000, 7, 2208000, 7.28, 85.27, 5.19, 0),
      ("Tensor G5", 5, 1075000, 7, 2342000, 8.26, 89.34, 5.23, 0),
      ("Tensor G5", 5, 1075000, 7, 2457000, 8.81, 99.61, 5.96, 0),
      ("Tensor G5", 5, 1075000, 7, 2592000, 10.64, 105.73, 5.71, 0),
      ("Tensor G5", 5, 1075000, 7, 2707000, 11.63, 111.1, 6.09, 0),
      ("Tensor G5", 5, 1075000, 7, 2937000, 12.58, 125.8, 7.71, 0),
      ("Tensor G5", 5, 1075000, 7, 3168000, 17.28, 150.49, 10.16, 0),
      ("Tensor G5", 5, 1075000, 7, 3398000, 17.69, 189.76, 9.77, 0),
      ("Tensor G5", 5, 1075000, 7, 3590000, 17.18, 251.42, 10.23, 0),
      ("Tensor G5", 5, 1075000, 7, 3782000, 17.69, 374.3, 9.8, 0),
      ("Tensor G5", 5, 1267000, 7, 266000, 4.39, 72.07, 3.68, 0),
      ("Tensor G5", 5, 1267000, 7, 400000, 3.84, 71.45, 4.05, 0),
      ("Tensor G5", 5, 1267000, 7, 533000, 4.23, 71.43, 3.86, 0),
      ("Tensor G5", 5, 1267000, 7, 800000, 3.95, 70.95, 3.95, 0),
      ("Tensor G5", 5, 1267000, 7, 883000, 4.39, 72.31, 4.05, 0),
      ("Tensor G5", 5, 1267000, 7, 1036000, 4.98, 70.96, 3.85, 0),
      ("Tensor G5", 5, 1267000, 7, 1152000, 4.73, 73.57, 3.9, 0),
      ("Tensor G5", 5, 1267000, 7, 1305000, 5.3, 70.43, 3.77, 0),
      ("Tensor G5", 5, 1267000, 7, 1420000, 5.58, 73.61, 3.62, 0),
      ("Tensor G5", 5, 1267000, 7, 1593000, 6.15, 72.2, 3.71, 0),
      ("Tensor G5", 5, 1267000, 7, 1766000, 6.03, 79.79, 4.48, 0),
      ("Tensor G5", 5, 1267000, 7, 1920000, 6.85, 81.15, 4.38, 0),
      ("Tensor G5", 5, 1267000, 7, 2073000, 7.57, 86.21, 4.19, 0),
      ("Tensor G5", 5, 1267000, 7, 2208000, 7.82, 91.55, 4.8, 0),
      ("Tensor G5", 5, 1267000, 7, 2342000, 9.42, 99.49, 4.84, 0),
      ("Tensor G5", 5, 1267000, 7, 2457000, 10.36, 103.61, 5.25, 0),
      ("Tensor G5", 5, 1267000, 7, 2592000, 10.86, 113.02, 5.88, 0),
      ("Tensor G5", 5, 1267000, 7, 2707000, 11.47, 120.51, 6.74, 0),
      ("Tensor G5", 5, 1267000, 7, 2937000, 13.87, 138.75, 7.05, 0),
      ("Tensor G5", 5, 1267000, 7, 3168000, 18.18, 162.12, 10.12, 0),
      ("Tensor G5", 5, 1267000, 7, 3398000, 17.69, 218.77, 10.62, 0),
      ("Tensor G5", 5, 1267000, 7, 3590000, 18.43, 272.7, 9.81, 0),
      ("Tensor G5", 5, 1267000, 7, 3782000, 18.37, 420.98, 9.85, 0),
      ("Tensor G5", 5, 1401000, 7, 266000, 5.06, 78.88, 3.71, 0),
      ("Tensor G5", 5, 1401000, 7, 400000, 4.96, 80.57, 3.93, 0),
      ("Tensor G5", 5, 1401000, 7, 533000, 4.56, 78.41, 3.94, 0),
      ("Tensor G5", 5, 1401000, 7, 800000, 4.55, 83.21, 4.03, 0),
      ("Tensor G5", 5, 1401000, 7, 883000, 5.56, 77.32, 3.83, 0),
      ("Tensor G5", 5, 1401000, 7, 1036000, 5.45, 81.45, 4.07, 0),
      ("Tensor G5", 5, 1401000, 7, 1152000, 5.28, 80.46, 4.09, 0),
      ("Tensor G5", 5, 1401000, 7, 1305000, 6.04, 82.52, 3.77, 0),
      ("Tensor G5", 5, 1401000, 7, 1420000, 5.05, 78.68, 4.51, 0),
      ("Tensor G5", 5, 1401000, 7, 1593000, 5.81, 81.65, 4.03, 0),
      ("Tensor G5", 5, 1401000, 7, 1766000, 6.28, 83.08, 4.19, 0),
      ("Tensor G5", 5, 1401000, 7, 1920000, 7.47, 89.32, 4.03, 0),
      ("Tensor G5", 5, 1401000, 7, 2073000, 7.74, 91.49, 4.37, 0),
      ("Tensor G5", 5, 1401000, 7, 2208000, 8.81, 95.82, 4.45, 0),
      ("Tensor G5", 5, 1401000, 7, 2342000, 9.04, 100.46, 5.17, 0),
      ("Tensor G5", 5, 1401000, 7, 2457000, 9.92, 117.59, 5.65, 0),
      ("Tensor G5", 5, 1401000, 7, 2592000, 11.03, 118.37, 5.98, 0),
      ("Tensor G5", 5, 1401000, 7, 2707000, 11.33, 131.34, 6.94, 0),
      ("Tensor G5", 5, 1401000, 7, 2937000, 14.47, 138.99, 7.08, 0),
      ("Tensor G5", 5, 1401000, 7, 3168000, 18.75, 172.92, 9.92, 0),
      ("Tensor G5", 5, 1401000, 7, 3398000, 17.53, 231.81, 10.92, 0),
      ("Tensor G5", 5, 1401000, 7, 3590000, 18.85, 292.08, 9.87, 0),
      ("Tensor G5", 5, 1401000, 7, 3782000, 18.21, 423.86, 10.47, 0),
      ("Tensor G5", 5, 1536000, 7, 266000, 4.88, 91.32, 4.26, 0),
      ("Tensor G5", 5, 1536000, 7, 400000, 4.44, 87.37, 4.8, 0),
      ("Tensor G5", 5, 1536000, 7, 533000, 5.35, 89.62, 4.03, 0),
      ("Tensor G5", 5, 1536000, 7, 800000, 5.66, 85.83, 3.94, 0),
      ("Tensor G5", 5, 1536000, 7, 883000, 6.18, 87.75, 3.96, 0),
      ("Tensor G5", 5, 1536000, 7, 1036000, 5.57, 84.98, 4.63, 0),
      ("Tensor G5", 5, 1536000, 7, 1152000, 6.29, 89.1, 4.16, 0),
      ("Tensor G5", 5, 1536000, 7, 1305000, 5.72, 92.82, 4.41, 0),
      ("Tensor G5", 5, 1536000, 7, 1420000, 6.13, 88.62, 4.23, 0),
      ("Tensor G5", 5, 1536000, 7, 1593000, 6.95, 86.06, 3.92, 0),
      ("Tensor G5", 5, 1536000, 7, 1766000, 7.14, 88.5, 3.88, 0),
      ("Tensor G5", 5, 1536000, 7, 1920000, 7.01, 93.42, 4.43, 0),
      ("Tensor G5", 5, 1536000, 7, 2073000, 7.37, 95.39, 4.57, 0),
      ("Tensor G5", 5, 1536000, 7, 2208000, 8.6, 100.41, 4.93, 0),
      ("Tensor G5", 5, 1536000, 7, 2342000, 9.98, 116.87, 4.9, 0),
      ("Tensor G5", 5, 1536000, 7, 2457000, 10.85, 116.27, 5.29, 0),
      ("Tensor G5", 5, 1536000, 7, 2592000, 11.19, 129.71, 6.14, 0),
      ("Tensor G5", 5, 1536000, 7, 2707000, 12.3, 132.09, 6.7, 0),
      ("Tensor G5", 5, 1536000, 7, 2937000, 13.9, 156.25, 7.59, 0),
      ("Tensor G5", 5, 1536000, 7, 3168000, 19.21, 181.15, 9.93, 0),
      ("Tensor G5", 5, 1536000, 7, 3398000, 18.66, 245.2, 10.61, 0),
      ("Tensor G5", 5, 1536000, 7, 3590000, 19.4, 297.18, 9.88, 0),
      ("Tensor G5", 5, 1536000, 7, 3782000, 18.37, 442.99, 10.87, 0),
      ("Tensor G5", 5, 1670000, 7, 266000, 5.19, 98.62, 4.67, 0),
      ("Tensor G5", 5, 1670000, 7, 400000, 6.0, 98.81, 4.2, 0),
      ("Tensor G5", 5, 1670000, 7, 533000, 5.38, 97.16, 4.46, 0),
      ("Tensor G5", 5, 1670000, 7, 800000, 6.29, 98.72, 4.09, 0),
      ("Tensor G5", 5, 1670000, 7, 883000, 6.86, 91.72, 4.08, 0),
      ("Tensor G5", 5, 1670000, 7, 1036000, 6.83, 98.16, 4.24, 0),
      ("Tensor G5", 5, 1670000, 7, 1152000, 6.52, 97.1, 4.39, 0),
      ("Tensor G5", 5, 1670000, 7, 1305000, 6.51, 98.86, 4.47, 0),
      ("Tensor G5", 5, 1670000, 7, 1420000, 6.85, 98.88, 4.6, 0),
      ("Tensor G5", 5, 1670000, 7, 1593000, 6.78, 97.06, 4.51, 0),
      ("Tensor G5", 5, 1670000, 7, 1766000, 7.08, 96.1, 4.48, 0),
      ("Tensor G5", 5, 1670000, 7, 1920000, 6.98, 100.67, 4.66, 0),
      ("Tensor G5", 5, 1670000, 7, 2073000, 8.26, 97.09, 4.31, 0),
      ("Tensor G5", 5, 1670000, 7, 2208000, 8.7, 114.7, 4.92, 0),
      ("Tensor G5", 5, 1670000, 7, 2342000, 9.9, 113.34, 5.09, 0),
      ("Tensor G5", 5, 1670000, 7, 2457000, 11.37, 130.66, 5.3, 0),
      ("Tensor G5", 5, 1670000, 7, 2592000, 12.05, 132.5, 5.97, 0),
      ("Tensor G5", 5, 1670000, 7, 2707000, 13.3, 147.45, 6.16, 0),
      ("Tensor G5", 5, 1670000, 7, 2937000, 14.48, 152.42, 7.9, 0),
      ("Tensor G5", 5, 1670000, 7, 3168000, 19.03, 196.69, 10.79, 0),
      ("Tensor G5", 5, 1670000, 7, 3398000, 18.81, 260.47, 10.76, 0),
      ("Tensor G5", 5, 1670000, 7, 3590000, 19.28, 324.66, 10.14, 0),
      ("Tensor G5", 5, 1670000, 7, 3782000, 18.92, 462.56, 10.69, 0),
      ("Tensor G5", 5, 1785000, 7, 266000, 5.92, 106.41, 4.54, 0),
      ("Tensor G5", 5, 1785000, 7, 400000, 6.12, 106.39, 4.48, 0),
      ("Tensor G5", 5, 1785000, 7, 533000, 6.48, 104.64, 4.33, 0),
      ("Tensor G5", 5, 1785000, 7, 800000, 5.93, 102.85, 4.65, 0),
      ("Tensor G5", 5, 1785000, 7, 883000, 7.42, 105.6, 4.09, 0),
      ("Tensor G5", 5, 1785000, 7, 1036000, 6.54, 106.22, 4.71, 0),
      ("Tensor G5", 5, 1785000, 7, 1152000, 7.63, 103.97, 4.19, 0),
      ("Tensor G5", 5, 1785000, 7, 1305000, 7.75, 100.33, 4.22, 0),
      ("Tensor G5", 5, 1785000, 7, 1420000, 7.96, 107.52, 4.17, 0),
      ("Tensor G5", 5, 1785000, 7, 1593000, 8.07, 109.33, 4.28, 0),
      ("Tensor G5", 5, 1785000, 7, 1766000, 8.17, 103.42, 4.26, 0),
      ("Tensor G5", 5, 1785000, 7, 1920000, 7.31, 104.43, 4.96, 0),
      ("Tensor G5", 5, 1785000, 7, 2073000, 7.9, 106.62, 4.78, 0),
      ("Tensor G5", 5, 1785000, 7, 2208000, 9.48, 110.92, 4.61, 0),
      ("Tensor G5", 5, 1785000, 7, 2342000, 10.0, 122.33, 5.4, 0),
      ("Tensor G5", 5, 1785000, 7, 2457000, 11.04, 125.94, 5.63, 0),
      ("Tensor G5", 5, 1785000, 7, 2592000, 12.7, 140.06, 5.62, 0),
      ("Tensor G5", 5, 1785000, 7, 2707000, 12.78, 145.79, 6.47, 0),
      ("Tensor G5", 5, 1785000, 7, 2937000, 15.76, 162.81, 6.91, 0),
      ("Tensor G5", 5, 1785000, 7, 3168000, 18.91, 196.99, 11.04, 0),
      ("Tensor G5", 5, 1785000, 7, 3398000, 20.29, 264.14, 9.85, 0),
      ("Tensor G5", 5, 1785000, 7, 3590000, 19.44, 329.73, 10.79, 0),
      ("Tensor G5", 5, 1785000, 7, 3782000, 19.91, 473.6, 10.07, 0),
      ("Tensor G5", 5, 1862000, 7, 266000, 6.25, 114.94, 5.01, 0),
      ("Tensor G5", 5, 1862000, 7, 400000, 6.36, 117.39, 4.99, 0),
      ("Tensor G5", 5, 1862000, 7, 533000, 6.81, 110.45, 4.85, 0),
      ("Tensor G5", 5, 1862000, 7, 800000, 7.22, 112.71, 4.67, 0),
      ("Tensor G5", 5, 1862000, 7, 883000, 7.95, 116.41, 4.53, 0),
      ("Tensor G5", 5, 1862000, 7, 1036000, 7.5, 118.48, 4.87, 0),
      ("Tensor G5", 5, 1862000, 7, 1152000, 8.17, 109.96, 4.55, 0),
      ("Tensor G5", 5, 1862000, 7, 1305000, 8.21, 115.7, 4.72, 0),
      ("Tensor G5", 5, 1862000, 7, 1420000, 7.77, 111.2, 4.89, 0),
      ("Tensor G5", 5, 1862000, 7, 1593000, 8.65, 116.4, 4.64, 0),
      ("Tensor G5", 5, 1862000, 7, 1766000, 8.05, 114.02, 5.03, 0),
      ("Tensor G5", 5, 1862000, 7, 1920000, 9.01, 115.93, 4.61, 0),
      ("Tensor G5", 5, 1862000, 7, 2073000, 9.27, 111.13, 4.61, 0),
      ("Tensor G5", 5, 1862000, 7, 2208000, 9.58, 118.08, 4.68, 0),
      ("Tensor G5", 5, 1862000, 7, 2342000, 10.74, 123.33, 4.9, 0),
      ("Tensor G5", 5, 1862000, 7, 2457000, 10.9, 136.92, 5.84, 0),
      ("Tensor G5", 5, 1862000, 7, 2592000, 11.69, 143.73, 6.31, 0),
      ("Tensor G5", 5, 1862000, 7, 2707000, 12.63, 158.23, 6.79, 0),
      ("Tensor G5", 5, 1862000, 7, 2937000, 15.12, 174.19, 7.49, 0),
      ("Tensor G5", 5, 1862000, 7, 3168000, 20.09, 216.69, 10.47, 0),
      ("Tensor G5", 5, 1862000, 7, 3398000, 20.65, 258.47, 9.91, 0),
      ("Tensor G5", 5, 1862000, 7, 3590000, 19.83, 334.54, 10.74, 0),
      ("Tensor G5", 5, 1862000, 7, 3782000, 20.22, 487.67, 10.1, 0),
      ("Tensor G5", 5, 1939000, 7, 266000, 7.27, 125.19, 5.03, 0),
      ("Tensor G5", 5, 1939000, 7, 400000, 6.32, 122.17, 5.79, 0),
      ("Tensor G5", 5, 1939000, 7, 533000, 7.34, 123.35, 4.98, 0),
      ("Tensor G5", 5, 1939000, 7, 800000, 6.88, 119.42, 5.3, 0),
      ("Tensor G5", 5, 1939000, 7, 883000, 8.36, 127.35, 4.84, 0),
      ("Tensor G5", 5, 1939000, 7, 1036000, 8.55, 120.02, 4.81, 0),
      ("Tensor G5", 5, 1939000, 7, 1152000, 7.9, 131.32, 5.23, 0),
      ("Tensor G5", 5, 1939000, 7, 1305000, 8.76, 119.77, 4.96, 0),
      ("Tensor G5", 5, 1939000, 7, 1420000, 8.46, 124.8, 5.09, 0),
      ("Tensor G5", 5, 1939000, 7, 1593000, 8.41, 123.55, 5.27, 0),
      ("Tensor G5", 5, 1939000, 7, 1766000, 8.64, 123.78, 5.34, 0),
      ("Tensor G5", 5, 1939000, 7, 1920000, 9.85, 122.17, 4.69, 0),
      ("Tensor G5", 5, 1939000, 7, 2073000, 8.68, 128.51, 5.62, 0),
      ("Tensor G5", 5, 1939000, 7, 2208000, 9.34, 121.66, 5.18, 0),
      ("Tensor G5", 5, 1939000, 7, 2342000, 10.73, 128.96, 5.13, 0),
      ("Tensor G5", 5, 1939000, 7, 2457000, 10.88, 138.85, 5.98, 0),
      ("Tensor G5", 5, 1939000, 7, 2592000, 13.04, 147.65, 5.72, 0),
      ("Tensor G5", 5, 1939000, 7, 2707000, 14.2, 152.24, 6.0, 0),
      ("Tensor G5", 5, 1939000, 7, 2937000, 15.17, 177.51, 7.77, 0),
      ("Tensor G5", 5, 1939000, 7, 3168000, 20.83, 202.25, 9.99, 0),
      ("Tensor G5", 5, 1939000, 7, 3398000, 19.59, 277.19, 10.7, 0),
      ("Tensor G5", 5, 1939000, 7, 3590000, 20.98, 343.01, 9.96, 0),
      ("Tensor G5", 5, 1939000, 7, 3782000, 18.71, 502.82, 11.53, 0),
      ("Tensor G5", 5, 2092000, 7, 266000, 7.18, 141.09, 6.46, 0),
      ("Tensor G5", 5, 2092000, 7, 400000, 8.15, 143.52, 5.78, 0),
      ("Tensor G5", 5, 2092000, 7, 533000, 7.46, 143.76, 6.07, 0),
      ("Tensor G5", 5, 2092000, 7, 800000, 8.55, 31.33, 5.65, 0),
      ("Tensor G5", 5, 2092000, 7, 883000, 8.86, 141.73, 5.7, 0),
      ("Tensor G5", 5, 2092000, 7, 1036000, 8.95, 142.92, 5.78, 0),
      ("Tensor G5", 5, 2092000, 7, 1152000, 9.86, 29.11, 5.41, 0),
      ("Tensor G5", 5, 2092000, 7, 1305000, 9.67, 147.95, 5.78, 0),
      ("Tensor G5", 5, 2092000, 7, 1420000, 10.26, 136.27, 5.37, 0),
      ("Tensor G5", 5, 2092000, 7, 1593000, 9.67, 147.72, 5.94, 0),
      ("Tensor G5", 5, 2092000, 7, 1766000, 10.79, 135.9, 5.47, 0),
      ("Tensor G5", 5, 2092000, 7, 1920000, 10.4, 145.94, 5.76, 0),
      ("Tensor G5", 5, 2092000, 7, 2073000, 11.31, 136.0, 5.31, 0),
      ("Tensor G5", 5, 2092000, 7, 2208000, 10.58, 145.88, 6.02, 0),
      ("Tensor G5", 5, 2092000, 7, 2342000, 11.09, 138.85, 5.86, 0),
      ("Tensor G5", 5, 2092000, 7, 2457000, 12.31, 146.5, 5.42, 0),
      ("Tensor G5", 5, 2092000, 7, 2592000, 13.58, 31.28, 5.61, 0),
      ("Tensor G5", 5, 2092000, 7, 2707000, 12.7, 171.16, 7.42, 0),
      ("Tensor G5", 5, 2092000, 7, 2937000, 15.5, 177.01, 7.66, 0),
      ("Tensor G5", 5, 2092000, 7, 3168000, 20.31, 50.32, 10.4, 0),
      ("Tensor G5", 5, 2092000, 7, 3398000, 21.18, 294.51, 10.15, 0),
      ("Tensor G5", 5, 2092000, 7, 3590000, 21.48, 362.26, 10.05, 0),
      ("Tensor G5", 5, 2092000, 7, 3782000, 20.04, 526.35, 10.61, 0),
      ("Tensor G5", 5, 2188000, 7, 266000, 8.43, 154.26, 6.28, 0),
      ("Tensor G5", 5, 2188000, 7, 400000, 8.31, 152.85, 6.32, 0),
      ("Tensor G5", 5, 2188000, 7, 533000, 8.4, 161.76, 6.13, 0),
      ("Tensor G5", 5, 2188000, 7, 800000, 8.54, 148.4, 6.12, 0),
      ("Tensor G5", 5, 2188000, 7, 883000, 9.19, 162.07, 6.16, 0),
      ("Tensor G5", 5, 2188000, 7, 1036000, 10.32, 148.71, 5.8, 0),
      ("Tensor G5", 5, 2188000, 7, 1152000, 10.61, 158.24, 5.68, 0),
      ("Tensor G5", 5, 2188000, 7, 1305000, 11.01, 149.94, 5.6, 0),
      ("Tensor G5", 5, 2188000, 7, 1420000, 11.21, 161.33, 5.6, 0),
      ("Tensor G5", 5, 2188000, 7, 1593000, 10.54, 152.11, 5.92, 0),
      ("Tensor G5", 5, 2188000, 7, 1766000, 10.36, 157.49, 6.25, 0),
      ("Tensor G5", 5, 2188000, 7, 1920000, 11.58, 147.52, 5.82, 0),
      ("Tensor G5", 5, 2188000, 7, 2073000, 12.15, 152.81, 5.52, 0),
      ("Tensor G5", 5, 2188000, 7, 2208000, 11.24, 152.77, 6.13, 0),
      ("Tensor G5", 5, 2188000, 7, 2342000, 12.1, 162.25, 5.79, 0),
      ("Tensor G5", 5, 2188000, 7, 2457000, 11.67, 151.0, 6.1, 0),
      ("Tensor G5", 5, 2188000, 7, 2592000, 13.16, 161.36, 5.83, 0),
      ("Tensor G5", 5, 2188000, 7, 2707000, 14.41, 161.55, 6.45, 0),
      ("Tensor G5", 5, 2188000, 7, 2937000, 16.48, 198.79, 7.5, 0),
      ("Tensor G5", 5, 2188000, 7, 3168000, 22.04, 217.71, 9.89, 0),
      ("Tensor G5", 5, 2188000, 7, 3398000, 22.02, 299.47, 9.83, 0),
      ("Tensor G5", 5, 2188000, 7, 3590000, 21.63, 370.68, 10.1, 0),
      ("Tensor G5", 5, 2188000, 7, 3782000, 22.05, 535.97, 9.84, 0),
      ("Tensor G5", 5, 2284000, 7, 266000, 8.85, 164.03, 6.68, 0),
      ("Tensor G5", 5, 2284000, 7, 400000, 8.89, 171.56, 6.72, 0),
      ("Tensor G5", 5, 2284000, 7, 533000, 8.84, 173.48, 6.71, 0),
      ("Tensor G5", 5, 2284000, 7, 800000, 10.19, 173.16, 6.13, 0),
      ("Tensor G5", 5, 2284000, 7, 883000, 10.9, 166.32, 5.98, 0),
      ("Tensor G5", 5, 2284000, 7, 1036000, 11.25, 174.86, 5.97, 0),
      ("Tensor G5", 5, 2284000, 7, 1152000, 11.29, 166.86, 6.16, 0),
      ("Tensor G5", 5, 2284000, 7, 1305000, 11.65, 171.18, 6.07, 0),
      ("Tensor G5", 5, 2284000, 7, 1420000, 9.65, 157.2, 8.18, 0),
      ("Tensor G5", 5, 2284000, 7, 1593000, 11.62, 170.04, 6.19, 0),
      ("Tensor G5", 5, 2284000, 7, 1766000, 11.6, 157.42, 6.31, 0),
      ("Tensor G5", 5, 2284000, 7, 1920000, 11.97, 165.07, 6.19, 0),
      ("Tensor G5", 5, 2284000, 7, 2073000, 13.32, 161.12, 5.61, 0),
      ("Tensor G5", 5, 2284000, 7, 2208000, 13.08, 167.74, 6.01, 0),
      ("Tensor G5", 5, 2284000, 7, 2342000, 11.97, 167.47, 6.72, 0),
      ("Tensor G5", 5, 2284000, 7, 2457000, 13.48, 171.67, 5.94, 0),
      ("Tensor G5", 5, 2284000, 7, 2592000, 13.39, 167.78, 6.18, 0),
      ("Tensor G5", 5, 2284000, 7, 2707000, 12.88, 179.52, 7.71, 0),
      ("Tensor G5", 5, 2284000, 7, 2937000, 15.77, 192.38, 7.85, 0),
      ("Tensor G5", 5, 2284000, 7, 3168000, 20.6, 249.62, 10.99, 0),
      ("Tensor G5", 5, 2284000, 7, 3398000, 20.03, 310.0, 11.49, 0),
      ("Tensor G5", 5, 2284000, 7, 3590000, 21.36, 396.97, 10.61, 0),
      ("Tensor G5", 5, 2284000, 7, 3782000, 22.28, 552.09, 9.94, 0),
      ("Tensor G5", 5, 2400000, 7, 266000, 9.83, 180.06, 6.82, 0),
      ("Tensor G5", 5, 2400000, 7, 400000, 10.94, 171.69, 6.42, 0),
      ("Tensor G5", 5, 2400000, 7, 533000, 9.88, 179.15, 6.85, 0),
      ("Tensor G5", 5, 2400000, 7, 800000, 9.96, 183.46, 6.87, 0),
      ("Tensor G5", 5, 2400000, 7, 883000, 10.45, 180.68, 7.11, 0),
      ("Tensor G5", 5, 2400000, 7, 1036000, 12.24, 177.33, 6.25, 0),
      ("Tensor G5", 5, 2400000, 7, 1152000, 11.46, 184.57, 6.7, 0),
      ("Tensor G5", 5, 2400000, 7, 1305000, 11.34, 180.3, 6.98, 0),
      ("Tensor G5", 5, 2400000, 7, 1420000, 12.53, 176.5, 6.47, 0),
      ("Tensor G5", 5, 2400000, 7, 1593000, 11.78, 173.09, 7.02, 0),
      ("Tensor G5", 5, 2400000, 7, 1766000, 12.27, 188.64, 6.9, 0),
      ("Tensor G5", 5, 2400000, 7, 1920000, 13.67, 179.83, 6.26, 0),
      ("Tensor G5", 5, 2400000, 7, 2073000, 12.49, 181.49, 7.04, 0),
      ("Tensor G5", 5, 2400000, 7, 2208000, 13.58, 180.93, 6.75, 0),
      ("Tensor G5", 5, 2400000, 7, 2342000, 14.11, 184.01, 6.41, 0),
      ("Tensor G5", 5, 2400000, 7, 2457000, 13.34, 172.07, 6.99, 0),
      ("Tensor G5", 5, 2400000, 7, 2592000, 12.59, 189.67, 7.82, 0),
      ("Tensor G5", 5, 2400000, 7, 2707000, 13.63, 174.29, 7.36, 0),
      ("Tensor G5", 5, 2400000, 7, 2937000, 16.45, 208.2, 7.65, 0),
      ("Tensor G5", 5, 2400000, 7, 3168000, 20.93, 242.56, 11.0, 0),
      ("Tensor G5", 5, 2400000, 7, 3398000, 21.29, 318.53, 10.66, 0),
      ("Tensor G5", 5, 2400000, 7, 3590000, 21.77, 396.53, 10.37, 0),
      ("Tensor G5", 5, 2400000, 7, 3782000, 22.91, 570.58, 9.64, 0),
      ("Tensor G5", 5, 2534000, 7, 266000, 12.7, 191.57, 7.25, 0),
      ("Tensor G5", 5, 2534000, 7, 400000, 13.27, 211.99, 6.63, 0),
      ("Tensor G5", 5, 2534000, 7, 533000, 12.2, 201.61, 7.47, 0),
      ("Tensor G5", 5, 2534000, 7, 800000, 11.73, 215.66, 7.82, 0),
      ("Tensor G5", 5, 2534000, 7, 883000, 12.69, 212.61, 7.75, 0),
      ("Tensor G5", 5, 2534000, 7, 1036000, 13.82, 211.11, 7.47, 0),
      ("Tensor G5", 5, 2534000, 7, 1152000, 14.85, 198.97, 6.82, 0),
      ("Tensor G5", 5, 2534000, 7, 1305000, 14.31, 201.45, 7.39, 0),
      ("Tensor G5", 5, 2534000, 7, 1420000, 14.67, 202.75, 7.26, 0),
      ("Tensor G5", 5, 2534000, 7, 1593000, 13.98, 212.66, 7.73, 0),
      ("Tensor G5", 5, 2534000, 7, 1766000, 14.27, 202.88, 7.7, 0),
      ("Tensor G5", 5, 2534000, 7, 1920000, 15.73, 208.43, 7.12, 0),
      ("Tensor G5", 5, 2534000, 7, 2073000, 15.71, 197.24, 7.46, 0),
      ("Tensor G5", 5, 2534000, 7, 2208000, 14.88, 216.52, 7.84, 0),
      ("Tensor G5", 5, 2534000, 7, 2342000, 15.36, 206.42, 7.64, 0),
      ("Tensor G5", 5, 2534000, 7, 2457000, 14.75, 218.4, 8.36, 0),
      ("Tensor G5", 5, 2534000, 7, 2592000, 16.01, 201.88, 7.58, 0),
      ("Tensor G5", 5, 2534000, 7, 2707000, 17.0, 212.26, 7.17, 0),
      ("Tensor G5", 5, 2534000, 7, 2937000, 16.05, 202.96, 8.41, 0),
      ("Tensor G5", 5, 2534000, 7, 3168000, 22.66, 257.8, 10.19, 0),
      ("Tensor G5", 5, 2534000, 7, 3398000, 20.99, 319.68, 11.23, 0),
      ("Tensor G5", 5, 2534000, 7, 3590000, 22.07, 407.71, 10.67, 0),
      ("Tensor G5", 5, 2534000, 7, 3782000, 22.38, 586.28, 10.5, 0),
      ("Tensor G5", 5, 2688000, 7, 266000, 13.26, 237.95, 8.95, 0),
      ("Tensor G5", 5, 2688000, 7, 400000, 13.05, 228.83, 9.13, 0),
      ("Tensor G5", 5, 2688000, 7, 533000, 13.82, 240.99, 9.1, 0),
      ("Tensor G5", 5, 2688000, 7, 800000, 13.73, 235.14, 8.82, 0),
      ("Tensor G5", 5, 2688000, 7, 883000, 14.22, 229.65, 9.12, 0),
      ("Tensor G5", 5, 2688000, 7, 1036000, 14.92, 228.96, 8.97, 0),
      ("Tensor G5", 5, 2688000, 7, 1152000, 15.58, 242.21, 8.69, 0),
      ("Tensor G5", 5, 2688000, 7, 1305000, 15.87, 233.94, 8.43, 0),
      ("Tensor G5", 5, 2688000, 7, 1420000, 15.58, 244.44, 8.85, 0),
      ("Tensor G5", 5, 2688000, 7, 1593000, 14.95, 236.7, 9.72, 0),
      ("Tensor G5", 5, 2688000, 7, 1766000, 17.31, 242.86, 8.48, 0),
      ("Tensor G5", 5, 2688000, 7, 1920000, 16.54, 234.67, 8.89, 0),
      ("Tensor G5", 5, 2688000, 7, 2073000, 17.92, 230.6, 8.37, 0),
      ("Tensor G5", 5, 2688000, 7, 2208000, 16.82, 226.97, 8.89, 0),
      ("Tensor G5", 5, 2688000, 7, 2342000, 17.38, 234.81, 8.76, 0),
      ("Tensor G5", 5, 2688000, 7, 2457000, 16.85, 226.11, 9.12, 0),
      ("Tensor G5", 5, 2688000, 7, 2592000, 18.51, 243.54, 8.67, 0),
      ("Tensor G5", 5, 2688000, 7, 2707000, 17.82, 234.49, 8.91, 0),
      ("Tensor G5", 5, 2688000, 7, 2937000, 19.73, 232.22, 8.2, 0),
      ("Tensor G5", 5, 2688000, 7, 3168000, 21.81, 260.09, 11.16, 0),
      ("Tensor G5", 5, 2688000, 7, 3398000, 20.97, 354.38, 12.05, 0),
      ("Tensor G5", 5, 2688000, 7, 3590000, 21.36, 418.1, 11.31, 0),
      ("Tensor G5", 5, 2688000, 7, 3782000, 21.7, 617.21, 11.36, 0),
      ("Tensor G5", 5, 2841000, 7, 266000, 18.08, 280.49, 11.11, 0),
      ("Tensor G5", 5, 2841000, 7, 400000, 16.48, 298.51, 12.02, 0),
      ("Tensor G5", 5, 2841000, 7, 533000, 16.27, 285.92, 12.01, 0),
      ("Tensor G5", 5, 2841000, 7, 800000, 17.44, 287.98, 11.39, 0),
      ("Tensor G5", 5, 2841000, 7, 883000, 19.74, 270.47, 10.98, 0),
      ("Tensor G5", 5, 2841000, 7, 1036000, 20.11, 273.57, 10.88, 0),
      ("Tensor G5", 5, 2841000, 7, 1152000, 19.05, 285.28, 11.5, 0),
      ("Tensor G5", 5, 2841000, 7, 1305000, 18.92, 291.44, 11.99, 0),
      ("Tensor G5", 5, 2841000, 7, 1420000, 19.35, 284.92, 11.78, 0),
      ("Tensor G5", 5, 2841000, 7, 1593000, 19.81, 289.05, 11.66, 0),
      ("Tensor G5", 5, 2841000, 7, 1766000, 20.33, 283.03, 11.5, 0),
      ("Tensor G5", 5, 2841000, 7, 1920000, 21.29, 279.53, 11.14, 0),
      ("Tensor G5", 5, 2841000, 7, 2073000, 20.66, 287.03, 11.72, 0),
      ("Tensor G5", 5, 2841000, 7, 2208000, 21.52, 294.05, 11.48, 0),
      ("Tensor G5", 5, 2841000, 7, 2342000, 20.89, 282.0, 12.44, 0),
      ("Tensor G5", 5, 2841000, 7, 2457000, 21.42, 293.84, 12.12, 0),
      ("Tensor G5", 5, 2841000, 7, 2592000, 22.21, 273.28, 11.64, 0),
      ("Tensor G5", 5, 2841000, 7, 2707000, 23.54, 280.57, 11.03, 0),
      ("Tensor G5", 5, 2841000, 7, 2937000, 23.11, 275.81, 11.42, 0),
      ("Tensor G5", 5, 2841000, 7, 3168000, 25.4, 285.75, 10.48, 0),
      ("Tensor G5", 5, 2841000, 7, 3398000, 25.17, 342.44, 10.67, 0),
      ("Tensor G5", 5, 2841000, 7, 3590000, 24.89, 436.76, 10.8, 0),
      ("Tensor G5", 5, 2841000, 7, 3782000, 25.3, 601.26, 10.52, 0),
      ("Tensor G5", 5, 2937000, 7, 266000, 21.01, 326.61, 13.39, 0),
      ("Tensor G5", 5, 2937000, 7, 400000, 19.79, 319.62, 14.18, 0),
      ("Tensor G5", 5, 2937000, 7, 533000, 20.93, 326.91, 13.65, 0),
      ("Tensor G5", 5, 2937000, 7, 800000, 20.53, 325.58, 13.77, 0),
      ("Tensor G5", 5, 2937000, 7, 883000, 20.96, 330.68, 14.64, 0),
      ("Tensor G5", 5, 2937000, 7, 1036000, 23.33, 315.3, 13.56, 0),
      ("Tensor G5", 5, 2937000, 7, 1152000, 21.59, 334.06, 14.34, 0),
      ("Tensor G5", 5, 2937000, 7, 1305000, 22.31, 309.45, 14.66, 0),
      ("Tensor G5", 5, 2937000, 7, 1420000, 21.83, 334.63, 14.75, 0),
      ("Tensor G5", 5, 2937000, 7, 1593000, 25.02, 316.91, 13.23, 0),
      ("Tensor G5", 5, 2937000, 7, 1766000, 22.57, 336.65, 15.01, 0),
      ("Tensor G5", 5, 2937000, 7, 1920000, 24.29, 315.73, 13.83, 0),
      ("Tensor G5", 5, 2937000, 7, 2073000, 24.42, 332.05, 14.04, 0),
      ("Tensor G5", 5, 2937000, 7, 2208000, 26.79, 315.44, 13.04, 0),
      ("Tensor G5", 5, 2937000, 7, 2342000, 26.4, 330.0, 13.46, 0),
      ("Tensor G5", 5, 2937000, 7, 2457000, 25.08, 321.49, 14.43, 0),
      ("Tensor G5", 5, 2937000, 7, 2592000, 25.54, 332.99, 14.44, 0),
      ("Tensor G5", 5, 2937000, 7, 2707000, 26.36, 322.76, 13.67, 0),
      ("Tensor G5", 5, 2937000, 7, 2937000, 26.28, 329.3, 14.17, 0),
      ("Tensor G5", 5, 2937000, 7, 3168000, 28.35, 319.87, 13.53, 0),
      ("Tensor G5", 5, 2937000, 7, 3398000, 26.52, 335.76, 14.82, 0),
      ("Tensor G5", 5, 2937000, 7, 3590000, 26.25, 418.35, 14.87, 0),
      ("Tensor G5", 5, 2937000, 7, 3782000, 28.68, 605.19, 13.36, 0),
      ("Tensor G5", 5, 3052000, 7, 266000, 24.53, 348.05, 17.64, 0),
      ("Tensor G5", 5, 3052000, 7, 400000, 23.87, 373.56, 17.85, 0),
      ("Tensor G5", 5, 3052000, 7, 533000, 25.15, 348.99, 17.25, 0),
      ("Tensor G5", 5, 3052000, 7, 800000, 25.56, 369.14, 16.83, 0),
      ("Tensor G5", 5, 3052000, 7, 883000, 27.72, 354.79, 16.36, 0),
      ("Tensor G5", 5, 3052000, 7, 1036000, 26.64, 372.01, 17.36, 0),
      ("Tensor G5", 5, 3052000, 7, 1152000, 28.94, 354.06, 16.06, 0),
      ("Tensor G5", 5, 3052000, 7, 1305000, 28.35, 354.8, 16.7, 0),
      ("Tensor G5", 5, 3052000, 7, 1420000, 27.29, 355.77, 17.31, 0),
      ("Tensor G5", 5, 3052000, 7, 1593000, 29.01, 360.68, 16.87, 0),
      ("Tensor G5", 5, 3052000, 7, 1766000, 28.38, 358.26, 17.13, 0),
      ("Tensor G5", 5, 3052000, 7, 1920000, 27.42, 371.84, 18.39, 0),
      ("Tensor G5", 5, 3052000, 7, 2073000, 27.93, 362.34, 18.17, 0),
      ("Tensor G5", 5, 3052000, 7, 2208000, 30.22, 361.79, 17.49, 0),
      ("Tensor G5", 5, 3052000, 7, 2342000, 30.1, 361.1, 17.73, 0),
      ("Tensor G5", 5, 3052000, 7, 2457000, 30.41, 371.25, 16.97, 0),
      ("Tensor G5", 5, 3052000, 7, 2592000, 29.14, 356.91, 18.21, 0),
      ("Tensor G5", 5, 3052000, 7, 2707000, 32.36, 366.08, 16.55, 0),
      ("Tensor G5", 5, 3052000, 7, 2937000, 31.08, 358.27, 17.42, 0),
      ("Tensor G5", 5, 3052000, 7, 3168000, 33.19, 370.28, 16.84, 0),
      ("Tensor G5", 5, 3052000, 7, 3398000, 32.38, 361.12, 17.47, 0),
      ("Tensor G5", 5, 3052000, 7, 3590000, 32.28, 415.4, 17.69, 0),
      ("Tensor G5", 5, 3052000, 7, 3782000, 33.41, 596.23, 16.73, 0)) AS _values
  )
SELECT
  *
FROM data;
