# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor.aio import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementGuestDiagnosticsSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_create_or_update(self, resource_group):
        response = await self.client.guest_diagnostics_settings.create_or_update(
            resource_group_name=resource_group.name,
            diagnostic_settings_name="str",
            diagnostic_settings={
                "location": "str",
                "dataSources": [
                    {
                        "configuration": {
                            "eventLogs": [{"logName": "str", "filter": "str"}],
                            "perfCounters": [{"name": "str", "samplingPeriod": "str", "instance": "str"}],
                            "providers": [{"events": [{"id": 0, "name": "str", "filter": "str"}], "id": "str"}],
                        },
                        "kind": "str",
                        "sinks": [{"kind": "str"}],
                    }
                ],
                "id": "str",
                "name": "str",
                "osType": "str",
                "proxySetting": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_get(self, resource_group):
        response = await self.client.guest_diagnostics_settings.get(
            resource_group_name=resource_group.name,
            diagnostic_settings_name="str",
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_update(self, resource_group):
        response = await self.client.guest_diagnostics_settings.update(
            resource_group_name=resource_group.name,
            diagnostic_settings_name="str",
            parameters={
                "dataSources": [
                    {
                        "configuration": {
                            "eventLogs": [{"logName": "str", "filter": "str"}],
                            "perfCounters": [{"name": "str", "samplingPeriod": "str", "instance": "str"}],
                            "providers": [{"events": [{"id": 0, "name": "str", "filter": "str"}], "id": "str"}],
                        },
                        "kind": "str",
                        "sinks": [{"kind": "str"}],
                    }
                ],
                "osType": "str",
                "proxySetting": "str",
                "tags": {"str": "str"},
            },
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_delete(self, resource_group):
        response = await self.client.guest_diagnostics_settings.delete(
            resource_group_name=resource_group.name,
            diagnostic_settings_name="str",
            api_version="2018-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_list(self, resource_group):
        response = self.client.guest_diagnostics_settings.list(
            api_version="2018-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_guest_diagnostics_settings_list_by_resource_group(self, resource_group):
        response = self.client.guest_diagnostics_settings.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2018-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
