% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-new.R
\name{vector-construction}
\alias{vector-construction}
\alias{lgl}
\alias{int}
\alias{dbl}
\alias{cpl}
\alias{chr}
\alias{bytes}
\title{Create vectors}
\usage{
lgl(...)

int(...)

dbl(...)

cpl(...)

chr(...)

bytes(...)
}
\arguments{
\item{...}{Components of the new vector. Bare lists and explicitly
spliced lists are spliced.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

The atomic vector constructors are equivalent to \code{\link[=c]{c()}} but:
\itemize{
\item They allow you to be more explicit about the output
type. Implicit coercions (e.g. from integer to logical) follow
the rules described in \link{vector-coercion}.
\item They use \link[=dyn-dots]{dynamic dots}.
}
}
\section{Life cycle}{

\itemize{
\item All the abbreviated constructors such as \code{lgl()} will probably be
moved to the vctrs package at some point. This is why they are
marked as questioning.
\item Automatic splicing is soft-deprecated and will trigger a warning
in a future version. Please splice explicitly with \verb{!!!}.
}
}

\examples{
# These constructors are like a typed version of c():
c(TRUE, FALSE)
lgl(TRUE, FALSE)

# They follow a restricted set of coercion rules:
int(TRUE, FALSE, 20)

# Lists can be spliced:
dbl(10, !!! list(1, 2L), TRUE)


# They splice names a bit differently than c(). The latter
# automatically composes inner and outer names:
c(a = c(A = 10), b = c(B = 20, C = 30))

# On the other hand, rlang's constructors use the inner names and issue a
# warning to inform the user that the outer names are ignored:
dbl(a = c(A = 10), b = c(B = 20, C = 30))
dbl(a = c(1, 2))

# As an exception, it is allowed to provide an outer name when the
# inner vector is an unnamed scalar atomic:
dbl(a = 1)

# Spliced lists behave the same way:
dbl(!!! list(a = 1))
dbl(!!! list(a = c(A = 1)))

# bytes() accepts integerish inputs
bytes(1:10)
bytes(0x01, 0xff, c(0x03, 0x05), list(10, 20, 30L))
}
