% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{Read10X_Image}
\alias{Read10X_Image}
\title{Load a 10X Genomics Visium Image}
\usage{
Read10X_Image(
  image.dir,
  image.name = "tissue_lowres_image.png",
  assay = "Spatial",
  slice = "slice1",
  filter.matrix = TRUE,
  image.type = "VisiumV2"
)
}
\arguments{
\item{image.dir}{Path to directory with 10X Genomics visium image data;
should include files \code{tissue_lowres_image.png},
\code{scalefactors_json.json} and \code{tissue_positions_list.csv}}

\item{image.name}{PNG file to read in}

\item{assay}{Name of associated assay}

\item{slice}{Name for the image, used to populate the instance's key}

\item{filter.matrix}{Filter spot/feature matrix to only include spots that
have been determined to be over tissue}

\item{image.type}{Image type to return, one of: "VisiumV1" or "VisiumV2"}
}
\value{
A \code{\link{VisiumV2}} object
}
\description{
Load a 10X Genomics Visium Image
}
\seealso{
\code{\link{VisiumV2}} \code{\link{Load10X_Spatial}}
}
\concept{preprocessing}
