% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{lazy_save}
\alias{lazy_save}
\alias{lazy_load}
\title{Save objects to files and lazy-load them}
\usage{
lazy_save(list = NULL, path = "./", method = "auto", envir = parent.frame())

lazy_load(path = "./", method = "auto", envir = parent.frame())
}
\arguments{
\item{list}{A character vector of object names. This list will be written to
an index file with \code{0} as the base name (e.g., \verb{0.rds}).}

\item{path}{The path to write files to / read files from.}

\item{method}{The file save/load method. It can be a string (e.g., \code{rds},
\code{raw}, or \code{qs2}) or a list. See the \code{rw} argument of \code{\link[=cache_exec]{cache_exec()}}. By
default, it is automatically detected by checking the existence of the
index file (e.g., \verb{0.rds}, \verb{0.raw}, or \verb{0.qs2}).}

\item{envir}{The environment to \link{get} or \link{assign} objects.}
}
\value{
\code{\link[=lazy_save]{lazy_save()}} returns invisible \code{NULL}; \code{\link[=lazy_load]{lazy_load()}} returns the
object names invisibly.
}
\description{
The function \code{\link[=lazy_save]{lazy_save()}} saves objects to files with incremental integer
names (e.g., the first object is saved to \verb{1.rds}, and the second object is
saved to \verb{2.rds}, etc.). The function \code{\link[=lazy_load]{lazy_load()}} lazy-load objects from
files saved via \code{\link[=lazy_save]{lazy_save()}}, i.e., a file will not be read until the object
is used.
}
\seealso{
\code{\link[=delayedAssign]{delayedAssign()}}
}
