package JMAP::Validation::Checks::Message;

use Test2::Bundle::Extended;

# record types {{{

my %Message_checks = (
  id                 => $JMAP::Validation::Checks::String::is_id,
  blobId             => $JMAP::Validation::Checks::String::is_string,
  threadId           => $JMAP::Validation::Checks::String::is_string,
  mailboxIds         => array { all_items $JMAP::Validation::Checks::String::is_string },
  inReplyToMessageId => in_set($JMAP::Validation::Checks::String::is_string, U()),
  isUnread           => $JMAP::Validation::Checks::Boolean::is_boolean,
  isFlagged          => $JMAP::Validation::Checks::Boolean::is_boolean,
  isAnswered         => $JMAP::Validation::Checks::Boolean::is_boolean,
  isDraft            => $JMAP::Validation::Checks::Boolean::is_boolean,
  hasAttachment      => $JMAP::Validation::Checks::Boolean::is_boolean,
  headers            => hash { all_items $JMAP::Validation::Checks::String::is_string },
  sender             => in_set($JMAP::Validation::Checks::Emaler::is_Emailer, U()),
  from               => in_set(array { all_items $JMAP::Validation::Checks::Emaler::is_Emailer }, U()),
  to                 => in_set(array { all_items $JMAP::Validation::Checks::Emaler::is_Emailer }, U()),
  cc                 => in_set(array { all_items $JMAP::Validation::Checks::Emaler::is_Emailer }, U()),
  bcc                => in_set(array { all_items $JMAP::Validation::Checks::Emaler::is_Emailer }, U()),
  replyTo            => in_set(array { all_items $JMAP::Validation::Checks::Emaler::is_Emailer }, U()),
  subject            => $JMAP::Validation::Checks::String::is_string,
  date               => $JMAP::Validation::Checks::String::is_datetime,
  size               => $JMAP::Validation::Checks::Number::is_number,
  preview            => $JMAP::Validation::Checks::String::is_string,
  textBody           => in_set($JMAP::Validation::Checks::String::is_string, U()),
  htmlBody           => in_set($JMAP::Validation::Checks::String::is_string, U()),
  attachments        => in_set(array { all_items $JMAP::Validation::Checks::Attachment::is_Attachment }, U()),

  # TODO: ignore the recursive check for now
  # attachedMessages => in_set(
  #   hash {
  #     all_keys   $JMAP::Validation::Checks::String::is_id;
  #     all_values $is_Message_embedded;
  # ), String[Message]|null
);

our $is_Message_embedded = hash {
  (field $_ => $Message_checks{$_}) for qw{
    headers
    from
    to
    cc
    bcc
    replyTo
    subject
    date
    textBody
    htmlBody
    attachments
    attachedMessages
  };

  # TODO: don't end() until recursive check works
  #end();
};

our $is_Message = hash {
  (field $_ => $Message_checks{$_}) for qw{
    id
    blobId
    threadId
    mailboxIds
    inReplyToMessageId
    isUnread
    isFlagged
    isAnswered
    isDraft
    hasAttachment
    headers
    sender
  };

  # TODO: don't end() until recursive check works
  #end();
};

# }}}

# request {{{
# }}}

# response types {{{
# }}}

1;
