/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grokkit.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JTextArea;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.Sign;
import opennlp.common.unify.FeatureStructure;

public class NLPTextComponent
extends JTextArea {
    private ArrayList content;

    public NLPTextComponent(ArrayList answers) {
        this.content = answers;
        this.setEditable(false);
        this.initialiseDocument();
    }

    public NLPTextComponent() {
        this.setEditable(false);
    }

    public void setContent(ArrayList answers) {
        this.content = answers;
        this.initialiseDocument();
    }

    private void initialiseDocument() {
        this.setText("");
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.content.size()) {
            Category category;
            Sign constituent = (Sign)this.content.get(i);
            if (constituent != null && (category = constituent.getCategory()) != null) {
                Set attributes;
                text.append(i).append(": Category: ").append(category.toString()).append('\n').append("     Orthography: ").append(constituent.getOrthography()).append('\n');
                FeatureStructure feats = category.getFeatureStructure();
                if (feats != null && (attributes = feats.getAttributes()) != null) {
                    text.append("        FeatureStructure: ").append('\n');
                    Iterator iter = attributes.iterator();
                    while (iter.hasNext()) {
                        text.append("            Attribute: ").append(iter.next().toString()).append('\n');
                    }
                }
            }
            ++i;
        }
        this.setText(text.toString());
    }
}

