/*
 * Decompiled with CFR 0.152.
 */
package gma.simr;

import gma.AxisTick;
import gma.BitextSpace;
import gma.MapPoint;
import gma.simr.MappingChain;
import gma.simr.SearchRectangle;
import gma.util.InputFileHandler;
import gma.util.OutputFileHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SIMR {
    public static final String DASH = "-";
    public static final String PLUS = "+";
    public static final String SPACE = " ";
    public static final String SIMR = "simr";
    public static final String VERBOSE = "verbose";
    public static final String PROPERTIES = "properties";
    public static final String X_AXIS_FILE = "xAxisFile";
    public static final String Y_AXIS_FILE = "yAxisFile";
    public static final String OUTPUT_FILE = "outputFile";
    public static final String DEF_OUT = "/tmp/temp.simr";
    public boolean debug = false;
    public String level = "1";
    public Integer verbose = new Integer(1);
    private Properties properties = new Properties();
    private BitextSpace bitextSpace = null;
    private boolean isDone = false;

    public SIMR(String[] args) {
        try {
            this.parseArguments(args);
        }
        catch (IllegalArgumentException e) {
            this.printUsage();
            System.exit(1);
        }
    }

    public SIMR(Properties properties) {
        this.properties = properties;
        this.level = properties.getProperty(VERBOSE, "1");
        this.verbose = new Integer(this.level);
    }

    private void printUsage() {
        StringBuffer buffer = new StringBuffer("Usage: java gma.simr.SIMR [arguments]\n\n");
        buffer.append("where [arguments] are:\n\n");
        buffer.append(this.formArgumentUsage(PROPERTIES, true, "./SIMR.properties"));
        buffer.append(this.formArgumentUsage(X_AXIS_FILE, false, "./french.txt"));
        buffer.append(this.formArgumentUsage(Y_AXIS_FILE, false, "./english.txt"));
        buffer.append(this.formArgumentUsage("simr.outputFile", false, "./simrOutput.txt"));
        System.err.println(buffer.toString());
    }

    private String formArgumentUsage(String argument, boolean isRequired, String example) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t").append(DASH).append(argument).append(SPACE).append(argument).append("\n");
        if (isRequired) {
            buffer.append("\t").append("required argument; ");
        } else {
            buffer.append("\t").append("optional argument; ");
        }
        buffer.append("e.g., ").append(DASH).append(argument).append(SPACE).append(example).append("\n\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readProperties(String fileName) {
        String line;
        BufferedInputStream in = null;
        in = new BufferedInputStream(new FileInputStream(fileName));
        this.properties.load(in);
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String inc = new String("#INCLUDE");
        while ((line = reader.readLine()) != null) {
            if (line.equals("") || !line.startsWith(inc)) continue;
            String[] tok = line.split(" +");
            Object in2 = null;
            this.readProperties(tok[1]);
        }
        Object var9_10 = null;
        if (in == null) return;
        try {
            ((InputStream)in).close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
                Object var9_11 = null;
                if (in == null) return;
                try {
                    ((InputStream)in).close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
                Object var9_12 = null;
                if (in == null) return;
                try {
                    ((InputStream)in).close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    private void parseArguments(String[] args) throws IllegalArgumentException {
        boolean gotProp = false;
        boolean gotOut = false;
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The number of arguments must be even.");
        }
        for (int index = 0; index < args.length; ++index) {
            if (args[index].equals("-properties")) {
                this.readProperties(args[++index]);
                gotProp = true;
                continue;
            }
            if (args[index].equals("-xAxisFile")) {
                this.properties.put(X_AXIS_FILE, args[++index]);
                continue;
            }
            if (args[index].equals("-yAxisFile")) {
                this.properties.put(Y_AXIS_FILE, args[++index]);
                continue;
            }
            if (args[index].equals("-verbose")) {
                this.properties.put(VERBOSE, args[++index]);
                this.level = this.properties.getProperty(VERBOSE);
                this.verbose = new Integer(this.level);
                continue;
            }
            if (args[index].equals("-simr.outputFile")) {
                this.properties.put("simr.outputFile", args[++index]);
                gotOut = true;
                System.err.println("out file = " + this.properties.getProperty("simr.outputFile"));
                continue;
            }
            throw new IllegalArgumentException(args[index] + "is an invalid argument.");
        }
        if (!gotProp) {
            throw new IllegalArgumentException("Property file must be specified at the command line.");
        }
        if (!gotOut) {
            this.properties.put("simr.outputFile", DEF_OUT);
        }
    }

    public SortedSet generateBitextCorrespondence() {
        this.bitextSpace = new BitextSpace(this.properties);
        this.bitextSpace.generateAxes();
        this.bitextSpace.updateSlopeProperty();
        SortedSet mappingChains = this.generateMappingChains();
        if (this.debug) {
            this.printChain(mappingChains);
        }
        List disambiguatedChains = this.disambiguateChains(mappingChains);
        return this.sortMapPoints(disambiguatedChains);
    }

    public void printChain(SortedSet mappingChains) {
        String outfile = this.properties.getProperty("simr.outputFile");
        OutputFileHandler outdebug = new OutputFileHandler(outfile + ".debug");
        Iterator it = mappingChains.iterator();
        while (it.hasNext()) {
            MappingChain itChain = (MappingChain)it.next();
            List newList = ((MappingChain)itChain.clone()).sort(itChain);
            Iterator lit = newList.iterator();
            outdebug.write(", " + lit.next() + "\n");
            while (lit.hasNext()) {
                outdebug.write(lit.next() + "\n");
            }
        }
        outdebug.close();
    }

    private SortedSet generateMappingChains() {
        MappingChain mappingChain;
        if (this.verbose >= 1) {
            System.err.println("Generating mapping chains");
        }
        TreeSet<MappingChain> mappingChains = new TreeSet<MappingChain>();
        SearchRectangle searchRectangle = new SearchRectangle(this.properties);
        searchRectangle.expandSearchRectangle(this.bitextSpace.getAxisTick(0, true), true);
        searchRectangle.expandSearchRectangle(this.bitextSpace.getAxisTick(0, false), false);
        while (!this.isDone && (mappingChain = this.searchMappingChains(searchRectangle)) != null) {
            mappingChains.add(mappingChain);
            searchRectangle = searchRectangle.reduceSearchRectangle();
        }
        return mappingChains;
    }

    private MappingChain searchMappingChains(SearchRectangle searchRectangle) {
        AxisTick xTick = searchRectangle.getBoundaryAxisTick(true, false);
        AxisTick yTick = searchRectangle.getBoundaryAxisTick(false, false);
        int xoffset = searchRectangle.getNumInstances(true, xTick);
        int yoffset = searchRectangle.getNumInstances(false, yTick);
        Iterator xTickIterator = this.bitextSpace.getAxisIterator(searchRectangle.getBoundaryAxisTick(true, false), true, xoffset - 1);
        Iterator yTickIterator = this.bitextSpace.getAxisIterator(searchRectangle.getBoundaryAxisTick(false, false), false, yoffset - 1);
        boolean first = true;
        while (xTickIterator.hasNext()) {
            if (first || searchRectangle.hasNewPoint()) {
                first = false;
                if (searchRectangle.hasMappingChain()) {
                    return searchRectangle.getBestChain();
                }
            }
            searchRectangle.expandSearchRectangle((AxisTick)xTickIterator.next(), true);
            while (yTickIterator.hasNext() && searchRectangle.canExpandYAxis()) {
                searchRectangle.expandSearchRectangle((AxisTick)yTickIterator.next(), false);
            }
        }
        if (searchRectangle.hasMappingChain()) {
            return searchRectangle.getBestChain();
        }
        this.isDone = true;
        return null;
    }

    private List disambiguateChains(SortedSet mappingChains) {
        ArrayList<MappingChain> nonConflictChains = new ArrayList<MappingChain>();
        HashMap conflictWithChains = new HashMap();
        Iterator outerIterator = mappingChains.iterator();
        while (outerIterator.hasNext()) {
            MappingChain innerMappingChain;
            ArrayList<MappingChain> conflictChains = new ArrayList<MappingChain>();
            MappingChain outerMappingChain = (MappingChain)outerIterator.next();
            Iterator innerIterator = mappingChains.iterator();
            while (innerIterator.hasNext() && outerMappingChain != (innerMappingChain = (MappingChain)innerIterator.next()) && (outerMappingChain.getEndMapPoint(true, false).isMaxMapPoint(innerMappingChain.getEndMapPoint(true, true), true) != -1 || outerMappingChain.getEndMapPoint(false, false).isMaxMapPoint(innerMappingChain.getEndMapPoint(false, true), false) != -1)) {
                if (outerMappingChain.getEndMapPoint(true, true).isMaxMapPoint(innerMappingChain.getEndMapPoint(true, false), true) == 1 && outerMappingChain.getEndMapPoint(false, true).isMaxMapPoint(innerMappingChain.getEndMapPoint(false, false), false) == 1 || !outerMappingChain.isConflict(innerMappingChain)) continue;
                conflictChains.add(innerMappingChain);
                List reverseConflictChains = null;
                reverseConflictChains = !conflictWithChains.containsKey(innerMappingChain) ? new ArrayList() : (List)conflictWithChains.get(innerMappingChain);
                reverseConflictChains.add(outerMappingChain);
                conflictWithChains.put(innerMappingChain, reverseConflictChains);
            }
            if (conflictChains.isEmpty()) continue;
            conflictWithChains.put(outerMappingChain, conflictChains);
        }
        Iterator nonConflictIterator = mappingChains.iterator();
        while (nonConflictIterator.hasNext()) {
            MappingChain mappingChain = (MappingChain)nonConflictIterator.next();
            if (conflictWithChains.containsKey(mappingChain)) continue;
            nonConflictChains.add(mappingChain);
        }
        while (!conflictWithChains.isEmpty()) {
            int maxConflictCounter = 0;
            MappingChain mostConflictualChain = null;
            Set keys = conflictWithChains.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                MappingChain keyChain = (MappingChain)iterator.next();
                List conflictChains = (List)conflictWithChains.get(keyChain);
                if (mostConflictualChain != null && conflictChains.size() <= maxConflictCounter && (conflictChains.size() != maxConflictCounter || !(mostConflictualChain.getSumSquareError() < keyChain.getSumSquareError()))) continue;
                maxConflictCounter = conflictChains.size();
                mostConflictualChain = keyChain;
            }
            List conflictChains = (List)conflictWithChains.get(mostConflictualChain);
            Iterator conflictIterator = conflictChains.iterator();
            while (conflictIterator.hasNext()) {
                MappingChain conflictChain = (MappingChain)conflictIterator.next();
                List reversedConflictChains = (List)conflictWithChains.get(conflictChain);
                reversedConflictChains.remove(mostConflictualChain);
                if (!reversedConflictChains.isEmpty()) continue;
                conflictIterator.remove();
                nonConflictChains.add(conflictChain);
                conflictWithChains.remove(conflictChain);
            }
            conflictWithChains.remove(mostConflictualChain);
        }
        return nonConflictChains;
    }

    private SortedSet sortMapPoints(List bestChains) {
        TreeSet<MapPoint> mapPoints = new TreeSet<MapPoint>();
        Iterator iterator = bestChains.iterator();
        while (iterator.hasNext()) {
            MappingChain mappingChain = (MappingChain)iterator.next();
            for (int index = 0; index < mappingChain.getChainSize(); ++index) {
                MapPoint mapPoint = mappingChain.getMapPoint(index);
                mapPoints.add(mapPoint);
            }
        }
        return mapPoints;
    }

    public String getTerminus(SortedSet bestPoints) {
        InputFileHandler xInput = new InputFileHandler(this.properties.getProperty(X_AXIS_FILE));
        String xLastLine = "null";
        while (xInput.hasLine()) {
            String line;
            xLastLine = line = xInput.nextLine();
        }
        StringTokenizer xTokenizer = new StringTokenizer(xLastLine);
        float xEndPosition = Float.parseFloat(xTokenizer.nextToken());
        InputFileHandler yInput = new InputFileHandler(this.properties.getProperty(Y_AXIS_FILE));
        String yLastLine = "null";
        while (yInput.hasLine()) {
            String line;
            yLastLine = line = yInput.nextLine();
        }
        StringTokenizer yTokenizer = new StringTokenizer(yLastLine);
        float yEndPosition = Float.parseFloat(yTokenizer.nextToken());
        String terminus = xEndPosition + SPACE + yEndPosition;
        return terminus;
    }

    public void printMapPoints(SortedSet bestPoints) {
        OutputFileHandler out = new OutputFileHandler(this.properties.getProperty("simr.outputFile"));
        Iterator iterator = bestPoints.iterator();
        out.write("0.0 0.0\n");
        String lastLine = this.getTerminus(bestPoints);
        if (iterator.hasNext()) {
            String first = ((MapPoint)iterator.next()).toString();
            if (!first.equals("0.0 0.0")) {
                out.write(first + "\n");
            }
            while (iterator.hasNext()) {
                out.write(((MapPoint)iterator.next()).toString() + "\n");
            }
            MapPoint mp = (MapPoint)bestPoints.last();
            if (!lastLine.equals(mp.toString())) {
                out.write(lastLine);
                out.write("\n");
            }
        } else {
            out.write(lastLine + "\n");
        }
        out.close();
        if (this.properties.getProperty("simr.outputFile") == DEF_OUT) {
            try {
                BufferedReader out2screen = new BufferedReader(new InputStreamReader(new FileInputStream(DEF_OUT)));
                String line = "";
                while ((line = out2screen.readLine()) != null) {
                    System.out.println(line);
                }
                out2screen.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        SIMR simr = new SIMR(args);
        long start = System.currentTimeMillis();
        SortedSet mapPoints = simr.generateBitextCorrespondence();
        simr.printMapPoints(mapPoints);
        long end = System.currentTimeMillis();
        long elapsed = end - start;
        System.exit(0);
    }
}

