/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.common.synsem.Category;
import opennlp.common.unify.ModFcn;
import opennlp.common.unify.Substitution;
import opennlp.common.unify.UnifyFailure;
import opennlp.common.unify.Variable;
import opennlp.grok.expression.Arg;
import opennlp.grok.expression.BasicArg;
import opennlp.grok.expression.CatReader;
import opennlp.grok.expression.Dollar;
import opennlp.grok.expression.Slash;
import org.jdom.Element;

public class ArgStack {
    protected Arg[] _list;
    protected boolean _hasDollar = false;

    public ArgStack() {
        this._list = new Arg[0];
    }

    public ArgStack(Arg c) {
        this._list = new Arg[1];
        this._list[0] = c;
    }

    public ArgStack(Slash s, Category c) {
        this(new BasicArg(s, c));
    }

    public ArgStack(Arg[] list) {
        this._list = list;
    }

    public ArgStack(List info) {
        ArrayList<Arg> args = new ArrayList<Arg>();
        Iterator infoIt = info.iterator();
        while (infoIt.hasNext()) {
            Slash s = new Slash((Element)infoIt.next());
            Element a = (Element)infoIt.next();
            if (a.getName().equals("dollar")) {
                args.add(new Dollar(s, a));
                this._hasDollar = true;
                continue;
            }
            args.add(new BasicArg(s, CatReader.getCat(a)));
        }
        this._list = new Arg[args.size()];
        args.toArray(this._list);
    }

    public void add(Arg c) {
        Arg[] $list = new Arg[this._list.length + 1];
        int last = ArgStack.insert(this._list, $list, 0);
        $list[last] = c;
        this._list = $list;
    }

    public void add(ArgStack cl) {
        Arg[] $list = new Arg[this._list.length + cl._list.length];
        int last = ArgStack.insert(this._list, $list, 0);
        ArgStack.insert(cl._list, $list, last);
        this._list = $list;
    }

    public void addFront(Arg c) {
        Arg[] $list = new Arg[this._list.length + 1];
        $list[0] = c;
        ArgStack.insert(this._list, $list, 1);
        this._list = $list;
    }

    public int size() {
        return this._list.length;
    }

    public boolean containsDollarArg() {
        return this._hasDollar;
    }

    public Arg get(int i) {
        return this._list[i];
    }

    public void set(int i, Arg c) {
        this._list[i] = c;
    }

    public Arg getLast() {
        return this._list[this._list.length - 1];
    }

    public void setLast(Arg c) {
        this._list[this._list.length - 1] = c;
    }

    public ArgStack copy() {
        Arg[] $list = new Arg[this._list.length];
        int i = 0;
        while (i < $list.length) {
            $list[i] = this._list[i].copy();
            ++i;
        }
        return new ArgStack($list);
    }

    public ArgStack copyWithout(int indexToRemove) {
        Arg[] $list = new Arg[this._list.length - 1];
        if ($list.length < 1) {
            System.out.println("Removing last item from an argument stack!");
        }
        int index = 0;
        int i = 0;
        while (i < this._list.length) {
            if (i != indexToRemove) {
                $list[index++] = this._list[i].copy();
            }
            ++i;
        }
        return new ArgStack($list);
    }

    public ArgStack subList(int from) {
        return this.subList(from, this._list.length);
    }

    public ArgStack subList(int from, int upto) {
        Arg[] $list = new Arg[upto - from];
        int index = 0;
        int i = from;
        while (i < upto) {
            $list[index++] = this._list[i];
            ++i;
        }
        return new ArgStack($list);
    }

    public ArgStack shallowCopy() {
        return new ArgStack(this._list);
    }

    public boolean occurs(Variable v) {
        int i = 0;
        while (i < this._list.length) {
            if (this._list[i].occurs(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArgStack fill(Substitution s) throws UnifyFailure {
        ArgStack args = new ArgStack();
        int i = 0;
        while (i < this._list.length) {
            Object value = this._list[i].fill(s);
            if (value instanceof ArgStack) {
                args.add((ArgStack)value);
            } else {
                args.add((Arg)value);
            }
            ++i;
        }
        return args;
    }

    public void deepMap(ModFcn mf) {
        int i = 0;
        while (i < this._list.length) {
            this._list[i].deepMap(mf);
            ++i;
        }
    }

    public int unifySuffix(ArgStack as, Substitution sub) throws UnifyFailure {
        int asIndex = as.size();
        int i = this._list.length - 1;
        while (i >= 0) {
            this.get(i).unify(as.get(--asIndex), sub);
            --i;
        }
        return asIndex;
    }

    public void unify(ArgStack as, Substitution sub) throws UnifyFailure {
        int asIndex = as.size();
        int i = this._list.length - 1;
        while (i >= 0) {
            Arg argi = this.get(i);
            if (argi instanceof Dollar) {
                if (i > 0) {
                    throw new UnifyFailure();
                }
                Slash dsl = ((Dollar)argi).getSlash();
                int j = 0;
                while (j < asIndex) {
                    as.get(j).unifySlash(dsl);
                    ++j;
                }
                sub.makeSubstitution((Variable)((Dollar)argi), (Object)as.subList(0, asIndex));
            } else {
                this.get(i).unify(as.get(--asIndex), sub);
            }
            --i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._list.length) {
            sb.append(this._list[i].toString());
            ++i;
        }
        return sb.toString();
    }

    protected static int insert(Arg[] a, Arg[] b, int pos) {
        int i = 0;
        while (i < a.length) {
            b[pos++] = a[i];
            ++i;
        }
        return pos;
    }
}

