/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.GISModelWriter;

public class BinaryGISModelWriter
extends GISModelWriter {
    DataOutputStream output;

    public BinaryGISModelWriter(GISModel model, DataOutputStream dos) {
        super(model);
        this.output = dos;
    }

    public BinaryGISModelWriter(GISModel model, File f) throws IOException {
        super(model);
        this.output = f.getName().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream(new FileOutputStream(f))) : new DataOutputStream(new FileOutputStream(f));
    }

    protected void close() throws IOException {
        this.output.flush();
        this.output.close();
    }

    protected void writeDouble(double d) throws IOException {
        this.output.writeDouble(d);
    }

    protected void writeInt(int i) throws IOException {
        this.output.writeInt(i);
    }

    protected void writeUTF(String s) throws IOException {
        this.output.writeUTF(s);
    }
}

