import { useState } from 'react';
import {
  Button,
  DescriptionList,
  DescriptionListTerm,
  DescriptionListDescription,
  Card,
  Checkbox
} from '@patternfly/react-core';
import PlusCircleIcon from '@patternfly/react-icons/dist/esm/icons/plus-circle-icon';

export const DescriptionListWithLargeDisplaySizeAndCard: React.FunctionComponent = () => {
  const [isChecked, setIsChecked] = useState<boolean>(false);
  const [displaySize, setDisplaySize] = useState<'lg' | '2xl'>('lg');

  const toggleDisplaySize = (checked: boolean) => {
    setDisplaySize(checked ? '2xl' : 'lg');
    setIsChecked(checked);
  };

  return (
    <>
      <div style={{ marginBottom: '12px' }}>
        <Checkbox
          label="displaySize 2xl"
          isChecked={isChecked}
          onChange={(_event, checked) => toggleDisplaySize(checked)}
          aria-label="set display size 2xl"
          id="toggle-display-size-with-card"
          name="toggle-display-size-with-card"
        />
      </div>
      <DescriptionList
        displaySize={displaySize}
        columnModifier={{ lg: '2Col' }}
        aria-label="With large display size and card"
      >
        <Card component="div">
          <DescriptionListTerm>Name</DescriptionListTerm>
          <DescriptionListDescription>Example</DescriptionListDescription>
        </Card>
        <Card component="div">
          <DescriptionListTerm>Namespace</DescriptionListTerm>
          <DescriptionListDescription>
            <a href="#">mary-test</a>
          </DescriptionListDescription>
        </Card>
        <Card component="div">
          <DescriptionListTerm>Labels</DescriptionListTerm>
          <DescriptionListDescription>example</DescriptionListDescription>
        </Card>
        <Card component="div">
          <DescriptionListTerm>Pod selector</DescriptionListTerm>
          <DescriptionListDescription>
            <Button variant="link" isInline icon={<PlusCircleIcon />}>
              app=MyApp
            </Button>
          </DescriptionListDescription>
        </Card>
        <Card component="div">
          <DescriptionListTerm>Annotation</DescriptionListTerm>
          <DescriptionListDescription>2 Annotations</DescriptionListDescription>
        </Card>
      </DescriptionList>
    </>
  );
};
