# Database
#
# The X-ray lines energies are taken from Chantler2005,
# Chantler, C.T., Olsen, K., Dragoset, R.A., Kishore, A.R.,
# Kotochigova, S.A., and Zucker, D.S.
#
# The line weight, more precisely the approximate line weight for K,L M
# shells are taken from epq library
# 
# The field 'threshold' and 'edge' are taken from Gatan EELS atlas
# https://eels.info/atlas (retrieved in June 2020)

from hyperspy.misc import utils

elements = {'Ru': {'Physical_properties': {'density (g/cm^3)': 12.37},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.33039,
                                                                'energy (keV)': 2.6833},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 21.6566},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 19.2793},
                                                        'Lb2': {'weight': 0.07259,
                                                                'energy (keV)': 2.8359},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.5585},
                                                        'Ln': {'weight': 0.0126,
                                                               'energy (keV)': 2.3819},
                                                        'Ll': {'weight': 0.0411,
                                                               'energy (keV)': 2.2529},
                                                        'Lb3': {'weight': 0.0654,
                                                                'energy (keV)': 2.7634},
                                                        'Lg3': {'weight': 0.0115,
                                                                'energy (keV)': 3.1809},
                                                        'Lg1': {'weight': 0.02176,
                                                                'energy (keV)': 2.9649}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 279.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 279.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 461.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 483.0}}},
                   'General_properties': {'Z': 44,
                                          'atomic_weight': 101.07,
                                          'name': 'ruthenium'}},
            'Re': {'Physical_properties': {'density (g/cm^3)': 21.02},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4408,
                                                                'energy (keV)': 10.0098},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 69.3091},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 61.1411},
                                                        'M2N4': {'weight': 0.01,
                                                                 'energy (keV)': 2.4079},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.8423},
                                                        'Lb4': {'weight': 0.09869,
                                                                'energy (keV)': 9.8451},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 8.6524},
                                                        'Ln': {'weight': 0.0151,
                                                               'energy (keV)': 9.027},
                                                        'M3O4': {'energy (keV)': 2.36124,
                                                                 'weight': 0.001},
                                                        'Ll': {'weight': 0.05299,
                                                               'energy (keV)': 7.6036},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.9083},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 2.1071},
                                                        'Lb2': {'weight': 0.21219,
                                                                'energy (keV)': 10.2751},
                                                        'Lb3': {'weight': 0.1222,
                                                                'energy (keV)': 10.1594},
                                                        'M3O5': {'energy (keV)': 2.36209,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.0331,
                                                                'energy (keV)': 12.0823},
                                                        'Lg1': {'weight': 0.08864,
                                                                'energy (keV)': 11.685},
                                                        'Mz': {'weight': 0.01344,
                                                               'energy (keV)': 1.4385}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1883.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1949.0}}},
                   'General_properties': {'Z': 75,
                                          'atomic_weight': 186.207,
                                          'name': 'rhenium'}},
            'Ra': {'Physical_properties': {'density (g/cm^3)': 5.0},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4,
                                                                'energy (keV)': 15.2359},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 100.1302},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 88.4776},
                                                        'M2N4': {'weight': 0.00674,
                                                                 'energy (keV)': 3.8536},
                                                        'Lb4': {'weight': 0.06209,
                                                                'energy (keV)': 14.7472},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 12.3395},
                                                        'Ln': {'weight': 0.0133,
                                                               'energy (keV)': 13.6623},
                                                        'Ll': {'weight': 0.06429,
                                                               'energy (keV)': 10.6224},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.9495},
                                                        'Mg': {'weight': 0.33505,
                                                               'energy (keV)': 3.1891},
                                                        'Lb2': {'weight': 0.23579,
                                                                'energy (keV)': 14.8417},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 18.3576},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 17.8484},
                                                        'Lb3': {'weight': 0.06,
                                                                'energy (keV)': 15.4449},
                                                        'Mz': {'weight': 0.03512,
                                                               'energy (keV)': 2.2258}}},
                   'General_properties': {'Z': 88,
                                          'atomic_weight': 226,
                                          'name': 'radium'}},
            'Rb': {'Physical_properties': {'density (g/cm^3)': 1.532},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.39095,
                                                                'energy (keV)': 1.7521},
                                                        'Kb': {'weight': 0.1558,
                                                               'energy (keV)': 14.9612},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 13.3953},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.6941},
                                                        'Ln': {'weight': 0.01709,
                                                               'energy (keV)': 1.5418},
                                                        'Ll': {'weight': 0.0441,
                                                               'energy (keV)': 1.4823},
                                                        'Lb3': {'weight': 0.04709,
                                                                'energy (keV)': 1.8266},
                                                        'Lg3': {'weight': 0.0058,
                                                                'energy (keV)': 2.0651}},
                                         'Binding_energies': {'M2': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 247.0},
                                                              'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 110.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 110.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1864.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1804.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 238.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 2065.0}}},
                   'General_properties': {'Z': 37,
                                          'atomic_weight': 85.4678,
                                          'name': 'rubidium'}},
            'Rn': {'Physical_properties': {'density (g/cm^3)': 0.00973},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.38463,
                                                                'energy (keV)': 14.3156},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 94.866},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 83.7846},
                                                        'M2N4': {'weight': 0.00863,
                                                                 'energy (keV)': 3.5924},
                                                        'Lb4': {'weight': 0.06,
                                                                'energy (keV)': 13.89},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 11.727},
                                                        'Ln': {'weight': 0.0134,
                                                               'energy (keV)': 12.8551},
                                                        'Ll': {'weight': 0.0625,
                                                               'energy (keV)': 10.1374},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.80187},
                                                        'Mg': {'weight': 0.21845,
                                                               'energy (keV)': 3.001},
                                                        'Lb2': {'weight': 0.2325,
                                                                'energy (keV)': 14.0824},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 17.281},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 16.7705},
                                                        'Lb3': {'weight': 0.0607,
                                                                'energy (keV)': 14.511},
                                                        'Mz': {'weight': 0.0058,
                                                               'energy (keV)': 2.1244}}},
                   'General_properties': {'Z': 86,
                                          'atomic_weight': 222,
                                          'name': 'radon'}},
            'Rh': {'Physical_properties': {'density (g/cm^3)': 12.45},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.33463,
                                                                'energy (keV)': 2.8344},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 22.7237},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 20.2161},
                                                        'Lb2': {'weight': 0.08539,
                                                                'energy (keV)': 3.0013},
                                                        'Lb4': {'weight': 0.0395,
                                                                'energy (keV)': 2.8909},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.6968},
                                                        'Ln': {'weight': 0.0126,
                                                               'energy (keV)': 2.519},
                                                        'Ll': {'weight': 0.0411,
                                                               'energy (keV)': 2.3767},
                                                        'Lb3': {'weight': 0.06669,
                                                                'energy (keV)': 2.9157},
                                                        'Lg3': {'weight': 0.0121,
                                                                'energy (keV)': 3.364},
                                                        'Lg1': {'weight': 0.02623,
                                                                'energy (keV)': 3.1436}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 308.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 312.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 496.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 521.0,}}},
                   'General_properties': {'Z': 45,
                                          'atomic_weight': 102.9055,
                                          'name': 'rhodium'}},
            'H': {'Physical_properties': {'density (g/cm^3)': 8.99e-5},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                              'energy (keV)': 0.0013598}},
                                        'Binding_energies': {'K': {'relevance': 'Major',
                                                                   'threshold': '',
                                                                   'edge': 'Abrupt onset',
                                                                   'onset_energy (eV)': 13.598}}},
                  'General_properties': {'Z': 1,
                                         'atomic_weight': 1.00794,
                                         'name': 'hydrogen'}},
            'He': {'Physical_properties': {'density (g/cm^3)': 1.785e-4},
                   'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                               'energy (keV)': 0.0024587}},
                                         'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 24.587}}},
                   'General_properties': {'Z': 2,
                                          'atomic_weight': 4.002602,
                                          'name': 'helium'}},
            'Be': {'Physical_properties': {'density (g/cm^3)': 1.848},
                   'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                               'energy (keV)': 0.10258}},
                                         'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 111.0}}},
                   'General_properties': {'Z': 4,
                                          'atomic_weight': 9.012182,
                                          'name': 'beryllium'}},
            'Ba': {'Physical_properties': {'density (g/cm^3)': 3.51},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43048,
                                                                'energy (keV)': 4.8275},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 36.3784},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 32.1936},
                                                        'Lb2': {'weight': 0.1905,
                                                                'energy (keV)': 5.1571},
                                                        'Lb4': {'weight': 0.08859,
                                                                'energy (keV)': 4.8521},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 4.4663},
                                                        'Ln': {'weight': 0.0151,
                                                               'energy (keV)': 4.3308},
                                                        'Ll': {'weight': 0.04299,
                                                               'energy (keV)': 3.9542},
                                                        'Lb3': {'weight': 0.13779,
                                                                'energy (keV)': 4.9266},
                                                        'Lg3': {'weight': 0.0331,
                                                                'energy (keV)': 5.8091},
                                                        'Lg1': {'weight': 0.07487,
                                                                'energy (keV)': 5.5311}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 781.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 796.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1062.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1137.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 90.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 90.0}}},
                   'General_properties': {'Z': 56,
                                          'atomic_weight': 137.327,
                                          'name': 'barium'}},
            'Bi': {'Physical_properties': {'density (g/cm^3)': 9.78},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4,
                                                                'energy (keV)': 13.0235},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 87.349},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 77.1073},
                                                        'M2N4': {'weight': 0.00863,
                                                                 'energy (keV)': 3.2327},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 2.4222},
                                                        'Lb4': {'weight': 0.05639,
                                                                'energy (keV)': 12.6912},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 10.839},
                                                        'Ln': {'weight': 0.0134,
                                                               'energy (keV)': 11.712},
                                                        'M3O4': {'energy (keV)': 3.1504,
                                                                 'weight': 0.01},
                                                        'Ll': {'weight': 0.06,
                                                               'energy (keV)': 9.4195},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.5257},
                                                        'Mg': {'weight': 0.21845,
                                                               'energy (keV)': 2.7369},
                                                        'Lb2': {'weight': 0.2278,
                                                                'energy (keV)': 12.9786},
                                                        'Lb3': {'weight': 0.0607,
                                                                'energy (keV)': 13.2106},
                                                        'M3O5': {'energy (keV)': 3.1525,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 15.7086},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 15.2475},
                                                        'Mz': {'weight': 0.0058,
                                                               'energy (keV)': 1.9007}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2580.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2688.0}}},
                   'General_properties': {'Z': 83,
                                          'atomic_weight': 208.9804,
                                          'name': 'bismuth'}},
            'Br': {'Physical_properties': {'density (g/cm^3)': 3.12},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.39175,
                                                                'energy (keV)': 1.5259},
                                                        'Kb': {'weight': 0.15289,
                                                               'energy (keV)': 13.2922},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 11.9238},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.4809},
                                                        'Ln': {'weight': 0.0182,
                                                               'energy (keV)': 1.3395},
                                                        'Ll': {'weight': 0.0462,
                                                               'energy (keV)': 1.2934},
                                                        'Lb3': {'weight': 0.04629,
                                                                'energy (keV)': 1.6005}},
                                         'Binding_energies': {'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1596.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1550.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1782.0}}},
                   'General_properties': {'Z': 35,
                                          'atomic_weight': 79.904,
                                          'name': 'bromine'}},
            'P': {'Physical_properties': {'density (g/cm^3)': 1.823},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.0498,
                                                              'energy (keV)': 2.13916},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 2.0133}},
                                        'Binding_energies': {'K': {'relevance': 'Major',
                                                                   'threshold': '',
                                                                   'edge': 'Abrupt onset',
                                                                   'onset_energy (eV)': 2146.0},
                                                             'L2,3': {'relevance': 'Major',
                                                                    # overlaps
                                                                    # with L2
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 132.0},
                                                             'L1': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 189.0}}},
                  'General_properties': {'Z': 15,
                                         'atomic_weight': 30.973762,
                                         'name': 'phosphorus'}},
            'Os': {'Physical_properties': {'density (g/cm^3)': 22.59},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43207,
                                                                'energy (keV)': 10.3542},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 71.4136},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 62.9999},
                                                        'M2N4': {'weight': 0.02901,
                                                                 'energy (keV)': 2.5028},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.9138},
                                                        'Lb4': {'weight': 0.08369,
                                                                'energy (keV)': 10.1758},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 8.9108},
                                                        'Ln': {'weight': 0.01479,
                                                               'energy (keV)': 9.3365},
                                                        'M3O4': {'energy (keV)': 2.45015,
                                                                 'weight': 0.005},
                                                        'Ll': {'weight': 0.05389,
                                                               'energy (keV)': 7.8224},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.9845},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 2.1844},
                                                        'Lb2': {'weight': 0.2146,
                                                                'energy (keV)': 10.5981},
                                                        'Lb3': {'weight': 0.1024,
                                                                'energy (keV)': 10.5108},
                                                        'M3O5': {'energy (keV)': 2.45117,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.028,
                                                                'energy (keV)': 12.4998},
                                                        'Lg1': {'weight': 0.08768,
                                                                'energy (keV)': 12.0956},
                                                        'Mz': {'weight': 0.01344,
                                                               'energy (keV)': 1.4919}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1960.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2031.0}}},
                   'General_properties': {'Z': 76,
                                          'atomic_weight': 190.23,
                                          'name': 'osmium'}},
            'Ge': {'Physical_properties': {'density (g/cm^3)': 5.323},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.16704,
                                                                'energy (keV)': 1.2191},
                                                        'Kb': {'weight': 0.1322,
                                                               'energy (keV)': 10.9823},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 9.8864},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.188},
                                                        'Ln': {'weight': 0.02,
                                                               'energy (keV)': 1.0678},
                                                        'Ll': {'weight': 0.0511,
                                                               'energy (keV)': 1.0367},
                                                        'Lb3': {'weight': 0.04429,
                                                                'energy (keV)': 1.2935}},
                                         'Binding_energies': {'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1248.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1217.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1414.0}}},
                   'General_properties': {'Z': 32,
                                          'atomic_weight': 72.64,
                                          'name': 'germanium'}},
            'Gd': {'Physical_properties': {'density (g/cm^3)': 7.901},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.44127,
                                                                'energy (keV)': 6.7131},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 48.6951},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 42.9963},
                                                        'M2N4': {'weight': 0.014,
                                                                 'energy (keV)': 1.5478},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.17668},
                                                        'Lb4': {'weight': 0.08789,
                                                                'energy (keV)': 6.6873},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 6.0576},
                                                        'Ln': {'weight': 0.01489,
                                                               'energy (keV)': 6.0495},
                                                        'Ll': {'weight': 0.04629,
                                                               'energy (keV)': 5.362},
                                                        'Mb': {'weight': 0.88,
                                                               'energy (keV)': 1.20792},
                                                        'Mg': {'weight': 0.261,
                                                               'energy (keV)': 1.4035},
                                                        'Lb2': {'weight': 0.2014,
                                                                'energy (keV)': 7.1023},
                                                        'Lb3': {'weight': 0.1255,
                                                                'energy (keV)': 6.8316},
                                                        'Lg3': {'weight': 0.032,
                                                                'energy (keV)': 8.1047},
                                                        'Lg1': {'weight': 0.08207,
                                                                'energy (keV)': 7.7898},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 0.9143}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1185.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1217.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1544.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1688.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 141.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 141.0}}},
                   'General_properties': {'Z': 64,
                                          'atomic_weight': 157.25,
                                          'name': 'gadolinium'}},
            'Ga': {'Physical_properties': {'density (g/cm^3)': 5.904},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.16704,
                                                                'energy (keV)': 1.1249},
                                                        'Kb': {'weight': 0.1287,
                                                               'energy (keV)': 10.2642},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 9.2517},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.098},
                                                        'Ln': {'weight': 0.02509,
                                                               'energy (keV)': 0.9842},
                                                        'Ll': {'weight': 0.0544,
                                                               'energy (keV)': 0.9573},
                                                        'Lb3': {'weight': 0.0461,
                                                                'energy (keV)': 1.1948}},
                                         'Binding_energies': {'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1142.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1115.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1298.0}}},
                   'General_properties': {'Z': 31,
                                          'atomic_weight': 69.723,
                                          'name': 'gallium'}},
            'Pr': {'Physical_properties': {'density (g/cm^3)': 6.64},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.42872,
                                                                'energy (keV)': 5.4893},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 40.7484},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 36.0263},
                                                        'M2N4': {'weight': 0.055,
                                                                 'energy (keV)': 1.2242},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 0.8936},
                                                        'Lb4': {'weight': 0.0864,
                                                                'energy (keV)': 5.4974},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 5.0333},
                                                        'Ln': {'weight': 0.01489,
                                                               'energy (keV)': 4.9294},
                                                        'Ll': {'weight': 0.044,
                                                               'energy (keV)': 4.4533},
                                                        'Mb': {'weight': 0.85,
                                                               'energy (keV)': 0.9476},
                                                        'Mg': {'weight': 0.6,
                                                               'energy (keV)': 1.129},
                                                        'Lb2': {'weight': 0.19519,
                                                                'energy (keV)': 5.8511},
                                                        'Lb3': {'weight': 0.13089,
                                                                'energy (keV)': 5.5926},
                                                        'Lg3': {'weight': 0.0321,
                                                                'energy (keV)': 6.6172},
                                                        'Lg1': {'weight': 0.07687,
                                                                'energy (keV)': 6.3272},
                                                        'Mz': {'weight': 0.068,
                                                               'energy (keV)': 0.7134}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 931.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 951.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1242.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1337.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 114.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 114.0}}},
                   'General_properties': {'Z': 59,
                                          'atomic_weight': 140.90765,
                                          'name': 'praseodymium'}},
            'Pt': {'Physical_properties': {'density (g/cm^3)': 21.09},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4088,
                                                                'energy (keV)': 11.0707},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 75.7494},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 66.8311},
                                                        'M2N4': {'weight': 0.02901,
                                                                 'energy (keV)': 2.6957},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 2.0505},
                                                        'Lb4': {'weight': 0.0662,
                                                                'energy (keV)': 10.8534},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 9.4421},
                                                        'Ln': {'weight': 0.01399,
                                                               'energy (keV)': 9.9766},
                                                        'M3O4': {'energy (keV)': 2.63796,
                                                                 'weight': 0.005},
                                                        'Ll': {'weight': 0.0554,
                                                               'energy (keV)': 8.2677},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 2.1276},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 2.3321},
                                                        'Lb2': {'weight': 0.21829,
                                                                'energy (keV)': 11.2504},
                                                        'Lb3': {'weight': 0.0783,
                                                                'energy (keV)': 11.2345},
                                                        'M3O5': {'energy (keV)': 2.63927,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.0218,
                                                                'energy (keV)': 13.3609},
                                                        'Lg1': {'weight': 0.08448,
                                                                'energy (keV)': 12.9418},
                                                        'Mz': {'weight': 0.01344,
                                                               'energy (keV)': 1.6026}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2122.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2202.0}}},
                   'General_properties': {'Z': 78,
                                          'atomic_weight': 195.084,
                                          'name': 'platinum'}},
            'C': {'Physical_properties': {'density (g/cm^3)': 2.26},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                              'energy (keV)': 0.2774}},
                                        'Binding_energies': {'K': {'relevance': 'Major',
                                                                   'threshold': '',
                                                                   'edge': 'Abrupt onset',
                                                                   'onset_energy (eV)': 284.0},
                                                             'K1a': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 284.0}}},
                  'General_properties': {'Z': 6,
                                         'atomic_weight': 12.0107,
                                         'name': 'carbon'}},
            'Pb': {'Physical_properties': {'density (g/cm^3)': 11.34},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.3836,
                                                                'energy (keV)': 12.6144},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 84.9381},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 74.9693},
                                                        'M2N4': {'weight': 0.00863,
                                                                 'energy (keV)': 3.119},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 2.3459},
                                                        'Lb4': {'weight': 0.055,
                                                                'energy (keV)': 12.3066},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 10.5512},
                                                        'Ln': {'weight': 0.0132,
                                                               'energy (keV)': 11.3493},
                                                        'M3O4': {'energy (keV)': 3.0446,
                                                                 'weight': 0.01},
                                                        'Ll': {'weight': 0.0586,
                                                               'energy (keV)': 9.1845},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.4427},
                                                        'Mg': {'weight': 0.21845,
                                                               'energy (keV)': 2.6535},
                                                        'Lb2': {'weight': 0.2244,
                                                                'energy (keV)': 12.6223},
                                                        'Lb3': {'weight': 0.06049,
                                                                'energy (keV)': 12.7944},
                                                        'M3O5': {'energy (keV)': 3.0472,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 15.2163},
                                                        'Lg1': {'weight': 0.08256,
                                                                'energy (keV)': 14.7648},
                                                        'Mz': {'weight': 0.0058,
                                                               'energy (keV)': 1.8395}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2484.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2586.0}}},
                   'General_properties': {'Z': 82,
                                          'atomic_weight': 207.2,
                                          'name': 'lead'}},
            'Pa': {'Physical_properties': {'density (g/cm^3)': 15.37},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4,
                                                                'energy (keV)': 16.7025},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 108.4272},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 95.8679},
                                                        'M2N4': {'weight': 0.00674,
                                                                 'energy (keV)': 4.2575},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 3.0823},
                                                        'Lb4': {'weight': 0.04,
                                                                'energy (keV)': 16.1037},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 13.2913},
                                                        'Ln': {'weight': 0.0126,
                                                               'energy (keV)': 14.9468},
                                                        'M3O4': {'energy (keV)': 4.07712,
                                                                 'weight': 0.01},
                                                        'Ll': {'weight': 0.0682,
                                                               'energy (keV)': 11.3662},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 3.24},
                                                        'Mg': {'weight': 0.33505,
                                                               'energy (keV)': 3.4656},
                                                        'Lb2': {'weight': 0.236,
                                                                'energy (keV)': 16.0249},
                                                        'Lb3': {'weight': 0.06,
                                                                'energy (keV)': 16.9308},
                                                        'M3O5': {'energy (keV)': 4.08456,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 20.0979},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 19.5703},
                                                        'Mz': {'weight': 0.03512,
                                                               'energy (keV)': 2.4351}}},
                   'General_properties': {'Z': 91,
                                          'atomic_weight': 231.03586,
                                          'name': 'protactinium'}},
            'Pd': {'Physical_properties': {'density (g/cm^3)': 12.023},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.34375,
                                                                'energy (keV)': 2.9903},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 23.8188},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 21.177},
                                                        'Lb2': {'weight': 0.10349,
                                                                'energy (keV)': 3.16828},
                                                        'Lb4': {'weight': 0.0407,
                                                                'energy (keV)': 3.0452},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.8386},
                                                        'Ln': {'weight': 0.0129,
                                                               'energy (keV)': 2.6604},
                                                        'Ll': {'weight': 0.0412,
                                                               'energy (keV)': 2.5034},
                                                        'Lb3': {'weight': 0.0682,
                                                                'energy (keV)': 3.0728},
                                                        'Lg3': {'weight': 0.0125,
                                                                'energy (keV)': 3.5532},
                                                        'Lg1': {'weight': 0.03256,
                                                                'energy (keV)': 3.32485}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 335.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 340.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 531.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 559.0}}},
                   'General_properties': {'Z': 46,
                                          'atomic_weight': 106.42,
                                          'name': 'palladium'}},
            'Cd': {'Physical_properties': {'density (g/cm^3)': 8.65},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.35704,
                                                                'energy (keV)': 3.3165},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 26.0947},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 23.1737},
                                                        'Lb2': {'weight': 0.1288,
                                                                'energy (keV)': 3.5282},
                                                        'Lb4': {'weight': 0.0469,
                                                                'energy (keV)': 3.3673},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 3.1338},
                                                        'Ln': {'weight': 0.0132,
                                                               'energy (keV)': 2.9568},
                                                        'Ll': {'weight': 0.04169,
                                                               'energy (keV)': 2.7673},
                                                        'Lb3': {'weight': 0.07719,
                                                                'energy (keV)': 3.4015},
                                                        'Lg3': {'weight': 0.0151,
                                                                'energy (keV)': 3.9511},
                                                        'Lg1': {'weight': 0.0416,
                                                                'energy (keV)': 3.7177}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 404.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 411.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 616.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 651.0}}},
                   'General_properties': {'Z': 48,
                                          'atomic_weight': 112.411,
                                          'name': 'cadmium'}},
            'Po': {'Physical_properties': {'density (g/cm^3)': 9.196},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.38536,
                                                                'energy (keV)': 13.4463},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 89.8031},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 79.2912},
                                                        'M2N4': {'weight': 0.00863,
                                                                 'energy (keV)': 3.3539},
                                                        'Lb4': {'weight': 0.05709,
                                                                'energy (keV)': 13.0852},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 11.1308},
                                                        'Ln': {'weight': 0.0133,
                                                               'energy (keV)': 12.0949},
                                                        'Ll': {'weight': 0.0607,
                                                               'energy (keV)': 9.6644},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.62266},
                                                        'Mg': {'weight': 0.21845,
                                                               'energy (keV)': 2.8285},
                                                        'Lb2': {'weight': 0.2289,
                                                                'energy (keV)': 13.3404},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 16.2343},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 15.7441},
                                                        'Lb3': {'weight': 0.0603,
                                                                'energy (keV)': 13.6374},
                                                        'Mz': {'weight': 0.00354,
                                                               'energy (keV)': 1.978}}},
                   'General_properties': {'Z': 84,
                                          'atomic_weight': 209,
                                          'name': 'polonium'}},
            'Pm': {'Physical_properties': {'density (g/cm^3)': 7.264},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4308,
                                                                'energy (keV)': 5.9613},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 43.8271},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 38.7247},
                                                        'M2N4': {'weight': 0.028,
                                                                 'energy (keV)': 1.351},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 0.9894},
                                                        'Lb4': {'weight': 0.07799,
                                                                'energy (keV)': 5.9565},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 5.4324},
                                                        'Ln': {'weight': 0.01479,
                                                               'energy (keV)': 5.3663},
                                                        'Ll': {'weight': 0.0448,
                                                               'energy (keV)': 4.8128},
                                                        'Mb': {'weight': 0.89,
                                                               'energy (keV)': 1.0475},
                                                        'Mg': {'weight': 0.4,
                                                               'energy (keV)': 1.2365},
                                                        'Lb2': {'weight': 0.196,
                                                                'energy (keV)': 6.3389},
                                                        'Lb3': {'weight': 0.1247,
                                                                'energy (keV)': 6.071},
                                                        'Lg3': {'weight': 0.0311,
                                                                'energy (keV)': 7.1919},
                                                        'Lg1': {'weight': 0.0784,
                                                                'energy (keV)': 6.8924},
                                                        'Mz': {'weight': 0.068,
                                                               'energy (keV)': 0.7909}}},
                   'General_properties': {'Z': 61,
                                          'atomic_weight': 145,
                                          'name': 'promethium'}},
            'Ho': {'Physical_properties': {'density (g/cm^3)': 8.795},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.45056,
                                                                'energy (keV)': 7.5263},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 53.8765},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 47.5466},
                                                        'M2N4': {'weight': 0.072,
                                                                 'energy (keV)': 1.7618},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.3477},
                                                        'Lb4': {'weight': 0.09039,
                                                                'energy (keV)': 7.4714},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 6.7197},
                                                        'Ln': {'weight': 0.0151,
                                                               'energy (keV)': 6.7895},
                                                        'Ll': {'weight': 0.04759,
                                                               'energy (keV)': 5.9428},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.3878},
                                                        'Mg': {'weight': 0.1418,
                                                               'energy (keV)': 1.5802},
                                                        'Lb2': {'weight': 0.23563,
                                                                'energy (keV)': 7.9101},
                                                        'Lb3': {'weight': 0.06,
                                                                'energy (keV)': 7.653},
                                                        'Lg3': {'weight': 0.0321,
                                                                'energy (keV)': 9.0876},
                                                        'Lg1': {'weight': 0.08448,
                                                                'energy (keV)': 8.7568},
                                                        'Mz': {'weight': 0.6629,
                                                               'energy (keV)': 1.0448}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1351.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1391.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1741.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1923.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 161.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 161.0}}},
                   'General_properties': {'Z': 67,
                                          'atomic_weight': 164.93032,
                                          'name': 'holmium'}},
            'Hf': {'Physical_properties': {'density (g/cm^3)': 13.31},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.46231,
                                                                'energy (keV)': 9.023},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 63.2432},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 55.7901},
                                                        'M2N4': {'weight': 0.01,
                                                                 'energy (keV)': 2.1416},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.6446},
                                                        'Lb4': {'weight': 0.10189,
                                                                'energy (keV)': 8.9053},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 7.899},
                                                        'Ln': {'weight': 0.0158,
                                                               'energy (keV)': 8.1385},
                                                        'Ll': {'weight': 0.05089,
                                                               'energy (keV)': 6.9598},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.6993},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 1.8939},
                                                        'Lb2': {'weight': 0.2048,
                                                                'energy (keV)': 9.347},
                                                        'Lb3': {'weight': 0.1316,
                                                                'energy (keV)': 9.1631},
                                                        'Lg3': {'weight': 0.0347,
                                                                'energy (keV)': 10.8903},
                                                        'Lg1': {'weight': 0.08968,
                                                                'energy (keV)': 10.5156},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 1.2813}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1662.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1716.0}}},
                   'General_properties': {'Z': 72,
                                          'atomic_weight': 178.49,
                                          'name': 'hafnium'}},
            'Hg': {'Physical_properties': {'density (g/cm^3)': 13.534},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.39504,
                                                                'energy (keV)': 11.8238},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 80.2552},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 70.8184},
                                                        'M2N4': {'weight': 0.02901,
                                                                 'energy (keV)': 2.9002},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 2.1964},
                                                        'Lb4': {'weight': 0.0566,
                                                                'energy (keV)': 11.5608},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 9.989},
                                                        'Ln': {'weight': 0.0136,
                                                               'energy (keV)': 10.6471},
                                                        'M3O4': {'energy (keV)': 2.8407,
                                                                 'weight': 0.005},
                                                        'Ll': {'weight': 0.05709,
                                                               'energy (keV)': 8.7223},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.2827},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 2.4873},
                                                        'Lb2': {'weight': 0.2221,
                                                                'energy (keV)': 11.9241},
                                                        'Lb3': {'weight': 0.06469,
                                                                'energy (keV)': 11.9922},
                                                        'M3O5': {'energy (keV)': 2.8407,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.0184,
                                                                'energy (keV)': 14.2683},
                                                        'Lg1': {'weight': 0.0832,
                                                                'energy (keV)': 13.8304},
                                                        'Mz': {'weight': 0.01344,
                                                               'energy (keV)': 1.7239}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2295.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2385.0}}},
                   'General_properties': {'Z': 80,
                                          'atomic_weight': 200.59,
                                          'name': 'mercury'}},
            'Mg': {'Physical_properties': {'density (g/cm^3)': 1.738},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.01,
                                                               'energy (keV)': 1.305},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 1.2536}},
                                         'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 1305.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 51.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 51.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 89.0}}},
                   'General_properties': {'Z': 12,
                                          'atomic_weight': 24.305,
                                          'name': 'magnesium'}},
            'K': {'Physical_properties': {'density (g/cm^3)': 0.856},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.1039,
                                                              'energy (keV)': 3.5896},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 3.3138}},
                                        'Binding_energies': {'L3': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 294.0},
                                                             'L2': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 296.0},
                                                             'L1a': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 377.0},
                                                             'L1': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 377.0}}},
                  'General_properties': {'Z': 19,
                                         'atomic_weight': 39.0983,
                                         'name': 'potassium'}},
            'Mn': {'Physical_properties': {'density (g/cm^3)': 7.47},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.1252,
                                                               'energy (keV)': 6.4904},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 5.8987},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 0.63316},
                                                        'Ln': {'weight': 0.1898,
                                                               'energy (keV)': 0.5675},
                                                        'Ll': {'weight': 0.3898,
                                                               'energy (keV)': 0.5564},
                                                        'Lb3': {'weight': 0.0263,
                                                                'energy (keV)': 0.7204}},
                                         'Binding_energies': {'M2': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 51.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 651.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 640.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 51.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 769.0}}},
                   'General_properties': {'Z': 25,
                                          'atomic_weight': 54.938045,
                                          'name': 'manganese'}},
            'O': {'Physical_properties': {'density (g/cm^3)': 0.001429},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                              'energy (keV)': 0.5249}},
                                        'Binding_energies': {'K': {'relevance': 'Major',
                                                                   'threshold': '',
                                                                   'edge': 'Abrupt onset',
                                                                   'onset_energy (eV)': 532.0}}},
                  'General_properties': {'Z': 8,
                                         'atomic_weight': 15.9994,
                                         'name': 'oxygen'}},
            'S': {'Physical_properties': {'density (g/cm^3)': 1.96},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.06525,
                                                              'energy (keV)': 2.46427},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 2.3072}},
                                        'Binding_energies': {'L2,3': {'relevance': 'Major',
                                                                    # overlaps
                                                                    # with L2
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 165.0},
                                                             'L1': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 229.0}}},
                  'General_properties': {'Z': 16,
                                         'atomic_weight': 32.065,
                                         'name': 'sulfur'}},
            'W': {'Physical_properties': {'density (g/cm^3)': 19.25},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.3679,
                                                               'energy (keV)': 9.6724},
                                                       'Kb': {'weight': 0.15,
                                                              'energy (keV)': 67.244},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 59.3182},
                                                       'M2N4': {'weight': 0.01,
                                                                'energy (keV)': 2.3161},
                                                       'Ma': {'weight': 1.0,
                                                              'energy (keV)': 1.7756},
                                                       'Lb4': {'weight': 0.05649,
                                                               'energy (keV)': 9.5249},
                                                       'La': {'weight': 1.0,
                                                              'energy (keV)': 8.3976},
                                                       'Ln': {'weight': 0.01155,
                                                              'energy (keV)': 8.7244},
                                                       'M3O4': {'energy (keV)': 2.2749,
                                                                'weight': 0.001},
                                                       'Ll': {'weight': 0.04169,
                                                              'energy (keV)': 7.3872},
                                                       'Mb': {'weight': 0.59443,
                                                              'energy (keV)': 1.8351},
                                                       'Mg': {'weight': 0.08505,
                                                              'energy (keV)': 2.0356},
                                                       'Lb2': {'weight': 0.21385,
                                                               'energy (keV)': 9.9614},
                                                       'Lb3': {'weight': 0.07077,
                                                               'energy (keV)': 9.8188},
                                                       'M3O5': {'energy (keV)': 2.281,
                                                                'weight': 0.01},
                                                       'Lg3': {'weight': 0.0362,
                                                               'energy (keV)': 11.6745},
                                                       'Lg1': {'weight': 0.05658,
                                                               'energy (keV)': 11.2852},
                                                       'Mz': {'weight': 0.01344,
                                                              'energy (keV)': 1.3839}},
                                        'Binding_energies': {'M5': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 1809.0},
                                                             'M4': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 1872.0}}},
                  'General_properties': {'Z': 74,
                                         'atomic_weight': 183.84,
                                         'name': 'tungsten'}},
            'Zn': {'Physical_properties': {'density (g/cm^3)': 7.14},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.1679,
                                                                'energy (keV)': 1.0347},
                                                        'Kb': {'weight': 0.12605,
                                                               'energy (keV)': 9.572},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 8.6389},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.0116},
                                                        'Ln': {'weight': 0.0368,
                                                               'energy (keV)': 0.9069},
                                                        'Ll': {'weight': 0.0603,
                                                               'energy (keV)': 0.8838},
                                                        'Lb3': {'weight': 0.002,
                                                                'energy (keV)': 1.107}},
                                         'Binding_energies': {'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 87.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1043.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1020.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 87.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1194.0}}},
                   'General_properties': {'Z': 30,
                                          'atomic_weight': 65.38,
                                          'name': 'zinc'}},
            'Eu': {'Physical_properties': {'density (g/cm^3)': 5.244},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43904,
                                                                'energy (keV)': 6.4565},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 47.0384},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 41.5421},
                                                        'M2N4': {'weight': 0.013,
                                                                 'energy (keV)': 1.4807},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.0991},
                                                        'Lb4': {'weight': 0.0874,
                                                                'energy (keV)': 6.4381},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 5.846},
                                                        'Ln': {'weight': 0.015,
                                                               'energy (keV)': 5.8171},
                                                        'Ll': {'weight': 0.04559,
                                                               'energy (keV)': 5.1769},
                                                        'Mb': {'weight': 0.87,
                                                               'energy (keV)': 1.15769},
                                                        'Mg': {'weight': 0.26,
                                                               'energy (keV)': 1.3474},
                                                        'Lb2': {'weight': 0.1985,
                                                                'energy (keV)': 6.8437},
                                                        'Lb3': {'weight': 0.1265,
                                                                'energy (keV)': 6.5714},
                                                        'Lg3': {'weight': 0.0318,
                                                                'energy (keV)': 7.7954},
                                                        'Lg1': {'weight': 0.08064,
                                                                'energy (keV)': 7.4839},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 0.8743}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1131.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1161.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1481.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1614.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 134.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 134.0}}},
                   'General_properties': {'Z': 63,
                                          'atomic_weight': 151.964,
                                          'name': 'europium'}},
            'Zr': {'Physical_properties': {'density (g/cm^3)': 6.511},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.37912,
                                                                'energy (keV)': 2.1243},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 17.6671},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 15.7753},
                                                        'Lb2': {'weight': 0.0177,
                                                                'energy (keV)': 2.2223},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.0423},
                                                        'Ln': {'weight': 0.0153,
                                                               'energy (keV)': 1.8764},
                                                        'Ll': {'weight': 0.04209,
                                                               'energy (keV)': 1.792},
                                                        'Lb3': {'weight': 0.05219,
                                                                'energy (keV)': 2.2011},
                                                        'Lg3': {'weight': 0.0082,
                                                                'energy (keV)': 2.5029},
                                                        'Lg1': {'weight': 0.006,
                                                                'energy (keV)': 2.30268}},
                                         'Binding_energies': {'M2': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 344.0},
                                                              'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 181.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 181.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2307.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2222.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 330.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 2532.0}}},
                   'General_properties': {'Z': 40,
                                          'atomic_weight': 91.224,
                                          'name': 'zirconium'}},
            'Er': {'Physical_properties': {'density (g/cm^3)': 9.066},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.45263,
                                                                'energy (keV)': 7.811},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 55.6737},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 49.1276},
                                                        'M2N4': {'weight': 0.0045,
                                                                 'energy (keV)': 1.8291},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.405},
                                                        'Lb4': {'weight': 0.0922,
                                                                'energy (keV)': 7.7455},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 6.9486},
                                                        'Ln': {'weight': 0.0153,
                                                               'energy (keV)': 7.0578},
                                                        'Ll': {'weight': 0.0482,
                                                               'energy (keV)': 6.1514},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.449},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 1.6442},
                                                        'Lb2': {'weight': 0.2005,
                                                                'energy (keV)': 8.1903},
                                                        'Lb3': {'weight': 0.1258,
                                                                'energy (keV)': 7.9395},
                                                        'Lg3': {'weight': 0.0324,
                                                                'energy (keV)': 9.4313},
                                                        'Lg1': {'weight': 0.08487,
                                                                'energy (keV)': 9.0876},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 1.0893}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1409.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1453.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1812.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 2006.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 168.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 168.0}}},
                   'General_properties': {'Z': 68,
                                          'atomic_weight': 167.259,
                                          'name': 'erbium'}},
            'Ni': {'Physical_properties': {'density (g/cm^3)': 8.908},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.1677,
                                                                'energy (keV)': 0.8683},
                                                        'Kb': {'weight': 0.1277,
                                                               'energy (keV)': 8.2647},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 7.4781},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 0.8511},
                                                        'Ln': {'weight': 0.09693,
                                                               'energy (keV)': 0.7601},
                                                        'Ll': {'weight': 0.14133,
                                                               'energy (keV)': 0.7429},
                                                        'Lb3': {'weight': 0.00199,
                                                                'energy (keV)': 0.94}},
                                         'Binding_energies': {'M2': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 68.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 872.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 855.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 68.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1008.0}}},
                   'General_properties': {'Z': 28,
                                          'atomic_weight': 58.6934,
                                          'name': 'nickel'}},
            'Na': {'Physical_properties': {'density (g/cm^3)': 0.968},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.01,
                                                               'energy (keV)': 1.0721},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 1.041}},
                                         'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 1072.0},
                                                              'L2,3': {'relevance': 'Major',
                                                                     # overlaps
                                                                     # with L2
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 31.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 63.0}}},
                   'General_properties': {'Z': 11,
                                          'atomic_weight': 22.98976928,
                                          'name': 'sodium'}},
            'Nb': {'Physical_properties': {'density (g/cm^3)': 8.57},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.32519,
                                                                'energy (keV)': 2.2573},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 18.6226},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 16.6151},
                                                        'Lb2': {'weight': 0.03299,
                                                                'energy (keV)': 2.3705},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.1659},
                                                        'Ln': {'weight': 0.0129,
                                                               'energy (keV)': 1.9963},
                                                        'Ll': {'weight': 0.04169,
                                                               'energy (keV)': 1.9021},
                                                        'Lb3': {'weight': 0.06429,
                                                                'energy (keV)': 2.3347},
                                                        'Lg3': {'weight': 0.0103,
                                                                'energy (keV)': 2.6638},
                                                        'Lg1': {'weight': 0.00975,
                                                                'energy (keV)': 2.4615}},
                                         'Binding_energies': {'M2': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 378.0},
                                                              'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 202.3},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 205.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2465.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2371.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 363.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 2698.0}}},
                   'General_properties': {'Z': 41,
                                          'atomic_weight': 92.90638,
                                          'name': 'niobium'}},
            'Nd': {'Physical_properties': {'density (g/cm^3)': 7.01},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.42672,
                                                                'energy (keV)': 5.722},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 42.2715},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 37.361},
                                                        'M2N4': {'weight': 0.052,
                                                                 'energy (keV)': 1.2853},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 0.9402},
                                                        'Lb4': {'weight': 0.0858,
                                                                'energy (keV)': 5.7232},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 5.2302},
                                                        'Ln': {'weight': 0.01469,
                                                               'energy (keV)': 5.1462},
                                                        'Ll': {'weight': 0.04429,
                                                               'energy (keV)': 4.6326},
                                                        'Mb': {'weight': 0.99,
                                                               'energy (keV)': 0.9965},
                                                        'Mg': {'weight': 0.625,
                                                               'energy (keV)': 1.1799},
                                                        'Lb2': {'weight': 0.1957,
                                                                'energy (keV)': 6.0904},
                                                        'Lb3': {'weight': 0.12869,
                                                                'energy (keV)': 5.8286},
                                                        'Lg3': {'weight': 0.0318,
                                                                'energy (keV)': 6.9014},
                                                        'Lg1': {'weight': 0.07712,
                                                                'energy (keV)': 6.604},
                                                        'Mz': {'weight': 0.069,
                                                               'energy (keV)': 0.7531}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 978.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1000.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1297.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1403.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 118.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 118.0}}},
                   'General_properties': {'Z': 60,
                                          'atomic_weight': 144.242,
                                          'name': 'neodymium'}},
            'Ne': {'Physical_properties': {'density (g/cm^3)': 0.0009},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.01,
                                                               'energy (keV)': 0.8669},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 0.8486}},
                                         'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 867.0}}},
                   'General_properties': {'Z': 10,
                                          'atomic_weight': 20.1791,
                                          'name': 'neon'}},
            'Fr': {'Physical_properties': {'density (g/cm^3)': 'NaN'},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.38327,
                                                                'energy (keV)': 14.7703},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 97.474},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 86.1058},
                                                        'M2N4': {'weight': 0.00674,
                                                                 'energy (keV)': 3.7237},
                                                        'Lb4': {'weight': 0.0603,
                                                                'energy (keV)': 14.312},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 12.0315},
                                                        'Ln': {'weight': 0.0134,
                                                               'energy (keV)': 13.2545},
                                                        'Ll': {'weight': 0.06339,
                                                               'energy (keV)': 10.3792},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.88971},
                                                        'Mg': {'weight': 0.21845,
                                                               'energy (keV)': 3.086},
                                                        'Lb2': {'weight': 0.2337,
                                                                'energy (keV)': 14.4542},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 17.829},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 17.3032},
                                                        'Lb3': {'weight': 0.05969,
                                                                'energy (keV)': 14.976},
                                                        'Mz': {'weight': 0.0058,
                                                               'energy (keV)': 2.1897}}},
                   'General_properties': {'Z': 87,
                                          'atomic_weight': 223,
                                          'name': 'francium'}},
            'Fe': {'Physical_properties': {'density (g/cm^3)': 7.874},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.1272,
                                                               'energy (keV)': 7.058},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 6.4039},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 0.7045},
                                                        'Ln': {'weight': 0.12525,
                                                               'energy (keV)': 0.6282},
                                                        'Ll': {'weight': 0.3086,
                                                               'energy (keV)': 0.6152},
                                                        'Lb3': {'weight': 0.02448,
                                                                'energy (keV)': 0.7921}},
                                         'Binding_energies': {'K': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                    'edge': '',
                                                                    'onset_energy (eV)': 7113.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 846.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 721.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 708.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 57.0},
                                                              'M2': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 57.0}}},
                   'General_properties': {'Z': 26,
                                          'atomic_weight': 55.845,
                                          'name': 'iron'}},
            'B': {'Physical_properties': {'density (g/cm^3)': 2.46},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                              'energy (keV)': 0.1833}},
                                        'Binding_energies': {'K': {'relevance': 'Major',
                                                                   'threshold': '',
                                                                   'edge': 'Abrupt onset',
                                                                   'onset_energy (eV)': 188.0}}},
                  'General_properties': {'Z': 5,
                                         'atomic_weight': 10.811,
                                         'name': 'boron'}},
            'F': {'Physical_properties': {'density (g/cm^3)': 0.001696},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                              'energy (keV)': 0.6768}},
                                        'Binding_energies': {'K': {'relevance': 'Major',
                                                                   'threshold': '',
                                                                   'edge': 'Abrupt onset',
                                                                   'onset_energy (eV)': 685.0}}},
                  'General_properties': {'Z': 9,
                                         'atomic_weight': 18.9984032,
                                         'name': 'fluorine'}},
            'Sr': {'Physical_properties': {'density (g/cm^3)': 2.63},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.37975,
                                                                'energy (keV)': 1.8718},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 15.8355},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 14.165},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.8065},
                                                        'Ln': {'weight': 0.01669,
                                                               'energy (keV)': 1.6493},
                                                        'Ll': {'weight': 0.04309,
                                                               'energy (keV)': 1.5821},
                                                        'Lb3': {'weight': 0.047,
                                                                'energy (keV)': 1.9472},
                                                        'Lg3': {'weight': 0.0065,
                                                                'energy (keV)': 2.1964}},
                                         'Binding_energies': {'M2': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 280.0},
                                                              'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 134.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 134.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2007.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1940.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 269.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 2216.0}}},
                   'General_properties': {'Z': 38,
                                          'atomic_weight': 87.62,
                                          'name': 'strontium'}},
            'N': {'Physical_properties': {'density (g/cm^3)': 0.001251},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'weight': 1.0,
                                                              'energy (keV)': 0.3924}},
                                        'Binding_energies': {'K': {'relevance': 'Major',
                                                                   'threshold': '',
                                                                   'edge': 'Abrupt onset',
                                                                   'onset_energy (eV)': 401.0}}},
                  'General_properties': {'Z': 7,
                                         'atomic_weight': 14.0067,
                                         'name': 'nitrogen'}},
            'Kr': {'Physical_properties': {'density (g/cm^3)': 0.00375},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.39031,
                                                                'energy (keV)': 1.6383},
                                                        'Kb': {'weight': 0.1538,
                                                               'energy (keV)': 14.1118},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 12.6507},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.586},
                                                        'Ln': {'weight': 0.0175,
                                                               'energy (keV)': 1.43887},
                                                        'Ll': {'weight': 0.04509,
                                                               'energy (keV)': 1.38657},
                                                        'Lb3': {'weight': 0.0465,
                                                                'energy (keV)': 1.7072},
                                                        'Lg3': {'weight': 0.005,
                                                                'energy (keV)': 1.921}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 89.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 89.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1727.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1675.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1921.0}}},
                   'General_properties': {'Z': 36,
                                          'atomic_weight': 83.798,
                                          'name': 'krypton'}},
            'Si': {'Physical_properties': {'density (g/cm^3)': 2.33},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.02779,
                                                               'energy (keV)': 1.8389},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 1.7397}},
                                         'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 1839.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 99.8},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 99.2},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 149.7}}},
                   'General_properties': {'Z': 14,
                                          'atomic_weight': 28.0855,
                                          'name': 'silicon'}},
            'Sn': {'Physical_properties': {'density (g/cm^3)': 7.31},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43456,
                                                                'energy (keV)': 3.6628},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 28.4857},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 25.2713},
                                                        'Lb2': {'weight': 0.14689,
                                                                'energy (keV)': 3.9049},
                                                        'Lb4': {'weight': 0.0948,
                                                                'energy (keV)': 3.7083},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 3.444},
                                                        'Ln': {'weight': 0.0158,
                                                               'energy (keV)': 3.2723},
                                                        'Ll': {'weight': 0.0416,
                                                               'energy (keV)': 3.045},
                                                        'Lb3': {'weight': 0.1547,
                                                                'energy (keV)': 3.7503},
                                                        'Lg3': {'weight': 0.0321,
                                                                'energy (keV)': 4.3761},
                                                        'Lg1': {'weight': 0.058,
                                                                'energy (keV)': 4.1322}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 485.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 494.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 714.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 756.0}}},
                   'General_properties': {'Z': 50,
                                          'atomic_weight': 118.71,
                                          'name': 'tin'}},
            'Sm': {'Physical_properties': {'density (g/cm^3)': 7.353},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43512,
                                                                'energy (keV)': 6.2058},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 45.4144},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 40.118},
                                                        'M2N4': {'weight': 0.012,
                                                                 'energy (keV)': 1.4117},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.0428},
                                                        'Lb4': {'weight': 0.08689,
                                                                'energy (keV)': 6.1961},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 5.636},
                                                        'Ln': {'weight': 0.01489,
                                                               'energy (keV)': 5.589},
                                                        'Ll': {'weight': 0.04519,
                                                               'energy (keV)': 4.9934},
                                                        'Mb': {'weight': 0.88,
                                                               'energy (keV)': 1.1005},
                                                        'Mg': {'weight': 0.26,
                                                               'energy (keV)': 1.2908},
                                                        'Lb2': {'weight': 0.19769,
                                                                'energy (keV)': 6.5872},
                                                        'Lb3': {'weight': 0.12669,
                                                                'energy (keV)': 6.317},
                                                        'Lg3': {'weight': 0.0318,
                                                                'energy (keV)': 7.4894},
                                                        'Lg1': {'weight': 0.07951,
                                                                'energy (keV)': 7.1828},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 0.8328}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1080.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1106.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1420.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1541.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 130.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 130.0}}},
                   'General_properties': {'Z': 62,
                                          'atomic_weight': 150.36,
                                          'name': 'samarium'}},
            'V': {'Physical_properties': {'density (g/cm^3)': 6.11},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.1225,
                                                              'energy (keV)': 5.4273},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 4.9522},
                                                       'La': {'weight': 1.0,
                                                              'energy (keV)': 0.5129},
                                                       'Ln': {'weight': 0.2805,
                                                              'energy (keV)': 0.454},
                                                       'Ll': {'weight': 0.5745,
                                                              'energy (keV)': 0.4464},
                                                       'Lb3': {'weight': 0.0154,
                                                               'energy (keV)': 0.5904}},
                                        'Binding_energies': {'M2': {'relevance': 'Major',
                                                                    'threshold': 'Broad peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 38.0},
                                                             'L2': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 521.0},
                                                             'L3': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 513.0},
                                                             'M3': {'relevance': 'Major',
                                                                    'threshold': 'Broad peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 38.0},
                                                             'L1': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 628.0}}},
                  'General_properties': {'Z': 23,
                                         'atomic_weight': 50.9415,
                                         'name': 'vanadium'}},
            'Sc': {'Physical_properties': {'density (g/cm^3)': 2.985},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.12839,
                                                               'energy (keV)': 4.4605},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 4.0906},
                                                        'La': {'weight': 0.308,
                                                               'energy (keV)': 0.4022},
                                                        'Ln': {'weight': 0.488,
                                                               'energy (keV)': 0.3529},
                                                        'Ll': {'weight': 1.0,
                                                               'energy (keV)': 0.3484},
                                                        'Lb3': {'weight': 0.037,
                                                                'energy (keV)': 0.4681}},
                                         'Binding_energies': {'M2': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 32.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 407.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 402.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 32.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 500.0}}},
                   'General_properties': {'Z': 21,
                                          'atomic_weight': 44.955912,
                                          'name': 'scandium'}},
            'Sb': {'Physical_properties': {'density (g/cm^3)': 6.697},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4276,
                                                                'energy (keV)': 3.8435},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 29.7256},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 26.359},
                                                        'Lb2': {'weight': 0.1556,
                                                                'energy (keV)': 4.1008},
                                                        'Lb4': {'weight': 0.0932,
                                                                'energy (keV)': 3.8864},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 3.6047},
                                                        'Ln': {'weight': 0.0155,
                                                               'energy (keV)': 3.4367},
                                                        'Ll': {'weight': 0.0419,
                                                               'energy (keV)': 3.1885},
                                                        'Lb3': {'weight': 0.15099,
                                                                'energy (keV)': 3.9327},
                                                        'Lg3': {'weight': 0.0321,
                                                                'energy (keV)': 4.5999},
                                                        'Lg1': {'weight': 0.06064,
                                                                'energy (keV)': 4.349}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 528.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 537.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 766.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 812.0}}},
                   'General_properties': {'Z': 51,
                                          'atomic_weight': 121.76,
                                          'name': 'antimony'}},
            'Se': {'Physical_properties': {'density (g/cm^3)': 4.819},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.38848,
                                                                'energy (keV)': 1.4195},
                                                        'Kb': {'weight': 0.1505,
                                                               'energy (keV)': 12.4959},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 11.222},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.3791},
                                                        'Ln': {'weight': 0.0187,
                                                               'energy (keV)': 1.2447},
                                                        'Ll': {'weight': 0.04759,
                                                               'energy (keV)': 1.2043},
                                                        'Lb3': {'weight': 0.047,
                                                                'energy (keV)': 1.492}},
                                         'Binding_energies': {'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1476.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1436.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1654.0}}},
                   'General_properties': {'Z': 34,
                                          'atomic_weight': 78.96,
                                          'name': 'selenium'}},
            'Co': {'Physical_properties': {'density (g/cm^3)': 8.9},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.1277,
                                                               'energy (keV)': 7.6494},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 6.9303},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 0.7757},
                                                        'Ln': {'weight': 0.0833,
                                                               'energy (keV)': 0.6929},
                                                        'Ll': {'weight': 0.2157,
                                                               'energy (keV)': 0.6779},
                                                        'Lb3': {'weight': 0.0238,
                                                                'energy (keV)': 0.8661}},
                                         'Binding_energies': {'M2': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 59.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 794.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 779.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 59.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 926.0}}},
                   'General_properties': {'Z': 27,
                                          'atomic_weight': 58.933195,
                                          'name': 'cobalt'}},
            'Cl': {'Physical_properties': {'density (g/cm^3)': 0.003214},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.0838,
                                                               'energy (keV)': 2.8156},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 2.6224}},
                                         'Binding_energies': {'L2,3': {'relevance': 'Major',
                                                                     # overlaps
                                                                     # with L2
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 200.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 270.0}}},
                   'General_properties': {'Z': 17,
                                          'atomic_weight': 35.453,
                                          'name': 'chlorine'}},
            'Ca': {'Physical_properties': {'density (g/cm^3)': 1.55},
                   'Atomic_properties': {'Xray_lines': {'Ln': {'weight': 0.23,
                                                               'energy (keV)': 0.3063},
                                                        'Kb': {'weight': 0.112,
                                                               'energy (keV)': 4.0127},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 3.6917},
                                                        'Ll': {'weight': 1.0,
                                                               'energy (keV)': 0.3027},
                                                        'La': {'weight': 0.0,
                                                               'energy (keV)': 0.3464}},
                                         'Binding_energies': {'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 350.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 346.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 438.0}}},
                   'General_properties': {'Z': 20,
                                          'atomic_weight': 40.078,
                                          'name': 'calcium'}},
            'Ce': {'Physical_properties': {'density (g/cm^3)': 6.689},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43,
                                                                'energy (keV)': 5.2629},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 39.2576},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 34.7196},
                                                        'M2N4': {'weight': 0.08,
                                                                 'energy (keV)': 1.1628},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 0.8455},
                                                        'Lb4': {'weight': 0.08699,
                                                                'energy (keV)': 5.276},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 4.8401},
                                                        'Ln': {'weight': 0.015,
                                                               'energy (keV)': 4.7296},
                                                        'Ll': {'weight': 0.0436,
                                                               'energy (keV)': 4.2888},
                                                        'Mb': {'weight': 0.91,
                                                               'energy (keV)': 0.8154},
                                                        'Mg': {'weight': 0.5,
                                                               'energy (keV)': 1.0754},
                                                        'Lb2': {'weight': 0.19399,
                                                                'energy (keV)': 5.6134},
                                                        'Lb3': {'weight': 0.1325,
                                                                'energy (keV)': 5.3634},
                                                        'Lg3': {'weight': 0.0324,
                                                                'energy (keV)': 6.3416},
                                                        'Lg1': {'weight': 0.0764,
                                                                'energy (keV)': 6.0542},
                                                        'Mz': {'weight': 0.07,
                                                               'energy (keV)': 0.6761}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 883.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 901.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1185.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1273.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 110.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 110.0}}},
                   'General_properties': {'Z': 58,
                                          'atomic_weight': 140.116,
                                          'name': 'cerium'}},
            'Xe': {'Physical_properties': {'density (g/cm^3)': 0.0059},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.42248,
                                                                'energy (keV)': 4.4183},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 33.6244},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 29.7792},
                                                        'Lb2': {'weight': 0.17699,
                                                                'energy (keV)': 4.7182},
                                                        'Lb4': {'weight': 0.08929,
                                                                'energy (keV)': 4.4538},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 4.1099},
                                                        'Ln': {'weight': 0.015,
                                                               'energy (keV)': 3.9591},
                                                        'Ll': {'weight': 0.0424,
                                                               'energy (keV)': 3.6376},
                                                        'Lb3': {'weight': 0.14119,
                                                                'energy (keV)': 4.5158},
                                                        'Lg3': {'weight': 0.0323,
                                                                'energy (keV)': 5.3061},
                                                        'Lg1': {'weight': 0.06848,
                                                                'energy (keV)': 5.0397}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 672.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 685.0}}},
                   'General_properties': {'Z': 54,
                                          'atomic_weight': 131.293,
                                          'name': 'xenon'}},
            'Tm': {'Physical_properties': {'density (g/cm^3)': 9.321},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.45831,
                                                                'energy (keV)': 8.1023},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 57.5051},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 50.7416},
                                                        'M2N4': {'weight': 0.01,
                                                                 'energy (keV)': 1.9102},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.4624},
                                                        'Lb4': {'weight': 0.09449,
                                                                'energy (keV)': 8.0259},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 7.1803},
                                                        'Ln': {'weight': 0.0156,
                                                               'energy (keV)': 7.3101},
                                                        'Ll': {'weight': 0.04889,
                                                               'energy (keV)': 6.3412},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.5093},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 1.7049},
                                                        'Lb2': {'weight': 0.20059,
                                                                'energy (keV)': 8.4684},
                                                        'Lb3': {'weight': 0.1273,
                                                                'energy (keV)': 8.2312},
                                                        'Lg3': {'weight': 0.0329,
                                                                'energy (keV)': 9.7791},
                                                        'Lg1': {'weight': 0.08615,
                                                                'energy (keV)': 9.4373},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 1.1311}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1468.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1515.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1884.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 2090.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 180.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 180.0}}},
                   'General_properties': {'Z': 69,
                                          'atomic_weight': 168.93421,
                                          'name': 'thulium'}},
            'Cs': {'Physical_properties': {'density (g/cm^3)': 1.879},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.42983,
                                                                'energy (keV)': 4.6199},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 34.987},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 30.9727},
                                                        'Lb2': {'weight': 0.19589,
                                                                'energy (keV)': 4.9354},
                                                        'Lb4': {'weight': 0.08869,
                                                                'energy (keV)': 4.6493},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 4.2864},
                                                        'Ln': {'weight': 0.0152,
                                                               'energy (keV)': 4.1423},
                                                        'Ll': {'weight': 0.04269,
                                                               'energy (keV)': 3.7948},
                                                        'Lb3': {'weight': 0.1399,
                                                                'energy (keV)': 4.7167},
                                                        'Lg3': {'weight': 0.0325,
                                                                'energy (keV)': 5.5527},
                                                        'Lg1': {'weight': 0.07215,
                                                                'energy (keV)': 5.2806}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 726.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 740.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 998.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1065.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 78.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 78.0}}},
                   'General_properties': {'Z': 55,
                                          'atomic_weight': 132.9054519,
                                          'name': 'cesium'}},
            'Cr': {'Physical_properties': {'density (g/cm^3)': 7.14},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.134,
                                                               'energy (keV)': 5.9467},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 5.4147},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 0.5722},
                                                        'Ln': {'weight': 0.2353,
                                                               'energy (keV)': 0.5096},
                                                        'Ll': {'weight': 0.6903,
                                                               'energy (keV)': 0.5004},
                                                        'Lb3': {'weight': 0.0309,
                                                                'energy (keV)': 0.6521}},
                                         'Binding_energies': {'M2': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 43.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 584.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 575.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 43.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 695.0}}},
                   'General_properties': {'Z': 24,
                                          'atomic_weight': 51.9961,
                                          'name': 'chromium'}},
            'Cu': {'Physical_properties': {'density (g/cm^3)': 8.92},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.03197,
                                                                'energy (keV)': 0.9494},
                                                        'Kb': {'weight': 0.13157,
                                                               'energy (keV)': 8.9053},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 8.0478},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 0.9295},
                                                        'Ln': {'weight': 0.01984,
                                                               'energy (keV)': 0.8312},
                                                        'Ll': {'weight': 0.08401,
                                                               'energy (keV)': 0.8113},
                                                        'Lb3': {'weight': 0.00114,
                                                                'energy (keV)': 1.0225}},
                                         'Binding_energies': {'M2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 74.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 951.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 931.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 74.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1096.0}}},
                   'General_properties': {'Z': 29,
                                          'atomic_weight': 63.546,
                                          'name': 'copper'}},
            'La': {'Physical_properties': {'density (g/cm^3)': 6.146},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.42631,
                                                                'energy (keV)': 5.0421},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 37.8012},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 33.4419},
                                                        'M2N4': {'weight': 0.022,
                                                                 'energy (keV)': 1.1055},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 0.8173},
                                                        'Lb4': {'weight': 0.0872,
                                                                'energy (keV)': 5.0619},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 4.651},
                                                        'Ln': {'weight': 0.015,
                                                               'energy (keV)': 4.5293},
                                                        'Ll': {'weight': 0.0432,
                                                               'energy (keV)': 4.1214},
                                                        'Mb': {'weight': 0.9,
                                                               'energy (keV)': 0.8162},
                                                        'Mg': {'weight': 0.4,
                                                               'energy (keV)': 1.0245},
                                                        'Lb2': {'weight': 0.19579,
                                                                'energy (keV)': 5.3838},
                                                        'Lb3': {'weight': 0.1341,
                                                                'energy (keV)': 5.1429},
                                                        'Lg3': {'weight': 0.0329,
                                                                'energy (keV)': 6.0749},
                                                        'Lg1': {'weight': 0.07656,
                                                                'energy (keV)': 5.7917},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 0.6403}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 832.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 849.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1123.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1204.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 99.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 99.0}}},
                   'General_properties': {'Z': 57,
                                          'atomic_weight': 138.90547,
                                          'name': 'lanthanum'}},
            'Li': {'Physical_properties': {'density (g/cm^3)': 0.534},
                   'Atomic_properties': {'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 55.0}}},
                   'General_properties': {'atomic_weight': 6.939,
                                          'Z': 3,
                                          'name': 'lithium'}},
            'Tl': {'Physical_properties': {'density (g/cm^3)': 11.85},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.39112,
                                                                'energy (keV)': 12.2128},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 82.5738},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 72.8729},
                                                        'M2N4': {'weight': 0.00863,
                                                                 'energy (keV)': 3.0091},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 2.2708},
                                                        'Lb4': {'weight': 0.05419,
                                                                'energy (keV)': 11.931},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 10.2682},
                                                        'Ln': {'weight': 0.0134,
                                                               'energy (keV)': 10.9938},
                                                        'M3O4': {'energy (keV)': 2.9413,
                                                                 'weight': 0.005},
                                                        'Ll': {'weight': 0.0578,
                                                               'energy (keV)': 8.9534},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.3623},
                                                        'Mg': {'weight': 0.21845,
                                                               'energy (keV)': 2.5704},
                                                        'Lb2': {'weight': 0.22289,
                                                                'energy (keV)': 12.2713},
                                                        'Lb3': {'weight': 0.0607,
                                                                'energy (keV)': 12.3901},
                                                        'M3O5': {'energy (keV)': 2.9435,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.0175,
                                                                'energy (keV)': 14.7377},
                                                        'Lg1': {'weight': 0.08304,
                                                                'energy (keV)': 14.2913},
                                                        'Mz': {'weight': 0.0058,
                                                               'energy (keV)': 1.7803}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2389.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2485.0}}},
                   'General_properties': {'Z': 81,
                                          'atomic_weight': 204.3833,
                                          'name': 'thallium'}},
            'Lu': {'Physical_properties': {'density (g/cm^3)': 9.841},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.46975,
                                                                'energy (keV)': 8.7092},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 61.2902},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 54.0697},
                                                        'M2N4': {'weight': 0.01,
                                                                 'energy (keV)': 2.0587},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.5816},
                                                        'Lb4': {'weight': 0.0996,
                                                                'energy (keV)': 8.6069},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 7.6556},
                                                        'Ln': {'weight': 0.016,
                                                               'energy (keV)': 7.8574},
                                                        'Ll': {'weight': 0.05009,
                                                               'energy (keV)': 6.7529},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.6325},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 1.8286},
                                                        'Lb2': {'weight': 0.20359,
                                                                'energy (keV)': 9.0491},
                                                        'Lb3': {'weight': 0.13099,
                                                                'energy (keV)': 8.8468},
                                                        'Lg3': {'weight': 0.0342,
                                                                'energy (keV)': 10.5111},
                                                        'Lg1': {'weight': 0.08968,
                                                                'energy (keV)': 10.1438},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 1.2292}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1588.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1639.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 2024.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 2263.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Very delayed',
                                                                     'onset_energy (eV)': 195.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Very delayed',
                                                                     'onset_energy (eV)': 195.0}}},
                   'General_properties': {'Z': 71,
                                          'atomic_weight': 174.9668,
                                          'name': 'lutetium'}},
            'Th': {'Physical_properties': {'density (g/cm^3)': 11.724},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4,
                                                                'energy (keV)': 16.2024},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 105.6049},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 93.3507},
                                                        'M2N4': {'weight': 0.00674,
                                                                 'energy (keV)': 4.1163},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 2.9968},
                                                        'Lb4': {'weight': 0.05,
                                                                'energy (keV)': 15.6417},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 12.9683},
                                                        'Ln': {'weight': 0.0134,
                                                               'energy (keV)': 14.5109},
                                                        'M3O4': {'energy (keV)': 3.9518,
                                                                 'weight': 0.01},
                                                        'Ll': {'weight': 0.06709,
                                                               'energy (keV)': 11.118},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 3.1464},
                                                        'Mg': {'weight': 0.33505,
                                                               'energy (keV)': 3.3697},
                                                        'Lb2': {'weight': 0.236,
                                                                'energy (keV)': 15.6239},
                                                        'Lb3': {'weight': 0.06,
                                                                'energy (keV)': 16.426},
                                                        'M3O5': {'energy (keV)': 3.9582,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 19.5048},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 18.9791},
                                                        'Mz': {'weight': 0.03512,
                                                               'energy (keV)': 2.3647}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 3332.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 3491.0},
                                                              'O5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 83.0},
                                                              'O4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 83.0}}},
                   'General_properties': {'Z': 90,
                                          'atomic_weight': 232.03806,
                                          'name': 'thorium'}},
            'Ti': {'Physical_properties': {'density (g/cm^3)': 4.507},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.11673,
                                                               'energy (keV)': 4.9318},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 4.5109},
                                                        'La': {'weight': 0.694,
                                                               'energy (keV)': 0.4555},
                                                        'Ln': {'weight': 0.491,
                                                               'energy (keV)': 0.4012},
                                                        'Ll': {'weight': 1.0,
                                                               'energy (keV)': 0.3952},
                                                        'Lb3': {'weight': 0.166,
                                                                'energy (keV)': 0.5291}},
                                         'Binding_energies': {'M2': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 35.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 462.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 456.0},
                                                              'M3': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 35.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 564.0}}},
                   'General_properties': {'Z': 22,
                                          'atomic_weight': 47.867,
                                          'name': 'titanium'}},
            'Te': {'Physical_properties': {'density (g/cm^3)': 6.24},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43183,
                                                                'energy (keV)': 4.0295},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 30.9951},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 27.4724},
                                                        'Lb2': {'weight': 0.16269,
                                                                'energy (keV)': 4.3016},
                                                        'Lb4': {'weight': 0.0906,
                                                                'energy (keV)': 4.0695},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 3.7693},
                                                        'Ln': {'weight': 0.0154,
                                                               'energy (keV)': 3.606},
                                                        'Ll': {'weight': 0.0419,
                                                               'energy (keV)': 3.3354},
                                                        'Lb3': {'weight': 0.1458,
                                                                'energy (keV)': 4.1205},
                                                        'Lg3': {'weight': 0.0317,
                                                                'energy (keV)': 4.829},
                                                        'Lg1': {'weight': 0.06375,
                                                                'energy (keV)': 4.5722}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 572.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 582.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 819.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 870.0}}},
                   'General_properties': {'Z': 52,
                                          'atomic_weight': 127.6,
                                          'name': 'tellurium'}},
            'Tb': {'Physical_properties': {'density (g/cm^3)': 8.219},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.44104,
                                                                'energy (keV)': 6.9766},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 50.3844},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 44.4817},
                                                        'M2N4': {'weight': 0.014,
                                                                 'energy (keV)': 1.6207},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.2326},
                                                        'Lb4': {'weight': 0.0874,
                                                                'energy (keV)': 6.9403},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 6.2728},
                                                        'Ln': {'weight': 0.01479,
                                                               'energy (keV)': 6.2841},
                                                        'Ll': {'weight': 0.0465,
                                                               'energy (keV)': 5.5465},
                                                        'Mb': {'weight': 0.78,
                                                               'energy (keV)': 1.2656},
                                                        'Mg': {'weight': 0.2615,
                                                               'energy (keV)': 1.4643},
                                                        'Lb2': {'weight': 0.19929,
                                                                'energy (keV)': 7.367},
                                                        'Lb3': {'weight': 0.124,
                                                                'energy (keV)': 7.0967},
                                                        'Lg3': {'weight': 0.0315,
                                                                'energy (keV)': 8.423},
                                                        'Lg1': {'weight': 0.08168,
                                                                'energy (keV)': 8.1046},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 0.9562}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1241.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1275.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1611.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1768.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 148.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 148.0}}},
                   'General_properties': {'Z': 65,
                                          'atomic_weight': 158.92535,
                                          'name': 'terbium'}},
            'Tc': {'Physical_properties': {'density (g/cm^3)': 11.5},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.32951,
                                                                'energy (keV)': 2.5368},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 20.619},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 18.3671},
                                                        'Lb2': {'weight': 0.05839,
                                                                'energy (keV)': 2.67017},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.424},
                                                        'Ln': {'weight': 0.0127,
                                                               'energy (keV)': 2.2456},
                                                        'Ll': {'weight': 0.0412,
                                                               'energy (keV)': 2.1293},
                                                        'Lb3': {'weight': 0.0644,
                                                                'energy (keV)': 2.6175},
                                                        'Lg3': {'weight': 0.0111,
                                                                'energy (keV)': 3.0036},
                                                        'Lg1': {'weight': 0.01744,
                                                                'energy (keV)': 2.78619}}},
                   'General_properties': {'Z': 43,
                                          'atomic_weight': 98,
                                          'name': 'technetium'}},
            'Ta': {'Physical_properties': {'density (g/cm^3)': 16.65},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.46248,
                                                                'energy (keV)': 9.3429},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 65.2224},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 57.5353},
                                                        'M2N4': {'weight': 0.01,
                                                                 'energy (keV)': 2.2274},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.7101},
                                                        'Lb4': {'weight': 0.10449,
                                                                'energy (keV)': 9.2128},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 8.146},
                                                        'Ln': {'weight': 0.0158,
                                                               'energy (keV)': 8.4281},
                                                        'M3O4': {'energy (keV)': 2.1883,
                                                                 'weight': 0.0001},
                                                        'Ll': {'weight': 0.0515,
                                                               'energy (keV)': 7.1731},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.7682},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 1.9647},
                                                        'Lb2': {'weight': 0.2076,
                                                                'energy (keV)': 9.6518},
                                                        'Lb3': {'weight': 0.1333,
                                                                'energy (keV)': 9.4875},
                                                        'M3O5': {'energy (keV)': 2.194,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.0354,
                                                                'energy (keV)': 11.277},
                                                        'Lg1': {'weight': 0.09071,
                                                                'energy (keV)': 10.8948},
                                                        'Mz': {'weight': 0.01344,
                                                               'energy (keV)': 1.3306}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1735.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1793.0}}},
                   'General_properties': {'Z': 73,
                                          'atomic_weight': 180.94788,
                                          'name': 'tantalum'}},
            'Yb': {'Physical_properties': {'density (g/cm^3)': 6.57},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.46224,
                                                                'energy (keV)': 8.4019},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 59.3825},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 52.3887},
                                                        'M2N4': {'weight': 0.01,
                                                                 'energy (keV)': 1.9749},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.5215},
                                                        'Lb4': {'weight': 0.09589,
                                                                'energy (keV)': 8.3134},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 7.4158},
                                                        'Ln': {'weight': 0.0157,
                                                               'energy (keV)': 7.5801},
                                                        'Ll': {'weight': 0.0494,
                                                               'energy (keV)': 6.5455},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 1.57},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 1.7649},
                                                        'Lb2': {'weight': 0.2017,
                                                                'energy (keV)': 8.7587},
                                                        'Lb3': {'weight': 0.12789,
                                                                'energy (keV)': 8.5366},
                                                        'Lg3': {'weight': 0.0331,
                                                                'energy (keV)': 10.1429},
                                                        'Lg1': {'weight': 0.08728,
                                                                'energy (keV)': 9.7801},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 1.1843}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1528.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1576.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1950.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 2173.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 184.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 184.0}}},
                   'General_properties': {'Z': 70,
                                          'atomic_weight': 173.054,
                                          'name': 'ytterbium'}},
            'Dy': {'Physical_properties': {'density (g/cm^3)': 8.551},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.444,
                                                                'energy (keV)': 7.2481},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 52.1129},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 45.9984},
                                                        'M2N4': {'weight': 0.008,
                                                                 'energy (keV)': 1.6876},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.2907},
                                                        'Lb4': {'weight': 0.0891,
                                                                'energy (keV)': 7.204},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 6.4952},
                                                        'Ln': {'weight': 0.01489,
                                                               'energy (keV)': 6.5338},
                                                        'Ll': {'weight': 0.0473,
                                                               'energy (keV)': 5.7433},
                                                        'Mb': {'weight': 0.76,
                                                               'energy (keV)': 1.3283},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 1.5214},
                                                        'Lb2': {'weight': 0.2,
                                                                'energy (keV)': 7.6359},
                                                        'Lb3': {'weight': 0.12529,
                                                                'energy (keV)': 7.3702},
                                                        'Lg3': {'weight': 0.0319,
                                                                'energy (keV)': 8.7529},
                                                        'Lg1': {'weight': 0.08295,
                                                                'energy (keV)': 8.4264},
                                                        'Mz': {'weight': 0.06,
                                                               'energy (keV)': 1.002}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1295.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1332.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1676.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 1842.0},
                                                              'N4': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 154.0},
                                                              'N5': {'relevance': 'Major',
                                                                     'threshold': 'Broad peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 154.0}}},
                   'General_properties': {'Z': 66,
                                          'atomic_weight': 162.5,
                                          'name': 'dysprosium'}},
            'I': {'Physical_properties': {'density (g/cm^3)': 4.94},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.43087,
                                                               'energy (keV)': 4.2208},
                                                       'Kb': {'weight': 0.15,
                                                              'energy (keV)': 32.2948},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 28.6123},
                                                       'Lb2': {'weight': 0.17059,
                                                               'energy (keV)': 4.5075},
                                                       'Lb4': {'weight': 0.09189,
                                                               'energy (keV)': 4.2576},
                                                       'La': {'weight': 1.0,
                                                              'energy (keV)': 3.9377},
                                                       'Ln': {'weight': 0.0154,
                                                              'energy (keV)': 3.78},
                                                       'Ll': {'weight': 0.0423,
                                                              'energy (keV)': 3.485},
                                                       'Lb3': {'weight': 0.1464,
                                                               'energy (keV)': 4.3135},
                                                       'Lg3': {'weight': 0.0327,
                                                               'energy (keV)': 5.0654},
                                                       'Lg1': {'weight': 0.06704,
                                                               'energy (keV)': 4.8025}},
                                        'Binding_energies': {'M5': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 620.0},
                                                             'M4': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 631.0},
                                                             'M3': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 875.0},
                                                             'M2': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                    'edge': '',
                                                                    'onset_energy (eV)': 930.0}}},
                  'General_properties': {'Z': 53,
                                         'atomic_weight': 126.90447,
                                         'name': 'iodine'}},
            'U': {'Physical_properties': {'density (g/cm^3)': 19.05},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4,
                                                               'energy (keV)': 17.22},
                                                       'Kb': {'weight': 0.15,
                                                              'energy (keV)': 111.3026},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 98.4397},
                                                       'M2N4': {'weight': 0.00674,
                                                                'energy (keV)': 4.4018},
                                                       'Ma': {'weight': 1.0,
                                                              'energy (keV)': 3.1708},
                                                       'Lb4': {'weight': 0.04,
                                                               'energy (keV)': 16.5752},
                                                       'La': {'weight': 1.0,
                                                              'energy (keV)': 13.6146},
                                                       'Ln': {'weight': 0.01199,
                                                              'energy (keV)': 15.3996},
                                                       'M3O4': {'energy (keV)': 4.1984,
                                                                'weight': 0.01},
                                                       'Ll': {'weight': 0.069,
                                                              'energy (keV)': 11.6183},
                                                       'Mb': {'weight': 0.6086,
                                                              'energy (keV)': 3.3363},
                                                       'Mg': {'weight': 0.33505,
                                                              'energy (keV)': 3.5657},
                                                       'Lb2': {'weight': 0.236,
                                                               'energy (keV)': 16.4286},
                                                       'Lb3': {'weight': 0.06,
                                                               'energy (keV)': 17.454},
                                                       'M3O5': {'energy (keV)': 4.2071,
                                                                'weight': 0.01},
                                                       'Lg3': {'weight': 0.017,
                                                               'energy (keV)': 20.7125},
                                                       'Lg1': {'weight': 0.08,
                                                               'energy (keV)': 20.1672},
                                                       'Mz': {'weight': 0.03512,
                                                              'energy (keV)': 2.5068}},
                                        'Binding_energies': {'M5': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 3552.0},
                                                             'M4': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 3728.0},
                                                             'O5': {'relevance': 'Major',
                                                                    'threshold': 'Broad peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 96.0},
                                                             'O4': {'relevance': 'Major',
                                                                    'threshold': 'Broad peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 96.0}}},
                  'General_properties': {'Z': 92,
                                         'atomic_weight': 238.02891,
                                         'name': 'uranium'}},
            'Y': {'Physical_properties': {'density (g/cm^3)': 4.472},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.39127,
                                                               'energy (keV)': 1.9959},
                                                       'Kb': {'weight': 0.15,
                                                              'energy (keV)': 16.7381},
                                                       'Ka': {'weight': 1.0,
                                                              'energy (keV)': 14.9584},
                                                       'Lb2': {'weight': 0.00739,
                                                               'energy (keV)': 2.08},
                                                       'La': {'weight': 1.0,
                                                              'energy (keV)': 1.9226},
                                                       'Ln': {'weight': 0.0162,
                                                              'energy (keV)': 1.7619},
                                                       'Ll': {'weight': 0.0428,
                                                              'energy (keV)': 1.6864},
                                                       'Lb3': {'weight': 0.05059,
                                                               'energy (keV)': 2.0722},
                                                       'Lg3': {'weight': 0.0075,
                                                               'energy (keV)': 2.3469},
                                                       'Lg1': {'weight': 0.00264,
                                                               'energy (keV)': 2.1555}},
                                        'Binding_energies': {'M2': {'relevance': 'Minor',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': '',
                                                                    'onset_energy (eV)': 312.0},
                                                             'M5': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 160.0},
                                                             'M4': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 160.0},
                                                             'L2': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 2155.0},
                                                             'L3': {'relevance': 'Major',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': 'Delayed maximum',
                                                                    'onset_energy (eV)': 2080.0},
                                                             'M3': {'relevance': 'Minor',
                                                                    'threshold': 'Sharp peak',
                                                                    'edge': '',
                                                                    'onset_energy (eV)': 300.0},
                                                             'L1': {'relevance': 'Minor',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 2372.0}}},
                  'General_properties': {'Z': 39,
                                         'atomic_weight': 88.90585,
                                         'name': 'yttrium'}},
            'Ac': {'Physical_properties': {'density (g/cm^3)': 10.07},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4,
                                                                'energy (keV)': 15.713},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 102.846},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 90.884},
                                                        'M2N4': {'weight': 0.00674,
                                                                 'energy (keV)': 3.9811},
                                                        'Ma': {'energy (keV)': 2.9239330000000003,
                                                               'weight': 1.0},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 12.652},
                                                        'Ln': {'weight': 0.0133,
                                                               'energy (keV)': 14.0812},
                                                        'M3O4': {'energy (keV)': 3.82586,
                                                                 'weight': 0.01},
                                                        'Ll': {'weight': 0.06549,
                                                               'energy (keV)': 10.869},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 3.06626},
                                                        'Mg': {'weight': 0.33505,
                                                               'energy (keV)': 3.272},
                                                        'M3O5': {'energy (keV)': 3.83206,
                                                                 'weight': 0.01},
                                                        'Lb2': {'weight': 0.236,
                                                                'energy (keV)': 15.234},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 18.95},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 18.4083},
                                                        'Lb3': {'weight': 0.06,
                                                                'energy (keV)': 15.931},
                                                        'Mz': {'weight': 0.03512,
                                                               'energy (keV)': 2.329}}},
                   'General_properties': {'Z': 89,
                                          'atomic_weight': 227,
                                          'name': 'actinium'}},
            'Ag': {'Physical_properties': {'density (g/cm^3)': 10.49},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.35175,
                                                                'energy (keV)': 3.1509},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 24.9426},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 22.1629},
                                                        'Lb2': {'weight': 0.1165,
                                                                'energy (keV)': 3.3478},
                                                        'Lb4': {'weight': 0.0444,
                                                                'energy (keV)': 3.2034},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.9844},
                                                        'Ln': {'weight': 0.0131,
                                                               'energy (keV)': 2.8062},
                                                        'Ll': {'weight': 0.04129,
                                                               'energy (keV)': 2.6336},
                                                        'Lb3': {'weight': 0.0737,
                                                                'energy (keV)': 3.2344},
                                                        'Lg3': {'weight': 0.014,
                                                                'energy (keV)': 3.7499},
                                                        'Lg1': {'weight': 0.03735,
                                                                'energy (keV)': 3.5204}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 367.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 373.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 571.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 602.0}}},
                   'General_properties': {'Z': 47,
                                          'atomic_weight': 107.8682,
                                          'name': 'silver'}},
            'Ir': {'Physical_properties': {'density (g/cm^3)': 22.56},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.4168,
                                                                'energy (keV)': 10.708},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 73.5603},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 64.8958},
                                                        'M2N4': {'weight': 0.02901,
                                                                 'energy (keV)': 2.5973},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 1.9799},
                                                        'Lb4': {'weight': 0.07269,
                                                                'energy (keV)': 10.5098},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 9.1748},
                                                        'Ln': {'weight': 0.01429,
                                                               'energy (keV)': 9.6504},
                                                        'M3O4': {'energy (keV)': 2.54264,
                                                                 'weight': 0.005},
                                                        'Ll': {'weight': 0.05429,
                                                               'energy (keV)': 8.0415},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 2.0527},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 2.2558},
                                                        'Lb2': {'weight': 0.216,
                                                                'energy (keV)': 10.9203},
                                                        'Lb3': {'weight': 0.0874,
                                                                'energy (keV)': 10.8678},
                                                        'M3O5': {'energy (keV)': 2.54385,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.024,
                                                                'energy (keV)': 12.9242},
                                                        'Lg1': {'weight': 0.08543,
                                                                'energy (keV)': 12.5127},
                                                        'Mz': {'weight': 0.01344,
                                                               'energy (keV)': 1.5461}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2040.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2116.0}}},
                   'General_properties': {'Z': 77,
                                          'atomic_weight': 192.217,
                                          'name': 'iridium'}},
            'Al': {'Physical_properties': {'density (g/cm^3)': 2.7},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.0132,
                                                               'energy (keV)': 1.5596},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 1.4865}},
                                         'Binding_energies': {'K': {'relevance': 'Major',
                                                                    'threshold': '',
                                                                    'edge': 'Abrupt onset',
                                                                    'onset_energy (eV)': 1560.0},
                                                              'L2,3': {'relevance': 'Major',
                                                                     # Overlaps
                                                                     # with L2
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 73.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 118.0}}},
                   'General_properties': {'Z': 13,
                                          'atomic_weight': 26.9815386,
                                          'name': 'aluminum'}},
            'As': {'Physical_properties': {'density (g/cm^3)': 5.727},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.16704,
                                                                'energy (keV)': 1.3174},
                                                        'Kb': {'weight': 0.14589,
                                                               'energy (keV)': 11.7262},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 10.5436},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 1.2819},
                                                        'Ln': {'weight': 0.01929,
                                                               'energy (keV)': 1.1551},
                                                        'Ll': {'weight': 0.04929,
                                                               'energy (keV)': 1.1196},
                                                        'Lb3': {'weight': 0.04769,
                                                                'energy (keV)': 1.386}},
                                         'Binding_energies': {'L2': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1359.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 1323.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 1526.0}}},
                   'General_properties': {'Z': 33,
                                          'atomic_weight': 74.9216,
                                          'name': 'arsenic'}},
            'Ar': {'Physical_properties': {'density (g/cm^3)': 0.001784},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'weight': 0.10169,
                                                               'energy (keV)': 3.1905},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 2.9577}},
                                         'Binding_energies': {'L2,3': {'relevance': 'Major',
                                                                     # overlaps
                                                                     # with L2
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 245.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 320.0}}},
                   'General_properties': {'Z': 18,
                                          'atomic_weight': 39.948,
                                          'name': 'argon'}},
            'Au': {'Physical_properties': {'density (g/cm^3)': 19.3},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.40151,
                                                                'energy (keV)': 11.4425},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 77.9819},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 68.8062},
                                                        'M2N4': {'weight': 0.02901,
                                                                 'energy (keV)': 2.7958},
                                                        'Ma': {'weight': 1.0,
                                                               'energy (keV)': 2.1229},
                                                        'Lb4': {'weight': 0.0594,
                                                                'energy (keV)': 11.205},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 9.713},
                                                        'Ln': {'weight': 0.01379,
                                                               'energy (keV)': 10.3087},
                                                        'M3O4': {'energy (keV)': 2.73469,
                                                                 'weight': 0.005},
                                                        'Ll': {'weight': 0.0562,
                                                               'energy (keV)': 8.4938},
                                                        'Mb': {'weight': 0.59443,
                                                               'energy (keV)': 2.2047},
                                                        'Mg': {'weight': 0.08505,
                                                               'energy (keV)': 2.4091},
                                                        'Lb2': {'weight': 0.21949,
                                                                'energy (keV)': 11.5848},
                                                        'Lb3': {'weight': 0.069,
                                                                'energy (keV)': 11.6098},
                                                        'M3O5': {'energy (keV)': 2.73621,
                                                                 'weight': 0.01},
                                                        'Lg3': {'weight': 0.0194,
                                                                'energy (keV)': 13.8074},
                                                        'Lg1': {'weight': 0.08407,
                                                                'energy (keV)': 13.3816},
                                                        'Mz': {'weight': 0.01344,
                                                               'energy (keV)': 1.6603}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2206.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2291.0}}},
                   'General_properties': {'Z': 79,
                                          'atomic_weight': 196.966569,
                                          'name': 'gold'}},
            'At': {'Physical_properties': {'density (g/cm^3)': 'NaN'},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.38048,
                                                                'energy (keV)': 13.876},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 92.3039},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 81.5164},
                                                        'M2N4': {'weight': 0.00863,
                                                                 'energy (keV)': 3.4748},
                                                        'Lb4': {'weight': 0.05809,
                                                                'energy (keV)': 13.485},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 11.4268},
                                                        'Ln': {'weight': 0.0132,
                                                               'energy (keV)': 12.4677},
                                                        'Ll': {'weight': 0.06179,
                                                               'energy (keV)': 9.8965},
                                                        'Mb': {'weight': 0.64124,
                                                               'energy (keV)': 2.71162},
                                                        'Mg': {'weight': 0.21845,
                                                               'energy (keV)': 2.95061},
                                                        'Lb2': {'weight': 0.2305,
                                                                'energy (keV)': 13.73812},
                                                        'Lg3': {'weight': 0.017,
                                                                'energy (keV)': 16.753},
                                                        'Lg1': {'weight': 0.08,
                                                                'energy (keV)': 16.2515},
                                                        'Lb3': {'weight': 0.06,
                                                                'energy (keV)': 14.067},
                                                        'Mz': {'weight': 0.00354,
                                                               'energy (keV)': 2.0467}}},
                   'General_properties': {'Z': 85,
                                          'atomic_weight': 210,
                                          'name': 'astatine'}},
            'In': {'Physical_properties': {'density (g/cm^3)': 7.31},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.3616,
                                                                'energy (keV)': 3.4872},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 27.2756},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 24.2098},
                                                        'Lb2': {'weight': 0.1371,
                                                                'energy (keV)': 3.7139},
                                                        'Lb4': {'weight': 0.05349,
                                                                'energy (keV)': 3.5353},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 3.287},
                                                        'Ln': {'weight': 0.0132,
                                                               'energy (keV)': 3.1124},
                                                        'Ll': {'weight': 0.0415,
                                                               'energy (keV)': 2.9045},
                                                        'Lb3': {'weight': 0.08779,
                                                                'energy (keV)': 3.5732},
                                                        'Lg3': {'weight': 0.0177,
                                                                'energy (keV)': 4.1601},
                                                        'Lg1': {'weight': 0.04535,
                                                                'energy (keV)': 3.9218}},
                                         'Binding_energies': {'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 443.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 451.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 664.0},
                                                              'M2': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 702.0}}},
                   'General_properties': {'Z': 49,
                                          'atomic_weight': 114.818,
                                          'name': 'indium'}},
            'Mo': {'Physical_properties': {'density (g/cm^3)': 10.28},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'weight': 0.32736,
                                                                'energy (keV)': 2.3948},
                                                        'Kb': {'weight': 0.15,
                                                               'energy (keV)': 19.6072},
                                                        'Ka': {'weight': 1.0,
                                                               'energy (keV)': 17.4793},
                                                        'Lb2': {'weight': 0.04509,
                                                                'energy (keV)': 2.5184},
                                                        'La': {'weight': 1.0,
                                                               'energy (keV)': 2.2932},
                                                        'Ln': {'weight': 0.0128,
                                                               'energy (keV)': 2.1205},
                                                        'Ll': {'weight': 0.0415,
                                                               'energy (keV)': 2.0156},
                                                        'Lb3': {'weight': 0.06299,
                                                                'energy (keV)': 2.4732},
                                                        'Lg3': {'weight': 0.0105,
                                                                'energy (keV)': 2.8307},
                                                        'Lg1': {'weight': 0.01335,
                                                                'energy (keV)': 2.6233}},
                                         'Binding_energies': {'M2': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 410.0},
                                                              'M5': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 227.0},
                                                              'M4': {'relevance': 'Major',
                                                                     'threshold': '',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 228.0},
                                                              'L2': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2625.0},
                                                              'L3': {'relevance': 'Major',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': 'Delayed maximum',
                                                                     'onset_energy (eV)': 2520.0},
                                                              'M3': {'relevance': 'Minor',
                                                                     'threshold': 'Sharp peak',
                                                                     'edge': '',
                                                                     'onset_energy (eV)': 392.0},
                                                              'L1': {'relevance': 'Minor',
                                                                     'threshold': '',
                                                                     'edge': 'Abrupt onset',
                                                                     'onset_energy (eV)': 2866.0}}},
                   'General_properties': {'Z': 42,
                                          'atomic_weight': 95.96,
                                          'name': 'molybdenum'}}}

elements_db = utils.DictionaryTreeBrowser(elements)

# read dictionary of atomic numbers from HyperSpy, and add the elements that
# do not currently exist in the database (in case anyone is doing EDS on
# Ununpentium...)
atomic_number2name = dict((p.General_properties.Z, e)
                          for (e, p) in elements_db)
atomic_number2name.update({93: 'Np', 94: 'Pu', 95: 'Am', 96: 'Cm', 97: 'Bk',
                           98: 'Cf', 99: 'Es', 100: 'Fm', 101: 'Md', 102: 'No',
                           103: 'Lr', 104: 'Rf', 105: 'Db', 106: 'Sg',
                           107: 'Bh', 108: 'Hs', 109: 'Mt', 110: 'Ds',
                           111: 'Rg', 112: 'Cp', 113: 'Uut', 114: 'Uuq',
                           115: 'Uup', 116: 'Uuh', 117: 'Uus', 118: 'Uuo',
                           119: 'Uue'})
