QT       += core gui dbus network

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets
TARGET = ukui-powermanagement

CONFIG += c++11 link_pkgconfig

PKGCONFIG += gsettings-qt

exists(/usr/include/kysdk/kysdk-system/libkysysinfo.h) {
    DEFINES += KY_SDK_SYSINFO
    PKGCONFIG += kysdk-sysinfo
}

//LIBS += -lukui-log4qt

# The following define makes your compiler emit warnings if you use
# any Qt feature that has been marked deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

# You can also make your code fail to compile if it uses deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0
TRANSLATIONS+=\
    translations/ukui-power-manager-daemon_bo_CN.ts \
    translations/ukui-power-manager-daemon_zh_CN.ts \
    translations/ukui-power-manager-daemon_tr.ts

QM_FILES_INSTALL_PATH = /usr/share/ukui-power-manager/daemon/translations/

# CONFIG += lrelase not work for qt5.6, add those from lrelease.prf for compatibility
qtPrepareTool(QMAKE_LRELEASE, lrelease)
lrelease.name = lrelease
lrelease.input = TRANSLATIONS
lrelease.output = ${QMAKE_FILE_IN_BASE}.qm
lrelease.commands = $$QMAKE_LRELEASE ${QMAKE_FILE_IN} -qm ${QMAKE_FILE_OUT}
lrelease.CONFIG = no_link
QMAKE_EXTRA_COMPILERS += lrelease
PRE_TARGETDEPS += compiler_lrelease_make_all

for (translation, TRANSLATIONS) {
    translation = $$basename(translation)
    QM_FILES += $$OUT_PWD/$$replace(translation, \\..*$, .qm)
}
qm_files.files = $$QM_FILES
qm_files.path = $$QM_FILES_INSTALL_PATH
qm_files.CONFIG = no_check_exist
INSTALLS += qm_files

DEFINES += QM_FILES_INSTALL_PATH='\\"$${QM_FILES_INSTALL_PATH}\\"'
include($$PWD/../common/common.pri)

SOURCES += \
    main.cpp \
    upm-common-dbus/upm_commondbus.cpp \
    upm-control-dbus/upm_controldbus.cpp \
    upm-gsettings/upm_gsettings.cpp \
    upm-upower-dbus/upm_upowerdbus.cpp \
    upm-upower-dbus/upowerbatterydbus.cpp \
    upm-upower-dbus/upowerdbus.cpp \
    upm-upower-dbus/upowerlinepowerdbus.cpp \
    upm_brightness.cpp \
    upm_checkconfig.cpp \
    upm_daemon.cpp \
    upm_externalinterface.cpp \
    upm_lid.cpp \
    upm_lowpower.cpp \
    upm_powerchanged.cpp \
    upm_systemidle.cpp

HEADERS += \
    common.h \
    upm-common-dbus/upm_commondbus.h \
    upm-control-dbus/upm_controldbus.h \
    upm-gsettings/upm_gsettings.h \
    upm-upower-dbus/upm_upowerdbus.h \
    upm-upower-dbus/upowerbatterydbus.h \
    upm-upower-dbus/upowerdbus.h \
    upm-upower-dbus/upowerlinepowerdbus.h \
    upm_brightness.h \
    upm_checkconfig.h \
    upm_daemon.h \
    upm_externalinterface.h \
    upm_lid.h \
    upm_lowpower.h \
    upm_powerchanged.h \
    upm_systemidle.h


# Default rules for deployment.
qnx: target.path = /tmp/usr/bin
else: unix:!android: target.path = /usr/bin
!isEmpty(target.path): INSTALLS += target

desktop.files += resources/ukui-powermanagement-daemon.desktop
desktop.path = /etc/xdg/autostart/
INSTALLS += desktop

conf.files += resources/org.ukui.power-manager.gschema.xml
conf.path=/usr/share/glib-2.0/schemas/
INSTALLS += conf

upmConf.files += resources/upm-global.conf
upmConf.path = /etc/ukui/ukui-power-manager

INSTALLS += upmConf
