/* 
 * LCDInfo V0.02 - Little program to display system info on a HD44780
 * compatible LCD display
 *
 * Copyright (C) 2002 Jan Svenungson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#define BASE 0x378

#include <stdio.h>
#include <stdlib.h>
#include <asm/io.h>

void main_loop(void);

char* uptime(void);
char* system_info(void);
char* mem(void);
char* swap(void);
char* cpu(void);

// Main function
int main(void)
{
	int width; 			// LCD screen width
	int height; 			// LCD screen height
	int i; 				// Just a counter
	width = 20;
	height = 2;
	
	ioperm(BASE, 3, 1);		// Get permission to the parallel port

	outb(0, BASE + 2); 		// Make sure there is power on C0 (Only needed if LCD is powered by parallel port)
	initialize_display();	 	// Initialize the display

	main_loop();

	display_off();
	return 0;
}
	
void main_loop(void)
{	
	while(1)
	{
		int i;

		clear_display();

		for (i = 0; i < 24; i++) //TODO: Remove this awful piece of code!!!
		{
			int x;
			int y;
				
			for(x = 0; x < strlen(system_info()); x++)
				print_character(system_info()[x]);

				second_row();

			for (y = 0; y < strlen(uptime()); y++)
				print_character(uptime()[y]);

				return_home();
		}

		clear_display();

		for (i = 0; i < 24; i++)
		{
			int x;
			int y;
			char mem_title[21] = "RAM Use Fre Sh Bu Ca\0";

			for(x = 0; x < strlen(mem_title); x++)
				print_character(mem_title[x]);

				second_row();

			for (y = 0; y < strlen(mem()); y++)
				print_character(mem()[y]);

				return_home();
		}
		
		clear_display();

		for (i = 0; i < 24; i++)
		{
			int x;
			int y;
			char swap_title[21] = "      Swap Used Free\0";
			
			for(x = 0; x < strlen(swap_title); x++)
				print_character(swap_title[x]);

				second_row();

			for (y = 0; y < strlen(swap()); y++)
				print_character(swap()[y]);

				return_home();
		}

		clear_display();

		for (i = 0; i < 24; i++)
		{
			int x;
			int y;
			char cpu_title[21] = "User Nice  Sys  Idle\0";
		
			for(x = 0; x < strlen(cpu_title); x++)
				print_character(cpu_title[x]);

				second_row();

			for (y = 0; y < strlen(cpu()); y++)
				print_character(cpu()[y]);

				return_home();
		}
	}
}
