#!/usr/bin/env perl -i
#
# This script converts all numbers that look like addresses or memory sizes,
# in a debug files generated by --debug (like mysqld --debug-dbug), to #.
# The script also deletes all thread id's from the start of the line.

# This allows you to easily compare the files (for example with diff)
# to find out what changes between different executions.
# This is extremely useful for comparing two mysqld versions to see
# why things now work differently.

# The script converts the files in place.
#
# Typical usage:
#
# convert-debug-for-diff /tmp/mysqld.trace /tmp/mysqld-old.trace
# diff /tmp/mysqld.trace /tmp/mysqld-old.trace

while (<>)
{
  s/^T@[0-9]+\s*://g;
  s/0x[0-9a-f]+(\s|\n|\))/#$1/g;
  s/size: [0-9]+/size: #/g;
  print $_;
}
