/*
 * Copyright (C) 2018 Codership Oy <info@codership.com>
 *
 * This file is part of wsrep-lib.
 *
 * Wsrep-lib is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Wsrep-lib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with wsrep-lib.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef WSREP_DB_PARAMS_HPP
#define WSREP_DB_PARAMS_HPP

#include <cstddef>
#include <string>

namespace db
{
    struct params
    {
        size_t n_servers;
        size_t n_clients;
        size_t n_transactions;
        size_t n_rows;
        size_t alg_freq;
        std::string topology;
        std::string wsrep_provider;
        std::string wsrep_provider_options;
        int debug_log_level;
        int fast_exit;
        params()
            : n_servers(0)
            , n_clients(0)
            , n_transactions(0)
            , n_rows(1000)
            , alg_freq(0)
            , topology()
            , wsrep_provider()
            , wsrep_provider_options()
            , debug_log_level(0)
            , fast_exit(0)
        { }
    };

    params parse_args(int argc, char** argv);
}

#endif // WSREP_DB_PARAMS_HPP
