/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.io.ServerCapabilities;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.mysqla.io.Buffer;

public class MysqlaCapabilities
implements ServerCapabilities {
    private Buffer initialHandshakePacket;
    private byte protocolVersion = 0;
    private ServerVersion serverVersion;
    private long threadId = -1L;
    private String seed;
    private int capabilityFlags;
    private int serverDefaultCollationIndex;
    private int statusFlags = 0;
    private int authPluginDataLength = 0;

    public Buffer getInitialHandshakePacket() {
        return this.initialHandshakePacket;
    }

    public void setInitialHandshakePacket(Buffer initialHandshakePacket) {
        this.initialHandshakePacket = initialHandshakePacket;
        this.setProtocolVersion(initialHandshakePacket.readByte());
        this.setServerVersion(ServerVersion.parseVersion(initialHandshakePacket.readString("ASCII")));
        this.setThreadId(initialHandshakePacket.readLong());
        this.setSeed(initialHandshakePacket.readString("ASCII", 8));
        initialHandshakePacket.readByte();
        int flags = 0;
        if (initialHandshakePacket.getPosition() < initialHandshakePacket.getBufLength()) {
            flags = initialHandshakePacket.readInt();
        }
        this.setServerDefaultCollationIndex(initialHandshakePacket.readByte() & 0xFF);
        this.setStatusFlags(initialHandshakePacket.readInt());
        this.setCapabilityFlags(flags |= initialHandshakePacket.readInt() << 16);
        if ((flags & 0x80000) != 0) {
            this.authPluginDataLength = initialHandshakePacket.readByte() & 0xFF;
        } else {
            initialHandshakePacket.readByte();
        }
        initialHandshakePacket.setPosition(initialHandshakePacket.getPosition() + 10);
    }

    @Override
    public int getCapabilityFlags() {
        return this.capabilityFlags;
    }

    @Override
    public void setCapabilityFlags(int capabilityFlags) {
        this.capabilityFlags = capabilityFlags;
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(byte protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void setServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public String getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public int getServerDefaultCollationIndex() {
        return this.serverDefaultCollationIndex;
    }

    public void setServerDefaultCollationIndex(int serverDefaultCollationIndex) {
        this.serverDefaultCollationIndex = serverDefaultCollationIndex;
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }

    public void setStatusFlags(int statusFlags) {
        this.statusFlags = statusFlags;
    }

    public int getAuthPluginDataLength() {
        return this.authPluginDataLength;
    }

    public void setAuthPluginDataLength(int authPluginDataLength) {
        this.authPluginDataLength = authPluginDataLength;
    }
}

