/* Copyright (c) 2000, 2011, Oracle and/or its affiliates.
   Copyright (c) 2009-2011, Monty Program Ab

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1335  USA */

/* This file is for Chinese character sets GBK, created by Wei He 
   (hewei@mail.ied.ac.cn)
*/

/*
 * This comment is parsed by configure to create ctype.c,
 * so don't change it unless you know what you are doing.
 *
 * .configure. strxfrm_multiply_gbk=1
 * .configure. mbmaxlen_gbk=2
 */

#include "strings_def.h"
#include <m_ctype.h>

#ifdef HAVE_CHARSET_gbk


/* Support for Chinese(GBK) characters, by hewei@mail.ied.ac.cn */

#define isgbkhead(c) (0x81<=(uchar)(c) && (uchar)(c)<=0xfe)
#define isgbktail(c) ((0x40<=(uchar)(c) && (uchar)(c)<=0x7e) || \
                          (0x80<=(uchar)(c) && (uchar)(c)<=0xfe))

#define isgbkcode(c,d) (isgbkhead(c) && isgbktail(d))
#define gbkcode(c,d)   ((((uint) (uchar) (c)) <<8) | (uchar)(d))
#define gbkhead(e)     ((uchar)(e>>8))
#define gbktail(e)     ((uchar)(e&0xff))

#define MY_FUNCTION_NAME(x)   my_ ## x ## _gbk
#define IS_MB1_CHAR(x)        ((uchar) (x) < 0x80)
#define IS_MB2_CHAR(x,y)      (isgbkhead(x) && isgbktail(y))
#define DEFINE_ASIAN_ROUTINES
#include "ctype-mb.ic"


static const uchar ctype_gbk[257] =
{
  0,				/* For standard library */
  32,32,32,32,32,32,32,32,32,40,40,40,40,40,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  72,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
  132,132,132,132,132,132,132,132,132,132,16,16,16,16,16,16,
  16,129,129,129,129,129,129,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,16,16,16,16,16,
  16,130,130,130,130,130,130,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,16,16,16,16,32,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
};

static const uchar to_lower_gbk[]=
{
  '\000','\001','\002','\003','\004','\005','\006','\007',
  '\010','\011','\012','\013','\014','\015','\016','\017',
  '\020','\021','\022','\023','\024','\025','\026','\027',
  '\030','\031','\032','\033','\034','\035','\036','\037',
  ' ',	 '!',	'"',   '#',   '$',   '%',   '&',   '\'',
  '(',	 ')',	'*',   '+',   ',',   '-',   '.',   '/',
  '0',	 '1',	'2',   '3',   '4',   '5',   '6',   '7',
  '8',	 '9',	':',   ';',   '<',   '=',   '>',   '?',
  '@',	 'a',	'b',   'c',   'd',   'e',   'f',   'g',
  'h',	 'i',	'j',   'k',   'l',   'm',   'n',   'o',
  'p',	 'q',	'r',   's',   't',   'u',   'v',   'w',
  'x',	 'y',	'z',   '[',   '\\',  ']',   '^',   '_',
  '`',	 'a',	'b',   'c',   'd',   'e',   'f',   'g',
  'h',	 'i',	'j',   'k',   'l',   'm',   'n',   'o',
  'p',	 'q',	'r',   's',   't',   'u',   'v',   'w',
  'x',	 'y',	'z',   '{',   '|',   '}',   '~',   '\177',
  (uchar) '\200',(uchar) '\201',(uchar) '\202',(uchar) '\203',(uchar) '\204',(uchar) '\205',(uchar) '\206',(uchar) '\207',
  (uchar) '\210',(uchar) '\211',(uchar) '\212',(uchar) '\213',(uchar) '\214',(uchar) '\215',(uchar) '\216',(uchar) '\217',
  (uchar) '\220',(uchar) '\221',(uchar) '\222',(uchar) '\223',(uchar) '\224',(uchar) '\225',(uchar) '\226',(uchar) '\227',
  (uchar) '\230',(uchar) '\231',(uchar) '\232',(uchar) '\233',(uchar) '\234',(uchar) '\235',(uchar) '\236',(uchar) '\237',
  (uchar) '\240',(uchar) '\241',(uchar) '\242',(uchar) '\243',(uchar) '\244',(uchar) '\245',(uchar) '\246',(uchar) '\247',
  (uchar) '\250',(uchar) '\251',(uchar) '\252',(uchar) '\253',(uchar) '\254',(uchar) '\255',(uchar) '\256',(uchar) '\257',
  (uchar) '\260',(uchar) '\261',(uchar) '\262',(uchar) '\263',(uchar) '\264',(uchar) '\265',(uchar) '\266',(uchar) '\267',
  (uchar) '\270',(uchar) '\271',(uchar) '\272',(uchar) '\273',(uchar) '\274',(uchar) '\275',(uchar) '\276',(uchar) '\277',
  (uchar) '\300',(uchar) '\301',(uchar) '\302',(uchar) '\303',(uchar) '\304',(uchar) '\305',(uchar) '\306',(uchar) '\307',
  (uchar) '\310',(uchar) '\311',(uchar) '\312',(uchar) '\313',(uchar) '\314',(uchar) '\315',(uchar) '\316',(uchar) '\317',
  (uchar) '\320',(uchar) '\321',(uchar) '\322',(uchar) '\323',(uchar) '\324',(uchar) '\325',(uchar) '\326',(uchar) '\327',
  (uchar) '\330',(uchar) '\331',(uchar) '\332',(uchar) '\333',(uchar) '\334',(uchar) '\335',(uchar) '\336',(uchar) '\337',
  (uchar) '\340',(uchar) '\341',(uchar) '\342',(uchar) '\343',(uchar) '\344',(uchar) '\345',(uchar) '\346',(uchar) '\347',
  (uchar) '\350',(uchar) '\351',(uchar) '\352',(uchar) '\353',(uchar) '\354',(uchar) '\355',(uchar) '\356',(uchar) '\357',
  (uchar) '\360',(uchar) '\361',(uchar) '\362',(uchar) '\363',(uchar) '\364',(uchar) '\365',(uchar) '\366',(uchar) '\367',
  (uchar) '\370',(uchar) '\371',(uchar) '\372',(uchar) '\373',(uchar) '\374',(uchar) '\375',(uchar) '\376',(uchar) '\377',
};

static const uchar to_upper_gbk[]=
{
  '\000','\001','\002','\003','\004','\005','\006','\007',
  '\010','\011','\012','\013','\014','\015','\016','\017',
  '\020','\021','\022','\023','\024','\025','\026','\027',
  '\030','\031','\032','\033','\034','\035','\036','\037',
  ' ',	 '!',	'"',   '#',   '$',   '%',   '&',   '\'',
  '(',	 ')',	'*',   '+',   ',',   '-',   '.',   '/',
  '0',	 '1',	'2',   '3',   '4',   '5',   '6',   '7',
  '8',	 '9',	':',   ';',   '<',   '=',   '>',   '?',
  '@',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '[',   '\\',  ']',   '^',   '_',
  '`',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '{',   '|',   '}',   '~',   '\177',
  (uchar) '\200',(uchar) '\201',(uchar) '\202',(uchar) '\203',(uchar) '\204',(uchar) '\205',(uchar) '\206',(uchar) '\207',
  (uchar) '\210',(uchar) '\211',(uchar) '\212',(uchar) '\213',(uchar) '\214',(uchar) '\215',(uchar) '\216',(uchar) '\217',
  (uchar) '\220',(uchar) '\221',(uchar) '\222',(uchar) '\223',(uchar) '\224',(uchar) '\225',(uchar) '\226',(uchar) '\227',
  (uchar) '\230',(uchar) '\231',(uchar) '\232',(uchar) '\233',(uchar) '\234',(uchar) '\235',(uchar) '\236',(uchar) '\237',
  (uchar) '\240',(uchar) '\241',(uchar) '\242',(uchar) '\243',(uchar) '\244',(uchar) '\245',(uchar) '\246',(uchar) '\247',
  (uchar) '\250',(uchar) '\251',(uchar) '\252',(uchar) '\253',(uchar) '\254',(uchar) '\255',(uchar) '\256',(uchar) '\257',
  (uchar) '\260',(uchar) '\261',(uchar) '\262',(uchar) '\263',(uchar) '\264',(uchar) '\265',(uchar) '\266',(uchar) '\267',
  (uchar) '\270',(uchar) '\271',(uchar) '\272',(uchar) '\273',(uchar) '\274',(uchar) '\275',(uchar) '\276',(uchar) '\277',
  (uchar) '\300',(uchar) '\301',(uchar) '\302',(uchar) '\303',(uchar) '\304',(uchar) '\305',(uchar) '\306',(uchar) '\307',
  (uchar) '\310',(uchar) '\311',(uchar) '\312',(uchar) '\313',(uchar) '\314',(uchar) '\315',(uchar) '\316',(uchar) '\317',
  (uchar) '\320',(uchar) '\321',(uchar) '\322',(uchar) '\323',(uchar) '\324',(uchar) '\325',(uchar) '\326',(uchar) '\327',
  (uchar) '\330',(uchar) '\331',(uchar) '\332',(uchar) '\333',(uchar) '\334',(uchar) '\335',(uchar) '\336',(uchar) '\337',
  (uchar) '\340',(uchar) '\341',(uchar) '\342',(uchar) '\343',(uchar) '\344',(uchar) '\345',(uchar) '\346',(uchar) '\347',
  (uchar) '\350',(uchar) '\351',(uchar) '\352',(uchar) '\353',(uchar) '\354',(uchar) '\355',(uchar) '\356',(uchar) '\357',
  (uchar) '\360',(uchar) '\361',(uchar) '\362',(uchar) '\363',(uchar) '\364',(uchar) '\365',(uchar) '\366',(uchar) '\367',
  (uchar) '\370',(uchar) '\371',(uchar) '\372',(uchar) '\373',(uchar) '\374',(uchar) '\375',(uchar) '\376',(uchar) '\377',
};


static MY_UNICASE_CHARACTER cA2[256]=
{
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx00 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx10 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx20 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx30 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0xA240,0xA240,0x003F}, /* A240 */
  {0xA241,0xA241,0x003F},
  {0xA242,0xA242,0x003F},
  {0xA243,0xA243,0x003F},
  {0xA244,0xA244,0x003F},
  {0xA245,0xA245,0x003F},
  {0xA246,0xA246,0x003F},
  {0xA247,0xA247,0x003F},
  {0xA248,0xA248,0x003F},
  {0xA249,0xA249,0x003F},
  {0xA24A,0xA24A,0x003F},
  {0xA24B,0xA24B,0x003F},
  {0xA24C,0xA24C,0x003F},
  {0xA24D,0xA24D,0x003F},
  {0xA24E,0xA24E,0x003F},
  {0xA24F,0xA24F,0x003F},
  {0xA250,0xA250,0x003F}, /* A250 */
  {0xA251,0xA251,0x003F},
  {0xA252,0xA252,0x003F},
  {0xA253,0xA253,0x003F},
  {0xA254,0xA254,0x003F},
  {0xA255,0xA255,0x003F},
  {0xA256,0xA256,0x003F},
  {0xA257,0xA257,0x003F},
  {0xA258,0xA258,0x003F},
  {0xA259,0xA259,0x003F},
  {0xA25A,0xA25A,0x003F},
  {0xA25B,0xA25B,0x003F},
  {0xA25C,0xA25C,0x003F},
  {0xA25D,0xA25D,0x003F},
  {0xA25E,0xA25E,0x003F},
  {0xA25F,0xA25F,0x003F},
  {0xA260,0xA260,0x003F}, /* A260 */
  {0xA261,0xA261,0x003F},
  {0xA262,0xA262,0x003F},
  {0xA263,0xA263,0x003F},
  {0xA264,0xA264,0x003F},
  {0xA265,0xA265,0x003F},
  {0xA266,0xA266,0x003F},
  {0xA267,0xA267,0x003F},
  {0xA268,0xA268,0x003F},
  {0xA269,0xA269,0x003F},
  {0xA26A,0xA26A,0x003F},
  {0xA26B,0xA26B,0x003F},
  {0xA26C,0xA26C,0x003F},
  {0xA26D,0xA26D,0x003F},
  {0xA26E,0xA26E,0x003F},
  {0xA26F,0xA26F,0x003F},
  {0xA270,0xA270,0x003F}, /* A270 */
  {0xA271,0xA271,0x003F},
  {0xA272,0xA272,0x003F},
  {0xA273,0xA273,0x003F},
  {0xA274,0xA274,0x003F},
  {0xA275,0xA275,0x003F},
  {0xA276,0xA276,0x003F},
  {0xA277,0xA277,0x003F},
  {0xA278,0xA278,0x003F},
  {0xA279,0xA279,0x003F},
  {0xA27A,0xA27A,0x003F},
  {0xA27B,0xA27B,0x003F},
  {0xA27C,0xA27C,0x003F},
  {0xA27D,0xA27D,0x003F},
  {0xA27E,0xA27E,0x003F},
  {0xA27F,0xA27F,0xA27F},
  {0xA280,0xA280,0x003F}, /* A280 */
  {0xA281,0xA281,0x003F},
  {0xA282,0xA282,0x003F},
  {0xA283,0xA283,0x003F},
  {0xA284,0xA284,0x003F},
  {0xA285,0xA285,0x003F},
  {0xA286,0xA286,0x003F},
  {0xA287,0xA287,0x003F},
  {0xA288,0xA288,0x003F},
  {0xA289,0xA289,0x003F},
  {0xA28A,0xA28A,0x003F},
  {0xA28B,0xA28B,0x003F},
  {0xA28C,0xA28C,0x003F},
  {0xA28D,0xA28D,0x003F},
  {0xA28E,0xA28E,0x003F},
  {0xA28F,0xA28F,0x003F},
  {0xA290,0xA290,0x003F}, /* A290 */
  {0xA291,0xA291,0x003F},
  {0xA292,0xA292,0x003F},
  {0xA293,0xA293,0x003F},
  {0xA294,0xA294,0x003F},
  {0xA295,0xA295,0x003F},
  {0xA296,0xA296,0x003F},
  {0xA297,0xA297,0x003F},
  {0xA298,0xA298,0x003F},
  {0xA299,0xA299,0x003F},
  {0xA29A,0xA29A,0x003F},
  {0xA29B,0xA29B,0x003F},
  {0xA29C,0xA29C,0x003F},
  {0xA29D,0xA29D,0x003F},
  {0xA29E,0xA29E,0x003F},
  {0xA29F,0xA29F,0x003F},
  {0xA2A0,0xA2A0,0x003F}, /* A2A0 */
  {0xA2F1,0xA2A1,0x2170},
  {0xA2F2,0xA2A2,0x2171},
  {0xA2F3,0xA2A3,0x2172},
  {0xA2F4,0xA2A4,0x2173},
  {0xA2F5,0xA2A5,0x2174},
  {0xA2F6,0xA2A6,0x2175},
  {0xA2F7,0xA2A7,0x2176},
  {0xA2F8,0xA2A8,0x2177},
  {0xA2F9,0xA2A9,0x2178},
  {0xA2FA,0xA2AA,0x2179},
  {0xA2AB,0xA2AB,0x003F},
  {0xA2AC,0xA2AC,0x003F},
  {0xA2AD,0xA2AD,0x003F},
  {0xA2AE,0xA2AE,0x003F},
  {0xA2AF,0xA2AF,0x003F},
  {0xA2B0,0xA2B0,0x003F}, /* A2B0 */
  {0xA2B1,0xA2B1,0x2488},
  {0xA2B2,0xA2B2,0x2489},
  {0xA2B3,0xA2B3,0x248A},
  {0xA2B4,0xA2B4,0x248B},
  {0xA2B5,0xA2B5,0x248C},
  {0xA2B6,0xA2B6,0x248D},
  {0xA2B7,0xA2B7,0x248E},
  {0xA2B8,0xA2B8,0x248F},
  {0xA2B9,0xA2B9,0x2490},
  {0xA2BA,0xA2BA,0x2491},
  {0xA2BB,0xA2BB,0x2492},
  {0xA2BC,0xA2BC,0x2493},
  {0xA2BD,0xA2BD,0x2494},
  {0xA2BE,0xA2BE,0x2495},
  {0xA2BF,0xA2BF,0x2496},
  {0xA2C0,0xA2C0,0x2497}, /* A2C0 */
  {0xA2C1,0xA2C1,0x2498},
  {0xA2C2,0xA2C2,0x2499},
  {0xA2C3,0xA2C3,0x249A},
  {0xA2C4,0xA2C4,0x249B},
  {0xA2C5,0xA2C5,0x2474},
  {0xA2C6,0xA2C6,0x2475},
  {0xA2C7,0xA2C7,0x2476},
  {0xA2C8,0xA2C8,0x2477},
  {0xA2C9,0xA2C9,0x2478},
  {0xA2CA,0xA2CA,0x2479},
  {0xA2CB,0xA2CB,0x247A},
  {0xA2CC,0xA2CC,0x247B},
  {0xA2CD,0xA2CD,0x247C},
  {0xA2CE,0xA2CE,0x247D},
  {0xA2CF,0xA2CF,0x247E},
  {0xA2D0,0xA2D0,0x247F}, /* A2D0 */
  {0xA2D1,0xA2D1,0x2480},
  {0xA2D2,0xA2D2,0x2481},
  {0xA2D3,0xA2D3,0x2482},
  {0xA2D4,0xA2D4,0x2483},
  {0xA2D5,0xA2D5,0x2484},
  {0xA2D6,0xA2D6,0x2485},
  {0xA2D7,0xA2D7,0x2486},
  {0xA2D8,0xA2D8,0x2487},
  {0xA2D9,0xA2D9,0x2460},
  {0xA2DA,0xA2DA,0x2461},
  {0xA2DB,0xA2DB,0x2462},
  {0xA2DC,0xA2DC,0x2463},
  {0xA2DD,0xA2DD,0x2464},
  {0xA2DE,0xA2DE,0x2465},
  {0xA2DF,0xA2DF,0x2466},
  {0xA2E0,0xA2E0,0x2467}, /* A2E0 */
  {0xA2E1,0xA2E1,0x2468},
  {0xA2E2,0xA2E2,0x2469},
  {0xA2E3,0xA2E3,0x003F},
  {0xA2E4,0xA2E4,0x003F},
  {0xA2E5,0xA2E5,0x3220},
  {0xA2E6,0xA2E6,0x3221},
  {0xA2E7,0xA2E7,0x3222},
  {0xA2E8,0xA2E8,0x3223},
  {0xA2E9,0xA2E9,0x3224},
  {0xA2EA,0xA2EA,0x3225},
  {0xA2EB,0xA2EB,0x3226},
  {0xA2EC,0xA2EC,0x3227},
  {0xA2ED,0xA2ED,0x3228},
  {0xA2EE,0xA2EE,0x3229},
  {0xA2EF,0xA2EF,0x003F},
  {0xA2F0,0xA2F0,0x003F}, /* A2F0 */
  {0xA2F1,0xA2A1,0x2160},
  {0xA2F2,0xA2A2,0x2161},
  {0xA2F3,0xA2A3,0x2162},
  {0xA2F4,0xA2A4,0x2163},
  {0xA2F5,0xA2A5,0x2164},
  {0xA2F6,0xA2A6,0x2165},
  {0xA2F7,0xA2A7,0x2166},
  {0xA2F8,0xA2A8,0x2167},
  {0xA2F9,0xA2A9,0x2168},
  {0xA2FA,0xA2AA,0x2169},
  {0xA2FB,0xA2FB,0x216A},
  {0xA2FC,0xA2FC,0x216B},
  {0xA2FD,0xA2FD,0x003F},
  {0xA2FE,0xA2FE,0x003F},
  {0xA2FF,0xA2FF,0xA2FF}
};

static MY_UNICASE_CHARACTER cA3[256]=
{
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx00 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx10 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx20 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx30 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0xA340,0xA340,0x003F}, /* A340 */
  {0xA341,0xA341,0x003F},
  {0xA342,0xA342,0x003F},
  {0xA343,0xA343,0x003F},
  {0xA344,0xA344,0x003F},
  {0xA345,0xA345,0x003F},
  {0xA346,0xA346,0x003F},
  {0xA347,0xA347,0x003F},
  {0xA348,0xA348,0x003F},
  {0xA349,0xA349,0x003F},
  {0xA34A,0xA34A,0x003F},
  {0xA34B,0xA34B,0x003F},
  {0xA34C,0xA34C,0x003F},
  {0xA34D,0xA34D,0x003F},
  {0xA34E,0xA34E,0x003F},
  {0xA34F,0xA34F,0x003F},
  {0xA350,0xA350,0x003F}, /* A350 */
  {0xA351,0xA351,0x003F},
  {0xA352,0xA352,0x003F},
  {0xA353,0xA353,0x003F},
  {0xA354,0xA354,0x003F},
  {0xA355,0xA355,0x003F},
  {0xA356,0xA356,0x003F},
  {0xA357,0xA357,0x003F},
  {0xA358,0xA358,0x003F},
  {0xA359,0xA359,0x003F},
  {0xA35A,0xA35A,0x003F},
  {0xA35B,0xA35B,0x003F},
  {0xA35C,0xA35C,0x003F},
  {0xA35D,0xA35D,0x003F},
  {0xA35E,0xA35E,0x003F},
  {0xA35F,0xA35F,0x003F},
  {0xA360,0xA360,0x003F}, /* A360 */
  {0xA361,0xA361,0x003F},
  {0xA362,0xA362,0x003F},
  {0xA363,0xA363,0x003F},
  {0xA364,0xA364,0x003F},
  {0xA365,0xA365,0x003F},
  {0xA366,0xA366,0x003F},
  {0xA367,0xA367,0x003F},
  {0xA368,0xA368,0x003F},
  {0xA369,0xA369,0x003F},
  {0xA36A,0xA36A,0x003F},
  {0xA36B,0xA36B,0x003F},
  {0xA36C,0xA36C,0x003F},
  {0xA36D,0xA36D,0x003F},
  {0xA36E,0xA36E,0x003F},
  {0xA36F,0xA36F,0x003F},
  {0xA370,0xA370,0x003F}, /* A370 */
  {0xA371,0xA371,0x003F},
  {0xA372,0xA372,0x003F},
  {0xA373,0xA373,0x003F},
  {0xA374,0xA374,0x003F},
  {0xA375,0xA375,0x003F},
  {0xA376,0xA376,0x003F},
  {0xA377,0xA377,0x003F},
  {0xA378,0xA378,0x003F},
  {0xA379,0xA379,0x003F},
  {0xA37A,0xA37A,0x003F},
  {0xA37B,0xA37B,0x003F},
  {0xA37C,0xA37C,0x003F},
  {0xA37D,0xA37D,0x003F},
  {0xA37E,0xA37E,0x003F},
  {0xA37F,0xA37F,0xA37F},
  {0xA380,0xA380,0x003F}, /* A380 */
  {0xA381,0xA381,0x003F},
  {0xA382,0xA382,0x003F},
  {0xA383,0xA383,0x003F},
  {0xA384,0xA384,0x003F},
  {0xA385,0xA385,0x003F},
  {0xA386,0xA386,0x003F},
  {0xA387,0xA387,0x003F},
  {0xA388,0xA388,0x003F},
  {0xA389,0xA389,0x003F},
  {0xA38A,0xA38A,0x003F},
  {0xA38B,0xA38B,0x003F},
  {0xA38C,0xA38C,0x003F},
  {0xA38D,0xA38D,0x003F},
  {0xA38E,0xA38E,0x003F},
  {0xA38F,0xA38F,0x003F},
  {0xA390,0xA390,0x003F}, /* A390 */
  {0xA391,0xA391,0x003F},
  {0xA392,0xA392,0x003F},
  {0xA393,0xA393,0x003F},
  {0xA394,0xA394,0x003F},
  {0xA395,0xA395,0x003F},
  {0xA396,0xA396,0x003F},
  {0xA397,0xA397,0x003F},
  {0xA398,0xA398,0x003F},
  {0xA399,0xA399,0x003F},
  {0xA39A,0xA39A,0x003F},
  {0xA39B,0xA39B,0x003F},
  {0xA39C,0xA39C,0x003F},
  {0xA39D,0xA39D,0x003F},
  {0xA39E,0xA39E,0x003F},
  {0xA39F,0xA39F,0x003F},
  {0xA3A0,0xA3A0,0x003F}, /* A3A0 */
  {0xA3A1,0xA3A1,0xFF01},
  {0xA3A2,0xA3A2,0xFF02},
  {0xA3A3,0xA3A3,0xFF03},
  {0xA3A4,0xA3A4,0xFFE5},
  {0xA3A5,0xA3A5,0xFF05},
  {0xA3A6,0xA3A6,0xFF06},
  {0xA3A7,0xA3A7,0xFF07},
  {0xA3A8,0xA3A8,0xFF08},
  {0xA3A9,0xA3A9,0xFF09},
  {0xA3AA,0xA3AA,0xFF0A},
  {0xA3AB,0xA3AB,0xFF0B},
  {0xA3AC,0xA3AC,0xFF0C},
  {0xA3AD,0xA3AD,0xFF0D},
  {0xA3AE,0xA3AE,0xFF0E},
  {0xA3AF,0xA3AF,0xFF0F},
  {0xA3B0,0xA3B0,0xFF10}, /* A3B0 */
  {0xA3B1,0xA3B1,0xFF11},
  {0xA3B2,0xA3B2,0xFF12},
  {0xA3B3,0xA3B3,0xFF13},
  {0xA3B4,0xA3B4,0xFF14},
  {0xA3B5,0xA3B5,0xFF15},
  {0xA3B6,0xA3B6,0xFF16},
  {0xA3B7,0xA3B7,0xFF17},
  {0xA3B8,0xA3B8,0xFF18},
  {0xA3B9,0xA3B9,0xFF19},
  {0xA3BA,0xA3BA,0xFF1A},
  {0xA3BB,0xA3BB,0xFF1B},
  {0xA3BC,0xA3BC,0xFF1C},
  {0xA3BD,0xA3BD,0xFF1D},
  {0xA3BE,0xA3BE,0xFF1E},
  {0xA3BF,0xA3BF,0xFF1F},
  {0xA3C0,0xA3C0,0xFF20}, /* A3C0 */
  {0xA3C1,0xA3E1,0xFF21},
  {0xA3C2,0xA3E2,0xFF22},
  {0xA3C3,0xA3E3,0xFF23},
  {0xA3C4,0xA3E4,0xFF24},
  {0xA3C5,0xA3E5,0xFF25},
  {0xA3C6,0xA3E6,0xFF26},
  {0xA3C7,0xA3E7,0xFF27},
  {0xA3C8,0xA3E8,0xFF28},
  {0xA3C9,0xA3E9,0xFF29},
  {0xA3CA,0xA3EA,0xFF2A},
  {0xA3CB,0xA3EB,0xFF2B},
  {0xA3CC,0xA3EC,0xFF2C},
  {0xA3CD,0xA3ED,0xFF2D},
  {0xA3CE,0xA3EE,0xFF2E},
  {0xA3CF,0xA3EF,0xFF2F},
  {0xA3D0,0xA3F0,0xFF30}, /* A3D0 */
  {0xA3D1,0xA3F1,0xFF31},
  {0xA3D2,0xA3F2,0xFF32},
  {0xA3D3,0xA3F3,0xFF33},
  {0xA3D4,0xA3F4,0xFF34},
  {0xA3D5,0xA3F5,0xFF35},
  {0xA3D6,0xA3F6,0xFF36},
  {0xA3D7,0xA3F7,0xFF37},
  {0xA3D8,0xA3F8,0xFF38},
  {0xA3D9,0xA3F9,0xFF39},
  {0xA3DA,0xA3FA,0xFF3A},
  {0xA3DB,0xA3DB,0xFF3B},
  {0xA3DC,0xA3DC,0xFF3C},
  {0xA3DD,0xA3DD,0xFF3D},
  {0xA3DE,0xA3DE,0xFF3E},
  {0xA3DF,0xA3DF,0xFF3F},
  {0xA3E0,0xA3E0,0xFF40}, /* A3E0 */
  {0xA3C1,0xA3E1,0xFF41},
  {0xA3C2,0xA3E2,0xFF42},
  {0xA3C3,0xA3E3,0xFF43},
  {0xA3C4,0xA3E4,0xFF44},
  {0xA3C5,0xA3E5,0xFF45},
  {0xA3C6,0xA3E6,0xFF46},
  {0xA3C7,0xA3E7,0xFF47},
  {0xA3C8,0xA3E8,0xFF48},
  {0xA3C9,0xA3E9,0xFF49},
  {0xA3CA,0xA3EA,0xFF4A},
  {0xA3CB,0xA3EB,0xFF4B},
  {0xA3CC,0xA3EC,0xFF4C},
  {0xA3CD,0xA3ED,0xFF4D},
  {0xA3CE,0xA3EE,0xFF4E},
  {0xA3CF,0xA3EF,0xFF4F},
  {0xA3D0,0xA3F0,0xFF50}, /* A3F0 */
  {0xA3D1,0xA3F1,0xFF51},
  {0xA3D2,0xA3F2,0xFF52},
  {0xA3D3,0xA3F3,0xFF53},
  {0xA3D4,0xA3F4,0xFF54},
  {0xA3D5,0xA3F5,0xFF55},
  {0xA3D6,0xA3F6,0xFF56},
  {0xA3D7,0xA3F7,0xFF57},
  {0xA3D8,0xA3F8,0xFF58},
  {0xA3D9,0xA3F9,0xFF59},
  {0xA3DA,0xA3FA,0xFF5A},
  {0xA3FB,0xA3FB,0xFF5B},
  {0xA3FC,0xA3FC,0xFF5C},
  {0xA3FD,0xA3FD,0xFF5D},
  {0xA3FE,0xA3FE,0xFFE3},
  {0xA3FF,0xA3FF,0xA3FF}
};


static MY_UNICASE_CHARACTER cA6[256]=
{
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx00 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx10 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx20 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx30 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0xA640,0xA640,0x003F}, /* A640 */
  {0xA641,0xA641,0x003F},
  {0xA642,0xA642,0x003F},
  {0xA643,0xA643,0x003F},
  {0xA644,0xA644,0x003F},
  {0xA645,0xA645,0x003F},
  {0xA646,0xA646,0x003F},
  {0xA647,0xA647,0x003F},
  {0xA648,0xA648,0x003F},
  {0xA649,0xA649,0x003F},
  {0xA64A,0xA64A,0x003F},
  {0xA64B,0xA64B,0x003F},
  {0xA64C,0xA64C,0x003F},
  {0xA64D,0xA64D,0x003F},
  {0xA64E,0xA64E,0x003F},
  {0xA64F,0xA64F,0x003F},
  {0xA650,0xA650,0x003F}, /* A650 */
  {0xA651,0xA651,0x003F},
  {0xA652,0xA652,0x003F},
  {0xA653,0xA653,0x003F},
  {0xA654,0xA654,0x003F},
  {0xA655,0xA655,0x003F},
  {0xA656,0xA656,0x003F},
  {0xA657,0xA657,0x003F},
  {0xA658,0xA658,0x003F},
  {0xA659,0xA659,0x003F},
  {0xA65A,0xA65A,0x003F},
  {0xA65B,0xA65B,0x003F},
  {0xA65C,0xA65C,0x003F},
  {0xA65D,0xA65D,0x003F},
  {0xA65E,0xA65E,0x003F},
  {0xA65F,0xA65F,0x003F},
  {0xA660,0xA660,0x003F}, /* A660 */
  {0xA661,0xA661,0x003F},
  {0xA662,0xA662,0x003F},
  {0xA663,0xA663,0x003F},
  {0xA664,0xA664,0x003F},
  {0xA665,0xA665,0x003F},
  {0xA666,0xA666,0x003F},
  {0xA667,0xA667,0x003F},
  {0xA668,0xA668,0x003F},
  {0xA669,0xA669,0x003F},
  {0xA66A,0xA66A,0x003F},
  {0xA66B,0xA66B,0x003F},
  {0xA66C,0xA66C,0x003F},
  {0xA66D,0xA66D,0x003F},
  {0xA66E,0xA66E,0x003F},
  {0xA66F,0xA66F,0x003F},
  {0xA670,0xA670,0x003F}, /* A670 */
  {0xA671,0xA671,0x003F},
  {0xA672,0xA672,0x003F},
  {0xA673,0xA673,0x003F},
  {0xA674,0xA674,0x003F},
  {0xA675,0xA675,0x003F},
  {0xA676,0xA676,0x003F},
  {0xA677,0xA677,0x003F},
  {0xA678,0xA678,0x003F},
  {0xA679,0xA679,0x003F},
  {0xA67A,0xA67A,0x003F},
  {0xA67B,0xA67B,0x003F},
  {0xA67C,0xA67C,0x003F},
  {0xA67D,0xA67D,0x003F},
  {0xA67E,0xA67E,0x003F},
  {0xA67F,0xA67F,0xA67F},
  {0xA680,0xA680,0x003F}, /* A680 */
  {0xA681,0xA681,0x003F},
  {0xA682,0xA682,0x003F},
  {0xA683,0xA683,0x003F},
  {0xA684,0xA684,0x003F},
  {0xA685,0xA685,0x003F},
  {0xA686,0xA686,0x003F},
  {0xA687,0xA687,0x003F},
  {0xA688,0xA688,0x003F},
  {0xA689,0xA689,0x003F},
  {0xA68A,0xA68A,0x003F},
  {0xA68B,0xA68B,0x003F},
  {0xA68C,0xA68C,0x003F},
  {0xA68D,0xA68D,0x003F},
  {0xA68E,0xA68E,0x003F},
  {0xA68F,0xA68F,0x003F},
  {0xA690,0xA690,0x003F}, /* A690 */
  {0xA691,0xA691,0x003F},
  {0xA692,0xA692,0x003F},
  {0xA693,0xA693,0x003F},
  {0xA694,0xA694,0x003F},
  {0xA695,0xA695,0x003F},
  {0xA696,0xA696,0x003F},
  {0xA697,0xA697,0x003F},
  {0xA698,0xA698,0x003F},
  {0xA699,0xA699,0x003F},
  {0xA69A,0xA69A,0x003F},
  {0xA69B,0xA69B,0x003F},
  {0xA69C,0xA69C,0x003F},
  {0xA69D,0xA69D,0x003F},
  {0xA69E,0xA69E,0x003F},
  {0xA69F,0xA69F,0x003F},
  {0xA6A0,0xA6A0,0x003F}, /* A6A0 */
  {0xA6A1,0xA6C1,0x0391},
  {0xA6A2,0xA6C2,0x0392},
  {0xA6A3,0xA6C3,0x0393},
  {0xA6A4,0xA6C4,0x0394},
  {0xA6A5,0xA6C5,0x0395},
  {0xA6A6,0xA6C6,0x0396},
  {0xA6A7,0xA6C7,0x0397},
  {0xA6A8,0xA6C8,0x0398},
  {0xA6A9,0xA6C9,0x0399},
  {0xA6AA,0xA6CA,0x039A},
  {0xA6AB,0xA6CB,0x039B},
  {0xA6AC,0xA6CC,0x039C},
  {0xA6AD,0xA6CD,0x039D},
  {0xA6AE,0xA6CE,0x039E},
  {0xA6AF,0xA6CF,0x039F},
  {0xA6B0,0xA6D0,0x03A0}, /* A6B0 */
  {0xA6B1,0xA6D1,0x03A1},
  {0xA6B2,0xA6D2,0x03A3},
  {0xA6B3,0xA6D3,0x03A4},
  {0xA6B4,0xA6D4,0x03A5},
  {0xA6B5,0xA6D5,0x03A6},
  {0xA6B6,0xA6D6,0x03A7},
  {0xA6B7,0xA6D7,0x03A8},
  {0xA6B8,0xA6D8,0x03A9},
  {0xA6B9,0xA6B9,0x003F},
  {0xA6BA,0xA6BA,0x003F},
  {0xA6BB,0xA6BB,0x003F},
  {0xA6BC,0xA6BC,0x003F},
  {0xA6BD,0xA6BD,0x003F},
  {0xA6BE,0xA6BE,0x003F},
  {0xA6BF,0xA6BF,0x003F},
  {0xA6C0,0xA6C0,0x003F}, /* A6C0 */
  {0xA6A1,0xA6C1,0x03B1},
  {0xA6A2,0xA6C2,0x03B2},
  {0xA6A3,0xA6C3,0x03B3},
  {0xA6A4,0xA6C4,0x03B4},
  {0xA6A5,0xA6C5,0x03B5},
  {0xA6A6,0xA6C6,0x03B6},
  {0xA6A7,0xA6C7,0x03B7},
  {0xA6A8,0xA6C8,0x03B8},
  {0xA6A9,0xA6C9,0x03B9},
  {0xA6AA,0xA6CA,0x03BA},
  {0xA6AB,0xA6CB,0x03BB},
  {0xA6AC,0xA6CC,0x03BC},
  {0xA6AD,0xA6CD,0x03BD},
  {0xA6AE,0xA6CE,0x03BE},
  {0xA6AF,0xA6CF,0x03BF},
  {0xA6B0,0xA6D0,0x03C0}, /* A6D0 */
  {0xA6B1,0xA6D1,0x03C1},
  {0xA6B2,0xA6D2,0x03C3},
  {0xA6B3,0xA6D3,0x03C4},
  {0xA6B4,0xA6D4,0x03C5},
  {0xA6B5,0xA6D5,0x03C6},
  {0xA6B6,0xA6D6,0x03C7},
  {0xA6B7,0xA6D7,0x03C8},
  {0xA6B8,0xA6D8,0x03C9},
  {0xA6D9,0xA6D9,0x003F},
  {0xA6DA,0xA6DA,0x003F},
  {0xA6DB,0xA6DB,0x003F},
  {0xA6DC,0xA6DC,0x003F},
  {0xA6DD,0xA6DD,0x003F},
  {0xA6DE,0xA6DE,0x003F},
  {0xA6DF,0xA6DF,0x003F},
  {0xA6E0,0xA6E0,0xFE35}, /* A6E0 */
  {0xA6E1,0xA6E1,0xFE36},
  {0xA6E2,0xA6E2,0xFE39},
  {0xA6E3,0xA6E3,0xFE3A},
  {0xA6E4,0xA6E4,0xFE3F},
  {0xA6E5,0xA6E5,0xFE40},
  {0xA6E6,0xA6E6,0xFE3D},
  {0xA6E7,0xA6E7,0xFE3E},
  {0xA6E8,0xA6E8,0xFE41},
  {0xA6E9,0xA6E9,0xFE42},
  {0xA6EA,0xA6EA,0xFE43},
  {0xA6EB,0xA6EB,0xFE44},
  {0xA6EC,0xA6EC,0x003F},
  {0xA6ED,0xA6ED,0x003F},
  {0xA6EE,0xA6EE,0xFE3B},
  {0xA6EF,0xA6EF,0xFE3C},
  {0xA6F0,0xA6F0,0xFE37}, /* A6F0 */
  {0xA6F1,0xA6F1,0xFE38},
  {0xA6F2,0xA6F2,0xFE31},
  {0xA6F3,0xA6F3,0x003F},
  {0xA6F4,0xA6F4,0xFE33},
  {0xA6F5,0xA6F5,0xFE34},
  {0xA6F6,0xA6F6,0x003F},
  {0xA6F7,0xA6F7,0x003F},
  {0xA6F8,0xA6F8,0x003F},
  {0xA6F9,0xA6F9,0x003F},
  {0xA6FA,0xA6FA,0x003F},
  {0xA6FB,0xA6FB,0x003F},
  {0xA6FC,0xA6FC,0x003F},
  {0xA6FD,0xA6FD,0x003F},
  {0xA6FE,0xA6FE,0x003F},
  {0xA6FF,0xA6FF,0xA6FF}
};


static MY_UNICASE_CHARACTER cA7[256]=
{
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx00 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx10 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx20 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}, /* xx30 */
  {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
  {0xA740,0xA740,0x003F}, /* A740 */
  {0xA741,0xA741,0x003F},
  {0xA742,0xA742,0x003F},
  {0xA743,0xA743,0x003F},
  {0xA744,0xA744,0x003F},
  {0xA745,0xA745,0x003F},
  {0xA746,0xA746,0x003F},
  {0xA747,0xA747,0x003F},
  {0xA748,0xA748,0x003F},
  {0xA749,0xA749,0x003F},
  {0xA74A,0xA74A,0x003F},
  {0xA74B,0xA74B,0x003F},
  {0xA74C,0xA74C,0x003F},
  {0xA74D,0xA74D,0x003F},
  {0xA74E,0xA74E,0x003F},
  {0xA74F,0xA74F,0x003F},
  {0xA750,0xA750,0x003F}, /* A750 */
  {0xA751,0xA751,0x003F},
  {0xA752,0xA752,0x003F},
  {0xA753,0xA753,0x003F},
  {0xA754,0xA754,0x003F},
  {0xA755,0xA755,0x003F},
  {0xA756,0xA756,0x003F},
  {0xA757,0xA757,0x003F},
  {0xA758,0xA758,0x003F},
  {0xA759,0xA759,0x003F},
  {0xA75A,0xA75A,0x003F},
  {0xA75B,0xA75B,0x003F},
  {0xA75C,0xA75C,0x003F},
  {0xA75D,0xA75D,0x003F},
  {0xA75E,0xA75E,0x003F},
  {0xA75F,0xA75F,0x003F},
  {0xA760,0xA760,0x003F}, /* A760 */
  {0xA761,0xA761,0x003F},
  {0xA762,0xA762,0x003F},
  {0xA763,0xA763,0x003F},
  {0xA764,0xA764,0x003F},
  {0xA765,0xA765,0x003F},
  {0xA766,0xA766,0x003F},
  {0xA767,0xA767,0x003F},
  {0xA768,0xA768,0x003F},
  {0xA769,0xA769,0x003F},
  {0xA76A,0xA76A,0x003F},
  {0xA76B,0xA76B,0x003F},
  {0xA76C,0xA76C,0x003F},
  {0xA76D,0xA76D,0x003F},
  {0xA76E,0xA76E,0x003F},
  {0xA76F,0xA76F,0x003F},
  {0xA770,0xA770,0x003F}, /* A770 */
  {0xA771,0xA771,0x003F},
  {0xA772,0xA772,0x003F},
  {0xA773,0xA773,0x003F},
  {0xA774,0xA774,0x003F},
  {0xA775,0xA775,0x003F},
  {0xA776,0xA776,0x003F},
  {0xA777,0xA777,0x003F},
  {0xA778,0xA778,0x003F},
  {0xA779,0xA779,0x003F},
  {0xA77A,0xA77A,0x003F},
  {0xA77B,0xA77B,0x003F},
  {0xA77C,0xA77C,0x003F},
  {0xA77D,0xA77D,0x003F},
  {0xA77E,0xA77E,0x003F},
  {0xA77F,0xA77F,0xA77F},
  {0xA780,0xA780,0x003F}, /* A780 */
  {0xA781,0xA781,0x003F},
  {0xA782,0xA782,0x003F},
  {0xA783,0xA783,0x003F},
  {0xA784,0xA784,0x003F},
  {0xA785,0xA785,0x003F},
  {0xA786,0xA786,0x003F},
  {0xA787,0xA787,0x003F},
  {0xA788,0xA788,0x003F},
  {0xA789,0xA789,0x003F},
  {0xA78A,0xA78A,0x003F},
  {0xA78B,0xA78B,0x003F},
  {0xA78C,0xA78C,0x003F},
  {0xA78D,0xA78D,0x003F},
  {0xA78E,0xA78E,0x003F},
  {0xA78F,0xA78F,0x003F},
  {0xA790,0xA790,0x003F}, /* A790 */
  {0xA791,0xA791,0x003F},
  {0xA792,0xA792,0x003F},
  {0xA793,0xA793,0x003F},
  {0xA794,0xA794,0x003F},
  {0xA795,0xA795,0x003F},
  {0xA796,0xA796,0x003F},
  {0xA797,0xA797,0x003F},
  {0xA798,0xA798,0x003F},
  {0xA799,0xA799,0x003F},
  {0xA79A,0xA79A,0x003F},
  {0xA79B,0xA79B,0x003F},
  {0xA79C,0xA79C,0x003F},
  {0xA79D,0xA79D,0x003F},
  {0xA79E,0xA79E,0x003F},
  {0xA79F,0xA79F,0x003F},
  {0xA7A0,0xA7A0,0x003F}, /* A7A0 */
  {0xA7A1,0xA7D1,0x0410},
  {0xA7A2,0xA7D2,0x0411},
  {0xA7A3,0xA7D3,0x0412},
  {0xA7A4,0xA7D4,0x0413},
  {0xA7A5,0xA7D5,0x0414},
  {0xA7A6,0xA7D6,0x0415},
  {0xA7A7,0xA7D7,0x0401},
  {0xA7A8,0xA7D8,0x0416},
  {0xA7A9,0xA7D9,0x0417},
  {0xA7AA,0xA7DA,0x0418},
  {0xA7AB,0xA7DB,0x0419},
  {0xA7AC,0xA7DC,0x041A},
  {0xA7AD,0xA7DD,0x041B},
  {0xA7AE,0xA7DE,0x041C},
  {0xA7AF,0xA7DF,0x041D},
  {0xA7B0,0xA7E0,0x041E}, /* A7B0 */
  {0xA7B1,0xA7E1,0x041F},
  {0xA7B2,0xA7E2,0x0420},
  {0xA7B3,0xA7E3,0x0421},
  {0xA7B4,0xA7E4,0x0422},
  {0xA7B5,0xA7E5,0x0423},
  {0xA7B6,0xA7E6,0x0424},
  {0xA7B7,0xA7E7,0x0425},
  {0xA7B8,0xA7E8,0x0426},
  {0xA7B9,0xA7E9,0x0427},
  {0xA7BA,0xA7EA,0x0428},
  {0xA7BB,0xA7EB,0x0429},
  {0xA7BC,0xA7EC,0x042A},
  {0xA7BD,0xA7ED,0x042B},
  {0xA7BE,0xA7EE,0x042C},
  {0xA7BF,0xA7EF,0x042D},
  {0xA7C0,0xA7F0,0x042E}, /* A7C0 */
  {0xA7C1,0xA7F1,0x042F},
  {0xA7C2,0xA7C2,0x003F},
  {0xA7C3,0xA7C3,0x003F},
  {0xA7C4,0xA7C4,0x003F},
  {0xA7C5,0xA7C5,0x003F},
  {0xA7C6,0xA7C6,0x003F},
  {0xA7C7,0xA7C7,0x003F},
  {0xA7C8,0xA7C8,0x003F},
  {0xA7C9,0xA7C9,0x003F},
  {0xA7CA,0xA7CA,0x003F},
  {0xA7CB,0xA7CB,0x003F},
  {0xA7CC,0xA7CC,0x003F},
  {0xA7CD,0xA7CD,0x003F},
  {0xA7CE,0xA7CE,0x003F},
  {0xA7CF,0xA7CF,0x003F},
  {0xA7D0,0xA7D0,0x003F}, /* A7D0 */
  {0xA7A1,0xA7D1,0x0430},
  {0xA7A2,0xA7D2,0x0431},
  {0xA7A3,0xA7D3,0x0432},
  {0xA7A4,0xA7D4,0x0433},
  {0xA7A5,0xA7D5,0x0434},
  {0xA7A6,0xA7D6,0x0435},
  {0xA7A7,0xA7D7,0x0451},
  {0xA7A8,0xA7D8,0x0436},
  {0xA7A9,0xA7D9,0x0437},
  {0xA7AA,0xA7DA,0x0438},
  {0xA7AB,0xA7DB,0x0439},
  {0xA7AC,0xA7DC,0x043A},
  {0xA7AD,0xA7DD,0x043B},
  {0xA7AE,0xA7DE,0x043C},
  {0xA7AF,0xA7DF,0x043D},
  {0xA7B0,0xA7E0,0x043E}, /* A7E0 */
  {0xA7B1,0xA7E1,0x043F},
  {0xA7B2,0xA7E2,0x0440},
  {0xA7B3,0xA7E3,0x0441},
  {0xA7B4,0xA7E4,0x0442},
  {0xA7B5,0xA7E5,0x0443},
  {0xA7B6,0xA7E6,0x0444},
  {0xA7B7,0xA7E7,0x0445},
  {0xA7B8,0xA7E8,0x0446},
  {0xA7B9,0xA7E9,0x0447},
  {0xA7BA,0xA7EA,0x0448},
  {0xA7BB,0xA7EB,0x0449},
  {0xA7BC,0xA7EC,0x044A},
  {0xA7BD,0xA7ED,0x044B},
  {0xA7BE,0xA7EE,0x044C},
  {0xA7BF,0xA7EF,0x044D},
  {0xA7C0,0xA7F0,0x044E}, /* A7F0 */
  {0xA7C1,0xA7F1,0x044F},
  {0xA7F2,0xA7F2,0x003F},
  {0xA7F3,0xA7F3,0x003F},
  {0xA7F4,0xA7F4,0x003F},
  {0xA7F5,0xA7F5,0x003F},
  {0xA7F6,0xA7F6,0x003F},
  {0xA7F7,0xA7F7,0x003F},
  {0xA7F8,0xA7F8,0x003F},
  {0xA7F9,0xA7F9,0x003F},
  {0xA7FA,0xA7FA,0x003F},
  {0xA7FB,0xA7FB,0x003F},
  {0xA7FC,0xA7FC,0x003F},
  {0xA7FD,0xA7FD,0x003F},
  {0xA7FE,0xA7FE,0x003F},
  {0xA7FF,0xA7FF,0xA7FF}
};


static MY_UNICASE_CHARACTER *my_caseinfo_pages_gbk[256]=
{
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 0 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 1 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 2 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 3 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 4 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 5 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 6 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 7 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 8 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* 9 */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL,  cA2,  cA3, NULL, NULL,  cA6,  cA7, /* A */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* B */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* C */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* D */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* E */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, /* F */
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};


static MY_UNICASE_INFO my_caseinfo_gbk=
{
  0xFFFF,
  my_caseinfo_pages_gbk
};


static uchar sort_order_gbk[]=
{
  '\000','\001','\002','\003','\004','\005','\006','\007',
  '\010','\011','\012','\013','\014','\015','\016','\017',
  '\020','\021','\022','\023','\024','\025','\026','\027',
  '\030','\031','\032','\033','\034','\035','\036','\037',
  ' ',	 '!',	'"',   '#',   '$',   '%',   '&',   '\'',
  '(',	 ')',	'*',   '+',   ',',   '-',   '.',   '/',
  '0',	 '1',	'2',   '3',   '4',   '5',   '6',   '7',
  '8',	 '9',	':',   ';',   '<',   '=',   '>',   '?',
  '@',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '\\',  ']',   '[',   '^',   '_',
  '`',	 'A',	'B',   'C',   'D',   'E',   'F',   'G',
  'H',	 'I',	'J',   'K',   'L',   'M',   'N',   'O',
  'P',	 'Q',	'R',   'S',   'T',   'U',   'V',   'W',
  'X',	 'Y',	'Z',   '{',   '|',   '}',   'Y',   '\177',
  (uchar) '\200',(uchar) '\201',(uchar) '\202',(uchar) '\203',(uchar) '\204',(uchar) '\205',(uchar) '\206',(uchar) '\207',
  (uchar) '\210',(uchar) '\211',(uchar) '\212',(uchar) '\213',(uchar) '\214',(uchar) '\215',(uchar) '\216',(uchar) '\217',
  (uchar) '\220',(uchar) '\221',(uchar) '\222',(uchar) '\223',(uchar) '\224',(uchar) '\225',(uchar) '\226',(uchar) '\227',
  (uchar) '\230',(uchar) '\231',(uchar) '\232',(uchar) '\233',(uchar) '\234',(uchar) '\235',(uchar) '\236',(uchar) '\237',
  (uchar) '\240',(uchar) '\241',(uchar) '\242',(uchar) '\243',(uchar) '\244',(uchar) '\245',(uchar) '\246',(uchar) '\247',
  (uchar) '\250',(uchar) '\251',(uchar) '\252',(uchar) '\253',(uchar) '\254',(uchar) '\255',(uchar) '\256',(uchar) '\257',
  (uchar) '\260',(uchar) '\261',(uchar) '\262',(uchar) '\263',(uchar) '\264',(uchar) '\265',(uchar) '\266',(uchar) '\267',
  (uchar) '\270',(uchar) '\271',(uchar) '\272',(uchar) '\273',(uchar) '\274',(uchar) '\275',(uchar) '\276',(uchar) '\277',
  (uchar) '\300',(uchar) '\301',(uchar) '\302',(uchar) '\303',(uchar) '\304',(uchar) '\305',(uchar) '\306',(uchar) '\307',
  (uchar) '\310',(uchar) '\311',(uchar) '\312',(uchar) '\313',(uchar) '\314',(uchar) '\315',(uchar) '\316',(uchar) '\317',
  (uchar) '\320',(uchar) '\321',(uchar) '\322',(uchar) '\323',(uchar) '\324',(uchar) '\325',(uchar) '\326',(uchar) '\327',
  (uchar) '\330',(uchar) '\331',(uchar) '\332',(uchar) '\333',(uchar) '\334',(uchar) '\335',(uchar) '\336',(uchar) '\337',
  (uchar) '\340',(uchar) '\341',(uchar) '\342',(uchar) '\343',(uchar) '\344',(uchar) '\345',(uchar) '\346',(uchar) '\347',
  (uchar) '\350',(uchar) '\351',(uchar) '\352',(uchar) '\353',(uchar) '\354',(uchar) '\355',(uchar) '\356',(uchar) '\357',
  (uchar) '\360',(uchar) '\361',(uchar) '\362',(uchar) '\363',(uchar) '\364',(uchar) '\365',(uchar) '\366',(uchar) '\367',
  (uchar) '\370',(uchar) '\371',(uchar) '\372',(uchar) '\373',(uchar) '\374',(uchar) '\375',(uchar) '\376',(uchar) '\377',
};

static const uint16 gbk_order[]=
{
8653,14277,17116,11482,11160,2751,14613,3913,13337,9827,
19496,1759,8105,7103,7836,5638,2223,21433,5878,8006,
4851,18766,18879,16728,8129,6200,19133,6389,2500,19084,
16228,5074,8130,5900,6201,3985,14597,11566,8588,8769,
15885,11411,11965,1961,18012,18303,12242,14118,11490,12911,
15015,4367,3184,2093,20937,5710,5108,10560,9993,18982,
8393,10697,14620,19558,14970,15193,5359,18189,12666,18192,
3310,18659,17358,7973,18673,19537,3404,9723,4221,16486,
7023,13648,16310,1049,1726,4799,15534,4366,17133,4192,
6219,5118,1804,2360,2279,14279,13740,4511,2361,12906,
16650,18590,4723,2001,16313,3594,21026,12146,19561,3800,
4161,16774,18892,17657,7025,892,7917,12245,3394,4813,
11902,3189,20002,2365,12964,18115,17660,20227,17182,11907,
11671,17562,17864,21131,13423,1361,12246,18897,14978,18848,
20727,5902,10726,21241,1906,13424,1408,20519,3038,18495,
20446,1431,17138,13464,14558,1221,6720,6137,17348,5268,
4448,11313,1760,6172,6870,5744,13541,3044,17701,14368,
16114,5051,9142,18776,5669,19089,11088,17867,925,10395,
4372,10578,2138,2554,18118,21087,13862,7461,14983,3322,
15305,11844,7924,8087,2542,20701,21772,2754,10490,8218,
14800,15869,14436,16119,1814,11543,17398,16069,19659,17020,
17844,5694,8833,16744,18925,4957,9812,6852,8036,12966,
14038,12145,16833,11165,17076,17756,3673,2367,20916,9143,
14927,6885,17486,7469,1661,2827,4627,18198,1307,19711,
17637,2595,2262,20807,1764,8150,18547,3192,9711,16262,
9144,2006,21629,5311,15743,14733,10991,15402,2916,17724,
12195,12622,5141,8039,15169,7780,4568,20835,21575,10580,
15022,9470,6853,3926,21563,1342,16745,8181,11526,1947,
7402,18641,14145,13149,19222,2468,12920,13916,21077,2968,
16438,19667,1768,15632,18374,4738,15517,16655,4309,2374,
14492,8602,3679,2103,1312,18681,6613,18604,20451,2755,
18218,19473,17854,20316,3003,4998,1391,20938,11169,7049,
18861,17577,18091,1937,4085,2059,20633,15948,1313,20138,
7785,16439,15081,20955,15117,17065,19924,13831,11913,20062,
7568,10703,3717,15480,6047,7790,16867,14223,12971,8429,
2008,2833,14026,1317,17493,19411,18551,15452,15257,18504,
4441,1769,7249,20128,5509,1970,9420,19365,20190,21617,
12202,15041,2871,19676,20388,21674,14258,2901,8058,5970,
20472,13257,18226,3694,17591,10279,1318,12409,7901,9794,
10416,10769,12876,17154,15455,19298,3970,21327,14228,13095,
8096,16072,21748,12581,9326,2311,5683,12641,3583,2184,
16464,6969,1795,6778,2880,15819,3433,7674,4713,17297,
8231,4333,9995,1841,5558,17155,17298,11283,18694,7946,
7311,13129,4753,21149,905,14010,18821,8532,11873,2190,
19006,3456,8874,7433,2841,7680,14143,20130,1993,1699,
976,15361,2736,2154,9202,11685,7951,12982,11008,16763,
11829,13327,11686,2299,9940,10507,8917,1277,19790,1636,
20143,21002,15011,19443,6026,13299,2455,9667,15612,16477,
10261,2811,2202,13674,14760,6818,9691,10624,20145,11940,
15524,18349,9437,11578,20132,17736,4121,4122,16023,2280,
4371,4373,7873,18307,14602,14695,13054,5410,6065,14389,
3979,1137,5411,6672,16311,11632,9829,19575,5901,15708,
12553,7165,18983,10860,13664,18242,10848,2049,8075,5579,
8083,10863,21136,5445,17851,19132,8597,18771,11054,14631,
10997,8292,8803,11246,4999,17559,11134,15369,5155,6407,
12054,4857,11265,12834,7322,15057,10937,15984,5544,8040,
13291,3961,5142,19101,869,9631,2009,11315,21404,3172,
14941,4204,7947,9997,16906,4035,4476,4477,8171,2818,
20725,4724,11453,20868,4725,4729,8565,5109,12490,8862,
5920,13737,2888,6930,12963,3223,6934,3395,16243,8397,
9475,4858,13515,3777,11266,10029,21028,1671,7765,7766,
14169,2221,5328,2907,8951,4225,4416,7770,3046,8014,
3975,10636,20236,19825,3248,8717,2140,2908,3249,9477,
4628,2225,12676,2909,21564,5167,1225,4186,13266,4017,
7471,7146,18214,6890,4195,16037,16688,5583,14497,7476,
3286,8566,2910,2862,2232,16038,10417,9492,12234,14190,
8793,5573,6486,20322,21455,9734,8317,10143,5781,7681,
5782,7500,7501,15466,7188,7511,7512,21003,2203,21693,
11350,9540,21212,18183,7918,8754,17511,20869,18899,21160,
11356,9315,8364,8798,18460,16189,17483,11415,8897,7771,
9917,8718,7926,5228,11270,2644,9269,19404,8719,8367,
13267,10400,1914,2157,8584,11171,3964,17881,16785,18951,
18052,16616,14500,9323,10418,12410,14661,6963,7570,7668,
13601,17386,18995,8437,4460,8346,15920,8318,3387,10734,
18057,18058,10525,9654,2390,13675,13603,20000,8106,1260,
10824,1426,5075,5076,18887,12175,8174,15558,5269,4304,
5380,3287,8156,5386,11605,8142,18768,7580,8641,6319,
13425,4478,13147,2019,8900,6331,19668,5756,6769,3381,
9009,9730,9735,15160,4036,8167,13489,17009,8667,18308,
13439,18112,11735,21667,14617,17010,16290,16291,17515,3368,
7050,14841,5636,16826,17573,7760,18493,13306,14312,2619,
17868,13609,8991,7038,4310,16881,14020,16422,20565,5941,
18174,3642,20346,12080,856,13144,18158,20908,10800,15630,
14340,15837,21707,4629,2060,19870,9632,3718,7902,994,
5762,18391,9647,2312,9199,9648,18281,18342,19911,5367,
9950,13834,13513,8771,9414,4057,21302,1963,1964,1967,
902,3349,14697,5602,1071,13959,14621,21428,7288,15079,
7039,16495,13949,3111,5580,13365,2615,4109,6202,11213,
10792,17918,21538,3226,18658,11985,6862,18734,2752,13232,
7838,1907,4252,6223,16703,11495,18037,3974,6301,5226,
8514,10487,5267,10892,12763,16706,7702,20003,2616,14457,
16083,16587,4296,14513,8355,12171,16590,10670,13651,3646,
14626,21132,15826,17015,18911,12792,12461,21545,17848,18912,
17396,3277,13516,5918,16115,12548,1673,4864,18438,6078,
5880,3263,16211,21784,1909,15296,17183,6884,12796,4417,
4299,17021,21137,14801,17484,8852,6512,15560,4300,17921,
5819,9342,15900,17742,19525,3869,11715,17703,12554,6040,
19865,10267,12549,10804,21670,6091,17277,9319,12531,9840,
1060,11215,10514,15170,4892,5904,14898,19534,5469,5470,
1128,5922,18937,7270,15971,17189,16263,9474,13382,2369,
20210,18177,3976,12767,3618,13236,10885,5397,15621,8770,
9830,9310,14121,21573,16634,19148,12803,4381,13051,956,
20237,3755,19551,15744,9169,16852,866,11893,21439,3680,
6197,17412,17324,16086,16747,16602,3834,5510,12770,12771,
3420,16198,21552,1421,3198,6097,18178,12772,20576,9831,
17200,19226,5584,20226,5822,10609,11641,3599,13550,15387,
5361,15481,952,3426,19731,20581,21103,2153,16223,19719,
20139,18533,11172,6356,20044,6584,6585,6954,21058,16397,
14150,17888,6618,4199,11775,9843,19732,14051,2564,13093,
18379,3377,12174,1968,19359,16350,19294,12243,1294,5362,
20214,6898,15645,18557,6146,13005,14084,19366,6272,17534,
10713,2104,5894,13900,16200,6964,12093,16692,12975,21496,
9358,16216,7314,15280,3056,14008,5363,11510,13001,1474,
997,9724,21709,20612,11383,15441,7715,2684,7622,8585,
15456,14192,872,17497,10281,17428,6338,6779,5831,11989,
17156,20245,2293,12512,3560,10705,6367,5040,15465,18663,
14003,7716,17498,6462,10721,13660,9327,17501,6973,9010,
17433,6024,10669,13098,2842,15393,3436,18133,4283,21749,
4461,2571,6707,1986,2900,3138,3434,19771,9090,16900,
12816,6022,9736,17830,6708,19167,18099,11781,14950,18337,
19249,3270,20404,21152,11875,6791,17596,7723,19933,884,
19376,8877,19687,12164,3544,17647,4150,3457,17648,12338,
19127,21715,11831,3635,9259,15329,6901,17127,18710,4191,
12352,21112,7195,7956,2300,18061,10887,15701,10319,6808,
1859,19445,11794,19170,6436,10969,6216,20594,9522,10157,
5898,11567,11326,18410,9674,10340,10229,11345,3447,2456,
12439,12340,17368,10889,17057,4224,8845,18285,2207,19263,
3872,9117,15331,17456,2995,6523,6919,21337,11803,17457,
1936,9533,2248,2161,9697,19072,10607,20163,15100,6199,
20287,7392,20107,21238,9225,11809,13650,10203,6717,19085,
11816,16035,8643,19823,8084,12359,20004,3059,6719,4253,
5838,15886,15982,5839,13638,13780,5840,15341,5842,19140,
6854,5923,10582,5843,2868,16398,19872,13534,8824,12598,
19879,19880,18208,16051,16004,16005,16039,10567,6783,19020,
10539,10550,18184,16018,15868,12573,10392,8863,8172,19697,
12845,12846,21424,3476,12833,17119,14167,11764,11357,7264,
20873,18048,18901,13220,4667,8756,16106,4705,1432,8009,
3665,7966,7128,2587,7967,12053,15477,13430,20832,5587,
15350,8076,18496,4801,10396,13339,5438,18013,1074,10032,
21247,4985,6322,20909,989,3323,12104,11235,7138,6138,
10512,3008,2621,19090,6306,4110,20541,4877,5674,18543,
4231,5748,2116,18465,17517,14702,1762,6233,3281,8548,
3479,6000,954,17677,17278,1186,4803,1097,18938,19207,
5954,17874,2917,13191,1374,4557,13610,19406,8518,7240,
3675,9306,8357,7882,20573,9913,6446,1915,8078,18661,
3600,18200,13551,15199,13252,16268,8298,10602,20739,8775,
2704,3928,15450,1948,2829,1375,8603,4214,18952,20841,
21403,12685,8299,11653,8726,9031,11701,7331,5169,19721,
4311,5546,9471,4548,18163,9032,972,14386,11607,15974,
2517,6540,1462,9789,5823,21324,1244,19595,10838,7744,
13909,18685,5360,21578,19596,6619,4318,18552,1268,3013,
10906,2309,16148,12551,4773,21079,7858,7887,6198,5174,
2935,8605,12479,9418,17729,6610,4093,16233,17928,17030,
7062,8871,19299,19417,8569,15122,14579,11123,16618,2526,
15997,13618,21060,9639,12203,1209,20185,4112,15728,16751,
20767,18053,20711,898,5381,18272,8607,16540,17592,10190,
5887,9300,2294,12204,1384,2426,10427,10374,11972,12978,
10920,11384,16040,14865,10301,1622,2072,20975,20512,8617,
3765,2439,20849,7172,5829,13045,7943,3700,3174,18392,
15307,20290,12928,16506,21383,13068,14230,14231,1088,12583,
8875,3942,4462,13626,4146,3217,3701,14505,4242,4245,
15413,3587,11432,4684,6631,15414,3271,18690,21282,7502,
1039,13032,13072,8748,19021,12316,3766,7551,18665,1852,
15419,9243,8322,6513,3492,13684,12987,18062,9260,16999,
906,18151,3529,13911,7957,9427,8940,10341,18286,15427,
16481,6514,10263,10264,13950,9675,9985,2208,18070,18291,
9406,1106,16240,14024,21355,18735,10727,21254,21358,6353,
9064,6357,17889,9070,14715,10820,4147,14718,18755,5496,
7582,4769,20373,1592,15166,13637,10033,3251,17753,17613,
11596,17130,19916,10850,4182,13264,11964,5447,12805,11003,
11047,2440,20269,5601,5209,15535,15370,18300,1406,6926,
20037,7229,1056,4359,3596,12118,8363,17518,3735,18497,
6573,8553,20360,1351,6662,4610,3780,18127,1363,1032,
16617,12536,16800,1037,7571,9731,4203,19993,7572,14677,
4715,6902,1527,10540,2376,3886,12847,8131,11926,2135,
17136,4517,7104,6221,3365,4816,8031,5875,16599,21029,
11997,5995,21069,20005,4807,2552,8400,21341,18361,11496,
17629,4669,4726,16292,4072,1075,21429,20521,11523,19918,
15958,17185,18913,4247,11358,1436,14370,4248,6080,17849,
4434,20728,11236,1173,4817,10034,21539,13666,14173,18439,
10741,21482,8275,13754,3952,7040,5056,17377,6456,8339,
5443,7327,7328,11738,20834,20673,17273,6182,5675,8491,
8847,18364,11314,9918,12150,4302,19527,18255,14375,14566,
5749,13543,15020,6234,17279,14316,2502,17574,10805,4827,
11443,8723,2979,2980,15870,17708,11546,19581,12503,11626,
20926,5924,21344,12472,16076,17280,16710,18256,16748,16841,
18260,19582,14989,9609,8190,21375,12628,17194,21440,3929,
10404,879,4249,10275,11146,3095,12550,8191,1949,10054,
17413,14766,12773,6692,5001,16647,16648,15405,4581,4582,
15709,11654,13552,8046,7979,12868,3756,17726,6421,16231,
9150,19109,21097,11614,5002,10583,973,9033,19149,18201,
8192,9622,3737,17195,6447,6480,3483,18605,11564,13964,
7294,15949,19734,16351,3689,13838,10941,3378,13918,13178,
6693,16657,12924,2936,11189,5005,7831,4086,18806,21080,
6620,11148,932,19228,17929,7745,16352,20747,13345,15635,
17584,16171,9790,10871,13670,14932,12361,16502,16199,3132,
6358,7791,1245,17817,15950,5715,21662,18558,19882,13796,
13901,10132,10944,12039,1026,10672,9002,13206,20689,19883,
7746,13800,11302,19235,15124,11752,15542,12085,9276,11609,
1235,12346,18996,19759,17966,10773,18749,8627,19370,11703,
5719,7905,21307,20246,5908,9361,20563,6426,6427,1034,
13922,10677,12423,5487,16758,13099,16174,20438,11193,17210,
17211,11392,9864,9712,6490,5723,3572,20852,17832,18753,
6482,16901,9011,13705,18396,2181,7625,10946,4534,4463,
17161,19022,6168,7724,4536,14680,15209,13033,9774,17945,
17649,11755,3943,19023,1971,907,11742,11832,10673,15800,
2738,7958,3028,19632,12437,13822,13876,11528,18236,15363,
19255,12988,19972,11154,1403,14431,17732,11711,4037,10186,
19849,9247,18411,10100,7696,11743,9249,17172,19264,14855,
6822,13579,11104,9538,10541,18292,21213,9251,8394,21477,
17662,14984,15342,19522,21318,15232,11216,3096,12869,18145,
11682,21506,9501,18022,1877,11517,11798,19265,10542,13830,
13303,7230,13858,18591,18772,8010,21395,21223,6229,14563,
18794,15793,14603,2503,13642,5375,17403,20364,3516,14419,
6659,11115,8804,1950,20141,19831,13343,6142,20637,7482,
11825,1770,6541,13226,14576,11826,7938,11847,20963,19677,
1247,8885,11827,8312,13229,6339,14584,11828,14425,16469,
17560,8886,6784,8533,19039,18830,1257,13187,2705,1258,
4762,10511,4124,12519,21303,4828,8724,7588,21305,18092,
14812,4131,3527,7762,4393,4394,14764,14280,11327,9907,
17242,17243,9046,16304,9904,10796,16305,16306,16307,18541,
4232,8998,21059,5110,5515,16061,5115,5116,17012,1390,
7844,15716,3798,14519,20669,17576,11649,16842,16843,10758,
10309,12474,15684,4631,17585,10500,2084,17597,8329,8391,
9883,8392,21237,17624,11692,16188,17134,9579,4288,3503,
6742,10206,13743,16775,5949,14364,2765,18725,19947,1157,
18592,981,16777,7768,4290,4670,16248,12907,12663,7839,
21769,21770,18498,8276,5161,18015,12501,9591,15773,13432,
4865,16137,12288,1030,8924,13433,12525,15774,10036,2589,
12463,2091,1185,15898,18016,1588,6083,8721,10649,4303,
4990,3826,10399,4363,4375,5057,13530,18786,11438,14567,
926,16386,6533,11113,9552,7139,3954,16387,19529,5502,
9919,18545,7610,4258,17519,1884,13639,4736,11585,9555,
19464,17281,13793,3517,14382,2504,15985,5349,5231,17082,
19141,19665,9307,8616,17234,13611,2695,15316,9955,6478,
8193,9151,11248,9034,9035,21671,5547,18164,5179,10584,
10585,10055,4187,20740,19151,3965,5926,20741,16440,12301,
7787,21672,8823,3930,19152,21490,20275,6621,19597,18474,
4742,13395,18475,15636,18862,20956,14654,4319,21271,8594,
10518,18318,10942,5932,6955,6586,15855,16795,19598,21579,
9193,8712,18267,18268,16447,21580,2121,15200,8679,13179,
12699,15998,4113,16882,16619,2010,15485,13801,7795,870,
10133,16801,13060,1368,3719,12950,19418,11778,3238,14580,
13968,15043,21588,7596,9858,8628,2233,3853,2076,3890,
15978,10302,20433,20434,998,2031,13447,13009,3175,21713,
3524,3525,16958,19760,12160,10221,17387,2085,1796,13182,
7626,18232,9328,20458,9866,9867,7890,4243,21738,7721,
8441,18574,7627,18575,8442,20405,19024,18023,11593,18705,
18706,18824,11788,17251,7074,17601,8707,5724,3710,1040,
21730,16369,13823,3530,10114,7818,19688,19975,19196,13859,
7823,9660,5732,10230,10231,19319,16937,8244,2209,19345,
8961,18287,11599,13580,2359,3159,10543,3729,3730,11805,
18293,18294,18354,8989,18295,8861,6605,7968,2341,9938,
8768,12561,12562,13406,20792,20522,18795,7897,15252,13598,
12240,4852,20087,3876,11763,4648,12010,20874,6409,3412,
3325,11359,4866,11367,18927,18928,12467,12835,8356,13863,
14839,14878,13123,20625,14523,13643,3336,5707,12475,20508,
7408,16232,3339,14148,12687,4061,6287,20780,17818,16400,
18969,1192,12480,3839,5382,12040,15543,11124,7309,15602,
6704,21044,14193,1623,5847,20247,11469,1193,8019,2236,
20985,6342,1492,1504,20496,11136,13073,2171,4685,11015,
1195,2739,11224,2793,7816,17258,9214,7318,1761,5147,
7112,15831,20270,5689,10886,13188,4163,18175,1124,7840,
21342,18140,3047,15899,18853,20918,15766,20919,17405,15986,
5754,8835,10998,19501,1885,1763,2547,9152,7051,15026,
14808,13284,19736,11210,15061,2064,17327,4633,8155,4327,
16448,10191,17124,15062,20964,1923,13258,8159,8160,10282,
19210,3348,10428,18997,2788,16006,14951,17645,11211,2313,
16759,4637,5691,8789,8878,1513,13034,9999,9884,10342,
7208,19346,17173,15845,19387,9539,15847,18074,3612,12524,
6721,11524,6722,4706,8251,18309,20183,18728,4413,14016,
4414,14663,3799,6402,16674,3664,7583,1095,14412,20469,
15536,4954,3649,2329,20674,18787,8365,14285,19827,8041,
3781,20470,7589,13024,12198,1463,14347,15407,7422,5256,
4428,1475,8794,7429,1682,17439,3437,5832,7552,6264,
11065,5836,16239,8476,7122,10397,6770,6771,18825,18826,
18836,19941,19942,16558,18365,19706,2556,3782,19419,12386,
2582,21425,16167,7028,21030,16314,3597,10037,4867,16320,
16834,16192,2543,20927,8042,3094,20798,3097,16984,7154,
20939,3065,21098,9153,17578,7857,7477,14656,7295,1595,
5007,16449,1210,16883,20750,12413,15649,3561,20754,1676,
2686,2387,18576,6792,10927,10271,17338,1280,13490,9371,
13717,3895,5069,13719,5093,18895,14619,16819,4457,19220,
11238,16588,16780,7029,17016,7841,16249,3061,19702,12664,
3190,15371,16092,12908,6842,17740,16318,17139,8623,8277,
18915,1238,11239,12128,8801,1174,11583,15810,5542,8283,
19457,3670,15969,19460,4821,17017,1437,19436,17979,3064,
1738,6656,18038,12251,14802,16835,15386,19400,11360,8772,
14633,17022,9344,6183,8902,11416,20884,17520,15767,3827,
6041,5750,12620,17485,14929,6328,13340,6723,2645,18788,
17743,5604,10010,2624,14282,13531,19953,12179,3554,6754,
17406,10801,19407,19828,12258,19955,19722,15988,7855,20577,
10011,6042,13150,15685,1916,12969,16845,10742,18954,6179,
2544,16786,9484,9295,3066,18955,9610,11603,4312,16788,
3098,3557,2322,10985,9623,5646,5641,12629,8777,15745,
10586,16868,8604,5796,11702,4142,5857,20398,19836,7885,
7161,9956,19723,6106,13553,15406,15689,11772,2981,6832,
17639,4282,15278,21613,7332,19412,3558,11608,20063,3840,
2970,13315,2065,1573,6835,21581,15637,1324,17930,16353,
5277,16450,1465,17931,6587,11173,19413,12806,14256,19110,
2421,10875,12840,8731,900,13156,18319,13919,21614,13998,
19229,13624,5383,20021,15132,12707,18560,15042,6665,7064,
5516,8313,2911,11704,17535,8570,20769,19420,2042,18131,
14446,1834,8586,17035,6859,19422,18507,9640,14053,15544,
19118,17896,15382,20067,11316,5407,3101,12414,11470,5848,
2665,1985,1980,1978,3176,11284,20476,15945,1035,14866,
5648,13627,20215,8161,9726,11995,15044,7944,19212,10523,
14260,16041,10744,12882,14352,13297,3707,20853,10283,8383,
12648,12643,19772,12491,9860,3115,19442,2687,20986,15946,
2474,12817,13449,12214,1335,13328,7628,2661,9737,12494,
9012,6786,2533,19214,19215,16992,16993,3438,15415,4244,
4177,15139,8454,2074,17434,4465,4714,9329,9362,17212,
11285,9868,16760,1987,8443,3139,17304,15442,14485,12280,
19025,17162,11876,3439,15443,8022,15032,6985,16515,6520,
13218,13213,8323,2043,8750,19256,19026,10001,14089,8534,
6504,908,18238,9098,17128,2669,19633,19217,3316,11048,
910,11016,4136,12731,11353,9205,10989,2740,21004,11955,
2792,18512,1860,21010,8942,8918,19446,4850,10158,11225,
2540,6809,2254,9248,6506,17972,13691,2256,7209,8336,
6524,14358,9808,11563,11076,15525,8477,21363,5186,19944,
5244,7323,3962,3835,1943,7276,20814,8973,20456,13010,
5259,7430,19761,18334,17044,20461,17050,17052,13492,6403,
6405,4289,14622,15676,10851,3752,14272,18796,18858,18320,
13367,9372,4512,13896,20126,20502,3797,19543,8815,5950,
14365,2095,16110,5497,16776,3566,13744,2096,12909,7265,
19564,1029,16825,20875,20905,3567,18301,8908,1583,8173,
16589,6347,19948,13234,14413,20763,20038,16250,11622,12542,
12543,1073,1020,20229,20006,1739,20880,11540,12559,18593,
20671,20312,18440,6068,11675,18672,2642,12253,7231,10952,
13434,2822,7233,20423,12100,11484,12910,16116,1125,3651,
8284,9079,12829,12861,6169,11818,5398,3221,2622,17521,
2054,6683,1109,20920,9081,4212,4213,11887,20702,5270,
7704,3956,11486,9920,20313,10367,3828,8407,9912,8256,
18196,17190,19661,16120,1820,5350,15671,2509,14122,8758,
10939,11888,8182,12193,7403,14178,13957,17523,2101,4770,
7655,8183,6886,15989,12544,20274,15038,18649,8414,16254,
1917,21752,18677,20375,10368,15058,16121,1188,16434,16294,
13198,14335,11249,10977,4962,3511,16649,8358,19962,21612,
15746,15973,1355,13958,21757,16656,12631,2512,14067,10572,
13292,5170,3655,6855,12688,14737,12872,10056,18202,20742,
9832,5590,11679,6891,18375,20766,1952,1731,15687,21643,
8751,12006,7737,11319,5333,10992,14052,12235,11944,7413,
20748,8118,7414,18273,11558,6209,12344,16354,13999,11761,
14657,21615,20712,18094,6624,1596,18476,6588,18321,21705,
17819,8705,7046,15690,9113,9121,2422,8120,15995,6694,
5325,2707,17426,17586,12922,2106,1289,18553,16355,3565,
16605,21616,5326,5451,13240,13802,13619,2711,15246,15234,
13803,12205,8685,18561,3522,20817,11914,9109,13419,17244,
7939,11219,4328,2922,14191,15318,20350,12042,9641,15545,
6359,20965,16202,17095,16606,13043,15730,20641,4329,11939,
13563,20368,16752,14349,8638,13804,13990,2234,15265,8122,
2685,2894,5849,4775,3702,12812,15070,9770,2475,2568,
5649,10429,10303,21619,5080,6428,20369,13046,15531,6487,
11516,7546,5720,19339,1004,20987,11782,10745,2253,8795,
2767,14353,16042,7675,2169,12884,1662,7594,18566,5458,
12885,6974,12417,9313,4151,17301,13910,5783,20142,19007,
17213,2477,11592,6276,5697,3272,11727,9998,20770,6709,
7682,7117,2025,15459,3406,1797,2375,8390,17435,1358,
4973,21451,16175,12569,13241,4148,6463,7683,15325,13131,
16643,7435,19378,11574,10380,21452,20254,12571,2992,6993,
3467,14090,13276,7756,8860,3388,17543,18699,1043,8324,
18700,4343,10993,11066,7118,15364,3531,9246,8267,18656,
13908,18715,18711,11688,6903,7819,1717,11833,5263,21005,
7817,9093,11343,7524,17550,9943,15396,1121,15086,10320,
10570,13706,21006,18513,9453,1932,14761,3157,11732,17259,
8542,9676,9130,6569,19320,10343,10265,12893,12894,12899,
9215,17174,19266,10930,2173,19321,3154,17554,14359,10645,
10933,11077,2580,20146,10544,15397,9698,3731,16207,3470,
7698,9252,9704,5767,5771,6957,18101,8654,18849,5096,
1140,12527,3715,8802,11271,16783,6092,2057,2828,5274,
17882,7710,2416,20634,4197,19671,1129,17883,4198,11776,
3738,4188,18970,8713,18381,6958,15960,17494,4200,18478,
17067,11280,873,874,3633,20715,14821,9870,13450,17754,
18870,7685,14235,7686,21462,19040,9775,1521,9528,17504,
17505,18011,12669,12677,8419,20377,20378,1147,19690,9221,
16487,14459,7291,7296,19678,7717,15962,4011,19137,12994,
13466,20429,21443,21447,21453,13211,9972,21463,2846,4106,
21215,7846,5998,12151,19461,11481,12678,12263,10127,4830,
4569,7982,20546,18863,14293,7483,4368,20996,4466,12391,
4467,20414,8881,15223,19646,7123,7156,6895,17513,15764,
15348,3667,17805,2222,18456,14564,11240,11241,16084,2931,
16740,1302,1158,7769,14460,6416,4564,5768,17920,4651,
13221,6324,18251,20273,4565,14437,8285,18467,1742,17981,
12528,20675,10041,6038,11368,1593,17872,6829,21627,14637,
4625,3870,16539,3924,878,1743,983,10210,8927,15794,
14574,6661,17923,8964,8848,7656,7929,20929,15903,6271,
5059,17362,5957,8521,17282,9030,21142,16846,14496,20578,
20579,5961,6045,16271,15748,21444,21722,21126,14210,11681,
16870,12775,20768,18971,961,16277,9958,2268,16325,17473,
4602,17975,18813,20068,6698,17857,11253,18643,19350,14773,
16456,13275,10876,11552,7423,18479,2937,18567,15281,12600,
7676,8573,5236,16622,2324,12813,6052,18393,9649,7183,
10986,20150,17598,6053,11393,3076,11708,20482,6787,5977,
17968,2874,9874,15444,8023,12418,9973,16994,19027,7189,
6675,3350,18695,18696,9655,15420,15927,17477,4639,14429,
20556,6027,19041,17388,17691,14198,7688,1278,8067,18405,
911,18712,13881,11019,9668,2434,8943,3863,3864,18635,
6920,10483,13827,10236,10646,10545,14163,15526,18355,21216,
19936,18904,6325,14734,2028,14470,20288,1984,17891,6772,
19191,13158,4664,12324,1141,10042,4606,13468,11921,15795,
9298,21708,11298,6609,16087,12635,19232,21586,16342,15928,
9305,9330,10237,12445,14794,15622,13718,1053,4209,3505,
9582,13370,8108,1407,2494,3042,13898,12854,19565,16680,
18079,4479,21541,13747,16113,3668,10797,2553,18905,5077,
5370,18773,7584,14171,16293,8133,10798,16977,19860,4621,
3922,17141,2932,14727,6475,17634,11859,2753,15018,19951,
7925,6942,10831,1438,984,4672,18918,4818,11541,6417,
18159,3988,17654,18530,4279,20540,20056,21718,14461,3671,
10325,15019,11542,17145,14990,16978,5598,4878,11369,18930,
18674,18679,14638,11766,1414,18789,11678,9105,6085,12036,
4480,21036,3332,3009,18518,4822,14731,14306,15021,14376,
11545,19408,20921,20314,3416,5467,12563,990,4879,1816,
4233,1400,20361,14991,21256,12130,14627,5599,2118,18599,
8149,10174,10898,9600,13786,20199,13996,19405,18087,12800,
20626,18797,17351,20707,9612,14076,8590,1730,13728,1115,
13729,1765,21485,2719,18941,3049,7472,21719,4379,4400,
19713,4440,5399,20394,9613,19097,18942,14643,4893,13865,
18798,8821,13311,14040,18042,4234,2918,11418,20093,11959,
19223,7782,10175,20449,18088,13977,20635,1287,15839,9083,
8048,1826,1356,13929,16855,9278,10177,4739,12632,16593,
8497,5125,15113,13389,19504,10268,12182,21359,3681,17925,
15994,20213,19535,1457,3622,5928,20813,13761,1314,7409,
6581,16272,11937,7244,15777,7157,17414,10492,8890,2079,
4675,15024,14993,4001,13223,19335,8195,9065,21441,2164,
16441,8049,9485,1732,17122,4802,15566,20941,9154,9720,
21415,9489,12807,1750,10589,3067,12973,12700,1958,2177,
20582,4613,12019,1206,6836,2519,20201,9633,19738,19739,
5551,5813,3967,5172,16326,3257,4489,2466,20454,12776,
19839,18322,19740,13535,18972,13732,12637,21417,4914,9159,
21645,21646,4658,2395,13272,11658,16278,10412,6019,7748,
2723,8257,8226,2520,21758,13002,18147,12304,21445,21499,
1690,12201,3903,2804,2269,10970,6448,7415,5716,17031,
3539,5774,3739,20815,13600,11483,4965,5335,12236,14225,
18807,14390,4216,5014,16457,16361,7297,21587,7347,18814,
16955,18388,18328,7348,19679,6110,16663,12369,1476,18535,
5825,17823,13967,18480,9122,18274,1353,6699,8975,7859,
8976,14937,4748,16173,7052,11471,10877,8831,6364,15860,
19611,19481,3070,17992,18505,20643,12370,18691,7796,18692,
14887,19602,16362,10915,15692,7058,7797,13854,6628,9380,
13564,17332,14606,15409,16542,14408,2779,12309,7300,18998,
20435,4929,11948,11127,5527,7497,15300,18609,14133,19889,
21557,11307,15133,7310,18568,7806,6674,5148,12929,10706,
19890,13809,14585,20820,16547,15861,13805,15490,20380,14943,
14506,8690,16890,5522,12644,5215,15238,12043,15547,5289,
2939,20652,11894,7070,5455,13011,12953,10921,17901,5184,
21420,16154,13096,18523,3721,7301,20976,3526,10222,14042,
16962,6975,9771,6788,19373,12983,5864,5087,5088,16043,
6488,14108,3179,12211,19513,7574,6431,6596,5784,11783,
19008,5199,8631,5725,5726,10747,20588,21351,9382,9302,
2427,3077,9502,17769,13277,14867,15892,5652,20250,15140,
9392,10377,9824,11135,10286,2347,15141,8693,1628,10435,
8123,20614,20325,14755,10748,11476,18525,15782,12212,21285,
14134,13572,7358,3078,6976,18233,18030,4423,18102,20856,
21710,3109,12603,14824,6489,9018,20659,14236,16908,2943,
3767,4430,11338,16764,13698,10016,10150,13104,17305,13956,
4494,20440,9353,20031,14892,4152,2480,15500,11009,15148,
8456,15421,6793,6986,11941,16176,11841,13935,15929,20295,
4689,13329,13672,6191,12935,5489,10184,9364,5200,16995,
14508,21558,14031,7083,3981,7995,7513,2845,3312,14758,
7555,10004,11581,19193,6801,14199,21731,17970,2484,5149,
8239,21734,19042,12606,4757,6738,3493,7196,15214,12496,
2537,2812,21294,6802,7084,7835,7303,14686,7436,13036,
3547,18872,1660,15033,14328,9661,19171,15580,15366,11155,
12734,16046,1734,6907,7202,12892,11690,11836,18759,5223,
7525,19218,11897,13288,18340,12735,11140,20559,5788,2945,
7000,8981,12517,3592,2794,5299,11156,19448,21012,6670,
12895,9430,9397,13995,10385,9669,3158,10527,11228,6814,
11979,10481,21007,5204,4039,19906,9677,4643,21465,15088,
9750,7602,2798,13302,21190,10348,18289,9683,21191,2458,
7824,4352,15099,6508,11800,19802,10238,9134,7646,17260,
5738,8268,17458,10103,19270,7384,19200,19492,19326,17341,
11884,1869,2211,9222,8270,14857,14362,21736,3113,13582,
13493,2022,8170,19809,10630,9701,3160,10546,3472,8481,
18296,9253,9228,21217,9411,9575,1108,11572,19816,10106,
5687,6517,12857,17808,2331,2825,12804,8582,18943,8415,
17025,17875,6069,9000,9273,8891,14905,862,17820,2629,
13239,8606,8893,8608,2873,5568,19113,19613,17429,18697,
16694,15460,7948,11973,6343,15695,6518,17833,12166,16996,
17502,17837,16910,9776,2847,19043,4350,19637,2994,6526,
1911,1912,8286,12915,2596,14082,2630,14086,21061,15203,
15204,9650,20251,19624,9656,5733,4287,20567,11361,11362,
18595,14464,17876,8421,12838,13390,15114,13269,18973,15961,
18686,1977,6837,3849,20653,20047,16543,2763,15696,7949,
14264,19168,3788,8162,9019,3165,3389,4080,7556,9803,
1719,4040,7378,7385,21257,13293,18956,14123,8704,13125,
18554,18129,6773,13628,6970,11974,6737,4103,18760,17463,
5637,10935,877,7830,12293,2197,10829,10830,12290,9911,
7237,13997,11460,16169,18089,4401,13794,17235,8221,13391,
4002,11963,12138,8227,4189,1392,14019,10878,14001,14749,
16184,6111,15323,14021,10479,11433,9507,15930,13816,20410,
14071,20411,11022,10386,3868,8398,12785,18461,11633,1712,
14377,12801,16847,13253,18205,3934,18508,20026,20762,1727,
3474,14876,9373,11693,4515,5741,1683,20271,11161,3776,
19946,2881,16244,4518,3320,16111,10794,13371,12447,12849,
16675,16676,16020,8132,20793,20876,12855,8011,8012,13939,
8490,6225,13589,1584,5137,21027,12072,8402,6390,11853,
17866,17869,20007,18302,3413,19454,6411,6881,11856,10893,
11109,2678,12073,1411,20877,12056,21372,20089,10122,20230,
4728,10953,20092,16118,9594,11089,18779,4425,15717,14926,
8925,8085,8177,18919,7234,21033,6746,1340,20232,21196,
19437,5466,6326,12178,3039,2590,15105,2462,14981,8217,
18039,14462,8404,4871,7106,5640,3414,19139,21089,18675,
6685,20127,2505,16388,6308,7465,14994,4376,17705,4881,
14075,20887,19205,16712,8657,10654,967,15679,11417,9442,
18739,11091,13545,12529,17465,17570,15107,8903,13152,8279,
12469,17744,20923,5676,11294,16683,13435,18931,8037,14521,
12239,2224,7927,9925,13383,16435,5925,10806,19465,1821,
3996,6240,18944,19334,9236,5943,9556,5331,9787,2951,
4771,18945,15905,9322,7242,2680,8090,15171,2467,12153,
17283,14440,9076,12453,5958,7977,11723,15972,17490,15872,
4259,16085,9614,14879,14995,9444,14880,4024,20015,6180,
17728,14711,2982,20493,8778,16273,16125,3931,16635,8196,
14343,9816,6833,15317,13154,3556,8372,5511,5858,5962,
21099,12232,6046,2264,12633,4546,2598,10405,8222,9445,
20611,12476,15747,19725,11655,10406,11118,8050,10058,10587,
13473,19726,11725,1619,6334,19837,9155,13254,12949,20890,
19184,1827,1343,19832,16603,13965,4583,19833,8711,7158,
14344,14079,12690,12343,16858,19835,13840,6589,7416,11927,
13397,15856,4743,16636,15639,16356,13868,2066,6099,18323,
6248,11097,10835,19230,18324,6210,14493,10943,20116,6845,
11533,5758,2653,4321,9791,12808,12809,10910,15727,3118,
16401,1969,6764,1831,17856,7060,7411,4788,18974,19208,
14577,7749,20638,15453,19603,1467,11277,14526,15975,14474,
19414,8228,3968,16054,7670,13398,15464,10220,6896,19874,
11559,1178,19508,13557,21347,9845,2178,17201,2956,6144,
21500,10759,19295,9119,4744,10277,16402,17092,19296,12506,
7940,5777,15282,19885,9727,18607,11004,21405,2527,15381,
3290,16203,5419,14055,20320,14581,10603,10688,16363,20117,
16802,16544,13006,20243,14529,871,20023,19114,15127,15290,
14530,863,12065,2837,16620,2011,11220,5286,6049,6673,
17036,3626,20966,19240,7798,5258,15176,7713,6775,19158,
5194,14849,2958,17495,19750,17782,6429,1478,1624,20977,
7595,8809,14451,14261,11128,1000,10375,6397,19441,2235,
4533,19372,5803,10762,13286,19619,7174,18171,2345,16989,
7175,10304,10223,7907,5850,3102,20854,5089,13030,7718,
3071,2961,16044,11996,15605,18664,16959,11129,15491,14262,
5975,9728,16204,2609,5113,12206,21572,8630,12187,20495,
2697,17902,6879,7499,18230,2902,9861,3185,15650,7549,
3103,19341,6258,17658,14820,5650,3104,9047,17903,20978,
12349,8444,7722,12508,3487,6789,7811,16761,12009,7075,
16410,15146,12956,17045,17046,15253,4178,11286,13955,15142,
20657,3105,18999,20988,16237,15394,18100,9013,18645,16007,
13982,6167,1505,2192,14780,12602,9969,16411,14095,14088,
2534,8099,6491,7629,9363,3218,6277,5938,20028,10192,
6278,4935,6054,6122,17214,7503,14197,17047,1038,10378,
11848,19634,10003,14486,3458,6599,20255,17604,19780,14681,
18024,10085,10782,21520,19379,6794,1994,9801,3768,18707,
6550,20660,10783,3407,19029,15210,12351,8325,15326,13215,
21459,11877,5833,7953,12165,14091,7085,16516,2810,15332,
15034,15884,14092,21234,9744,11102,14544,14825,11137,11849,
19312,19313,11017,7959,12732,7197,21716,16667,15553,19197,
19128,4133,3029,6904,13300,9261,8537,885,16413,1701,
5533,12941,19314,1702,9094,4642,2014,10888,7526,16478,
10666,20155,10454,9662,19447,18514,10384,15013,20997,19355,
4038,16334,6715,17614,12048,14432,1638,2200,11226,10159,
7375,14097,2539,5536,1706,6914,17311,10344,13242,13826,
9678,8070,17452,19323,15190,16484,6507,18047,21188,10232,
9181,4137,4537,6383,9182,14762,10097,19324,11103,7217,
9806,7528,19267,9986,19065,7382,2210,3359,13676,7450,
9216,4504,14870,19851,21470,4763,14360,9433,9217,3112,
13491,19388,12943,4452,8473,18429,19327,13983,20164,10547,
18419,9534,11105,14250,15398,3471,7699,2249,19329,6064,
21214,9266,9226,11577,16241,10551,18111,17265,18432,5152,
18436,19820,5668,17394,17395,6679,6203,21322,20357,17563,
2639,20109,12794,21034,4673,11860,16561,12560,18920,12254,
8580,12058,8581,12097,11457,9905,5670,17663,5671,5672,
1567,3282,17079,20734,21198,8710,20525,4882,1078,17571,
17572,10118,21411,12108,15354,18500,15887,14207,16389,6658,
21091,7657,17877,6186,13592,6579,17760,17761,17236,19142,
16686,21093,18548,14644,16345,15906,18043,20114,8583,17083,
17974,20736,12532,6727,5679,2381,6689,2412,6757,9927,
4902,8091,2382,12596,15840,21435,15874,5886,9299,14182,
17884,2650,13795,6355,16860,14740,6143,18051,8837,8422,
17415,16861,21360,8525,3682,17580,7053,16793,10493,18376,
8223,10013,9039,6857,16088,16871,3203,16719,6211,8304,
4966,16661,3068,4789,12481,13316,13966,16872,13317,17669,
18975,7618,19741,5182,12305,5517,16327,14475,5569,14290,
14291,11634,5336,16357,2424,6147,8993,21062,17068,6700,
4790,9796,17681,7671,1479,19233,21230,16458,16032,14211,
16885,11929,11930,2182,18227,8092,8097,10963,16505,20340,
7936,13322,13855,6591,4490,13402,15205,18481,9934,7752,
20216,5570,19990,11554,14664,9847,5456,15492,2357,4362,
1842,6667,17539,17041,16805,19992,6118,6149,16892,20027,
11515,14213,13323,18623,11130,9732,19304,16753,5408,18394,
13052,1494,1629,3079,10436,7359,10287,12213,15178,19011,
15893,8445,21592,6432,18822,20989,16509,10181,5978,11975,
13712,8098,9051,3163,20296,7366,16912,16913,19012,17503,
2668,6635,2240,18698,18103,18400,18104,13075,8536,3573,
4179,14399,7632,4690,14958,19781,9974,8100,14299,4691,
18105,9258,10947,15533,19030,8101,10987,8024,8025,19309,
19044,18025,9206,15383,1996,16919,13631,21622,9751,6739,
21208,10093,16371,19045,17549,20557,6803,3299,11934,1757,
13882,6156,18066,7961,2742,3549,18631,6157,9262,1641,
13824,9670,11406,13972,10528,9131,992,18071,8944,14917,
9891,9684,10349,8463,9900,18415,16939,17617,10239,18716,
1999,13688,19981,9263,3114,2702,5658,8338,2392,11075,
15527,9264,21218,9254,10107,19822,20533,20731,12109,2465,
16403,5936,8446,18652,21685,4404,2899,8671,20171,3850,
13012,19374,13037,12060,2338,7339,2893,19614,20341,1553,
1200,1843,2895,19515,4041,2471,11852,8109,15294,13748,
10790,4544,5162,18363,5246,1303,14992,19530,5248,11439,
3653,13599,13548,21566,10808,8760,12870,9490,12552,5173,
15593,1345,13558,2957,7254,4749,8686,8229,2786,17042,
1329,10661,7863,10679,14022,16510,9508,4153,15931,13105,
16920,9671,4042,9945,12024,12395,1866,16940,2714,16419,
13701,2715,1072,7105,2148,21426,5242,8645,1807,6302,
18190,19135,4458,21357,8910,21070,11455,12255,8219,18780,
17675,16139,10039,12256,11676,18596,19523,18040,3396,1811,
23007,23008,23009,23010,23011,23012,23013,23014,23015,23016,
23017,23018,23019,23020,23021,23022,23023,23024,23025,23026,
23027,23028,23029,23030,23031,23032,23033,23034,23035,23036,
23037,23038,23039,23040,23041,23042,23043,23044,23045,23046,
23047,23048,23049,23050,23051,23052,23053,23054,23055,23056,
23057,23058,23059,23060,23061,23062,23063,23064,23065,23066,
23067,23068,23069,23070,23071,23072,23073,23074,23075,23076,
23077,23078,23079,23080,23081,23082,23083,23084,23085,23086,
23087,23088,23089,23090,23091,23092,23093,23094,23095,23096,
23097,23098,23099,23100,23101,23102,11,34,37,328,
70,72,68,118,23934,6,66,74,330,75,
76,77,78,109,112,88,90,92,94,96,
98,100,102,114,115,104,106,131,132,133,
151,143,144,136,135,146,145,134,152,137,
165,142,140,167,124,147,148,158,155,154,
153,138,157,163,164,159,160,431,150,149,
339,338,327,79,80,443,18,323,321,322,
331,325,491,335,336,176,178,177,175,174,
169,168,171,170,332,185,189,183,187,334,
23103,23104,23105,23106,23107,23108,23109,23110,23111,23112,
23113,23114,23115,23116,23117,23118,23119,23120,23121,23122,
23123,23124,23125,23126,23127,23128,23129,23130,23131,23132,
23133,23134,23135,23136,23137,23138,23139,23140,23141,23142,
23143,23144,23145,23146,23147,23148,23149,23150,23151,23152,
23153,23154,23155,23156,23157,23158,23159,23160,23161,23162,
23163,23164,23165,23166,23167,23168,23169,23170,23171,23172,
23173,23174,23175,23176,23177,23178,23179,23180,23181,23182,
23183,23184,23185,23186,23187,23188,23189,23190,23191,23192,
23193,23194,23195,23196,23197,23198,345,352,359,366,
373,380,387,394,401,407,23679,23680,23681,23682,
23683,23684,344,351,358,365,372,379,386,393,
400,406,410,413,416,418,420,422,424,426,
428,430,343,350,357,364,371,378,385,392,
399,405,409,412,415,417,419,421,423,425,
427,429,342,349,356,363,370,377,384,391,
398,404,23685,23686,18727,4412,14015,14972,16730,10188,
12616,1048,8127,14553,23687,23688,346,353,360,367,
374,381,388,395,402,408,411,414,23689,23690,
23199,23200,23201,23202,23203,23204,23205,23206,23207,23208,
23209,23210,23211,23212,23213,23214,23215,23216,23217,23218,
23219,23220,23221,23222,23223,23224,23225,23226,23227,23228,
23229,23230,23231,23232,23233,23234,23235,23236,23237,23238,
23239,23240,23241,23242,23243,23244,23245,23246,23247,23248,
23249,23250,23251,23252,23253,23254,23255,23256,23257,23258,
23259,23260,23261,23262,23263,23264,23265,23266,23267,23268,
23269,23270,23271,23272,23273,23274,23275,23276,23277,23278,
23279,23280,23281,23282,23283,23284,23285,23286,23287,23288,
23289,23290,23291,23292,23293,23294,13,14,16,324,
20,22,1,24,27,30,121,32,3,36,
38,340,341,348,355,362,369,376,383,390,
397,40,43,126,128,130,45,47,432,439,
441,447,449,456,459,462,464,470,472,477,
481,487,492,498,500,502,504,506,509,520,
522,524,526,528,48,50,51,52,53,57,
433,440,442,448,450,457,460,463,465,471,
473,478,482,488,493,499,501,503,505,507,
510,521,523,525,527,529,60,62,64,69,
23295,23296,23297,23298,23299,23300,23301,23302,23303,23304,
23305,23306,23307,23308,23309,23310,23311,23312,23313,23314,
23315,23316,23317,23318,23319,23320,23321,23322,23323,23324,
23325,23326,23327,23328,23329,23330,23331,23332,23333,23334,
23335,23336,23337,23338,23339,23340,23341,23342,23343,23344,
23345,23346,23347,23348,23349,23350,23351,23352,23353,23354,
23355,23356,23357,23358,23359,23360,23361,23362,23363,23364,
23365,23366,23367,23368,23369,23370,23371,23372,23373,23374,
23375,23376,23377,23378,23379,23380,23381,23382,23383,23384,
23385,23386,23387,23388,23389,23390,645,647,649,651,
653,655,658,660,662,664,667,669,671,673,
675,677,680,682,684,686,688,690,692,694,
696,698,700,702,704,706,708,710,712,714,
716,718,720,722,724,726,728,730,732,734,
736,738,740,742,744,746,748,750,752,754,
756,758,760,762,764,766,768,770,772,774,
776,778,780,782,784,786,788,790,792,794,
796,798,800,802,804,806,808,810,812,23691,
23692,23693,23694,23695,23696,23697,23698,23699,23700,23701,
23391,23392,23393,23394,23395,23396,23397,23398,23399,23400,
23401,23402,23403,23404,23405,23406,23407,23408,23409,23410,
23411,23412,23413,23414,23415,23416,23417,23418,23419,23420,
23421,23422,23423,23424,23425,23426,23427,23428,23429,23430,
23431,23432,23433,23434,23435,23436,23437,23438,23439,23440,
23441,23442,23443,23444,23445,23446,23447,23448,23449,23450,
23451,23452,23453,23454,23455,23456,23457,23458,23459,23460,
23461,23462,23463,23464,23465,23466,23467,23468,23469,23470,
23471,23472,23473,23474,23475,23476,23477,23478,23479,23480,
23481,23482,23483,23484,23485,23486,644,646,648,650,
652,654,657,659,661,663,666,668,670,672,
674,676,679,681,683,685,687,689,691,693,
695,697,699,701,703,705,707,709,711,713,
715,717,719,721,723,725,727,729,731,733,
735,737,739,741,743,745,747,749,751,753,
755,757,759,761,763,765,767,769,771,773,
775,777,779,781,783,785,787,789,791,793,
795,797,799,801,803,805,807,809,811,656,
665,678,23702,23703,23704,23705,23706,23707,23708,23709,
23487,23488,23489,23490,23491,23492,23493,23494,23495,23496,
23497,23498,23499,23500,23501,23502,23503,23504,23505,23506,
23507,23508,23509,23510,23511,23512,23513,23514,23515,23516,
23517,23518,23519,23520,23521,23522,23523,23524,23525,23526,
23527,23528,23529,23530,23531,23532,23533,23534,23535,23536,
23537,23538,23539,23540,23541,23542,23543,23544,23545,23546,
23547,23548,23549,23550,23551,23552,23553,23554,23555,23556,
23557,23558,23559,23560,23561,23562,23563,23564,23565,23566,
23567,23568,23569,23570,23571,23572,23573,23574,23575,23576,
23577,23578,23579,23580,23581,23582,530,532,534,536,
538,540,542,544,546,548,550,552,554,556,
558,560,562,564,566,568,570,572,574,576,
23710,23711,23712,23713,23714,23715,23716,23717,531,533,
535,537,539,541,543,545,547,549,551,553,
555,557,559,561,563,565,567,569,571,573,
575,577,23718,23719,23720,23721,23722,23723,23724,25,
28,110,113,89,91,93,95,97,99,101,
103,23725,23726,105,107,61,65,8,23727,82,
87,23728,23729,23730,23731,23732,23733,23734,23735,23736,
23583,23584,23585,23586,23587,23588,23589,23590,23591,23592,
23593,23594,23595,23596,23597,23598,23599,23600,23601,23602,
23603,23604,23605,23606,23607,23608,23609,23610,23611,23612,
23613,23614,23615,23616,23617,23618,23619,23620,23621,23622,
23623,23624,23625,23626,23627,23628,23629,23630,23631,23632,
23633,23634,23635,23636,23637,23638,23639,23640,23641,23642,
23643,23644,23645,23646,23647,23648,23649,23650,23651,23652,
23653,23654,23655,23656,23657,23658,23659,23660,23661,23662,
23663,23664,23665,23666,23667,23668,23669,23670,23671,23672,
23673,23674,23675,23676,23677,23678,578,580,582,584,
586,588,590,592,594,596,598,600,602,604,
606,608,610,612,614,616,618,620,622,624,
626,628,630,632,634,636,638,640,642,23737,
23738,23739,23740,23741,23742,23743,23744,23745,23746,23747,
23748,23749,23750,23751,579,581,583,585,587,589,
591,593,595,597,599,601,603,605,607,609,
611,613,615,617,619,621,623,625,627,629,
631,633,635,637,639,641,643,23752,23753,23754,
23755,23756,23757,23758,23759,23760,23761,23762,23763,23764,
71,58,73,5,7,329,81,446,458,190,
184,186,188,123,139,141,156,161,162,166,
197,204,209,210,211,217,218,219,225,226,
227,233,234,235,245,246,247,256,257,258,
267,268,269,278,279,280,297,298,299,212,
220,236,228,300,301,302,303,307,309,311,
313,315,317,319,318,316,314,312,310,308,
304,320,305,306,172,173,179,180,181,182,
337,122,333,116,117,23765,23766,23767,23768,23769,
23770,23771,23772,23773,23774,23775,437,434,436,435,
455,451,454,452,469,466,468,467,497,494,
496,495,515,511,514,512,519,516,518,517,
513,453,438,23776,489,490,23777,461,23778,23779,
23780,23781,813,814,815,816,817,818,819,820,
821,822,823,824,825,826,827,828,829,830,
831,832,833,834,835,836,837,838,839,840,
841,842,843,844,845,846,847,848,849,23782,
23783,23784,23785,23786,23787,23788,23789,23790,23791,23792,
23793,23794,23795,23796,23797,23798,23799,23800,23801,23802,
347,354,361,368,375,382,389,396,403,20773,
484,474,486,445,475,483,444,476,479,480,
485,41,326,67,23803,508,21167,23804,4,23805,
23806,23807,23935,9,10,23936,23937,119,23938,23939,
83,84,85,86,54,55,56,31,33,35,
42,39,44,12,23,26,59,63,108,111,
15,21,29,120,2,125,129,127,49,17,
19,46,23808,23809,23810,23811,23812,23813,23814,23815,
23816,23817,23818,23819,23820,0,23821,23822,23823,23824,
23825,23826,23827,23828,23829,23830,23831,23832,23833,191,
192,198,199,193,194,200,201,195,196,202,
203,205,206,207,208,213,214,215,216,221,
222,223,224,229,230,231,232,237,238,239,
240,241,242,243,244,248,249,250,251,252,
253,254,255,259,260,261,262,263,264,265,
266,270,271,272,273,274,275,276,277,281,
282,283,284,285,286,287,288,289,290,291,
292,293,294,295,296,23834,23835,23836,23837,23838,
23839,23840,23841,23842,23843,23844,23845,23846,23847,23848,
8829,17231,6535,6086,20542,7042,18120,14179,15314,15901,
9317,10807,16850,17084,1310,20931,18257,14124,5959,7983,
12018,4587,17416,1130,12691,1620,19209,9156,7333,12998,
9036,18384,21630,20942,20743,18167,9930,2092,21583,5037,
4745,16637,19875,2869,16031,18206,17531,7250,1549,19478,
18563,15235,1836,11304,15065,10689,19887,3315,19763,14531,
6021,13003,18986,20644,2012,6025,10777,7575,11431,2185,
1002,5217,3180,1359,1506,1495,6633,1901,9970,17909,
15926,18626,14914,17436,14719,4149,7725,5316,8386,4033,
6795,8879,17252,17253,11834,1558,21785,21786,21787,21788,
21789,21790,21791,21792,21793,21794,21795,21796,21797,21798,
21799,21800,21801,21802,21803,21804,21805,21806,21807,21808,
21809,21810,21811,21812,21813,21814,21815,21816,21817,21818,
21819,21820,21821,21822,21823,21824,21825,21826,21827,21828,
21829,21830,21831,21832,21833,21834,21835,21836,21837,21838,
21839,21840,21841,21842,21843,21844,21845,21846,21847,21848,
21849,21850,21851,21852,21853,21854,21855,21856,21857,21858,
21859,21860,21861,21862,21863,21864,21865,21866,21867,21868,
21869,21870,21871,21872,21873,21874,21875,21876,21877,21878,
6905,11896,11018,9944,11594,5692,14720,10345,15311,17313,
11073,13677,11600,10627,17262,12754,8479,11208,21486,10333,
15102,13369,5048,9375,1054,6226,3669,2883,5098,19567,
12765,19568,2317,6231,16742,4819,7847,18193,10973,1202,
19952,8405,20040,8406,7324,3397,12430,12996,18932,951,
12470,4883,17960,3000,5431,7289,14307,3007,13669,14466,
14378,15344,21686,10176,1444,20623,7883,7706,7474,9616,
5680,17147,21094,18216,17786,18471,17853,15109,13192,19144,
18090,1242,17380,17085,5708,2681,17878,12154,9347,3452,
19224,16567,4261,2513,15633,16750,21879,21880,21881,21882,
21883,21884,21885,21886,21887,21888,21889,21890,21891,21892,
21893,21894,21895,21896,21897,21898,21899,21900,21901,21902,
21903,21904,21905,21906,21907,21908,21909,21910,21911,21912,
21913,21914,21915,21916,21917,21918,21919,21920,21921,21922,
21923,21924,21925,21926,21927,21928,21929,21930,21931,21932,
21933,21934,21935,21936,21937,21938,21939,21940,21941,21942,
21943,21944,21945,21946,21947,21948,21949,21950,21951,21952,
21953,21954,21955,21956,21957,21958,21959,21960,21961,21962,
21963,21964,21965,21966,21967,21968,21969,21970,21971,21972,
16716,2510,8526,10903,1315,15875,17286,2830,5964,17964,
18262,17987,17789,4903,16862,10059,9624,7886,15277,4741,
16257,3760,12433,20430,14083,11250,19742,9160,11251,14501,
16404,15749,2834,1377,2472,4330,2270,1378,10413,5626,
3784,1321,12999,21418,13200,4454,7888,4062,7860,6701,
19680,10917,2940,17937,15646,17682,3347,13842,11254,7350,
16459,13920,6592,17537,2863,7424,21326,2323,9797,13565,
4098,18168,6630,10141,14536,13811,15283,18569,16545,16756,
20654,7945,19306,10691,15548,10144,9651,9282,15761,13013,
3229,8438,20536,1694,14752,2296,21973,21974,21975,21976,
21977,21978,21979,21980,21981,21982,21983,21984,21985,21986,
21987,21988,21989,21990,21991,21992,21993,21994,21995,21996,
21997,21998,21999,22000,22001,22002,22003,22004,22005,22006,
22007,22008,22009,22010,22011,22012,22013,22014,22015,22016,
22017,22018,22019,22020,22021,22022,22023,22024,22025,22026,
22027,22028,22029,22030,22031,22032,22033,22034,22035,22036,
22037,22038,22039,22040,22041,22042,22043,22044,22045,22046,
22047,22048,22049,22050,22051,22052,22053,22054,22055,22056,
22057,22058,22059,22060,22061,22062,22063,22064,22065,22066,
9052,21308,3080,18756,12724,8021,20202,13409,1006,9772,
10979,19169,6464,16517,16723,3574,17793,20297,18106,13480,
3494,9975,9876,13330,15149,5727,8026,4496,7891,10151,
6988,6796,8027,912,20204,3459,7689,5816,15446,6804,
6553,14096,15216,15737,2813,19638,7962,10346,1705,14771,
21717,9211,17004,7203,17971,13927,16668,5090,9398,4043,
9679,21013,13850,9709,20158,13332,15702,5736,15188,9135,
10240,10350,9685,9265,19271,11078,17342,13335,5659,3552,
20166,6564,1812,1822,20848,9705,14696,17347,13055,1161,
12167,4566,3398,4797,11233,16212,22067,22068,22069,22070,
22071,22072,22073,22074,22075,22076,22077,22078,22079,22080,
22081,22082,22083,22084,22085,22086,22087,22088,22089,22090,
22091,22092,22093,22094,22095,22096,22097,22098,22099,22100,
22101,22102,22103,22104,22105,22106,22107,22108,22109,22110,
22111,22112,22113,22114,22115,22116,22117,22118,22119,22120,
22121,22122,22123,22124,22125,22126,22127,22128,22129,22130,
22131,22132,22133,22134,22135,22136,22137,22138,22139,22140,
22141,22142,22143,22144,22145,22146,22147,22148,22149,22150,
22151,22152,22153,22154,22155,22156,22157,22158,22159,22160,
6350,18790,1138,8373,2289,2560,10201,3484,11035,21378,
12482,1554,21148,10202,3018,19241,12814,17208,10305,3708,
11976,21309,10017,16765,3445,16627,19259,18343,15724,5934,
2291,13265,14383,2227,2228,13930,15091,14397,10393,4786,
20334,4856,12451,3878,13590,10995,1440,8146,15241,10123,
11440,20011,4884,5330,7849,4885,15720,11441,15587,7543,
16196,4895,11547,11444,11445,2058,15723,5061,1451,3266,
20943,10563,12032,18741,6481,19604,19605,11447,8527,18957,
10129,3842,6483,3455,21380,7592,2530,2325,16105,9393,
2111,10152,3859,10020,7559,2744,22161,22162,22163,22164,
22165,22166,22167,22168,22169,22170,22171,22172,22173,22174,
22175,22176,22177,22178,22179,22180,22181,22182,22183,22184,
22185,22186,22187,22188,22189,22190,22191,22192,22193,22194,
22195,22196,22197,22198,22199,22200,22201,22202,22203,22204,
22205,22206,22207,22208,22209,22210,22211,22212,22213,22214,
22215,22216,22217,22218,22219,22220,22221,22222,22223,22224,
22225,22226,22227,22228,22229,22230,22231,22232,22233,22234,
22235,22236,22237,22238,22239,22240,22241,22242,22243,22244,
22245,22246,22247,22248,22249,22250,22251,22252,22253,22254,
12354,3866,3867,7773,3417,14744,20979,11522,1412,5163,
21124,17120,17806,2446,18041,12674,17062,3191,1445,21628,
18004,20808,4436,20891,4630,8185,14183,11699,15601,15889,
7738,16442,6730,15388,2651,10960,8055,17418,15976,10812,
17419,15158,12565,4201,14713,18987,1369,20510,5627,10676,
9961,7166,15752,935,2656,1481,11255,4114,8681,18181,
3134,14449,21064,20980,19764,4751,18483,2428,15999,5830,
16571,6595,8842,19119,8448,16903,5616,19013,2896,6780,
11925,3722,20516,14453,3142,19031,21634,15089,14093,3815,
10313,10314,13216,4943,9879,13106,22255,22256,22257,22258,
22259,22260,22261,22262,22263,22264,22265,22266,22267,22268,
22269,22270,22271,22272,22273,22274,22275,22276,22277,22278,
22279,22280,22281,22282,22283,22284,22285,22286,22287,22288,
22289,22290,22291,22292,22293,22294,22295,22296,22297,22298,
22299,22300,22301,22302,22303,22304,22305,22306,22307,22308,
22309,22310,22311,22312,22313,22314,22315,22316,22317,22318,
22319,22320,22321,22322,22323,22324,22325,22326,22327,22328,
22329,22330,22331,22332,22333,22334,22335,22336,22337,22338,
22339,22340,22341,22342,22343,22344,22345,22346,22347,22348,
10154,9331,17220,4640,3390,19213,6155,17221,5617,16373,
11889,19795,16417,19383,9428,9663,14784,3446,10006,10007,
1681,7210,2577,18515,7757,20761,10891,9692,6922,9185,
7009,17978,19348,19201,19392,15399,3732,10647,10554,10555,
1775,1778,1079,4426,4427,13140,1389,20208,10861,11998,
3040,10047,11370,7043,12233,5191,4263,5968,1468,2727,
12976,875,17476,6055,6676,6056,20256,3188,6057,17480,
18701,6059,7691,916,17694,6671,9686,12406,6134,7731,
5119,12121,13399,13620,20323,5528,8503,8504,21150,20327,
20328,20443,4044,12766,19283,1286,852,851,860,861,
857,859,858,868,876,882,881,891,901,893,
896,941,928,924,955,966,974,965,970,969,
979,982,985,987,993,1005,1009,1023,1031,1033,
1042,1041,1058,1061,1052,1051,1055,1062,1047,1059,
1050,1076,1084,1093,1090,12005,1094,1105,1098,1096,
1111,1114,1112,1120,1113,1126,1127,1131,1145,1142,
1146,1139,1143,1144,1159,1160,1172,1175,1171,1183,
1170,1169,1176,1184,1187,1189,1199,1201,1197,1205,
1214,1203,1215,1204,1208,1223,1224,1220,1230,1780,
20526,6087,6094,1781,16266,19553,4527,4967,13400,3540,
10420,20432,9504,7908,17904,7356,12044,942,10339,17862,
21113,3495,947,5537,9687,5138,16340,12795,19913,15721,
17636,17023,4733,11245,11295,14640,20012,12031,4567,10866,
17275,14645,18444,20737,18600,14384,6887,3311,20680,8930,
8186,14441,10957,11371,21261,20628,14646,3832,11700,21568,
2356,1747,11093,10214,15909,3871,3683,11623,11299,17988,
20709,18472,11377,21078,11372,10912,13094,5969,6565,2548,
3240,8376,4264,10760,17289,16874,9077,14212,15753,5814,
16235,9473,14665,13324,9935,20751,1853,1236,1240,1243,
1239,1237,1262,1261,1273,1263,1270,1279,1285,1290,
1288,1284,1295,1323,1305,1297,1306,1308,1298,1301,
1319,1320,1311,1339,1350,1349,1357,1364,1365,1373,
1380,1387,1381,1393,1402,1405,1423,1417,1413,1496,
1483,1501,1429,1449,1443,1427,1433,1480,1430,1456,
1493,1428,1488,1511,1523,1519,1448,1563,1546,1550,
1568,1569,1590,1591,1580,1605,1606,1608,1598,1615,
1614,1630,1654,1666,1665,1672,1680,1687,1689,1700,
1691,1686,1713,1729,1728,1744,1735,1740,1746,1745,
9494,9172,15206,8380,12347,6839,10421,5195,21127,19620,
6840,10704,17125,17716,6705,5815,20118,2971,7351,10964,
6291,17939,15762,17905,4443,16666,5780,11053,16623,8812,
3489,2399,13325,11395,4702,20257,20518,19032,3789,8796,
11396,14893,3085,10290,2572,10750,5728,6600,14894,16921,
12586,14430,9909,2391,7518,18702,17913,11423,5785,7519,
18713,917,6810,7442,20560,10929,2758,14072,11842,18068,
18634,6910,11023,11157,12440,11158,9431,8945,17951,11159,
6923,10352,11028,10241,5660,10767,17006,15528,8622,21239,
13193,19743,14907,20244,8482,14416,1766,1758,1779,1791,
1798,1776,1785,1777,1829,1815,1835,1825,1844,1805,
1809,1828,1790,1845,1830,1810,1808,1898,1894,1897,
1896,1920,1904,1905,1908,1929,1919,1910,1931,1938,
1944,1940,1939,1941,1953,1956,1946,1951,1957,1959,
1972,1962,1975,1974,1976,1983,1991,2004,2007,2000,
2003,2021,2026,2027,2034,2029,2041,2052,2067,2051,
2050,2055,2083,2088,2105,2094,2119,2120,2117,2128,
2122,2127,2137,2142,2139,2145,2150,2152,2166,2165,
2186,2180,2175,2183,2229,2220,2230,2255,2261,2265,
6285,19332,21100,7690,20298,19940,1104,3897,12790,21542,
16782,20568,8817,5164,3370,8409,9603,4823,16562,4280,
8624,20888,7851,1685,4297,20569,15195,16213,7878,11373,
8187,19715,10638,16144,4306,11446,21225,11910,12454,10048,
12122,9378,1782,12534,19430,8931,8759,13555,21171,5682,
4313,12839,10408,16443,895,17287,18263,12184,9348,6244,
13270,16498,13091,2089,8761,13614,2252,9283,6212,19606,
17421,17093,1207,10269,19415,2371,2385,18385,14130,9067,
5518,2090,6449,10371,2437,11932,15030,21448,8763,18329,
21381,8779,2528,12708,21631,13294,2306,2285,2287,2278,
2286,2281,2305,2310,2318,2321,2319,2335,2328,2332,
2342,2346,2348,2340,2354,2355,2364,2373,2388,2384,
2378,2389,2394,2404,2407,2403,2417,2405,2406,2408,
2449,2445,2478,2447,2501,2536,2493,2495,2507,2521,
2518,2535,2498,2496,2545,2546,2550,2551,2569,2592,
2597,2585,2588,2584,2586,2625,2620,2618,2614,2640,
2648,2638,2646,2675,2676,2693,2694,2703,2709,2733,
2724,2735,2728,2726,2729,2716,2721,2756,2750,2760,
2766,2764,2791,2774,2796,2778,2785,2775,2772,2808,
9962,8501,1793,11256,7352,6148,13621,9465,19159,16754,
12709,10591,11591,13923,18276,3907,16152,19236,8734,16465,
14913,20655,4100,17099,3488,15648,11612,15732,12815,4175,
4752,13629,13069,10692,5387,15143,4269,10146,14954,15497,
6465,12273,8996,15734,17102,12649,9738,16511,20050,4115,
9114,12030,18577,21312,2195,12820,1008,12190,10193,10382,
8620,2903,2441,19121,9424,12390,12821,12822,3181,21599,
2993,10596,6994,14238,9332,20299,7520,17053,3911,3770,
1800,20104,13077,3608,9664,7521,16922,20497,13108,7443,
19791,21391,6128,8738,20260,9454,2803,2805,2851,2836,
2838,2819,2854,2859,2861,2872,2864,2867,2879,2882,
2890,2892,21361,2898,2444,2905,2912,2913,2920,2926,
2915,2933,2938,2963,2950,2954,2948,2974,2976,2983,
3001,3012,3021,3022,3019,3017,3014,3006,3037,3045,
3053,3043,3084,3069,2889,3058,3057,3093,3117,3123,
3141,3143,3130,3153,3164,3162,3177,3170,3171,3196,
3204,3205,3200,3207,3215,3220,3225,3231,3232,3228,
3255,3252,3260,3267,3274,3291,3295,3308,3309,3313,
3317,3318,3354,3329,3333,3319,3335,3342,3330,3344,
7820,2814,18717,13633,3496,18873,12281,12282,19642,12426,
12824,919,8701,7379,19796,13928,12125,3032,1861,18516,
10710,17224,8946,9400,9432,21017,9680,9688,4505,13636,
12126,19272,9693,10242,10243,11408,14858,5661,9223,1934,
18297,13775,19949,15295,10699,17566,18531,12671,1362,4125,
21071,21072,18737,14570,19531,20924,15776,4991,11114,15161,
10955,2151,10494,19666,16717,21262,5755,17086,20809,5232,
5233,14881,7934,14443,5062,9066,3684,15570,5552,5647,
21724,10070,10414,3520,20845,1469,2807,6702,19510,19115,
21507,6897,20646,19928,16720,17245,3331,3372,3367,3364,
3366,3373,3403,3399,3410,3427,3411,3422,3423,3415,
3421,3425,3451,3464,3465,3480,3481,3500,3518,3532,
3515,3513,3519,3512,3534,3545,3535,3541,3537,3562,
3555,3564,3579,3568,3569,3580,3589,3584,3582,3603,
3595,3606,3617,3619,3623,3613,3620,20383,3628,3650,
3648,3663,3693,3685,3674,3666,3677,3692,3723,3716,
3720,3740,3736,3734,3769,3751,3745,3746,3747,3750,
3757,3759,3758,3761,3786,3775,3790,3779,3774,3806,
3801,3802,3805,3821,3820,3854,3858,3824,3836,3848,
18482,20818,18748,10918,14938,3695,1326,20656,19424,7176,
5237,15494,14944,10707,15324,5018,17941,12725,19792,6989,
15008,2196,3441,5786,15217,9568,11879,11071,3533,9672,
19982,20829,20167,9459,13835,17581,15967,13720,21543,2115,
18921,17143,11714,13342,4709,6039,20013,20801,7974,20802,
19709,8836,1177,12259,11650,9619,19466,12260,1823,10049,
11716,21755,20810,8288,6872,15910,20945,6873,6101,19102,
21492,20946,13731,4075,21265,11871,5008,5212,20276,14882,
9068,5127,7987,15640,15996,18209,10599,10423,5555,21760,
21408,1211,6966,20967,9071,9466,3873,3880,3875,3881,
3887,3889,3906,3898,3894,3914,3918,3919,3941,3944,
3948,3957,3950,3955,3949,3958,3978,3987,3984,3990,
3994,3998,4005,3977,4020,4023,4029,4058,4025,4060,
4064,4063,4070,4078,4071,4073,4076,4069,4087,4090,
4101,4091,4092,4094,4111,4123,4119,4120,4145,4141,
4155,4143,4170,4162,4169,4166,4171,4196,4184,4181,
4193,4211,4219,4208,4240,4236,4226,4237,4235,4268,
4257,4267,4255,4273,4251,4256,4305,4286,4293,4326,
4316,4308,4360,4370,4369,4396,4395,4399,4398,4411,
12208,9994,21675,19752,10565,10566,18751,17043,1575,7177,
4930,1497,11949,7753,21065,21589,17827,2452,3542,9799,
21513,19773,17910,20990,5218,5529,13812,15211,13833,7190,
8632,1988,10980,21008,7178,10445,15095,6990,19343,16596,
13353,9102,19033,6642,13165,7119,17444,12587,7635,21421,
15934,21735,10508,15219,11881,14098,6811,13673,11957,19797,
12427,7211,16066,16597,2486,6911,8947,10510,1645,14100,
21422,9542,3161,18186,19547,14379,8015,18615,9318,18601,
1234,1748,16197,21202,7707,3803,16689,5712,2891,18619,
17422,2514,8807,3431,21449,17824,4418,4424,4437,4442,
4433,4432,4439,4449,4453,4469,4456,4459,4468,4492,
4481,4483,4499,4475,4485,4510,4514,4521,4522,4516,
4520,4519,4541,4542,4539,4556,4555,4553,4554,4560,
4561,4563,4575,4585,4578,4580,4576,4600,4608,4609,
4619,4624,4620,4622,4626,4650,4661,4647,4652,4646,
4649,4668,4680,4671,4701,4707,4704,4708,4711,4712,
4721,4731,4730,4750,4737,4747,4722,4732,4740,4772,
4768,4777,4780,4785,4784,4800,4806,4812,4843,4820,
4841,4860,4869,4924,4913,4880,4904,4854,4876,4870,
15094,5614,21419,16641,16205,18210,13326,18578,18579,15799,
2349,15735,3816,8326,9877,16914,16809,8957,2897,20531,
8894,8895,2485,3210,9880,20221,3168,13134,13333,4013,
20225,10266,13170,2820,14560,4986,12858,2826,6236,12675,
6016,14467,4654,11209,13505,21263,10050,10216,1767,1117,
15001,6249,8056,3810,18988,14815,8052,13509,12456,9505,
21320,2086,3575,3219,16224,8072,8612,8073,9377,12194,
2593,10802,21199,16252,7658,15162,13222,18161,21374,19867,
6002,2081,12295,18859,3932,14186,17088,21204,11505,5473,
13155,11275,1226,2061,12156,10060,4894,4901,4919,4912,
4853,4952,4951,4964,4959,4960,4956,4963,4968,4953,
4971,4994,5000,5034,5013,4989,5004,4980,4987,4978,
5016,4982,5006,4979,4983,4981,5015,4984,5045,5044,
5052,5070,5085,5078,5079,5081,5091,5092,5097,5103,
5104,5099,5123,5128,5120,5124,5150,5153,5156,5166,
5165,5160,5159,5158,5180,5181,5201,5187,5190,5198,
5188,5202,5213,5220,5219,5227,5250,5257,5255,5240,
5253,5251,5247,5254,5273,5279,5275,5281,5272,5283,
5313,5308,5309,5317,5319,5320,5332,5327,5329,5344,
11905,4905,4487,5126,4528,14605,10857,14651,13312,11276,
10656,5775,13442,2602,19111,18620,1422,9084,7665,15245,
13869,6960,6007,21081,9161,3454,2069,4838,16000,9495,
9286,8258,5628,7425,5935,15941,17098,20969,2522,15163,
21278,21761,15857,2070,5235,5112,8905,20024,11962,17475,
12547,9163,21648,12021,1499,5314,15358,5600,19556,7357,
20552,6398,20755,14154,21128,10431,9963,8529,4931,20324,
5486,12886,8530,2927,2073,21676,1875,17942,1555,15248,
17248,12492,17686,6371,14539,19939,2941,10524,16696,3945,
14915,7077,7800,17687,10967,4535,5348,5352,5354,5364,
5369,5368,5376,5379,5371,5378,5366,5374,5365,5394,
5395,5396,5404,5403,5415,5412,5414,5429,5428,5442,
5439,5441,5446,5481,5474,5462,5485,5461,5465,5464,
5463,5524,5495,5513,5504,5500,5501,5543,5545,5541,
5553,5564,5563,5582,5585,5589,5594,5596,5597,5603,
5612,5605,5607,5608,5606,5629,5625,5663,5642,5657,
5639,5667,5688,5695,5717,5702,5699,5711,5698,5701,
5706,5742,5753,5746,5751,5773,5769,5779,5772,5765,
5799,5800,5812,5828,5821,5841,5856,5868,5872,5879,
2875,4754,21288,6262,13163,13350,11202,12984,5488,14588,
20032,6124,15501,19974,2713,13971,20758,11789,12986,17478,
5388,12086,4067,21460,2789,14159,21289,13016,10227,7367,
1927,6805,1515,3634,3086,18237,14110,3166,12318,12404,
19798,16045,20258,14160,5787,18832,6434,2241,8813,12497,
20219,6995,10307,2075,11731,15268,3167,3793,15269,9383,
9810,17445,1862,11141,14161,3497,9885,3392,4975,7444,
11287,9022,3357,7639,15249,9333,17453,10460,14689,20135,
12781,12023,12736,12321,5133,8333,10461,10455,18288,3461,
14012,21296,5424,12896,9758,14690,5883,5882,5884,5893,
5890,5892,5891,5906,5910,5916,5933,5915,5929,5931,
5917,5944,5942,5983,5982,5956,5953,5981,5955,5963,
5951,5948,5993,5999,6003,6029,6028,6023,6018,6035,
6034,6044,6036,6043,6067,6070,6096,6102,6093,6074,
6079,6076,6075,6100,6114,6089,6081,6098,6151,6150,
6152,6139,6166,6165,6170,6173,6174,6176,6178,6177,
6190,6192,6184,6204,6205,6207,6239,6247,6235,6224,
6220,6222,6286,6284,6288,6300,6305,6310,6303,6321,
6318,6323,6366,6352,6363,6351,6373,6349,6372,6360,
9218,9024,19647,19977,6031,20667,15367,15704,11801,2745,
18839,12746,15615,21338,21157,4472,14789,21156,12944,21473,
15617,10469,10353,7389,16187,19328,19812,9187,10246,13171,
9764,9227,12904,19984,21054,13495,9765,1566,4108,21702,
9543,14550,10632,19331,19986,21475,19821,4482,14371,20570,
14380,11917,6088,11647,3227,20507,12863,20374,1418,1163,
16789,14125,8625,13837,1419,15197,19145,20574,11094,15377,
6420,5107,8294,11378,21145,2563,15115,6250,15913,2062,
9960,21348,1118,9312,4384,13443,6107,17294,4920,9561,
19968,10432,8232,12716,1132,20479,6348,6391,6393,6410,
6401,6412,6404,6444,6455,6454,6461,6460,6476,6474,
6473,6477,6501,6499,6498,6500,6511,6516,6531,6537,
6530,6566,6576,6580,6575,6590,6593,6582,6578,6574,
6570,6607,6611,6617,6641,6639,6644,6612,6614,6623,
6629,6660,6664,6657,6663,6678,6684,6696,6713,6682,
6731,6718,6774,6735,6785,6741,6763,6760,6758,6761,
6744,6756,6743,6745,6752,6749,6830,6828,6831,6846,
6843,6856,6867,6871,6875,6874,6888,6882,6894,6906,
6883,6892,6929,6935,6952,6936,6965,6978,6949,6971,
5865,6450,14029,15498,1577,11182,21633,7505,9509,17606,
4847,11952,1336,5531,17783,7259,21352,15505,14032,4717,
7598,11340,14033,14034,11956,2670,9826,8882,1880,6558,
14787,7212,17314,16048,11806,9689,21783,3638,11807,15809,
9267,14923,8111,5372,20764,8113,19524,7143,2143,21139,
18085,19938,6237,19549,5249,16253,13755,16564,13384,11502,
21487,15959,11862,4804,7147,14736,2952,12261,20708,14126,
6241,20892,7045,4656,20016,13758,3402,7884,4570,3193,
8138,20094,1064,4831,20948,12639,2710,6245,20095,17027,
4906,17582,14388,1788,21266,13507,6938,6932,6944,6987,
6928,6941,6947,6953,6961,7026,7033,7057,7069,7092,
7061,7024,7041,7047,7030,7032,7063,7031,7108,7101,
7109,7102,7168,7131,7187,7136,7126,7159,7135,7155,
7142,7153,7152,7124,7125,7140,7130,7134,7129,7148,
7127,7257,7236,7228,7232,7241,7227,7268,7278,7292,
7287,7293,7307,7312,7304,7306,7305,7308,7320,7330,
7319,7317,7334,7321,7349,7329,7325,7326,7316,7341,
7401,7410,7400,7432,7418,7397,7404,7426,7399,7407,
7406,7467,7498,7494,7491,7468,7458,7495,7504,7459,
10061,21267,14318,5144,18503,4907,16147,20682,3340,2831,
14524,21042,17196,21688,8079,1179,13475,11379,14809,21720,
8933,7984,13763,6008,17588,7792,21174,2725,5592,1119,
8431,8934,6362,3051,6542,5337,15540,17532,8840,7666,
13560,5071,10657,17991,1366,17290,4915,5318,15914,13798,
15804,19112,9419,17589,8377,5063,3843,15940,14934,7591,
17353,6765,8432,7427,8381,2570,16607,20713,10498,2523,
13403,14750,1198,15942,17427,6544,13180,5355,17781,15647,
17792,17538,6255,17038,4921,15841,15186,4130,9072,4839,
7991,6424,20819,18270,8095,4776,7470,7475,7464,7463,
7478,7486,7473,7462,7548,7539,7540,7542,7538,7561,
7569,7567,7566,7565,7581,7593,7585,7631,7616,7634,
7617,7615,7606,7607,7611,7614,7609,8468,7663,7662,
7660,7650,7661,7652,7648,7654,7687,7653,7667,7711,
7719,7708,7709,7701,7712,7747,7736,7735,7739,7751,
7733,7805,7767,7763,8220,7772,7788,7799,7808,7777,
7778,7832,7829,7842,7867,7843,7848,7854,7837,7850,
7853,7845,7869,7889,7871,7874,7870,7876,7894,7898,
7904,7895,7903,7923,7942,7930,7941,7922,7932,7931,
7167,17898,13734,21590,2398,4220,9652,10521,9822,2734,
13594,14319,12717,21406,12719,16283,12980,17299,14717,16407,
15572,16284,5175,16330,1371,21384,1955,5866,3206,10592,
10180,12779,20457,1500,2988,10080,11150,12647,13160,15733,
21591,5804,21649,16894,21514,17730,9835,7909,4590,13931,
11258,19765,21620,4491,10522,17906,19242,14284,12720,17911,
17335,7360,8735,17302,13924,11151,6979,4102,2699,3709,
11259,10841,19892,17599,1253,14955,13351,1556,6568,5340,
3082,11178,16512,5021,16470,15956,5421,11203,17544,9800,
21593,1601,5807,19122,15651,5574,7919,7920,7975,7992,
7972,7989,7986,7996,7969,7980,7993,7990,7971,8005,
8030,8017,8016,8064,8060,8054,8068,8034,8043,8059,
8051,8044,8032,8088,8093,8119,8110,8107,8135,8137,
8128,8134,8126,8139,8152,8153,8143,8144,8157,8145,
8154,8147,8213,8176,8178,8184,8175,8180,8224,8216,
8250,8254,8253,8252,8315,8278,8301,8273,8282,8303,
8320,8311,8290,8272,8300,8287,8293,8341,8345,8340,
8366,8374,8354,8370,8389,8478,8401,8418,8413,8458,
8412,8396,8399,8410,8489,8499,8494,8487,8488,8519,
20998,20073,2479,2194,3351,17103,19893,21621,17834,14484,
16366,5341,14114,19310,7954,19034,21386,11709,1194,5530,
12046,21153,7368,3004,13574,14868,20076,17105,3182,7191,
13817,15551,5027,20033,20693,5221,13907,6376,20131,15608,
17306,15147,20694,21635,15552,6668,1960,1516,4779,3144,
9516,15270,18339,17000,21637,9395,21332,12989,10785,20858,
10509,11400,12392,9745,18000,21623,6996,14200,15220,10526,
1372,18758,14058,11323,13047,6848,17166,7198,14144,17799,
13663,18001,15224,13080,20301,21765,20826,14241,14035,9981,
19799,4501,9886,2337,21741,7527,8515,8528,8522,8516,
8524,8545,8544,8546,10204,8552,8554,8571,8559,8567,
8589,8593,8591,8598,8600,8614,8626,8629,8633,8637,
8644,8639,8647,8655,8656,8659,8664,8668,8669,8670,
8680,8695,8692,8673,8702,8703,8708,8714,8715,8716,
8720,8725,8741,8745,8743,8744,8757,8755,8773,8786,
8785,8787,8790,8797,8800,8805,8819,8820,8826,8830,
8843,8832,8841,8846,8853,8855,8857,8856,8864,8872,
8866,8865,8884,8892,8896,8904,8909,8929,8926,8932,
8923,8922,8950,8954,8952,8955,8971,8963,8977,8992,
13709,2243,13936,17800,6812,6495,21698,16928,13049,20034,
3300,14487,6815,7213,14099,7445,7562,6559,13081,3089,
7868,7694,1531,2204,19057,11885,15225,19058,14141,13884,
7218,1708,12959,9219,12590,18072,12747,12225,18637,11409,
9457,17555,21701,8948,19449,17915,9401,17176,2212,7697,
10354,2213,19276,1945,13689,17180,21712,21703,10667,17007,
9255,9412,9809,6227,13749,21244,20700,3829,17026,19231,
15568,20065,17291,3173,17568,4808,4809,12626,1789,12483,
17382,20548,5176,19250,5654,21742,15425,2017,12825,16628,
19268,9402,15432,10355,14973,5154,9008,9004,9005,9028,
9029,9062,9075,9080,9078,9089,9088,9103,9104,9115,
9124,9120,9127,9106,9148,9141,9173,9196,9192,9191,
9190,9204,9195,9188,9200,9198,9237,9235,9244,9238,
9256,9257,9279,9281,9274,9277,9270,9296,9308,9311,
9314,9316,9340,9341,9343,9360,9357,9356,9379,9369,
9388,9396,9425,9422,9446,9426,9417,9451,9440,9443,
9441,9463,9464,9469,9476,9478,9486,9514,9515,9479,
9480,9493,9558,9549,9550,9566,9547,9482,9605,9581,
9611,9583,9578,9585,9618,9577,9584,9630,9590,9598,
13649,14373,5471,21226,8188,10999,11247,5591,15642,8378,
4916,14394,5593,21450,19753,962,4444,14945,10708,10182,
1101,4446,2350,16518,1507,7199,2690,10185,8387,11142,
20561,10621,12322,7014,7020,10548,11086,3283,18469,19502,
19500,4676,1065,18521,5506,12997,20172,5189,18958,21268,
18808,13799,13645,13044,6545,17295,18990,18509,13014,12933,
19625,5342,19899,4502,14203,4694,14204,9780,11891,13053,
5405,2682,4657,6242,2647,3194,4908,17089,12172,9107,
12264,10189,20949,13476,16951,17533,16878,8706,6767,6695,
17423,14153,6256,7547,3543,14155,9634,9580,9626,9588,
9597,9576,9503,9553,9710,9721,9718,9714,9757,9725,
9716,9717,9715,9766,9768,9793,9786,9785,9783,9819,
9813,9815,9820,9811,9828,9842,9846,9844,9839,9841,
9869,9855,9856,9854,9875,9857,9853,9352,9902,9908,
9881,9859,9906,9914,9933,9926,9915,9929,9959,9952,
9979,9977,9953,9951,9988,9957,9996,10012,10009,10027,
10044,10067,10078,10079,10051,10028,10063,10046,10030,10052,
10035,10112,10116,10115,10119,10128,10140,10130,10138,10126,
10121,10145,10125,10173,10187,10205,10218,10207,10217,10226,
2662,17943,2667,21594,16297,6710,6295,6153,12393,9746,
13485,1012,9982,12173,13135,1014,6816,17952,3550,9339,
5432,5435,5433,3833,13915,4377,4084,15836,12265,2599,
13519,7246,8295,2780,10600,7071,20259,10291,7001,9365,
6915,19450,6509,18906,13195,20018,3371,6243,20837,20838,
20683,2383,20745,19505,16215,15770,4385,18207,15813,14106,
6050,14504,9936,7994,1424,3660,5851,16572,17907,12484,
3072,3908,3909,15864,8264,3083,8956,9739,9740,16624,
9016,9747,9752,3087,14478,15045,15843,9023,11795,20859,
3393,11837,13142,7531,15844,15846,10219,10258,10260,10257,
10280,10273,10300,10306,10310,10308,10323,10321,10335,10322,
10327,10369,10365,10366,10372,10466,10422,10316,10425,10401,
10411,10444,10415,10398,10394,10434,10474,10486,10496,10488,
10491,10505,10497,10499,10515,10519,10513,10516,10419,10517,
10531,10532,10530,10536,10557,10558,10561,10562,10571,10579,
10574,10573,10576,10577,10601,10612,10620,10608,10613,10616,
10617,10618,10640,10658,10650,10653,10651,10671,10675,10684,
10685,10686,10682,10701,10714,10712,10715,10718,10728,10729,
10725,10730,10749,10746,10743,10761,10780,10768,10775,10776,
10247,20545,14996,15128,20554,18888,13372,8740,2045,5245,
3614,6572,2617,13750,13891,19917,2099,5919,4674,12129,
12074,19459,13652,16591,12673,12291,16831,16832,8742,3830,
1446,1080,1817,13469,15722,21544,4607,20803,11696,12180,
21570,4824,17192,11442,13437,8674,2623,18443,12075,2557,
17745,4380,6188,21571,5709,2511,15796,3195,10900,17524,
17525,10731,17526,11815,16604,16594,17764,8053,19506,6181,
9931,14184,15876,10904,2955,14444,7274,15592,8343,7054,
17763,17666,16126,2515,16070,4003,11606,12332,5512,9461,
20509,15201,7750,9833,14872,1621,10770,10795,10803,10799,
10994,10793,10817,10825,10833,10840,10827,10828,10856,10849,
10864,10865,10872,10881,10867,10890,10896,10895,10902,10922,
10926,10916,10894,10899,10907,10945,10936,10938,10954,10959,
10951,10958,10971,10983,10990,11001,11036,11021,11005,11037,
11034,11046,11045,11096,11064,11072,11067,11057,11060,11055,
11085,11116,11112,11111,11132,11117,11121,11149,11145,11147,
11170,11162,11166,11168,11175,11181,11188,11190,11191,11204,
11198,11200,11207,11206,11221,11217,11234,11268,11264,11274,
11273,11272,11292,11311,11293,11300,11291,11318,11321,11325,
10590,12368,5874,13561,2924,3428,11628,11514,13764,14445,
2985,8199,3969,12308,5846,16664,10919,13921,4173,2657,
10615,11988,3696,936,11611,14847,20069,21063,13843,16001,
16461,7672,7255,4099,1482,2292,12954,16218,14714,15495,
15134,21382,19001,9862,7072,12312,17540,10502,11977,2297,
10437,5853,12078,2853,7577,4844,21310,10438,7630,19353,
10480,18031,2077,15932,11710,9878,3209,5729,17440,15598,
4497,20857,7633,6344,3208,18724,17336,15189,4716,21295,
3409,8880,11880,8459,2848,8361,9129,9777,16103,12737,
3213,1720,18067,11618,16669,20188,11331,11346,11332,11333,
11339,11336,11349,11352,11355,11376,11391,11401,11364,11386,
11385,11366,11420,11413,11428,11437,11435,11434,11436,11429,
11467,11475,11468,11464,11474,11450,11452,11472,11458,11479,
11485,11491,11621,11501,11494,11499,11497,11521,11518,11519,
11531,11529,11544,11539,11549,11568,11584,11604,11602,11613,
11615,11625,11627,11493,11635,11636,11642,11665,11648,11646,
11643,11674,11673,11698,11707,11697,11705,18231,11712,11713,
11729,11728,11724,11737,11741,11744,11747,11758,11760,11769,
11799,11771,11786,11787,11768,11817,11823,11822,11830,11819,
17312,1642,17733,9056,9132,18239,10351,6921,20098,10644,
13496,20189,10549,11670,20099,12859,16654,5696,9980,5693,
7647,7162,5193,2761,11152,11790,5278,7488,3845,20816,
17766,15359,17271,2100,13616,19682,17688,8265,8163,17671,
14339,8136,15389,14673,15458,12611,12612,5631,6496,15763,
17100,3507,4484,12000,15378,4486,2866,10331,10066,17090,
13319,12084,8849,4922,20217,4778,9497,19616,9287,15880,
1846,11740,8205,6638,21595,1602,11477,3857,3983,1216,
2110,19035,2015,10292,3355,18032,18632,3577,3462,13039,
10387,18874,7091,7532,6916,12748,11821,11845,11851,11855,
11861,11858,11870,11869,11866,11886,11901,11908,11912,11915,
11928,11924,11923,11936,11954,11958,11942,11961,11968,11971,
11969,11992,11986,11987,11994,12001,11999,12004,12011,12012,
12007,12014,12017,12020,12016,12027,12026,12034,12033,12037,
12045,12061,12062,12055,12059,12071,12081,12083,12094,12098,
12099,12103,12102,12107,12110,12117,12119,12127,12131,12137,
12141,12139,12135,12155,12148,12147,12163,12168,12181,12177,
12183,12215,12199,12209,12200,12207,12217,12218,12192,12210,
12231,12237,12250,12257,12284,12247,12252,12272,12306,12292,
10389,10356,2216,14861,7370,12455,18412,18428,2040,9374,
15833,15771,7605,12191,18896,2097,11144,5094,19700,6408,
21561,6750,15167,20902,16093,16427,12791,16560,13721,4862,
21245,6445,8403,7133,1021,2773,10862,13776,5996,19136,
19498,18907,13139,12331,3672,3616,9596,19429,1304,18852,
21250,11677,1813,1741,17779,18597,17144,6232,20347,3923,
3823,11765,6327,10897,14463,5565,1441,16492,4875,21479,
20882,7144,3063,11749,18017,5271,9604,13789,2155,2410,
19710,6011,21562,9922,16714,4185,5705,3048,5444,5677,
7613,19579,21484,4438,10819,21073,12299,12307,12294,12285,
12327,12333,12350,12341,12355,12363,12360,12358,12381,12389,
12387,12399,12408,12416,12419,12425,12435,12431,12443,12449,
12450,12462,12464,12477,12458,12460,12473,12459,12466,12500,
12502,12505,12511,12533,12539,12526,12535,12540,12558,12566,
12555,12575,12578,12576,12580,12594,12592,12593,12597,12595,
12601,12614,12613,12636,12638,12624,12630,12619,12615,12623,
12646,12621,12618,12667,12701,12668,12670,12692,12686,12680,
12660,12715,12672,12659,12698,12769,12760,12756,12758,12762,
12797,12798,12818,12783,12787,12788,12789,12793,12784,12827,
12856,21200,6536,4825,5058,3284,2878,7976,4378,968,
13088,2594,12471,7879,9345,14805,21343,3285,2056,19580,
4074,16436,9481,3997,4829,13730,19146,1918,20042,15173,
2506,2413,16715,1674,16851,5353,21264,11375,21346,21756,
16122,13385,15256,2414,12196,11000,17725,7978,2370,8495,
18259,3253,5960,3254,7272,16315,19468,11863,14289,17284,
16601,7783,11548,11461,16026,11637,10818,3050,3686,13470,
3933,21644,9108,10409,16499,11773,9037,12577,20115,5211,
5860,10588,2722,2921,20453,10978,9487,1266,13237,8359,
13196,3656,7740,7900,13092,15355,12836,12837,12862,12848,
12860,12867,12842,12851,12878,12843,12873,12919,12937,12917,
12918,12912,12932,12952,12947,12957,12970,12972,12962,12979,
12995,12990,13004,12991,13026,13028,13025,13041,13074,13067,
13065,13056,13090,13107,13086,13087,13115,13132,13130,13126,
13122,13119,13124,13138,13141,13143,13146,13148,13174,13173,
13172,13194,13199,13204,13190,13210,13201,13228,13235,13245,
13247,13246,13248,13249,13255,13278,13271,13273,13268,13282,
13283,13290,13318,13308,13341,13336,13338,13392,13373,13366,
13381,13375,13446,13421,13440,13422,13441,13431,13429,13474,
5334,6458,13177,930,16324,1376,21125,7336,9992,15438,
15726,3538,6394,6103,2934,2290,6538,4632,9157,14149,
18315,18805,14308,7160,5611,2063,20684,16182,8116,1459,
18961,11002,1282,12123,3902,13346,8682,17383,16296,19673,
19674,5009,9792,17934,11560,2068,16638,2969,17424,1551,
11465,933,19297,9085,9086,7545,11176,21759,21780,21665,
13841,16985,18688,934,13477,7342,4917,10520,7343,12170,
6251,6252,6289,18386,15977,21503,13274,11098,6626,14391,
5082,21146,7489,16452,1832,16358,7163,4095,18621,15175,
13562,20639,6838,14528,9194,21585,13504,13506,13511,13522,
13514,13533,13585,13540,13575,13544,13539,13554,13547,13588,
13597,13596,13605,13604,13607,13608,13623,13625,13615,13613,
13644,13646,13658,13662,13665,13668,13680,13686,13687,13685,
13690,13695,13702,13707,13710,13711,13716,13715,13713,13726,
13752,13742,13738,13736,13746,13745,13772,13773,13778,13784,
13790,13807,13791,13818,13810,13806,13792,13788,13829,13839,
13836,13857,13864,13885,13873,13877,13861,13893,13892,13890,
13895,13906,13914,13912,13933,13944,13943,13951,13952,13960,
13962,13978,13979,13988,14002,14005,14000,14009,14014,14017,
18534,19838,10913,19989,14810,21325,5613,13671,18005,9007,
16453,19509,15066,19116,14532,2959,14582,19991,20647,13870,
9643,13606,19888,9644,8261,16887,2776,17846,16002,10135,
6899,3741,12977,21666,12537,3242,19840,2781,19754,12041,
12579,11511,16956,4681,20025,13969,2013,11061,15236,11305,
15067,10136,16957,5477,9280,5086,3259,15488,10639,17938,
18608,5778,21618,5801,21781,15779,2071,12157,9197,14395,
9301,10074,3811,15780,10858,15891,21207,938,9729,3073,
12485,13348,7910,2962,7809,16408,16057,2033,19774,19002,
8233,1484,10376,1924,20480,9391,14025,14027,14041,14043,
14050,14054,14056,14066,14068,14085,14074,14077,14107,14111,
14127,14120,14115,14119,14116,14117,14142,14147,14152,14158,
14162,14180,14218,14170,14164,14168,14194,14175,14205,14206,
14234,14240,14237,14224,14216,14220,14232,14259,14253,14255,
14274,14273,14278,14281,14270,14287,14286,14292,14288,14304,
14303,14309,14310,14315,14313,14314,14321,14323,14332,14329,
14334,14346,14350,14341,14348,14342,14338,14337,14385,14363,
14369,14366,14367,14387,14381,14372,14407,14414,14415,14422,
14438,14435,14447,14442,14458,14455,14476,14465,14454,14483,
13031,10779,18277,10081,7164,1625,5805,5945,3629,10433,
14354,14263,3630,18056,1883,3704,3243,14398,17996,6368,
1007,11100,10284,21045,12513,7573,11131,3074,11754,6781,
8384,19162,14195,19117,5852,2425,6430,14131,8810,12981,
10678,2020,20249,9510,16471,7078,12934,14507,11011,11991,
2237,3742,13934,9423,19626,13101,2787,6466,7361,10722,
20029,1229,19487,10446,13697,4337,15652,4616,8449,4638,
13872,4686,9017,14891,18182,17835,5022,3490,16722,3946,
14956,17441,17048,10224,20074,14298,7362,15239,10086,19783,
17104,15010,11878,17946,20077,19775,14490,14498,14499,14468,
14494,14512,14511,14522,14520,14527,14516,14510,14514,14552,
14556,14568,14559,14555,14572,14571,14562,14561,14595,14596,
14599,14604,14601,14600,14618,14616,14609,14612,14639,14623,
14635,14675,14649,14625,14636,14662,14679,14642,14614,14624,
14660,14630,14610,14615,14634,14632,14628,14629,14698,14699,
14703,14701,14705,14710,14709,14706,14716,14708,14756,14728,
14738,14735,14724,14751,14726,14746,14739,14745,14722,14768,
14767,14770,14782,14774,14783,14776,14779,14775,14777,21229,
14795,14799,14803,14797,14796,14804,14818,14807,14814,14819,
16964,6058,909,6797,6798,7192,3030,17333,16299,11222,
9468,7554,1995,14400,13035,9748,8691,19900,3297,15698,
15469,20407,15240,17163,4498,3892,17607,5532,14781,7514,
6015,13994,18059,18628,1134,4134,12438,16476,11835,2741,
10716,12400,12823,20205,2432,20662,4408,11689,19315,3110,
17446,12733,4447,7437,17912,8982,1579,3818,11138,9207,
7960,13331,13166,17249,17222,15151,10482,19052,17914,17561,
19053,9116,9429,7726,3636,20898,1292,18633,11403,6601,
1639,15087,15426,16058,13334,13109,16528,10160,6806,11980,
5224,20082,1256,9681,14785,21189,14806,14831,14833,14836,
14835,14837,14838,14845,14843,14851,14848,14864,14871,14875,
14885,14883,14886,14895,14888,14889,14897,14906,14903,14902,
14933,14952,14949,14928,14924,14922,14921,14968,15004,14974,
15003,14971,14976,14977,14986,14969,15017,15039,15036,15051,
15050,15048,15047,15049,15063,15072,15084,14911,15090,15092,
15101,15110,15111,15118,15131,15123,15126,15112,15104,15106,
15159,15164,15165,15168,15183,15184,15182,15192,15207,15194,
15218,15202,15208,15196,15229,15242,15243,15264,15260,15254,
15266,15276,15275,15279,15273,15299,15292,15293,7828,15306,
887,10021,17953,13243,9184,16186,16814,13937,13938,12741,
10347,15097,16067,10816,20085,12498,19692,18069,7214,8082,
17954,13359,15098,8104,4796,1882,13678,19066,17261,19804,
8245,9781,9782,19199,13040,19269,10233,15964,6453,19979,
10101,18587,10931,5991,8962,9220,7219,3498,10789,9458,
9403,6497,4764,20827,16533,8987,6510,9535,7221,9435,
6515,10628,7015,8988,10471,7393,14013,15618,9409,13595,
17464,19080,10552,10982,1669,14930,17409,2832,6335,17814,
3236,4911,17821,10373,6396,6051,7623,8309,1275,18279,
20462,20463,8958,1703,17054,14830,15308,15313,15333,15328,
15345,15352,15351,15347,15376,15379,15368,15373,15372,15384,
15391,15385,15395,15392,15400,15423,15410,15416,15412,15403,
15435,15439,15436,15457,15451,15448,15449,15462,15484,15486,
15479,15482,15499,15478,15502,15516,15521,15518,15532,15530,
15539,15537,15546,15538,15569,15563,15562,15567,15564,15584,
15585,15590,15613,15603,15600,15604,15624,15623,15626,15625,
15638,15654,15656,15634,15670,15691,15699,15686,15682,15678,
15677,15707,15710,15729,15715,15725,15718,15754,15750,15768,
15772,15775,15801,15807,15811,15816,15827,15830,15834,15838,
3778,13376,2463,14515,8411,20571,14331,19550,5921,21548,
17360,4547,4307,1066,2626,12865,16565,19957,19958,8496,
12681,15908,12682,19868,8416,6728,13197,12683,21076,11462,
16316,4677,4678,6004,4995,13655,12112,11657,3341,12478,
2600,8296,9628,5003,20338,5436,12302,1873,17198,3783,
1675,1749,20396,15817,5514,19293,5280,3052,6732,10813,
5010,9932,18747,17203,9635,18976,12486,7793,14333,18809,
16328,11381,13157,5759,13321,9350,17684,7861,13404,7279,
16078,2372,1328,5971,17965,20714,4970,17246,9288,1485,
19841,19511,7801,3429,3762,6733,15832,15849,15853,15850,
15851,15871,15878,15888,15904,15917,15933,15895,15911,15897,
15912,15938,15937,15939,15936,15944,15947,15954,15953,15965,
15966,15968,15970,15983,15987,15992,15990,15993,16017,16019,
16025,16030,16034,16056,16059,16071,16079,16080,16075,16082,
16091,16102,16117,16109,16127,16146,16134,16132,16141,16172,
16168,16179,16181,16193,16190,16201,16194,16191,16208,16214,
16222,16226,16238,16229,16234,16251,16255,16242,16256,16247,
16282,16264,16265,16280,16270,16261,16269,16289,16295,16308,
16312,16309,16321,16317,16319,16339,16341,16337,16336,16344,
15031,8206,12721,19766,8531,14946,10593,9653,3855,15573,
9048,5937,5976,1213,4604,16466,4144,19845,15291,12955,
13945,11661,16467,9836,3935,4334,1166,3705,16331,1979,
11099,2187,9125,7067,15865,10883,17836,11153,7755,14586,
17944,18335,13845,16367,5023,19894,10968,16513,13925,17546,
17071,19245,14540,2700,15468,21180,21596,15653,19895,11012,
9128,4032,13352,16963,16644,19994,13510,19307,7550,1150,
14959,3054,16917,16613,9749,1151,13819,7086,16697,17798,
5984,18827,1395,6467,18871,4079,11536,6126,6377,6736,
10693,19037,16577,19311,15609,21047,16374,16360,16343,16379,
16384,16391,16381,16393,16395,16378,16406,16396,16428,16444,
16429,16423,16424,16425,16426,16489,16507,16491,16493,16494,
16501,16527,16490,16503,16500,16497,16508,16488,16548,16541,
16566,16557,16563,16559,16586,16595,16592,16598,16611,16610,
16625,16630,16642,16632,16640,16646,16665,16653,16659,16651,
16681,16679,16685,16672,16677,16684,16682,16701,16707,16711,
16705,16704,16702,16741,16729,16746,16731,16757,16733,16743,
16734,16772,16803,16791,16781,16770,16771,16787,16784,16827,
16893,16828,16821,16863,16829,16869,16899,16823,16888,16849,
2016,15014,12728,15788,14266,3713,10452,16524,21009,2430,
13482,12319,19639,7522,10293,13231,19198,7557,16580,17447,
10786,20593,20616,10681,5837,10155,3088,9519,10765,17448,
2301,11404,21711,14961,13356,15597,20860,12222,7692,13486,
1678,9887,5764,17002,7120,21314,4605,9334,8461,8462,
19172,2201,7640,11595,17454,11427,2701,18108,14962,2795,
2487,3463,9570,14243,18875,8029,3301,12826,3033,17369,
14355,13219,19325,2160,9673,20280,17955,21209,20264,17510,
10823,17619,12749,13828,7451,6032,21471,7826,1709,6073,
4508,9434,7825,9138,11289,9690,16875,16844,16824,16853,
16904,16817,16854,16891,16859,16884,16820,16873,16966,16952,
16950,16948,16954,16983,16982,16979,17013,17034,17011,17018,
17070,17063,17073,17110,17101,17096,17077,17074,17080,17117,
17123,17121,17118,17149,17153,17135,17132,17158,17137,17188,
17187,17199,17197,17184,17191,17186,17206,17232,17233,17269,
17293,17266,17296,17288,17292,17274,17285,17272,17270,17320,
17323,17343,17321,17334,17337,17328,17318,17354,17352,17349,
17364,17359,17357,17379,17378,17389,17385,17376,17381,17417,
17420,17438,17399,17487,17451,17425,17407,17404,17468,17472,
13417,11808,10357,4082,17461,21194,10248,9537,10249,12092,
18646,12326,11569,5540,19277,14790,16944,1981,13498,13584,
1982,10757,7827,21219,21423,6608,11919,12132,21082,10733,
4420,8555,11230,17060,8615,19923,13471,10069,17989,14811,
15915,10270,17207,6374,16514,3546,2689,16519,3548,21401,
5121,19572,18781,4826,4655,7774,21038,3400,18935,21074,
7852,20805,17527,13653,20806,8492,2158,6687,13654,16145,
10111,1267,18618,21778,1452,14317,8297,6140,18019,20681,
18801,12013,1783,3598,4996,5798,20934,20950,13656,18947,
16123,11503,5416,17985,20575,13438,17471,17481,17489,17482,
17492,17491,17488,17507,17506,17508,17509,17547,17512,17522,
17536,17514,17529,17516,17530,17558,17579,17569,17618,17603,
17564,17565,17590,17575,17650,17631,17642,17635,17632,17643,
17630,17627,17664,17667,17676,17683,17680,17679,17674,17696,
17704,17699,17698,17697,17717,17721,17719,17722,17720,17735,
17734,17746,17737,17741,17749,17750,17755,17757,17762,17780,
17895,17790,17784,17788,17787,17831,17804,17828,17815,17826,
17811,17845,17847,17899,17887,17870,17863,17865,17879,17871,
17893,17890,17885,17886,17919,17927,17922,17962,17963,17959,
19727,11058,1784,1792,2631,2627,8838,13762,7590,7479,
11380,7789,4382,13866,21172,5713,19103,8550,17710,14105,
9038,11753,14813,7252,9069,9562,8344,14392,5282,20685,
10131,7169,18993,1899,21350,14884,13647,9559,17794,2168,
9042,15571,19930,10075,2632,2271,2730,9834,12142,4589,
5802,18331,4030,20981,12777,12710,5863,8753,12640,15694,
14674,4932,2698,17595,3856,9049,4088,17795,17796,19931,
5019,19623,16055,18333,6706,12115,3383,20048,15303,5422,
6502,13814,19932,11535,8102,2129,1152,14046,11756,19251,
7865,6505,8844,9741,9511,14542,17973,17977,17984,17983,
18006,18007,18014,18010,18029,18036,18049,18054,18093,18077,
18080,18075,18078,18076,18123,18116,18113,18114,18122,18117,
18138,18141,18142,18144,18139,18137,18157,18154,18162,18165,
18170,18166,18180,18176,18185,18188,18221,18212,18223,18215,
18220,18261,18245,18258,18271,18250,18243,18248,18278,18266,
18253,18252,18305,18313,18314,18310,18332,18371,18380,18401,
18360,18367,18387,18368,18366,18382,18369,18377,18373,18442,
18437,18446,18445,18457,18452,18459,18462,18453,18468,18455,
18501,18494,18502,18499,18520,18524,18538,18536,18529,18570,
10506,19038,3822,17611,17167,16525,1658,2035,7193,14109,
1232,1508,4944,7438,21333,7439,3211,7088,3391,20105,
4500,1857,17390,18107,1677,13699,10764,9208,1027,20261,
5789,2047,15221,11882,2172,9779,3460,14786,15447,1533,
9212,4947,20899,15340,14788,16219,14691,1122,17552,1870,
2459,9186,10244,16974,17178,9224,20600,3361,8271,20168,
14549,7456,19077,9231,18187,16822,4781,5011,4798,1103,
6132,7017,7022,7460,5609,1594,18372,5714,8423,12377,
10870,11119,11120,11218,14652,15002,2167,20686,8433,11125,
15805,9733,18624,20982,8505,16960,18562,18540,18565,18550,
18555,18544,18598,18603,18616,18617,18636,18642,18644,18648,
18647,18662,18660,18657,18669,18682,18666,18667,18668,18687,
18671,18683,18726,18744,18733,18745,18743,18736,18731,18732,
18818,18770,18812,18804,18767,18800,18820,18774,18777,18785,
18835,18864,18855,18857,18844,18843,18850,18845,18885,18903,
18917,18909,18893,18881,18902,19048,18966,18991,18933,18891,
18992,18984,19009,18884,18880,18946,18985,18923,18889,18948,
18908,18894,19047,18960,18922,19093,19094,19086,19098,19095,
19088,19091,19134,19155,19153,19150,19181,19178,19179,19183,
14214,16368,17049,15756,19635,9245,4344,4065,13183,12095,
7200,11312,19316,5459,13526,20464,7963,5618,3578,7529,
10622,13527,7380,16418,8470,13529,10625,9250,14433,3639,
5623,18362,15751,13378,7881,3124,20951,2363,7048,3430,
3657,6484,13566,5287,14667,5760,7833,6860,13407,17685,
11662,6980,10439,20326,1518,17692,14267,5390,21014,18026,
2850,16932,18840,10470,8475,16942,18422,16946,18249,3899,
4992,13379,13380,7705,7145,4524,18124,3804,6274,2102,
15586,17812,7784,3418,13759,18125,19147,14221,12802,16124,
7150,18126,19163,4262,4659,18203,19203,19221,19247,19227,
19261,19219,19243,19289,19290,19291,19288,19305,19284,19318,
19286,19340,19338,19351,19349,19357,19361,19360,19382,19362,
19364,19368,19423,19421,19399,19401,19409,19397,19410,19403,
19428,19438,19432,19439,19433,19452,19453,19456,19472,19455,
19458,19477,19499,19495,19494,19518,19520,19539,19532,19517,
19519,19545,19552,19557,19570,19612,19617,19610,19622,19562,
19574,19608,19573,19600,19554,19588,19592,19559,19583,19658,
19653,19656,19662,19655,19663,19657,19694,19720,19699,19705,
19696,19745,19733,19712,19737,19749,19724,19708,19704,19756,
18532,15052,14424,19154,17640,8425,17469,11624,2418,19475,
20893,17747,4572,17668,2333,14345,18264,13980,21407,17855,
18962,18963,15119,2565,6071,14393,6108,17894,20687,21273,
20781,5448,21556,20399,5519,5012,7420,3846,10071,3658,
18522,11590,12064,21147,5145,18977,8302,18622,20367,16149,
18810,13508,20549,12487,1471,17752,13445,1083,3292,21689,
15541,21232,3015,20584,19416,17858,18095,18994,6666,6112,
14668,2126,17496,14534,6175,2144,5452,5761,13567,6776,
7802,6485,5065,17355,16365,14396,2731,3971,11062,11320,
4332,6703,18275,17748,5595,4422,19714,19735,19744,19717,
19776,19695,19830,19834,19826,19854,19861,19869,19864,19873,
19891,19858,19857,19866,19886,19884,19876,19912,19919,19929,
19920,19921,19935,19937,19966,19964,19954,19950,19965,19943,
19956,19961,20017,19999,20014,20001,20041,20035,20055,20075,
20061,20059,20071,20054,20088,20101,20100,20113,20112,20110,
20120,20121,20124,20125,20137,20144,20149,20152,20173,20184,
20186,20191,20192,20195,20206,20198,20197,20203,20200,20224,
20218,20212,20209,20207,20220,20234,20231,20228,20233,20277,
20283,20292,20293,20289,20307,20332,20317,20319,20333,20335,
1772,15798,18815,9421,21176,8906,8850,16693,7179,20983,
13770,3136,9303,4270,8914,16896,15881,3432,1331,2188,
19541,8764,13127,13181,14834,939,19683,17499,2529,7864,
17300,16695,16806,5238,15054,1890,6782,8062,14899,20716,
14900,4031,6451,2326,14873,7813,8736,13451,3106,17470,
15212,16332,17215,4617,2573,15327,19014,11487,19164,3814,
12335,21456,2238,2400,21400,7185,12650,15417,21387,16472,
8207,13287,3947,20783,20252,21650,12887,21457,9849,7506,
2843,17126,10604,14426,1657,6492,12372,19628,3860,17838,
12380,14682,17947,14683,6861,6493,20339,20337,20348,20362,
20370,20311,20356,20363,20358,20379,20376,20382,20384,20386,
20389,20412,20392,20401,20395,20391,20427,20424,20436,20428,
20426,20466,20448,20445,20447,20450,20455,20452,20483,20471,
20475,20477,20468,20494,20492,20504,20500,20503,20506,20501,
20505,20517,20511,20523,20524,20534,20535,20543,20550,20551,
20538,20553,20537,20564,20566,20572,20583,20592,20602,20603,
20613,20607,20609,20622,20642,20629,20645,20630,20661,20618,
20619,20620,20672,20679,20670,20720,20705,20719,20699,20752,
20733,20744,20729,20735,20726,20730,20771,20765,20772,20778,
4345,21083,3711,17548,4939,12605,15866,7515,12780,19784,
21521,21313,16998,6799,19124,943,17217,11555,2431,4783,
21183,18484,18402,6643,17948,5296,11950,12652,11422,18708,
16520,17689,15611,21114,14239,12516,9020,6669,6908,5264,
19317,11063,17479,11139,17001,13038,2402,18046,15658,15152,
1217,2613,12890,14688,7578,19902,17612,17449,15554,18582,
18583,20824,19643,1640,3116,9520,11341,11342,14268,20595,
11324,7446,20262,21692,9755,10294,1998,11981,5817,16967,
21466,1013,1044,7915,20596,18837,6345,7603,10787,2353,
5988,6469,2245,17839,20302,14103,20777,20779,20776,20774,
20790,20794,20787,20791,20821,20795,20797,20811,20789,20786,
20796,20842,20833,20843,20844,20830,20836,20831,20872,20885,
20866,20894,20867,20870,20878,20903,20928,20940,20901,20933,
20970,20911,20917,20907,20958,20932,20968,20914,20913,20944,
20959,20912,20947,21025,21037,21032,21039,21041,21035,21056,
21055,21075,21067,21068,21085,21088,21084,21090,21086,21104,
21119,21122,21123,21133,21143,21134,21138,21154,21168,21166,
21175,21159,21170,21169,21162,21203,21195,21201,21231,21224,
21236,21233,21222,21269,21255,21243,21270,21251,21277,21272,
16933,20329,4138,20785,11597,9213,4278,19356,8464,7003,
21751,7695,1881,6817,21335,11347,20285,20345,14592,13110,
15428,20286,12608,14488,17956,20222,15431,3468,15227,17175,
7006,7730,9760,11892,18763,888,20415,6740,6819,19067,
19068,14244,13692,11900,12960,4140,15338,6438,21117,6033,
920,19273,7386,19805,7455,6826,4047,20599,17958,20165,
9436,14434,16535,2250,9702,18841,1611,20601,18423,4355,
2748,16537,2749,18639,2217,13693,19202,9229,2460,17556,
11810,6528,20169,19082,3473,20422,18433,4056,16108,13741,
17739,17751,1434,21092,14421,17816,21242,21249,21259,21253,
21293,21298,21299,21301,21304,21317,21329,21328,21330,21345,
21340,21349,21339,21362,21354,21356,21367,21368,21365,21385,
21373,21376,21399,21402,21413,21410,21409,21414,21446,21430,
21437,21438,21442,21427,21432,21480,21481,21489,21483,21501,
21491,21478,21553,21476,21536,21554,21537,21560,21567,21559,
21603,21582,21598,21574,21576,21610,21626,21638,21658,21660,
21661,21663,21668,21669,21673,21687,21681,21682,21683,21704,
21700,21714,21729,21723,21725,21737,21739,21754,21763,21764,
21773,21779,21766,21767,21777,23849,23850,23851,23852,23853,
12866,6246,17064,7055,6257,5909,6213,16924,16925,9888,
5946,4048,10251,12768,9563,3570,1394,14823,17309,4758,
21018,21024,18434,18435,2824,6691,16095,18964,18965,7337,
1068,6313,4323,2777,7355,8746,5066,8310,4842,16897,
1695,21184,7260,4692,16926,1858,16549,6554,3637,21600,
4696,19059,971,12303,11506,12266,5437,11508,19538,11382,
15005,6546,8747,6113,975,9506,11663,1425,19689,7261,
16033,10826,16927,19049,8332,2769,15429,6527,8484,1299,
20624,19863,4993,1942,5406,15591,18949,6006,16258,12432,
6893,4529,15390,5645,20242,20952,2817,6927,16768,5073,
11736,13984,12244,5322,2492,5276,11580,4342,5794,19576,
12420,1404,16107,18527,18539,20788,3641,17661,19206,8968,
19762,5197,15583,21221,7034,11534,11212,6933,12658,11087,
1806,14078,5526,20268,14336,3250,18312,8430,14942,18704,
18403,4538,12518,5745,8999,1571,20253,5586,19497,3501,
18883,16585,8008,8816,5766,8560,9118,6945,14219,16230,
8859,12385,8436,13064,6865,19019,8074,16322,13714,3874,
20491,9367,13976,18886,11451,13739,19654,12329,18155,16209,
16732,2260,2002,8640,21240,11843,8547,19434,18898,5413,
4419,21274,14659,1472,21509,4421,5776,12379,1572,10720,
3345,14502,8935,4634,15814,18811,2603,10873,6145,1346,
10424,10014,6777,5067,12371,21510,7298,17900,20278,7673,
5068,20174,7493,19246,18132,20717,14326,1696,1697,13408,
14327,2886,20176,21108,9174,20151,3055,2401,14275,15757,
12143,5343,17216,10735,7507,15213,5025,15461,3107,3108,
20993,6981,20515,4066,7955,11260,2972,20078,1255,20119,
9176,4795,2024,6998,14509,913,21334,5030,5460,14011,
20263,9889,19054,1135,2443,16301,21011,21392,1643,19998,
20308,3448,20159,18413,12589,14245,15896,16133,11672,5039,
7035,4415,19521,8851,8599,21161,18910,15765,2149,7649,
11867,11414,2717,18306,9599,13377,9551,19660,12452,19402,
14988,4787,12968,13961,12015,21412,14732,10637,16631,1416,
15680,5610,8774,8291,4710,18311,17528,7151,16346,21611,
10274,15519,1688,11938,2655,16889,8018,7496,7621,8158,
15919,17940,3386,15894,16104,14330,12852,21684,19976,3150,
3615,16818,18128,6267,5855,2242,8986,1219,12574,6206,
4899,4855,15103,14979,15952,18304,1819,5795,10869,17583,
10535,12546,1751,19308,10643,9399,1725,6406,9916,17230,
16303,19330,7964,5409,17225,20177,1540,4049,14772,18420,
18421,18003,10272,5151,20179,19855,1473,21105,4791,19995,
16865,15916,17039,2473,2482,17106,15507,21657,9606,14222,
13314,13224,17240,21495,8426,13225,2601,3002,2450,3847,
3604,17033,20400,8434,7068,2605,2783,5572,18045,15806,
4217,5130,15267,3137,16961,20555,15137,19192,8235,7508,
13630,2989,3187,10440,3491,13354,21522,15655,13456,2671,
6649,13111,13082,7727,20223,15706,4410,20148,16687,8677,
8427,2436,4549,19963,1099,12694,16183,18978,7490,10072,
10961,8825,3041,12830,21275,8201,15023,11106,21057,11297,
18241,7764,6273,14215,11967,8274,11620,5499,6066,3643,
20539,13427,18775,8898,9416,5588,7775,6680,14374,5440,
13542,20775,6851,17850,13120,5229,8911,16836,21640,21436,
16437,19585,14420,2226,15198,2419,7480,18044,18684,4314,
19728,17926,931,3687,21494,12378,11328,3466,15120,14658,
11122,20585,7428,20284,13097,8439,18397,20403,2457,7759,
7896,4977,16773,12844,8007,1155,3748,21768,1283,17700,
5054,20925,11767,21642,2919,12298,16349,6615,16445,16965,
5914,13307,8919,10791,16678,4540,1736,12249,1300,18670,
15815,12038,8306,11659,18816,7170,4238,4239,21177,13568,
21300,17356,2658,1383,20971,7280,1954,3294,8234,14753,
16008,2839,8063,11780,17432,1925,3222,11449,14754,7677,
13066,11051,7509,12727,16645,16473,7814,7080,11784,8208,
11785,10594,10441,9467,16286,13573,21677,13164,12651,3140,
21597,12238,20757,19636,4180,2973,19426,3712,20353,2442,
16156,15504,4940,21678,11951,2132,16073,13018,20441,3724,
15659,7089,10195,20156,1524,2692,10456,9890,15471,3358,
15153,17003,8997,7204,20861,13020,20862,12050,21601,9754,
20193,11733,16068,8242,17171,21052,3644,15349,7267,20915,
21163,8867,17019,6532,20057,9608,19333,5230,16837,4889,
12297,15404,18316,8375,18228,19160,20473,12514,14229,21651,
10098,4761,2771,6571,10724,13465,14311,6077,5306,11033,
17880,17541,15080,17610,8469,19177,12946,3475,2320,14919,
1581,1352,13396,1354,4301,4435,14769,6984,19377,6154,
16380,16673,5241,20698,8920,12330,18769,9587,12661,1156,
5100,10259,3749,10324,2379,3647,16136,11644,11456,988,
18194,3825,3951,8561,14177,14271,11601,5055,19138,2508,
14573,5820,18050,9924,19922,20840,957,18953,12300,11739,
1801,3148,8466,10022,15304,13083,13084,9852,4156,5634,
3303,1537,1538,8334,13137,4160,2746,7010,16767,19983,
11734,20864,9699,21021,2801,4107,16536,10252,10024,17179,
16538,9230,13682,17623,11811,15339,13500,7098,3155,21696,
17008,8990,8485,10025,3375,4660,15672,4218,5385,9291,
13735,10641,883,6982,8236,8781,8782,18338,10948,8634,
13458,10295,9366,4222,20863,18414,15674,3551,19279,19817,
2366,20336,5752,8493,19959,17665,3337,17924,4525,13760,
14185,8912,14742,16097,2420,3343,4315,11507,12695,10836,
13917,8913,12923,21319,6208,6336,12197,16027,14069,3338,
8822,3838,19108,9462,6312,5285,19881,10772,19369,9821,
2608,17651,12325,19076,2039,7604,11520,4068,12850,6939,
16246,17738,12761,17319,4861,18247,20009,4863,7132,9589,
4294,8280,12287,20879,13940,17268,2282,3060,13189,16779,
12965,12665,14172,1586,21246,8791,18851,11365,5102,12421,
10209,1077,11459,8179,13667,13281,2591,4874,10040,11748,
19204,10854,19285,13310,11243,14305,12967,18791,13694,1447,
3011,8255,15902,6725,21165,15852,13089,4888,13727,17723,
13546,6751,18086,11296,12799,7612,2679,7541,10652,19287,
13478,8936,3659,10073,3346,991,20688,4530,8907,18506,
12185,1322,5479,5480,12113,21276,13832,4324,1085,21120,
20895,18556,8683,18979,13256,14669,12488,4386,5401,8230,
7714,5684,10426,8572,13569,21106,20123,20972,14325,9848,
19768,14297,19485,6567,13641,20587,16285,4972,13260,21109,
11664,10082,20590,20459,9850,21518,6711,16333,2990,5869,
8609,18869,12216,12985,5808,11730,12493,5630,1333,10595,
12022,9825,13926,13847,7087,18485,17218,2876,3122,2944,
5297,19490,6215,14757,5028,21523,4941,16550,1360,20442,
19640,16551,8610,5492,20664,17108,12913,5324,7928,10719,
15231,6238,21141,8601,1401,14575,16633,19503,4260,10901,
19467,9620,15991,17148,4897,15172,19469,3621,17638,16267,
9275,19225,2953,7985,12693,16864,15028,7899,11532,12634,
1082,14741,2266,15812,19589,6539,1458,4910,16028,3424,
3201,18222,21664,3482,7335,16276,19292,5475,5965,12828,
4746,13765,17330,16359,2231,8568,12810,9006,16986,4322,
1246,12002,15858,10278,12028,17933,7251,20648,14533,13904,
11387,4361,1327,16621,6012,7066,9498,1212,7354,14910,
9309,19302,19755,15135,11007,3980,16990,9773,3135,10015,
19903,10457,7641,2351,21321,16529,6849,18033,20598,7728,
20465,1892,9355,4697,4470,9984,5302,14101,8613,6560,
18877,7093,21393,4392,19806,7533,6218,9405,12162,9700,
9703,10358,10026,3321,21095,9818,16546,3016,21726,1600,
9126,3025,18008,1182,1604,1607,1154,3034,1609,1610,
11872,11874,20695,2978,18729,13774,4513,14557,13897,2162,
5095,19546,18846,12617,20310,16338,16024,21396,3275,5997,
3276,4254,21031,2380,11694,2643,2409,21252,15559,16140,
13517,6726,3960,19533,11525,18793,7779,9923,18121,4168,
8089,19470,13386,3678,8045,18860,13479,8811,17917,9899,
6790,18134,8450,13932,21728,7079,11010,4493,12726,6265,
17608,6214,16370,19036,16626,15085,1517,6014,15365,13879,
18064,17254,5222,9523,6917,13488,6195,4506,11802,11079,
5393,18929,8916,9713,3265,18926,16840,20182,12111,19451,
9903,5049,5111,14700,10972,16036,2393,4955,1589,1022,
7776,7651,20091,18940,10605,8520,15760,18650,867,11504,
7110,5845,1116,8194,12545,9928,12921,5643,3841,20318,
18204,13238,19601,960,17932,1771,8970,19926,14747,4364,
2852,7346,14909,20431,11946,14044,10659,19239,20850,5974,
20610,16790,9719,15289,6729,5507,9158,1344,3256,8428,
1382,19476,21101,7935,19729,2984,15688,3289,19914,11945,
3485,15185,18326,2604,15643,14578,20640,19479,20066,4325,
5873,3293,16405,11551,18564,2762,18130,15319,3697,2606,
19915,15129,10690,5651,20481,14676,1935,2663,15138,4176,
3706,10285,2611,3230,13708,12888,17976,19777,18823,4338,
9873,14684,10736,6552,20408,15607,4409,1559,1562,9524,
19907,19493,10629,9573,15848,12757,14166,19560,13860,16260,
4814,8642,1684,17628,14411,19856,3214,6876,1191,8281,
1435,16210,8899,5703,14517,8818,20586,17542,10318,21750,
3151,5132,6598,12337,17718,21461,6868,21706,11576,18882,
15589,3326,14655,1895,2637,6931,8799,3502,9370,20309,
850,18528,4815,4950,18900,3314,9586,4292,1409,1123,
5818,13233,19180,20090,8543,17061,5581,10117,3920,11820,
4183,11582,19435,14925,8901,6943,14417,6681,3264,9910,
18784,17400,1442,2999,5673,6747,17758,18738,12025,8868,
4210,7137,11214,11052,20359,11868,5321,11412,10702,2555,
9320,5347,16709,20315,15274,20211,16839,21776,6946,4782,
20238,11943,11187,9954,21323,20528,15565,6332,3197,14146,
5053,6082,7036,6304,17702,16949,5718,11935,9289,18254,
2499,3995,10489,4958,16708,9272,7269,5346,1818,17024,
13518,17466,12627,13250,21096,21641,12465,9149,11651,19471,
1926,17322,8225,19380,13058,18742,10905,13963,1316,14743,
19672,20060,6311,8966,17325,17326,15059,15483,11301,16880,
13894,2835,21505,21647,18689,16691,17331,20019,13059,19367,
10874,2343,4840,9898,21306,6425,13062,10771,13063,17859,
3585,1529,18097,1502,20291,16409,20782,10882,9965,3384,
11013,18703,2046,8876,4755,11014,8939,9778,20154,2198,
19444,6999,18407,2206,20157,6522,19358,3419,1787,3901,
9268,9621,14832,2855,3837,3268,11550,9488,8969,7742,
19393,9001,8117,15060,19107,2652,7743,10276,8839,16639,
6762,13205,996,15121,4019,8730,11777,6072,2397,15262,
5284,855,11638,6020,3714,880,897,14908,5881,15890,
2566,12158,9460,2030,12411,12642,19238,1370,15082,3605,
11126,12188,8388,9863,12568,2856,7720,11960,13209,10317,
2082,3571,6013,7952,8453,18754,14004,12276,13875,1930,
6913,11565,16377,7396,11538,10575,6346,10031,19526,19664,
13251,19669,19897,16382,20910,12149,15515,2718,20239,5844,
16941,20162,9694,19586,18317,21721,10837,3376,4004,20636,
19871,4833,15711,12831,12507,2732,20129,2987,19540,19211,
12582,21727,5888,16412,10443,9242,18234,15575,20439,15418,
21388,17219,4021,15445,13412,2964,20079,4431,8698,15074,
2757,3234,20080,19431,986,20372,7599,12405,2244,19800,
9521,20194,18761,7601,15430,12509,11883,19069,18416,19070,
11745,13887,2747,18424,10104,11081,11082,11746,17673,7732,
14551,11084,18430,1587,14653,14692,9525,7875,5043,18856,
9897,3508,20527,3884,12504,13388,1081,20632,20839,1067,
10559,4961,11527,3807,14187,13116,16394,16658,10774,20514,
4934,4464,7027,12759,12853,12662,13426,18156,17267,1028,
2078,9189,1057,6413,8709,3921,7266,17785,3324,5427,
10852,11237,18914,3953,7703,18081,20732,9321,9145,15025,
18219,5548,17467,5824,8776,8417,13797,18606,16225,20122,
16399,19599,3237,10299,21498,10908,14503,15029,7114,20513,
9968,3588,1704,18831,3725,2636,4562,3128,18119,18466,
6307,9146,16981,2288,6622,18559,20756,7684,13499,14165,
13587,13368,964,5690,10683,11857,20039,17075,12106,4623,
13787,8869,14707,15230,1450,8369,9615,19584,17237,19143,
8806,2885,21551,4488,19590,16690,5966,5171,12696,10810,
13781,3688,15000,17028,18967,2147,14525,16022,16866,11918,
12871,13394,7481,12267,18653,19185,1092,4550,2423,17712,
3993,19967,12874,4837,1922,11509,17641,4265,8435,4172,
5418,19186,12925,1165,13989,13722,2336,11864,4662,20045,
18865,13202,12268,5827,6253,19156,8500,3809,18980,21043,
16987,5083,13782,6878,15380,8649,19877,10336,11639,16569,
4202,21515,11660,16003,14670,11257,5484,8689,10076,1752,
3020,5523,1837,12269,19757,15006,21762,1889,19483,3763,
7299,20649,14607,14671,15818,8307,15157,18740,5859,10610,
11656,14322,3131,11059,6361,2123,16451,16504,10911,11588,
20478,8061,8447,9871,17605,18063,6525,2877,6880,15233,
19161,20865,14554,15476,16094,17014,13753,19703,2641,18783,
17361,1786,19587,6844,2107,15068,11330,17768,7911,14030,
21331,11571,12328,16736,5743,12105,17759,17350,16170,929,
19670,1455,5338,999,7906,2191,17602,10000,19257,17626,
3504,3224,2251,16738,20904,11993,2677,16737,8579,2316,
2906,15016,1582,11854,6414,2821,12176,3279,18517,21771,
11645,4868,2330,18916,18778,15943,18213,2053,8562,18082,
12926,14535,15302,17994,20529,1269,6115,1489,14477,2784,
14583,1838,21279,2659,20096,12522,15918,12927,4925,20385,
10859,12879,4926,9645,19969,12270,18447,1180,1794,7803,
5420,14817,20753,11448,11683,11779,3698,7256,11473,15440,
14409,18866,14939,8937,8551,1296,15921,17713,6259,7678,
2633,4405,5315,1753,14587,11421,5877,19165,8506,21107,
2708,17365,15922,11389,9448,6972,19769,17908,13724,21753,
20984,14226,2664,16991,17714,13571,12271,15820,21181,6292,
11308,8854,18571,17157,17209,17770,8507,2108,9351,7073,
12334,13871,11101,18752,19120,5685,8722,20058,1309,15037,
12864,8953,9061,18939,15681,13532,13153,17727,4611,2308,
16323,2720,6333,3199,20064,9003,4320,9472,21377,13117,
1466,15125,12951,19371,8020,13100,2688,2844,10002,11041,
15741,6714,14842,18244,16385,6228,11267,8646,15315,10475,
9063,8115,9297,19730,2267,17029,16568,6834,4317,13520,
13617,6116,15731,13622,8618,21353,12035,12992,14874,12786,
14975,2136,4727,19859,11454,11163,4164,11108,5498,1585,
16600,6010,16383,9376,5101,14798,10208,10326,18441,14985,
4227,10038,10853,10648,17980,12057,16138,6230,11269,7970,
963,3917,19512,14087,8662,12931,14947,11640,3812,5979,
13947,14678,8765,13411,17437,20591,17797,20187,15627,3261,
5575,6279,19375,4009,10504,10925,9292,16298,17646,20030,
1334,15144,19778,2189,15882,1850,5980,7282,6263,8347,
4756,2170,16287,20995,14957,8348,6468,19685,15784,8938,
21458,10568,17715,13230,14452,5939,10569,18654,2790,20305,
8209,17303,4271,10814,12570,9512,12067,13948,2532,5239,
9565,15596,1733,21286,20718,15979,10183,21732,8328,2315,
19847,7369,5177,3817,15577,2298,10597,8737,10087,12277,
10447,9518,13017,12144,8362,11261,6534,16432,9921,7238,
20621,19092,6724,21164,7141,17873,6748,15561,18083,7586,
10124,6392,18084,13899,15108,16713,9147,16392,21434,8342,
2080,1190,16848,10940,6577,21228,12689,16857,15027,4026,
21416,12342,14482,5143,4601,3099,14423,5644,10407,14846,
17587,18224,11174,7664,15064,6625,17892,12169,7338,17990,
16660,10909,18389,13207,8732,14351,10821,19301,12599,9642,
13902,15301,6858,1477,17791,4969,15487,12077,11303,6632,
19303,17430,9240,2032,6340,10660,6594,9798,21179,18750,
10430,17967,5129,14822,14953,14196,14320,15925,2193,9175,
21733,12219,977,12278,17307,18149,21369,9452,854,8783,
15330,9054,4034,16521,2928,21524,20759,1348,11791,21636,
2965,15422,3910,12729,12936,21389,6991,19785,7914,5632,
10845,2273,15758,16918,9802,15578,5559,3262,14826,20663,
10448,11040,10449,6452,1659,5046,9164,8749,4551,16762,
11537,16300,6399,3563,17164,17165,6866,9851,4451,10981,
8575,18450,3609,9804,5835,17255,4081,16011,16414,16288,
5031,13848,7090,4348,8510,20665,15660,20344,6435,18486,
4105,17109,19641,8766,14479,6646,16479,5032,20532,2112,
13167,14545,6217,8983,11953,13078,15179,9567,3440,20406,
9743,13878,12585,1522,6030,21464,5990,17616,19322,19978,
4719,6061,1107,11143,5740,3477,11110,19528,2411,11846,
12880,12883,16804,9865,12889,6549,7441,7440,2977,18191,
16739,8086,20235,18782,4397,7235,8035,3328,6309,12082,
1886,9557,13387,17410,15683,13640,8965,16347,6583,10410,
2870,6627,13401,17094,1003,5453,15320,10137,17159,9971,
8327,17609,11205,15222,9110,7121,6759,16053,20957,8651,
20883,6948,4250,2176,16988,8319,2257,8033,11909,11090,
4909,1464,19811,2377,14901,4577,18246,16735,19701,1410,
13079,6297,15951,21624,6555,18714,11263,7523,4089,7516,
14960,8984,6381,17949,20606,7821,20666,1560,21050,21527,
17773,18655,10949,12029,865,5072,12938,10928,2113,3302,
1218,17111,9756,15284,8587,18584,18718,11898,16614,13825,
15510,15285,13021,5300,14916,2929,1863,12051,3273,1397,
14048,5178,21528,16699,19260,6677,15790,10162,8576,15250,
14138,15075,16302,5225,20722,20723,9293,19055,19905,15523,
11796,16968,7262,5266,10694,8350,15056,21691,15286,15287,
4759,16553,11489,10388,15288,11982,21680,16047,17777,5656,
18002,9805,14721,10766,11405,10623,7921,21540,5700,11850,
19563,14980,3278,21118,14174,13145,18195,13703,14730,9784,
7608,12424,2141,9554,12448,16195,17193,15255,3676,16433,
4281,8047,1655,7786,2263,1454,2174,11911,1024,19925,
15854,16794,5449,11329,12345,899,12434,2567,9500,18229,
13027,12412,2295,9389,20474,16902,14233,1512,11757,10674,
14853,5047,5042,4859,11903,21497,7761,8395,1222,20180,
14987,4988,21639,18924,11904,15343,17402,6457,12366,9483,
12697,8728,21366,1966,20962,16799,1036,10139,14227,1627,
3075,20460,7215,17339,14920,19544,21130,5243,16245,8921,
1534,16530,10165,3611,14036,21625,18838,10462,8767,13022,
3183,12656,2303,15472,10788,19385,2246,4760,8071,1644,
14827,10315,17801,3090,10234,20160,7530,2038,9529,17131,
16935,8635,14869,1388,20487,12897,2488,10467,6470,7094,
12591,6820,13023,12510,9987,14102,17802,17315,2489,9025,
14965,10167,11598,6651,12422,15226,4507,13112,13538,18489,
15473,17392,8471,7642,21744,9892,13169,9336,4139,17656,
20136,7007,7452,21053,3593,18153,19347,4118,8472,11899,
15705,12610,15822,15823,20499,3893,14246,8558,7453,4644,
15228,10390,8352,6823,19807,9762,20008,12248,14725,5140,
17567,4872,21135,4873,2823,3327,8834,6001,7587,5351,
17408,15631,10062,12774,4584,14283,5797,4215,14712,10178,
13593,16274,21493,8729,17329,15641,11201,6766,14935,1597,
5417,21379,11252,7937,20690,13903,5214,9496,18989,7353,
1692,12388,10778,9390,11322,14057,17545,9872,20294,7553,
12958,13076,6551,21699,18526,6977,2858,20111,19363,3877,
6937,16431,4653,11242,8408,8672,10212,3753,3334,12530,
11244,7239,4402,5400,17813,18160,6187,18549,10655,16980,
6690,9767,12703,19234,12702,6395,9040,18325,3100,16279,
21468,13085,12901,21472,9404,1541,15824,6562,17553,4207,
5871,2491,8337,4698,3304,19073,921,21609,18136,3819,
21292,6196,21394,7016,11691,6135,6924,13263,1710,19275,
9027,11838,17842,7534,7535,12961,2134,21023,11231,9541,
9407,7018,21695,8949,14276,12230,9139,4052,14918,2997,
10529,1652,1281,10391,17226,8888,10253,4356,10359,7536,
9232,1872,7394,18640,2218,17345,7537,16947,5664,2023,
11812,9438,3156,13502,12070,10633,21697,10553,20196,11814,
8486,15529,21220,9233,13985,18463,17706,1265,17711,10811,
18146,20953,17150,19675,12711,2272,2396,8198,10879,19615,
19927,17097,11610,904,15493,7913,6636,19248,3186,3081,
17969,20484,12584,1997,13484,10450,1528,20161,16609,16463,
20070,15549,16778,1613,12764,2098,10698,9593,12289,11196,
18594,13941,7398,2802,2497,3062,17397,4543,12003,21248,
11530,20922,20608,10211,8148,12468,10328,17078,17401,19462,
20886,16180,20799,10043,5430,3652,9601,16142,2464,8658,
9346,18143,13696,20930,20627,5678,12625,15873,9082,8151,
6479,6185,6755,7781,10533,8368,927,17852,4526,5549,
4900,8420,21550,15259,10057,2806,4679,4027,12974,20547,
20973,19237,6634,21516,1851,15522,13815,1386,10153,6556,
9136,2215,2283,2284,8140,1025,3852,8457,9901,11080,
10975,10700,14844,14209,6889,10976,18265,1460,5967,1461,
14188,8557,8650,1367,6254,13953,14039,17204,7492,7344,
11278,17066,14877,4006,20342,11616,20402,12186,17115,10077,
1599,1490,13954,6119,5615,5291,5260,4445,2840,6275,
5721,11282,14113,9073,9304,10477,15862,14156,8237,19970,
19971,2239,13523,10019,2274,14137,9074,18235,16578,18280,
4346,6841,19786,16579,6280,1231,6281,13525,18611,16581,
1168,944,16415,19129,9095,13632,10614,2923,9817,5862,
7484,3690,8197,3119,14448,11553,20321,9795,9239,7065,
12444,8260,13347,4096,2925,2451,10476,2125,8259,17993,
10914,19300,20651,4614,15322,15247,17594,5196,3178,5216,
14912,1693,13808,21178,17593,7912,13029,12645,2768,15496,
21182,6370,5131,19973,13279,16159,8455,13103,13214,10381,
21740,16907,8238,19898,9394,18282,10005,1879,2130,19482,
1001,11363,3129,14254,15742,20043,9788,12402,3379,7059,
1714,19028,13751,4298,5468,8675,10330,20889,18936,20677,
6330,9607,18546,14648,20936,13549,10402,20580,11726,16329,
9210,4022,13576,12241,15738,11797,15335,8577,6129,13634,
2904,5619,4012,12782,8959,15512,5621,12401,8621,17058,
6821,2247,12283,3499,6561,15337,16583,16584,5952,8563,
4018,6768,15321,6548,9368,17659,18890,20900,19087,18454,
3986,4291,14456,12134,5157,20036,20871,12286,2461,4295,
13428,3645,10110,16135,1737,4228,14729,4229,4374,5747,
19548,8517,13121,17707,2949,4997,17081,14208,14469,12564,
20703,17276,3514,12136,18950,4127,10581,19100,8189,2415,
10403,14471,17239,19105,21227,18473,13777,17091,2696,18378,
19106,19591,3602,16348,11774,4128,2986,21504,3121,10442,
9976,16496,7315,12993,7273,7113,7056,8595,3581,5084,
7431,20175,11970,10045,1921,1385,20306,12353,12556,5038,
9111,5136,6037,15401,5210,20272,17633,20010,5770,6084,
20140,10855,19707,2307,11695,12679,14495,18678,2339,18370,
6688,1888,5927,5757,17935,8974,903,11306,16089,18065,
18630,16938,11575,1341,14641,8928,18792,20935,21488,5060,
7933,20710,9170,13393,6962,15454,5020,2163,7149,16953,
3624,19618,5457,7950,13521,7466,7597,12446,10832,5503,
16749,5550,6959,8305,7340,12362,8661,13151,15258,1110,
959,7741,5064,18327,6697,20046,16797,15489,7171,3523,
995,17040,19188,13991,13704,9966,16060,3586,12314,15187,
19770,17250,4683,11687,4388,6992,3528,19195,20999,10262,
16936,9658,9665,6141,20812,18968,13203,12875,6543,5454,
8379,6341,20103,19629,2737,15181,5989,6909,14852,5655,
2797,20106,19384,7002,16929,10197,9526,11556,18027,20108,
7099,7100,11492,4810,14081,11466,4663,12076,20020,2660,
18448,953,11006,3764,3486,6337,3813,11478,2429,20343,
10083,12653,21110,6266,20409,19125,21290,16101,10088,3973,
19252,16810,10094,10095,6268,19130,5288,1878,10868,11430,
3202,7485,14018,14748,2314,10473,12604,13494,12415,3506,
17140,2860,3925,18199,19099,8727,20022,12557,2649,7669,
4028,3851,19514,19862,5854,19945,16652,13785,6606,8013,
13913,15374,5373,21397,11498,18542,12948,10213,3959,8549,
10329,7290,14439,21140,21775,5566,20676,13467,20804,8038,
5681,3963,18217,8870,13987,5885,12367,20706,11095,16096,
10611,3247,12101,16275,11759,7988,18225,4603,19607,21584,
3904,7487,3120,11561,11177,16217,4331,14816,2525,19352,
5290,10501,1715,15606,20991,20371,5534,11020,14059,14201,
10737,10738,20051,10196,11049,1707,16812,16531,9099,16969,
19060,3449,15620,19808,10235,3360,7095,12079,18491,16420,
16421,17059,7222,11050,11029,9408,9706,6925,890,4645,
3363,10254,10105,923,4765,9708,1259,6160,6161,6163,
1774,13244,15712,20650,2476,13296,8066,8069,15714,4588,
11180,1271,15759,6824,18721,3885,2124,7345,13766,3625,
4077,16798,13767,13208,11865,19189,13981,11512,11390,21690,
1181,19004,18625,15574,1133,7754,6260,12114,1754,19123,
5293,15576,7081,940,6171,5402,12832,15842,19354,15180,
15785,17998,8788,1379,15334,20498,9753,10018,19566,16856,
18746,14151,17644,16909,1616,13986,8308,15069,1634,1635,
14723,5450,5483,6380,4612,6983,9203,19569,12152,10834,
20393,7981,11680,10134,18868,18458,16430,4165,13050,14569,
6329,21258,17982,15353,18680,18470,16792,5930,10984,2334,
18383,6365,19751,16364,4097,1227,17936,1552,16077,10120,
10781,14265,20072,19010,19782,4495,15215,17256,8474,3169,
1612,3536,17897,16911,9592,6415,8077,6422,4586,14611,
14982,17142,20881,13436,6418,4886,21774,11056,20800,3010,
20631,15769,12704,2179,17037,21454,16997,13679,15588,15434,
1525,9096,9140,17615,1196,4365,13357,13358,6130,13136,
11480,7371,3610,11966,15555,15336,17551,12052,5303,1535,
9100,15474,10297,5791,13113,18009,7011,7390,7563,2258,
3305,6440,17263,12905,4053,16220,7395,9234,16390,13768,
4933,10965,13602,5294,16474,13133,5940,2327,9097,13856,
20083,14356,16482,5301,1136,15556,5426,20084,5205,1536,
16485,6825,4050,16221,4054,4890,8141,17160,17600,17168,
7004,20102,9381,12220,6650,19258,20086,12226,949,19131,
17372,6441,18676,3888,13285,8967,17384,14890,5907,17822,
18817,17825,5557,15053,8995,12712,4126,7271,6753,11920,
13757,18519,21565,13612,12877,11279,15595,12819,4132,10884,
10988,5185,11762,19698,3280,18018,11199,6940,5139,3478,
17809,2368,4167,18197,21431,1547,4734,4450,894,9617,
10215,20349,15907,3654,9112,16143,4896,17709,10809,17087,
13057,20387,3966,11586,5312,16662,12811,4129,1325,3905,
2438,21121,7807,3703,17995,1574,20589,5806,14045,13298,
13481,4154,3590,7560,1933,11024,1871,8592,20896,4946,
4976,17807,11167,8792,4158,11197,3369,14491,19829,18799,
15174,21569,2561,11419,9171,7417,3691,15261,18169,11706,
6009,19758,16259,1148,4174,3631,3385,12066,12538,10113,
2386,8065,9449,6123,13070,4339,4272,16475,7815,9091,
14427,18828,18829,8697,4116,1603,12457,9450,15808,7283,
15957,6800,8980,7284,10606,15883,2483,19344,19996,6379,
5985,8028,16062,16063,12436,9177,16064,21529,21530,2930,
3912,9178,15424,5986,12891,8699,3212,8103,13184,18833,
14006,15663,4275,4351,18283,16608,8611,19395,21315,18284,
17257,17672,18876,19934,14049,3726,3727,7579,8960,9456,
9337,12407,16227,10740,3149,18588,6062,13114,5562,18135,
18352,6827,2259,13888,11031,1711,15177,12348,13946,15083,
8978,10880,8694,11310,12403,2481,8619,9978,5538,15835,
1439,13591,15719,4523,20678,14324,16281,16052,4887,5168,
5505,9636,18330,12311,9241,9517,6997,20300,6095,5653,
8353,7872,5041,18847,12499,20520,9896,16021,2884,14176,
10974,2146,11916,1913,15375,8289,1162,12914,4545,8648,
3989,6877,1091,19716,20738,5508,8678,12520,1887,1824,
19960,11463,15437,3754,14904,14650,17986,15298,1453,11652,
12262,4194,8660,9349,4403,19507,2516,7275,11587,18651,
2470,3808,19104,8564,21173,15877,3915,6459,13556,5876,
17264,12442,10360,10008,11813,13586,15879,8094,12541,19337,
19394,9455,4735,3916,5571,4927,17069,20437,1626,13993,
1086,15360,9939,5576,17999,14300,8330,1637,14963,16483,
18488,18586,15077,8578,14061,4471,10166,16971,10198,12396,
12397,10169,1647,1648,1649,9894,1650,14104,4766,17778,
18464,20425,14940,18572,10142,4579,4473,4599,14565,1965,
6951,3900,14997,16128,20397,16098,13769,19746,8382,2654,
19190,4531,4532,15237,19187,21280,18819,21782,1491,7834,
15550,1248,3026,15828,15007,1249,14672,4241,5895,13771,
15755,7679,7281,1755,18573,15923,14128,15803,20746,14080,
2706,15463,958,13867,9325,9162,15594,8762,20304,9560,
5234,4266,3258,10564,10179,8556,7421,9285,13227,8202,
853,13008,11947,1347,3559,8733,9043,5556,6864,12140,
8360,15411,21512,13161,8574,14948,4335,2109,15071,6547,
864,10312,13015,4636,10923,11397,5292,8349,11488,10147,
19015,7258,1698,1633,15470,10784,10619,19381,21679,17997,
3607,2199,8460,12588,10383,4135,9209,12607,3152,13019,
3591,6912,21467,19056,2133,1646,21046,14418,3241,20974,
1415,21546,11374,14765,10495,6956,4835,9284,8687,13733,
3027,17366,18510,8385,4406,9387,16898,1799,11629,4341,
1891,8535,4010,15145,19630,16905,18580,6847,5870,14685,
7517,21390,1756,17308,1928,18709,3442,4594,20485,16522,
5633,4347,11931,20081,6382,6647,6807,7372,6298,914,
15509,4665,16526,5535,2114,15055,15511,1864,5203,17055,
9021,10163,15076,15581,18719,16554,11344,15513,10752,1530,
19803,17776,7916,14037,9026,21336,14247,2672,3450,19071,
7008,13700,2490,16534,17373,20416,4666,5899,11030,18425,
11351,2219,17374,10634,20170,11573,3896,16112,4230,6090,
9386,16838,3999,8523,5861,5520,20691,7184,14094,11721,
5035,13681,5704,7659,6048,16886,12515,3831,6423,19398,
8112,19824,1241,20704,5472,3927,10332,13472,2559,14931,
4383,20954,5567,17765,10534,1833,9491,5521,19748,17205,
15644,16755,11192,937,1291,2960,6369,4336,3023,10924,
16807,18627,7365,19254,20615,10194,9882,7638,8164,19794,
6437,10459,5662,11619,3879,7734,9595,14217,9602,19463,
5105,8676,3401,20365,12120,21260,17961,7243,18179,18803,
20960,9324,16796,3239,17202,14129,21206,4635,5554,16460,
19681,19555,3380,9123,19000,6290,2159,10311,7302,14070,
18693,1839,4682,1847,11684,1503,1854,16010,5911,4595,
7373,945,918,17170,19997,4699,12428,17653,10687,19747,
4774,5973,3699,16153,16129,2607,18096,21281,20822,12159,
17670,13783,13992,20049,16573,20851,3405,10478,19486,1848,
1251,8440,16155,19005,13448,12567,13452,8080,12523,20530,
19846,12189,21151,8316,21287,11906,8210,12274,20181,7313,
10084,20692,15346,5026,18511,14608,1509,16157,16158,15009,
10148,10709,12375,15579,21000,13820,15610,3972,18060,13536,
14401,8081,4407,5896,1855,21185,19126,10663,21111,3443,
5897,10156,8240,15046,13185,10815,2666,11394,1149,7076,
6640,1632,10642,19342,20390,10225,19194,2712,1153,9179,
19051,3771,12339,3728,13497,18959,15040,16830,13309,21398,
1570,18602,15797,4007,8688,19621,18055,8314,19684,18730,
2131,11500,13756,7880,10956,12063,3453,7248,5252,8752,
9722,2524,9769,7419,1656,2809,15693,1486,8203,4190,
3269,1330,1250,10503,1576,9201,2634,20605,13048,13883,
12069,18173,17810,8498,3216,7877,9415,21547,2362,14999,
6863,9359,15520,11990,10288,7576,11895,11410,3844,3882,
3374,10065,11824,5826,9015,1010,15408,5903,12684,6005,
9294,5987,16012,17950,16081,8538,4284,2549,17693,15012,
10458,21370,21116,14357,12376,9057,15582,9165,21602,8739,
12738,12739,18408,4596,14062,18409,5304,18612,16815,12383,
3091,12384,12942,4597,6652,12940,6869,19648,15666,13537,
17113,21604,8985,13851,14964,5578,16163,5735,15078,12900,
2541,21015,10168,12228,15614,16972,2044,4045,18417,19908,
21655,14063,14248,12751,21019,14856,10468,16973,10626,20488,
11407,1046,1973,1651,3092,13461,1542,21020,19810,17841,
6471,1802,15154,17462,9989,20467,4157,10172,16165,2087,
3773,7643,15825,18426,10635,20418,7794,6109,19336,8684,
5972,4340,21311,11792,10739,14047,6060,13886,12441,6320,
12916,13374,7107,2156,6686,5310,10996,4898,12296,13942,
17238,6017,7856,5377,3991,19182,2558,5905,5476,6104,
9629,19474,13657,20366,13344,10068,2469,19536,13320,7277,
11589,20961,14936,13444,15859,9087,12705,7619,18477,10839,
14450,20562,14296,16721,9499,2782,4923,13007,13259,12722,
16895,19767,4591,5867,5834,19003,12313,15783,13570,16236,
9290,11039,2942,13813,11562,4936,8979,8696,5024,15073,
19627,19488,10289,13410,1557,10843,13217,1011,10763,10822,
8003,19078,18722,16131,12429,21158,18431,10255,10485,15619,
17346,7226,14862,8249,16976,6529,9544,1653,13779,19096,
1617,17678,13176,21577,15116,8972,14854,16446,16454,16455,
19609,5146,18981,980,1272,1332,3005,15673,13071,8858,
16074,5357,12373,19644,15191,1867,17455,12096,1868,3235,
11348,9893,10298,17459,20178,15675,1723,8889,10361,5192,
13128,8652,13118,9338,14073,9041,3627,4573,17771,13659,
3435,9050,1716,4429,12275,4455,15697,1274,1510,10844,
4937,4389,13821,13454,5389,9092,12221,21297,14301,15271,
15700,9666,1718,15703,12224,15035,10680,19901,16916,2574,
15503,12087,14687,6645,2037,12394,15506,16923,17391,21049,
20486,14840,10846,12223,6813,12049,14242,6918,11042,2205,
9759,11229,9536,4083,13501,4805,19244,13301,17129,14647,
21197,19577,7044,4059,6950,7405,20544,21549,6419,13313,
12521,3288,14472,20240,5434,9625,14998,15778,7245,1548,
2562,8808,1470,17241,18269,13559,20749,8502,14666,5183,
12008,14294,17474,13295,20248,13159,21283,13970,12930,16185,
1498,3382,8780,19843,17431,20658,9014,6637,6293,5423,
4618,9657,1514,2612,15150,11227,3982,10451,4104,5763,
20760,21605,14896,7447,4223,6384,9133,12750,9761,20696,
12229,10711,14023,10754,10755,14112,17843,9947,12902,12903,
11570,9101,11839,1724,13683,4000,4008,11617,6282,17056,
4014,5947,4015,4016,8125,19818,19819,18404,4974,17655,
5734,21606,10199,5737,14269,10962,12713,12714,5050,17829,
19793,16065,12655,9838,5117,12398,1539,12752,17840,2759,
18356,20419,19594,3510,13723,7804,1070,6261,16130,3632,
7116,19631,4274,13162,14135,5994,16100,11398,7866,14428,
1167,19896,12315,10379,16574,6375,10338,20097,4559,4687,
11513,19489,12382,11337,6127,17107,3772,20134,3576,1876,
9183,21155,19571,19578,2683,17032,11770,11922,2865,14181,
18854,1420,21040,1164,4571,5307,10334,21205,20241,16879,
14295,16462,11038,14704,2036,2691,11026,13175,11750,7247,
13405,14132,1532,3601,13042,15263,7812,15467,16915,17146,
11092,1063,9627,15802,16876,21502,1992,9964,21632,14028,
6294,20133,3024,17860,13844,13420,7600,5323,7173,18934,
10064,16877,21284,4615,7434,12364,6125,19046,11107,20846,
12718,12778,18581,3553,4834,13459,8114,8200,9937,21511,
20147,11557,20604,7544,2628,3883,5106,21144,18802,5482,
13455,5912,12279,10089,16160,1102,13413,12495,4942,1520,
7201,16523,8211,3791,1856,19491,5810,12317,11718,17690,
15362,1276,5029,20354,8321,5490,14590,3936,3352,15309,
7822,14759,6316,17370,4390,946,16416,20558,21186,19216,
9941,10664,15935,18834,19050,1773,16480,7636,8828,5730,
17169,5298,6734,9354,4945,8665,17774,4206,8511,15664,
11179,14302,20355,15272,13186,19645,11630,20597,5811,5358,
15096,16725,13415,14202,12572,6602,15789,9569,14139,14140,
8666,11025,2538,9527,21659,16930,19427,14403,21531,12742,
13262,17371,11631,2966,7216,3795,3133,16151,17152,11317,
20897,18395,14537,2531,16009,9447,9053,12133,6378,15657,
17861,5889,15508,9335,1893,7729,16934,8335,9571,18073,
14598,3244,4159,13304,18021,3145,1679,1264,15297,7412,
4832,13000,20847,4836,14189,9637,16150,7253,1874,15356,
8994,13061,1487,17247,17151,6967,7620,9823,7180,2975,
6503,2610,20994,3743,1849,20855,7510,3861,2857,21066,
8266,4205,3233,12374,13846,11793,12047,12654,2799,8465,
12609,4503,3147,21210,10023,2214,9946,21694,17625,20906,
3785,11388,17767,11402,12320,6354,8424,14257,5478,21508,
13168,5561,21129,3938,9166,4598,11667,19061,9058,10463,
8165,2276,7998,10598,10099,21653,9530,11043,21607,21016,
11722,6400,19649,3662,14546,14405,6603,15667,6299,17695,
21193,9137,21608,7205,1564,1565,6604,13581,20281,16375,
16376,19650,2946,13852,3865,6653,9807,18344,13360,13361,
7448,1399,4353,18490,5036,14007,7383,17072,16178,6385,
14693,13973,17957,16555,7387,6063,16700,12091,14064,10170,
10696,14594,14547,5622,21534,15616,15312,18589,5305,19396,
12945,12753,16556,13974,14410,9763,1017,9385,6716,11290,
7223,15792,13462,7391,14406,10756,5384,15136,20992,21555,
13289,8057,19593,9638,16570,15863,7181,12161,4592,14157,
19173,889,17316,10717,2448,8262,1228,15781,21517,19166,
19686,2991,16670,11164,19878,16164,21364,15244,8371,8204,
10662,8331,2743,13305,10537,16808,20153,11424,1045,10161,
1338,17652,19480,4558,1100,12489,11717,10337,15093,5017,
6314,15357,5722,7810,16468,4387,7182,7624,17367,18098,
5356,9513,9742,7363,14589,15787,5809,14136,6597,7186,
13261,10090,21652,4593,9055,2275,5560,11666,11719,3792,
14543,21526,4718,3862,4349,13355,5033,6648,1561,14060,
16975,13418,1664,7224,7220,21211,7564,13363,21316,19390,
20489,8636,18035,1667,19813,13463,17393,1803,7700,18109,
15155,6654,21746,14251,14252,4474,5792,9991,18110,11195,
17005,20303,17344,4720,5624,6317,8883,20282,14065,20420,
5135,5793,14489,9574,2304,9410,14791,922,13889,7225,
17916,6442,14793,9707,9949,10668,11232,20668,17375,4358,
10362,5666,9545,17181,3509,7111,16099,1069,6117,19484,
20351,1840,12310,8663,15924,20279,6315,8873,20352,8508,
19425,12730,14402,1396,2302,15661,16552,16372,13577,7558,
12088,7377,16532,16970,6439,5134,1015,12740,15310,5620,
18585,9384,1663,18034,10753,11288,19386,5790,14249,21745,
9572,3296,18449,3298,13102,10751,7376,8214,13849,5425,
1337,7862,15955,8827,5493,3661,6296,5295,8700,1526,
10296,12841,8887,1721,4051,10966,1087,18336,9837,17442,
16335,2578,17363,18398,15829,15557,19389,1618,9044,10842,
13661,15786,7194,21525,17772,13578,8124,1722,6563,9948,
11335,6712,11068,7115,8509,21235,11070,12745,1016,14361,
9990,3356,2849,19516,17112,18762,13460,4046,9532,13280,
1989,978,4693,19542,16726,18357,16943,13414,5913,20330,
20417,5635,11751,18867,4928,9646,8121,1900,18390,4891,
3787,6968,4792,13905,5114,14538,4793,11309,1252,19844,
20823,6433,13212,4845,4688,16575,7364,14541,19779,4811,
18537,8451,8452,12336,6519,20721,1254,18399,18148,20784,
4552,4794,16576,11978,3353,5261,13874,10091,11223,4938,
16161,11262,9659,1578,21001,5262,19848,3031,13483,17443,
2575,3444,8212,18610,5491,21048,19787,18451,19788,18150,
15821,19789,15736,19253,4117,16698,4391,5577,915,20825,
18406,6193,17450,7285,9942,21187,18487,15662,6269,10453,
13880,11425,5265,13725,7637,17775,22349,22350,22351,22352,
22353,22354,22355,22356,22357,22358,22359,22360,22361,22362,
22363,22364,22365,22366,22367,22368,22369,22370,22371,22372,
22373,22374,22375,22376,22377,22378,22379,22380,22381,22382,
22383,22384,22385,22386,22387,22388,22389,22390,22391,22392,
22393,22394,22395,22396,22397,22398,22399,22400,22401,22402,
22403,22404,22405,22406,22407,22408,22409,22410,22411,22412,
22413,22414,22415,22416,22417,22418,22419,22420,22421,22422,
22423,22424,22425,22426,22427,22428,22429,22430,22431,22432,
22433,22434,22435,22436,22437,22438,22439,22440,22441,22442,
21115,2576,10665,6194,11720,4285,10538,7286,7206,16013,
6521,16177,1902,16724,8351,19801,1865,8539,8540,1398,
16931,8541,8241,15980,7997,15665,4276,4277,8915,5539,
16766,14404,9180,7693,12068,10464,12323,14763,4948,948,
21469,12227,13416,12898,1293,3796,10465,13635,7381,8243,
16029,18152,19850,12743,9531,18720,21371,8784,4246,9059,
14481,12744,7999,19062,19063,8000,21532,9167,3939,12657,
2967,5345,8215,8467,19064,21743,7005,14828,14829,2673,
11194,13853,950,13362,15668,6386,15669,4354,7758,10847,
4949,2947,16014,18345,6133,19909,22443,22444,22445,22446,
22447,22448,22449,22450,22451,22452,22453,22454,22455,22456,
22457,22458,22459,22460,22461,22462,22463,22464,22465,22466,
22467,22468,22469,22470,22471,22472,22473,22474,22475,22476,
22477,22478,22479,22480,22481,22482,22483,22484,22485,22486,
22487,22488,22489,22490,22491,22492,22493,22494,22495,22496,
22497,22498,22499,22500,22501,22502,22503,22504,22505,22506,
22507,22508,22509,22510,22511,22512,22513,22514,22515,22516,
22517,22518,22519,22520,22521,22522,22523,22524,22525,22526,
22527,22528,22529,22530,22531,22532,22533,22534,22535,22536,
12365,9060,10932,6387,19262,2887,16816,8246,3940,2018,
4574,6388,19274,19910,17177,16615,14548,6158,2800,15514,
17114,13975,10171,7096,5494,7388,15251,5992,3035,3036,
19074,18638,18418,7012,9695,15739,8814,15628,15629,19075,
16015,10695,17460,5206,15740,2435,7097,16049,20617,1018,
18614,18764,11983,2674,21022,10200,19391,10484,1543,14859,
21474,19651,16727,8480,19176,15433,14966,7644,19079,6472,
1544,19278,15156,6655,4509,7645,9895,18427,5208,8169,
17227,17228,16016,10723,21747,19814,19280,10472,16050,17229,
18028,19081,12356,14792,10631,16945,22537,22538,22539,22540,
22541,22542,22543,22544,22545,22546,22547,22548,22549,22550,
22551,22552,22553,22554,22555,22556,22557,22558,22559,22560,
22561,22562,22563,22564,22565,22566,22567,22568,22569,22570,
22571,22572,22573,22574,22575,22576,22577,22578,22579,22580,
22581,22582,22583,22584,22585,22586,22587,22588,22589,22590,
22591,22592,22593,22594,22595,22596,22597,22598,22599,22600,
22601,22602,22603,22604,22605,22606,22607,22608,22609,22610,
22611,22612,22613,22614,22615,22616,22617,22618,22619,22620,
22621,22622,22623,22624,22625,22626,22627,22628,22629,22630,
18842,7021,20267,19652,20421,18723,18492,12357,11840,6443,
11083,19281,11032,3640,19985,19815,9439,1903,10363,6162,
10256,14863,19988,19282,5665,13503,9546,10556,14518,2005,
17411,10053,18020,6189,21102,16718,9045,12881,5339,19842,
15130,6120,13349,19016,16612,10149,7082,19017,18757,6557,
20413,11027,14860,10370,7892,10092,7449,17223,3245,7454,
7457,18298,19440,3125,1631,3126,12116,21291,7374,11069,
19691,10164,2433,8512,9983,11668,8166,8513,8001,9682,
17340,18290,7263,11074,9696,20490,8004,12755,10108,18299,
3127,10732,6121,2358,4846,11183,22631,22632,22633,22634,
22635,22636,22637,22638,22639,22640,22641,22642,22643,22644,
22645,22646,22647,22648,22649,22650,22651,22652,22653,22654,
22655,22656,22657,22658,22659,22660,22661,22662,22663,22664,
22665,22666,22667,22668,22669,22670,22671,22672,22673,22674,
22675,22676,22677,22678,22679,22680,22681,22682,22683,22684,
22685,22686,22687,22688,22689,22690,22691,22692,22693,22694,
22695,22696,22697,22698,22699,22700,22701,22702,22703,22704,
22705,22706,22707,22708,22709,22710,22711,22712,22713,22714,
22715,22716,22717,22718,22719,22720,22721,22722,22723,22724,
11184,4848,12124,13524,13457,11426,4849,17310,9168,11186,
2581,4767,13453,11185,11334,11354,21654,11933,4700,6616,
7893,5686,15713,15963,6494,8941,6270,2583,6164,19018,
3408,17051,16090,11399,12939,3744,18341,10950,18346,19980,
3469,18240,18350,18351,20724,20697,3362,1990,18765,10934,
20444,18359,4055,10364,4703,11281,19904,3146,13528,2352,
16206,21192,20828,11044,1019,1668,16166,1545,2344,11133,
3891,21519,5525,3937,4695,19852,2277,5207,2048,19853,
15475,15599,14778,4641,16582,1089,3794,16162,21051,13487,
14480,14591,14593,15867,8247,8002,22725,22726,22727,22728,
22729,22730,22731,22732,22733,22734,22735,22736,22737,22738,
22739,22740,22741,22742,22743,22744,22745,22746,22747,22748,
22749,22750,22751,22752,22753,22754,22755,22756,22757,22758,
22759,22760,22761,22762,22763,22764,22765,22766,22767,22768,
22769,22770,22771,22772,22773,22774,22775,22776,22777,22778,
22779,22780,22781,22782,22783,22784,22785,22786,22787,22788,
22789,22790,22791,22792,22793,22794,22795,22796,22797,22798,
22799,22800,22801,22802,22803,22804,22805,22806,22807,22808,
22809,22810,22811,22812,22813,22814,22815,22816,22817,22818,
6850,8248,18353,15981,14967,17317,9413,18629,16811,16813,
6283,17622,6159,17803,16629,20331,11890,11579,12723,20381,
7207,21533,7013,7019,2635,2453,2454,6131,18172,19174,
17620,1233,20265,14694,21535,2579,18347,8269,15791,10102,
10096,2770,13583,17621,19175,11804,8168,18613,2996,20052,
19693,2815,18878,11669,20266,2998,13512,20053,18358,11984,
4357,16671,19083,3246,21656,3733,2816,7965,18211,6105,
19157,10228,12089,5391,12090,18348,10245,10250,5392,8596,
3306,10109,3307,5731,13364,1670,2914,6136,8483,17557,
19987,9271,9814,5122,9564,9967,22819,22820,22821,22822,
22823,22824,22825,22826,22827,22828,22829,22830,22831,22832,
22833,22834,22835,22836,22837,22838,22839,22840,22841,22842,
22843,22844,22845,22846,22847,22848,22849,22850,22851,22852,
22853,22854,22855,22856,22857,22858,22859,22860,22861,22862,
22863,22864,22865,22866,22867,22868,22869,22870,22871,22872,
22873,22874,22875,22876,22877,22878,22879,22880,22881,22882,
22883,22884,22885,22886,22887,22888,22889,22890,22891,22892,
22893,22894,22895,22896,22897,22898,22899,22900,22901,22902,
22903,22904,22905,22906,22907,22908,22909,22910,22911,22912,
16769,6900,14850,19718,12706,4918,8263,9548,886,5739,
14473,3992,7037,17500,17731,3521,23854,23855,23856,23857,
23858,23859,23860,23861,23862,23863,23864,23865,23866,23867,
23868,23869,23870,23871,23872,23873,23874,23875,23876,23877,
23878,23879,23880,23881,23882,23883,23884,23885,23886,23887,
23888,23889,23890,23891,23892,23893,23894,23895,23896,23897,
23898,23899,23900,23901,23902,23903,23904,23905,23906,23907,
23908,23909,23910,23911,23912,23913,23914,23915,23916,23917,
23918,23919,23920,23921,23922,23923,23924,23925,23926,23927,
23928,23929,23930,23931,23932,23933,22913,22914,22915,22916,
22917,22918,22919,22920,22921,22922,22923,22924,22925,22926,
22927,22928,22929,22930,22931,22932,22933,22934,22935,22936,
22937,22938,22939,22940,22941,22942,22943,22944,22945,22946,
22947,22948,22949,22950,22951,22952,22953,22954,22955,22956,
22957,22958,22959,22960,22961,22962,22963,22964,22965,22966,
22967,22968,22969,22970,22971,22972,22973,22974,22975,22976,
22977,22978,22979,22980,22981,22982,22983,22984,22985,22986,
22987,22988,22989,22990,22991,22992,22993,22994,22995,22996,
22997,22998,22999,23000,23001,23002,23003,23004,23005,23006
};

static uint16 gbksortorder(uint16 i)
{
  uint idx=gbktail(i);
  if (idx>0x7f) idx-=0x41;
  else idx-=0x40;
  idx+=(gbkhead(i)-0x81)*0xbe;
  return 0x8100+gbk_order[idx];
}


/* page 0 0x8140-0xFE4F */
static const uint16 tab_gbk_uni0[]={
0x4E02,0x4E04,0x4E05,0x4E06,0x4E0F,0x4E12,0x4E17,0x4E1F,
0x4E20,0x4E21,0x4E23,0x4E26,0x4E29,0x4E2E,0x4E2F,0x4E31,
0x4E33,0x4E35,0x4E37,0x4E3C,0x4E40,0x4E41,0x4E42,0x4E44,
0x4E46,0x4E4A,0x4E51,0x4E55,0x4E57,0x4E5A,0x4E5B,0x4E62,
0x4E63,0x4E64,0x4E65,0x4E67,0x4E68,0x4E6A,0x4E6B,0x4E6C,
0x4E6D,0x4E6E,0x4E6F,0x4E72,0x4E74,0x4E75,0x4E76,0x4E77,
0x4E78,0x4E79,0x4E7A,0x4E7B,0x4E7C,0x4E7D,0x4E7F,0x4E80,
0x4E81,0x4E82,0x4E83,0x4E84,0x4E85,0x4E87,0x4E8A,     0,
0x4E90,0x4E96,0x4E97,0x4E99,0x4E9C,0x4E9D,0x4E9E,0x4EA3,
0x4EAA,0x4EAF,0x4EB0,0x4EB1,0x4EB4,0x4EB6,0x4EB7,0x4EB8,
0x4EB9,0x4EBC,0x4EBD,0x4EBE,0x4EC8,0x4ECC,0x4ECF,0x4ED0,
0x4ED2,0x4EDA,0x4EDB,0x4EDC,0x4EE0,0x4EE2,0x4EE6,0x4EE7,
0x4EE9,0x4EED,0x4EEE,0x4EEF,0x4EF1,0x4EF4,0x4EF8,0x4EF9,
0x4EFA,0x4EFC,0x4EFE,0x4F00,0x4F02,0x4F03,0x4F04,0x4F05,
0x4F06,0x4F07,0x4F08,0x4F0B,0x4F0C,0x4F12,0x4F13,0x4F14,
0x4F15,0x4F16,0x4F1C,0x4F1D,0x4F21,0x4F23,0x4F28,0x4F29,
0x4F2C,0x4F2D,0x4F2E,0x4F31,0x4F33,0x4F35,0x4F37,0x4F39,
0x4F3B,0x4F3E,0x4F3F,0x4F40,0x4F41,0x4F42,0x4F44,0x4F45,
0x4F47,0x4F48,0x4F49,0x4F4A,0x4F4B,0x4F4C,0x4F52,0x4F54,
0x4F56,0x4F61,0x4F62,0x4F66,0x4F68,0x4F6A,0x4F6B,0x4F6D,
0x4F6E,0x4F71,0x4F72,0x4F75,0x4F77,0x4F78,0x4F79,0x4F7A,
0x4F7D,0x4F80,0x4F81,0x4F82,0x4F85,0x4F86,0x4F87,0x4F8A,
0x4F8C,0x4F8E,0x4F90,0x4F92,0x4F93,0x4F95,0x4F96,0x4F98,
0x4F99,0x4F9A,0x4F9C,0x4F9E,0x4F9F,0x4FA1,0x4FA2,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x4FA4,0x4FAB,0x4FAD,0x4FB0,0x4FB1,0x4FB2,0x4FB3,0x4FB4,
0x4FB6,0x4FB7,0x4FB8,0x4FB9,0x4FBA,0x4FBB,0x4FBC,0x4FBD,
0x4FBE,0x4FC0,0x4FC1,0x4FC2,0x4FC6,0x4FC7,0x4FC8,0x4FC9,
0x4FCB,0x4FCC,0x4FCD,0x4FD2,0x4FD3,0x4FD4,0x4FD5,0x4FD6,
0x4FD9,0x4FDB,0x4FE0,0x4FE2,0x4FE4,0x4FE5,0x4FE7,0x4FEB,
0x4FEC,0x4FF0,0x4FF2,0x4FF4,0x4FF5,0x4FF6,0x4FF7,0x4FF9,
0x4FFB,0x4FFC,0x4FFD,0x4FFF,0x5000,0x5001,0x5002,0x5003,
0x5004,0x5005,0x5006,0x5007,0x5008,0x5009,0x500A,     0,
0x500B,0x500E,0x5010,0x5011,0x5013,0x5015,0x5016,0x5017,
0x501B,0x501D,0x501E,0x5020,0x5022,0x5023,0x5024,0x5027,
0x502B,0x502F,0x5030,0x5031,0x5032,0x5033,0x5034,0x5035,
0x5036,0x5037,0x5038,0x5039,0x503B,0x503D,0x503F,0x5040,
0x5041,0x5042,0x5044,0x5045,0x5046,0x5049,0x504A,0x504B,
0x504D,0x5050,0x5051,0x5052,0x5053,0x5054,0x5056,0x5057,
0x5058,0x5059,0x505B,0x505D,0x505E,0x505F,0x5060,0x5061,
0x5062,0x5063,0x5064,0x5066,0x5067,0x5068,0x5069,0x506A,
0x506B,0x506D,0x506E,0x506F,0x5070,0x5071,0x5072,0x5073,
0x5074,0x5075,0x5078,0x5079,0x507A,0x507C,0x507D,0x5081,
0x5082,0x5083,0x5084,0x5086,0x5087,0x5089,0x508A,0x508B,
0x508C,0x508E,0x508F,0x5090,0x5091,0x5092,0x5093,0x5094,
0x5095,0x5096,0x5097,0x5098,0x5099,0x509A,0x509B,0x509C,
0x509D,0x509E,0x509F,0x50A0,0x50A1,0x50A2,0x50A4,0x50A6,
0x50AA,0x50AB,0x50AD,0x50AE,0x50AF,0x50B0,0x50B1,0x50B3,
0x50B4,0x50B5,0x50B6,0x50B7,0x50B8,0x50B9,0x50BC,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x50BD,0x50BE,0x50BF,0x50C0,0x50C1,0x50C2,0x50C3,0x50C4,
0x50C5,0x50C6,0x50C7,0x50C8,0x50C9,0x50CA,0x50CB,0x50CC,
0x50CD,0x50CE,0x50D0,0x50D1,0x50D2,0x50D3,0x50D4,0x50D5,
0x50D7,0x50D8,0x50D9,0x50DB,0x50DC,0x50DD,0x50DE,0x50DF,
0x50E0,0x50E1,0x50E2,0x50E3,0x50E4,0x50E5,0x50E8,0x50E9,
0x50EA,0x50EB,0x50EF,0x50F0,0x50F1,0x50F2,0x50F4,0x50F6,
0x50F7,0x50F8,0x50F9,0x50FA,0x50FC,0x50FD,0x50FE,0x50FF,
0x5100,0x5101,0x5102,0x5103,0x5104,0x5105,0x5108,     0,
0x5109,0x510A,0x510C,0x510D,0x510E,0x510F,0x5110,0x5111,
0x5113,0x5114,0x5115,0x5116,0x5117,0x5118,0x5119,0x511A,
0x511B,0x511C,0x511D,0x511E,0x511F,0x5120,0x5122,0x5123,
0x5124,0x5125,0x5126,0x5127,0x5128,0x5129,0x512A,0x512B,
0x512C,0x512D,0x512E,0x512F,0x5130,0x5131,0x5132,0x5133,
0x5134,0x5135,0x5136,0x5137,0x5138,0x5139,0x513A,0x513B,
0x513C,0x513D,0x513E,0x5142,0x5147,0x514A,0x514C,0x514E,
0x514F,0x5150,0x5152,0x5153,0x5157,0x5158,0x5159,0x515B,
0x515D,0x515E,0x515F,0x5160,0x5161,0x5163,0x5164,0x5166,
0x5167,0x5169,0x516A,0x516F,0x5172,0x517A,0x517E,0x517F,
0x5183,0x5184,0x5186,0x5187,0x518A,0x518B,0x518E,0x518F,
0x5190,0x5191,0x5193,0x5194,0x5198,0x519A,0x519D,0x519E,
0x519F,0x51A1,0x51A3,0x51A6,0x51A7,0x51A8,0x51A9,0x51AA,
0x51AD,0x51AE,0x51B4,0x51B8,0x51B9,0x51BA,0x51BE,0x51BF,
0x51C1,0x51C2,0x51C3,0x51C5,0x51C8,0x51CA,0x51CD,0x51CE,
0x51D0,0x51D2,0x51D3,0x51D4,0x51D5,0x51D6,0x51D7,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x51D8,0x51D9,0x51DA,0x51DC,0x51DE,0x51DF,0x51E2,0x51E3,
0x51E5,0x51E6,0x51E7,0x51E8,0x51E9,0x51EA,0x51EC,0x51EE,
0x51F1,0x51F2,0x51F4,0x51F7,0x51FE,0x5204,0x5205,0x5209,
0x520B,0x520C,0x520F,0x5210,0x5213,0x5214,0x5215,0x521C,
0x521E,0x521F,0x5221,0x5222,0x5223,0x5225,0x5226,0x5227,
0x522A,0x522C,0x522F,0x5231,0x5232,0x5234,0x5235,0x523C,
0x523E,0x5244,0x5245,0x5246,0x5247,0x5248,0x5249,0x524B,
0x524E,0x524F,0x5252,0x5253,0x5255,0x5257,0x5258,     0,
0x5259,0x525A,0x525B,0x525D,0x525F,0x5260,0x5262,0x5263,
0x5264,0x5266,0x5268,0x526B,0x526C,0x526D,0x526E,0x5270,
0x5271,0x5273,0x5274,0x5275,0x5276,0x5277,0x5278,0x5279,
0x527A,0x527B,0x527C,0x527E,0x5280,0x5283,0x5284,0x5285,
0x5286,0x5287,0x5289,0x528A,0x528B,0x528C,0x528D,0x528E,
0x528F,0x5291,0x5292,0x5294,0x5295,0x5296,0x5297,0x5298,
0x5299,0x529A,0x529C,0x52A4,0x52A5,0x52A6,0x52A7,0x52AE,
0x52AF,0x52B0,0x52B4,0x52B5,0x52B6,0x52B7,0x52B8,0x52B9,
0x52BA,0x52BB,0x52BC,0x52BD,0x52C0,0x52C1,0x52C2,0x52C4,
0x52C5,0x52C6,0x52C8,0x52CA,0x52CC,0x52CD,0x52CE,0x52CF,
0x52D1,0x52D3,0x52D4,0x52D5,0x52D7,0x52D9,0x52DA,0x52DB,
0x52DC,0x52DD,0x52DE,0x52E0,0x52E1,0x52E2,0x52E3,0x52E5,
0x52E6,0x52E7,0x52E8,0x52E9,0x52EA,0x52EB,0x52EC,0x52ED,
0x52EE,0x52EF,0x52F1,0x52F2,0x52F3,0x52F4,0x52F5,0x52F6,
0x52F7,0x52F8,0x52FB,0x52FC,0x52FD,0x5301,0x5302,0x5303,
0x5304,0x5307,0x5309,0x530A,0x530B,0x530C,0x530E,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5311,0x5312,0x5313,0x5314,0x5318,0x531B,0x531C,0x531E,
0x531F,0x5322,0x5324,0x5325,0x5327,0x5328,0x5329,0x532B,
0x532C,0x532D,0x532F,0x5330,0x5331,0x5332,0x5333,0x5334,
0x5335,0x5336,0x5337,0x5338,0x533C,0x533D,0x5340,0x5342,
0x5344,0x5346,0x534B,0x534C,0x534D,0x5350,0x5354,0x5358,
0x5359,0x535B,0x535D,0x5365,0x5368,0x536A,0x536C,0x536D,
0x5372,0x5376,0x5379,0x537B,0x537C,0x537D,0x537E,0x5380,
0x5381,0x5383,0x5387,0x5388,0x538A,0x538E,0x538F,     0,
0x5390,0x5391,0x5392,0x5393,0x5394,0x5396,0x5397,0x5399,
0x539B,0x539C,0x539E,0x53A0,0x53A1,0x53A4,0x53A7,0x53AA,
0x53AB,0x53AC,0x53AD,0x53AF,0x53B0,0x53B1,0x53B2,0x53B3,
0x53B4,0x53B5,0x53B7,0x53B8,0x53B9,0x53BA,0x53BC,0x53BD,
0x53BE,0x53C0,0x53C3,0x53C4,0x53C5,0x53C6,0x53C7,0x53CE,
0x53CF,0x53D0,0x53D2,0x53D3,0x53D5,0x53DA,0x53DC,0x53DD,
0x53DE,0x53E1,0x53E2,0x53E7,0x53F4,0x53FA,0x53FE,0x53FF,
0x5400,0x5402,0x5405,0x5407,0x540B,0x5414,0x5418,0x5419,
0x541A,0x541C,0x5422,0x5424,0x5425,0x542A,0x5430,0x5433,
0x5436,0x5437,0x543A,0x543D,0x543F,0x5441,0x5442,0x5444,
0x5445,0x5447,0x5449,0x544C,0x544D,0x544E,0x544F,0x5451,
0x545A,0x545D,0x545E,0x545F,0x5460,0x5461,0x5463,0x5465,
0x5467,0x5469,0x546A,0x546B,0x546C,0x546D,0x546E,0x546F,
0x5470,0x5474,0x5479,0x547A,0x547E,0x547F,0x5481,0x5483,
0x5485,0x5487,0x5488,0x5489,0x548A,0x548D,0x5491,0x5493,
0x5497,0x5498,0x549C,0x549E,0x549F,0x54A0,0x54A1,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x54A2,0x54A5,0x54AE,0x54B0,0x54B2,0x54B5,0x54B6,0x54B7,
0x54B9,0x54BA,0x54BC,0x54BE,0x54C3,0x54C5,0x54CA,0x54CB,
0x54D6,0x54D8,0x54DB,0x54E0,0x54E1,0x54E2,0x54E3,0x54E4,
0x54EB,0x54EC,0x54EF,0x54F0,0x54F1,0x54F4,0x54F5,0x54F6,
0x54F7,0x54F8,0x54F9,0x54FB,0x54FE,0x5500,0x5502,0x5503,
0x5504,0x5505,0x5508,0x550A,0x550B,0x550C,0x550D,0x550E,
0x5512,0x5513,0x5515,0x5516,0x5517,0x5518,0x5519,0x551A,
0x551C,0x551D,0x551E,0x551F,0x5521,0x5525,0x5526,     0,
0x5528,0x5529,0x552B,0x552D,0x5532,0x5534,0x5535,0x5536,
0x5538,0x5539,0x553A,0x553B,0x553D,0x5540,0x5542,0x5545,
0x5547,0x5548,0x554B,0x554C,0x554D,0x554E,0x554F,0x5551,
0x5552,0x5553,0x5554,0x5557,0x5558,0x5559,0x555A,0x555B,
0x555D,0x555E,0x555F,0x5560,0x5562,0x5563,0x5568,0x5569,
0x556B,0x556F,0x5570,0x5571,0x5572,0x5573,0x5574,0x5579,
0x557A,0x557D,0x557F,0x5585,0x5586,0x558C,0x558D,0x558E,
0x5590,0x5592,0x5593,0x5595,0x5596,0x5597,0x559A,0x559B,
0x559E,0x55A0,0x55A1,0x55A2,0x55A3,0x55A4,0x55A5,0x55A6,
0x55A8,0x55A9,0x55AA,0x55AB,0x55AC,0x55AD,0x55AE,0x55AF,
0x55B0,0x55B2,0x55B4,0x55B6,0x55B8,0x55BA,0x55BC,0x55BF,
0x55C0,0x55C1,0x55C2,0x55C3,0x55C6,0x55C7,0x55C8,0x55CA,
0x55CB,0x55CE,0x55CF,0x55D0,0x55D5,0x55D7,0x55D8,0x55D9,
0x55DA,0x55DB,0x55DE,0x55E0,0x55E2,0x55E7,0x55E9,0x55ED,
0x55EE,0x55F0,0x55F1,0x55F4,0x55F6,0x55F8,0x55F9,0x55FA,
0x55FB,0x55FC,0x55FF,0x5602,0x5603,0x5604,0x5605,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5606,0x5607,0x560A,0x560B,0x560D,0x5610,0x5611,0x5612,
0x5613,0x5614,0x5615,0x5616,0x5617,0x5619,0x561A,0x561C,
0x561D,0x5620,0x5621,0x5622,0x5625,0x5626,0x5628,0x5629,
0x562A,0x562B,0x562E,0x562F,0x5630,0x5633,0x5635,0x5637,
0x5638,0x563A,0x563C,0x563D,0x563E,0x5640,0x5641,0x5642,
0x5643,0x5644,0x5645,0x5646,0x5647,0x5648,0x5649,0x564A,
0x564B,0x564F,0x5650,0x5651,0x5652,0x5653,0x5655,0x5656,
0x565A,0x565B,0x565D,0x565E,0x565F,0x5660,0x5661,     0,
0x5663,0x5665,0x5666,0x5667,0x566D,0x566E,0x566F,0x5670,
0x5672,0x5673,0x5674,0x5675,0x5677,0x5678,0x5679,0x567A,
0x567D,0x567E,0x567F,0x5680,0x5681,0x5682,0x5683,0x5684,
0x5687,0x5688,0x5689,0x568A,0x568B,0x568C,0x568D,0x5690,
0x5691,0x5692,0x5694,0x5695,0x5696,0x5697,0x5698,0x5699,
0x569A,0x569B,0x569C,0x569D,0x569E,0x569F,0x56A0,0x56A1,
0x56A2,0x56A4,0x56A5,0x56A6,0x56A7,0x56A8,0x56A9,0x56AA,
0x56AB,0x56AC,0x56AD,0x56AE,0x56B0,0x56B1,0x56B2,0x56B3,
0x56B4,0x56B5,0x56B6,0x56B8,0x56B9,0x56BA,0x56BB,0x56BD,
0x56BE,0x56BF,0x56C0,0x56C1,0x56C2,0x56C3,0x56C4,0x56C5,
0x56C6,0x56C7,0x56C8,0x56C9,0x56CB,0x56CC,0x56CD,0x56CE,
0x56CF,0x56D0,0x56D1,0x56D2,0x56D3,0x56D5,0x56D6,0x56D8,
0x56D9,0x56DC,0x56E3,0x56E5,0x56E6,0x56E7,0x56E8,0x56E9,
0x56EA,0x56EC,0x56EE,0x56EF,0x56F2,0x56F3,0x56F6,0x56F7,
0x56F8,0x56FB,0x56FC,0x5700,0x5701,0x5702,0x5705,0x5707,
0x570B,0x570C,0x570D,0x570E,0x570F,0x5710,0x5711,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5712,0x5713,0x5714,0x5715,0x5716,0x5717,0x5718,0x5719,
0x571A,0x571B,0x571D,0x571E,0x5720,0x5721,0x5722,0x5724,
0x5725,0x5726,0x5727,0x572B,0x5731,0x5732,0x5734,0x5735,
0x5736,0x5737,0x5738,0x573C,0x573D,0x573F,0x5741,0x5743,
0x5744,0x5745,0x5746,0x5748,0x5749,0x574B,0x5752,0x5753,
0x5754,0x5755,0x5756,0x5758,0x5759,0x5762,0x5763,0x5765,
0x5767,0x576C,0x576E,0x5770,0x5771,0x5772,0x5774,0x5775,
0x5778,0x5779,0x577A,0x577D,0x577E,0x577F,0x5780,     0,
0x5781,0x5787,0x5788,0x5789,0x578A,0x578D,0x578E,0x578F,
0x5790,0x5791,0x5794,0x5795,0x5796,0x5797,0x5798,0x5799,
0x579A,0x579C,0x579D,0x579E,0x579F,0x57A5,0x57A8,0x57AA,
0x57AC,0x57AF,0x57B0,0x57B1,0x57B3,0x57B5,0x57B6,0x57B7,
0x57B9,0x57BA,0x57BB,0x57BC,0x57BD,0x57BE,0x57BF,0x57C0,
0x57C1,0x57C4,0x57C5,0x57C6,0x57C7,0x57C8,0x57C9,0x57CA,
0x57CC,0x57CD,0x57D0,0x57D1,0x57D3,0x57D6,0x57D7,0x57DB,
0x57DC,0x57DE,0x57E1,0x57E2,0x57E3,0x57E5,0x57E6,0x57E7,
0x57E8,0x57E9,0x57EA,0x57EB,0x57EC,0x57EE,0x57F0,0x57F1,
0x57F2,0x57F3,0x57F5,0x57F6,0x57F7,0x57FB,0x57FC,0x57FE,
0x57FF,0x5801,0x5803,0x5804,0x5805,0x5808,0x5809,0x580A,
0x580C,0x580E,0x580F,0x5810,0x5812,0x5813,0x5814,0x5816,
0x5817,0x5818,0x581A,0x581B,0x581C,0x581D,0x581F,0x5822,
0x5823,0x5825,0x5826,0x5827,0x5828,0x5829,0x582B,0x582C,
0x582D,0x582E,0x582F,0x5831,0x5832,0x5833,0x5834,0x5836,
0x5837,0x5838,0x5839,0x583A,0x583B,0x583C,0x583D,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x583E,0x583F,0x5840,0x5841,0x5842,0x5843,0x5845,0x5846,
0x5847,0x5848,0x5849,0x584A,0x584B,0x584E,0x584F,0x5850,
0x5852,0x5853,0x5855,0x5856,0x5857,0x5859,0x585A,0x585B,
0x585C,0x585D,0x585F,0x5860,0x5861,0x5862,0x5863,0x5864,
0x5866,0x5867,0x5868,0x5869,0x586A,0x586D,0x586E,0x586F,
0x5870,0x5871,0x5872,0x5873,0x5874,0x5875,0x5876,0x5877,
0x5878,0x5879,0x587A,0x587B,0x587C,0x587D,0x587F,0x5882,
0x5884,0x5886,0x5887,0x5888,0x588A,0x588B,0x588C,     0,
0x588D,0x588E,0x588F,0x5890,0x5891,0x5894,0x5895,0x5896,
0x5897,0x5898,0x589B,0x589C,0x589D,0x58A0,0x58A1,0x58A2,
0x58A3,0x58A4,0x58A5,0x58A6,0x58A7,0x58AA,0x58AB,0x58AC,
0x58AD,0x58AE,0x58AF,0x58B0,0x58B1,0x58B2,0x58B3,0x58B4,
0x58B5,0x58B6,0x58B7,0x58B8,0x58B9,0x58BA,0x58BB,0x58BD,
0x58BE,0x58BF,0x58C0,0x58C2,0x58C3,0x58C4,0x58C6,0x58C7,
0x58C8,0x58C9,0x58CA,0x58CB,0x58CC,0x58CD,0x58CE,0x58CF,
0x58D0,0x58D2,0x58D3,0x58D4,0x58D6,0x58D7,0x58D8,0x58D9,
0x58DA,0x58DB,0x58DC,0x58DD,0x58DE,0x58DF,0x58E0,0x58E1,
0x58E2,0x58E3,0x58E5,0x58E6,0x58E7,0x58E8,0x58E9,0x58EA,
0x58ED,0x58EF,0x58F1,0x58F2,0x58F4,0x58F5,0x58F7,0x58F8,
0x58FA,0x58FB,0x58FC,0x58FD,0x58FE,0x58FF,0x5900,0x5901,
0x5903,0x5905,0x5906,0x5908,0x5909,0x590A,0x590B,0x590C,
0x590E,0x5910,0x5911,0x5912,0x5913,0x5917,0x5918,0x591B,
0x591D,0x591E,0x5920,0x5921,0x5922,0x5923,0x5926,0x5928,
0x592C,0x5930,0x5932,0x5933,0x5935,0x5936,0x593B,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x593D,0x593E,0x593F,0x5940,0x5943,0x5945,0x5946,0x594A,
0x594C,0x594D,0x5950,0x5952,0x5953,0x5959,0x595B,0x595C,
0x595D,0x595E,0x595F,0x5961,0x5963,0x5964,0x5966,0x5967,
0x5968,0x5969,0x596A,0x596B,0x596C,0x596D,0x596E,0x596F,
0x5970,0x5971,0x5972,0x5975,0x5977,0x597A,0x597B,0x597C,
0x597E,0x597F,0x5980,0x5985,0x5989,0x598B,0x598C,0x598E,
0x598F,0x5990,0x5991,0x5994,0x5995,0x5998,0x599A,0x599B,
0x599C,0x599D,0x599F,0x59A0,0x59A1,0x59A2,0x59A6,     0,
0x59A7,0x59AC,0x59AD,0x59B0,0x59B1,0x59B3,0x59B4,0x59B5,
0x59B6,0x59B7,0x59B8,0x59BA,0x59BC,0x59BD,0x59BF,0x59C0,
0x59C1,0x59C2,0x59C3,0x59C4,0x59C5,0x59C7,0x59C8,0x59C9,
0x59CC,0x59CD,0x59CE,0x59CF,0x59D5,0x59D6,0x59D9,0x59DB,
0x59DE,0x59DF,0x59E0,0x59E1,0x59E2,0x59E4,0x59E6,0x59E7,
0x59E9,0x59EA,0x59EB,0x59ED,0x59EE,0x59EF,0x59F0,0x59F1,
0x59F2,0x59F3,0x59F4,0x59F5,0x59F6,0x59F7,0x59F8,0x59FA,
0x59FC,0x59FD,0x59FE,0x5A00,0x5A02,0x5A0A,0x5A0B,0x5A0D,
0x5A0E,0x5A0F,0x5A10,0x5A12,0x5A14,0x5A15,0x5A16,0x5A17,
0x5A19,0x5A1A,0x5A1B,0x5A1D,0x5A1E,0x5A21,0x5A22,0x5A24,
0x5A26,0x5A27,0x5A28,0x5A2A,0x5A2B,0x5A2C,0x5A2D,0x5A2E,
0x5A2F,0x5A30,0x5A33,0x5A35,0x5A37,0x5A38,0x5A39,0x5A3A,
0x5A3B,0x5A3D,0x5A3E,0x5A3F,0x5A41,0x5A42,0x5A43,0x5A44,
0x5A45,0x5A47,0x5A48,0x5A4B,0x5A4C,0x5A4D,0x5A4E,0x5A4F,
0x5A50,0x5A51,0x5A52,0x5A53,0x5A54,0x5A56,0x5A57,0x5A58,
0x5A59,0x5A5B,0x5A5C,0x5A5D,0x5A5E,0x5A5F,0x5A60,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5A61,0x5A63,0x5A64,0x5A65,0x5A66,0x5A68,0x5A69,0x5A6B,
0x5A6C,0x5A6D,0x5A6E,0x5A6F,0x5A70,0x5A71,0x5A72,0x5A73,
0x5A78,0x5A79,0x5A7B,0x5A7C,0x5A7D,0x5A7E,0x5A80,0x5A81,
0x5A82,0x5A83,0x5A84,0x5A85,0x5A86,0x5A87,0x5A88,0x5A89,
0x5A8A,0x5A8B,0x5A8C,0x5A8D,0x5A8E,0x5A8F,0x5A90,0x5A91,
0x5A93,0x5A94,0x5A95,0x5A96,0x5A97,0x5A98,0x5A99,0x5A9C,
0x5A9D,0x5A9E,0x5A9F,0x5AA0,0x5AA1,0x5AA2,0x5AA3,0x5AA4,
0x5AA5,0x5AA6,0x5AA7,0x5AA8,0x5AA9,0x5AAB,0x5AAC,     0,
0x5AAD,0x5AAE,0x5AAF,0x5AB0,0x5AB1,0x5AB4,0x5AB6,0x5AB7,
0x5AB9,0x5ABA,0x5ABB,0x5ABC,0x5ABD,0x5ABF,0x5AC0,0x5AC3,
0x5AC4,0x5AC5,0x5AC6,0x5AC7,0x5AC8,0x5ACA,0x5ACB,0x5ACD,
0x5ACE,0x5ACF,0x5AD0,0x5AD1,0x5AD3,0x5AD5,0x5AD7,0x5AD9,
0x5ADA,0x5ADB,0x5ADD,0x5ADE,0x5ADF,0x5AE2,0x5AE4,0x5AE5,
0x5AE7,0x5AE8,0x5AEA,0x5AEC,0x5AED,0x5AEE,0x5AEF,0x5AF0,
0x5AF2,0x5AF3,0x5AF4,0x5AF5,0x5AF6,0x5AF7,0x5AF8,0x5AF9,
0x5AFA,0x5AFB,0x5AFC,0x5AFD,0x5AFE,0x5AFF,0x5B00,0x5B01,
0x5B02,0x5B03,0x5B04,0x5B05,0x5B06,0x5B07,0x5B08,0x5B0A,
0x5B0B,0x5B0C,0x5B0D,0x5B0E,0x5B0F,0x5B10,0x5B11,0x5B12,
0x5B13,0x5B14,0x5B15,0x5B18,0x5B19,0x5B1A,0x5B1B,0x5B1C,
0x5B1D,0x5B1E,0x5B1F,0x5B20,0x5B21,0x5B22,0x5B23,0x5B24,
0x5B25,0x5B26,0x5B27,0x5B28,0x5B29,0x5B2A,0x5B2B,0x5B2C,
0x5B2D,0x5B2E,0x5B2F,0x5B30,0x5B31,0x5B33,0x5B35,0x5B36,
0x5B38,0x5B39,0x5B3A,0x5B3B,0x5B3C,0x5B3D,0x5B3E,0x5B3F,
0x5B41,0x5B42,0x5B43,0x5B44,0x5B45,0x5B46,0x5B47,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5B48,0x5B49,0x5B4A,0x5B4B,0x5B4C,0x5B4D,0x5B4E,0x5B4F,
0x5B52,0x5B56,0x5B5E,0x5B60,0x5B61,0x5B67,0x5B68,0x5B6B,
0x5B6D,0x5B6E,0x5B6F,0x5B72,0x5B74,0x5B76,0x5B77,0x5B78,
0x5B79,0x5B7B,0x5B7C,0x5B7E,0x5B7F,0x5B82,0x5B86,0x5B8A,
0x5B8D,0x5B8E,0x5B90,0x5B91,0x5B92,0x5B94,0x5B96,0x5B9F,
0x5BA7,0x5BA8,0x5BA9,0x5BAC,0x5BAD,0x5BAE,0x5BAF,0x5BB1,
0x5BB2,0x5BB7,0x5BBA,0x5BBB,0x5BBC,0x5BC0,0x5BC1,0x5BC3,
0x5BC8,0x5BC9,0x5BCA,0x5BCB,0x5BCD,0x5BCE,0x5BCF,     0,
0x5BD1,0x5BD4,0x5BD5,0x5BD6,0x5BD7,0x5BD8,0x5BD9,0x5BDA,
0x5BDB,0x5BDC,0x5BE0,0x5BE2,0x5BE3,0x5BE6,0x5BE7,0x5BE9,
0x5BEA,0x5BEB,0x5BEC,0x5BED,0x5BEF,0x5BF1,0x5BF2,0x5BF3,
0x5BF4,0x5BF5,0x5BF6,0x5BF7,0x5BFD,0x5BFE,0x5C00,0x5C02,
0x5C03,0x5C05,0x5C07,0x5C08,0x5C0B,0x5C0C,0x5C0D,0x5C0E,
0x5C10,0x5C12,0x5C13,0x5C17,0x5C19,0x5C1B,0x5C1E,0x5C1F,
0x5C20,0x5C21,0x5C23,0x5C26,0x5C28,0x5C29,0x5C2A,0x5C2B,
0x5C2D,0x5C2E,0x5C2F,0x5C30,0x5C32,0x5C33,0x5C35,0x5C36,
0x5C37,0x5C43,0x5C44,0x5C46,0x5C47,0x5C4C,0x5C4D,0x5C52,
0x5C53,0x5C54,0x5C56,0x5C57,0x5C58,0x5C5A,0x5C5B,0x5C5C,
0x5C5D,0x5C5F,0x5C62,0x5C64,0x5C67,0x5C68,0x5C69,0x5C6A,
0x5C6B,0x5C6C,0x5C6D,0x5C70,0x5C72,0x5C73,0x5C74,0x5C75,
0x5C76,0x5C77,0x5C78,0x5C7B,0x5C7C,0x5C7D,0x5C7E,0x5C80,
0x5C83,0x5C84,0x5C85,0x5C86,0x5C87,0x5C89,0x5C8A,0x5C8B,
0x5C8E,0x5C8F,0x5C92,0x5C93,0x5C95,0x5C9D,0x5C9E,0x5C9F,
0x5CA0,0x5CA1,0x5CA4,0x5CA5,0x5CA6,0x5CA7,0x5CA8,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5CAA,0x5CAE,0x5CAF,0x5CB0,0x5CB2,0x5CB4,0x5CB6,0x5CB9,
0x5CBA,0x5CBB,0x5CBC,0x5CBE,0x5CC0,0x5CC2,0x5CC3,0x5CC5,
0x5CC6,0x5CC7,0x5CC8,0x5CC9,0x5CCA,0x5CCC,0x5CCD,0x5CCE,
0x5CCF,0x5CD0,0x5CD1,0x5CD3,0x5CD4,0x5CD5,0x5CD6,0x5CD7,
0x5CD8,0x5CDA,0x5CDB,0x5CDC,0x5CDD,0x5CDE,0x5CDF,0x5CE0,
0x5CE2,0x5CE3,0x5CE7,0x5CE9,0x5CEB,0x5CEC,0x5CEE,0x5CEF,
0x5CF1,0x5CF2,0x5CF3,0x5CF4,0x5CF5,0x5CF6,0x5CF7,0x5CF8,
0x5CF9,0x5CFA,0x5CFC,0x5CFD,0x5CFE,0x5CFF,0x5D00,     0,
0x5D01,0x5D04,0x5D05,0x5D08,0x5D09,0x5D0A,0x5D0B,0x5D0C,
0x5D0D,0x5D0F,0x5D10,0x5D11,0x5D12,0x5D13,0x5D15,0x5D17,
0x5D18,0x5D19,0x5D1A,0x5D1C,0x5D1D,0x5D1F,0x5D20,0x5D21,
0x5D22,0x5D23,0x5D25,0x5D28,0x5D2A,0x5D2B,0x5D2C,0x5D2F,
0x5D30,0x5D31,0x5D32,0x5D33,0x5D35,0x5D36,0x5D37,0x5D38,
0x5D39,0x5D3A,0x5D3B,0x5D3C,0x5D3F,0x5D40,0x5D41,0x5D42,
0x5D43,0x5D44,0x5D45,0x5D46,0x5D48,0x5D49,0x5D4D,0x5D4E,
0x5D4F,0x5D50,0x5D51,0x5D52,0x5D53,0x5D54,0x5D55,0x5D56,
0x5D57,0x5D59,0x5D5A,0x5D5C,0x5D5E,0x5D5F,0x5D60,0x5D61,
0x5D62,0x5D63,0x5D64,0x5D65,0x5D66,0x5D67,0x5D68,0x5D6A,
0x5D6D,0x5D6E,0x5D70,0x5D71,0x5D72,0x5D73,0x5D75,0x5D76,
0x5D77,0x5D78,0x5D79,0x5D7A,0x5D7B,0x5D7C,0x5D7D,0x5D7E,
0x5D7F,0x5D80,0x5D81,0x5D83,0x5D84,0x5D85,0x5D86,0x5D87,
0x5D88,0x5D89,0x5D8A,0x5D8B,0x5D8C,0x5D8D,0x5D8E,0x5D8F,
0x5D90,0x5D91,0x5D92,0x5D93,0x5D94,0x5D95,0x5D96,0x5D97,
0x5D98,0x5D9A,0x5D9B,0x5D9C,0x5D9E,0x5D9F,0x5DA0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5DA1,0x5DA2,0x5DA3,0x5DA4,0x5DA5,0x5DA6,0x5DA7,0x5DA8,
0x5DA9,0x5DAA,0x5DAB,0x5DAC,0x5DAD,0x5DAE,0x5DAF,0x5DB0,
0x5DB1,0x5DB2,0x5DB3,0x5DB4,0x5DB5,0x5DB6,0x5DB8,0x5DB9,
0x5DBA,0x5DBB,0x5DBC,0x5DBD,0x5DBE,0x5DBF,0x5DC0,0x5DC1,
0x5DC2,0x5DC3,0x5DC4,0x5DC6,0x5DC7,0x5DC8,0x5DC9,0x5DCA,
0x5DCB,0x5DCC,0x5DCE,0x5DCF,0x5DD0,0x5DD1,0x5DD2,0x5DD3,
0x5DD4,0x5DD5,0x5DD6,0x5DD7,0x5DD8,0x5DD9,0x5DDA,0x5DDC,
0x5DDF,0x5DE0,0x5DE3,0x5DE4,0x5DEA,0x5DEC,0x5DED,     0,
0x5DF0,0x5DF5,0x5DF6,0x5DF8,0x5DF9,0x5DFA,0x5DFB,0x5DFC,
0x5DFF,0x5E00,0x5E04,0x5E07,0x5E09,0x5E0A,0x5E0B,0x5E0D,
0x5E0E,0x5E12,0x5E13,0x5E17,0x5E1E,0x5E1F,0x5E20,0x5E21,
0x5E22,0x5E23,0x5E24,0x5E25,0x5E28,0x5E29,0x5E2A,0x5E2B,
0x5E2C,0x5E2F,0x5E30,0x5E32,0x5E33,0x5E34,0x5E35,0x5E36,
0x5E39,0x5E3A,0x5E3E,0x5E3F,0x5E40,0x5E41,0x5E43,0x5E46,
0x5E47,0x5E48,0x5E49,0x5E4A,0x5E4B,0x5E4D,0x5E4E,0x5E4F,
0x5E50,0x5E51,0x5E52,0x5E53,0x5E56,0x5E57,0x5E58,0x5E59,
0x5E5A,0x5E5C,0x5E5D,0x5E5F,0x5E60,0x5E63,0x5E64,0x5E65,
0x5E66,0x5E67,0x5E68,0x5E69,0x5E6A,0x5E6B,0x5E6C,0x5E6D,
0x5E6E,0x5E6F,0x5E70,0x5E71,0x5E75,0x5E77,0x5E79,0x5E7E,
0x5E81,0x5E82,0x5E83,0x5E85,0x5E88,0x5E89,0x5E8C,0x5E8D,
0x5E8E,0x5E92,0x5E98,0x5E9B,0x5E9D,0x5EA1,0x5EA2,0x5EA3,
0x5EA4,0x5EA8,0x5EA9,0x5EAA,0x5EAB,0x5EAC,0x5EAE,0x5EAF,
0x5EB0,0x5EB1,0x5EB2,0x5EB4,0x5EBA,0x5EBB,0x5EBC,0x5EBD,
0x5EBF,0x5EC0,0x5EC1,0x5EC2,0x5EC3,0x5EC4,0x5EC5,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x5EC6,0x5EC7,0x5EC8,0x5ECB,0x5ECC,0x5ECD,0x5ECE,0x5ECF,
0x5ED0,0x5ED4,0x5ED5,0x5ED7,0x5ED8,0x5ED9,0x5EDA,0x5EDC,
0x5EDD,0x5EDE,0x5EDF,0x5EE0,0x5EE1,0x5EE2,0x5EE3,0x5EE4,
0x5EE5,0x5EE6,0x5EE7,0x5EE9,0x5EEB,0x5EEC,0x5EED,0x5EEE,
0x5EEF,0x5EF0,0x5EF1,0x5EF2,0x5EF3,0x5EF5,0x5EF8,0x5EF9,
0x5EFB,0x5EFC,0x5EFD,0x5F05,0x5F06,0x5F07,0x5F09,0x5F0C,
0x5F0D,0x5F0E,0x5F10,0x5F12,0x5F14,0x5F16,0x5F19,0x5F1A,
0x5F1C,0x5F1D,0x5F1E,0x5F21,0x5F22,0x5F23,0x5F24,     0,
0x5F28,0x5F2B,0x5F2C,0x5F2E,0x5F30,0x5F32,0x5F33,0x5F34,
0x5F35,0x5F36,0x5F37,0x5F38,0x5F3B,0x5F3D,0x5F3E,0x5F3F,
0x5F41,0x5F42,0x5F43,0x5F44,0x5F45,0x5F46,0x5F47,0x5F48,
0x5F49,0x5F4A,0x5F4B,0x5F4C,0x5F4D,0x5F4E,0x5F4F,0x5F51,
0x5F54,0x5F59,0x5F5A,0x5F5B,0x5F5C,0x5F5E,0x5F5F,0x5F60,
0x5F63,0x5F65,0x5F67,0x5F68,0x5F6B,0x5F6E,0x5F6F,0x5F72,
0x5F74,0x5F75,0x5F76,0x5F78,0x5F7A,0x5F7D,0x5F7E,0x5F7F,
0x5F83,0x5F86,0x5F8D,0x5F8E,0x5F8F,0x5F91,0x5F93,0x5F94,
0x5F96,0x5F9A,0x5F9B,0x5F9D,0x5F9E,0x5F9F,0x5FA0,0x5FA2,
0x5FA3,0x5FA4,0x5FA5,0x5FA6,0x5FA7,0x5FA9,0x5FAB,0x5FAC,
0x5FAF,0x5FB0,0x5FB1,0x5FB2,0x5FB3,0x5FB4,0x5FB6,0x5FB8,
0x5FB9,0x5FBA,0x5FBB,0x5FBE,0x5FBF,0x5FC0,0x5FC1,0x5FC2,
0x5FC7,0x5FC8,0x5FCA,0x5FCB,0x5FCE,0x5FD3,0x5FD4,0x5FD5,
0x5FDA,0x5FDB,0x5FDC,0x5FDE,0x5FDF,0x5FE2,0x5FE3,0x5FE5,
0x5FE6,0x5FE8,0x5FE9,0x5FEC,0x5FEF,0x5FF0,0x5FF2,0x5FF3,
0x5FF4,0x5FF6,0x5FF7,0x5FF9,0x5FFA,0x5FFC,0x6007,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6008,0x6009,0x600B,0x600C,0x6010,0x6011,0x6013,0x6017,
0x6018,0x601A,0x601E,0x601F,0x6022,0x6023,0x6024,0x602C,
0x602D,0x602E,0x6030,0x6031,0x6032,0x6033,0x6034,0x6036,
0x6037,0x6038,0x6039,0x603A,0x603D,0x603E,0x6040,0x6044,
0x6045,0x6046,0x6047,0x6048,0x6049,0x604A,0x604C,0x604E,
0x604F,0x6051,0x6053,0x6054,0x6056,0x6057,0x6058,0x605B,
0x605C,0x605E,0x605F,0x6060,0x6061,0x6065,0x6066,0x606E,
0x6071,0x6072,0x6074,0x6075,0x6077,0x607E,0x6080,     0,
0x6081,0x6082,0x6085,0x6086,0x6087,0x6088,0x608A,0x608B,
0x608E,0x608F,0x6090,0x6091,0x6093,0x6095,0x6097,0x6098,
0x6099,0x609C,0x609E,0x60A1,0x60A2,0x60A4,0x60A5,0x60A7,
0x60A9,0x60AA,0x60AE,0x60B0,0x60B3,0x60B5,0x60B6,0x60B7,
0x60B9,0x60BA,0x60BD,0x60BE,0x60BF,0x60C0,0x60C1,0x60C2,
0x60C3,0x60C4,0x60C7,0x60C8,0x60C9,0x60CC,0x60CD,0x60CE,
0x60CF,0x60D0,0x60D2,0x60D3,0x60D4,0x60D6,0x60D7,0x60D9,
0x60DB,0x60DE,0x60E1,0x60E2,0x60E3,0x60E4,0x60E5,0x60EA,
0x60F1,0x60F2,0x60F5,0x60F7,0x60F8,0x60FB,0x60FC,0x60FD,
0x60FE,0x60FF,0x6102,0x6103,0x6104,0x6105,0x6107,0x610A,
0x610B,0x610C,0x6110,0x6111,0x6112,0x6113,0x6114,0x6116,
0x6117,0x6118,0x6119,0x611B,0x611C,0x611D,0x611E,0x6121,
0x6122,0x6125,0x6128,0x6129,0x612A,0x612C,0x612D,0x612E,
0x612F,0x6130,0x6131,0x6132,0x6133,0x6134,0x6135,0x6136,
0x6137,0x6138,0x6139,0x613A,0x613B,0x613C,0x613D,0x613E,
0x6140,0x6141,0x6142,0x6143,0x6144,0x6145,0x6146,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6147,0x6149,0x614B,0x614D,0x614F,0x6150,0x6152,0x6153,
0x6154,0x6156,0x6157,0x6158,0x6159,0x615A,0x615B,0x615C,
0x615E,0x615F,0x6160,0x6161,0x6163,0x6164,0x6165,0x6166,
0x6169,0x616A,0x616B,0x616C,0x616D,0x616E,0x616F,0x6171,
0x6172,0x6173,0x6174,0x6176,0x6178,0x6179,0x617A,0x617B,
0x617C,0x617D,0x617E,0x617F,0x6180,0x6181,0x6182,0x6183,
0x6184,0x6185,0x6186,0x6187,0x6188,0x6189,0x618A,0x618C,
0x618D,0x618F,0x6190,0x6191,0x6192,0x6193,0x6195,     0,
0x6196,0x6197,0x6198,0x6199,0x619A,0x619B,0x619C,0x619E,
0x619F,0x61A0,0x61A1,0x61A2,0x61A3,0x61A4,0x61A5,0x61A6,
0x61AA,0x61AB,0x61AD,0x61AE,0x61AF,0x61B0,0x61B1,0x61B2,
0x61B3,0x61B4,0x61B5,0x61B6,0x61B8,0x61B9,0x61BA,0x61BB,
0x61BC,0x61BD,0x61BF,0x61C0,0x61C1,0x61C3,0x61C4,0x61C5,
0x61C6,0x61C7,0x61C9,0x61CC,0x61CD,0x61CE,0x61CF,0x61D0,
0x61D3,0x61D5,0x61D6,0x61D7,0x61D8,0x61D9,0x61DA,0x61DB,
0x61DC,0x61DD,0x61DE,0x61DF,0x61E0,0x61E1,0x61E2,0x61E3,
0x61E4,0x61E5,0x61E7,0x61E8,0x61E9,0x61EA,0x61EB,0x61EC,
0x61ED,0x61EE,0x61EF,0x61F0,0x61F1,0x61F2,0x61F3,0x61F4,
0x61F6,0x61F7,0x61F8,0x61F9,0x61FA,0x61FB,0x61FC,0x61FD,
0x61FE,0x6200,0x6201,0x6202,0x6203,0x6204,0x6205,0x6207,
0x6209,0x6213,0x6214,0x6219,0x621C,0x621D,0x621E,0x6220,
0x6223,0x6226,0x6227,0x6228,0x6229,0x622B,0x622D,0x622F,
0x6230,0x6231,0x6232,0x6235,0x6236,0x6238,0x6239,0x623A,
0x623B,0x623C,0x6242,0x6244,0x6245,0x6246,0x624A,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x624F,0x6250,0x6255,0x6256,0x6257,0x6259,0x625A,0x625C,
0x625D,0x625E,0x625F,0x6260,0x6261,0x6262,0x6264,0x6265,
0x6268,0x6271,0x6272,0x6274,0x6275,0x6277,0x6278,0x627A,
0x627B,0x627D,0x6281,0x6282,0x6283,0x6285,0x6286,0x6287,
0x6288,0x628B,0x628C,0x628D,0x628E,0x628F,0x6290,0x6294,
0x6299,0x629C,0x629D,0x629E,0x62A3,0x62A6,0x62A7,0x62A9,
0x62AA,0x62AD,0x62AE,0x62AF,0x62B0,0x62B2,0x62B3,0x62B4,
0x62B6,0x62B7,0x62B8,0x62BA,0x62BE,0x62C0,0x62C1,     0,
0x62C3,0x62CB,0x62CF,0x62D1,0x62D5,0x62DD,0x62DE,0x62E0,
0x62E1,0x62E4,0x62EA,0x62EB,0x62F0,0x62F2,0x62F5,0x62F8,
0x62F9,0x62FA,0x62FB,0x6300,0x6303,0x6304,0x6305,0x6306,
0x630A,0x630B,0x630C,0x630D,0x630F,0x6310,0x6312,0x6313,
0x6314,0x6315,0x6317,0x6318,0x6319,0x631C,0x6326,0x6327,
0x6329,0x632C,0x632D,0x632E,0x6330,0x6331,0x6333,0x6334,
0x6335,0x6336,0x6337,0x6338,0x633B,0x633C,0x633E,0x633F,
0x6340,0x6341,0x6344,0x6347,0x6348,0x634A,0x6351,0x6352,
0x6353,0x6354,0x6356,0x6357,0x6358,0x6359,0x635A,0x635B,
0x635C,0x635D,0x6360,0x6364,0x6365,0x6366,0x6368,0x636A,
0x636B,0x636C,0x636F,0x6370,0x6372,0x6373,0x6374,0x6375,
0x6378,0x6379,0x637C,0x637D,0x637E,0x637F,0x6381,0x6383,
0x6384,0x6385,0x6386,0x638B,0x638D,0x6391,0x6393,0x6394,
0x6395,0x6397,0x6399,0x639A,0x639B,0x639C,0x639D,0x639E,
0x639F,0x63A1,0x63A4,0x63A6,0x63AB,0x63AF,0x63B1,0x63B2,
0x63B5,0x63B6,0x63B9,0x63BB,0x63BD,0x63BF,0x63C0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x63C1,0x63C2,0x63C3,0x63C5,0x63C7,0x63C8,0x63CA,0x63CB,
0x63CC,0x63D1,0x63D3,0x63D4,0x63D5,0x63D7,0x63D8,0x63D9,
0x63DA,0x63DB,0x63DC,0x63DD,0x63DF,0x63E2,0x63E4,0x63E5,
0x63E6,0x63E7,0x63E8,0x63EB,0x63EC,0x63EE,0x63EF,0x63F0,
0x63F1,0x63F3,0x63F5,0x63F7,0x63F9,0x63FA,0x63FB,0x63FC,
0x63FE,0x6403,0x6404,0x6406,0x6407,0x6408,0x6409,0x640A,
0x640D,0x640E,0x6411,0x6412,0x6415,0x6416,0x6417,0x6418,
0x6419,0x641A,0x641D,0x641F,0x6422,0x6423,0x6424,     0,
0x6425,0x6427,0x6428,0x6429,0x642B,0x642E,0x642F,0x6430,
0x6431,0x6432,0x6433,0x6435,0x6436,0x6437,0x6438,0x6439,
0x643B,0x643C,0x643E,0x6440,0x6442,0x6443,0x6449,0x644B,
0x644C,0x644D,0x644E,0x644F,0x6450,0x6451,0x6453,0x6455,
0x6456,0x6457,0x6459,0x645A,0x645B,0x645C,0x645D,0x645F,
0x6460,0x6461,0x6462,0x6463,0x6464,0x6465,0x6466,0x6468,
0x646A,0x646B,0x646C,0x646E,0x646F,0x6470,0x6471,0x6472,
0x6473,0x6474,0x6475,0x6476,0x6477,0x647B,0x647C,0x647D,
0x647E,0x647F,0x6480,0x6481,0x6483,0x6486,0x6488,0x6489,
0x648A,0x648B,0x648C,0x648D,0x648E,0x648F,0x6490,0x6493,
0x6494,0x6497,0x6498,0x649A,0x649B,0x649C,0x649D,0x649F,
0x64A0,0x64A1,0x64A2,0x64A3,0x64A5,0x64A6,0x64A7,0x64A8,
0x64AA,0x64AB,0x64AF,0x64B1,0x64B2,0x64B3,0x64B4,0x64B6,
0x64B9,0x64BB,0x64BD,0x64BE,0x64BF,0x64C1,0x64C3,0x64C4,
0x64C6,0x64C7,0x64C8,0x64C9,0x64CA,0x64CB,0x64CC,0x64CF,
0x64D1,0x64D3,0x64D4,0x64D5,0x64D6,0x64D9,0x64DA,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x64DB,0x64DC,0x64DD,0x64DF,0x64E0,0x64E1,0x64E3,0x64E5,
0x64E7,0x64E8,0x64E9,0x64EA,0x64EB,0x64EC,0x64ED,0x64EE,
0x64EF,0x64F0,0x64F1,0x64F2,0x64F3,0x64F4,0x64F5,0x64F6,
0x64F7,0x64F8,0x64F9,0x64FA,0x64FB,0x64FC,0x64FD,0x64FE,
0x64FF,0x6501,0x6502,0x6503,0x6504,0x6505,0x6506,0x6507,
0x6508,0x650A,0x650B,0x650C,0x650D,0x650E,0x650F,0x6510,
0x6511,0x6513,0x6514,0x6515,0x6516,0x6517,0x6519,0x651A,
0x651B,0x651C,0x651D,0x651E,0x651F,0x6520,0x6521,     0,
0x6522,0x6523,0x6524,0x6526,0x6527,0x6528,0x6529,0x652A,
0x652C,0x652D,0x6530,0x6531,0x6532,0x6533,0x6537,0x653A,
0x653C,0x653D,0x6540,0x6541,0x6542,0x6543,0x6544,0x6546,
0x6547,0x654A,0x654B,0x654D,0x654E,0x6550,0x6552,0x6553,
0x6554,0x6557,0x6558,0x655A,0x655C,0x655F,0x6560,0x6561,
0x6564,0x6565,0x6567,0x6568,0x6569,0x656A,0x656D,0x656E,
0x656F,0x6571,0x6573,0x6575,0x6576,0x6578,0x6579,0x657A,
0x657B,0x657C,0x657D,0x657E,0x657F,0x6580,0x6581,0x6582,
0x6583,0x6584,0x6585,0x6586,0x6588,0x6589,0x658A,0x658D,
0x658E,0x658F,0x6592,0x6594,0x6595,0x6596,0x6598,0x659A,
0x659D,0x659E,0x65A0,0x65A2,0x65A3,0x65A6,0x65A8,0x65AA,
0x65AC,0x65AE,0x65B1,0x65B2,0x65B3,0x65B4,0x65B5,0x65B6,
0x65B7,0x65B8,0x65BA,0x65BB,0x65BE,0x65BF,0x65C0,0x65C2,
0x65C7,0x65C8,0x65C9,0x65CA,0x65CD,0x65D0,0x65D1,0x65D3,
0x65D4,0x65D5,0x65D8,0x65D9,0x65DA,0x65DB,0x65DC,0x65DD,
0x65DE,0x65DF,0x65E1,0x65E3,0x65E4,0x65EA,0x65EB,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x65F2,0x65F3,0x65F4,0x65F5,0x65F8,0x65F9,0x65FB,0x65FC,
0x65FD,0x65FE,0x65FF,0x6601,0x6604,0x6605,0x6607,0x6608,
0x6609,0x660B,0x660D,0x6610,0x6611,0x6612,0x6616,0x6617,
0x6618,0x661A,0x661B,0x661C,0x661E,0x6621,0x6622,0x6623,
0x6624,0x6626,0x6629,0x662A,0x662B,0x662C,0x662E,0x6630,
0x6632,0x6633,0x6637,0x6638,0x6639,0x663A,0x663B,0x663D,
0x663F,0x6640,0x6642,0x6644,0x6645,0x6646,0x6647,0x6648,
0x6649,0x664A,0x664D,0x664E,0x6650,0x6651,0x6658,     0,
0x6659,0x665B,0x665C,0x665D,0x665E,0x6660,0x6662,0x6663,
0x6665,0x6667,0x6669,0x666A,0x666B,0x666C,0x666D,0x6671,
0x6672,0x6673,0x6675,0x6678,0x6679,0x667B,0x667C,0x667D,
0x667F,0x6680,0x6681,0x6683,0x6685,0x6686,0x6688,0x6689,
0x668A,0x668B,0x668D,0x668E,0x668F,0x6690,0x6692,0x6693,
0x6694,0x6695,0x6698,0x6699,0x669A,0x669B,0x669C,0x669E,
0x669F,0x66A0,0x66A1,0x66A2,0x66A3,0x66A4,0x66A5,0x66A6,
0x66A9,0x66AA,0x66AB,0x66AC,0x66AD,0x66AF,0x66B0,0x66B1,
0x66B2,0x66B3,0x66B5,0x66B6,0x66B7,0x66B8,0x66BA,0x66BB,
0x66BC,0x66BD,0x66BF,0x66C0,0x66C1,0x66C2,0x66C3,0x66C4,
0x66C5,0x66C6,0x66C7,0x66C8,0x66C9,0x66CA,0x66CB,0x66CC,
0x66CD,0x66CE,0x66CF,0x66D0,0x66D1,0x66D2,0x66D3,0x66D4,
0x66D5,0x66D6,0x66D7,0x66D8,0x66DA,0x66DE,0x66DF,0x66E0,
0x66E1,0x66E2,0x66E3,0x66E4,0x66E5,0x66E7,0x66E8,0x66EA,
0x66EB,0x66EC,0x66ED,0x66EE,0x66EF,0x66F1,0x66F5,0x66F6,
0x66F8,0x66FA,0x66FB,0x66FD,0x6701,0x6702,0x6703,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6704,0x6705,0x6706,0x6707,0x670C,0x670E,0x670F,0x6711,
0x6712,0x6713,0x6716,0x6718,0x6719,0x671A,0x671C,0x671E,
0x6720,0x6721,0x6722,0x6723,0x6724,0x6725,0x6727,0x6729,
0x672E,0x6730,0x6732,0x6733,0x6736,0x6737,0x6738,0x6739,
0x673B,0x673C,0x673E,0x673F,0x6741,0x6744,0x6745,0x6747,
0x674A,0x674B,0x674D,0x6752,0x6754,0x6755,0x6757,0x6758,
0x6759,0x675A,0x675B,0x675D,0x6762,0x6763,0x6764,0x6766,
0x6767,0x676B,0x676C,0x676E,0x6771,0x6774,0x6776,     0,
0x6778,0x6779,0x677A,0x677B,0x677D,0x6780,0x6782,0x6783,
0x6785,0x6786,0x6788,0x678A,0x678C,0x678D,0x678E,0x678F,
0x6791,0x6792,0x6793,0x6794,0x6796,0x6799,0x679B,0x679F,
0x67A0,0x67A1,0x67A4,0x67A6,0x67A9,0x67AC,0x67AE,0x67B1,
0x67B2,0x67B4,0x67B9,0x67BA,0x67BB,0x67BC,0x67BD,0x67BE,
0x67BF,0x67C0,0x67C2,0x67C5,0x67C6,0x67C7,0x67C8,0x67C9,
0x67CA,0x67CB,0x67CC,0x67CD,0x67CE,0x67D5,0x67D6,0x67D7,
0x67DB,0x67DF,0x67E1,0x67E3,0x67E4,0x67E6,0x67E7,0x67E8,
0x67EA,0x67EB,0x67ED,0x67EE,0x67F2,0x67F5,0x67F6,0x67F7,
0x67F8,0x67F9,0x67FA,0x67FB,0x67FC,0x67FE,0x6801,0x6802,
0x6803,0x6804,0x6806,0x680D,0x6810,0x6812,0x6814,0x6815,
0x6818,0x6819,0x681A,0x681B,0x681C,0x681E,0x681F,0x6820,
0x6822,0x6823,0x6824,0x6825,0x6826,0x6827,0x6828,0x682B,
0x682C,0x682D,0x682E,0x682F,0x6830,0x6831,0x6834,0x6835,
0x6836,0x683A,0x683B,0x683F,0x6847,0x684B,0x684D,0x684F,
0x6852,0x6856,0x6857,0x6858,0x6859,0x685A,0x685B,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x685C,0x685D,0x685E,0x685F,0x686A,0x686C,0x686D,0x686E,
0x686F,0x6870,0x6871,0x6872,0x6873,0x6875,0x6878,0x6879,
0x687A,0x687B,0x687C,0x687D,0x687E,0x687F,0x6880,0x6882,
0x6884,0x6887,0x6888,0x6889,0x688A,0x688B,0x688C,0x688D,
0x688E,0x6890,0x6891,0x6892,0x6894,0x6895,0x6896,0x6898,
0x6899,0x689A,0x689B,0x689C,0x689D,0x689E,0x689F,0x68A0,
0x68A1,0x68A3,0x68A4,0x68A5,0x68A9,0x68AA,0x68AB,0x68AC,
0x68AE,0x68B1,0x68B2,0x68B4,0x68B6,0x68B7,0x68B8,     0,
0x68B9,0x68BA,0x68BB,0x68BC,0x68BD,0x68BE,0x68BF,0x68C1,
0x68C3,0x68C4,0x68C5,0x68C6,0x68C7,0x68C8,0x68CA,0x68CC,
0x68CE,0x68CF,0x68D0,0x68D1,0x68D3,0x68D4,0x68D6,0x68D7,
0x68D9,0x68DB,0x68DC,0x68DD,0x68DE,0x68DF,0x68E1,0x68E2,
0x68E4,0x68E5,0x68E6,0x68E7,0x68E8,0x68E9,0x68EA,0x68EB,
0x68EC,0x68ED,0x68EF,0x68F2,0x68F3,0x68F4,0x68F6,0x68F7,
0x68F8,0x68FB,0x68FD,0x68FE,0x68FF,0x6900,0x6902,0x6903,
0x6904,0x6906,0x6907,0x6908,0x6909,0x690A,0x690C,0x690F,
0x6911,0x6913,0x6914,0x6915,0x6916,0x6917,0x6918,0x6919,
0x691A,0x691B,0x691C,0x691D,0x691E,0x6921,0x6922,0x6923,
0x6925,0x6926,0x6927,0x6928,0x6929,0x692A,0x692B,0x692C,
0x692E,0x692F,0x6931,0x6932,0x6933,0x6935,0x6936,0x6937,
0x6938,0x693A,0x693B,0x693C,0x693E,0x6940,0x6941,0x6943,
0x6944,0x6945,0x6946,0x6947,0x6948,0x6949,0x694A,0x694B,
0x694C,0x694D,0x694E,0x694F,0x6950,0x6951,0x6952,0x6953,
0x6955,0x6956,0x6958,0x6959,0x695B,0x695C,0x695F,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6961,0x6962,0x6964,0x6965,0x6967,0x6968,0x6969,0x696A,
0x696C,0x696D,0x696F,0x6970,0x6972,0x6973,0x6974,0x6975,
0x6976,0x697A,0x697B,0x697D,0x697E,0x697F,0x6981,0x6983,
0x6985,0x698A,0x698B,0x698C,0x698E,0x698F,0x6990,0x6991,
0x6992,0x6993,0x6996,0x6997,0x6999,0x699A,0x699D,0x699E,
0x699F,0x69A0,0x69A1,0x69A2,0x69A3,0x69A4,0x69A5,0x69A6,
0x69A9,0x69AA,0x69AC,0x69AE,0x69AF,0x69B0,0x69B2,0x69B3,
0x69B5,0x69B6,0x69B8,0x69B9,0x69BA,0x69BC,0x69BD,     0,
0x69BE,0x69BF,0x69C0,0x69C2,0x69C3,0x69C4,0x69C5,0x69C6,
0x69C7,0x69C8,0x69C9,0x69CB,0x69CD,0x69CF,0x69D1,0x69D2,
0x69D3,0x69D5,0x69D6,0x69D7,0x69D8,0x69D9,0x69DA,0x69DC,
0x69DD,0x69DE,0x69E1,0x69E2,0x69E3,0x69E4,0x69E5,0x69E6,
0x69E7,0x69E8,0x69E9,0x69EA,0x69EB,0x69EC,0x69EE,0x69EF,
0x69F0,0x69F1,0x69F3,0x69F4,0x69F5,0x69F6,0x69F7,0x69F8,
0x69F9,0x69FA,0x69FB,0x69FC,0x69FE,0x6A00,0x6A01,0x6A02,
0x6A03,0x6A04,0x6A05,0x6A06,0x6A07,0x6A08,0x6A09,0x6A0B,
0x6A0C,0x6A0D,0x6A0E,0x6A0F,0x6A10,0x6A11,0x6A12,0x6A13,
0x6A14,0x6A15,0x6A16,0x6A19,0x6A1A,0x6A1B,0x6A1C,0x6A1D,
0x6A1E,0x6A20,0x6A22,0x6A23,0x6A24,0x6A25,0x6A26,0x6A27,
0x6A29,0x6A2B,0x6A2C,0x6A2D,0x6A2E,0x6A30,0x6A32,0x6A33,
0x6A34,0x6A36,0x6A37,0x6A38,0x6A39,0x6A3A,0x6A3B,0x6A3C,
0x6A3F,0x6A40,0x6A41,0x6A42,0x6A43,0x6A45,0x6A46,0x6A48,
0x6A49,0x6A4A,0x6A4B,0x6A4C,0x6A4D,0x6A4E,0x6A4F,0x6A51,
0x6A52,0x6A53,0x6A54,0x6A55,0x6A56,0x6A57,0x6A5A,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6A5C,0x6A5D,0x6A5E,0x6A5F,0x6A60,0x6A62,0x6A63,0x6A64,
0x6A66,0x6A67,0x6A68,0x6A69,0x6A6A,0x6A6B,0x6A6C,0x6A6D,
0x6A6E,0x6A6F,0x6A70,0x6A72,0x6A73,0x6A74,0x6A75,0x6A76,
0x6A77,0x6A78,0x6A7A,0x6A7B,0x6A7D,0x6A7E,0x6A7F,0x6A81,
0x6A82,0x6A83,0x6A85,0x6A86,0x6A87,0x6A88,0x6A89,0x6A8A,
0x6A8B,0x6A8C,0x6A8D,0x6A8F,0x6A92,0x6A93,0x6A94,0x6A95,
0x6A96,0x6A98,0x6A99,0x6A9A,0x6A9B,0x6A9C,0x6A9D,0x6A9E,
0x6A9F,0x6AA1,0x6AA2,0x6AA3,0x6AA4,0x6AA5,0x6AA6,     0,
0x6AA7,0x6AA8,0x6AAA,0x6AAD,0x6AAE,0x6AAF,0x6AB0,0x6AB1,
0x6AB2,0x6AB3,0x6AB4,0x6AB5,0x6AB6,0x6AB7,0x6AB8,0x6AB9,
0x6ABA,0x6ABB,0x6ABC,0x6ABD,0x6ABE,0x6ABF,0x6AC0,0x6AC1,
0x6AC2,0x6AC3,0x6AC4,0x6AC5,0x6AC6,0x6AC7,0x6AC8,0x6AC9,
0x6ACA,0x6ACB,0x6ACC,0x6ACD,0x6ACE,0x6ACF,0x6AD0,0x6AD1,
0x6AD2,0x6AD3,0x6AD4,0x6AD5,0x6AD6,0x6AD7,0x6AD8,0x6AD9,
0x6ADA,0x6ADB,0x6ADC,0x6ADD,0x6ADE,0x6ADF,0x6AE0,0x6AE1,
0x6AE2,0x6AE3,0x6AE4,0x6AE5,0x6AE6,0x6AE7,0x6AE8,0x6AE9,
0x6AEA,0x6AEB,0x6AEC,0x6AED,0x6AEE,0x6AEF,0x6AF0,0x6AF1,
0x6AF2,0x6AF3,0x6AF4,0x6AF5,0x6AF6,0x6AF7,0x6AF8,0x6AF9,
0x6AFA,0x6AFB,0x6AFC,0x6AFD,0x6AFE,0x6AFF,0x6B00,0x6B01,
0x6B02,0x6B03,0x6B04,0x6B05,0x6B06,0x6B07,0x6B08,0x6B09,
0x6B0A,0x6B0B,0x6B0C,0x6B0D,0x6B0E,0x6B0F,0x6B10,0x6B11,
0x6B12,0x6B13,0x6B14,0x6B15,0x6B16,0x6B17,0x6B18,0x6B19,
0x6B1A,0x6B1B,0x6B1C,0x6B1D,0x6B1E,0x6B1F,0x6B25,0x6B26,
0x6B28,0x6B29,0x6B2A,0x6B2B,0x6B2C,0x6B2D,0x6B2E,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6B2F,0x6B30,0x6B31,0x6B33,0x6B34,0x6B35,0x6B36,0x6B38,
0x6B3B,0x6B3C,0x6B3D,0x6B3F,0x6B40,0x6B41,0x6B42,0x6B44,
0x6B45,0x6B48,0x6B4A,0x6B4B,0x6B4D,0x6B4E,0x6B4F,0x6B50,
0x6B51,0x6B52,0x6B53,0x6B54,0x6B55,0x6B56,0x6B57,0x6B58,
0x6B5A,0x6B5B,0x6B5C,0x6B5D,0x6B5E,0x6B5F,0x6B60,0x6B61,
0x6B68,0x6B69,0x6B6B,0x6B6C,0x6B6D,0x6B6E,0x6B6F,0x6B70,
0x6B71,0x6B72,0x6B73,0x6B74,0x6B75,0x6B76,0x6B77,0x6B78,
0x6B7A,0x6B7D,0x6B7E,0x6B7F,0x6B80,0x6B85,0x6B88,     0,
0x6B8C,0x6B8E,0x6B8F,0x6B90,0x6B91,0x6B94,0x6B95,0x6B97,
0x6B98,0x6B99,0x6B9C,0x6B9D,0x6B9E,0x6B9F,0x6BA0,0x6BA2,
0x6BA3,0x6BA4,0x6BA5,0x6BA6,0x6BA7,0x6BA8,0x6BA9,0x6BAB,
0x6BAC,0x6BAD,0x6BAE,0x6BAF,0x6BB0,0x6BB1,0x6BB2,0x6BB6,
0x6BB8,0x6BB9,0x6BBA,0x6BBB,0x6BBC,0x6BBD,0x6BBE,0x6BC0,
0x6BC3,0x6BC4,0x6BC6,0x6BC7,0x6BC8,0x6BC9,0x6BCA,0x6BCC,
0x6BCE,0x6BD0,0x6BD1,0x6BD8,0x6BDA,0x6BDC,0x6BDD,0x6BDE,
0x6BDF,0x6BE0,0x6BE2,0x6BE3,0x6BE4,0x6BE5,0x6BE6,0x6BE7,
0x6BE8,0x6BE9,0x6BEC,0x6BED,0x6BEE,0x6BF0,0x6BF1,0x6BF2,
0x6BF4,0x6BF6,0x6BF7,0x6BF8,0x6BFA,0x6BFB,0x6BFC,0x6BFE,
0x6BFF,0x6C00,0x6C01,0x6C02,0x6C03,0x6C04,0x6C08,0x6C09,
0x6C0A,0x6C0B,0x6C0C,0x6C0E,0x6C12,0x6C17,0x6C1C,0x6C1D,
0x6C1E,0x6C20,0x6C23,0x6C25,0x6C2B,0x6C2C,0x6C2D,0x6C31,
0x6C33,0x6C36,0x6C37,0x6C39,0x6C3A,0x6C3B,0x6C3C,0x6C3E,
0x6C3F,0x6C43,0x6C44,0x6C45,0x6C48,0x6C4B,0x6C4C,0x6C4D,
0x6C4E,0x6C4F,0x6C51,0x6C52,0x6C53,0x6C56,0x6C58,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6C59,0x6C5A,0x6C62,0x6C63,0x6C65,0x6C66,0x6C67,0x6C6B,
0x6C6C,0x6C6D,0x6C6E,0x6C6F,0x6C71,0x6C73,0x6C75,0x6C77,
0x6C78,0x6C7A,0x6C7B,0x6C7C,0x6C7F,0x6C80,0x6C84,0x6C87,
0x6C8A,0x6C8B,0x6C8D,0x6C8E,0x6C91,0x6C92,0x6C95,0x6C96,
0x6C97,0x6C98,0x6C9A,0x6C9C,0x6C9D,0x6C9E,0x6CA0,0x6CA2,
0x6CA8,0x6CAC,0x6CAF,0x6CB0,0x6CB4,0x6CB5,0x6CB6,0x6CB7,
0x6CBA,0x6CC0,0x6CC1,0x6CC2,0x6CC3,0x6CC6,0x6CC7,0x6CC8,
0x6CCB,0x6CCD,0x6CCE,0x6CCF,0x6CD1,0x6CD2,0x6CD8,     0,
0x6CD9,0x6CDA,0x6CDC,0x6CDD,0x6CDF,0x6CE4,0x6CE6,0x6CE7,
0x6CE9,0x6CEC,0x6CED,0x6CF2,0x6CF4,0x6CF9,0x6CFF,0x6D00,
0x6D02,0x6D03,0x6D05,0x6D06,0x6D08,0x6D09,0x6D0A,0x6D0D,
0x6D0F,0x6D10,0x6D11,0x6D13,0x6D14,0x6D15,0x6D16,0x6D18,
0x6D1C,0x6D1D,0x6D1F,0x6D20,0x6D21,0x6D22,0x6D23,0x6D24,
0x6D26,0x6D28,0x6D29,0x6D2C,0x6D2D,0x6D2F,0x6D30,0x6D34,
0x6D36,0x6D37,0x6D38,0x6D3A,0x6D3F,0x6D40,0x6D42,0x6D44,
0x6D49,0x6D4C,0x6D50,0x6D55,0x6D56,0x6D57,0x6D58,0x6D5B,
0x6D5D,0x6D5F,0x6D61,0x6D62,0x6D64,0x6D65,0x6D67,0x6D68,
0x6D6B,0x6D6C,0x6D6D,0x6D70,0x6D71,0x6D72,0x6D73,0x6D75,
0x6D76,0x6D79,0x6D7A,0x6D7B,0x6D7D,0x6D7E,0x6D7F,0x6D80,
0x6D81,0x6D83,0x6D84,0x6D86,0x6D87,0x6D8A,0x6D8B,0x6D8D,
0x6D8F,0x6D90,0x6D92,0x6D96,0x6D97,0x6D98,0x6D99,0x6D9A,
0x6D9C,0x6DA2,0x6DA5,0x6DAC,0x6DAD,0x6DB0,0x6DB1,0x6DB3,
0x6DB4,0x6DB6,0x6DB7,0x6DB9,0x6DBA,0x6DBB,0x6DBC,0x6DBD,
0x6DBE,0x6DC1,0x6DC2,0x6DC3,0x6DC8,0x6DC9,0x6DCA,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6DCD,0x6DCE,0x6DCF,0x6DD0,0x6DD2,0x6DD3,0x6DD4,0x6DD5,
0x6DD7,0x6DDA,0x6DDB,0x6DDC,0x6DDF,0x6DE2,0x6DE3,0x6DE5,
0x6DE7,0x6DE8,0x6DE9,0x6DEA,0x6DED,0x6DEF,0x6DF0,0x6DF2,
0x6DF4,0x6DF5,0x6DF6,0x6DF8,0x6DFA,0x6DFD,0x6DFE,0x6DFF,
0x6E00,0x6E01,0x6E02,0x6E03,0x6E04,0x6E06,0x6E07,0x6E08,
0x6E09,0x6E0B,0x6E0F,0x6E12,0x6E13,0x6E15,0x6E18,0x6E19,
0x6E1B,0x6E1C,0x6E1E,0x6E1F,0x6E22,0x6E26,0x6E27,0x6E28,
0x6E2A,0x6E2C,0x6E2E,0x6E30,0x6E31,0x6E33,0x6E35,     0,
0x6E36,0x6E37,0x6E39,0x6E3B,0x6E3C,0x6E3D,0x6E3E,0x6E3F,
0x6E40,0x6E41,0x6E42,0x6E45,0x6E46,0x6E47,0x6E48,0x6E49,
0x6E4A,0x6E4B,0x6E4C,0x6E4F,0x6E50,0x6E51,0x6E52,0x6E55,
0x6E57,0x6E59,0x6E5A,0x6E5C,0x6E5D,0x6E5E,0x6E60,0x6E61,
0x6E62,0x6E63,0x6E64,0x6E65,0x6E66,0x6E67,0x6E68,0x6E69,
0x6E6A,0x6E6C,0x6E6D,0x6E6F,0x6E70,0x6E71,0x6E72,0x6E73,
0x6E74,0x6E75,0x6E76,0x6E77,0x6E78,0x6E79,0x6E7A,0x6E7B,
0x6E7C,0x6E7D,0x6E80,0x6E81,0x6E82,0x6E84,0x6E87,0x6E88,
0x6E8A,0x6E8B,0x6E8C,0x6E8D,0x6E8E,0x6E91,0x6E92,0x6E93,
0x6E94,0x6E95,0x6E96,0x6E97,0x6E99,0x6E9A,0x6E9B,0x6E9D,
0x6E9E,0x6EA0,0x6EA1,0x6EA3,0x6EA4,0x6EA6,0x6EA8,0x6EA9,
0x6EAB,0x6EAC,0x6EAD,0x6EAE,0x6EB0,0x6EB3,0x6EB5,0x6EB8,
0x6EB9,0x6EBC,0x6EBE,0x6EBF,0x6EC0,0x6EC3,0x6EC4,0x6EC5,
0x6EC6,0x6EC8,0x6EC9,0x6ECA,0x6ECC,0x6ECD,0x6ECE,0x6ED0,
0x6ED2,0x6ED6,0x6ED8,0x6ED9,0x6EDB,0x6EDC,0x6EDD,0x6EE3,
0x6EE7,0x6EEA,0x6EEB,0x6EEC,0x6EED,0x6EEE,0x6EEF,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6EF0,0x6EF1,0x6EF2,0x6EF3,0x6EF5,0x6EF6,0x6EF7,0x6EF8,
0x6EFA,0x6EFB,0x6EFC,0x6EFD,0x6EFE,0x6EFF,0x6F00,0x6F01,
0x6F03,0x6F04,0x6F05,0x6F07,0x6F08,0x6F0A,0x6F0B,0x6F0C,
0x6F0D,0x6F0E,0x6F10,0x6F11,0x6F12,0x6F16,0x6F17,0x6F18,
0x6F19,0x6F1A,0x6F1B,0x6F1C,0x6F1D,0x6F1E,0x6F1F,0x6F21,
0x6F22,0x6F23,0x6F25,0x6F26,0x6F27,0x6F28,0x6F2C,0x6F2E,
0x6F30,0x6F32,0x6F34,0x6F35,0x6F37,0x6F38,0x6F39,0x6F3A,
0x6F3B,0x6F3C,0x6F3D,0x6F3F,0x6F40,0x6F41,0x6F42,     0,
0x6F43,0x6F44,0x6F45,0x6F48,0x6F49,0x6F4A,0x6F4C,0x6F4E,
0x6F4F,0x6F50,0x6F51,0x6F52,0x6F53,0x6F54,0x6F55,0x6F56,
0x6F57,0x6F59,0x6F5A,0x6F5B,0x6F5D,0x6F5F,0x6F60,0x6F61,
0x6F63,0x6F64,0x6F65,0x6F67,0x6F68,0x6F69,0x6F6A,0x6F6B,
0x6F6C,0x6F6F,0x6F70,0x6F71,0x6F73,0x6F75,0x6F76,0x6F77,
0x6F79,0x6F7B,0x6F7D,0x6F7E,0x6F7F,0x6F80,0x6F81,0x6F82,
0x6F83,0x6F85,0x6F86,0x6F87,0x6F8A,0x6F8B,0x6F8F,0x6F90,
0x6F91,0x6F92,0x6F93,0x6F94,0x6F95,0x6F96,0x6F97,0x6F98,
0x6F99,0x6F9A,0x6F9B,0x6F9D,0x6F9E,0x6F9F,0x6FA0,0x6FA2,
0x6FA3,0x6FA4,0x6FA5,0x6FA6,0x6FA8,0x6FA9,0x6FAA,0x6FAB,
0x6FAC,0x6FAD,0x6FAE,0x6FAF,0x6FB0,0x6FB1,0x6FB2,0x6FB4,
0x6FB5,0x6FB7,0x6FB8,0x6FBA,0x6FBB,0x6FBC,0x6FBD,0x6FBE,
0x6FBF,0x6FC1,0x6FC3,0x6FC4,0x6FC5,0x6FC6,0x6FC7,0x6FC8,
0x6FCA,0x6FCB,0x6FCC,0x6FCD,0x6FCE,0x6FCF,0x6FD0,0x6FD3,
0x6FD4,0x6FD5,0x6FD6,0x6FD7,0x6FD8,0x6FD9,0x6FDA,0x6FDB,
0x6FDC,0x6FDD,0x6FDF,0x6FE2,0x6FE3,0x6FE4,0x6FE5,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x6FE6,0x6FE7,0x6FE8,0x6FE9,0x6FEA,0x6FEB,0x6FEC,0x6FED,
0x6FF0,0x6FF1,0x6FF2,0x6FF3,0x6FF4,0x6FF5,0x6FF6,0x6FF7,
0x6FF8,0x6FF9,0x6FFA,0x6FFB,0x6FFC,0x6FFD,0x6FFE,0x6FFF,
0x7000,0x7001,0x7002,0x7003,0x7004,0x7005,0x7006,0x7007,
0x7008,0x7009,0x700A,0x700B,0x700C,0x700D,0x700E,0x700F,
0x7010,0x7012,0x7013,0x7014,0x7015,0x7016,0x7017,0x7018,
0x7019,0x701C,0x701D,0x701E,0x701F,0x7020,0x7021,0x7022,
0x7024,0x7025,0x7026,0x7027,0x7028,0x7029,0x702A,     0,
0x702B,0x702C,0x702D,0x702E,0x702F,0x7030,0x7031,0x7032,
0x7033,0x7034,0x7036,0x7037,0x7038,0x703A,0x703B,0x703C,
0x703D,0x703E,0x703F,0x7040,0x7041,0x7042,0x7043,0x7044,
0x7045,0x7046,0x7047,0x7048,0x7049,0x704A,0x704B,0x704D,
0x704E,0x7050,0x7051,0x7052,0x7053,0x7054,0x7055,0x7056,
0x7057,0x7058,0x7059,0x705A,0x705B,0x705C,0x705D,0x705F,
0x7060,0x7061,0x7062,0x7063,0x7064,0x7065,0x7066,0x7067,
0x7068,0x7069,0x706A,0x706E,0x7071,0x7072,0x7073,0x7074,
0x7077,0x7079,0x707A,0x707B,0x707D,0x7081,0x7082,0x7083,
0x7084,0x7086,0x7087,0x7088,0x708B,0x708C,0x708D,0x708F,
0x7090,0x7091,0x7093,0x7097,0x7098,0x709A,0x709B,0x709E,
0x709F,0x70A0,0x70A1,0x70A2,0x70A3,0x70A4,0x70A5,0x70A6,
0x70A7,0x70A8,0x70A9,0x70AA,0x70B0,0x70B2,0x70B4,0x70B5,
0x70B6,0x70BA,0x70BE,0x70BF,0x70C4,0x70C5,0x70C6,0x70C7,
0x70C9,0x70CB,0x70CC,0x70CD,0x70CE,0x70CF,0x70D0,0x70D1,
0x70D2,0x70D3,0x70D4,0x70D5,0x70D6,0x70D7,0x70DA,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x70DC,0x70DD,0x70DE,0x70E0,0x70E1,0x70E2,0x70E3,0x70E5,
0x70EA,0x70EE,0x70F0,0x70F1,0x70F2,0x70F3,0x70F4,0x70F5,
0x70F6,0x70F8,0x70FA,0x70FB,0x70FC,0x70FE,0x70FF,0x7100,
0x7101,0x7102,0x7103,0x7104,0x7105,0x7106,0x7107,0x7108,
0x710B,0x710C,0x710D,0x710E,0x710F,0x7111,0x7112,0x7114,
0x7117,0x711B,0x711C,0x711D,0x711E,0x711F,0x7120,0x7121,
0x7122,0x7123,0x7124,0x7125,0x7127,0x7128,0x7129,0x712A,
0x712B,0x712C,0x712D,0x712E,0x7132,0x7133,0x7134,     0,
0x7135,0x7137,0x7138,0x7139,0x713A,0x713B,0x713C,0x713D,
0x713E,0x713F,0x7140,0x7141,0x7142,0x7143,0x7144,0x7146,
0x7147,0x7148,0x7149,0x714B,0x714D,0x714F,0x7150,0x7151,
0x7152,0x7153,0x7154,0x7155,0x7156,0x7157,0x7158,0x7159,
0x715A,0x715B,0x715D,0x715F,0x7160,0x7161,0x7162,0x7163,
0x7165,0x7169,0x716A,0x716B,0x716C,0x716D,0x716F,0x7170,
0x7171,0x7174,0x7175,0x7176,0x7177,0x7179,0x717B,0x717C,
0x717E,0x717F,0x7180,0x7181,0x7182,0x7183,0x7185,0x7186,
0x7187,0x7188,0x7189,0x718B,0x718C,0x718D,0x718E,0x7190,
0x7191,0x7192,0x7193,0x7195,0x7196,0x7197,0x719A,0x719B,
0x719C,0x719D,0x719E,0x71A1,0x71A2,0x71A3,0x71A4,0x71A5,
0x71A6,0x71A7,0x71A9,0x71AA,0x71AB,0x71AD,0x71AE,0x71AF,
0x71B0,0x71B1,0x71B2,0x71B4,0x71B6,0x71B7,0x71B8,0x71BA,
0x71BB,0x71BC,0x71BD,0x71BE,0x71BF,0x71C0,0x71C1,0x71C2,
0x71C4,0x71C5,0x71C6,0x71C7,0x71C8,0x71C9,0x71CA,0x71CB,
0x71CC,0x71CD,0x71CF,0x71D0,0x71D1,0x71D2,0x71D3,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x71D6,0x71D7,0x71D8,0x71D9,0x71DA,0x71DB,0x71DC,0x71DD,
0x71DE,0x71DF,0x71E1,0x71E2,0x71E3,0x71E4,0x71E6,0x71E8,
0x71E9,0x71EA,0x71EB,0x71EC,0x71ED,0x71EF,0x71F0,0x71F1,
0x71F2,0x71F3,0x71F4,0x71F5,0x71F6,0x71F7,0x71F8,0x71FA,
0x71FB,0x71FC,0x71FD,0x71FE,0x71FF,0x7200,0x7201,0x7202,
0x7203,0x7204,0x7205,0x7207,0x7208,0x7209,0x720A,0x720B,
0x720C,0x720D,0x720E,0x720F,0x7210,0x7211,0x7212,0x7213,
0x7214,0x7215,0x7216,0x7217,0x7218,0x7219,0x721A,     0,
0x721B,0x721C,0x721E,0x721F,0x7220,0x7221,0x7222,0x7223,
0x7224,0x7225,0x7226,0x7227,0x7229,0x722B,0x722D,0x722E,
0x722F,0x7232,0x7233,0x7234,0x723A,0x723C,0x723E,0x7240,
0x7241,0x7242,0x7243,0x7244,0x7245,0x7246,0x7249,0x724A,
0x724B,0x724E,0x724F,0x7250,0x7251,0x7253,0x7254,0x7255,
0x7257,0x7258,0x725A,0x725C,0x725E,0x7260,0x7263,0x7264,
0x7265,0x7268,0x726A,0x726B,0x726C,0x726D,0x7270,0x7271,
0x7273,0x7274,0x7276,0x7277,0x7278,0x727B,0x727C,0x727D,
0x7282,0x7283,0x7285,0x7286,0x7287,0x7288,0x7289,0x728C,
0x728E,0x7290,0x7291,0x7293,0x7294,0x7295,0x7296,0x7297,
0x7298,0x7299,0x729A,0x729B,0x729C,0x729D,0x729E,0x72A0,
0x72A1,0x72A2,0x72A3,0x72A4,0x72A5,0x72A6,0x72A7,0x72A8,
0x72A9,0x72AA,0x72AB,0x72AE,0x72B1,0x72B2,0x72B3,0x72B5,
0x72BA,0x72BB,0x72BC,0x72BD,0x72BE,0x72BF,0x72C0,0x72C5,
0x72C6,0x72C7,0x72C9,0x72CA,0x72CB,0x72CC,0x72CF,0x72D1,
0x72D3,0x72D4,0x72D5,0x72D6,0x72D8,0x72DA,0x72DB,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x3000,0x3001,0x3002,0x00B7,0x02C9,0x02C7,0x00A8,
0x3003,0x3005,0x2014,0xFF5E,0x2016,0x2026,0x2018,0x2019,
0x201C,0x201D,0x3014,0x3015,0x3008,0x3009,0x300A,0x300B,
0x300C,0x300D,0x300E,0x300F,0x3016,0x3017,0x3010,0x3011,
0x00B1,0x00D7,0x00F7,0x2236,0x2227,0x2228,0x2211,0x220F,
0x222A,0x2229,0x2208,0x2237,0x221A,0x22A5,0x2225,0x2220,
0x2312,0x2299,0x222B,0x222E,0x2261,0x224C,0x2248,0x223D,
0x221D,0x2260,0x226E,0x226F,0x2264,0x2265,0x221E,0x2235,
0x2234,0x2642,0x2640,0x00B0,0x2032,0x2033,0x2103,0xFF04,
0x00A4,0xFFE0,0xFFE1,0x2030,0x00A7,0x2116,0x2606,0x2605,
0x25CB,0x25CF,0x25CE,0x25C7,0x25C6,0x25A1,0x25A0,0x25B3,
0x25B2,0x203B,0x2192,0x2190,0x2191,0x2193,0x3013,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,
0x2177,0x2178,0x2179,     0,     0,     0,     0,     0,
     0,0x2488,0x2489,0x248A,0x248B,0x248C,0x248D,0x248E,
0x248F,0x2490,0x2491,0x2492,0x2493,0x2494,0x2495,0x2496,
0x2497,0x2498,0x2499,0x249A,0x249B,0x2474,0x2475,0x2476,
0x2477,0x2478,0x2479,0x247A,0x247B,0x247C,0x247D,0x247E,
0x247F,0x2480,0x2481,0x2482,0x2483,0x2484,0x2485,0x2486,
0x2487,0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,
0x2467,0x2468,0x2469,     0,     0,0x3220,0x3221,0x3222,
0x3223,0x3224,0x3225,0x3226,0x3227,0x3228,0x3229,     0,
     0,0x2160,0x2161,0x2162,0x2163,0x2164,0x2165,0x2166,
0x2167,0x2168,0x2169,0x216A,0x216B,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0xFF01,0xFF02,0xFF03,0xFFE5,0xFF05,0xFF06,0xFF07,
0xFF08,0xFF09,0xFF0A,0xFF0B,0xFF0C,0xFF0D,0xFF0E,0xFF0F,
0xFF10,0xFF11,0xFF12,0xFF13,0xFF14,0xFF15,0xFF16,0xFF17,
0xFF18,0xFF19,0xFF1A,0xFF1B,0xFF1C,0xFF1D,0xFF1E,0xFF1F,
0xFF20,0xFF21,0xFF22,0xFF23,0xFF24,0xFF25,0xFF26,0xFF27,
0xFF28,0xFF29,0xFF2A,0xFF2B,0xFF2C,0xFF2D,0xFF2E,0xFF2F,
0xFF30,0xFF31,0xFF32,0xFF33,0xFF34,0xFF35,0xFF36,0xFF37,
0xFF38,0xFF39,0xFF3A,0xFF3B,0xFF3C,0xFF3D,0xFF3E,0xFF3F,
0xFF40,0xFF41,0xFF42,0xFF43,0xFF44,0xFF45,0xFF46,0xFF47,
0xFF48,0xFF49,0xFF4A,0xFF4B,0xFF4C,0xFF4D,0xFF4E,0xFF4F,
0xFF50,0xFF51,0xFF52,0xFF53,0xFF54,0xFF55,0xFF56,0xFF57,
0xFF58,0xFF59,0xFF5A,0xFF5B,0xFF5C,0xFF5D,0xFFE3,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x3041,0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,
0x3048,0x3049,0x304A,0x304B,0x304C,0x304D,0x304E,0x304F,
0x3050,0x3051,0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,
0x3058,0x3059,0x305A,0x305B,0x305C,0x305D,0x305E,0x305F,
0x3060,0x3061,0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,
0x3068,0x3069,0x306A,0x306B,0x306C,0x306D,0x306E,0x306F,
0x3070,0x3071,0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,
0x3078,0x3079,0x307A,0x307B,0x307C,0x307D,0x307E,0x307F,
0x3080,0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,
0x3088,0x3089,0x308A,0x308B,0x308C,0x308D,0x308E,0x308F,
0x3090,0x3091,0x3092,0x3093,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x30A1,0x30A2,0x30A3,0x30A4,0x30A5,0x30A6,0x30A7,
0x30A8,0x30A9,0x30AA,0x30AB,0x30AC,0x30AD,0x30AE,0x30AF,
0x30B0,0x30B1,0x30B2,0x30B3,0x30B4,0x30B5,0x30B6,0x30B7,
0x30B8,0x30B9,0x30BA,0x30BB,0x30BC,0x30BD,0x30BE,0x30BF,
0x30C0,0x30C1,0x30C2,0x30C3,0x30C4,0x30C5,0x30C6,0x30C7,
0x30C8,0x30C9,0x30CA,0x30CB,0x30CC,0x30CD,0x30CE,0x30CF,
0x30D0,0x30D1,0x30D2,0x30D3,0x30D4,0x30D5,0x30D6,0x30D7,
0x30D8,0x30D9,0x30DA,0x30DB,0x30DC,0x30DD,0x30DE,0x30DF,
0x30E0,0x30E1,0x30E2,0x30E3,0x30E4,0x30E5,0x30E6,0x30E7,
0x30E8,0x30E9,0x30EA,0x30EB,0x30EC,0x30ED,0x30EE,0x30EF,
0x30F0,0x30F1,0x30F2,0x30F3,0x30F4,0x30F5,0x30F6,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,
0x0398,0x0399,0x039A,0x039B,0x039C,0x039D,0x039E,0x039F,
0x03A0,0x03A1,0x03A3,0x03A4,0x03A5,0x03A6,0x03A7,0x03A8,
0x03A9,     0,     0,     0,     0,     0,     0,     0,
     0,0x03B1,0x03B2,0x03B3,0x03B4,0x03B5,0x03B6,0x03B7,
0x03B8,0x03B9,0x03BA,0x03BB,0x03BC,0x03BD,0x03BE,0x03BF,
0x03C0,0x03C1,0x03C3,0x03C4,0x03C5,0x03C6,0x03C7,0x03C8,
0x03C9,     0,     0,     0,     0,     0,     0,     0,
0xFE35,0xFE36,0xFE39,0xFE3A,0xFE3F,0xFE40,0xFE3D,0xFE3E,
0xFE41,0xFE42,0xFE43,0xFE44,     0,     0,0xFE3B,0xFE3C,
0xFE37,0xFE38,0xFE31,     0,0xFE33,0xFE34,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401,
0x0416,0x0417,0x0418,0x0419,0x041A,0x041B,0x041C,0x041D,
0x041E,0x041F,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,
0x0426,0x0427,0x0428,0x0429,0x042A,0x042B,0x042C,0x042D,
0x042E,0x042F,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451,
0x0436,0x0437,0x0438,0x0439,0x043A,0x043B,0x043C,0x043D,
0x043E,0x043F,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445,
0x0446,0x0447,0x0448,0x0449,0x044A,0x044B,0x044C,0x044D,
0x044E,0x044F,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x02CA,0x02CB,0x02D9,0x2013,0x2015,0x2025,0x2035,0x2105,
0x2109,0x2196,0x2197,0x2198,0x2199,0x2215,0x221F,0x2223,
0x2252,0x2266,0x2267,0x22BF,0x2550,0x2551,0x2552,0x2553,
0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255A,0x255B,
0x255C,0x255D,0x255E,0x255F,0x2560,0x2561,0x2562,0x2563,
0x2564,0x2565,0x2566,0x2567,0x2568,0x2569,0x256A,0x256B,
0x256C,0x256D,0x256E,0x256F,0x2570,0x2571,0x2572,0x2573,
0x2581,0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,     0,
0x2588,0x2589,0x258A,0x258B,0x258C,0x258D,0x258E,0x258F,
0x2593,0x2594,0x2595,0x25BC,0x25BD,0x25E2,0x25E3,0x25E4,
0x25E5,0x2609,0x2295,0x3012,0x301D,0x301E,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0x0101,0x00E1,0x01CE,0x00E0,0x0113,0x00E9,0x011B,
0x00E8,0x012B,0x00ED,0x01D0,0x00EC,0x014D,0x00F3,0x01D2,
0x00F2,0x016B,0x00FA,0x01D4,0x00F9,0x01D6,0x01D8,0x01DA,
0x01DC,0x00FC,0x00EA,0x0251,     0,0x0144,0x0148,     0,
0x0261,     0,     0,     0,     0,0x3105,0x3106,0x3107,
0x3108,0x3109,0x310A,0x310B,0x310C,0x310D,0x310E,0x310F,
0x3110,0x3111,0x3112,0x3113,0x3114,0x3115,0x3116,0x3117,
0x3118,0x3119,0x311A,0x311B,0x311C,0x311D,0x311E,0x311F,
0x3120,0x3121,0x3122,0x3123,0x3124,0x3125,0x3126,0x3127,
0x3128,0x3129,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x3021,0x3022,0x3023,0x3024,0x3025,0x3026,0x3027,0x3028,
0x3029,0x32A3,0x338E,0x338F,0x339C,0x339D,0x339E,0x33A1,
0x33C4,0x33CE,0x33D1,0x33D2,0x33D5,0xFE30,0xFFE2,0xFFE4,
     0,0x2121,0x3231,     0,0x2010,     0,     0,     0,
0x30FC,0x309B,0x309C,0x30FD,0x30FE,0x3006,0x309D,0x309E,
0xFE49,0xFE4A,0xFE4B,0xFE4C,0xFE4D,0xFE4E,0xFE4F,0xFE50,
0xFE51,0xFE52,0xFE54,0xFE55,0xFE56,0xFE57,0xFE59,0xFE5A,
0xFE5B,0xFE5C,0xFE5D,0xFE5E,0xFE5F,0xFE60,0xFE61,     0,
0xFE62,0xFE63,0xFE64,0xFE65,0xFE66,0xFE68,0xFE69,0xFE6A,
0xFE6B,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,0x3007,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,0x2500,0x2501,0x2502,0x2503,
0x2504,0x2505,0x2506,0x2507,0x2508,0x2509,0x250A,0x250B,
0x250C,0x250D,0x250E,0x250F,0x2510,0x2511,0x2512,0x2513,
0x2514,0x2515,0x2516,0x2517,0x2518,0x2519,0x251A,0x251B,
0x251C,0x251D,0x251E,0x251F,0x2520,0x2521,0x2522,0x2523,
0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,0x252A,0x252B,
0x252C,0x252D,0x252E,0x252F,0x2530,0x2531,0x2532,0x2533,
0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253A,0x253B,
0x253C,0x253D,0x253E,0x253F,0x2540,0x2541,0x2542,0x2543,
0x2544,0x2545,0x2546,0x2547,0x2548,0x2549,0x254A,0x254B,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x72DC,0x72DD,0x72DF,0x72E2,0x72E3,0x72E4,0x72E5,0x72E6,
0x72E7,0x72EA,0x72EB,0x72F5,0x72F6,0x72F9,0x72FD,0x72FE,
0x72FF,0x7300,0x7302,0x7304,0x7305,0x7306,0x7307,0x7308,
0x7309,0x730B,0x730C,0x730D,0x730F,0x7310,0x7311,0x7312,
0x7314,0x7318,0x7319,0x731A,0x731F,0x7320,0x7323,0x7324,
0x7326,0x7327,0x7328,0x732D,0x732F,0x7330,0x7332,0x7333,
0x7335,0x7336,0x733A,0x733B,0x733C,0x733D,0x7340,0x7341,
0x7342,0x7343,0x7344,0x7345,0x7346,0x7347,0x7348,     0,
0x7349,0x734A,0x734B,0x734C,0x734E,0x734F,0x7351,0x7353,
0x7354,0x7355,0x7356,0x7358,0x7359,0x735A,0x735B,0x735C,
0x735D,0x735E,0x735F,0x7361,0x7362,0x7363,0x7364,0x7365,
0x7366,0x7367,0x7368,0x7369,0x736A,0x736B,0x736E,0x7370,
0x7371,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7372,0x7373,0x7374,0x7375,0x7376,0x7377,0x7378,0x7379,
0x737A,0x737B,0x737C,0x737D,0x737F,0x7380,0x7381,0x7382,
0x7383,0x7385,0x7386,0x7388,0x738A,0x738C,0x738D,0x738F,
0x7390,0x7392,0x7393,0x7394,0x7395,0x7397,0x7398,0x7399,
0x739A,0x739C,0x739D,0x739E,0x73A0,0x73A1,0x73A3,0x73A4,
0x73A5,0x73A6,0x73A7,0x73A8,0x73AA,0x73AC,0x73AD,0x73B1,
0x73B4,0x73B5,0x73B6,0x73B8,0x73B9,0x73BC,0x73BD,0x73BE,
0x73BF,0x73C1,0x73C3,0x73C4,0x73C5,0x73C6,0x73C7,     0,
0x73CB,0x73CC,0x73CE,0x73D2,0x73D3,0x73D4,0x73D5,0x73D6,
0x73D7,0x73D8,0x73DA,0x73DB,0x73DC,0x73DD,0x73DF,0x73E1,
0x73E2,0x73E3,0x73E4,0x73E6,0x73E8,0x73EA,0x73EB,0x73EC,
0x73EE,0x73EF,0x73F0,0x73F1,0x73F3,0x73F4,0x73F5,0x73F6,
0x73F7,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x73F8,0x73F9,0x73FA,0x73FB,0x73FC,0x73FD,0x73FE,0x73FF,
0x7400,0x7401,0x7402,0x7404,0x7407,0x7408,0x740B,0x740C,
0x740D,0x740E,0x7411,0x7412,0x7413,0x7414,0x7415,0x7416,
0x7417,0x7418,0x7419,0x741C,0x741D,0x741E,0x741F,0x7420,
0x7421,0x7423,0x7424,0x7427,0x7429,0x742B,0x742D,0x742F,
0x7431,0x7432,0x7437,0x7438,0x7439,0x743A,0x743B,0x743D,
0x743E,0x743F,0x7440,0x7442,0x7443,0x7444,0x7445,0x7446,
0x7447,0x7448,0x7449,0x744A,0x744B,0x744C,0x744D,     0,
0x744E,0x744F,0x7450,0x7451,0x7452,0x7453,0x7454,0x7456,
0x7458,0x745D,0x7460,0x7461,0x7462,0x7463,0x7464,0x7465,
0x7466,0x7467,0x7468,0x7469,0x746A,0x746B,0x746C,0x746E,
0x746F,0x7471,0x7472,0x7473,0x7474,0x7475,0x7478,0x7479,
0x747A,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x747B,0x747C,0x747D,0x747F,0x7482,0x7484,0x7485,0x7486,
0x7488,0x7489,0x748A,0x748C,0x748D,0x748F,0x7491,0x7492,
0x7493,0x7494,0x7495,0x7496,0x7497,0x7498,0x7499,0x749A,
0x749B,0x749D,0x749F,0x74A0,0x74A1,0x74A2,0x74A3,0x74A4,
0x74A5,0x74A6,0x74AA,0x74AB,0x74AC,0x74AD,0x74AE,0x74AF,
0x74B0,0x74B1,0x74B2,0x74B3,0x74B4,0x74B5,0x74B6,0x74B7,
0x74B8,0x74B9,0x74BB,0x74BC,0x74BD,0x74BE,0x74BF,0x74C0,
0x74C1,0x74C2,0x74C3,0x74C4,0x74C5,0x74C6,0x74C7,     0,
0x74C8,0x74C9,0x74CA,0x74CB,0x74CC,0x74CD,0x74CE,0x74CF,
0x74D0,0x74D1,0x74D3,0x74D4,0x74D5,0x74D6,0x74D7,0x74D8,
0x74D9,0x74DA,0x74DB,0x74DD,0x74DF,0x74E1,0x74E5,0x74E7,
0x74E8,0x74E9,0x74EA,0x74EB,0x74EC,0x74ED,0x74F0,0x74F1,
0x74F2,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x74F3,0x74F5,0x74F8,0x74F9,0x74FA,0x74FB,0x74FC,0x74FD,
0x74FE,0x7500,0x7501,0x7502,0x7503,0x7505,0x7506,0x7507,
0x7508,0x7509,0x750A,0x750B,0x750C,0x750E,0x7510,0x7512,
0x7514,0x7515,0x7516,0x7517,0x751B,0x751D,0x751E,0x7520,
0x7521,0x7522,0x7523,0x7524,0x7526,0x7527,0x752A,0x752E,
0x7534,0x7536,0x7539,0x753C,0x753D,0x753F,0x7541,0x7542,
0x7543,0x7544,0x7546,0x7547,0x7549,0x754A,0x754D,0x7550,
0x7551,0x7552,0x7553,0x7555,0x7556,0x7557,0x7558,     0,
0x755D,0x755E,0x755F,0x7560,0x7561,0x7562,0x7563,0x7564,
0x7567,0x7568,0x7569,0x756B,0x756C,0x756D,0x756E,0x756F,
0x7570,0x7571,0x7573,0x7575,0x7576,0x7577,0x757A,0x757B,
0x757C,0x757D,0x757E,0x7580,0x7581,0x7582,0x7584,0x7585,
0x7587,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7588,0x7589,0x758A,0x758C,0x758D,0x758E,0x7590,0x7593,
0x7595,0x7598,0x759B,0x759C,0x759E,0x75A2,0x75A6,0x75A7,
0x75A8,0x75A9,0x75AA,0x75AD,0x75B6,0x75B7,0x75BA,0x75BB,
0x75BF,0x75C0,0x75C1,0x75C6,0x75CB,0x75CC,0x75CE,0x75CF,
0x75D0,0x75D1,0x75D3,0x75D7,0x75D9,0x75DA,0x75DC,0x75DD,
0x75DF,0x75E0,0x75E1,0x75E5,0x75E9,0x75EC,0x75ED,0x75EE,
0x75EF,0x75F2,0x75F3,0x75F5,0x75F6,0x75F7,0x75F8,0x75FA,
0x75FB,0x75FD,0x75FE,0x7602,0x7604,0x7606,0x7607,     0,
0x7608,0x7609,0x760B,0x760D,0x760E,0x760F,0x7611,0x7612,
0x7613,0x7614,0x7616,0x761A,0x761C,0x761D,0x761E,0x7621,
0x7623,0x7627,0x7628,0x762C,0x762E,0x762F,0x7631,0x7632,
0x7636,0x7637,0x7639,0x763A,0x763B,0x763D,0x7641,0x7642,
0x7644,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7645,0x7646,0x7647,0x7648,0x7649,0x764A,0x764B,0x764E,
0x764F,0x7650,0x7651,0x7652,0x7653,0x7655,0x7657,0x7658,
0x7659,0x765A,0x765B,0x765D,0x765F,0x7660,0x7661,0x7662,
0x7664,0x7665,0x7666,0x7667,0x7668,0x7669,0x766A,0x766C,
0x766D,0x766E,0x7670,0x7671,0x7672,0x7673,0x7674,0x7675,
0x7676,0x7677,0x7679,0x767A,0x767C,0x767F,0x7680,0x7681,
0x7683,0x7685,0x7689,0x768A,0x768C,0x768D,0x768F,0x7690,
0x7692,0x7694,0x7695,0x7697,0x7698,0x769A,0x769B,     0,
0x769C,0x769D,0x769E,0x769F,0x76A0,0x76A1,0x76A2,0x76A3,
0x76A5,0x76A6,0x76A7,0x76A8,0x76A9,0x76AA,0x76AB,0x76AC,
0x76AD,0x76AF,0x76B0,0x76B3,0x76B5,0x76B6,0x76B7,0x76B8,
0x76B9,0x76BA,0x76BB,0x76BC,0x76BD,0x76BE,0x76C0,0x76C1,
0x76C3,0x554A,0x963F,0x57C3,0x6328,0x54CE,0x5509,0x54C0,
0x7691,0x764C,0x853C,0x77EE,0x827E,0x788D,0x7231,0x9698,
0x978D,0x6C28,0x5B89,0x4FFA,0x6309,0x6697,0x5CB8,0x80FA,
0x6848,0x80AE,0x6602,0x76CE,0x51F9,0x6556,0x71AC,0x7FF1,
0x8884,0x50B2,0x5965,0x61CA,0x6FB3,0x82AD,0x634C,0x6252,
0x53ED,0x5427,0x7B06,0x516B,0x75A4,0x5DF4,0x62D4,0x8DCB,
0x9776,0x628A,0x8019,0x575D,0x9738,0x7F62,0x7238,0x767D,
0x67CF,0x767E,0x6446,0x4F70,0x8D25,0x62DC,0x7A17,0x6591,
0x73ED,0x642C,0x6273,0x822C,0x9881,0x677F,0x7248,0x626E,
0x62CC,0x4F34,0x74E3,0x534A,0x529E,0x7ECA,0x90A6,0x5E2E,
0x6886,0x699C,0x8180,0x7ED1,0x68D2,0x78C5,0x868C,0x9551,
0x508D,0x8C24,0x82DE,0x80DE,0x5305,0x8912,0x5265,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x76C4,0x76C7,0x76C9,0x76CB,0x76CC,0x76D3,0x76D5,0x76D9,
0x76DA,0x76DC,0x76DD,0x76DE,0x76E0,0x76E1,0x76E2,0x76E3,
0x76E4,0x76E6,0x76E7,0x76E8,0x76E9,0x76EA,0x76EB,0x76EC,
0x76ED,0x76F0,0x76F3,0x76F5,0x76F6,0x76F7,0x76FA,0x76FB,
0x76FD,0x76FF,0x7700,0x7702,0x7703,0x7705,0x7706,0x770A,
0x770C,0x770E,0x770F,0x7710,0x7711,0x7712,0x7713,0x7714,
0x7715,0x7716,0x7717,0x7718,0x771B,0x771C,0x771D,0x771E,
0x7721,0x7723,0x7724,0x7725,0x7727,0x772A,0x772B,     0,
0x772C,0x772E,0x7730,0x7731,0x7732,0x7733,0x7734,0x7739,
0x773B,0x773D,0x773E,0x773F,0x7742,0x7744,0x7745,0x7746,
0x7748,0x7749,0x774A,0x774B,0x774C,0x774D,0x774E,0x774F,
0x7752,0x7753,0x7754,0x7755,0x7756,0x7757,0x7758,0x7759,
0x775C,0x8584,0x96F9,0x4FDD,0x5821,0x9971,0x5B9D,0x62B1,
0x62A5,0x66B4,0x8C79,0x9C8D,0x7206,0x676F,0x7891,0x60B2,
0x5351,0x5317,0x8F88,0x80CC,0x8D1D,0x94A1,0x500D,0x72C8,
0x5907,0x60EB,0x7119,0x88AB,0x5954,0x82EF,0x672C,0x7B28,
0x5D29,0x7EF7,0x752D,0x6CF5,0x8E66,0x8FF8,0x903C,0x9F3B,
0x6BD4,0x9119,0x7B14,0x5F7C,0x78A7,0x84D6,0x853D,0x6BD5,
0x6BD9,0x6BD6,0x5E01,0x5E87,0x75F9,0x95ED,0x655D,0x5F0A,
0x5FC5,0x8F9F,0x58C1,0x81C2,0x907F,0x965B,0x97AD,0x8FB9,
0x7F16,0x8D2C,0x6241,0x4FBF,0x53D8,0x535E,0x8FA8,0x8FA9,
0x8FAB,0x904D,0x6807,0x5F6A,0x8198,0x8868,0x9CD6,0x618B,
0x522B,0x762A,0x5F6C,0x658C,0x6FD2,0x6EE8,0x5BBE,0x6448,
0x5175,0x51B0,0x67C4,0x4E19,0x79C9,0x997C,0x70B3,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x775D,0x775E,0x775F,0x7760,0x7764,0x7767,0x7769,0x776A,
0x776D,0x776E,0x776F,0x7770,0x7771,0x7772,0x7773,0x7774,
0x7775,0x7776,0x7777,0x7778,0x777A,0x777B,0x777C,0x7781,
0x7782,0x7783,0x7786,0x7787,0x7788,0x7789,0x778A,0x778B,
0x778F,0x7790,0x7793,0x7794,0x7795,0x7796,0x7797,0x7798,
0x7799,0x779A,0x779B,0x779C,0x779D,0x779E,0x77A1,0x77A3,
0x77A4,0x77A6,0x77A8,0x77AB,0x77AD,0x77AE,0x77AF,0x77B1,
0x77B2,0x77B4,0x77B6,0x77B7,0x77B8,0x77B9,0x77BA,     0,
0x77BC,0x77BE,0x77C0,0x77C1,0x77C2,0x77C3,0x77C4,0x77C5,
0x77C6,0x77C7,0x77C8,0x77C9,0x77CA,0x77CB,0x77CC,0x77CE,
0x77CF,0x77D0,0x77D1,0x77D2,0x77D3,0x77D4,0x77D5,0x77D6,
0x77D8,0x77D9,0x77DA,0x77DD,0x77DE,0x77DF,0x77E0,0x77E1,
0x77E4,0x75C5,0x5E76,0x73BB,0x83E0,0x64AD,0x62E8,0x94B5,
0x6CE2,0x535A,0x52C3,0x640F,0x94C2,0x7B94,0x4F2F,0x5E1B,
0x8236,0x8116,0x818A,0x6E24,0x6CCA,0x9A73,0x6355,0x535C,
0x54FA,0x8865,0x57E0,0x4E0D,0x5E03,0x6B65,0x7C3F,0x90E8,
0x6016,0x64E6,0x731C,0x88C1,0x6750,0x624D,0x8D22,0x776C,
0x8E29,0x91C7,0x5F69,0x83DC,0x8521,0x9910,0x53C2,0x8695,
0x6B8B,0x60ED,0x60E8,0x707F,0x82CD,0x8231,0x4ED3,0x6CA7,
0x85CF,0x64CD,0x7CD9,0x69FD,0x66F9,0x8349,0x5395,0x7B56,
0x4FA7,0x518C,0x6D4B,0x5C42,0x8E6D,0x63D2,0x53C9,0x832C,
0x8336,0x67E5,0x78B4,0x643D,0x5BDF,0x5C94,0x5DEE,0x8BE7,
0x62C6,0x67F4,0x8C7A,0x6400,0x63BA,0x8749,0x998B,0x8C17,
0x7F20,0x94F2,0x4EA7,0x9610,0x98A4,0x660C,0x7316,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x77E6,0x77E8,0x77EA,0x77EF,0x77F0,0x77F1,0x77F2,0x77F4,
0x77F5,0x77F7,0x77F9,0x77FA,0x77FB,0x77FC,0x7803,0x7804,
0x7805,0x7806,0x7807,0x7808,0x780A,0x780B,0x780E,0x780F,
0x7810,0x7813,0x7815,0x7819,0x781B,0x781E,0x7820,0x7821,
0x7822,0x7824,0x7828,0x782A,0x782B,0x782E,0x782F,0x7831,
0x7832,0x7833,0x7835,0x7836,0x783D,0x783F,0x7841,0x7842,
0x7843,0x7844,0x7846,0x7848,0x7849,0x784A,0x784B,0x784D,
0x784F,0x7851,0x7853,0x7854,0x7858,0x7859,0x785A,     0,
0x785B,0x785C,0x785E,0x785F,0x7860,0x7861,0x7862,0x7863,
0x7864,0x7865,0x7866,0x7867,0x7868,0x7869,0x786F,0x7870,
0x7871,0x7872,0x7873,0x7874,0x7875,0x7876,0x7878,0x7879,
0x787A,0x787B,0x787D,0x787E,0x787F,0x7880,0x7881,0x7882,
0x7883,0x573A,0x5C1D,0x5E38,0x957F,0x507F,0x80A0,0x5382,
0x655E,0x7545,0x5531,0x5021,0x8D85,0x6284,0x949E,0x671D,
0x5632,0x6F6E,0x5DE2,0x5435,0x7092,0x8F66,0x626F,0x64A4,
0x63A3,0x5F7B,0x6F88,0x90F4,0x81E3,0x8FB0,0x5C18,0x6668,
0x5FF1,0x6C89,0x9648,0x8D81,0x886C,0x6491,0x79F0,0x57CE,
0x6A59,0x6210,0x5448,0x4E58,0x7A0B,0x60E9,0x6F84,0x8BDA,
0x627F,0x901E,0x9A8B,0x79E4,0x5403,0x75F4,0x6301,0x5319,
0x6C60,0x8FDF,0x5F1B,0x9A70,0x803B,0x9F7F,0x4F88,0x5C3A,
0x8D64,0x7FC5,0x65A5,0x70BD,0x5145,0x51B2,0x866B,0x5D07,
0x5BA0,0x62BD,0x916C,0x7574,0x8E0C,0x7A20,0x6101,0x7B79,
0x4EC7,0x7EF8,0x7785,0x4E11,0x81ED,0x521D,0x51FA,0x6A71,
0x53A8,0x8E87,0x9504,0x96CF,0x6EC1,0x9664,0x695A,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7884,0x7885,0x7886,0x7888,0x788A,0x788B,0x788F,0x7890,
0x7892,0x7894,0x7895,0x7896,0x7899,0x789D,0x789E,0x78A0,
0x78A2,0x78A4,0x78A6,0x78A8,0x78A9,0x78AA,0x78AB,0x78AC,
0x78AD,0x78AE,0x78AF,0x78B5,0x78B6,0x78B7,0x78B8,0x78BA,
0x78BB,0x78BC,0x78BD,0x78BF,0x78C0,0x78C2,0x78C3,0x78C4,
0x78C6,0x78C7,0x78C8,0x78CC,0x78CD,0x78CE,0x78CF,0x78D1,
0x78D2,0x78D3,0x78D6,0x78D7,0x78D8,0x78DA,0x78DB,0x78DC,
0x78DD,0x78DE,0x78DF,0x78E0,0x78E1,0x78E2,0x78E3,     0,
0x78E4,0x78E5,0x78E6,0x78E7,0x78E9,0x78EA,0x78EB,0x78ED,
0x78EE,0x78EF,0x78F0,0x78F1,0x78F3,0x78F5,0x78F6,0x78F8,
0x78F9,0x78FB,0x78FC,0x78FD,0x78FE,0x78FF,0x7900,0x7902,
0x7903,0x7904,0x7906,0x7907,0x7908,0x7909,0x790A,0x790B,
0x790C,0x7840,0x50A8,0x77D7,0x6410,0x89E6,0x5904,0x63E3,
0x5DDD,0x7A7F,0x693D,0x4F20,0x8239,0x5598,0x4E32,0x75AE,
0x7A97,0x5E62,0x5E8A,0x95EF,0x521B,0x5439,0x708A,0x6376,
0x9524,0x5782,0x6625,0x693F,0x9187,0x5507,0x6DF3,0x7EAF,
0x8822,0x6233,0x7EF0,0x75B5,0x8328,0x78C1,0x96CC,0x8F9E,
0x6148,0x74F7,0x8BCD,0x6B64,0x523A,0x8D50,0x6B21,0x806A,
0x8471,0x56F1,0x5306,0x4ECE,0x4E1B,0x51D1,0x7C97,0x918B,
0x7C07,0x4FC3,0x8E7F,0x7BE1,0x7A9C,0x6467,0x5D14,0x50AC,
0x8106,0x7601,0x7CB9,0x6DEC,0x7FE0,0x6751,0x5B58,0x5BF8,
0x78CB,0x64AE,0x6413,0x63AA,0x632B,0x9519,0x642D,0x8FBE,
0x7B54,0x7629,0x6253,0x5927,0x5446,0x6B79,0x50A3,0x6234,
0x5E26,0x6B86,0x4EE3,0x8D37,0x888B,0x5F85,0x902E,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x790D,0x790E,0x790F,0x7910,0x7911,0x7912,0x7914,0x7915,
0x7916,0x7917,0x7918,0x7919,0x791A,0x791B,0x791C,0x791D,
0x791F,0x7920,0x7921,0x7922,0x7923,0x7925,0x7926,0x7927,
0x7928,0x7929,0x792A,0x792B,0x792C,0x792D,0x792E,0x792F,
0x7930,0x7931,0x7932,0x7933,0x7935,0x7936,0x7937,0x7938,
0x7939,0x793D,0x793F,0x7942,0x7943,0x7944,0x7945,0x7947,
0x794A,0x794B,0x794C,0x794D,0x794E,0x794F,0x7950,0x7951,
0x7952,0x7954,0x7955,0x7958,0x7959,0x7961,0x7963,     0,
0x7964,0x7966,0x7969,0x796A,0x796B,0x796C,0x796E,0x7970,
0x7971,0x7972,0x7973,0x7974,0x7975,0x7976,0x7979,0x797B,
0x797C,0x797D,0x797E,0x797F,0x7982,0x7983,0x7986,0x7987,
0x7988,0x7989,0x798B,0x798C,0x798D,0x798E,0x7990,0x7991,
0x7992,0x6020,0x803D,0x62C5,0x4E39,0x5355,0x90F8,0x63B8,
0x80C6,0x65E6,0x6C2E,0x4F46,0x60EE,0x6DE1,0x8BDE,0x5F39,
0x86CB,0x5F53,0x6321,0x515A,0x8361,0x6863,0x5200,0x6363,
0x8E48,0x5012,0x5C9B,0x7977,0x5BFC,0x5230,0x7A3B,0x60BC,
0x9053,0x76D7,0x5FB7,0x5F97,0x7684,0x8E6C,0x706F,0x767B,
0x7B49,0x77AA,0x51F3,0x9093,0x5824,0x4F4E,0x6EF4,0x8FEA,
0x654C,0x7B1B,0x72C4,0x6DA4,0x7FDF,0x5AE1,0x62B5,0x5E95,
0x5730,0x8482,0x7B2C,0x5E1D,0x5F1F,0x9012,0x7F14,0x98A0,
0x6382,0x6EC7,0x7898,0x70B9,0x5178,0x975B,0x57AB,0x7535,
0x4F43,0x7538,0x5E97,0x60E6,0x5960,0x6DC0,0x6BBF,0x7889,
0x53FC,0x96D5,0x51CB,0x5201,0x6389,0x540A,0x9493,0x8C03,
0x8DCC,0x7239,0x789F,0x8776,0x8FED,0x8C0D,0x53E0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7993,0x7994,0x7995,0x7996,0x7997,0x7998,0x7999,0x799B,
0x799C,0x799D,0x799E,0x799F,0x79A0,0x79A1,0x79A2,0x79A3,
0x79A4,0x79A5,0x79A6,0x79A8,0x79A9,0x79AA,0x79AB,0x79AC,
0x79AD,0x79AE,0x79AF,0x79B0,0x79B1,0x79B2,0x79B4,0x79B5,
0x79B6,0x79B7,0x79B8,0x79BC,0x79BF,0x79C2,0x79C4,0x79C5,
0x79C7,0x79C8,0x79CA,0x79CC,0x79CE,0x79CF,0x79D0,0x79D3,
0x79D4,0x79D6,0x79D7,0x79D9,0x79DA,0x79DB,0x79DC,0x79DD,
0x79DE,0x79E0,0x79E1,0x79E2,0x79E5,0x79E8,0x79EA,     0,
0x79EC,0x79EE,0x79F1,0x79F2,0x79F3,0x79F4,0x79F5,0x79F6,
0x79F7,0x79F9,0x79FA,0x79FC,0x79FE,0x79FF,0x7A01,0x7A04,
0x7A05,0x7A07,0x7A08,0x7A09,0x7A0A,0x7A0C,0x7A0F,0x7A10,
0x7A11,0x7A12,0x7A13,0x7A15,0x7A16,0x7A18,0x7A19,0x7A1B,
0x7A1C,0x4E01,0x76EF,0x53EE,0x9489,0x9876,0x9F0E,0x952D,
0x5B9A,0x8BA2,0x4E22,0x4E1C,0x51AC,0x8463,0x61C2,0x52A8,
0x680B,0x4F97,0x606B,0x51BB,0x6D1E,0x515C,0x6296,0x6597,
0x9661,0x8C46,0x9017,0x75D8,0x90FD,0x7763,0x6BD2,0x728A,
0x72EC,0x8BFB,0x5835,0x7779,0x8D4C,0x675C,0x9540,0x809A,
0x5EA6,0x6E21,0x5992,0x7AEF,0x77ED,0x953B,0x6BB5,0x65AD,
0x7F0E,0x5806,0x5151,0x961F,0x5BF9,0x58A9,0x5428,0x8E72,
0x6566,0x987F,0x56E4,0x949D,0x76FE,0x9041,0x6387,0x54C6,
0x591A,0x593A,0x579B,0x8EB2,0x6735,0x8DFA,0x8235,0x5241,
0x60F0,0x5815,0x86FE,0x5CE8,0x9E45,0x4FC4,0x989D,0x8BB9,
0x5A25,0x6076,0x5384,0x627C,0x904F,0x9102,0x997F,0x6069,
0x800C,0x513F,0x8033,0x5C14,0x9975,0x6D31,0x4E8C,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7A1D,0x7A1F,0x7A21,0x7A22,0x7A24,0x7A25,0x7A26,0x7A27,
0x7A28,0x7A29,0x7A2A,0x7A2B,0x7A2C,0x7A2D,0x7A2E,0x7A2F,
0x7A30,0x7A31,0x7A32,0x7A34,0x7A35,0x7A36,0x7A38,0x7A3A,
0x7A3E,0x7A40,0x7A41,0x7A42,0x7A43,0x7A44,0x7A45,0x7A47,
0x7A48,0x7A49,0x7A4A,0x7A4B,0x7A4C,0x7A4D,0x7A4E,0x7A4F,
0x7A50,0x7A52,0x7A53,0x7A54,0x7A55,0x7A56,0x7A58,0x7A59,
0x7A5A,0x7A5B,0x7A5C,0x7A5D,0x7A5E,0x7A5F,0x7A60,0x7A61,
0x7A62,0x7A63,0x7A64,0x7A65,0x7A66,0x7A67,0x7A68,     0,
0x7A69,0x7A6A,0x7A6B,0x7A6C,0x7A6D,0x7A6E,0x7A6F,0x7A71,
0x7A72,0x7A73,0x7A75,0x7A7B,0x7A7C,0x7A7D,0x7A7E,0x7A82,
0x7A85,0x7A87,0x7A89,0x7A8A,0x7A8B,0x7A8C,0x7A8E,0x7A8F,
0x7A90,0x7A93,0x7A94,0x7A99,0x7A9A,0x7A9B,0x7A9E,0x7AA1,
0x7AA2,0x8D30,0x53D1,0x7F5A,0x7B4F,0x4F10,0x4E4F,0x9600,
0x6CD5,0x73D0,0x85E9,0x5E06,0x756A,0x7FFB,0x6A0A,0x77FE,
0x9492,0x7E41,0x51E1,0x70E6,0x53CD,0x8FD4,0x8303,0x8D29,
0x72AF,0x996D,0x6CDB,0x574A,0x82B3,0x65B9,0x80AA,0x623F,
0x9632,0x59A8,0x4EFF,0x8BBF,0x7EBA,0x653E,0x83F2,0x975E,
0x5561,0x98DE,0x80A5,0x532A,0x8BFD,0x5420,0x80BA,0x5E9F,
0x6CB8,0x8D39,0x82AC,0x915A,0x5429,0x6C1B,0x5206,0x7EB7,
0x575F,0x711A,0x6C7E,0x7C89,0x594B,0x4EFD,0x5FFF,0x6124,
0x7CAA,0x4E30,0x5C01,0x67AB,0x8702,0x5CF0,0x950B,0x98CE,
0x75AF,0x70FD,0x9022,0x51AF,0x7F1D,0x8BBD,0x5949,0x51E4,
0x4F5B,0x5426,0x592B,0x6577,0x80A4,0x5B75,0x6276,0x62C2,
0x8F90,0x5E45,0x6C1F,0x7B26,0x4F0F,0x4FD8,0x670D,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7AA3,0x7AA4,0x7AA7,0x7AA9,0x7AAA,0x7AAB,0x7AAE,0x7AAF,
0x7AB0,0x7AB1,0x7AB2,0x7AB4,0x7AB5,0x7AB6,0x7AB7,0x7AB8,
0x7AB9,0x7ABA,0x7ABB,0x7ABC,0x7ABD,0x7ABE,0x7AC0,0x7AC1,
0x7AC2,0x7AC3,0x7AC4,0x7AC5,0x7AC6,0x7AC7,0x7AC8,0x7AC9,
0x7ACA,0x7ACC,0x7ACD,0x7ACE,0x7ACF,0x7AD0,0x7AD1,0x7AD2,
0x7AD3,0x7AD4,0x7AD5,0x7AD7,0x7AD8,0x7ADA,0x7ADB,0x7ADC,
0x7ADD,0x7AE1,0x7AE2,0x7AE4,0x7AE7,0x7AE8,0x7AE9,0x7AEA,
0x7AEB,0x7AEC,0x7AEE,0x7AF0,0x7AF1,0x7AF2,0x7AF3,     0,
0x7AF4,0x7AF5,0x7AF6,0x7AF7,0x7AF8,0x7AFB,0x7AFC,0x7AFE,
0x7B00,0x7B01,0x7B02,0x7B05,0x7B07,0x7B09,0x7B0C,0x7B0D,
0x7B0E,0x7B10,0x7B12,0x7B13,0x7B16,0x7B17,0x7B18,0x7B1A,
0x7B1C,0x7B1D,0x7B1F,0x7B21,0x7B22,0x7B23,0x7B27,0x7B29,
0x7B2D,0x6D6E,0x6DAA,0x798F,0x88B1,0x5F17,0x752B,0x629A,
0x8F85,0x4FEF,0x91DC,0x65A7,0x812F,0x8151,0x5E9C,0x8150,
0x8D74,0x526F,0x8986,0x8D4B,0x590D,0x5085,0x4ED8,0x961C,
0x7236,0x8179,0x8D1F,0x5BCC,0x8BA3,0x9644,0x5987,0x7F1A,
0x5490,0x5676,0x560E,0x8BE5,0x6539,0x6982,0x9499,0x76D6,
0x6E89,0x5E72,0x7518,0x6746,0x67D1,0x7AFF,0x809D,0x8D76,
0x611F,0x79C6,0x6562,0x8D63,0x5188,0x521A,0x94A2,0x7F38,
0x809B,0x7EB2,0x5C97,0x6E2F,0x6760,0x7BD9,0x768B,0x9AD8,
0x818F,0x7F94,0x7CD5,0x641E,0x9550,0x7A3F,0x544A,0x54E5,
0x6B4C,0x6401,0x6208,0x9E3D,0x80F3,0x7599,0x5272,0x9769,
0x845B,0x683C,0x86E4,0x9601,0x9694,0x94EC,0x4E2A,0x5404,
0x7ED9,0x6839,0x8DDF,0x8015,0x66F4,0x5E9A,0x7FB9,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7B2F,0x7B30,0x7B32,0x7B34,0x7B35,0x7B36,0x7B37,0x7B39,
0x7B3B,0x7B3D,0x7B3F,0x7B40,0x7B41,0x7B42,0x7B43,0x7B44,
0x7B46,0x7B48,0x7B4A,0x7B4D,0x7B4E,0x7B53,0x7B55,0x7B57,
0x7B59,0x7B5C,0x7B5E,0x7B5F,0x7B61,0x7B63,0x7B64,0x7B65,
0x7B66,0x7B67,0x7B68,0x7B69,0x7B6A,0x7B6B,0x7B6C,0x7B6D,
0x7B6F,0x7B70,0x7B73,0x7B74,0x7B76,0x7B78,0x7B7A,0x7B7C,
0x7B7D,0x7B7F,0x7B81,0x7B82,0x7B83,0x7B84,0x7B86,0x7B87,
0x7B88,0x7B89,0x7B8A,0x7B8B,0x7B8C,0x7B8E,0x7B8F,     0,
0x7B91,0x7B92,0x7B93,0x7B96,0x7B98,0x7B99,0x7B9A,0x7B9B,
0x7B9E,0x7B9F,0x7BA0,0x7BA3,0x7BA4,0x7BA5,0x7BAE,0x7BAF,
0x7BB0,0x7BB2,0x7BB3,0x7BB5,0x7BB6,0x7BB7,0x7BB9,0x7BBA,
0x7BBB,0x7BBC,0x7BBD,0x7BBE,0x7BBF,0x7BC0,0x7BC2,0x7BC3,
0x7BC4,0x57C2,0x803F,0x6897,0x5DE5,0x653B,0x529F,0x606D,
0x9F9A,0x4F9B,0x8EAC,0x516C,0x5BAB,0x5F13,0x5DE9,0x6C5E,
0x62F1,0x8D21,0x5171,0x94A9,0x52FE,0x6C9F,0x82DF,0x72D7,
0x57A2,0x6784,0x8D2D,0x591F,0x8F9C,0x83C7,0x5495,0x7B8D,
0x4F30,0x6CBD,0x5B64,0x59D1,0x9F13,0x53E4,0x86CA,0x9AA8,
0x8C37,0x80A1,0x6545,0x987E,0x56FA,0x96C7,0x522E,0x74DC,
0x5250,0x5BE1,0x6302,0x8902,0x4E56,0x62D0,0x602A,0x68FA,
0x5173,0x5B98,0x51A0,0x89C2,0x7BA1,0x9986,0x7F50,0x60EF,
0x704C,0x8D2F,0x5149,0x5E7F,0x901B,0x7470,0x89C4,0x572D,
0x7845,0x5F52,0x9F9F,0x95FA,0x8F68,0x9B3C,0x8BE1,0x7678,
0x6842,0x67DC,0x8DEA,0x8D35,0x523D,0x8F8A,0x6EDA,0x68CD,
0x9505,0x90ED,0x56FD,0x679C,0x88F9,0x8FC7,0x54C8,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7BC5,0x7BC8,0x7BC9,0x7BCA,0x7BCB,0x7BCD,0x7BCE,0x7BCF,
0x7BD0,0x7BD2,0x7BD4,0x7BD5,0x7BD6,0x7BD7,0x7BD8,0x7BDB,
0x7BDC,0x7BDE,0x7BDF,0x7BE0,0x7BE2,0x7BE3,0x7BE4,0x7BE7,
0x7BE8,0x7BE9,0x7BEB,0x7BEC,0x7BED,0x7BEF,0x7BF0,0x7BF2,
0x7BF3,0x7BF4,0x7BF5,0x7BF6,0x7BF8,0x7BF9,0x7BFA,0x7BFB,
0x7BFD,0x7BFF,0x7C00,0x7C01,0x7C02,0x7C03,0x7C04,0x7C05,
0x7C06,0x7C08,0x7C09,0x7C0A,0x7C0D,0x7C0E,0x7C10,0x7C11,
0x7C12,0x7C13,0x7C14,0x7C15,0x7C17,0x7C18,0x7C19,     0,
0x7C1A,0x7C1B,0x7C1C,0x7C1D,0x7C1E,0x7C20,0x7C21,0x7C22,
0x7C23,0x7C24,0x7C25,0x7C28,0x7C29,0x7C2B,0x7C2C,0x7C2D,
0x7C2E,0x7C2F,0x7C30,0x7C31,0x7C32,0x7C33,0x7C34,0x7C35,
0x7C36,0x7C37,0x7C39,0x7C3A,0x7C3B,0x7C3C,0x7C3D,0x7C3E,
0x7C42,0x9AB8,0x5B69,0x6D77,0x6C26,0x4EA5,0x5BB3,0x9A87,
0x9163,0x61A8,0x90AF,0x97E9,0x542B,0x6DB5,0x5BD2,0x51FD,
0x558A,0x7F55,0x7FF0,0x64BC,0x634D,0x65F1,0x61BE,0x608D,
0x710A,0x6C57,0x6C49,0x592F,0x676D,0x822A,0x58D5,0x568E,
0x8C6A,0x6BEB,0x90DD,0x597D,0x8017,0x53F7,0x6D69,0x5475,
0x559D,0x8377,0x83CF,0x6838,0x79BE,0x548C,0x4F55,0x5408,
0x76D2,0x8C89,0x9602,0x6CB3,0x6DB8,0x8D6B,0x8910,0x9E64,
0x8D3A,0x563F,0x9ED1,0x75D5,0x5F88,0x72E0,0x6068,0x54FC,
0x4EA8,0x6A2A,0x8861,0x6052,0x8F70,0x54C4,0x70D8,0x8679,
0x9E3F,0x6D2A,0x5B8F,0x5F18,0x7EA2,0x5589,0x4FAF,0x7334,
0x543C,0x539A,0x5019,0x540E,0x547C,0x4E4E,0x5FFD,0x745A,
0x58F6,0x846B,0x80E1,0x8774,0x72D0,0x7CCA,0x6E56,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7C43,0x7C44,0x7C45,0x7C46,0x7C47,0x7C48,0x7C49,0x7C4A,
0x7C4B,0x7C4C,0x7C4E,0x7C4F,0x7C50,0x7C51,0x7C52,0x7C53,
0x7C54,0x7C55,0x7C56,0x7C57,0x7C58,0x7C59,0x7C5A,0x7C5B,
0x7C5C,0x7C5D,0x7C5E,0x7C5F,0x7C60,0x7C61,0x7C62,0x7C63,
0x7C64,0x7C65,0x7C66,0x7C67,0x7C68,0x7C69,0x7C6A,0x7C6B,
0x7C6C,0x7C6D,0x7C6E,0x7C6F,0x7C70,0x7C71,0x7C72,0x7C75,
0x7C76,0x7C77,0x7C78,0x7C79,0x7C7A,0x7C7E,0x7C7F,0x7C80,
0x7C81,0x7C82,0x7C83,0x7C84,0x7C85,0x7C86,0x7C87,     0,
0x7C88,0x7C8A,0x7C8B,0x7C8C,0x7C8D,0x7C8E,0x7C8F,0x7C90,
0x7C93,0x7C94,0x7C96,0x7C99,0x7C9A,0x7C9B,0x7CA0,0x7CA1,
0x7CA3,0x7CA6,0x7CA7,0x7CA8,0x7CA9,0x7CAB,0x7CAC,0x7CAD,
0x7CAF,0x7CB0,0x7CB4,0x7CB5,0x7CB6,0x7CB7,0x7CB8,0x7CBA,
0x7CBB,0x5F27,0x864E,0x552C,0x62A4,0x4E92,0x6CAA,0x6237,
0x82B1,0x54D7,0x534E,0x733E,0x6ED1,0x753B,0x5212,0x5316,
0x8BDD,0x69D0,0x5F8A,0x6000,0x6DEE,0x574F,0x6B22,0x73AF,
0x6853,0x8FD8,0x7F13,0x6362,0x60A3,0x5524,0x75EA,0x8C62,
0x7115,0x6DA3,0x5BA6,0x5E7B,0x8352,0x614C,0x9EC4,0x78FA,
0x8757,0x7C27,0x7687,0x51F0,0x60F6,0x714C,0x6643,0x5E4C,
0x604D,0x8C0E,0x7070,0x6325,0x8F89,0x5FBD,0x6062,0x86D4,
0x56DE,0x6BC1,0x6094,0x6167,0x5349,0x60E0,0x6666,0x8D3F,
0x79FD,0x4F1A,0x70E9,0x6C47,0x8BB3,0x8BF2,0x7ED8,0x8364,
0x660F,0x5A5A,0x9B42,0x6D51,0x6DF7,0x8C41,0x6D3B,0x4F19,
0x706B,0x83B7,0x6216,0x60D1,0x970D,0x8D27,0x7978,0x51FB,
0x573E,0x57FA,0x673A,0x7578,0x7A3D,0x79EF,0x7B95,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7CBF,0x7CC0,0x7CC2,0x7CC3,0x7CC4,0x7CC6,0x7CC9,0x7CCB,
0x7CCE,0x7CCF,0x7CD0,0x7CD1,0x7CD2,0x7CD3,0x7CD4,0x7CD8,
0x7CDA,0x7CDB,0x7CDD,0x7CDE,0x7CE1,0x7CE2,0x7CE3,0x7CE4,
0x7CE5,0x7CE6,0x7CE7,0x7CE9,0x7CEA,0x7CEB,0x7CEC,0x7CED,
0x7CEE,0x7CF0,0x7CF1,0x7CF2,0x7CF3,0x7CF4,0x7CF5,0x7CF6,
0x7CF7,0x7CF9,0x7CFA,0x7CFC,0x7CFD,0x7CFE,0x7CFF,0x7D00,
0x7D01,0x7D02,0x7D03,0x7D04,0x7D05,0x7D06,0x7D07,0x7D08,
0x7D09,0x7D0B,0x7D0C,0x7D0D,0x7D0E,0x7D0F,0x7D10,     0,
0x7D11,0x7D12,0x7D13,0x7D14,0x7D15,0x7D16,0x7D17,0x7D18,
0x7D19,0x7D1A,0x7D1B,0x7D1C,0x7D1D,0x7D1E,0x7D1F,0x7D21,
0x7D23,0x7D24,0x7D25,0x7D26,0x7D28,0x7D29,0x7D2A,0x7D2C,
0x7D2D,0x7D2E,0x7D30,0x7D31,0x7D32,0x7D33,0x7D34,0x7D35,
0x7D36,0x808C,0x9965,0x8FF9,0x6FC0,0x8BA5,0x9E21,0x59EC,
0x7EE9,0x7F09,0x5409,0x6781,0x68D8,0x8F91,0x7C4D,0x96C6,
0x53CA,0x6025,0x75BE,0x6C72,0x5373,0x5AC9,0x7EA7,0x6324,
0x51E0,0x810A,0x5DF1,0x84DF,0x6280,0x5180,0x5B63,0x4F0E,
0x796D,0x5242,0x60B8,0x6D4E,0x5BC4,0x5BC2,0x8BA1,0x8BB0,
0x65E2,0x5FCC,0x9645,0x5993,0x7EE7,0x7EAA,0x5609,0x67B7,
0x5939,0x4F73,0x5BB6,0x52A0,0x835A,0x988A,0x8D3E,0x7532,
0x94BE,0x5047,0x7A3C,0x4EF7,0x67B6,0x9A7E,0x5AC1,0x6B7C,
0x76D1,0x575A,0x5C16,0x7B3A,0x95F4,0x714E,0x517C,0x80A9,
0x8270,0x5978,0x7F04,0x8327,0x68C0,0x67EC,0x78B1,0x7877,
0x62E3,0x6361,0x7B80,0x4FED,0x526A,0x51CF,0x8350,0x69DB,
0x9274,0x8DF5,0x8D31,0x89C1,0x952E,0x7BAD,0x4EF6,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7D37,0x7D38,0x7D39,0x7D3A,0x7D3B,0x7D3C,0x7D3D,0x7D3E,
0x7D3F,0x7D40,0x7D41,0x7D42,0x7D43,0x7D44,0x7D45,0x7D46,
0x7D47,0x7D48,0x7D49,0x7D4A,0x7D4B,0x7D4C,0x7D4D,0x7D4E,
0x7D4F,0x7D50,0x7D51,0x7D52,0x7D53,0x7D54,0x7D55,0x7D56,
0x7D57,0x7D58,0x7D59,0x7D5A,0x7D5B,0x7D5C,0x7D5D,0x7D5E,
0x7D5F,0x7D60,0x7D61,0x7D62,0x7D63,0x7D64,0x7D65,0x7D66,
0x7D67,0x7D68,0x7D69,0x7D6A,0x7D6B,0x7D6C,0x7D6D,0x7D6F,
0x7D70,0x7D71,0x7D72,0x7D73,0x7D74,0x7D75,0x7D76,     0,
0x7D78,0x7D79,0x7D7A,0x7D7B,0x7D7C,0x7D7D,0x7D7E,0x7D7F,
0x7D80,0x7D81,0x7D82,0x7D83,0x7D84,0x7D85,0x7D86,0x7D87,
0x7D88,0x7D89,0x7D8A,0x7D8B,0x7D8C,0x7D8D,0x7D8E,0x7D8F,
0x7D90,0x7D91,0x7D92,0x7D93,0x7D94,0x7D95,0x7D96,0x7D97,
0x7D98,0x5065,0x8230,0x5251,0x996F,0x6E10,0x6E85,0x6DA7,
0x5EFA,0x50F5,0x59DC,0x5C06,0x6D46,0x6C5F,0x7586,0x848B,
0x6868,0x5956,0x8BB2,0x5320,0x9171,0x964D,0x8549,0x6912,
0x7901,0x7126,0x80F6,0x4EA4,0x90CA,0x6D47,0x9A84,0x5A07,
0x56BC,0x6405,0x94F0,0x77EB,0x4FA5,0x811A,0x72E1,0x89D2,
0x997A,0x7F34,0x7EDE,0x527F,0x6559,0x9175,0x8F7F,0x8F83,
0x53EB,0x7A96,0x63ED,0x63A5,0x7686,0x79F8,0x8857,0x9636,
0x622A,0x52AB,0x8282,0x6854,0x6770,0x6377,0x776B,0x7AED,
0x6D01,0x7ED3,0x89E3,0x59D0,0x6212,0x85C9,0x82A5,0x754C,
0x501F,0x4ECB,0x75A5,0x8BEB,0x5C4A,0x5DFE,0x7B4B,0x65A4,
0x91D1,0x4ECA,0x6D25,0x895F,0x7D27,0x9526,0x4EC5,0x8C28,
0x8FDB,0x9773,0x664B,0x7981,0x8FD1,0x70EC,0x6D78,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7D99,0x7D9A,0x7D9B,0x7D9C,0x7D9D,0x7D9E,0x7D9F,0x7DA0,
0x7DA1,0x7DA2,0x7DA3,0x7DA4,0x7DA5,0x7DA7,0x7DA8,0x7DA9,
0x7DAA,0x7DAB,0x7DAC,0x7DAD,0x7DAF,0x7DB0,0x7DB1,0x7DB2,
0x7DB3,0x7DB4,0x7DB5,0x7DB6,0x7DB7,0x7DB8,0x7DB9,0x7DBA,
0x7DBB,0x7DBC,0x7DBD,0x7DBE,0x7DBF,0x7DC0,0x7DC1,0x7DC2,
0x7DC3,0x7DC4,0x7DC5,0x7DC6,0x7DC7,0x7DC8,0x7DC9,0x7DCA,
0x7DCB,0x7DCC,0x7DCD,0x7DCE,0x7DCF,0x7DD0,0x7DD1,0x7DD2,
0x7DD3,0x7DD4,0x7DD5,0x7DD6,0x7DD7,0x7DD8,0x7DD9,     0,
0x7DDA,0x7DDB,0x7DDC,0x7DDD,0x7DDE,0x7DDF,0x7DE0,0x7DE1,
0x7DE2,0x7DE3,0x7DE4,0x7DE5,0x7DE6,0x7DE7,0x7DE8,0x7DE9,
0x7DEA,0x7DEB,0x7DEC,0x7DED,0x7DEE,0x7DEF,0x7DF0,0x7DF1,
0x7DF2,0x7DF3,0x7DF4,0x7DF5,0x7DF6,0x7DF7,0x7DF8,0x7DF9,
0x7DFA,0x5C3D,0x52B2,0x8346,0x5162,0x830E,0x775B,0x6676,
0x9CB8,0x4EAC,0x60CA,0x7CBE,0x7CB3,0x7ECF,0x4E95,0x8B66,
0x666F,0x9888,0x9759,0x5883,0x656C,0x955C,0x5F84,0x75C9,
0x9756,0x7ADF,0x7ADE,0x51C0,0x70AF,0x7A98,0x63EA,0x7A76,
0x7EA0,0x7396,0x97ED,0x4E45,0x7078,0x4E5D,0x9152,0x53A9,
0x6551,0x65E7,0x81FC,0x8205,0x548E,0x5C31,0x759A,0x97A0,
0x62D8,0x72D9,0x75BD,0x5C45,0x9A79,0x83CA,0x5C40,0x5480,
0x77E9,0x4E3E,0x6CAE,0x805A,0x62D2,0x636E,0x5DE8,0x5177,
0x8DDD,0x8E1E,0x952F,0x4FF1,0x53E5,0x60E7,0x70AC,0x5267,
0x6350,0x9E43,0x5A1F,0x5026,0x7737,0x5377,0x7EE2,0x6485,
0x652B,0x6289,0x6398,0x5014,0x7235,0x89C9,0x51B3,0x8BC0,
0x7EDD,0x5747,0x83CC,0x94A7,0x519B,0x541B,0x5CFB,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7DFB,0x7DFC,0x7DFD,0x7DFE,0x7DFF,0x7E00,0x7E01,0x7E02,
0x7E03,0x7E04,0x7E05,0x7E06,0x7E07,0x7E08,0x7E09,0x7E0A,
0x7E0B,0x7E0C,0x7E0D,0x7E0E,0x7E0F,0x7E10,0x7E11,0x7E12,
0x7E13,0x7E14,0x7E15,0x7E16,0x7E17,0x7E18,0x7E19,0x7E1A,
0x7E1B,0x7E1C,0x7E1D,0x7E1E,0x7E1F,0x7E20,0x7E21,0x7E22,
0x7E23,0x7E24,0x7E25,0x7E26,0x7E27,0x7E28,0x7E29,0x7E2A,
0x7E2B,0x7E2C,0x7E2D,0x7E2E,0x7E2F,0x7E30,0x7E31,0x7E32,
0x7E33,0x7E34,0x7E35,0x7E36,0x7E37,0x7E38,0x7E39,     0,
0x7E3A,0x7E3C,0x7E3D,0x7E3E,0x7E3F,0x7E40,0x7E42,0x7E43,
0x7E44,0x7E45,0x7E46,0x7E48,0x7E49,0x7E4A,0x7E4B,0x7E4C,
0x7E4D,0x7E4E,0x7E4F,0x7E50,0x7E51,0x7E52,0x7E53,0x7E54,
0x7E55,0x7E56,0x7E57,0x7E58,0x7E59,0x7E5A,0x7E5B,0x7E5C,
0x7E5D,0x4FCA,0x7AE3,0x6D5A,0x90E1,0x9A8F,0x5580,0x5496,
0x5361,0x54AF,0x5F00,0x63E9,0x6977,0x51EF,0x6168,0x520A,
0x582A,0x52D8,0x574E,0x780D,0x770B,0x5EB7,0x6177,0x7CE0,
0x625B,0x6297,0x4EA2,0x7095,0x8003,0x62F7,0x70E4,0x9760,
0x5777,0x82DB,0x67EF,0x68F5,0x78D5,0x9897,0x79D1,0x58F3,
0x54B3,0x53EF,0x6E34,0x514B,0x523B,0x5BA2,0x8BFE,0x80AF,
0x5543,0x57A6,0x6073,0x5751,0x542D,0x7A7A,0x6050,0x5B54,
0x63A7,0x62A0,0x53E3,0x6263,0x5BC7,0x67AF,0x54ED,0x7A9F,
0x82E6,0x9177,0x5E93,0x88E4,0x5938,0x57AE,0x630E,0x8DE8,
0x80EF,0x5757,0x7B77,0x4FA9,0x5FEB,0x5BBD,0x6B3E,0x5321,
0x7B50,0x72C2,0x6846,0x77FF,0x7736,0x65F7,0x51B5,0x4E8F,
0x76D4,0x5CBF,0x7AA5,0x8475,0x594E,0x9B41,0x5080,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7E5E,0x7E5F,0x7E60,0x7E61,0x7E62,0x7E63,0x7E64,0x7E65,
0x7E66,0x7E67,0x7E68,0x7E69,0x7E6A,0x7E6B,0x7E6C,0x7E6D,
0x7E6E,0x7E6F,0x7E70,0x7E71,0x7E72,0x7E73,0x7E74,0x7E75,
0x7E76,0x7E77,0x7E78,0x7E79,0x7E7A,0x7E7B,0x7E7C,0x7E7D,
0x7E7E,0x7E7F,0x7E80,0x7E81,0x7E83,0x7E84,0x7E85,0x7E86,
0x7E87,0x7E88,0x7E89,0x7E8A,0x7E8B,0x7E8C,0x7E8D,0x7E8E,
0x7E8F,0x7E90,0x7E91,0x7E92,0x7E93,0x7E94,0x7E95,0x7E96,
0x7E97,0x7E98,0x7E99,0x7E9A,0x7E9C,0x7E9D,0x7E9E,     0,
0x7EAE,0x7EB4,0x7EBB,0x7EBC,0x7ED6,0x7EE4,0x7EEC,0x7EF9,
0x7F0A,0x7F10,0x7F1E,0x7F37,0x7F39,0x7F3B,0x7F3C,0x7F3D,
0x7F3E,0x7F3F,0x7F40,0x7F41,0x7F43,0x7F46,0x7F47,0x7F48,
0x7F49,0x7F4A,0x7F4B,0x7F4C,0x7F4D,0x7F4E,0x7F4F,0x7F52,
0x7F53,0x9988,0x6127,0x6E83,0x5764,0x6606,0x6346,0x56F0,
0x62EC,0x6269,0x5ED3,0x9614,0x5783,0x62C9,0x5587,0x8721,
0x814A,0x8FA3,0x5566,0x83B1,0x6765,0x8D56,0x84DD,0x5A6A,
0x680F,0x62E6,0x7BEE,0x9611,0x5170,0x6F9C,0x8C30,0x63FD,
0x89C8,0x61D2,0x7F06,0x70C2,0x6EE5,0x7405,0x6994,0x72FC,
0x5ECA,0x90CE,0x6717,0x6D6A,0x635E,0x52B3,0x7262,0x8001,
0x4F6C,0x59E5,0x916A,0x70D9,0x6D9D,0x52D2,0x4E50,0x96F7,
0x956D,0x857E,0x78CA,0x7D2F,0x5121,0x5792,0x64C2,0x808B,
0x7C7B,0x6CEA,0x68F1,0x695E,0x51B7,0x5398,0x68A8,0x7281,
0x9ECE,0x7BF1,0x72F8,0x79BB,0x6F13,0x7406,0x674E,0x91CC,
0x9CA4,0x793C,0x8389,0x8354,0x540F,0x6817,0x4E3D,0x5389,
0x52B1,0x783E,0x5386,0x5229,0x5088,0x4F8B,0x4FD0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7F56,0x7F59,0x7F5B,0x7F5C,0x7F5D,0x7F5E,0x7F60,0x7F63,
0x7F64,0x7F65,0x7F66,0x7F67,0x7F6B,0x7F6C,0x7F6D,0x7F6F,
0x7F70,0x7F73,0x7F75,0x7F76,0x7F77,0x7F78,0x7F7A,0x7F7B,
0x7F7C,0x7F7D,0x7F7F,0x7F80,0x7F82,0x7F83,0x7F84,0x7F85,
0x7F86,0x7F87,0x7F88,0x7F89,0x7F8B,0x7F8D,0x7F8F,0x7F90,
0x7F91,0x7F92,0x7F93,0x7F95,0x7F96,0x7F97,0x7F98,0x7F99,
0x7F9B,0x7F9C,0x7FA0,0x7FA2,0x7FA3,0x7FA5,0x7FA6,0x7FA8,
0x7FA9,0x7FAA,0x7FAB,0x7FAC,0x7FAD,0x7FAE,0x7FB1,     0,
0x7FB3,0x7FB4,0x7FB5,0x7FB6,0x7FB7,0x7FBA,0x7FBB,0x7FBE,
0x7FC0,0x7FC2,0x7FC3,0x7FC4,0x7FC6,0x7FC7,0x7FC8,0x7FC9,
0x7FCB,0x7FCD,0x7FCF,0x7FD0,0x7FD1,0x7FD2,0x7FD3,0x7FD6,
0x7FD7,0x7FD9,0x7FDA,0x7FDB,0x7FDC,0x7FDD,0x7FDE,0x7FE2,
0x7FE3,0x75E2,0x7ACB,0x7C92,0x6CA5,0x96B6,0x529B,0x7483,
0x54E9,0x4FE9,0x8054,0x83B2,0x8FDE,0x9570,0x5EC9,0x601C,
0x6D9F,0x5E18,0x655B,0x8138,0x94FE,0x604B,0x70BC,0x7EC3,
0x7CAE,0x51C9,0x6881,0x7CB1,0x826F,0x4E24,0x8F86,0x91CF,
0x667E,0x4EAE,0x8C05,0x64A9,0x804A,0x50DA,0x7597,0x71CE,
0x5BE5,0x8FBD,0x6F66,0x4E86,0x6482,0x9563,0x5ED6,0x6599,
0x5217,0x88C2,0x70C8,0x52A3,0x730E,0x7433,0x6797,0x78F7,
0x9716,0x4E34,0x90BB,0x9CDE,0x6DCB,0x51DB,0x8D41,0x541D,
0x62CE,0x73B2,0x83F1,0x96F6,0x9F84,0x94C3,0x4F36,0x7F9A,
0x51CC,0x7075,0x9675,0x5CAD,0x9886,0x53E6,0x4EE4,0x6E9C,
0x7409,0x69B4,0x786B,0x998F,0x7559,0x5218,0x7624,0x6D41,
0x67F3,0x516D,0x9F99,0x804B,0x5499,0x7B3C,0x7ABF,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x7FE4,0x7FE7,0x7FE8,0x7FEA,0x7FEB,0x7FEC,0x7FED,0x7FEF,
0x7FF2,0x7FF4,0x7FF5,0x7FF6,0x7FF7,0x7FF8,0x7FF9,0x7FFA,
0x7FFD,0x7FFE,0x7FFF,0x8002,0x8007,0x8008,0x8009,0x800A,
0x800E,0x800F,0x8011,0x8013,0x801A,0x801B,0x801D,0x801E,
0x801F,0x8021,0x8023,0x8024,0x802B,0x802C,0x802D,0x802E,
0x802F,0x8030,0x8032,0x8034,0x8039,0x803A,0x803C,0x803E,
0x8040,0x8041,0x8044,0x8045,0x8047,0x8048,0x8049,0x804E,
0x804F,0x8050,0x8051,0x8053,0x8055,0x8056,0x8057,     0,
0x8059,0x805B,0x805C,0x805D,0x805E,0x805F,0x8060,0x8061,
0x8062,0x8063,0x8064,0x8065,0x8066,0x8067,0x8068,0x806B,
0x806C,0x806D,0x806E,0x806F,0x8070,0x8072,0x8073,0x8074,
0x8075,0x8076,0x8077,0x8078,0x8079,0x807A,0x807B,0x807C,
0x807D,0x9686,0x5784,0x62E2,0x9647,0x697C,0x5A04,0x6402,
0x7BD3,0x6F0F,0x964B,0x82A6,0x5362,0x9885,0x5E90,0x7089,
0x63B3,0x5364,0x864F,0x9C81,0x9E93,0x788C,0x9732,0x8DEF,
0x8D42,0x9E7F,0x6F5E,0x7984,0x5F55,0x9646,0x622E,0x9A74,
0x5415,0x94DD,0x4FA3,0x65C5,0x5C65,0x5C61,0x7F15,0x8651,
0x6C2F,0x5F8B,0x7387,0x6EE4,0x7EFF,0x5CE6,0x631B,0x5B6A,
0x6EE6,0x5375,0x4E71,0x63A0,0x7565,0x62A1,0x8F6E,0x4F26,
0x4ED1,0x6CA6,0x7EB6,0x8BBA,0x841D,0x87BA,0x7F57,0x903B,
0x9523,0x7BA9,0x9AA1,0x88F8,0x843D,0x6D1B,0x9A86,0x7EDC,
0x5988,0x9EBB,0x739B,0x7801,0x8682,0x9A6C,0x9A82,0x561B,
0x5417,0x57CB,0x4E70,0x9EA6,0x5356,0x8FC8,0x8109,0x7792,
0x9992,0x86EE,0x6EE1,0x8513,0x66FC,0x6162,0x6F2B,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x807E,0x8081,0x8082,0x8085,0x8088,0x808A,0x808D,0x808E,
0x808F,0x8090,0x8091,0x8092,0x8094,0x8095,0x8097,0x8099,
0x809E,0x80A3,0x80A6,0x80A7,0x80A8,0x80AC,0x80B0,0x80B3,
0x80B5,0x80B6,0x80B8,0x80B9,0x80BB,0x80C5,0x80C7,0x80C8,
0x80C9,0x80CA,0x80CB,0x80CF,0x80D0,0x80D1,0x80D2,0x80D3,
0x80D4,0x80D5,0x80D8,0x80DF,0x80E0,0x80E2,0x80E3,0x80E6,
0x80EE,0x80F5,0x80F7,0x80F9,0x80FB,0x80FE,0x80FF,0x8100,
0x8101,0x8103,0x8104,0x8105,0x8107,0x8108,0x810B,     0,
0x810C,0x8115,0x8117,0x8119,0x811B,0x811C,0x811D,0x811F,
0x8120,0x8121,0x8122,0x8123,0x8124,0x8125,0x8126,0x8127,
0x8128,0x8129,0x812A,0x812B,0x812D,0x812E,0x8130,0x8133,
0x8134,0x8135,0x8137,0x8139,0x813A,0x813B,0x813C,0x813D,
0x813F,0x8C29,0x8292,0x832B,0x76F2,0x6C13,0x5FD9,0x83BD,
0x732B,0x8305,0x951A,0x6BDB,0x77DB,0x94C6,0x536F,0x8302,
0x5192,0x5E3D,0x8C8C,0x8D38,0x4E48,0x73AB,0x679A,0x6885,
0x9176,0x9709,0x7164,0x6CA1,0x7709,0x5A92,0x9541,0x6BCF,
0x7F8E,0x6627,0x5BD0,0x59B9,0x5A9A,0x95E8,0x95F7,0x4EEC,
0x840C,0x8499,0x6AAC,0x76DF,0x9530,0x731B,0x68A6,0x5B5F,
0x772F,0x919A,0x9761,0x7CDC,0x8FF7,0x8C1C,0x5F25,0x7C73,
0x79D8,0x89C5,0x6CCC,0x871C,0x5BC6,0x5E42,0x68C9,0x7720,
0x7EF5,0x5195,0x514D,0x52C9,0x5A29,0x7F05,0x9762,0x82D7,
0x63CF,0x7784,0x85D0,0x79D2,0x6E3A,0x5E99,0x5999,0x8511,
0x706D,0x6C11,0x62BF,0x76BF,0x654F,0x60AF,0x95FD,0x660E,
0x879F,0x9E23,0x94ED,0x540D,0x547D,0x8C2C,0x6478,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8140,0x8141,0x8142,0x8143,0x8144,0x8145,0x8147,0x8149,
0x814D,0x814E,0x814F,0x8152,0x8156,0x8157,0x8158,0x815B,
0x815C,0x815D,0x815E,0x815F,0x8161,0x8162,0x8163,0x8164,
0x8166,0x8168,0x816A,0x816B,0x816C,0x816F,0x8172,0x8173,
0x8175,0x8176,0x8177,0x8178,0x8181,0x8183,0x8184,0x8185,
0x8186,0x8187,0x8189,0x818B,0x818C,0x818D,0x818E,0x8190,
0x8192,0x8193,0x8194,0x8195,0x8196,0x8197,0x8199,0x819A,
0x819E,0x819F,0x81A0,0x81A1,0x81A2,0x81A4,0x81A5,     0,
0x81A7,0x81A9,0x81AB,0x81AC,0x81AD,0x81AE,0x81AF,0x81B0,
0x81B1,0x81B2,0x81B4,0x81B5,0x81B6,0x81B7,0x81B8,0x81B9,
0x81BC,0x81BD,0x81BE,0x81BF,0x81C4,0x81C5,0x81C7,0x81C8,
0x81C9,0x81CB,0x81CD,0x81CE,0x81CF,0x81D0,0x81D1,0x81D2,
0x81D3,0x6479,0x8611,0x6A21,0x819C,0x78E8,0x6469,0x9B54,
0x62B9,0x672B,0x83AB,0x58A8,0x9ED8,0x6CAB,0x6F20,0x5BDE,
0x964C,0x8C0B,0x725F,0x67D0,0x62C7,0x7261,0x4EA9,0x59C6,
0x6BCD,0x5893,0x66AE,0x5E55,0x52DF,0x6155,0x6728,0x76EE,
0x7766,0x7267,0x7A46,0x62FF,0x54EA,0x5450,0x94A0,0x90A3,
0x5A1C,0x7EB3,0x6C16,0x4E43,0x5976,0x8010,0x5948,0x5357,
0x7537,0x96BE,0x56CA,0x6320,0x8111,0x607C,0x95F9,0x6DD6,
0x5462,0x9981,0x5185,0x5AE9,0x80FD,0x59AE,0x9713,0x502A,
0x6CE5,0x5C3C,0x62DF,0x4F60,0x533F,0x817B,0x9006,0x6EBA,
0x852B,0x62C8,0x5E74,0x78BE,0x64B5,0x637B,0x5FF5,0x5A18,
0x917F,0x9E1F,0x5C3F,0x634F,0x8042,0x5B7D,0x556E,0x954A,
0x954D,0x6D85,0x60A8,0x67E0,0x72DE,0x51DD,0x5B81,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x81D4,0x81D5,0x81D6,0x81D7,0x81D8,0x81D9,0x81DA,0x81DB,
0x81DC,0x81DD,0x81DE,0x81DF,0x81E0,0x81E1,0x81E2,0x81E4,
0x81E5,0x81E6,0x81E8,0x81E9,0x81EB,0x81EE,0x81EF,0x81F0,
0x81F1,0x81F2,0x81F5,0x81F6,0x81F7,0x81F8,0x81F9,0x81FA,
0x81FD,0x81FF,0x8203,0x8207,0x8208,0x8209,0x820A,0x820B,
0x820E,0x820F,0x8211,0x8213,0x8215,0x8216,0x8217,0x8218,
0x8219,0x821A,0x821D,0x8220,0x8224,0x8225,0x8226,0x8227,
0x8229,0x822E,0x8232,0x823A,0x823C,0x823D,0x823F,     0,
0x8240,0x8241,0x8242,0x8243,0x8245,0x8246,0x8248,0x824A,
0x824C,0x824D,0x824E,0x8250,0x8251,0x8252,0x8253,0x8254,
0x8255,0x8256,0x8257,0x8259,0x825B,0x825C,0x825D,0x825E,
0x8260,0x8261,0x8262,0x8263,0x8264,0x8265,0x8266,0x8267,
0x8269,0x62E7,0x6CDE,0x725B,0x626D,0x94AE,0x7EBD,0x8113,
0x6D53,0x519C,0x5F04,0x5974,0x52AA,0x6012,0x5973,0x6696,
0x8650,0x759F,0x632A,0x61E6,0x7CEF,0x8BFA,0x54E6,0x6B27,
0x9E25,0x6BB4,0x85D5,0x5455,0x5076,0x6CA4,0x556A,0x8DB4,
0x722C,0x5E15,0x6015,0x7436,0x62CD,0x6392,0x724C,0x5F98,
0x6E43,0x6D3E,0x6500,0x6F58,0x76D8,0x78D0,0x76FC,0x7554,
0x5224,0x53DB,0x4E53,0x5E9E,0x65C1,0x802A,0x80D6,0x629B,
0x5486,0x5228,0x70AE,0x888D,0x8DD1,0x6CE1,0x5478,0x80DA,
0x57F9,0x88F4,0x8D54,0x966A,0x914D,0x4F69,0x6C9B,0x55B7,
0x76C6,0x7830,0x62A8,0x70F9,0x6F8E,0x5F6D,0x84EC,0x68DA,
0x787C,0x7BF7,0x81A8,0x670B,0x9E4F,0x6367,0x78B0,0x576F,
0x7812,0x9739,0x6279,0x62AB,0x5288,0x7435,0x6BD7,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x826A,0x826B,0x826C,0x826D,0x8271,0x8275,0x8276,0x8277,
0x8278,0x827B,0x827C,0x8280,0x8281,0x8283,0x8285,0x8286,
0x8287,0x8289,0x828C,0x8290,0x8293,0x8294,0x8295,0x8296,
0x829A,0x829B,0x829E,0x82A0,0x82A2,0x82A3,0x82A7,0x82B2,
0x82B5,0x82B6,0x82BA,0x82BB,0x82BC,0x82BF,0x82C0,0x82C2,
0x82C3,0x82C5,0x82C6,0x82C9,0x82D0,0x82D6,0x82D9,0x82DA,
0x82DD,0x82E2,0x82E7,0x82E8,0x82E9,0x82EA,0x82EC,0x82ED,
0x82EE,0x82F0,0x82F2,0x82F3,0x82F5,0x82F6,0x82F8,     0,
0x82FA,0x82FC,0x82FD,0x82FE,0x82FF,0x8300,0x830A,0x830B,
0x830D,0x8310,0x8312,0x8313,0x8316,0x8318,0x8319,0x831D,
0x831E,0x831F,0x8320,0x8321,0x8322,0x8323,0x8324,0x8325,
0x8326,0x8329,0x832A,0x832E,0x8330,0x8332,0x8337,0x833B,
0x833D,0x5564,0x813E,0x75B2,0x76AE,0x5339,0x75DE,0x50FB,
0x5C41,0x8B6C,0x7BC7,0x504F,0x7247,0x9A97,0x98D8,0x6F02,
0x74E2,0x7968,0x6487,0x77A5,0x62FC,0x9891,0x8D2B,0x54C1,
0x8058,0x4E52,0x576A,0x82F9,0x840D,0x5E73,0x51ED,0x74F6,
0x8BC4,0x5C4F,0x5761,0x6CFC,0x9887,0x5A46,0x7834,0x9B44,
0x8FEB,0x7C95,0x5256,0x6251,0x94FA,0x4EC6,0x8386,0x8461,
0x83E9,0x84B2,0x57D4,0x6734,0x5703,0x666E,0x6D66,0x8C31,
0x66DD,0x7011,0x671F,0x6B3A,0x6816,0x621A,0x59BB,0x4E03,
0x51C4,0x6F06,0x67D2,0x6C8F,0x5176,0x68CB,0x5947,0x6B67,
0x7566,0x5D0E,0x8110,0x9F50,0x65D7,0x7948,0x7941,0x9A91,
0x8D77,0x5C82,0x4E5E,0x4F01,0x542F,0x5951,0x780C,0x5668,
0x6C14,0x8FC4,0x5F03,0x6C7D,0x6CE3,0x8BAB,0x6390,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x833E,0x833F,0x8341,0x8342,0x8344,0x8345,0x8348,0x834A,
0x834B,0x834C,0x834D,0x834E,0x8353,0x8355,0x8356,0x8357,
0x8358,0x8359,0x835D,0x8362,0x8370,0x8371,0x8372,0x8373,
0x8374,0x8375,0x8376,0x8379,0x837A,0x837E,0x837F,0x8380,
0x8381,0x8382,0x8383,0x8384,0x8387,0x8388,0x838A,0x838B,
0x838C,0x838D,0x838F,0x8390,0x8391,0x8394,0x8395,0x8396,
0x8397,0x8399,0x839A,0x839D,0x839F,0x83A1,0x83A2,0x83A3,
0x83A4,0x83A5,0x83A6,0x83A7,0x83AC,0x83AD,0x83AE,     0,
0x83AF,0x83B5,0x83BB,0x83BE,0x83BF,0x83C2,0x83C3,0x83C4,
0x83C6,0x83C8,0x83C9,0x83CB,0x83CD,0x83CE,0x83D0,0x83D1,
0x83D2,0x83D3,0x83D5,0x83D7,0x83D9,0x83DA,0x83DB,0x83DE,
0x83E2,0x83E3,0x83E4,0x83E6,0x83E7,0x83E8,0x83EB,0x83EC,
0x83ED,0x6070,0x6D3D,0x7275,0x6266,0x948E,0x94C5,0x5343,
0x8FC1,0x7B7E,0x4EDF,0x8C26,0x4E7E,0x9ED4,0x94B1,0x94B3,
0x524D,0x6F5C,0x9063,0x6D45,0x8C34,0x5811,0x5D4C,0x6B20,
0x6B49,0x67AA,0x545B,0x8154,0x7F8C,0x5899,0x8537,0x5F3A,
0x62A2,0x6A47,0x9539,0x6572,0x6084,0x6865,0x77A7,0x4E54,
0x4FA8,0x5DE7,0x9798,0x64AC,0x7FD8,0x5CED,0x4FCF,0x7A8D,
0x5207,0x8304,0x4E14,0x602F,0x7A83,0x94A6,0x4FB5,0x4EB2,
0x79E6,0x7434,0x52E4,0x82B9,0x64D2,0x79BD,0x5BDD,0x6C81,
0x9752,0x8F7B,0x6C22,0x503E,0x537F,0x6E05,0x64CE,0x6674,
0x6C30,0x60C5,0x9877,0x8BF7,0x5E86,0x743C,0x7A77,0x79CB,
0x4E18,0x90B1,0x7403,0x6C42,0x56DA,0x914B,0x6CC5,0x8D8B,
0x533A,0x86C6,0x66F2,0x8EAF,0x5C48,0x9A71,0x6E20,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x83EE,0x83EF,0x83F3,0x83F4,0x83F5,0x83F6,0x83F7,0x83FA,
0x83FB,0x83FC,0x83FE,0x83FF,0x8400,0x8402,0x8405,0x8407,
0x8408,0x8409,0x840A,0x8410,0x8412,0x8413,0x8414,0x8415,
0x8416,0x8417,0x8419,0x841A,0x841B,0x841E,0x841F,0x8420,
0x8421,0x8422,0x8423,0x8429,0x842A,0x842B,0x842C,0x842D,
0x842E,0x842F,0x8430,0x8432,0x8433,0x8434,0x8435,0x8436,
0x8437,0x8439,0x843A,0x843B,0x843E,0x843F,0x8440,0x8441,
0x8442,0x8443,0x8444,0x8445,0x8447,0x8448,0x8449,     0,
0x844A,0x844B,0x844C,0x844D,0x844E,0x844F,0x8450,0x8452,
0x8453,0x8454,0x8455,0x8456,0x8458,0x845D,0x845E,0x845F,
0x8460,0x8462,0x8464,0x8465,0x8466,0x8467,0x8468,0x846A,
0x846E,0x846F,0x8470,0x8472,0x8474,0x8477,0x8479,0x847B,
0x847C,0x53D6,0x5A36,0x9F8B,0x8DA3,0x53BB,0x5708,0x98A7,
0x6743,0x919B,0x6CC9,0x5168,0x75CA,0x62F3,0x72AC,0x5238,
0x529D,0x7F3A,0x7094,0x7638,0x5374,0x9E4A,0x69B7,0x786E,
0x96C0,0x88D9,0x7FA4,0x7136,0x71C3,0x5189,0x67D3,0x74E4,
0x58E4,0x6518,0x56B7,0x8BA9,0x9976,0x6270,0x7ED5,0x60F9,
0x70ED,0x58EC,0x4EC1,0x4EBA,0x5FCD,0x97E7,0x4EFB,0x8BA4,
0x5203,0x598A,0x7EAB,0x6254,0x4ECD,0x65E5,0x620E,0x8338,
0x84C9,0x8363,0x878D,0x7194,0x6EB6,0x5BB9,0x7ED2,0x5197,
0x63C9,0x67D4,0x8089,0x8339,0x8815,0x5112,0x5B7A,0x5982,
0x8FB1,0x4E73,0x6C5D,0x5165,0x8925,0x8F6F,0x962E,0x854A,
0x745E,0x9510,0x95F0,0x6DA6,0x82E5,0x5F31,0x6492,0x6D12,
0x8428,0x816E,0x9CC3,0x585E,0x8D5B,0x4E09,0x53C1,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x847D,0x847E,0x847F,0x8480,0x8481,0x8483,0x8484,0x8485,
0x8486,0x848A,0x848D,0x848F,0x8490,0x8491,0x8492,0x8493,
0x8494,0x8495,0x8496,0x8498,0x849A,0x849B,0x849D,0x849E,
0x849F,0x84A0,0x84A2,0x84A3,0x84A4,0x84A5,0x84A6,0x84A7,
0x84A8,0x84A9,0x84AA,0x84AB,0x84AC,0x84AD,0x84AE,0x84B0,
0x84B1,0x84B3,0x84B5,0x84B6,0x84B7,0x84BB,0x84BC,0x84BE,
0x84C0,0x84C2,0x84C3,0x84C5,0x84C6,0x84C7,0x84C8,0x84CB,
0x84CC,0x84CE,0x84CF,0x84D2,0x84D4,0x84D5,0x84D7,     0,
0x84D8,0x84D9,0x84DA,0x84DB,0x84DC,0x84DE,0x84E1,0x84E2,
0x84E4,0x84E7,0x84E8,0x84E9,0x84EA,0x84EB,0x84ED,0x84EE,
0x84EF,0x84F1,0x84F2,0x84F3,0x84F4,0x84F5,0x84F6,0x84F7,
0x84F8,0x84F9,0x84FA,0x84FB,0x84FD,0x84FE,0x8500,0x8501,
0x8502,0x4F1E,0x6563,0x6851,0x55D3,0x4E27,0x6414,0x9A9A,
0x626B,0x5AC2,0x745F,0x8272,0x6DA9,0x68EE,0x50E7,0x838E,
0x7802,0x6740,0x5239,0x6C99,0x7EB1,0x50BB,0x5565,0x715E,
0x7B5B,0x6652,0x73CA,0x82EB,0x6749,0x5C71,0x5220,0x717D,
0x886B,0x95EA,0x9655,0x64C5,0x8D61,0x81B3,0x5584,0x6C55,
0x6247,0x7F2E,0x5892,0x4F24,0x5546,0x8D4F,0x664C,0x4E0A,
0x5C1A,0x88F3,0x68A2,0x634E,0x7A0D,0x70E7,0x828D,0x52FA,
0x97F6,0x5C11,0x54E8,0x90B5,0x7ECD,0x5962,0x8D4A,0x86C7,
0x820C,0x820D,0x8D66,0x6444,0x5C04,0x6151,0x6D89,0x793E,
0x8BBE,0x7837,0x7533,0x547B,0x4F38,0x8EAB,0x6DF1,0x5A20,
0x7EC5,0x795E,0x6C88,0x5BA1,0x5A76,0x751A,0x80BE,0x614E,
0x6E17,0x58F0,0x751F,0x7525,0x7272,0x5347,0x7EF3,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8503,0x8504,0x8505,0x8506,0x8507,0x8508,0x8509,0x850A,
0x850B,0x850D,0x850E,0x850F,0x8510,0x8512,0x8514,0x8515,
0x8516,0x8518,0x8519,0x851B,0x851C,0x851D,0x851E,0x8520,
0x8522,0x8523,0x8524,0x8525,0x8526,0x8527,0x8528,0x8529,
0x852A,0x852D,0x852E,0x852F,0x8530,0x8531,0x8532,0x8533,
0x8534,0x8535,0x8536,0x853E,0x853F,0x8540,0x8541,0x8542,
0x8544,0x8545,0x8546,0x8547,0x854B,0x854C,0x854D,0x854E,
0x854F,0x8550,0x8551,0x8552,0x8553,0x8554,0x8555,     0,
0x8557,0x8558,0x855A,0x855B,0x855C,0x855D,0x855F,0x8560,
0x8561,0x8562,0x8563,0x8565,0x8566,0x8567,0x8569,0x856A,
0x856B,0x856C,0x856D,0x856E,0x856F,0x8570,0x8571,0x8573,
0x8575,0x8576,0x8577,0x8578,0x857C,0x857D,0x857F,0x8580,
0x8581,0x7701,0x76DB,0x5269,0x80DC,0x5723,0x5E08,0x5931,
0x72EE,0x65BD,0x6E7F,0x8BD7,0x5C38,0x8671,0x5341,0x77F3,
0x62FE,0x65F6,0x4EC0,0x98DF,0x8680,0x5B9E,0x8BC6,0x53F2,
0x77E2,0x4F7F,0x5C4E,0x9A76,0x59CB,0x5F0F,0x793A,0x58EB,
0x4E16,0x67FF,0x4E8B,0x62ED,0x8A93,0x901D,0x52BF,0x662F,
0x55DC,0x566C,0x9002,0x4ED5,0x4F8D,0x91CA,0x9970,0x6C0F,
0x5E02,0x6043,0x5BA4,0x89C6,0x8BD5,0x6536,0x624B,0x9996,
0x5B88,0x5BFF,0x6388,0x552E,0x53D7,0x7626,0x517D,0x852C,
0x67A2,0x68B3,0x6B8A,0x6292,0x8F93,0x53D4,0x8212,0x6DD1,
0x758F,0x4E66,0x8D4E,0x5B70,0x719F,0x85AF,0x6691,0x66D9,
0x7F72,0x8700,0x9ECD,0x9F20,0x5C5E,0x672F,0x8FF0,0x6811,
0x675F,0x620D,0x7AD6,0x5885,0x5EB6,0x6570,0x6F31,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8582,0x8583,0x8586,0x8588,0x8589,0x858A,0x858B,0x858C,
0x858D,0x858E,0x8590,0x8591,0x8592,0x8593,0x8594,0x8595,
0x8596,0x8597,0x8598,0x8599,0x859A,0x859D,0x859E,0x859F,
0x85A0,0x85A1,0x85A2,0x85A3,0x85A5,0x85A6,0x85A7,0x85A9,
0x85AB,0x85AC,0x85AD,0x85B1,0x85B2,0x85B3,0x85B4,0x85B5,
0x85B6,0x85B8,0x85BA,0x85BB,0x85BC,0x85BD,0x85BE,0x85BF,
0x85C0,0x85C2,0x85C3,0x85C4,0x85C5,0x85C6,0x85C7,0x85C8,
0x85CA,0x85CB,0x85CC,0x85CD,0x85CE,0x85D1,0x85D2,     0,
0x85D4,0x85D6,0x85D7,0x85D8,0x85D9,0x85DA,0x85DB,0x85DD,
0x85DE,0x85DF,0x85E0,0x85E1,0x85E2,0x85E3,0x85E5,0x85E6,
0x85E7,0x85E8,0x85EA,0x85EB,0x85EC,0x85ED,0x85EE,0x85EF,
0x85F0,0x85F1,0x85F2,0x85F3,0x85F4,0x85F5,0x85F6,0x85F7,
0x85F8,0x6055,0x5237,0x800D,0x6454,0x8870,0x7529,0x5E05,
0x6813,0x62F4,0x971C,0x53CC,0x723D,0x8C01,0x6C34,0x7761,
0x7A0E,0x542E,0x77AC,0x987A,0x821C,0x8BF4,0x7855,0x6714,
0x70C1,0x65AF,0x6495,0x5636,0x601D,0x79C1,0x53F8,0x4E1D,
0x6B7B,0x8086,0x5BFA,0x55E3,0x56DB,0x4F3A,0x4F3C,0x9972,
0x5DF3,0x677E,0x8038,0x6002,0x9882,0x9001,0x5B8B,0x8BBC,
0x8BF5,0x641C,0x8258,0x64DE,0x55FD,0x82CF,0x9165,0x4FD7,
0x7D20,0x901F,0x7C9F,0x50F3,0x5851,0x6EAF,0x5BBF,0x8BC9,
0x8083,0x9178,0x849C,0x7B97,0x867D,0x968B,0x968F,0x7EE5,
0x9AD3,0x788E,0x5C81,0x7A57,0x9042,0x96A7,0x795F,0x5B59,
0x635F,0x7B0B,0x84D1,0x68AD,0x5506,0x7F29,0x7410,0x7D22,
0x9501,0x6240,0x584C,0x4ED6,0x5B83,0x5979,0x5854,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x85F9,0x85FA,0x85FC,0x85FD,0x85FE,0x8600,0x8601,0x8602,
0x8603,0x8604,0x8606,0x8607,0x8608,0x8609,0x860A,0x860B,
0x860C,0x860D,0x860E,0x860F,0x8610,0x8612,0x8613,0x8614,
0x8615,0x8617,0x8618,0x8619,0x861A,0x861B,0x861C,0x861D,
0x861E,0x861F,0x8620,0x8621,0x8622,0x8623,0x8624,0x8625,
0x8626,0x8628,0x862A,0x862B,0x862C,0x862D,0x862E,0x862F,
0x8630,0x8631,0x8632,0x8633,0x8634,0x8635,0x8636,0x8637,
0x8639,0x863A,0x863B,0x863D,0x863E,0x863F,0x8640,     0,
0x8641,0x8642,0x8643,0x8644,0x8645,0x8646,0x8647,0x8648,
0x8649,0x864A,0x864B,0x864C,0x8652,0x8653,0x8655,0x8656,
0x8657,0x8658,0x8659,0x865B,0x865C,0x865D,0x865F,0x8660,
0x8661,0x8663,0x8664,0x8665,0x8666,0x8667,0x8668,0x8669,
0x866A,0x736D,0x631E,0x8E4B,0x8E0F,0x80CE,0x82D4,0x62AC,
0x53F0,0x6CF0,0x915E,0x592A,0x6001,0x6C70,0x574D,0x644A,
0x8D2A,0x762B,0x6EE9,0x575B,0x6A80,0x75F0,0x6F6D,0x8C2D,
0x8C08,0x5766,0x6BEF,0x8892,0x78B3,0x63A2,0x53F9,0x70AD,
0x6C64,0x5858,0x642A,0x5802,0x68E0,0x819B,0x5510,0x7CD6,
0x5018,0x8EBA,0x6DCC,0x8D9F,0x70EB,0x638F,0x6D9B,0x6ED4,
0x7EE6,0x8404,0x6843,0x9003,0x6DD8,0x9676,0x8BA8,0x5957,
0x7279,0x85E4,0x817E,0x75BC,0x8A8A,0x68AF,0x5254,0x8E22,
0x9511,0x63D0,0x9898,0x8E44,0x557C,0x4F53,0x66FF,0x568F,
0x60D5,0x6D95,0x5243,0x5C49,0x5929,0x6DFB,0x586B,0x7530,
0x751C,0x606C,0x8214,0x8146,0x6311,0x6761,0x8FE2,0x773A,
0x8DF3,0x8D34,0x94C1,0x5E16,0x5385,0x542C,0x70C3,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x866D,0x866F,0x8670,0x8672,0x8673,0x8674,0x8675,0x8676,
0x8677,0x8678,0x8683,0x8684,0x8685,0x8686,0x8687,0x8688,
0x8689,0x868E,0x868F,0x8690,0x8691,0x8692,0x8694,0x8696,
0x8697,0x8698,0x8699,0x869A,0x869B,0x869E,0x869F,0x86A0,
0x86A1,0x86A2,0x86A5,0x86A6,0x86AB,0x86AD,0x86AE,0x86B2,
0x86B3,0x86B7,0x86B8,0x86B9,0x86BB,0x86BC,0x86BD,0x86BE,
0x86BF,0x86C1,0x86C2,0x86C3,0x86C5,0x86C8,0x86CC,0x86CD,
0x86D2,0x86D3,0x86D5,0x86D6,0x86D7,0x86DA,0x86DC,     0,
0x86DD,0x86E0,0x86E1,0x86E2,0x86E3,0x86E5,0x86E6,0x86E7,
0x86E8,0x86EA,0x86EB,0x86EC,0x86EF,0x86F5,0x86F6,0x86F7,
0x86FA,0x86FB,0x86FC,0x86FD,0x86FF,0x8701,0x8704,0x8705,
0x8706,0x870B,0x870C,0x870E,0x870F,0x8710,0x8711,0x8714,
0x8716,0x6C40,0x5EF7,0x505C,0x4EAD,0x5EAD,0x633A,0x8247,
0x901A,0x6850,0x916E,0x77B3,0x540C,0x94DC,0x5F64,0x7AE5,
0x6876,0x6345,0x7B52,0x7EDF,0x75DB,0x5077,0x6295,0x5934,
0x900F,0x51F8,0x79C3,0x7A81,0x56FE,0x5F92,0x9014,0x6D82,
0x5C60,0x571F,0x5410,0x5154,0x6E4D,0x56E2,0x63A8,0x9893,
0x817F,0x8715,0x892A,0x9000,0x541E,0x5C6F,0x81C0,0x62D6,
0x6258,0x8131,0x9E35,0x9640,0x9A6E,0x9A7C,0x692D,0x59A5,
0x62D3,0x553E,0x6316,0x54C7,0x86D9,0x6D3C,0x5A03,0x74E6,
0x889C,0x6B6A,0x5916,0x8C4C,0x5F2F,0x6E7E,0x73A9,0x987D,
0x4E38,0x70F7,0x5B8C,0x7897,0x633D,0x665A,0x7696,0x60CB,
0x5B9B,0x5A49,0x4E07,0x8155,0x6C6A,0x738B,0x4EA1,0x6789,
0x7F51,0x5F80,0x65FA,0x671B,0x5FD8,0x5984,0x5A01,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8719,0x871B,0x871D,0x871F,0x8720,0x8724,0x8726,0x8727,
0x8728,0x872A,0x872B,0x872C,0x872D,0x872F,0x8730,0x8732,
0x8733,0x8735,0x8736,0x8738,0x8739,0x873A,0x873C,0x873D,
0x8740,0x8741,0x8742,0x8743,0x8744,0x8745,0x8746,0x874A,
0x874B,0x874D,0x874F,0x8750,0x8751,0x8752,0x8754,0x8755,
0x8756,0x8758,0x875A,0x875B,0x875C,0x875D,0x875E,0x875F,
0x8761,0x8762,0x8766,0x8767,0x8768,0x8769,0x876A,0x876B,
0x876C,0x876D,0x876F,0x8771,0x8772,0x8773,0x8775,     0,
0x8777,0x8778,0x8779,0x877A,0x877F,0x8780,0x8781,0x8784,
0x8786,0x8787,0x8789,0x878A,0x878C,0x878E,0x878F,0x8790,
0x8791,0x8792,0x8794,0x8795,0x8796,0x8798,0x8799,0x879A,
0x879B,0x879C,0x879D,0x879E,0x87A0,0x87A1,0x87A2,0x87A3,
0x87A4,0x5DCD,0x5FAE,0x5371,0x97E6,0x8FDD,0x6845,0x56F4,
0x552F,0x60DF,0x4E3A,0x6F4D,0x7EF4,0x82C7,0x840E,0x59D4,
0x4F1F,0x4F2A,0x5C3E,0x7EAC,0x672A,0x851A,0x5473,0x754F,
0x80C3,0x5582,0x9B4F,0x4F4D,0x6E2D,0x8C13,0x5C09,0x6170,
0x536B,0x761F,0x6E29,0x868A,0x6587,0x95FB,0x7EB9,0x543B,
0x7A33,0x7D0A,0x95EE,0x55E1,0x7FC1,0x74EE,0x631D,0x8717,
0x6DA1,0x7A9D,0x6211,0x65A1,0x5367,0x63E1,0x6C83,0x5DEB,
0x545C,0x94A8,0x4E4C,0x6C61,0x8BEC,0x5C4B,0x65E0,0x829C,
0x68A7,0x543E,0x5434,0x6BCB,0x6B66,0x4E94,0x6342,0x5348,
0x821E,0x4F0D,0x4FAE,0x575E,0x620A,0x96FE,0x6664,0x7269,
0x52FF,0x52A1,0x609F,0x8BEF,0x6614,0x7199,0x6790,0x897F,
0x7852,0x77FD,0x6670,0x563B,0x5438,0x9521,0x727A,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x87A5,0x87A6,0x87A7,0x87A9,0x87AA,0x87AE,0x87B0,0x87B1,
0x87B2,0x87B4,0x87B6,0x87B7,0x87B8,0x87B9,0x87BB,0x87BC,
0x87BE,0x87BF,0x87C1,0x87C2,0x87C3,0x87C4,0x87C5,0x87C7,
0x87C8,0x87C9,0x87CC,0x87CD,0x87CE,0x87CF,0x87D0,0x87D4,
0x87D5,0x87D6,0x87D7,0x87D8,0x87D9,0x87DA,0x87DC,0x87DD,
0x87DE,0x87DF,0x87E1,0x87E2,0x87E3,0x87E4,0x87E6,0x87E7,
0x87E8,0x87E9,0x87EB,0x87EC,0x87ED,0x87EF,0x87F0,0x87F1,
0x87F2,0x87F3,0x87F4,0x87F5,0x87F6,0x87F7,0x87F8,     0,
0x87FA,0x87FB,0x87FC,0x87FD,0x87FF,0x8800,0x8801,0x8802,
0x8804,0x8805,0x8806,0x8807,0x8808,0x8809,0x880B,0x880C,
0x880D,0x880E,0x880F,0x8810,0x8811,0x8812,0x8814,0x8817,
0x8818,0x8819,0x881A,0x881C,0x881D,0x881E,0x881F,0x8820,
0x8823,0x7A00,0x606F,0x5E0C,0x6089,0x819D,0x5915,0x60DC,
0x7184,0x70EF,0x6EAA,0x6C50,0x7280,0x6A84,0x88AD,0x5E2D,
0x4E60,0x5AB3,0x559C,0x94E3,0x6D17,0x7CFB,0x9699,0x620F,
0x7EC6,0x778E,0x867E,0x5323,0x971E,0x8F96,0x6687,0x5CE1,
0x4FA0,0x72ED,0x4E0B,0x53A6,0x590F,0x5413,0x6380,0x9528,
0x5148,0x4ED9,0x9C9C,0x7EA4,0x54B8,0x8D24,0x8854,0x8237,
0x95F2,0x6D8E,0x5F26,0x5ACC,0x663E,0x9669,0x73B0,0x732E,
0x53BF,0x817A,0x9985,0x7FA1,0x5BAA,0x9677,0x9650,0x7EBF,
0x76F8,0x53A2,0x9576,0x9999,0x7BB1,0x8944,0x6E58,0x4E61,
0x7FD4,0x7965,0x8BE6,0x60F3,0x54CD,0x4EAB,0x9879,0x5DF7,
0x6A61,0x50CF,0x5411,0x8C61,0x8427,0x785D,0x9704,0x524A,
0x54EE,0x56A3,0x9500,0x6D88,0x5BB5,0x6DC6,0x6653,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8824,0x8825,0x8826,0x8827,0x8828,0x8829,0x882A,0x882B,
0x882C,0x882D,0x882E,0x882F,0x8830,0x8831,0x8833,0x8834,
0x8835,0x8836,0x8837,0x8838,0x883A,0x883B,0x883D,0x883E,
0x883F,0x8841,0x8842,0x8843,0x8846,0x8847,0x8848,0x8849,
0x884A,0x884B,0x884E,0x884F,0x8850,0x8851,0x8852,0x8853,
0x8855,0x8856,0x8858,0x885A,0x885B,0x885C,0x885D,0x885E,
0x885F,0x8860,0x8866,0x8867,0x886A,0x886D,0x886F,0x8871,
0x8873,0x8874,0x8875,0x8876,0x8878,0x8879,0x887A,     0,
0x887B,0x887C,0x8880,0x8883,0x8886,0x8887,0x8889,0x888A,
0x888C,0x888E,0x888F,0x8890,0x8891,0x8893,0x8894,0x8895,
0x8897,0x8898,0x8899,0x889A,0x889B,0x889D,0x889E,0x889F,
0x88A0,0x88A1,0x88A3,0x88A5,0x88A6,0x88A7,0x88A8,0x88A9,
0x88AA,0x5C0F,0x5B5D,0x6821,0x8096,0x5578,0x7B11,0x6548,
0x6954,0x4E9B,0x6B47,0x874E,0x978B,0x534F,0x631F,0x643A,
0x90AA,0x659C,0x80C1,0x8C10,0x5199,0x68B0,0x5378,0x87F9,
0x61C8,0x6CC4,0x6CFB,0x8C22,0x5C51,0x85AA,0x82AF,0x950C,
0x6B23,0x8F9B,0x65B0,0x5FFB,0x5FC3,0x4FE1,0x8845,0x661F,
0x8165,0x7329,0x60FA,0x5174,0x5211,0x578B,0x5F62,0x90A2,
0x884C,0x9192,0x5E78,0x674F,0x6027,0x59D3,0x5144,0x51F6,
0x80F8,0x5308,0x6C79,0x96C4,0x718A,0x4F11,0x4FEE,0x7F9E,
0x673D,0x55C5,0x9508,0x79C0,0x8896,0x7EE3,0x589F,0x620C,
0x9700,0x865A,0x5618,0x987B,0x5F90,0x8BB8,0x84C4,0x9157,
0x53D9,0x65ED,0x5E8F,0x755C,0x6064,0x7D6E,0x5A7F,0x7EEA,
0x7EED,0x8F69,0x55A7,0x5BA3,0x60AC,0x65CB,0x7384,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x88AC,0x88AE,0x88AF,0x88B0,0x88B2,0x88B3,0x88B4,0x88B5,
0x88B6,0x88B8,0x88B9,0x88BA,0x88BB,0x88BD,0x88BE,0x88BF,
0x88C0,0x88C3,0x88C4,0x88C7,0x88C8,0x88CA,0x88CB,0x88CC,
0x88CD,0x88CF,0x88D0,0x88D1,0x88D3,0x88D6,0x88D7,0x88DA,
0x88DB,0x88DC,0x88DD,0x88DE,0x88E0,0x88E1,0x88E6,0x88E7,
0x88E9,0x88EA,0x88EB,0x88EC,0x88ED,0x88EE,0x88EF,0x88F2,
0x88F5,0x88F6,0x88F7,0x88FA,0x88FB,0x88FD,0x88FF,0x8900,
0x8901,0x8903,0x8904,0x8905,0x8906,0x8907,0x8908,     0,
0x8909,0x890B,0x890C,0x890D,0x890E,0x890F,0x8911,0x8914,
0x8915,0x8916,0x8917,0x8918,0x891C,0x891D,0x891E,0x891F,
0x8920,0x8922,0x8923,0x8924,0x8926,0x8927,0x8928,0x8929,
0x892C,0x892D,0x892E,0x892F,0x8931,0x8932,0x8933,0x8935,
0x8937,0x9009,0x7663,0x7729,0x7EDA,0x9774,0x859B,0x5B66,
0x7A74,0x96EA,0x8840,0x52CB,0x718F,0x5FAA,0x65EC,0x8BE2,
0x5BFB,0x9A6F,0x5DE1,0x6B89,0x6C5B,0x8BAD,0x8BAF,0x900A,
0x8FC5,0x538B,0x62BC,0x9E26,0x9E2D,0x5440,0x4E2B,0x82BD,
0x7259,0x869C,0x5D16,0x8859,0x6DAF,0x96C5,0x54D1,0x4E9A,
0x8BB6,0x7109,0x54BD,0x9609,0x70DF,0x6DF9,0x76D0,0x4E25,
0x7814,0x8712,0x5CA9,0x5EF6,0x8A00,0x989C,0x960E,0x708E,
0x6CBF,0x5944,0x63A9,0x773C,0x884D,0x6F14,0x8273,0x5830,
0x71D5,0x538C,0x781A,0x96C1,0x5501,0x5F66,0x7130,0x5BB4,
0x8C1A,0x9A8C,0x6B83,0x592E,0x9E2F,0x79E7,0x6768,0x626C,
0x4F6F,0x75A1,0x7F8A,0x6D0B,0x9633,0x6C27,0x4EF0,0x75D2,
0x517B,0x6837,0x6F3E,0x9080,0x8170,0x5996,0x7476,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8938,0x8939,0x893A,0x893B,0x893C,0x893D,0x893E,0x893F,
0x8940,0x8942,0x8943,0x8945,0x8946,0x8947,0x8948,0x8949,
0x894A,0x894B,0x894C,0x894D,0x894E,0x894F,0x8950,0x8951,
0x8952,0x8953,0x8954,0x8955,0x8956,0x8957,0x8958,0x8959,
0x895A,0x895B,0x895C,0x895D,0x8960,0x8961,0x8962,0x8963,
0x8964,0x8965,0x8967,0x8968,0x8969,0x896A,0x896B,0x896C,
0x896D,0x896E,0x896F,0x8970,0x8971,0x8972,0x8973,0x8974,
0x8975,0x8976,0x8977,0x8978,0x8979,0x897A,0x897C,     0,
0x897D,0x897E,0x8980,0x8982,0x8984,0x8985,0x8987,0x8988,
0x8989,0x898A,0x898B,0x898C,0x898D,0x898E,0x898F,0x8990,
0x8991,0x8992,0x8993,0x8994,0x8995,0x8996,0x8997,0x8998,
0x8999,0x899A,0x899B,0x899C,0x899D,0x899E,0x899F,0x89A0,
0x89A1,0x6447,0x5C27,0x9065,0x7A91,0x8C23,0x59DA,0x54AC,
0x8200,0x836F,0x8981,0x8000,0x6930,0x564E,0x8036,0x7237,
0x91CE,0x51B6,0x4E5F,0x9875,0x6396,0x4E1A,0x53F6,0x66F3,
0x814B,0x591C,0x6DB2,0x4E00,0x58F9,0x533B,0x63D6,0x94F1,
0x4F9D,0x4F0A,0x8863,0x9890,0x5937,0x9057,0x79FB,0x4EEA,
0x80F0,0x7591,0x6C82,0x5B9C,0x59E8,0x5F5D,0x6905,0x8681,
0x501A,0x5DF2,0x4E59,0x77E3,0x4EE5,0x827A,0x6291,0x6613,
0x9091,0x5C79,0x4EBF,0x5F79,0x81C6,0x9038,0x8084,0x75AB,
0x4EA6,0x88D4,0x610F,0x6BC5,0x5FC6,0x4E49,0x76CA,0x6EA2,
0x8BE3,0x8BAE,0x8C0A,0x8BD1,0x5F02,0x7FFC,0x7FCC,0x7ECE,
0x8335,0x836B,0x56E0,0x6BB7,0x97F3,0x9634,0x59FB,0x541F,
0x94F6,0x6DEB,0x5BC5,0x996E,0x5C39,0x5F15,0x9690,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x89A2,0x89A3,0x89A4,0x89A5,0x89A6,0x89A7,0x89A8,0x89A9,
0x89AA,0x89AB,0x89AC,0x89AD,0x89AE,0x89AF,0x89B0,0x89B1,
0x89B2,0x89B3,0x89B4,0x89B5,0x89B6,0x89B7,0x89B8,0x89B9,
0x89BA,0x89BB,0x89BC,0x89BD,0x89BE,0x89BF,0x89C0,0x89C3,
0x89CD,0x89D3,0x89D4,0x89D5,0x89D7,0x89D8,0x89D9,0x89DB,
0x89DD,0x89DF,0x89E0,0x89E1,0x89E2,0x89E4,0x89E7,0x89E8,
0x89E9,0x89EA,0x89EC,0x89ED,0x89EE,0x89F0,0x89F1,0x89F2,
0x89F4,0x89F5,0x89F6,0x89F7,0x89F8,0x89F9,0x89FA,     0,
0x89FB,0x89FC,0x89FD,0x89FE,0x89FF,0x8A01,0x8A02,0x8A03,
0x8A04,0x8A05,0x8A06,0x8A08,0x8A09,0x8A0A,0x8A0B,0x8A0C,
0x8A0D,0x8A0E,0x8A0F,0x8A10,0x8A11,0x8A12,0x8A13,0x8A14,
0x8A15,0x8A16,0x8A17,0x8A18,0x8A19,0x8A1A,0x8A1B,0x8A1C,
0x8A1D,0x5370,0x82F1,0x6A31,0x5A74,0x9E70,0x5E94,0x7F28,
0x83B9,0x8424,0x8425,0x8367,0x8747,0x8FCE,0x8D62,0x76C8,
0x5F71,0x9896,0x786C,0x6620,0x54DF,0x62E5,0x4F63,0x81C3,
0x75C8,0x5EB8,0x96CD,0x8E0A,0x86F9,0x548F,0x6CF3,0x6D8C,
0x6C38,0x607F,0x52C7,0x7528,0x5E7D,0x4F18,0x60A0,0x5FE7,
0x5C24,0x7531,0x90AE,0x94C0,0x72B9,0x6CB9,0x6E38,0x9149,
0x6709,0x53CB,0x53F3,0x4F51,0x91C9,0x8BF1,0x53C8,0x5E7C,
0x8FC2,0x6DE4,0x4E8E,0x76C2,0x6986,0x865E,0x611A,0x8206,
0x4F59,0x4FDE,0x903E,0x9C7C,0x6109,0x6E1D,0x6E14,0x9685,
0x4E88,0x5A31,0x96E8,0x4E0E,0x5C7F,0x79B9,0x5B87,0x8BED,
0x7FBD,0x7389,0x57DF,0x828B,0x90C1,0x5401,0x9047,0x55BB,
0x5CEA,0x5FA1,0x6108,0x6B32,0x72F1,0x80B2,0x8A89,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8A1E,0x8A1F,0x8A20,0x8A21,0x8A22,0x8A23,0x8A24,0x8A25,
0x8A26,0x8A27,0x8A28,0x8A29,0x8A2A,0x8A2B,0x8A2C,0x8A2D,
0x8A2E,0x8A2F,0x8A30,0x8A31,0x8A32,0x8A33,0x8A34,0x8A35,
0x8A36,0x8A37,0x8A38,0x8A39,0x8A3A,0x8A3B,0x8A3C,0x8A3D,
0x8A3F,0x8A40,0x8A41,0x8A42,0x8A43,0x8A44,0x8A45,0x8A46,
0x8A47,0x8A49,0x8A4A,0x8A4B,0x8A4C,0x8A4D,0x8A4E,0x8A4F,
0x8A50,0x8A51,0x8A52,0x8A53,0x8A54,0x8A55,0x8A56,0x8A57,
0x8A58,0x8A59,0x8A5A,0x8A5B,0x8A5C,0x8A5D,0x8A5E,     0,
0x8A5F,0x8A60,0x8A61,0x8A62,0x8A63,0x8A64,0x8A65,0x8A66,
0x8A67,0x8A68,0x8A69,0x8A6A,0x8A6B,0x8A6C,0x8A6D,0x8A6E,
0x8A6F,0x8A70,0x8A71,0x8A72,0x8A73,0x8A74,0x8A75,0x8A76,
0x8A77,0x8A78,0x8A7A,0x8A7B,0x8A7C,0x8A7D,0x8A7E,0x8A7F,
0x8A80,0x6D74,0x5BD3,0x88D5,0x9884,0x8C6B,0x9A6D,0x9E33,
0x6E0A,0x51A4,0x5143,0x57A3,0x8881,0x539F,0x63F4,0x8F95,
0x56ED,0x5458,0x5706,0x733F,0x6E90,0x7F18,0x8FDC,0x82D1,
0x613F,0x6028,0x9662,0x66F0,0x7EA6,0x8D8A,0x8DC3,0x94A5,
0x5CB3,0x7CA4,0x6708,0x60A6,0x9605,0x8018,0x4E91,0x90E7,
0x5300,0x9668,0x5141,0x8FD0,0x8574,0x915D,0x6655,0x97F5,
0x5B55,0x531D,0x7838,0x6742,0x683D,0x54C9,0x707E,0x5BB0,
0x8F7D,0x518D,0x5728,0x54B1,0x6512,0x6682,0x8D5E,0x8D43,
0x810F,0x846C,0x906D,0x7CDF,0x51FF,0x85FB,0x67A3,0x65E9,
0x6FA1,0x86A4,0x8E81,0x566A,0x9020,0x7682,0x7076,0x71E5,
0x8D23,0x62E9,0x5219,0x6CFD,0x8D3C,0x600E,0x589E,0x618E,
0x66FE,0x8D60,0x624E,0x55B3,0x6E23,0x672D,0x8F67,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8A81,0x8A82,0x8A83,0x8A84,0x8A85,0x8A86,0x8A87,0x8A88,
0x8A8B,0x8A8C,0x8A8D,0x8A8E,0x8A8F,0x8A90,0x8A91,0x8A92,
0x8A94,0x8A95,0x8A96,0x8A97,0x8A98,0x8A99,0x8A9A,0x8A9B,
0x8A9C,0x8A9D,0x8A9E,0x8A9F,0x8AA0,0x8AA1,0x8AA2,0x8AA3,
0x8AA4,0x8AA5,0x8AA6,0x8AA7,0x8AA8,0x8AA9,0x8AAA,0x8AAB,
0x8AAC,0x8AAD,0x8AAE,0x8AAF,0x8AB0,0x8AB1,0x8AB2,0x8AB3,
0x8AB4,0x8AB5,0x8AB6,0x8AB7,0x8AB8,0x8AB9,0x8ABA,0x8ABB,
0x8ABC,0x8ABD,0x8ABE,0x8ABF,0x8AC0,0x8AC1,0x8AC2,     0,
0x8AC3,0x8AC4,0x8AC5,0x8AC6,0x8AC7,0x8AC8,0x8AC9,0x8ACA,
0x8ACB,0x8ACC,0x8ACD,0x8ACE,0x8ACF,0x8AD0,0x8AD1,0x8AD2,
0x8AD3,0x8AD4,0x8AD5,0x8AD6,0x8AD7,0x8AD8,0x8AD9,0x8ADA,
0x8ADB,0x8ADC,0x8ADD,0x8ADE,0x8ADF,0x8AE0,0x8AE1,0x8AE2,
0x8AE3,0x94E1,0x95F8,0x7728,0x6805,0x69A8,0x548B,0x4E4D,
0x70B8,0x8BC8,0x6458,0x658B,0x5B85,0x7A84,0x503A,0x5BE8,
0x77BB,0x6BE1,0x8A79,0x7C98,0x6CBE,0x76CF,0x65A9,0x8F97,
0x5D2D,0x5C55,0x8638,0x6808,0x5360,0x6218,0x7AD9,0x6E5B,
0x7EFD,0x6A1F,0x7AE0,0x5F70,0x6F33,0x5F20,0x638C,0x6DA8,
0x6756,0x4E08,0x5E10,0x8D26,0x4ED7,0x80C0,0x7634,0x969C,
0x62DB,0x662D,0x627E,0x6CBC,0x8D75,0x7167,0x7F69,0x5146,
0x8087,0x53EC,0x906E,0x6298,0x54F2,0x86F0,0x8F99,0x8005,
0x9517,0x8517,0x8FD9,0x6D59,0x73CD,0x659F,0x771F,0x7504,
0x7827,0x81FB,0x8D1E,0x9488,0x4FA6,0x6795,0x75B9,0x8BCA,
0x9707,0x632F,0x9547,0x9635,0x84B8,0x6323,0x7741,0x5F81,
0x72F0,0x4E89,0x6014,0x6574,0x62EF,0x6B63,0x653F,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8AE4,0x8AE5,0x8AE6,0x8AE7,0x8AE8,0x8AE9,0x8AEA,0x8AEB,
0x8AEC,0x8AED,0x8AEE,0x8AEF,0x8AF0,0x8AF1,0x8AF2,0x8AF3,
0x8AF4,0x8AF5,0x8AF6,0x8AF7,0x8AF8,0x8AF9,0x8AFA,0x8AFB,
0x8AFC,0x8AFD,0x8AFE,0x8AFF,0x8B00,0x8B01,0x8B02,0x8B03,
0x8B04,0x8B05,0x8B06,0x8B08,0x8B09,0x8B0A,0x8B0B,0x8B0C,
0x8B0D,0x8B0E,0x8B0F,0x8B10,0x8B11,0x8B12,0x8B13,0x8B14,
0x8B15,0x8B16,0x8B17,0x8B18,0x8B19,0x8B1A,0x8B1B,0x8B1C,
0x8B1D,0x8B1E,0x8B1F,0x8B20,0x8B21,0x8B22,0x8B23,     0,
0x8B24,0x8B25,0x8B27,0x8B28,0x8B29,0x8B2A,0x8B2B,0x8B2C,
0x8B2D,0x8B2E,0x8B2F,0x8B30,0x8B31,0x8B32,0x8B33,0x8B34,
0x8B35,0x8B36,0x8B37,0x8B38,0x8B39,0x8B3A,0x8B3B,0x8B3C,
0x8B3D,0x8B3E,0x8B3F,0x8B40,0x8B41,0x8B42,0x8B43,0x8B44,
0x8B45,0x5E27,0x75C7,0x90D1,0x8BC1,0x829D,0x679D,0x652F,
0x5431,0x8718,0x77E5,0x80A2,0x8102,0x6C41,0x4E4B,0x7EC7,
0x804C,0x76F4,0x690D,0x6B96,0x6267,0x503C,0x4F84,0x5740,
0x6307,0x6B62,0x8DBE,0x53EA,0x65E8,0x7EB8,0x5FD7,0x631A,
0x63B7,0x81F3,0x81F4,0x7F6E,0x5E1C,0x5CD9,0x5236,0x667A,
0x79E9,0x7A1A,0x8D28,0x7099,0x75D4,0x6EDE,0x6CBB,0x7A92,
0x4E2D,0x76C5,0x5FE0,0x949F,0x8877,0x7EC8,0x79CD,0x80BF,
0x91CD,0x4EF2,0x4F17,0x821F,0x5468,0x5DDE,0x6D32,0x8BCC,
0x7CA5,0x8F74,0x8098,0x5E1A,0x5492,0x76B1,0x5B99,0x663C,
0x9AA4,0x73E0,0x682A,0x86DB,0x6731,0x732A,0x8BF8,0x8BDB,
0x9010,0x7AF9,0x70DB,0x716E,0x62C4,0x77A9,0x5631,0x4E3B,
0x8457,0x67F1,0x52A9,0x86C0,0x8D2E,0x94F8,0x7B51,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8B46,0x8B47,0x8B48,0x8B49,0x8B4A,0x8B4B,0x8B4C,0x8B4D,
0x8B4E,0x8B4F,0x8B50,0x8B51,0x8B52,0x8B53,0x8B54,0x8B55,
0x8B56,0x8B57,0x8B58,0x8B59,0x8B5A,0x8B5B,0x8B5C,0x8B5D,
0x8B5E,0x8B5F,0x8B60,0x8B61,0x8B62,0x8B63,0x8B64,0x8B65,
0x8B67,0x8B68,0x8B69,0x8B6A,0x8B6B,0x8B6D,0x8B6E,0x8B6F,
0x8B70,0x8B71,0x8B72,0x8B73,0x8B74,0x8B75,0x8B76,0x8B77,
0x8B78,0x8B79,0x8B7A,0x8B7B,0x8B7C,0x8B7D,0x8B7E,0x8B7F,
0x8B80,0x8B81,0x8B82,0x8B83,0x8B84,0x8B85,0x8B86,     0,
0x8B87,0x8B88,0x8B89,0x8B8A,0x8B8B,0x8B8C,0x8B8D,0x8B8E,
0x8B8F,0x8B90,0x8B91,0x8B92,0x8B93,0x8B94,0x8B95,0x8B96,
0x8B97,0x8B98,0x8B99,0x8B9A,0x8B9B,0x8B9C,0x8B9D,0x8B9E,
0x8B9F,0x8BAC,0x8BB1,0x8BBB,0x8BC7,0x8BD0,0x8BEA,0x8C09,
0x8C1E,0x4F4F,0x6CE8,0x795D,0x9A7B,0x6293,0x722A,0x62FD,
0x4E13,0x7816,0x8F6C,0x64B0,0x8D5A,0x7BC6,0x6869,0x5E84,
0x88C5,0x5986,0x649E,0x58EE,0x72B6,0x690E,0x9525,0x8FFD,
0x8D58,0x5760,0x7F00,0x8C06,0x51C6,0x6349,0x62D9,0x5353,
0x684C,0x7422,0x8301,0x914C,0x5544,0x7740,0x707C,0x6D4A,
0x5179,0x54A8,0x8D44,0x59FF,0x6ECB,0x6DC4,0x5B5C,0x7D2B,
0x4ED4,0x7C7D,0x6ED3,0x5B50,0x81EA,0x6E0D,0x5B57,0x9B03,
0x68D5,0x8E2A,0x5B97,0x7EFC,0x603B,0x7EB5,0x90B9,0x8D70,
0x594F,0x63CD,0x79DF,0x8DB3,0x5352,0x65CF,0x7956,0x8BC5,
0x963B,0x7EC4,0x94BB,0x7E82,0x5634,0x9189,0x6700,0x7F6A,
0x5C0A,0x9075,0x6628,0x5DE6,0x4F50,0x67DE,0x505A,0x4F5C,
0x5750,0x5EA7,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8C38,0x8C39,0x8C3A,0x8C3B,0x8C3C,0x8C3D,0x8C3E,0x8C3F,
0x8C40,0x8C42,0x8C43,0x8C44,0x8C45,0x8C48,0x8C4A,0x8C4B,
0x8C4D,0x8C4E,0x8C4F,0x8C50,0x8C51,0x8C52,0x8C53,0x8C54,
0x8C56,0x8C57,0x8C58,0x8C59,0x8C5B,0x8C5C,0x8C5D,0x8C5E,
0x8C5F,0x8C60,0x8C63,0x8C64,0x8C65,0x8C66,0x8C67,0x8C68,
0x8C69,0x8C6C,0x8C6D,0x8C6E,0x8C6F,0x8C70,0x8C71,0x8C72,
0x8C74,0x8C75,0x8C76,0x8C77,0x8C7B,0x8C7C,0x8C7D,0x8C7E,
0x8C7F,0x8C80,0x8C81,0x8C83,0x8C84,0x8C86,0x8C87,     0,
0x8C88,0x8C8B,0x8C8D,0x8C8E,0x8C8F,0x8C90,0x8C91,0x8C92,
0x8C93,0x8C95,0x8C96,0x8C97,0x8C99,0x8C9A,0x8C9B,0x8C9C,
0x8C9D,0x8C9E,0x8C9F,0x8CA0,0x8CA1,0x8CA2,0x8CA3,0x8CA4,
0x8CA5,0x8CA6,0x8CA7,0x8CA8,0x8CA9,0x8CAA,0x8CAB,0x8CAC,
0x8CAD,0x4E8D,0x4E0C,0x5140,0x4E10,0x5EFF,0x5345,0x4E15,
0x4E98,0x4E1E,0x9B32,0x5B6C,0x5669,0x4E28,0x79BA,0x4E3F,
0x5315,0x4E47,0x592D,0x723B,0x536E,0x6C10,0x56DF,0x80E4,
0x9997,0x6BD3,0x777E,0x9F17,0x4E36,0x4E9F,0x9F10,0x4E5C,
0x4E69,0x4E93,0x8288,0x5B5B,0x556C,0x560F,0x4EC4,0x538D,
0x539D,0x53A3,0x53A5,0x53AE,0x9765,0x8D5D,0x531A,0x53F5,
0x5326,0x532E,0x533E,0x8D5C,0x5366,0x5363,0x5202,0x5208,
0x520E,0x522D,0x5233,0x523F,0x5240,0x524C,0x525E,0x5261,
0x525C,0x84AF,0x527D,0x5282,0x5281,0x5290,0x5293,0x5182,
0x7F54,0x4EBB,0x4EC3,0x4EC9,0x4EC2,0x4EE8,0x4EE1,0x4EEB,
0x4EDE,0x4F1B,0x4EF3,0x4F22,0x4F64,0x4EF5,0x4F25,0x4F27,
0x4F09,0x4F2B,0x4F5E,0x4F67,0x6538,0x4F5A,0x4F5D,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8CAE,0x8CAF,0x8CB0,0x8CB1,0x8CB2,0x8CB3,0x8CB4,0x8CB5,
0x8CB6,0x8CB7,0x8CB8,0x8CB9,0x8CBA,0x8CBB,0x8CBC,0x8CBD,
0x8CBE,0x8CBF,0x8CC0,0x8CC1,0x8CC2,0x8CC3,0x8CC4,0x8CC5,
0x8CC6,0x8CC7,0x8CC8,0x8CC9,0x8CCA,0x8CCB,0x8CCC,0x8CCD,
0x8CCE,0x8CCF,0x8CD0,0x8CD1,0x8CD2,0x8CD3,0x8CD4,0x8CD5,
0x8CD6,0x8CD7,0x8CD8,0x8CD9,0x8CDA,0x8CDB,0x8CDC,0x8CDD,
0x8CDE,0x8CDF,0x8CE0,0x8CE1,0x8CE2,0x8CE3,0x8CE4,0x8CE5,
0x8CE6,0x8CE7,0x8CE8,0x8CE9,0x8CEA,0x8CEB,0x8CEC,     0,
0x8CED,0x8CEE,0x8CEF,0x8CF0,0x8CF1,0x8CF2,0x8CF3,0x8CF4,
0x8CF5,0x8CF6,0x8CF7,0x8CF8,0x8CF9,0x8CFA,0x8CFB,0x8CFC,
0x8CFD,0x8CFE,0x8CFF,0x8D00,0x8D01,0x8D02,0x8D03,0x8D04,
0x8D05,0x8D06,0x8D07,0x8D08,0x8D09,0x8D0A,0x8D0B,0x8D0C,
0x8D0D,0x4F5F,0x4F57,0x4F32,0x4F3D,0x4F76,0x4F74,0x4F91,
0x4F89,0x4F83,0x4F8F,0x4F7E,0x4F7B,0x4FAA,0x4F7C,0x4FAC,
0x4F94,0x4FE6,0x4FE8,0x4FEA,0x4FC5,0x4FDA,0x4FE3,0x4FDC,
0x4FD1,0x4FDF,0x4FF8,0x5029,0x504C,0x4FF3,0x502C,0x500F,
0x502E,0x502D,0x4FFE,0x501C,0x500C,0x5025,0x5028,0x507E,
0x5043,0x5055,0x5048,0x504E,0x506C,0x507B,0x50A5,0x50A7,
0x50A9,0x50BA,0x50D6,0x5106,0x50ED,0x50EC,0x50E6,0x50EE,
0x5107,0x510B,0x4EDD,0x6C3D,0x4F58,0x4F65,0x4FCE,0x9FA0,
0x6C46,0x7C74,0x516E,0x5DFD,0x9EC9,0x9998,0x5181,0x5914,
0x52F9,0x530D,0x8A07,0x5310,0x51EB,0x5919,0x5155,0x4EA0,
0x5156,0x4EB3,0x886E,0x88A4,0x4EB5,0x8114,0x88D2,0x7980,
0x5B34,0x8803,0x7FB8,0x51AB,0x51B1,0x51BD,0x51BC,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8D0E,0x8D0F,0x8D10,0x8D11,0x8D12,0x8D13,0x8D14,0x8D15,
0x8D16,0x8D17,0x8D18,0x8D19,0x8D1A,0x8D1B,0x8D1C,0x8D20,
0x8D51,0x8D52,0x8D57,0x8D5F,0x8D65,0x8D68,0x8D69,0x8D6A,
0x8D6C,0x8D6E,0x8D6F,0x8D71,0x8D72,0x8D78,0x8D79,0x8D7A,
0x8D7B,0x8D7C,0x8D7D,0x8D7E,0x8D7F,0x8D80,0x8D82,0x8D83,
0x8D86,0x8D87,0x8D88,0x8D89,0x8D8C,0x8D8D,0x8D8E,0x8D8F,
0x8D90,0x8D92,0x8D93,0x8D95,0x8D96,0x8D97,0x8D98,0x8D99,
0x8D9A,0x8D9B,0x8D9C,0x8D9D,0x8D9E,0x8DA0,0x8DA1,     0,
0x8DA2,0x8DA4,0x8DA5,0x8DA6,0x8DA7,0x8DA8,0x8DA9,0x8DAA,
0x8DAB,0x8DAC,0x8DAD,0x8DAE,0x8DAF,0x8DB0,0x8DB2,0x8DB6,
0x8DB7,0x8DB9,0x8DBB,0x8DBD,0x8DC0,0x8DC1,0x8DC2,0x8DC5,
0x8DC7,0x8DC8,0x8DC9,0x8DCA,0x8DCD,0x8DD0,0x8DD2,0x8DD3,
0x8DD4,0x51C7,0x5196,0x51A2,0x51A5,0x8BA0,0x8BA6,0x8BA7,
0x8BAA,0x8BB4,0x8BB5,0x8BB7,0x8BC2,0x8BC3,0x8BCB,0x8BCF,
0x8BCE,0x8BD2,0x8BD3,0x8BD4,0x8BD6,0x8BD8,0x8BD9,0x8BDC,
0x8BDF,0x8BE0,0x8BE4,0x8BE8,0x8BE9,0x8BEE,0x8BF0,0x8BF3,
0x8BF6,0x8BF9,0x8BFC,0x8BFF,0x8C00,0x8C02,0x8C04,0x8C07,
0x8C0C,0x8C0F,0x8C11,0x8C12,0x8C14,0x8C15,0x8C16,0x8C19,
0x8C1B,0x8C18,0x8C1D,0x8C1F,0x8C20,0x8C21,0x8C25,0x8C27,
0x8C2A,0x8C2B,0x8C2E,0x8C2F,0x8C32,0x8C33,0x8C35,0x8C36,
0x5369,0x537A,0x961D,0x9622,0x9621,0x9631,0x962A,0x963D,
0x963C,0x9642,0x9649,0x9654,0x965F,0x9667,0x966C,0x9672,
0x9674,0x9688,0x968D,0x9697,0x96B0,0x9097,0x909B,0x909D,
0x9099,0x90AC,0x90A1,0x90B4,0x90B3,0x90B6,0x90BA,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8DD5,0x8DD8,0x8DD9,0x8DDC,0x8DE0,0x8DE1,0x8DE2,0x8DE5,
0x8DE6,0x8DE7,0x8DE9,0x8DED,0x8DEE,0x8DF0,0x8DF1,0x8DF2,
0x8DF4,0x8DF6,0x8DFC,0x8DFE,0x8DFF,0x8E00,0x8E01,0x8E02,
0x8E03,0x8E04,0x8E06,0x8E07,0x8E08,0x8E0B,0x8E0D,0x8E0E,
0x8E10,0x8E11,0x8E12,0x8E13,0x8E15,0x8E16,0x8E17,0x8E18,
0x8E19,0x8E1A,0x8E1B,0x8E1C,0x8E20,0x8E21,0x8E24,0x8E25,
0x8E26,0x8E27,0x8E28,0x8E2B,0x8E2D,0x8E30,0x8E32,0x8E33,
0x8E34,0x8E36,0x8E37,0x8E38,0x8E3B,0x8E3C,0x8E3E,     0,
0x8E3F,0x8E43,0x8E45,0x8E46,0x8E4C,0x8E4D,0x8E4E,0x8E4F,
0x8E50,0x8E53,0x8E54,0x8E55,0x8E56,0x8E57,0x8E58,0x8E5A,
0x8E5B,0x8E5C,0x8E5D,0x8E5E,0x8E5F,0x8E60,0x8E61,0x8E62,
0x8E63,0x8E64,0x8E65,0x8E67,0x8E68,0x8E6A,0x8E6B,0x8E6E,
0x8E71,0x90B8,0x90B0,0x90CF,0x90C5,0x90BE,0x90D0,0x90C4,
0x90C7,0x90D3,0x90E6,0x90E2,0x90DC,0x90D7,0x90DB,0x90EB,
0x90EF,0x90FE,0x9104,0x9122,0x911E,0x9123,0x9131,0x912F,
0x9139,0x9143,0x9146,0x520D,0x5942,0x52A2,0x52AC,0x52AD,
0x52BE,0x54FF,0x52D0,0x52D6,0x52F0,0x53DF,0x71EE,0x77CD,
0x5EF4,0x51F5,0x51FC,0x9B2F,0x53B6,0x5F01,0x755A,0x5DEF,
0x574C,0x57A9,0x57A1,0x587E,0x58BC,0x58C5,0x58D1,0x5729,
0x572C,0x572A,0x5733,0x5739,0x572E,0x572F,0x575C,0x573B,
0x5742,0x5769,0x5785,0x576B,0x5786,0x577C,0x577B,0x5768,
0x576D,0x5776,0x5773,0x57AD,0x57A4,0x578C,0x57B2,0x57CF,
0x57A7,0x57B4,0x5793,0x57A0,0x57D5,0x57D8,0x57DA,0x57D9,
0x57D2,0x57B8,0x57F4,0x57EF,0x57F8,0x57E4,0x57DD,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8E73,0x8E75,0x8E77,0x8E78,0x8E79,0x8E7A,0x8E7B,0x8E7D,
0x8E7E,0x8E80,0x8E82,0x8E83,0x8E84,0x8E86,0x8E88,0x8E89,
0x8E8A,0x8E8B,0x8E8C,0x8E8D,0x8E8E,0x8E91,0x8E92,0x8E93,
0x8E95,0x8E96,0x8E97,0x8E98,0x8E99,0x8E9A,0x8E9B,0x8E9D,
0x8E9F,0x8EA0,0x8EA1,0x8EA2,0x8EA3,0x8EA4,0x8EA5,0x8EA6,
0x8EA7,0x8EA8,0x8EA9,0x8EAA,0x8EAD,0x8EAE,0x8EB0,0x8EB1,
0x8EB3,0x8EB4,0x8EB5,0x8EB6,0x8EB7,0x8EB8,0x8EB9,0x8EBB,
0x8EBC,0x8EBD,0x8EBE,0x8EBF,0x8EC0,0x8EC1,0x8EC2,     0,
0x8EC3,0x8EC4,0x8EC5,0x8EC6,0x8EC7,0x8EC8,0x8EC9,0x8ECA,
0x8ECB,0x8ECC,0x8ECD,0x8ECF,0x8ED0,0x8ED1,0x8ED2,0x8ED3,
0x8ED4,0x8ED5,0x8ED6,0x8ED7,0x8ED8,0x8ED9,0x8EDA,0x8EDB,
0x8EDC,0x8EDD,0x8EDE,0x8EDF,0x8EE0,0x8EE1,0x8EE2,0x8EE3,
0x8EE4,0x580B,0x580D,0x57FD,0x57ED,0x5800,0x581E,0x5819,
0x5844,0x5820,0x5865,0x586C,0x5881,0x5889,0x589A,0x5880,
0x99A8,0x9F19,0x61FF,0x8279,0x827D,0x827F,0x828F,0x828A,
0x82A8,0x8284,0x828E,0x8291,0x8297,0x8299,0x82AB,0x82B8,
0x82BE,0x82B0,0x82C8,0x82CA,0x82E3,0x8298,0x82B7,0x82AE,
0x82CB,0x82CC,0x82C1,0x82A9,0x82B4,0x82A1,0x82AA,0x829F,
0x82C4,0x82CE,0x82A4,0x82E1,0x8309,0x82F7,0x82E4,0x830F,
0x8307,0x82DC,0x82F4,0x82D2,0x82D8,0x830C,0x82FB,0x82D3,
0x8311,0x831A,0x8306,0x8314,0x8315,0x82E0,0x82D5,0x831C,
0x8351,0x835B,0x835C,0x8308,0x8392,0x833C,0x8334,0x8331,
0x839B,0x835E,0x832F,0x834F,0x8347,0x8343,0x835F,0x8340,
0x8317,0x8360,0x832D,0x833A,0x8333,0x8366,0x8365,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8EE5,0x8EE6,0x8EE7,0x8EE8,0x8EE9,0x8EEA,0x8EEB,0x8EEC,
0x8EED,0x8EEE,0x8EEF,0x8EF0,0x8EF1,0x8EF2,0x8EF3,0x8EF4,
0x8EF5,0x8EF6,0x8EF7,0x8EF8,0x8EF9,0x8EFA,0x8EFB,0x8EFC,
0x8EFD,0x8EFE,0x8EFF,0x8F00,0x8F01,0x8F02,0x8F03,0x8F04,
0x8F05,0x8F06,0x8F07,0x8F08,0x8F09,0x8F0A,0x8F0B,0x8F0C,
0x8F0D,0x8F0E,0x8F0F,0x8F10,0x8F11,0x8F12,0x8F13,0x8F14,
0x8F15,0x8F16,0x8F17,0x8F18,0x8F19,0x8F1A,0x8F1B,0x8F1C,
0x8F1D,0x8F1E,0x8F1F,0x8F20,0x8F21,0x8F22,0x8F23,     0,
0x8F24,0x8F25,0x8F26,0x8F27,0x8F28,0x8F29,0x8F2A,0x8F2B,
0x8F2C,0x8F2D,0x8F2E,0x8F2F,0x8F30,0x8F31,0x8F32,0x8F33,
0x8F34,0x8F35,0x8F36,0x8F37,0x8F38,0x8F39,0x8F3A,0x8F3B,
0x8F3C,0x8F3D,0x8F3E,0x8F3F,0x8F40,0x8F41,0x8F42,0x8F43,
0x8F44,0x8368,0x831B,0x8369,0x836C,0x836A,0x836D,0x836E,
0x83B0,0x8378,0x83B3,0x83B4,0x83A0,0x83AA,0x8393,0x839C,
0x8385,0x837C,0x83B6,0x83A9,0x837D,0x83B8,0x837B,0x8398,
0x839E,0x83A8,0x83BA,0x83BC,0x83C1,0x8401,0x83E5,0x83D8,
0x5807,0x8418,0x840B,0x83DD,0x83FD,0x83D6,0x841C,0x8438,
0x8411,0x8406,0x83D4,0x83DF,0x840F,0x8403,0x83F8,0x83F9,
0x83EA,0x83C5,0x83C0,0x8426,0x83F0,0x83E1,0x845C,0x8451,
0x845A,0x8459,0x8473,0x8487,0x8488,0x847A,0x8489,0x8478,
0x843C,0x8446,0x8469,0x8476,0x848C,0x848E,0x8431,0x846D,
0x84C1,0x84CD,0x84D0,0x84E6,0x84BD,0x84D3,0x84CA,0x84BF,
0x84BA,0x84E0,0x84A1,0x84B9,0x84B4,0x8497,0x84E5,0x84E3,
0x850C,0x750D,0x8538,0x84F0,0x8539,0x851F,0x853A,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x8F45,0x8F46,0x8F47,0x8F48,0x8F49,0x8F4A,0x8F4B,0x8F4C,
0x8F4D,0x8F4E,0x8F4F,0x8F50,0x8F51,0x8F52,0x8F53,0x8F54,
0x8F55,0x8F56,0x8F57,0x8F58,0x8F59,0x8F5A,0x8F5B,0x8F5C,
0x8F5D,0x8F5E,0x8F5F,0x8F60,0x8F61,0x8F62,0x8F63,0x8F64,
0x8F65,0x8F6A,0x8F80,0x8F8C,0x8F92,0x8F9D,0x8FA0,0x8FA1,
0x8FA2,0x8FA4,0x8FA5,0x8FA6,0x8FA7,0x8FAA,0x8FAC,0x8FAD,
0x8FAE,0x8FAF,0x8FB2,0x8FB3,0x8FB4,0x8FB5,0x8FB7,0x8FB8,
0x8FBA,0x8FBB,0x8FBC,0x8FBF,0x8FC0,0x8FC3,0x8FC6,     0,
0x8FC9,0x8FCA,0x8FCB,0x8FCC,0x8FCD,0x8FCF,0x8FD2,0x8FD6,
0x8FD7,0x8FDA,0x8FE0,0x8FE1,0x8FE3,0x8FE7,0x8FEC,0x8FEF,
0x8FF1,0x8FF2,0x8FF4,0x8FF5,0x8FF6,0x8FFA,0x8FFB,0x8FFC,
0x8FFE,0x8FFF,0x9007,0x9008,0x900C,0x900E,0x9013,0x9015,
0x9018,0x8556,0x853B,0x84FF,0x84FC,0x8559,0x8548,0x8568,
0x8564,0x855E,0x857A,0x77A2,0x8543,0x8572,0x857B,0x85A4,
0x85A8,0x8587,0x858F,0x8579,0x85AE,0x859C,0x8585,0x85B9,
0x85B7,0x85B0,0x85D3,0x85C1,0x85DC,0x85FF,0x8627,0x8605,
0x8629,0x8616,0x863C,0x5EFE,0x5F08,0x593C,0x5941,0x8037,
0x5955,0x595A,0x5958,0x530F,0x5C22,0x5C25,0x5C2C,0x5C34,
0x624C,0x626A,0x629F,0x62BB,0x62CA,0x62DA,0x62D7,0x62EE,
0x6322,0x62F6,0x6339,0x634B,0x6343,0x63AD,0x63F6,0x6371,
0x637A,0x638E,0x63B4,0x636D,0x63AC,0x638A,0x6369,0x63AE,
0x63BC,0x63F2,0x63F8,0x63E0,0x63FF,0x63C4,0x63DE,0x63CE,
0x6452,0x63C6,0x63BE,0x6445,0x6441,0x640B,0x641B,0x6420,
0x640C,0x6426,0x6421,0x645E,0x6484,0x646D,0x6496,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9019,0x901C,0x9023,0x9024,0x9025,0x9027,0x9028,0x9029,
0x902A,0x902B,0x902C,0x9030,0x9031,0x9032,0x9033,0x9034,
0x9037,0x9039,0x903A,0x903D,0x903F,0x9040,0x9043,0x9045,
0x9046,0x9048,0x9049,0x904A,0x904B,0x904C,0x904E,0x9054,
0x9055,0x9056,0x9059,0x905A,0x905C,0x905D,0x905E,0x905F,
0x9060,0x9061,0x9064,0x9066,0x9067,0x9069,0x906A,0x906B,
0x906C,0x906F,0x9070,0x9071,0x9072,0x9073,0x9076,0x9077,
0x9078,0x9079,0x907A,0x907B,0x907C,0x907E,0x9081,     0,
0x9084,0x9085,0x9086,0x9087,0x9089,0x908A,0x908C,0x908D,
0x908E,0x908F,0x9090,0x9092,0x9094,0x9096,0x9098,0x909A,
0x909C,0x909E,0x909F,0x90A0,0x90A4,0x90A5,0x90A7,0x90A8,
0x90A9,0x90AB,0x90AD,0x90B2,0x90B7,0x90BC,0x90BD,0x90BF,
0x90C0,0x647A,0x64B7,0x64B8,0x6499,0x64BA,0x64C0,0x64D0,
0x64D7,0x64E4,0x64E2,0x6509,0x6525,0x652E,0x5F0B,0x5FD2,
0x7519,0x5F11,0x535F,0x53F1,0x53FD,0x53E9,0x53E8,0x53FB,
0x5412,0x5416,0x5406,0x544B,0x5452,0x5453,0x5454,0x5456,
0x5443,0x5421,0x5457,0x5459,0x5423,0x5432,0x5482,0x5494,
0x5477,0x5471,0x5464,0x549A,0x549B,0x5484,0x5476,0x5466,
0x549D,0x54D0,0x54AD,0x54C2,0x54B4,0x54D2,0x54A7,0x54A6,
0x54D3,0x54D4,0x5472,0x54A3,0x54D5,0x54BB,0x54BF,0x54CC,
0x54D9,0x54DA,0x54DC,0x54A9,0x54AA,0x54A4,0x54DD,0x54CF,
0x54DE,0x551B,0x54E7,0x5520,0x54FD,0x5514,0x54F3,0x5522,
0x5523,0x550F,0x5511,0x5527,0x552A,0x5567,0x558F,0x55B5,
0x5549,0x556D,0x5541,0x5555,0x553F,0x5550,0x553C,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x90C2,0x90C3,0x90C6,0x90C8,0x90C9,0x90CB,0x90CC,0x90CD,
0x90D2,0x90D4,0x90D5,0x90D6,0x90D8,0x90D9,0x90DA,0x90DE,
0x90DF,0x90E0,0x90E3,0x90E4,0x90E5,0x90E9,0x90EA,0x90EC,
0x90EE,0x90F0,0x90F1,0x90F2,0x90F3,0x90F5,0x90F6,0x90F7,
0x90F9,0x90FA,0x90FB,0x90FC,0x90FF,0x9100,0x9101,0x9103,
0x9105,0x9106,0x9107,0x9108,0x9109,0x910A,0x910B,0x910C,
0x910D,0x910E,0x910F,0x9110,0x9111,0x9112,0x9113,0x9114,
0x9115,0x9116,0x9117,0x9118,0x911A,0x911B,0x911C,     0,
0x911D,0x911F,0x9120,0x9121,0x9124,0x9125,0x9126,0x9127,
0x9128,0x9129,0x912A,0x912B,0x912C,0x912D,0x912E,0x9130,
0x9132,0x9133,0x9134,0x9135,0x9136,0x9137,0x9138,0x913A,
0x913B,0x913C,0x913D,0x913E,0x913F,0x9140,0x9141,0x9142,
0x9144,0x5537,0x5556,0x5575,0x5576,0x5577,0x5533,0x5530,
0x555C,0x558B,0x55D2,0x5583,0x55B1,0x55B9,0x5588,0x5581,
0x559F,0x557E,0x55D6,0x5591,0x557B,0x55DF,0x55BD,0x55BE,
0x5594,0x5599,0x55EA,0x55F7,0x55C9,0x561F,0x55D1,0x55EB,
0x55EC,0x55D4,0x55E6,0x55DD,0x55C4,0x55EF,0x55E5,0x55F2,
0x55F3,0x55CC,0x55CD,0x55E8,0x55F5,0x55E4,0x8F94,0x561E,
0x5608,0x560C,0x5601,0x5624,0x5623,0x55FE,0x5600,0x5627,
0x562D,0x5658,0x5639,0x5657,0x562C,0x564D,0x5662,0x5659,
0x565C,0x564C,0x5654,0x5686,0x5664,0x5671,0x566B,0x567B,
0x567C,0x5685,0x5693,0x56AF,0x56D4,0x56D7,0x56DD,0x56E1,
0x56F5,0x56EB,0x56F9,0x56FF,0x5704,0x570A,0x5709,0x571C,
0x5E0F,0x5E19,0x5E14,0x5E11,0x5E31,0x5E3B,0x5E3C,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9145,0x9147,0x9148,0x9151,0x9153,0x9154,0x9155,0x9156,
0x9158,0x9159,0x915B,0x915C,0x915F,0x9160,0x9166,0x9167,
0x9168,0x916B,0x916D,0x9173,0x917A,0x917B,0x917C,0x9180,
0x9181,0x9182,0x9183,0x9184,0x9186,0x9188,0x918A,0x918E,
0x918F,0x9193,0x9194,0x9195,0x9196,0x9197,0x9198,0x9199,
0x919C,0x919D,0x919E,0x919F,0x91A0,0x91A1,0x91A4,0x91A5,
0x91A6,0x91A7,0x91A8,0x91A9,0x91AB,0x91AC,0x91B0,0x91B1,
0x91B2,0x91B3,0x91B6,0x91B7,0x91B8,0x91B9,0x91BB,     0,
0x91BC,0x91BD,0x91BE,0x91BF,0x91C0,0x91C1,0x91C2,0x91C3,
0x91C4,0x91C5,0x91C6,0x91C8,0x91CB,0x91D0,0x91D2,0x91D3,
0x91D4,0x91D5,0x91D6,0x91D7,0x91D8,0x91D9,0x91DA,0x91DB,
0x91DD,0x91DE,0x91DF,0x91E0,0x91E1,0x91E2,0x91E3,0x91E4,
0x91E5,0x5E37,0x5E44,0x5E54,0x5E5B,0x5E5E,0x5E61,0x5C8C,
0x5C7A,0x5C8D,0x5C90,0x5C96,0x5C88,0x5C98,0x5C99,0x5C91,
0x5C9A,0x5C9C,0x5CB5,0x5CA2,0x5CBD,0x5CAC,0x5CAB,0x5CB1,
0x5CA3,0x5CC1,0x5CB7,0x5CC4,0x5CD2,0x5CE4,0x5CCB,0x5CE5,
0x5D02,0x5D03,0x5D27,0x5D26,0x5D2E,0x5D24,0x5D1E,0x5D06,
0x5D1B,0x5D58,0x5D3E,0x5D34,0x5D3D,0x5D6C,0x5D5B,0x5D6F,
0x5D5D,0x5D6B,0x5D4B,0x5D4A,0x5D69,0x5D74,0x5D82,0x5D99,
0x5D9D,0x8C73,0x5DB7,0x5DC5,0x5F73,0x5F77,0x5F82,0x5F87,
0x5F89,0x5F8C,0x5F95,0x5F99,0x5F9C,0x5FA8,0x5FAD,0x5FB5,
0x5FBC,0x8862,0x5F61,0x72AD,0x72B0,0x72B4,0x72B7,0x72B8,
0x72C3,0x72C1,0x72CE,0x72CD,0x72D2,0x72E8,0x72EF,0x72E9,
0x72F2,0x72F4,0x72F7,0x7301,0x72F3,0x7303,0x72FA,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x91E6,0x91E7,0x91E8,0x91E9,0x91EA,0x91EB,0x91EC,0x91ED,
0x91EE,0x91EF,0x91F0,0x91F1,0x91F2,0x91F3,0x91F4,0x91F5,
0x91F6,0x91F7,0x91F8,0x91F9,0x91FA,0x91FB,0x91FC,0x91FD,
0x91FE,0x91FF,0x9200,0x9201,0x9202,0x9203,0x9204,0x9205,
0x9206,0x9207,0x9208,0x9209,0x920A,0x920B,0x920C,0x920D,
0x920E,0x920F,0x9210,0x9211,0x9212,0x9213,0x9214,0x9215,
0x9216,0x9217,0x9218,0x9219,0x921A,0x921B,0x921C,0x921D,
0x921E,0x921F,0x9220,0x9221,0x9222,0x9223,0x9224,     0,
0x9225,0x9226,0x9227,0x9228,0x9229,0x922A,0x922B,0x922C,
0x922D,0x922E,0x922F,0x9230,0x9231,0x9232,0x9233,0x9234,
0x9235,0x9236,0x9237,0x9238,0x9239,0x923A,0x923B,0x923C,
0x923D,0x923E,0x923F,0x9240,0x9241,0x9242,0x9243,0x9244,
0x9245,0x72FB,0x7317,0x7313,0x7321,0x730A,0x731E,0x731D,
0x7315,0x7322,0x7339,0x7325,0x732C,0x7338,0x7331,0x7350,
0x734D,0x7357,0x7360,0x736C,0x736F,0x737E,0x821B,0x5925,
0x98E7,0x5924,0x5902,0x9963,0x9967,0x9968,0x9969,0x996A,
0x996B,0x996C,0x9974,0x9977,0x997D,0x9980,0x9984,0x9987,
0x998A,0x998D,0x9990,0x9991,0x9993,0x9994,0x9995,0x5E80,
0x5E91,0x5E8B,0x5E96,0x5EA5,0x5EA0,0x5EB9,0x5EB5,0x5EBE,
0x5EB3,0x8D53,0x5ED2,0x5ED1,0x5EDB,0x5EE8,0x5EEA,0x81BA,
0x5FC4,0x5FC9,0x5FD6,0x5FCF,0x6003,0x5FEE,0x6004,0x5FE1,
0x5FE4,0x5FFE,0x6005,0x6006,0x5FEA,0x5FED,0x5FF8,0x6019,
0x6035,0x6026,0x601B,0x600F,0x600D,0x6029,0x602B,0x600A,
0x603F,0x6021,0x6078,0x6079,0x607B,0x607A,0x6042,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9246,0x9247,0x9248,0x9249,0x924A,0x924B,0x924C,0x924D,
0x924E,0x924F,0x9250,0x9251,0x9252,0x9253,0x9254,0x9255,
0x9256,0x9257,0x9258,0x9259,0x925A,0x925B,0x925C,0x925D,
0x925E,0x925F,0x9260,0x9261,0x9262,0x9263,0x9264,0x9265,
0x9266,0x9267,0x9268,0x9269,0x926A,0x926B,0x926C,0x926D,
0x926E,0x926F,0x9270,0x9271,0x9272,0x9273,0x9275,0x9276,
0x9277,0x9278,0x9279,0x927A,0x927B,0x927C,0x927D,0x927E,
0x927F,0x9280,0x9281,0x9282,0x9283,0x9284,0x9285,     0,
0x9286,0x9287,0x9288,0x9289,0x928A,0x928B,0x928C,0x928D,
0x928F,0x9290,0x9291,0x9292,0x9293,0x9294,0x9295,0x9296,
0x9297,0x9298,0x9299,0x929A,0x929B,0x929C,0x929D,0x929E,
0x929F,0x92A0,0x92A1,0x92A2,0x92A3,0x92A4,0x92A5,0x92A6,
0x92A7,0x606A,0x607D,0x6096,0x609A,0x60AD,0x609D,0x6083,
0x6092,0x608C,0x609B,0x60EC,0x60BB,0x60B1,0x60DD,0x60D8,
0x60C6,0x60DA,0x60B4,0x6120,0x6126,0x6115,0x6123,0x60F4,
0x6100,0x610E,0x612B,0x614A,0x6175,0x61AC,0x6194,0x61A7,
0x61B7,0x61D4,0x61F5,0x5FDD,0x96B3,0x95E9,0x95EB,0x95F1,
0x95F3,0x95F5,0x95F6,0x95FC,0x95FE,0x9603,0x9604,0x9606,
0x9608,0x960A,0x960B,0x960C,0x960D,0x960F,0x9612,0x9615,
0x9616,0x9617,0x9619,0x961A,0x4E2C,0x723F,0x6215,0x6C35,
0x6C54,0x6C5C,0x6C4A,0x6CA3,0x6C85,0x6C90,0x6C94,0x6C8C,
0x6C68,0x6C69,0x6C74,0x6C76,0x6C86,0x6CA9,0x6CD0,0x6CD4,
0x6CAD,0x6CF7,0x6CF8,0x6CF1,0x6CD7,0x6CB2,0x6CE0,0x6CD6,
0x6CFA,0x6CEB,0x6CEE,0x6CB1,0x6CD3,0x6CEF,0x6CFE,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x92A8,0x92A9,0x92AA,0x92AB,0x92AC,0x92AD,0x92AF,0x92B0,
0x92B1,0x92B2,0x92B3,0x92B4,0x92B5,0x92B6,0x92B7,0x92B8,
0x92B9,0x92BA,0x92BB,0x92BC,0x92BD,0x92BE,0x92BF,0x92C0,
0x92C1,0x92C2,0x92C3,0x92C4,0x92C5,0x92C6,0x92C7,0x92C9,
0x92CA,0x92CB,0x92CC,0x92CD,0x92CE,0x92CF,0x92D0,0x92D1,
0x92D2,0x92D3,0x92D4,0x92D5,0x92D6,0x92D7,0x92D8,0x92D9,
0x92DA,0x92DB,0x92DC,0x92DD,0x92DE,0x92DF,0x92E0,0x92E1,
0x92E2,0x92E3,0x92E4,0x92E5,0x92E6,0x92E7,0x92E8,     0,
0x92E9,0x92EA,0x92EB,0x92EC,0x92ED,0x92EE,0x92EF,0x92F0,
0x92F1,0x92F2,0x92F3,0x92F4,0x92F5,0x92F6,0x92F7,0x92F8,
0x92F9,0x92FA,0x92FB,0x92FC,0x92FD,0x92FE,0x92FF,0x9300,
0x9301,0x9302,0x9303,0x9304,0x9305,0x9306,0x9307,0x9308,
0x9309,0x6D39,0x6D27,0x6D0C,0x6D43,0x6D48,0x6D07,0x6D04,
0x6D19,0x6D0E,0x6D2B,0x6D4D,0x6D2E,0x6D35,0x6D1A,0x6D4F,
0x6D52,0x6D54,0x6D33,0x6D91,0x6D6F,0x6D9E,0x6DA0,0x6D5E,
0x6D93,0x6D94,0x6D5C,0x6D60,0x6D7C,0x6D63,0x6E1A,0x6DC7,
0x6DC5,0x6DDE,0x6E0E,0x6DBF,0x6DE0,0x6E11,0x6DE6,0x6DDD,
0x6DD9,0x6E16,0x6DAB,0x6E0C,0x6DAE,0x6E2B,0x6E6E,0x6E4E,
0x6E6B,0x6EB2,0x6E5F,0x6E86,0x6E53,0x6E54,0x6E32,0x6E25,
0x6E44,0x6EDF,0x6EB1,0x6E98,0x6EE0,0x6F2D,0x6EE2,0x6EA5,
0x6EA7,0x6EBD,0x6EBB,0x6EB7,0x6ED7,0x6EB4,0x6ECF,0x6E8F,
0x6EC2,0x6E9F,0x6F62,0x6F46,0x6F47,0x6F24,0x6F15,0x6EF9,
0x6F2F,0x6F36,0x6F4B,0x6F74,0x6F2A,0x6F09,0x6F29,0x6F89,
0x6F8D,0x6F8C,0x6F78,0x6F72,0x6F7C,0x6F7A,0x6FD1,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x930A,0x930B,0x930C,0x930D,0x930E,0x930F,0x9310,0x9311,
0x9312,0x9313,0x9314,0x9315,0x9316,0x9317,0x9318,0x9319,
0x931A,0x931B,0x931C,0x931D,0x931E,0x931F,0x9320,0x9321,
0x9322,0x9323,0x9324,0x9325,0x9326,0x9327,0x9328,0x9329,
0x932A,0x932B,0x932C,0x932D,0x932E,0x932F,0x9330,0x9331,
0x9332,0x9333,0x9334,0x9335,0x9336,0x9337,0x9338,0x9339,
0x933A,0x933B,0x933C,0x933D,0x933F,0x9340,0x9341,0x9342,
0x9343,0x9344,0x9345,0x9346,0x9347,0x9348,0x9349,     0,
0x934A,0x934B,0x934C,0x934D,0x934E,0x934F,0x9350,0x9351,
0x9352,0x9353,0x9354,0x9355,0x9356,0x9357,0x9358,0x9359,
0x935A,0x935B,0x935C,0x935D,0x935E,0x935F,0x9360,0x9361,
0x9362,0x9363,0x9364,0x9365,0x9366,0x9367,0x9368,0x9369,
0x936B,0x6FC9,0x6FA7,0x6FB9,0x6FB6,0x6FC2,0x6FE1,0x6FEE,
0x6FDE,0x6FE0,0x6FEF,0x701A,0x7023,0x701B,0x7039,0x7035,
0x704F,0x705E,0x5B80,0x5B84,0x5B95,0x5B93,0x5BA5,0x5BB8,
0x752F,0x9A9E,0x6434,0x5BE4,0x5BEE,0x8930,0x5BF0,0x8E47,
0x8B07,0x8FB6,0x8FD3,0x8FD5,0x8FE5,0x8FEE,0x8FE4,0x8FE9,
0x8FE6,0x8FF3,0x8FE8,0x9005,0x9004,0x900B,0x9026,0x9011,
0x900D,0x9016,0x9021,0x9035,0x9036,0x902D,0x902F,0x9044,
0x9051,0x9052,0x9050,0x9068,0x9058,0x9062,0x905B,0x66B9,
0x9074,0x907D,0x9082,0x9088,0x9083,0x908B,0x5F50,0x5F57,
0x5F56,0x5F58,0x5C3B,0x54AB,0x5C50,0x5C59,0x5B71,0x5C63,
0x5C66,0x7FBC,0x5F2A,0x5F29,0x5F2D,0x8274,0x5F3C,0x9B3B,
0x5C6E,0x5981,0x5983,0x598D,0x59A9,0x59AA,0x59A3,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x936C,0x936D,0x936E,0x936F,0x9370,0x9371,0x9372,0x9373,
0x9374,0x9375,0x9376,0x9377,0x9378,0x9379,0x937A,0x937B,
0x937C,0x937D,0x937E,0x937F,0x9380,0x9381,0x9382,0x9383,
0x9384,0x9385,0x9386,0x9387,0x9388,0x9389,0x938A,0x938B,
0x938C,0x938D,0x938E,0x9390,0x9391,0x9392,0x9393,0x9394,
0x9395,0x9396,0x9397,0x9398,0x9399,0x939A,0x939B,0x939C,
0x939D,0x939E,0x939F,0x93A0,0x93A1,0x93A2,0x93A3,0x93A4,
0x93A5,0x93A6,0x93A7,0x93A8,0x93A9,0x93AA,0x93AB,     0,
0x93AC,0x93AD,0x93AE,0x93AF,0x93B0,0x93B1,0x93B2,0x93B3,
0x93B4,0x93B5,0x93B6,0x93B7,0x93B8,0x93B9,0x93BA,0x93BB,
0x93BC,0x93BD,0x93BE,0x93BF,0x93C0,0x93C1,0x93C2,0x93C3,
0x93C4,0x93C5,0x93C6,0x93C7,0x93C8,0x93C9,0x93CB,0x93CC,
0x93CD,0x5997,0x59CA,0x59AB,0x599E,0x59A4,0x59D2,0x59B2,
0x59AF,0x59D7,0x59BE,0x5A05,0x5A06,0x59DD,0x5A08,0x59E3,
0x59D8,0x59F9,0x5A0C,0x5A09,0x5A32,0x5A34,0x5A11,0x5A23,
0x5A13,0x5A40,0x5A67,0x5A4A,0x5A55,0x5A3C,0x5A62,0x5A75,
0x80EC,0x5AAA,0x5A9B,0x5A77,0x5A7A,0x5ABE,0x5AEB,0x5AB2,
0x5AD2,0x5AD4,0x5AB8,0x5AE0,0x5AE3,0x5AF1,0x5AD6,0x5AE6,
0x5AD8,0x5ADC,0x5B09,0x5B17,0x5B16,0x5B32,0x5B37,0x5B40,
0x5C15,0x5C1C,0x5B5A,0x5B65,0x5B73,0x5B51,0x5B53,0x5B62,
0x9A75,0x9A77,0x9A78,0x9A7A,0x9A7F,0x9A7D,0x9A80,0x9A81,
0x9A85,0x9A88,0x9A8A,0x9A90,0x9A92,0x9A93,0x9A96,0x9A98,
0x9A9B,0x9A9C,0x9A9D,0x9A9F,0x9AA0,0x9AA2,0x9AA3,0x9AA5,
0x9AA7,0x7E9F,0x7EA1,0x7EA3,0x7EA5,0x7EA8,0x7EA9,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x93CE,0x93CF,0x93D0,0x93D1,0x93D2,0x93D3,0x93D4,0x93D5,
0x93D7,0x93D8,0x93D9,0x93DA,0x93DB,0x93DC,0x93DD,0x93DE,
0x93DF,0x93E0,0x93E1,0x93E2,0x93E3,0x93E4,0x93E5,0x93E6,
0x93E7,0x93E8,0x93E9,0x93EA,0x93EB,0x93EC,0x93ED,0x93EE,
0x93EF,0x93F0,0x93F1,0x93F2,0x93F3,0x93F4,0x93F5,0x93F6,
0x93F7,0x93F8,0x93F9,0x93FA,0x93FB,0x93FC,0x93FD,0x93FE,
0x93FF,0x9400,0x9401,0x9402,0x9403,0x9404,0x9405,0x9406,
0x9407,0x9408,0x9409,0x940A,0x940B,0x940C,0x940D,     0,
0x940E,0x940F,0x9410,0x9411,0x9412,0x9413,0x9414,0x9415,
0x9416,0x9417,0x9418,0x9419,0x941A,0x941B,0x941C,0x941D,
0x941E,0x941F,0x9420,0x9421,0x9422,0x9423,0x9424,0x9425,
0x9426,0x9427,0x9428,0x9429,0x942A,0x942B,0x942C,0x942D,
0x942E,0x7EAD,0x7EB0,0x7EBE,0x7EC0,0x7EC1,0x7EC2,0x7EC9,
0x7ECB,0x7ECC,0x7ED0,0x7ED4,0x7ED7,0x7EDB,0x7EE0,0x7EE1,
0x7EE8,0x7EEB,0x7EEE,0x7EEF,0x7EF1,0x7EF2,0x7F0D,0x7EF6,
0x7EFA,0x7EFB,0x7EFE,0x7F01,0x7F02,0x7F03,0x7F07,0x7F08,
0x7F0B,0x7F0C,0x7F0F,0x7F11,0x7F12,0x7F17,0x7F19,0x7F1C,
0x7F1B,0x7F1F,0x7F21,0x7F22,0x7F23,0x7F24,0x7F25,0x7F26,
0x7F27,0x7F2A,0x7F2B,0x7F2C,0x7F2D,0x7F2F,0x7F30,0x7F31,
0x7F32,0x7F33,0x7F35,0x5E7A,0x757F,0x5DDB,0x753E,0x9095,
0x738E,0x7391,0x73AE,0x73A2,0x739F,0x73CF,0x73C2,0x73D1,
0x73B7,0x73B3,0x73C0,0x73C9,0x73C8,0x73E5,0x73D9,0x987C,
0x740A,0x73E9,0x73E7,0x73DE,0x73BA,0x73F2,0x740F,0x742A,
0x745B,0x7426,0x7425,0x7428,0x7430,0x742E,0x742C,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x942F,0x9430,0x9431,0x9432,0x9433,0x9434,0x9435,0x9436,
0x9437,0x9438,0x9439,0x943A,0x943B,0x943C,0x943D,0x943F,
0x9440,0x9441,0x9442,0x9443,0x9444,0x9445,0x9446,0x9447,
0x9448,0x9449,0x944A,0x944B,0x944C,0x944D,0x944E,0x944F,
0x9450,0x9451,0x9452,0x9453,0x9454,0x9455,0x9456,0x9457,
0x9458,0x9459,0x945A,0x945B,0x945C,0x945D,0x945E,0x945F,
0x9460,0x9461,0x9462,0x9463,0x9464,0x9465,0x9466,0x9467,
0x9468,0x9469,0x946A,0x946C,0x946D,0x946E,0x946F,     0,
0x9470,0x9471,0x9472,0x9473,0x9474,0x9475,0x9476,0x9477,
0x9478,0x9479,0x947A,0x947B,0x947C,0x947D,0x947E,0x947F,
0x9480,0x9481,0x9482,0x9483,0x9484,0x9491,0x9496,0x9498,
0x94C7,0x94CF,0x94D3,0x94D4,0x94DA,0x94E6,0x94FB,0x951C,
0x9520,0x741B,0x741A,0x7441,0x745C,0x7457,0x7455,0x7459,
0x7477,0x746D,0x747E,0x749C,0x748E,0x7480,0x7481,0x7487,
0x748B,0x749E,0x74A8,0x74A9,0x7490,0x74A7,0x74D2,0x74BA,
0x97EA,0x97EB,0x97EC,0x674C,0x6753,0x675E,0x6748,0x6769,
0x67A5,0x6787,0x676A,0x6773,0x6798,0x67A7,0x6775,0x67A8,
0x679E,0x67AD,0x678B,0x6777,0x677C,0x67F0,0x6809,0x67D8,
0x680A,0x67E9,0x67B0,0x680C,0x67D9,0x67B5,0x67DA,0x67B3,
0x67DD,0x6800,0x67C3,0x67B8,0x67E2,0x680E,0x67C1,0x67FD,
0x6832,0x6833,0x6860,0x6861,0x684E,0x6862,0x6844,0x6864,
0x6883,0x681D,0x6855,0x6866,0x6841,0x6867,0x6840,0x683E,
0x684A,0x6849,0x6829,0x68B5,0x688F,0x6874,0x6877,0x6893,
0x686B,0x68C2,0x696E,0x68FC,0x691F,0x6920,0x68F9,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9527,0x9533,0x953D,0x9543,0x9548,0x954B,0x9555,0x955A,
0x9560,0x956E,0x9574,0x9575,0x9577,0x9578,0x9579,0x957A,
0x957B,0x957C,0x957D,0x957E,0x9580,0x9581,0x9582,0x9583,
0x9584,0x9585,0x9586,0x9587,0x9588,0x9589,0x958A,0x958B,
0x958C,0x958D,0x958E,0x958F,0x9590,0x9591,0x9592,0x9593,
0x9594,0x9595,0x9596,0x9597,0x9598,0x9599,0x959A,0x959B,
0x959C,0x959D,0x959E,0x959F,0x95A0,0x95A1,0x95A2,0x95A3,
0x95A4,0x95A5,0x95A6,0x95A7,0x95A8,0x95A9,0x95AA,     0,
0x95AB,0x95AC,0x95AD,0x95AE,0x95AF,0x95B0,0x95B1,0x95B2,
0x95B3,0x95B4,0x95B5,0x95B6,0x95B7,0x95B8,0x95B9,0x95BA,
0x95BB,0x95BC,0x95BD,0x95BE,0x95BF,0x95C0,0x95C1,0x95C2,
0x95C3,0x95C4,0x95C5,0x95C6,0x95C7,0x95C8,0x95C9,0x95CA,
0x95CB,0x6924,0x68F0,0x690B,0x6901,0x6957,0x68E3,0x6910,
0x6971,0x6939,0x6960,0x6942,0x695D,0x6984,0x696B,0x6980,
0x6998,0x6978,0x6934,0x69CC,0x6987,0x6988,0x69CE,0x6989,
0x6966,0x6963,0x6979,0x699B,0x69A7,0x69BB,0x69AB,0x69AD,
0x69D4,0x69B1,0x69C1,0x69CA,0x69DF,0x6995,0x69E0,0x698D,
0x69FF,0x6A2F,0x69ED,0x6A17,0x6A18,0x6A65,0x69F2,0x6A44,
0x6A3E,0x6AA0,0x6A50,0x6A5B,0x6A35,0x6A8E,0x6A79,0x6A3D,
0x6A28,0x6A58,0x6A7C,0x6A91,0x6A90,0x6AA9,0x6A97,0x6AAB,
0x7337,0x7352,0x6B81,0x6B82,0x6B87,0x6B84,0x6B92,0x6B93,
0x6B8D,0x6B9A,0x6B9B,0x6BA1,0x6BAA,0x8F6B,0x8F6D,0x8F71,
0x8F72,0x8F73,0x8F75,0x8F76,0x8F78,0x8F77,0x8F79,0x8F7A,
0x8F7C,0x8F7E,0x8F81,0x8F82,0x8F84,0x8F87,0x8F8B,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x95CC,0x95CD,0x95CE,0x95CF,0x95D0,0x95D1,0x95D2,0x95D3,
0x95D4,0x95D5,0x95D6,0x95D7,0x95D8,0x95D9,0x95DA,0x95DB,
0x95DC,0x95DD,0x95DE,0x95DF,0x95E0,0x95E1,0x95E2,0x95E3,
0x95E4,0x95E5,0x95E6,0x95E7,0x95EC,0x95FF,0x9607,0x9613,
0x9618,0x961B,0x961E,0x9620,0x9623,0x9624,0x9625,0x9626,
0x9627,0x9628,0x9629,0x962B,0x962C,0x962D,0x962F,0x9630,
0x9637,0x9638,0x9639,0x963A,0x963E,0x9641,0x9643,0x964A,
0x964E,0x964F,0x9651,0x9652,0x9653,0x9656,0x9657,     0,
0x9658,0x9659,0x965A,0x965C,0x965D,0x965E,0x9660,0x9663,
0x9665,0x9666,0x966B,0x966D,0x966E,0x966F,0x9670,0x9671,
0x9673,0x9678,0x9679,0x967A,0x967B,0x967C,0x967D,0x967E,
0x967F,0x9680,0x9681,0x9682,0x9683,0x9684,0x9687,0x9689,
0x968A,0x8F8D,0x8F8E,0x8F8F,0x8F98,0x8F9A,0x8ECE,0x620B,
0x6217,0x621B,0x621F,0x6222,0x6221,0x6225,0x6224,0x622C,
0x81E7,0x74EF,0x74F4,0x74FF,0x750F,0x7511,0x7513,0x6534,
0x65EE,0x65EF,0x65F0,0x660A,0x6619,0x6772,0x6603,0x6615,
0x6600,0x7085,0x66F7,0x661D,0x6634,0x6631,0x6636,0x6635,
0x8006,0x665F,0x6654,0x6641,0x664F,0x6656,0x6661,0x6657,
0x6677,0x6684,0x668C,0x66A7,0x669D,0x66BE,0x66DB,0x66DC,
0x66E6,0x66E9,0x8D32,0x8D33,0x8D36,0x8D3B,0x8D3D,0x8D40,
0x8D45,0x8D46,0x8D48,0x8D49,0x8D47,0x8D4D,0x8D55,0x8D59,
0x89C7,0x89CA,0x89CB,0x89CC,0x89CE,0x89CF,0x89D0,0x89D1,
0x726E,0x729F,0x725D,0x7266,0x726F,0x727E,0x727F,0x7284,
0x728B,0x728D,0x728F,0x7292,0x6308,0x6332,0x63B0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x968C,0x968E,0x9691,0x9692,0x9693,0x9695,0x9696,0x969A,
0x969B,0x969D,0x969E,0x969F,0x96A0,0x96A1,0x96A2,0x96A3,
0x96A4,0x96A5,0x96A6,0x96A8,0x96A9,0x96AA,0x96AB,0x96AC,
0x96AD,0x96AE,0x96AF,0x96B1,0x96B2,0x96B4,0x96B5,0x96B7,
0x96B8,0x96BA,0x96BB,0x96BF,0x96C2,0x96C3,0x96C8,0x96CA,
0x96CB,0x96D0,0x96D1,0x96D3,0x96D4,0x96D6,0x96D7,0x96D8,
0x96D9,0x96DA,0x96DB,0x96DC,0x96DD,0x96DE,0x96DF,0x96E1,
0x96E2,0x96E3,0x96E4,0x96E5,0x96E6,0x96E7,0x96EB,     0,
0x96EC,0x96ED,0x96EE,0x96F0,0x96F1,0x96F2,0x96F4,0x96F5,
0x96F8,0x96FA,0x96FB,0x96FC,0x96FD,0x96FF,0x9702,0x9703,
0x9705,0x970A,0x970B,0x970C,0x9710,0x9711,0x9712,0x9714,
0x9715,0x9717,0x9718,0x9719,0x971A,0x971B,0x971D,0x971F,
0x9720,0x643F,0x64D8,0x8004,0x6BEA,0x6BF3,0x6BFD,0x6BF5,
0x6BF9,0x6C05,0x6C07,0x6C06,0x6C0D,0x6C15,0x6C18,0x6C19,
0x6C1A,0x6C21,0x6C29,0x6C24,0x6C2A,0x6C32,0x6535,0x6555,
0x656B,0x724D,0x7252,0x7256,0x7230,0x8662,0x5216,0x809F,
0x809C,0x8093,0x80BC,0x670A,0x80BD,0x80B1,0x80AB,0x80AD,
0x80B4,0x80B7,0x80E7,0x80E8,0x80E9,0x80EA,0x80DB,0x80C2,
0x80C4,0x80D9,0x80CD,0x80D7,0x6710,0x80DD,0x80EB,0x80F1,
0x80F4,0x80ED,0x810D,0x810E,0x80F2,0x80FC,0x6715,0x8112,
0x8C5A,0x8136,0x811E,0x812C,0x8118,0x8132,0x8148,0x814C,
0x8153,0x8174,0x8159,0x815A,0x8171,0x8160,0x8169,0x817C,
0x817D,0x816D,0x8167,0x584D,0x5AB5,0x8188,0x8182,0x8191,
0x6ED5,0x81A3,0x81AA,0x81CC,0x6726,0x81CA,0x81BB,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9721,0x9722,0x9723,0x9724,0x9725,0x9726,0x9727,0x9728,
0x9729,0x972B,0x972C,0x972E,0x972F,0x9731,0x9733,0x9734,
0x9735,0x9736,0x9737,0x973A,0x973B,0x973C,0x973D,0x973F,
0x9740,0x9741,0x9742,0x9743,0x9744,0x9745,0x9746,0x9747,
0x9748,0x9749,0x974A,0x974B,0x974C,0x974D,0x974E,0x974F,
0x9750,0x9751,0x9754,0x9755,0x9757,0x9758,0x975A,0x975C,
0x975D,0x975F,0x9763,0x9764,0x9766,0x9767,0x9768,0x976A,
0x976B,0x976C,0x976D,0x976E,0x976F,0x9770,0x9771,     0,
0x9772,0x9775,0x9777,0x9778,0x9779,0x977A,0x977B,0x977D,
0x977E,0x977F,0x9780,0x9781,0x9782,0x9783,0x9784,0x9786,
0x9787,0x9788,0x9789,0x978A,0x978C,0x978E,0x978F,0x9790,
0x9793,0x9795,0x9796,0x9797,0x9799,0x979A,0x979B,0x979C,
0x979D,0x81C1,0x81A6,0x6B24,0x6B37,0x6B39,0x6B43,0x6B46,
0x6B59,0x98D1,0x98D2,0x98D3,0x98D5,0x98D9,0x98DA,0x6BB3,
0x5F40,0x6BC2,0x89F3,0x6590,0x9F51,0x6593,0x65BC,0x65C6,
0x65C4,0x65C3,0x65CC,0x65CE,0x65D2,0x65D6,0x7080,0x709C,
0x7096,0x709D,0x70BB,0x70C0,0x70B7,0x70AB,0x70B1,0x70E8,
0x70CA,0x7110,0x7113,0x7116,0x712F,0x7131,0x7173,0x715C,
0x7168,0x7145,0x7172,0x714A,0x7178,0x717A,0x7198,0x71B3,
0x71B5,0x71A8,0x71A0,0x71E0,0x71D4,0x71E7,0x71F9,0x721D,
0x7228,0x706C,0x7118,0x7166,0x71B9,0x623E,0x623D,0x6243,
0x6248,0x6249,0x793B,0x7940,0x7946,0x7949,0x795B,0x795C,
0x7953,0x795A,0x7962,0x7957,0x7960,0x796F,0x7967,0x797A,
0x7985,0x798A,0x799A,0x79A7,0x79B3,0x5FD1,0x5FD0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x979E,0x979F,0x97A1,0x97A2,0x97A4,0x97A5,0x97A6,0x97A7,
0x97A8,0x97A9,0x97AA,0x97AC,0x97AE,0x97B0,0x97B1,0x97B3,
0x97B5,0x97B6,0x97B7,0x97B8,0x97B9,0x97BA,0x97BB,0x97BC,
0x97BD,0x97BE,0x97BF,0x97C0,0x97C1,0x97C2,0x97C3,0x97C4,
0x97C5,0x97C6,0x97C7,0x97C8,0x97C9,0x97CA,0x97CB,0x97CC,
0x97CD,0x97CE,0x97CF,0x97D0,0x97D1,0x97D2,0x97D3,0x97D4,
0x97D5,0x97D6,0x97D7,0x97D8,0x97D9,0x97DA,0x97DB,0x97DC,
0x97DD,0x97DE,0x97DF,0x97E0,0x97E1,0x97E2,0x97E3,     0,
0x97E4,0x97E5,0x97E8,0x97EE,0x97EF,0x97F0,0x97F1,0x97F2,
0x97F4,0x97F7,0x97F8,0x97F9,0x97FA,0x97FB,0x97FC,0x97FD,
0x97FE,0x97FF,0x9800,0x9801,0x9802,0x9803,0x9804,0x9805,
0x9806,0x9807,0x9808,0x9809,0x980A,0x980B,0x980C,0x980D,
0x980E,0x603C,0x605D,0x605A,0x6067,0x6041,0x6059,0x6063,
0x60AB,0x6106,0x610D,0x615D,0x61A9,0x619D,0x61CB,0x61D1,
0x6206,0x8080,0x807F,0x6C93,0x6CF6,0x6DFC,0x77F6,0x77F8,
0x7800,0x7809,0x7817,0x7818,0x7811,0x65AB,0x782D,0x781C,
0x781D,0x7839,0x783A,0x783B,0x781F,0x783C,0x7825,0x782C,
0x7823,0x7829,0x784E,0x786D,0x7856,0x7857,0x7826,0x7850,
0x7847,0x784C,0x786A,0x789B,0x7893,0x789A,0x7887,0x789C,
0x78A1,0x78A3,0x78B2,0x78B9,0x78A5,0x78D4,0x78D9,0x78C9,
0x78EC,0x78F2,0x7905,0x78F4,0x7913,0x7924,0x791E,0x7934,
0x9F9B,0x9EF9,0x9EFB,0x9EFC,0x76F1,0x7704,0x770D,0x76F9,
0x7707,0x7708,0x771A,0x7722,0x7719,0x772D,0x7726,0x7735,
0x7738,0x7750,0x7751,0x7747,0x7743,0x775A,0x7768,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x980F,0x9810,0x9811,0x9812,0x9813,0x9814,0x9815,0x9816,
0x9817,0x9818,0x9819,0x981A,0x981B,0x981C,0x981D,0x981E,
0x981F,0x9820,0x9821,0x9822,0x9823,0x9824,0x9825,0x9826,
0x9827,0x9828,0x9829,0x982A,0x982B,0x982C,0x982D,0x982E,
0x982F,0x9830,0x9831,0x9832,0x9833,0x9834,0x9835,0x9836,
0x9837,0x9838,0x9839,0x983A,0x983B,0x983C,0x983D,0x983E,
0x983F,0x9840,0x9841,0x9842,0x9843,0x9844,0x9845,0x9846,
0x9847,0x9848,0x9849,0x984A,0x984B,0x984C,0x984D,     0,
0x984E,0x984F,0x9850,0x9851,0x9852,0x9853,0x9854,0x9855,
0x9856,0x9857,0x9858,0x9859,0x985A,0x985B,0x985C,0x985D,
0x985E,0x985F,0x9860,0x9861,0x9862,0x9863,0x9864,0x9865,
0x9866,0x9867,0x9868,0x9869,0x986A,0x986B,0x986C,0x986D,
0x986E,0x7762,0x7765,0x777F,0x778D,0x777D,0x7780,0x778C,
0x7791,0x779F,0x77A0,0x77B0,0x77B5,0x77BD,0x753A,0x7540,
0x754E,0x754B,0x7548,0x755B,0x7572,0x7579,0x7583,0x7F58,
0x7F61,0x7F5F,0x8A48,0x7F68,0x7F74,0x7F71,0x7F79,0x7F81,
0x7F7E,0x76CD,0x76E5,0x8832,0x9485,0x9486,0x9487,0x948B,
0x948A,0x948C,0x948D,0x948F,0x9490,0x9494,0x9497,0x9495,
0x949A,0x949B,0x949C,0x94A3,0x94A4,0x94AB,0x94AA,0x94AD,
0x94AC,0x94AF,0x94B0,0x94B2,0x94B4,0x94B6,0x94B7,0x94B8,
0x94B9,0x94BA,0x94BC,0x94BD,0x94BF,0x94C4,0x94C8,0x94C9,
0x94CA,0x94CB,0x94CC,0x94CD,0x94CE,0x94D0,0x94D1,0x94D2,
0x94D5,0x94D6,0x94D7,0x94D9,0x94D8,0x94DB,0x94DE,0x94DF,
0x94E0,0x94E2,0x94E4,0x94E5,0x94E7,0x94E8,0x94EA,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x986F,0x9870,0x9871,0x9872,0x9873,0x9874,0x988B,0x988E,
0x9892,0x9895,0x9899,0x98A3,0x98A8,0x98A9,0x98AA,0x98AB,
0x98AC,0x98AD,0x98AE,0x98AF,0x98B0,0x98B1,0x98B2,0x98B3,
0x98B4,0x98B5,0x98B6,0x98B7,0x98B8,0x98B9,0x98BA,0x98BB,
0x98BC,0x98BD,0x98BE,0x98BF,0x98C0,0x98C1,0x98C2,0x98C3,
0x98C4,0x98C5,0x98C6,0x98C7,0x98C8,0x98C9,0x98CA,0x98CB,
0x98CC,0x98CD,0x98CF,0x98D0,0x98D4,0x98D6,0x98D7,0x98DB,
0x98DC,0x98DD,0x98E0,0x98E1,0x98E2,0x98E3,0x98E4,     0,
0x98E5,0x98E6,0x98E9,0x98EA,0x98EB,0x98EC,0x98ED,0x98EE,
0x98EF,0x98F0,0x98F1,0x98F2,0x98F3,0x98F4,0x98F5,0x98F6,
0x98F7,0x98F8,0x98F9,0x98FA,0x98FB,0x98FC,0x98FD,0x98FE,
0x98FF,0x9900,0x9901,0x9902,0x9903,0x9904,0x9905,0x9906,
0x9907,0x94E9,0x94EB,0x94EE,0x94EF,0x94F3,0x94F4,0x94F5,
0x94F7,0x94F9,0x94FC,0x94FD,0x94FF,0x9503,0x9502,0x9506,
0x9507,0x9509,0x950A,0x950D,0x950E,0x950F,0x9512,0x9513,
0x9514,0x9515,0x9516,0x9518,0x951B,0x951D,0x951E,0x951F,
0x9522,0x952A,0x952B,0x9529,0x952C,0x9531,0x9532,0x9534,
0x9536,0x9537,0x9538,0x953C,0x953E,0x953F,0x9542,0x9535,
0x9544,0x9545,0x9546,0x9549,0x954C,0x954E,0x954F,0x9552,
0x9553,0x9554,0x9556,0x9557,0x9558,0x9559,0x955B,0x955E,
0x955F,0x955D,0x9561,0x9562,0x9564,0x9565,0x9566,0x9567,
0x9568,0x9569,0x956A,0x956B,0x956C,0x956F,0x9571,0x9572,
0x9573,0x953A,0x77E7,0x77EC,0x96C9,0x79D5,0x79ED,0x79E3,
0x79EB,0x7A06,0x5D47,0x7A03,0x7A02,0x7A1E,0x7A14,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9908,0x9909,0x990A,0x990B,0x990C,0x990E,0x990F,0x9911,
0x9912,0x9913,0x9914,0x9915,0x9916,0x9917,0x9918,0x9919,
0x991A,0x991B,0x991C,0x991D,0x991E,0x991F,0x9920,0x9921,
0x9922,0x9923,0x9924,0x9925,0x9926,0x9927,0x9928,0x9929,
0x992A,0x992B,0x992C,0x992D,0x992F,0x9930,0x9931,0x9932,
0x9933,0x9934,0x9935,0x9936,0x9937,0x9938,0x9939,0x993A,
0x993B,0x993C,0x993D,0x993E,0x993F,0x9940,0x9941,0x9942,
0x9943,0x9944,0x9945,0x9946,0x9947,0x9948,0x9949,     0,
0x994A,0x994B,0x994C,0x994D,0x994E,0x994F,0x9950,0x9951,
0x9952,0x9953,0x9956,0x9957,0x9958,0x9959,0x995A,0x995B,
0x995C,0x995D,0x995E,0x995F,0x9960,0x9961,0x9962,0x9964,
0x9966,0x9973,0x9978,0x9979,0x997B,0x997E,0x9982,0x9983,
0x9989,0x7A39,0x7A37,0x7A51,0x9ECF,0x99A5,0x7A70,0x7688,
0x768E,0x7693,0x7699,0x76A4,0x74DE,0x74E0,0x752C,0x9E20,
0x9E22,0x9E28,0x9E29,0x9E2A,0x9E2B,0x9E2C,0x9E32,0x9E31,
0x9E36,0x9E38,0x9E37,0x9E39,0x9E3A,0x9E3E,0x9E41,0x9E42,
0x9E44,0x9E46,0x9E47,0x9E48,0x9E49,0x9E4B,0x9E4C,0x9E4E,
0x9E51,0x9E55,0x9E57,0x9E5A,0x9E5B,0x9E5C,0x9E5E,0x9E63,
0x9E66,0x9E67,0x9E68,0x9E69,0x9E6A,0x9E6B,0x9E6C,0x9E71,
0x9E6D,0x9E73,0x7592,0x7594,0x7596,0x75A0,0x759D,0x75AC,
0x75A3,0x75B3,0x75B4,0x75B8,0x75C4,0x75B1,0x75B0,0x75C3,
0x75C2,0x75D6,0x75CD,0x75E3,0x75E8,0x75E6,0x75E4,0x75EB,
0x75E7,0x7603,0x75F1,0x75FC,0x75FF,0x7610,0x7600,0x7605,
0x760C,0x7617,0x760A,0x7625,0x7618,0x7615,0x7619,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x998C,0x998E,0x999A,0x999B,0x999C,0x999D,0x999E,0x999F,
0x99A0,0x99A1,0x99A2,0x99A3,0x99A4,0x99A6,0x99A7,0x99A9,
0x99AA,0x99AB,0x99AC,0x99AD,0x99AE,0x99AF,0x99B0,0x99B1,
0x99B2,0x99B3,0x99B4,0x99B5,0x99B6,0x99B7,0x99B8,0x99B9,
0x99BA,0x99BB,0x99BC,0x99BD,0x99BE,0x99BF,0x99C0,0x99C1,
0x99C2,0x99C3,0x99C4,0x99C5,0x99C6,0x99C7,0x99C8,0x99C9,
0x99CA,0x99CB,0x99CC,0x99CD,0x99CE,0x99CF,0x99D0,0x99D1,
0x99D2,0x99D3,0x99D4,0x99D5,0x99D6,0x99D7,0x99D8,     0,
0x99D9,0x99DA,0x99DB,0x99DC,0x99DD,0x99DE,0x99DF,0x99E0,
0x99E1,0x99E2,0x99E3,0x99E4,0x99E5,0x99E6,0x99E7,0x99E8,
0x99E9,0x99EA,0x99EB,0x99EC,0x99ED,0x99EE,0x99EF,0x99F0,
0x99F1,0x99F2,0x99F3,0x99F4,0x99F5,0x99F6,0x99F7,0x99F8,
0x99F9,0x761B,0x763C,0x7622,0x7620,0x7640,0x762D,0x7630,
0x763F,0x7635,0x7643,0x763E,0x7633,0x764D,0x765E,0x7654,
0x765C,0x7656,0x766B,0x766F,0x7FCA,0x7AE6,0x7A78,0x7A79,
0x7A80,0x7A86,0x7A88,0x7A95,0x7AA6,0x7AA0,0x7AAC,0x7AA8,
0x7AAD,0x7AB3,0x8864,0x8869,0x8872,0x887D,0x887F,0x8882,
0x88A2,0x88C6,0x88B7,0x88BC,0x88C9,0x88E2,0x88CE,0x88E3,
0x88E5,0x88F1,0x891A,0x88FC,0x88E8,0x88FE,0x88F0,0x8921,
0x8919,0x8913,0x891B,0x890A,0x8934,0x892B,0x8936,0x8941,
0x8966,0x897B,0x758B,0x80E5,0x76B2,0x76B4,0x77DC,0x8012,
0x8014,0x8016,0x801C,0x8020,0x8022,0x8025,0x8026,0x8027,
0x8029,0x8028,0x8031,0x800B,0x8035,0x8043,0x8046,0x804D,
0x8052,0x8069,0x8071,0x8983,0x9878,0x9880,0x9883,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x99FA,0x99FB,0x99FC,0x99FD,0x99FE,0x99FF,0x9A00,0x9A01,
0x9A02,0x9A03,0x9A04,0x9A05,0x9A06,0x9A07,0x9A08,0x9A09,
0x9A0A,0x9A0B,0x9A0C,0x9A0D,0x9A0E,0x9A0F,0x9A10,0x9A11,
0x9A12,0x9A13,0x9A14,0x9A15,0x9A16,0x9A17,0x9A18,0x9A19,
0x9A1A,0x9A1B,0x9A1C,0x9A1D,0x9A1E,0x9A1F,0x9A20,0x9A21,
0x9A22,0x9A23,0x9A24,0x9A25,0x9A26,0x9A27,0x9A28,0x9A29,
0x9A2A,0x9A2B,0x9A2C,0x9A2D,0x9A2E,0x9A2F,0x9A30,0x9A31,
0x9A32,0x9A33,0x9A34,0x9A35,0x9A36,0x9A37,0x9A38,     0,
0x9A39,0x9A3A,0x9A3B,0x9A3C,0x9A3D,0x9A3E,0x9A3F,0x9A40,
0x9A41,0x9A42,0x9A43,0x9A44,0x9A45,0x9A46,0x9A47,0x9A48,
0x9A49,0x9A4A,0x9A4B,0x9A4C,0x9A4D,0x9A4E,0x9A4F,0x9A50,
0x9A51,0x9A52,0x9A53,0x9A54,0x9A55,0x9A56,0x9A57,0x9A58,
0x9A59,0x9889,0x988C,0x988D,0x988F,0x9894,0x989A,0x989B,
0x989E,0x989F,0x98A1,0x98A2,0x98A5,0x98A6,0x864D,0x8654,
0x866C,0x866E,0x867F,0x867A,0x867C,0x867B,0x86A8,0x868D,
0x868B,0x86AC,0x869D,0x86A7,0x86A3,0x86AA,0x8693,0x86A9,
0x86B6,0x86C4,0x86B5,0x86CE,0x86B0,0x86BA,0x86B1,0x86AF,
0x86C9,0x86CF,0x86B4,0x86E9,0x86F1,0x86F2,0x86ED,0x86F3,
0x86D0,0x8713,0x86DE,0x86F4,0x86DF,0x86D8,0x86D1,0x8703,
0x8707,0x86F8,0x8708,0x870A,0x870D,0x8709,0x8723,0x873B,
0x871E,0x8725,0x872E,0x871A,0x873E,0x8748,0x8734,0x8731,
0x8729,0x8737,0x873F,0x8782,0x8722,0x877D,0x877E,0x877B,
0x8760,0x8770,0x874C,0x876E,0x878B,0x8753,0x8763,0x877C,
0x8764,0x8759,0x8765,0x8793,0x87AF,0x87A8,0x87D2,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9A5A,0x9A5B,0x9A5C,0x9A5D,0x9A5E,0x9A5F,0x9A60,0x9A61,
0x9A62,0x9A63,0x9A64,0x9A65,0x9A66,0x9A67,0x9A68,0x9A69,
0x9A6A,0x9A6B,0x9A72,0x9A83,0x9A89,0x9A8D,0x9A8E,0x9A94,
0x9A95,0x9A99,0x9AA6,0x9AA9,0x9AAA,0x9AAB,0x9AAC,0x9AAD,
0x9AAE,0x9AAF,0x9AB2,0x9AB3,0x9AB4,0x9AB5,0x9AB9,0x9ABB,
0x9ABD,0x9ABE,0x9ABF,0x9AC3,0x9AC4,0x9AC6,0x9AC7,0x9AC8,
0x9AC9,0x9ACA,0x9ACD,0x9ACE,0x9ACF,0x9AD0,0x9AD2,0x9AD4,
0x9AD5,0x9AD6,0x9AD7,0x9AD9,0x9ADA,0x9ADB,0x9ADC,     0,
0x9ADD,0x9ADE,0x9AE0,0x9AE2,0x9AE3,0x9AE4,0x9AE5,0x9AE7,
0x9AE8,0x9AE9,0x9AEA,0x9AEC,0x9AEE,0x9AF0,0x9AF1,0x9AF2,
0x9AF3,0x9AF4,0x9AF5,0x9AF6,0x9AF7,0x9AF8,0x9AFA,0x9AFC,
0x9AFD,0x9AFE,0x9AFF,0x9B00,0x9B01,0x9B02,0x9B04,0x9B05,
0x9B06,0x87C6,0x8788,0x8785,0x87AD,0x8797,0x8783,0x87AB,
0x87E5,0x87AC,0x87B5,0x87B3,0x87CB,0x87D3,0x87BD,0x87D1,
0x87C0,0x87CA,0x87DB,0x87EA,0x87E0,0x87EE,0x8816,0x8813,
0x87FE,0x880A,0x881B,0x8821,0x8839,0x883C,0x7F36,0x7F42,
0x7F44,0x7F45,0x8210,0x7AFA,0x7AFD,0x7B08,0x7B03,0x7B04,
0x7B15,0x7B0A,0x7B2B,0x7B0F,0x7B47,0x7B38,0x7B2A,0x7B19,
0x7B2E,0x7B31,0x7B20,0x7B25,0x7B24,0x7B33,0x7B3E,0x7B1E,
0x7B58,0x7B5A,0x7B45,0x7B75,0x7B4C,0x7B5D,0x7B60,0x7B6E,
0x7B7B,0x7B62,0x7B72,0x7B71,0x7B90,0x7BA6,0x7BA7,0x7BB8,
0x7BAC,0x7B9D,0x7BA8,0x7B85,0x7BAA,0x7B9C,0x7BA2,0x7BAB,
0x7BB4,0x7BD1,0x7BC1,0x7BCC,0x7BDD,0x7BDA,0x7BE5,0x7BE6,
0x7BEA,0x7C0C,0x7BFE,0x7BFC,0x7C0F,0x7C16,0x7C0B,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9B07,0x9B09,0x9B0A,0x9B0B,0x9B0C,0x9B0D,0x9B0E,0x9B10,
0x9B11,0x9B12,0x9B14,0x9B15,0x9B16,0x9B17,0x9B18,0x9B19,
0x9B1A,0x9B1B,0x9B1C,0x9B1D,0x9B1E,0x9B20,0x9B21,0x9B22,
0x9B24,0x9B25,0x9B26,0x9B27,0x9B28,0x9B29,0x9B2A,0x9B2B,
0x9B2C,0x9B2D,0x9B2E,0x9B30,0x9B31,0x9B33,0x9B34,0x9B35,
0x9B36,0x9B37,0x9B38,0x9B39,0x9B3A,0x9B3D,0x9B3E,0x9B3F,
0x9B40,0x9B46,0x9B4A,0x9B4B,0x9B4C,0x9B4E,0x9B50,0x9B52,
0x9B53,0x9B55,0x9B56,0x9B57,0x9B58,0x9B59,0x9B5A,     0,
0x9B5B,0x9B5C,0x9B5D,0x9B5E,0x9B5F,0x9B60,0x9B61,0x9B62,
0x9B63,0x9B64,0x9B65,0x9B66,0x9B67,0x9B68,0x9B69,0x9B6A,
0x9B6B,0x9B6C,0x9B6D,0x9B6E,0x9B6F,0x9B70,0x9B71,0x9B72,
0x9B73,0x9B74,0x9B75,0x9B76,0x9B77,0x9B78,0x9B79,0x9B7A,
0x9B7B,0x7C1F,0x7C2A,0x7C26,0x7C38,0x7C41,0x7C40,0x81FE,
0x8201,0x8202,0x8204,0x81EC,0x8844,0x8221,0x8222,0x8223,
0x822D,0x822F,0x8228,0x822B,0x8238,0x823B,0x8233,0x8234,
0x823E,0x8244,0x8249,0x824B,0x824F,0x825A,0x825F,0x8268,
0x887E,0x8885,0x8888,0x88D8,0x88DF,0x895E,0x7F9D,0x7F9F,
0x7FA7,0x7FAF,0x7FB0,0x7FB2,0x7C7C,0x6549,0x7C91,0x7C9D,
0x7C9C,0x7C9E,0x7CA2,0x7CB2,0x7CBC,0x7CBD,0x7CC1,0x7CC7,
0x7CCC,0x7CCD,0x7CC8,0x7CC5,0x7CD7,0x7CE8,0x826E,0x66A8,
0x7FBF,0x7FCE,0x7FD5,0x7FE5,0x7FE1,0x7FE6,0x7FE9,0x7FEE,
0x7FF3,0x7CF8,0x7D77,0x7DA6,0x7DAE,0x7E47,0x7E9B,0x9EB8,
0x9EB4,0x8D73,0x8D84,0x8D94,0x8D91,0x8DB1,0x8D67,0x8D6D,
0x8C47,0x8C49,0x914A,0x9150,0x914E,0x914F,0x9164,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9B7C,0x9B7D,0x9B7E,0x9B7F,0x9B80,0x9B81,0x9B82,0x9B83,
0x9B84,0x9B85,0x9B86,0x9B87,0x9B88,0x9B89,0x9B8A,0x9B8B,
0x9B8C,0x9B8D,0x9B8E,0x9B8F,0x9B90,0x9B91,0x9B92,0x9B93,
0x9B94,0x9B95,0x9B96,0x9B97,0x9B98,0x9B99,0x9B9A,0x9B9B,
0x9B9C,0x9B9D,0x9B9E,0x9B9F,0x9BA0,0x9BA1,0x9BA2,0x9BA3,
0x9BA4,0x9BA5,0x9BA6,0x9BA7,0x9BA8,0x9BA9,0x9BAA,0x9BAB,
0x9BAC,0x9BAD,0x9BAE,0x9BAF,0x9BB0,0x9BB1,0x9BB2,0x9BB3,
0x9BB4,0x9BB5,0x9BB6,0x9BB7,0x9BB8,0x9BB9,0x9BBA,     0,
0x9BBB,0x9BBC,0x9BBD,0x9BBE,0x9BBF,0x9BC0,0x9BC1,0x9BC2,
0x9BC3,0x9BC4,0x9BC5,0x9BC6,0x9BC7,0x9BC8,0x9BC9,0x9BCA,
0x9BCB,0x9BCC,0x9BCD,0x9BCE,0x9BCF,0x9BD0,0x9BD1,0x9BD2,
0x9BD3,0x9BD4,0x9BD5,0x9BD6,0x9BD7,0x9BD8,0x9BD9,0x9BDA,
0x9BDB,0x9162,0x9161,0x9170,0x9169,0x916F,0x917D,0x917E,
0x9172,0x9174,0x9179,0x918C,0x9185,0x9190,0x918D,0x9191,
0x91A2,0x91A3,0x91AA,0x91AD,0x91AE,0x91AF,0x91B5,0x91B4,
0x91BA,0x8C55,0x9E7E,0x8DB8,0x8DEB,0x8E05,0x8E59,0x8E69,
0x8DB5,0x8DBF,0x8DBC,0x8DBA,0x8DC4,0x8DD6,0x8DD7,0x8DDA,
0x8DDE,0x8DCE,0x8DCF,0x8DDB,0x8DC6,0x8DEC,0x8DF7,0x8DF8,
0x8DE3,0x8DF9,0x8DFB,0x8DE4,0x8E09,0x8DFD,0x8E14,0x8E1D,
0x8E1F,0x8E2C,0x8E2E,0x8E23,0x8E2F,0x8E3A,0x8E40,0x8E39,
0x8E35,0x8E3D,0x8E31,0x8E49,0x8E41,0x8E42,0x8E51,0x8E52,
0x8E4A,0x8E70,0x8E76,0x8E7C,0x8E6F,0x8E74,0x8E85,0x8E8F,
0x8E94,0x8E90,0x8E9C,0x8E9E,0x8C78,0x8C82,0x8C8A,0x8C85,
0x8C98,0x8C94,0x659B,0x89D6,0x89DE,0x89DA,0x89DC,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9BDC,0x9BDD,0x9BDE,0x9BDF,0x9BE0,0x9BE1,0x9BE2,0x9BE3,
0x9BE4,0x9BE5,0x9BE6,0x9BE7,0x9BE8,0x9BE9,0x9BEA,0x9BEB,
0x9BEC,0x9BED,0x9BEE,0x9BEF,0x9BF0,0x9BF1,0x9BF2,0x9BF3,
0x9BF4,0x9BF5,0x9BF6,0x9BF7,0x9BF8,0x9BF9,0x9BFA,0x9BFB,
0x9BFC,0x9BFD,0x9BFE,0x9BFF,0x9C00,0x9C01,0x9C02,0x9C03,
0x9C04,0x9C05,0x9C06,0x9C07,0x9C08,0x9C09,0x9C0A,0x9C0B,
0x9C0C,0x9C0D,0x9C0E,0x9C0F,0x9C10,0x9C11,0x9C12,0x9C13,
0x9C14,0x9C15,0x9C16,0x9C17,0x9C18,0x9C19,0x9C1A,     0,
0x9C1B,0x9C1C,0x9C1D,0x9C1E,0x9C1F,0x9C20,0x9C21,0x9C22,
0x9C23,0x9C24,0x9C25,0x9C26,0x9C27,0x9C28,0x9C29,0x9C2A,
0x9C2B,0x9C2C,0x9C2D,0x9C2E,0x9C2F,0x9C30,0x9C31,0x9C32,
0x9C33,0x9C34,0x9C35,0x9C36,0x9C37,0x9C38,0x9C39,0x9C3A,
0x9C3B,0x89E5,0x89EB,0x89EF,0x8A3E,0x8B26,0x9753,0x96E9,
0x96F3,0x96EF,0x9706,0x9701,0x9708,0x970F,0x970E,0x972A,
0x972D,0x9730,0x973E,0x9F80,0x9F83,0x9F85,0x9F86,0x9F87,
0x9F88,0x9F89,0x9F8A,0x9F8C,0x9EFE,0x9F0B,0x9F0D,0x96B9,
0x96BC,0x96BD,0x96CE,0x96D2,0x77BF,0x96E0,0x928E,0x92AE,
0x92C8,0x933E,0x936A,0x93CA,0x938F,0x943E,0x946B,0x9C7F,
0x9C82,0x9C85,0x9C86,0x9C87,0x9C88,0x7A23,0x9C8B,0x9C8E,
0x9C90,0x9C91,0x9C92,0x9C94,0x9C95,0x9C9A,0x9C9B,0x9C9E,
0x9C9F,0x9CA0,0x9CA1,0x9CA2,0x9CA3,0x9CA5,0x9CA6,0x9CA7,
0x9CA8,0x9CA9,0x9CAB,0x9CAD,0x9CAE,0x9CB0,0x9CB1,0x9CB2,
0x9CB3,0x9CB4,0x9CB5,0x9CB6,0x9CB7,0x9CBA,0x9CBB,0x9CBC,
0x9CBD,0x9CC4,0x9CC5,0x9CC6,0x9CC7,0x9CCA,0x9CCB,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9C3C,0x9C3D,0x9C3E,0x9C3F,0x9C40,0x9C41,0x9C42,0x9C43,
0x9C44,0x9C45,0x9C46,0x9C47,0x9C48,0x9C49,0x9C4A,0x9C4B,
0x9C4C,0x9C4D,0x9C4E,0x9C4F,0x9C50,0x9C51,0x9C52,0x9C53,
0x9C54,0x9C55,0x9C56,0x9C57,0x9C58,0x9C59,0x9C5A,0x9C5B,
0x9C5C,0x9C5D,0x9C5E,0x9C5F,0x9C60,0x9C61,0x9C62,0x9C63,
0x9C64,0x9C65,0x9C66,0x9C67,0x9C68,0x9C69,0x9C6A,0x9C6B,
0x9C6C,0x9C6D,0x9C6E,0x9C6F,0x9C70,0x9C71,0x9C72,0x9C73,
0x9C74,0x9C75,0x9C76,0x9C77,0x9C78,0x9C79,0x9C7A,     0,
0x9C7B,0x9C7D,0x9C7E,0x9C80,0x9C83,0x9C84,0x9C89,0x9C8A,
0x9C8C,0x9C8F,0x9C93,0x9C96,0x9C97,0x9C98,0x9C99,0x9C9D,
0x9CAA,0x9CAC,0x9CAF,0x9CB9,0x9CBE,0x9CBF,0x9CC0,0x9CC1,
0x9CC2,0x9CC8,0x9CC9,0x9CD1,0x9CD2,0x9CDA,0x9CDB,0x9CE0,
0x9CE1,0x9CCC,0x9CCD,0x9CCE,0x9CCF,0x9CD0,0x9CD3,0x9CD4,
0x9CD5,0x9CD7,0x9CD8,0x9CD9,0x9CDC,0x9CDD,0x9CDF,0x9CE2,
0x977C,0x9785,0x9791,0x9792,0x9794,0x97AF,0x97AB,0x97A3,
0x97B2,0x97B4,0x9AB1,0x9AB0,0x9AB7,0x9E58,0x9AB6,0x9ABA,
0x9ABC,0x9AC1,0x9AC0,0x9AC5,0x9AC2,0x9ACB,0x9ACC,0x9AD1,
0x9B45,0x9B43,0x9B47,0x9B49,0x9B48,0x9B4D,0x9B51,0x98E8,
0x990D,0x992E,0x9955,0x9954,0x9ADF,0x9AE1,0x9AE6,0x9AEF,
0x9AEB,0x9AFB,0x9AED,0x9AF9,0x9B08,0x9B0F,0x9B13,0x9B1F,
0x9B23,0x9EBD,0x9EBE,0x7E3B,0x9E82,0x9E87,0x9E88,0x9E8B,
0x9E92,0x93D6,0x9E9D,0x9E9F,0x9EDB,0x9EDC,0x9EDD,0x9EE0,
0x9EDF,0x9EE2,0x9EE9,0x9EE7,0x9EE5,0x9EEA,0x9EEF,0x9F22,
0x9F2C,0x9F2F,0x9F39,0x9F37,0x9F3D,0x9F3E,0x9F44,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9CE3,0x9CE4,0x9CE5,0x9CE6,0x9CE7,0x9CE8,0x9CE9,0x9CEA,
0x9CEB,0x9CEC,0x9CED,0x9CEE,0x9CEF,0x9CF0,0x9CF1,0x9CF2,
0x9CF3,0x9CF4,0x9CF5,0x9CF6,0x9CF7,0x9CF8,0x9CF9,0x9CFA,
0x9CFB,0x9CFC,0x9CFD,0x9CFE,0x9CFF,0x9D00,0x9D01,0x9D02,
0x9D03,0x9D04,0x9D05,0x9D06,0x9D07,0x9D08,0x9D09,0x9D0A,
0x9D0B,0x9D0C,0x9D0D,0x9D0E,0x9D0F,0x9D10,0x9D11,0x9D12,
0x9D13,0x9D14,0x9D15,0x9D16,0x9D17,0x9D18,0x9D19,0x9D1A,
0x9D1B,0x9D1C,0x9D1D,0x9D1E,0x9D1F,0x9D20,0x9D21,     0,
0x9D22,0x9D23,0x9D24,0x9D25,0x9D26,0x9D27,0x9D28,0x9D29,
0x9D2A,0x9D2B,0x9D2C,0x9D2D,0x9D2E,0x9D2F,0x9D30,0x9D31,
0x9D32,0x9D33,0x9D34,0x9D35,0x9D36,0x9D37,0x9D38,0x9D39,
0x9D3A,0x9D3B,0x9D3C,0x9D3D,0x9D3E,0x9D3F,0x9D40,0x9D41,
0x9D42,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9D43,0x9D44,0x9D45,0x9D46,0x9D47,0x9D48,0x9D49,0x9D4A,
0x9D4B,0x9D4C,0x9D4D,0x9D4E,0x9D4F,0x9D50,0x9D51,0x9D52,
0x9D53,0x9D54,0x9D55,0x9D56,0x9D57,0x9D58,0x9D59,0x9D5A,
0x9D5B,0x9D5C,0x9D5D,0x9D5E,0x9D5F,0x9D60,0x9D61,0x9D62,
0x9D63,0x9D64,0x9D65,0x9D66,0x9D67,0x9D68,0x9D69,0x9D6A,
0x9D6B,0x9D6C,0x9D6D,0x9D6E,0x9D6F,0x9D70,0x9D71,0x9D72,
0x9D73,0x9D74,0x9D75,0x9D76,0x9D77,0x9D78,0x9D79,0x9D7A,
0x9D7B,0x9D7C,0x9D7D,0x9D7E,0x9D7F,0x9D80,0x9D81,     0,
0x9D82,0x9D83,0x9D84,0x9D85,0x9D86,0x9D87,0x9D88,0x9D89,
0x9D8A,0x9D8B,0x9D8C,0x9D8D,0x9D8E,0x9D8F,0x9D90,0x9D91,
0x9D92,0x9D93,0x9D94,0x9D95,0x9D96,0x9D97,0x9D98,0x9D99,
0x9D9A,0x9D9B,0x9D9C,0x9D9D,0x9D9E,0x9D9F,0x9DA0,0x9DA1,
0x9DA2,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9DA3,0x9DA4,0x9DA5,0x9DA6,0x9DA7,0x9DA8,0x9DA9,0x9DAA,
0x9DAB,0x9DAC,0x9DAD,0x9DAE,0x9DAF,0x9DB0,0x9DB1,0x9DB2,
0x9DB3,0x9DB4,0x9DB5,0x9DB6,0x9DB7,0x9DB8,0x9DB9,0x9DBA,
0x9DBB,0x9DBC,0x9DBD,0x9DBE,0x9DBF,0x9DC0,0x9DC1,0x9DC2,
0x9DC3,0x9DC4,0x9DC5,0x9DC6,0x9DC7,0x9DC8,0x9DC9,0x9DCA,
0x9DCB,0x9DCC,0x9DCD,0x9DCE,0x9DCF,0x9DD0,0x9DD1,0x9DD2,
0x9DD3,0x9DD4,0x9DD5,0x9DD6,0x9DD7,0x9DD8,0x9DD9,0x9DDA,
0x9DDB,0x9DDC,0x9DDD,0x9DDE,0x9DDF,0x9DE0,0x9DE1,     0,
0x9DE2,0x9DE3,0x9DE4,0x9DE5,0x9DE6,0x9DE7,0x9DE8,0x9DE9,
0x9DEA,0x9DEB,0x9DEC,0x9DED,0x9DEE,0x9DEF,0x9DF0,0x9DF1,
0x9DF2,0x9DF3,0x9DF4,0x9DF5,0x9DF6,0x9DF7,0x9DF8,0x9DF9,
0x9DFA,0x9DFB,0x9DFC,0x9DFD,0x9DFE,0x9DFF,0x9E00,0x9E01,
0x9E02,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9E03,0x9E04,0x9E05,0x9E06,0x9E07,0x9E08,0x9E09,0x9E0A,
0x9E0B,0x9E0C,0x9E0D,0x9E0E,0x9E0F,0x9E10,0x9E11,0x9E12,
0x9E13,0x9E14,0x9E15,0x9E16,0x9E17,0x9E18,0x9E19,0x9E1A,
0x9E1B,0x9E1C,0x9E1D,0x9E1E,0x9E24,0x9E27,0x9E2E,0x9E30,
0x9E34,0x9E3B,0x9E3C,0x9E40,0x9E4D,0x9E50,0x9E52,0x9E53,
0x9E54,0x9E56,0x9E59,0x9E5D,0x9E5F,0x9E60,0x9E61,0x9E62,
0x9E65,0x9E6E,0x9E6F,0x9E72,0x9E74,0x9E75,0x9E76,0x9E77,
0x9E78,0x9E79,0x9E7A,0x9E7B,0x9E7C,0x9E7D,0x9E80,     0,
0x9E81,0x9E83,0x9E84,0x9E85,0x9E86,0x9E89,0x9E8A,0x9E8C,
0x9E8D,0x9E8E,0x9E8F,0x9E90,0x9E91,0x9E94,0x9E95,0x9E96,
0x9E97,0x9E98,0x9E99,0x9E9A,0x9E9B,0x9E9C,0x9E9E,0x9EA0,
0x9EA1,0x9EA2,0x9EA3,0x9EA4,0x9EA5,0x9EA7,0x9EA8,0x9EA9,
0x9EAA,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9EAB,0x9EAC,0x9EAD,0x9EAE,0x9EAF,0x9EB0,0x9EB1,0x9EB2,
0x9EB3,0x9EB5,0x9EB6,0x9EB7,0x9EB9,0x9EBA,0x9EBC,0x9EBF,
0x9EC0,0x9EC1,0x9EC2,0x9EC3,0x9EC5,0x9EC6,0x9EC7,0x9EC8,
0x9ECA,0x9ECB,0x9ECC,0x9ED0,0x9ED2,0x9ED3,0x9ED5,0x9ED6,
0x9ED7,0x9ED9,0x9EDA,0x9EDE,0x9EE1,0x9EE3,0x9EE4,0x9EE6,
0x9EE8,0x9EEB,0x9EEC,0x9EED,0x9EEE,0x9EF0,0x9EF1,0x9EF2,
0x9EF3,0x9EF4,0x9EF5,0x9EF6,0x9EF7,0x9EF8,0x9EFA,0x9EFD,
0x9EFF,0x9F00,0x9F01,0x9F02,0x9F03,0x9F04,0x9F05,     0,
0x9F06,0x9F07,0x9F08,0x9F09,0x9F0A,0x9F0C,0x9F0F,0x9F11,
0x9F12,0x9F14,0x9F15,0x9F16,0x9F18,0x9F1A,0x9F1B,0x9F1C,
0x9F1D,0x9F1E,0x9F1F,0x9F21,0x9F23,0x9F24,0x9F25,0x9F26,
0x9F27,0x9F28,0x9F29,0x9F2A,0x9F2B,0x9F2D,0x9F2E,0x9F30,
0x9F31,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0x9F32,0x9F33,0x9F34,0x9F35,0x9F36,0x9F38,0x9F3A,0x9F3C,
0x9F3F,0x9F40,0x9F41,0x9F42,0x9F43,0x9F45,0x9F46,0x9F47,
0x9F48,0x9F49,0x9F4A,0x9F4B,0x9F4C,0x9F4D,0x9F4E,0x9F4F,
0x9F52,0x9F53,0x9F54,0x9F55,0x9F56,0x9F57,0x9F58,0x9F59,
0x9F5A,0x9F5B,0x9F5C,0x9F5D,0x9F5E,0x9F5F,0x9F60,0x9F61,
0x9F62,0x9F63,0x9F64,0x9F65,0x9F66,0x9F67,0x9F68,0x9F69,
0x9F6A,0x9F6B,0x9F6C,0x9F6D,0x9F6E,0x9F6F,0x9F70,0x9F71,
0x9F72,0x9F73,0x9F74,0x9F75,0x9F76,0x9F77,0x9F78,     0,
0x9F79,0x9F7A,0x9F7B,0x9F7C,0x9F7D,0x9F7E,0x9F81,0x9F82,
0x9F8D,0x9F8E,0x9F8F,0x9F90,0x9F91,0x9F92,0x9F93,0x9F94,
0x9F95,0x9F96,0x9F97,0x9F98,0x9F9C,0x9F9D,0x9F9E,0x9FA1,
0x9FA2,0x9FA3,0x9FA4,0x9FA5,0xF92C,0xF979,0xF995,0xF9E7,
0xF9F1,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xFA0C,0xFA0D,0xFA0E,0xFA0F,0xFA11,0xFA13,0xFA14,0xFA18,
0xFA1F,0xFA20,0xFA21,0xFA23,0xFA24,0xFA27,0xFA28,0xFA29
};

static int func_gbk_uni_onechar(int code){
  if  ((code>=0x8140)&&(code<=0xFE4F))
    return(tab_gbk_uni0[code-0x8140]);
  return(0);
}



/* page 0 0x00A4-0x0451 */
static const uint16 tab_uni_gbk0[]={
0xA1E8,     0,     0,0xA1EC,0xA1A7,     0,     0,     0,
     0,     0,     0,     0,0xA1E3,0xA1C0,     0,     0,
     0,     0,     0,0xA1A4,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,0xA1C1,     0,     0,     0,     0,
     0,     0,     0,     0,0xA8A4,0xA8A2,     0,     0,
     0,     0,     0,     0,0xA8A8,0xA8A6,0xA8BA,     0,
0xA8AC,0xA8AA,     0,     0,     0,     0,0xA8B0,0xA8AE,
     0,     0,     0,0xA1C2,     0,0xA8B4,0xA8B2,     0,
0xA8B9,     0,     0,     0,     0,0xA8A1,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,0xA8A5,
     0,     0,     0,     0,     0,     0,     0,0xA8A7,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,0xA8A9,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA8BD,     0,     0,     0,0xA8BE,     0,     0,     0,
     0,0xA8AD,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,0xA8B1,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,0xA8A3,     0,0xA8AB,     0,0xA8AF,     0,
0xA8B3,     0,0xA8B5,     0,0xA8B6,     0,0xA8B7,     0,
0xA8B8,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA8BB,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA8C0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,0xA1A6,     0,0xA1A5,0xA840,0xA841,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA842,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA6A1,0xA6A2,0xA6A3,
0xA6A4,0xA6A5,0xA6A6,0xA6A7,0xA6A8,0xA6A9,0xA6AA,0xA6AB,
0xA6AC,0xA6AD,0xA6AE,0xA6AF,0xA6B0,0xA6B1,     0,0xA6B2,
0xA6B3,0xA6B4,0xA6B5,0xA6B6,0xA6B7,0xA6B8,     0,     0,
     0,     0,     0,     0,     0,0xA6C1,0xA6C2,0xA6C3,
0xA6C4,0xA6C5,0xA6C6,0xA6C7,0xA6C8,0xA6C9,0xA6CA,0xA6CB,
0xA6CC,0xA6CD,0xA6CE,0xA6CF,0xA6D0,0xA6D1,     0,0xA6D2,
0xA6D3,0xA6D4,0xA6D5,0xA6D6,0xA6D7,0xA6D8,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA7A7,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,0xA7A1,0xA7A2,0xA7A3,0xA7A4,
0xA7A5,0xA7A6,0xA7A8,0xA7A9,0xA7AA,0xA7AB,0xA7AC,0xA7AD,
0xA7AE,0xA7AF,0xA7B0,0xA7B1,0xA7B2,0xA7B3,0xA7B4,0xA7B5,
0xA7B6,0xA7B7,0xA7B8,0xA7B9,0xA7BA,0xA7BB,0xA7BC,0xA7BD,
0xA7BE,0xA7BF,0xA7C0,0xA7C1,0xA7D1,0xA7D2,0xA7D3,0xA7D4,
0xA7D5,0xA7D6,0xA7D8,0xA7D9,0xA7DA,0xA7DB,0xA7DC,0xA7DD,
0xA7DE,0xA7DF,0xA7E0,0xA7E1,0xA7E2,0xA7E3,0xA7E4,0xA7E5,
0xA7E6,0xA7E7,0xA7E8,0xA7E9,0xA7EA,0xA7EB,0xA7EC,0xA7ED,
0xA7EE,0xA7EF,0xA7F0,0xA7F1,     0,0xA7D7};

/* page 1 0x2010-0x2312 */
static const uint16 tab_uni_gbk1[]={
0xA95C,     0,     0,0xA843,0xA1AA,0xA844,0xA1AC,     0,
0xA1AE,0xA1AF,     0,     0,0xA1B0,0xA1B1,     0,     0,
     0,     0,     0,     0,     0,0xA845,0xA1AD,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1EB,     0,0xA1E4,0xA1E5,     0,0xA846,     0,     0,
     0,     0,     0,0xA1F9,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,0xA1E6,     0,0xA847,     0,     0,
     0,0xA848,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,0xA1ED,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0xA959,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA2F1,0xA2F2,0xA2F3,0xA2F4,0xA2F5,0xA2F6,0xA2F7,0xA2F8,
0xA2F9,0xA2FA,0xA2FB,0xA2FC,     0,     0,     0,     0,
0xA2A1,0xA2A2,0xA2A3,0xA2A4,0xA2A5,0xA2A6,0xA2A7,0xA2A8,
0xA2A9,0xA2AA,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1FB,0xA1FC,0xA1FA,0xA1FD,     0,     0,0xA849,0xA84A,
0xA84B,0xA84C,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1CA,     0,     0,     0,     0,     0,     0,0xA1C7,
     0,0xA1C6,     0,     0,     0,0xA84D,     0,     0,
     0,     0,0xA1CC,     0,     0,0xA1D8,0xA1DE,0xA84E,
0xA1CF,     0,     0,0xA84F,     0,0xA1CE,     0,0xA1C4,
0xA1C5,0xA1C9,0xA1C8,0xA1D2,     0,     0,0xA1D3,     0,
     0,     0,     0,     0,0xA1E0,0xA1DF,0xA1C3,0xA1CB,
     0,     0,     0,     0,     0,0xA1D7,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1D6,     0,     0,     0,0xA1D5,     0,     0,     0,
     0,     0,0xA850,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1D9,0xA1D4,     0,     0,0xA1DC,0xA1DD,0xA851,0xA852,
     0,     0,     0,     0,     0,     0,0xA1DA,0xA1DB,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA892,     0,     0,
     0,0xA1D1,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA1CD,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,0xA853,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,0xA1D0};

/* page 2 0x2460-0x2642 */
static const uint16 tab_uni_gbk2[]={
0xA2D9,0xA2DA,0xA2DB,0xA2DC,0xA2DD,0xA2DE,0xA2DF,0xA2E0,
0xA2E1,0xA2E2,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,0xA2C5,0xA2C6,0xA2C7,0xA2C8,
0xA2C9,0xA2CA,0xA2CB,0xA2CC,0xA2CD,0xA2CE,0xA2CF,0xA2D0,
0xA2D1,0xA2D2,0xA2D3,0xA2D4,0xA2D5,0xA2D6,0xA2D7,0xA2D8,
0xA2B1,0xA2B2,0xA2B3,0xA2B4,0xA2B5,0xA2B6,0xA2B7,0xA2B8,
0xA2B9,0xA2BA,0xA2BB,0xA2BC,0xA2BD,0xA2BE,0xA2BF,0xA2C0,
0xA2C1,0xA2C2,0xA2C3,0xA2C4,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA9A4,0xA9A5,0xA9A6,0xA9A7,0xA9A8,0xA9A9,0xA9AA,0xA9AB,
0xA9AC,0xA9AD,0xA9AE,0xA9AF,0xA9B0,0xA9B1,0xA9B2,0xA9B3,
0xA9B4,0xA9B5,0xA9B6,0xA9B7,0xA9B8,0xA9B9,0xA9BA,0xA9BB,
0xA9BC,0xA9BD,0xA9BE,0xA9BF,0xA9C0,0xA9C1,0xA9C2,0xA9C3,
0xA9C4,0xA9C5,0xA9C6,0xA9C7,0xA9C8,0xA9C9,0xA9CA,0xA9CB,
0xA9CC,0xA9CD,0xA9CE,0xA9CF,0xA9D0,0xA9D1,0xA9D2,0xA9D3,
0xA9D4,0xA9D5,0xA9D6,0xA9D7,0xA9D8,0xA9D9,0xA9DA,0xA9DB,
0xA9DC,0xA9DD,0xA9DE,0xA9DF,0xA9E0,0xA9E1,0xA9E2,0xA9E3,
0xA9E4,0xA9E5,0xA9E6,0xA9E7,0xA9E8,0xA9E9,0xA9EA,0xA9EB,
0xA9EC,0xA9ED,0xA9EE,0xA9EF,     0,     0,     0,     0,
0xA854,0xA855,0xA856,0xA857,0xA858,0xA859,0xA85A,0xA85B,
0xA85C,0xA85D,0xA85E,0xA85F,0xA860,0xA861,0xA862,0xA863,
0xA864,0xA865,0xA866,0xA867,0xA868,0xA869,0xA86A,0xA86B,
0xA86C,0xA86D,0xA86E,0xA86F,0xA870,0xA871,0xA872,0xA873,
0xA874,0xA875,0xA876,0xA877,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0xA878,0xA879,0xA87A,0xA87B,0xA87C,0xA87D,0xA87E,
0xA880,0xA881,0xA882,0xA883,0xA884,0xA885,0xA886,0xA887,
     0,     0,     0,0xA888,0xA889,0xA88A,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1F6,0xA1F5,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,0xA1F8,0xA1F7,     0,     0,     0,     0,
     0,     0,     0,     0,0xA88B,0xA88C,     0,     0,
     0,     0,     0,     0,     0,     0,0xA1F4,0xA1F3,
     0,     0,     0,0xA1F0,     0,     0,0xA1F2,0xA1F1,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,0xA88D,0xA88E,0xA88F,0xA890,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xA1EF,0xA1EE,     0,
     0,0xA891,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1E2,     0,0xA1E1};

/* page 3 0x3000-0x3129 */
static const uint16 tab_uni_gbk3[]={
0xA1A1,0xA1A2,0xA1A3,0xA1A8,     0,0xA1A9,0xA965,0xA996,
0xA1B4,0xA1B5,0xA1B6,0xA1B7,0xA1B8,0xA1B9,0xA1BA,0xA1BB,
0xA1BE,0xA1BF,0xA893,0xA1FE,0xA1B2,0xA1B3,0xA1BC,0xA1BD,
     0,     0,     0,     0,     0,0xA894,0xA895,     0,
     0,0xA940,0xA941,0xA942,0xA943,0xA944,0xA945,0xA946,
0xA947,0xA948,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0xA4A1,0xA4A2,0xA4A3,0xA4A4,0xA4A5,0xA4A6,0xA4A7,
0xA4A8,0xA4A9,0xA4AA,0xA4AB,0xA4AC,0xA4AD,0xA4AE,0xA4AF,
0xA4B0,0xA4B1,0xA4B2,0xA4B3,0xA4B4,0xA4B5,0xA4B6,0xA4B7,
0xA4B8,0xA4B9,0xA4BA,0xA4BB,0xA4BC,0xA4BD,0xA4BE,0xA4BF,
0xA4C0,0xA4C1,0xA4C2,0xA4C3,0xA4C4,0xA4C5,0xA4C6,0xA4C7,
0xA4C8,0xA4C9,0xA4CA,0xA4CB,0xA4CC,0xA4CD,0xA4CE,0xA4CF,
0xA4D0,0xA4D1,0xA4D2,0xA4D3,0xA4D4,0xA4D5,0xA4D6,0xA4D7,
0xA4D8,0xA4D9,0xA4DA,0xA4DB,0xA4DC,0xA4DD,0xA4DE,0xA4DF,
0xA4E0,0xA4E1,0xA4E2,0xA4E3,0xA4E4,0xA4E5,0xA4E6,0xA4E7,
0xA4E8,0xA4E9,0xA4EA,0xA4EB,0xA4EC,0xA4ED,0xA4EE,0xA4EF,
0xA4F0,0xA4F1,0xA4F2,0xA4F3,     0,     0,     0,     0,
     0,     0,     0,0xA961,0xA962,0xA966,0xA967,     0,
     0,0xA5A1,0xA5A2,0xA5A3,0xA5A4,0xA5A5,0xA5A6,0xA5A7,
0xA5A8,0xA5A9,0xA5AA,0xA5AB,0xA5AC,0xA5AD,0xA5AE,0xA5AF,
0xA5B0,0xA5B1,0xA5B2,0xA5B3,0xA5B4,0xA5B5,0xA5B6,0xA5B7,
0xA5B8,0xA5B9,0xA5BA,0xA5BB,0xA5BC,0xA5BD,0xA5BE,0xA5BF,
0xA5C0,0xA5C1,0xA5C2,0xA5C3,0xA5C4,0xA5C5,0xA5C6,0xA5C7,
0xA5C8,0xA5C9,0xA5CA,0xA5CB,0xA5CC,0xA5CD,0xA5CE,0xA5CF,
0xA5D0,0xA5D1,0xA5D2,0xA5D3,0xA5D4,0xA5D5,0xA5D6,0xA5D7,
0xA5D8,0xA5D9,0xA5DA,0xA5DB,0xA5DC,0xA5DD,0xA5DE,0xA5DF,
0xA5E0,0xA5E1,0xA5E2,0xA5E3,0xA5E4,0xA5E5,0xA5E6,0xA5E7,
0xA5E8,0xA5E9,0xA5EA,0xA5EB,0xA5EC,0xA5ED,0xA5EE,0xA5EF,
0xA5F0,0xA5F1,0xA5F2,0xA5F3,0xA5F4,0xA5F5,0xA5F6,     0,
     0,     0,     0,     0,0xA960,0xA963,0xA964,     0,
     0,     0,     0,     0,     0,0xA8C5,0xA8C6,0xA8C7,
0xA8C8,0xA8C9,0xA8CA,0xA8CB,0xA8CC,0xA8CD,0xA8CE,0xA8CF,
0xA8D0,0xA8D1,0xA8D2,0xA8D3,0xA8D4,0xA8D5,0xA8D6,0xA8D7,
0xA8D8,0xA8D9,0xA8DA,0xA8DB,0xA8DC,0xA8DD,0xA8DE,0xA8DF,
0xA8E0,0xA8E1,0xA8E2,0xA8E3,0xA8E4,0xA8E5,0xA8E6,0xA8E7,
0xA8E8,0xA8E9};

/* page 4 0x3220-0x32A3 */
static const uint16 tab_uni_gbk4[]={
0xA2E5,0xA2E6,0xA2E7,0xA2E8,0xA2E9,0xA2EA,0xA2EB,0xA2EC,
0xA2ED,0xA2EE,     0,     0,     0,     0,     0,     0,
     0,0xA95A,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,0xA949};

/* page 5 0x338E-0x33D5 */
static const uint16 tab_uni_gbk5[]={
0xA94A,0xA94B,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,0xA94C,0xA94D,
0xA94E,     0,     0,0xA94F,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,0xA950,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA951,     0,     0,0xA952,0xA953,     0,     0,0xA954
};

/* page 6 0x4E00-0x9FA5 */
static const uint16 tab_uni_gbk6[]={
0xD2BB,0xB6A1,0x8140,0xC6DF,0x8141,0x8142,0x8143,0xCDF2,
0xD5C9,0xC8FD,0xC9CF,0xCFC2,0xD8A2,0xB2BB,0xD3EB,0x8144,
0xD8A4,0xB3F3,0x8145,0xD7A8,0xC7D2,0xD8A7,0xCAC0,0x8146,
0xC7F0,0xB1FB,0xD2B5,0xB4D4,0xB6AB,0xCBBF,0xD8A9,0x8147,
0x8148,0x8149,0xB6AA,0x814A,0xC1BD,0xD1CF,0x814B,0xC9A5,
0xD8AD,0x814C,0xB8F6,0xD1BE,0xE3DC,0xD6D0,0x814D,0x814E,
0xB7E1,0x814F,0xB4AE,0x8150,0xC1D9,0x8151,0xD8BC,0x8152,
0xCDE8,0xB5A4,0xCEAA,0xD6F7,0x8153,0xC0F6,0xBED9,0xD8AF,
0x8154,0x8155,0x8156,0xC4CB,0x8157,0xBEC3,0x8158,0xD8B1,
0xC3B4,0xD2E5,0x8159,0xD6AE,0xCEDA,0xD5A7,0xBAF5,0xB7A6,
0xC0D6,0x815A,0xC6B9,0xC5D2,0xC7C7,0x815B,0xB9D4,0x815C,
0xB3CB,0xD2D2,0x815D,0x815E,0xD8BF,0xBEC5,0xC6F2,0xD2B2,
0xCFB0,0xCFE7,0x815F,0x8160,0x8161,0x8162,0xCAE9,0x8163,
0x8164,0xD8C0,0x8165,0x8166,0x8167,0x8168,0x8169,0x816A,
0xC2F2,0xC2D2,0x816B,0xC8E9,0x816C,0x816D,0x816E,0x816F,
0x8170,0x8171,0x8172,0x8173,0x8174,0x8175,0xC7AC,0x8176,
0x8177,0x8178,0x8179,0x817A,0x817B,0x817C,0xC1CB,0x817D,
0xD3E8,0xD5F9,0x817E,0xCAC2,0xB6FE,0xD8A1,0xD3DA,0xBFF7,
0x8180,0xD4C6,0xBBA5,0xD8C1,0xCEE5,0xBEAE,0x8181,0x8182,
0xD8A8,0x8183,0xD1C7,0xD0A9,0x8184,0x8185,0x8186,0xD8BD,
0xD9EF,0xCDF6,0xBFBA,0x8187,0xBDBB,0xBAA5,0xD2E0,0xB2FA,
0xBAE0,0xC4B6,0x8188,0xCFED,0xBEA9,0xCDA4,0xC1C1,0x8189,
0x818A,0x818B,0xC7D7,0xD9F1,0x818C,0xD9F4,0x818D,0x818E,
0x818F,0x8190,0xC8CB,0xD8E9,0x8191,0x8192,0x8193,0xD2DA,
0xCAB2,0xC8CA,0xD8EC,0xD8EA,0xD8C6,0xBDF6,0xC6CD,0xB3F0,
0x8194,0xD8EB,0xBDF1,0xBDE9,0x8195,0xC8D4,0xB4D3,0x8196,
0x8197,0xC2D8,0x8198,0xB2D6,0xD7D0,0xCACB,0xCBFB,0xD5CC,
0xB8B6,0xCFC9,0x8199,0x819A,0x819B,0xD9DA,0xD8F0,0xC7AA,
0x819C,0xD8EE,0x819D,0xB4FA,0xC1EE,0xD2D4,0x819E,0x819F,
0xD8ED,0x81A0,0xD2C7,0xD8EF,0xC3C7,0x81A1,0x81A2,0x81A3,
0xD1F6,0x81A4,0xD6D9,0xD8F2,0x81A5,0xD8F5,0xBCFE,0xBCDB,
0x81A6,0x81A7,0x81A8,0xC8CE,0x81A9,0xB7DD,0x81AA,0xB7C2,
0x81AB,0xC6F3,0x81AC,0x81AD,0x81AE,0x81AF,0x81B0,0x81B1,
0x81B2,0xD8F8,0xD2C1,0x81B3,0x81B4,0xCEE9,0xBCBF,0xB7FC,
0xB7A5,0xD0DD,0x81B5,0x81B6,0x81B7,0x81B8,0x81B9,0xD6DA,
0xD3C5,0xBBEF,0xBBE1,0xD8F1,0x81BA,0x81BB,0xC9A1,0xCEB0,
0xB4AB,0x81BC,0xD8F3,0x81BD,0xC9CB,0xD8F6,0xC2D7,0xD8F7,
0x81BE,0x81BF,0xCEB1,0xD8F9,0x81C0,0x81C1,0x81C2,0xB2AE,
0xB9C0,0x81C3,0xD9A3,0x81C4,0xB0E9,0x81C5,0xC1E6,0x81C6,
0xC9EC,0x81C7,0xCBC5,0x81C8,0xCBC6,0xD9A4,0x81C9,0x81CA,
0x81CB,0x81CC,0x81CD,0xB5E8,0x81CE,0x81CF,0xB5AB,0x81D0,
0x81D1,0x81D2,0x81D3,0x81D4,0x81D5,0xCEBB,0xB5CD,0xD7A1,
0xD7F4,0xD3D3,0x81D6,0xCCE5,0x81D7,0xBACE,0x81D8,0xD9A2,
0xD9DC,0xD3E0,0xD8FD,0xB7F0,0xD7F7,0xD8FE,0xD8FA,0xD9A1,
0xC4E3,0x81D9,0x81DA,0xD3B6,0xD8F4,0xD9DD,0x81DB,0xD8FB,
0x81DC,0xC5E5,0x81DD,0x81DE,0xC0D0,0x81DF,0x81E0,0xD1F0,
0xB0DB,0x81E1,0x81E2,0xBCD1,0xD9A6,0x81E3,0xD9A5,0x81E4,
0x81E5,0x81E6,0x81E7,0xD9AC,0xD9AE,0x81E8,0xD9AB,0xCAB9,
0x81E9,0x81EA,0x81EB,0xD9A9,0xD6B6,0x81EC,0x81ED,0x81EE,
0xB3DE,0xD9A8,0x81EF,0xC0FD,0x81F0,0xCACC,0x81F1,0xD9AA,
0x81F2,0xD9A7,0x81F3,0x81F4,0xD9B0,0x81F5,0x81F6,0xB6B1,
0x81F7,0x81F8,0x81F9,0xB9A9,0x81FA,0xD2C0,0x81FB,0x81FC,
0xCFC0,0x81FD,0x81FE,0xC2C2,0x8240,0xBDC4,0xD5EC,0xB2E0,
0xC7C8,0xBFEB,0xD9AD,0x8241,0xD9AF,0x8242,0xCEEA,0xBAEE,
0x8243,0x8244,0x8245,0x8246,0x8247,0xC7D6,0x8248,0x8249,
0x824A,0x824B,0x824C,0x824D,0x824E,0x824F,0x8250,0xB1E3,
0x8251,0x8252,0x8253,0xB4D9,0xB6ED,0xD9B4,0x8254,0x8255,
0x8256,0x8257,0xBFA1,0x8258,0x8259,0x825A,0xD9DE,0xC7CE,
0xC0FE,0xD9B8,0x825B,0x825C,0x825D,0x825E,0x825F,0xCBD7,
0xB7FD,0x8260,0xD9B5,0x8261,0xD9B7,0xB1A3,0xD3E1,0xD9B9,
0x8262,0xD0C5,0x8263,0xD9B6,0x8264,0x8265,0xD9B1,0x8266,
0xD9B2,0xC1A9,0xD9B3,0x8267,0x8268,0xBCF3,0xD0DE,0xB8A9,
0x8269,0xBEE3,0x826A,0xD9BD,0x826B,0x826C,0x826D,0x826E,
0xD9BA,0x826F,0xB0B3,0x8270,0x8271,0x8272,0xD9C2,0x8273,
0x8274,0x8275,0x8276,0x8277,0x8278,0x8279,0x827A,0x827B,
0x827C,0x827D,0x827E,0x8280,0xD9C4,0xB1B6,0x8281,0xD9BF,
0x8282,0x8283,0xB5B9,0x8284,0xBEF3,0x8285,0x8286,0x8287,
0xCCC8,0xBAF2,0xD2D0,0x8288,0xD9C3,0x8289,0x828A,0xBDE8,
0x828B,0xB3AB,0x828C,0x828D,0x828E,0xD9C5,0xBEEB,0x828F,
0xD9C6,0xD9BB,0xC4DF,0x8290,0xD9BE,0xD9C1,0xD9C0,0x8291,
0x8292,0x8293,0x8294,0x8295,0x8296,0x8297,0x8298,0x8299,
0x829A,0x829B,0xD5AE,0x829C,0xD6B5,0x829D,0xC7E3,0x829E,
0x829F,0x82A0,0x82A1,0xD9C8,0x82A2,0x82A3,0x82A4,0xBCD9,
0xD9CA,0x82A5,0x82A6,0x82A7,0xD9BC,0x82A8,0xD9CB,0xC6AB,
0x82A9,0x82AA,0x82AB,0x82AC,0x82AD,0xD9C9,0x82AE,0x82AF,
0x82B0,0x82B1,0xD7F6,0x82B2,0xCDA3,0x82B3,0x82B4,0x82B5,
0x82B6,0x82B7,0x82B8,0x82B9,0x82BA,0xBDA1,0x82BB,0x82BC,
0x82BD,0x82BE,0x82BF,0x82C0,0xD9CC,0x82C1,0x82C2,0x82C3,
0x82C4,0x82C5,0x82C6,0x82C7,0x82C8,0x82C9,0xC5BC,0xCDB5,
0x82CA,0x82CB,0x82CC,0xD9CD,0x82CD,0x82CE,0xD9C7,0xB3A5,
0xBFFE,0x82CF,0x82D0,0x82D1,0x82D2,0xB8B5,0x82D3,0x82D4,
0xC0FC,0x82D5,0x82D6,0x82D7,0x82D8,0xB0F8,0x82D9,0x82DA,
0x82DB,0x82DC,0x82DD,0x82DE,0x82DF,0x82E0,0x82E1,0x82E2,
0x82E3,0x82E4,0x82E5,0x82E6,0x82E7,0x82E8,0x82E9,0x82EA,
0x82EB,0x82EC,0x82ED,0xB4F6,0x82EE,0xD9CE,0x82EF,0xD9CF,
0xB4A2,0xD9D0,0x82F0,0x82F1,0xB4DF,0x82F2,0x82F3,0x82F4,
0x82F5,0x82F6,0xB0C1,0x82F7,0x82F8,0x82F9,0x82FA,0x82FB,
0x82FC,0x82FD,0xD9D1,0xC9B5,0x82FE,0x8340,0x8341,0x8342,
0x8343,0x8344,0x8345,0x8346,0x8347,0x8348,0x8349,0x834A,
0x834B,0x834C,0x834D,0x834E,0x834F,0x8350,0x8351,0xCFF1,
0x8352,0x8353,0x8354,0x8355,0x8356,0x8357,0xD9D2,0x8358,
0x8359,0x835A,0xC1C5,0x835B,0x835C,0x835D,0x835E,0x835F,
0x8360,0x8361,0x8362,0x8363,0x8364,0x8365,0xD9D6,0xC9AE,
0x8366,0x8367,0x8368,0x8369,0xD9D5,0xD9D4,0xD9D7,0x836A,
0x836B,0x836C,0x836D,0xCBDB,0x836E,0xBDA9,0x836F,0x8370,
0x8371,0x8372,0x8373,0xC6A7,0x8374,0x8375,0x8376,0x8377,
0x8378,0x8379,0x837A,0x837B,0x837C,0x837D,0xD9D3,0xD9D8,
0x837E,0x8380,0x8381,0xD9D9,0x8382,0x8383,0x8384,0x8385,
0x8386,0x8387,0xC8E5,0x8388,0x8389,0x838A,0x838B,0x838C,
0x838D,0x838E,0x838F,0x8390,0x8391,0x8392,0x8393,0x8394,
0x8395,0xC0DC,0x8396,0x8397,0x8398,0x8399,0x839A,0x839B,
0x839C,0x839D,0x839E,0x839F,0x83A0,0x83A1,0x83A2,0x83A3,
0x83A4,0x83A5,0x83A6,0x83A7,0x83A8,0x83A9,0x83AA,0x83AB,
0x83AC,0x83AD,0x83AE,0x83AF,0x83B0,0x83B1,0x83B2,0xB6F9,
0xD8A3,0xD4CA,0x83B3,0xD4AA,0xD0D6,0xB3E4,0xD5D7,0x83B4,
0xCFC8,0xB9E2,0x83B5,0xBFCB,0x83B6,0xC3E2,0x83B7,0x83B8,
0x83B9,0xB6D2,0x83BA,0x83BB,0xCDC3,0xD9EE,0xD9F0,0x83BC,
0x83BD,0x83BE,0xB5B3,0x83BF,0xB6B5,0x83C0,0x83C1,0x83C2,
0x83C3,0x83C4,0xBEA4,0x83C5,0x83C6,0xC8EB,0x83C7,0x83C8,
0xC8AB,0x83C9,0x83CA,0xB0CB,0xB9AB,0xC1F9,0xD9E2,0x83CB,
0xC0BC,0xB9B2,0x83CC,0xB9D8,0xD0CB,0xB1F8,0xC6E4,0xBEDF,
0xB5E4,0xD7C8,0x83CD,0xD1F8,0xBCE6,0xCADE,0x83CE,0x83CF,
0xBCBD,0xD9E6,0xD8E7,0x83D0,0x83D1,0xC4DA,0x83D2,0x83D3,
0xB8D4,0xC8BD,0x83D4,0x83D5,0xB2E1,0xD4D9,0x83D6,0x83D7,
0x83D8,0x83D9,0xC3B0,0x83DA,0x83DB,0xC3E1,0xDAA2,0xC8DF,
0x83DC,0xD0B4,0x83DD,0xBEFC,0xC5A9,0x83DE,0x83DF,0x83E0,
0xB9DA,0x83E1,0xDAA3,0x83E2,0xD4A9,0xDAA4,0x83E3,0x83E4,
0x83E5,0x83E6,0x83E7,0xD9FB,0xB6AC,0x83E8,0x83E9,0xB7EB,
0xB1F9,0xD9FC,0xB3E5,0xBEF6,0x83EA,0xBFF6,0xD2B1,0xC0E4,
0x83EB,0x83EC,0x83ED,0xB6B3,0xD9FE,0xD9FD,0x83EE,0x83EF,
0xBEBB,0x83F0,0x83F1,0x83F2,0xC6E0,0x83F3,0xD7BC,0xDAA1,
0x83F4,0xC1B9,0x83F5,0xB5F2,0xC1E8,0x83F6,0x83F7,0xBCF5,
0x83F8,0xB4D5,0x83F9,0x83FA,0x83FB,0x83FC,0x83FD,0x83FE,
0x8440,0x8441,0x8442,0xC1DD,0x8443,0xC4FD,0x8444,0x8445,
0xBCB8,0xB7B2,0x8446,0x8447,0xB7EF,0x8448,0x8449,0x844A,
0x844B,0x844C,0x844D,0xD9EC,0x844E,0xC6BE,0x844F,0xBFAD,
0xBBCB,0x8450,0x8451,0xB5CA,0x8452,0xDBC9,0xD0D7,0x8453,
0xCDB9,0xB0BC,0xB3F6,0xBBF7,0xDBCA,0xBAAF,0x8454,0xD4E4,
0xB5B6,0xB5F3,0xD8D6,0xC8D0,0x8455,0x8456,0xB7D6,0xC7D0,
0xD8D7,0x8457,0xBFAF,0x8458,0x8459,0xDBBB,0xD8D8,0x845A,
0x845B,0xD0CC,0xBBAE,0x845C,0x845D,0x845E,0xEBBE,0xC1D0,
0xC1F5,0xD4F2,0xB8D5,0xB4B4,0x845F,0xB3F5,0x8460,0x8461,
0xC9BE,0x8462,0x8463,0x8464,0xC5D0,0x8465,0x8466,0x8467,
0xC5D9,0xC0FB,0x8468,0xB1F0,0x8469,0xD8D9,0xB9CE,0x846A,
0xB5BD,0x846B,0x846C,0xD8DA,0x846D,0x846E,0xD6C6,0xCBA2,
0xC8AF,0xC9B2,0xB4CC,0xBFCC,0x846F,0xB9F4,0x8470,0xD8DB,
0xD8DC,0xB6E7,0xBCC1,0xCCEA,0x8471,0x8472,0x8473,0x8474,
0x8475,0x8476,0xCFF7,0x8477,0xD8DD,0xC7B0,0x8478,0x8479,
0xB9D0,0xBDA3,0x847A,0x847B,0xCCDE,0x847C,0xC6CA,0x847D,
0x847E,0x8480,0x8481,0x8482,0xD8E0,0x8483,0xD8DE,0x8484,
0x8485,0xD8DF,0x8486,0x8487,0x8488,0xB0FE,0x8489,0xBEE7,
0x848A,0xCAA3,0xBCF4,0x848B,0x848C,0x848D,0x848E,0xB8B1,
0x848F,0x8490,0xB8EE,0x8491,0x8492,0x8493,0x8494,0x8495,
0x8496,0x8497,0x8498,0x8499,0x849A,0xD8E2,0x849B,0xBDCB,
0x849C,0xD8E4,0xD8E3,0x849D,0x849E,0x849F,0x84A0,0x84A1,
0xC5FC,0x84A2,0x84A3,0x84A4,0x84A5,0x84A6,0x84A7,0x84A8,
0xD8E5,0x84A9,0x84AA,0xD8E6,0x84AB,0x84AC,0x84AD,0x84AE,
0x84AF,0x84B0,0x84B1,0xC1A6,0x84B2,0xC8B0,0xB0EC,0xB9A6,
0xBCD3,0xCEF1,0xDBBD,0xC1D3,0x84B3,0x84B4,0x84B5,0x84B6,
0xB6AF,0xD6FA,0xC5AC,0xBDD9,0xDBBE,0xDBBF,0x84B7,0x84B8,
0x84B9,0xC0F8,0xBEA2,0xC0CD,0x84BA,0x84BB,0x84BC,0x84BD,
0x84BE,0x84BF,0x84C0,0x84C1,0x84C2,0x84C3,0xDBC0,0xCAC6,
0x84C4,0x84C5,0x84C6,0xB2AA,0x84C7,0x84C8,0x84C9,0xD3C2,
0x84CA,0xC3E3,0x84CB,0xD1AB,0x84CC,0x84CD,0x84CE,0x84CF,
0xDBC2,0x84D0,0xC0D5,0x84D1,0x84D2,0x84D3,0xDBC3,0x84D4,
0xBFB1,0x84D5,0x84D6,0x84D7,0x84D8,0x84D9,0x84DA,0xC4BC,
0x84DB,0x84DC,0x84DD,0x84DE,0xC7DA,0x84DF,0x84E0,0x84E1,
0x84E2,0x84E3,0x84E4,0x84E5,0x84E6,0x84E7,0x84E8,0x84E9,
0xDBC4,0x84EA,0x84EB,0x84EC,0x84ED,0x84EE,0x84EF,0x84F0,
0x84F1,0xD9E8,0xC9D7,0x84F2,0x84F3,0x84F4,0xB9B4,0xCEF0,
0xD4C8,0x84F5,0x84F6,0x84F7,0x84F8,0xB0FC,0xB4D2,0x84F9,
0xD0D9,0x84FA,0x84FB,0x84FC,0x84FD,0xD9E9,0x84FE,0xDECB,
0xD9EB,0x8540,0x8541,0x8542,0x8543,0xD8B0,0xBBAF,0xB1B1,
0x8544,0xB3D7,0xD8CE,0x8545,0x8546,0xD4D1,0x8547,0x8548,
0xBDB3,0xBFEF,0x8549,0xCFBB,0x854A,0x854B,0xD8D0,0x854C,
0x854D,0x854E,0xB7CB,0x854F,0x8550,0x8551,0xD8D1,0x8552,
0x8553,0x8554,0x8555,0x8556,0x8557,0x8558,0x8559,0x855A,
0x855B,0xC6A5,0xC7F8,0xD2BD,0x855C,0x855D,0xD8D2,0xC4E4,
0x855E,0xCAAE,0x855F,0xC7A7,0x8560,0xD8A6,0x8561,0xC9FD,
0xCEE7,0xBBDC,0xB0EB,0x8562,0x8563,0x8564,0xBBAA,0xD0AD,
0x8565,0xB1B0,0xD7E4,0xD7BF,0x8566,0xB5A5,0xC2F4,0xC4CF,
0x8567,0x8568,0xB2A9,0x8569,0xB2B7,0x856A,0xB1E5,0xDFB2,
0xD5BC,0xBFA8,0xC2AC,0xD8D5,0xC2B1,0x856B,0xD8D4,0xCED4,
0x856C,0xDAE0,0x856D,0xCEC0,0x856E,0x856F,0xD8B4,0xC3AE,
0xD3A1,0xCEA3,0x8570,0xBCB4,0xC8B4,0xC2D1,0x8571,0xBEED,
0xD0B6,0x8572,0xDAE1,0x8573,0x8574,0x8575,0x8576,0xC7E4,
0x8577,0x8578,0xB3A7,0x8579,0xB6F2,0xCCFC,0xC0FA,0x857A,
0x857B,0xC0F7,0x857C,0xD1B9,0xD1E1,0xD8C7,0x857D,0x857E,
0x8580,0x8581,0x8582,0x8583,0x8584,0xB2DE,0x8585,0x8586,
0xC0E5,0x8587,0xBAF1,0x8588,0x8589,0xD8C8,0x858A,0xD4AD,
0x858B,0x858C,0xCFE1,0xD8C9,0x858D,0xD8CA,0xCFC3,0x858E,
0xB3F8,0xBEC7,0x858F,0x8590,0x8591,0x8592,0xD8CB,0x8593,
0x8594,0x8595,0x8596,0x8597,0x8598,0x8599,0xDBCC,0x859A,
0x859B,0x859C,0x859D,0xC8A5,0x859E,0x859F,0x85A0,0xCFD8,
0x85A1,0xC8FE,0xB2CE,0x85A2,0x85A3,0x85A4,0x85A5,0x85A6,
0xD3D6,0xB2E6,0xBCB0,0xD3D1,0xCBAB,0xB7B4,0x85A7,0x85A8,
0x85A9,0xB7A2,0x85AA,0x85AB,0xCAE5,0x85AC,0xC8A1,0xCADC,
0xB1E4,0xD0F0,0x85AD,0xC5D1,0x85AE,0x85AF,0x85B0,0xDBC5,
0xB5FE,0x85B1,0x85B2,0xBFDA,0xB9C5,0xBEE4,0xC1ED,0x85B3,
0xDFB6,0xDFB5,0xD6BB,0xBDD0,0xD5D9,0xB0C8,0xB6A3,0xBFC9,
0xCCA8,0xDFB3,0xCAB7,0xD3D2,0x85B4,0xD8CF,0xD2B6,0xBAC5,
0xCBBE,0xCCBE,0x85B5,0xDFB7,0xB5F0,0xDFB4,0x85B6,0x85B7,
0x85B8,0xD3F5,0x85B9,0xB3D4,0xB8F7,0x85BA,0xDFBA,0x85BB,
0xBACF,0xBCAA,0xB5F5,0x85BC,0xCDAC,0xC3FB,0xBAF3,0xC0F4,
0xCDC2,0xCFF2,0xDFB8,0xCFC5,0x85BD,0xC2C0,0xDFB9,0xC2F0,
0x85BE,0x85BF,0x85C0,0xBEFD,0x85C1,0xC1DF,0xCDCC,0xD2F7,
0xB7CD,0xDFC1,0x85C2,0xDFC4,0x85C3,0x85C4,0xB7F1,0xB0C9,
0xB6D6,0xB7D4,0x85C5,0xBAAC,0xCCFD,0xBFD4,0xCBB1,0xC6F4,
0x85C6,0xD6A8,0xDFC5,0x85C7,0xCEE2,0xB3B3,0x85C8,0x85C9,
0xCEFC,0xB4B5,0x85CA,0xCEC7,0xBAF0,0x85CB,0xCEE1,0x85CC,
0xD1BD,0x85CD,0x85CE,0xDFC0,0x85CF,0x85D0,0xB4F4,0x85D1,
0xB3CA,0x85D2,0xB8E6,0xDFBB,0x85D3,0x85D4,0x85D5,0x85D6,
0xC4C5,0x85D7,0xDFBC,0xDFBD,0xDFBE,0xC5BB,0xDFBF,0xDFC2,
0xD4B1,0xDFC3,0x85D8,0xC7BA,0xCED8,0x85D9,0x85DA,0x85DB,
0x85DC,0x85DD,0xC4D8,0x85DE,0xDFCA,0x85DF,0xDFCF,0x85E0,
0xD6DC,0x85E1,0x85E2,0x85E3,0x85E4,0x85E5,0x85E6,0x85E7,
0x85E8,0xDFC9,0xDFDA,0xCEB6,0x85E9,0xBAC7,0xDFCE,0xDFC8,
0xC5DE,0x85EA,0x85EB,0xC9EB,0xBAF4,0xC3FC,0x85EC,0x85ED,
0xBED7,0x85EE,0xDFC6,0x85EF,0xDFCD,0x85F0,0xC5D8,0x85F1,
0x85F2,0x85F3,0x85F4,0xD5A6,0xBACD,0x85F5,0xBECC,0xD3BD,
0xB8C0,0x85F6,0xD6E4,0x85F7,0xDFC7,0xB9BE,0xBFA7,0x85F8,
0x85F9,0xC1FC,0xDFCB,0xDFCC,0x85FA,0xDFD0,0x85FB,0x85FC,
0x85FD,0x85FE,0x8640,0xDFDB,0xDFE5,0x8641,0xDFD7,0xDFD6,
0xD7C9,0xDFE3,0xDFE4,0xE5EB,0xD2A7,0xDFD2,0x8642,0xBFA9,
0x8643,0xD4DB,0x8644,0xBFC8,0xDFD4,0x8645,0x8646,0x8647,
0xCFCC,0x8648,0x8649,0xDFDD,0x864A,0xD1CA,0x864B,0xDFDE,
0xB0A7,0xC6B7,0xDFD3,0x864C,0xBAE5,0x864D,0xB6DF,0xCDDB,
0xB9FE,0xD4D5,0x864E,0x864F,0xDFDF,0xCFEC,0xB0A5,0xDFE7,
0xDFD1,0xD1C6,0xDFD5,0xDFD8,0xDFD9,0xDFDC,0x8650,0xBBA9,
0x8651,0xDFE0,0xDFE1,0x8652,0xDFE2,0xDFE6,0xDFE8,0xD3B4,
0x8653,0x8654,0x8655,0x8656,0x8657,0xB8E7,0xC5B6,0xDFEA,
0xC9DA,0xC1A8,0xC4C4,0x8658,0x8659,0xBFDE,0xCFF8,0x865A,
0x865B,0x865C,0xD5DC,0xDFEE,0x865D,0x865E,0x865F,0x8660,
0x8661,0x8662,0xB2B8,0x8663,0xBADF,0xDFEC,0x8664,0xDBC1,
0x8665,0xD1E4,0x8666,0x8667,0x8668,0x8669,0xCBF4,0xB4BD,
0x866A,0xB0A6,0x866B,0x866C,0x866D,0x866E,0x866F,0xDFF1,
0xCCC6,0xDFF2,0x8670,0x8671,0xDFED,0x8672,0x8673,0x8674,
0x8675,0x8676,0x8677,0xDFE9,0x8678,0x8679,0x867A,0x867B,
0xDFEB,0x867C,0xDFEF,0xDFF0,0xBBBD,0x867D,0x867E,0xDFF3,
0x8680,0x8681,0xDFF4,0x8682,0xBBA3,0x8683,0xCADB,0xCEA8,
0xE0A7,0xB3AA,0x8684,0xE0A6,0x8685,0x8686,0x8687,0xE0A1,
0x8688,0x8689,0x868A,0x868B,0xDFFE,0x868C,0xCDD9,0xDFFC,
0x868D,0xDFFA,0x868E,0xBFD0,0xD7C4,0x868F,0xC9CC,0x8690,
0x8691,0xDFF8,0xB0A1,0x8692,0x8693,0x8694,0x8695,0x8696,
0xDFFD,0x8697,0x8698,0x8699,0x869A,0xDFFB,0xE0A2,0x869B,
0x869C,0x869D,0x869E,0x869F,0xE0A8,0x86A0,0x86A1,0x86A2,
0x86A3,0xB7C8,0x86A4,0x86A5,0xC6A1,0xC9B6,0xC0B2,0xDFF5,
0x86A6,0x86A7,0xC5BE,0x86A8,0xD8C4,0xDFF9,0xC4F6,0x86A9,
0x86AA,0x86AB,0x86AC,0x86AD,0x86AE,0xE0A3,0xE0A4,0xE0A5,
0xD0A5,0x86AF,0x86B0,0xE0B4,0xCCE4,0x86B1,0xE0B1,0x86B2,
0xBFA6,0xE0AF,0xCEB9,0xE0AB,0xC9C6,0x86B3,0x86B4,0xC0AE,
0xE0AE,0xBAED,0xBAB0,0xE0A9,0x86B5,0x86B6,0x86B7,0xDFF6,
0x86B8,0xE0B3,0x86B9,0x86BA,0xE0B8,0x86BB,0x86BC,0x86BD,
0xB4AD,0xE0B9,0x86BE,0x86BF,0xCFB2,0xBAC8,0x86C0,0xE0B0,
0x86C1,0x86C2,0x86C3,0x86C4,0x86C5,0x86C6,0x86C7,0xD0FA,
0x86C8,0x86C9,0x86CA,0x86CB,0x86CC,0x86CD,0x86CE,0x86CF,
0x86D0,0xE0AC,0x86D1,0xD4FB,0x86D2,0xDFF7,0x86D3,0xC5E7,
0x86D4,0xE0AD,0x86D5,0xD3F7,0x86D6,0xE0B6,0xE0B7,0x86D7,
0x86D8,0x86D9,0x86DA,0x86DB,0xE0C4,0xD0E1,0x86DC,0x86DD,
0x86DE,0xE0BC,0x86DF,0x86E0,0xE0C9,0xE0CA,0x86E1,0x86E2,
0x86E3,0xE0BE,0xE0AA,0xC9A4,0xE0C1,0x86E4,0xE0B2,0x86E5,
0x86E6,0x86E7,0x86E8,0x86E9,0xCAC8,0xE0C3,0x86EA,0xE0B5,
0x86EB,0xCECB,0x86EC,0xCBC3,0xE0CD,0xE0C6,0xE0C2,0x86ED,
0xE0CB,0x86EE,0xE0BA,0xE0BF,0xE0C0,0x86EF,0x86F0,0xE0C5,
0x86F1,0x86F2,0xE0C7,0xE0C8,0x86F3,0xE0CC,0x86F4,0xE0BB,
0x86F5,0x86F6,0x86F7,0x86F8,0x86F9,0xCBD4,0xE0D5,0x86FA,
0xE0D6,0xE0D2,0x86FB,0x86FC,0x86FD,0x86FE,0x8740,0x8741,
0xE0D0,0xBCCE,0x8742,0x8743,0xE0D1,0x8744,0xB8C2,0xD8C5,
0x8745,0x8746,0x8747,0x8748,0x8749,0x874A,0x874B,0x874C,
0xD0EA,0x874D,0x874E,0xC2EF,0x874F,0x8750,0xE0CF,0xE0BD,
0x8751,0x8752,0x8753,0xE0D4,0xE0D3,0x8754,0x8755,0xE0D7,
0x8756,0x8757,0x8758,0x8759,0xE0DC,0xE0D8,0x875A,0x875B,
0x875C,0xD6F6,0xB3B0,0x875D,0xD7EC,0x875E,0xCBBB,0x875F,
0x8760,0xE0DA,0x8761,0xCEFB,0x8762,0x8763,0x8764,0xBAD9,
0x8765,0x8766,0x8767,0x8768,0x8769,0x876A,0x876B,0x876C,
0x876D,0x876E,0x876F,0x8770,0xE0E1,0xE0DD,0xD2AD,0x8771,
0x8772,0x8773,0x8774,0x8775,0xE0E2,0x8776,0x8777,0xE0DB,
0xE0D9,0xE0DF,0x8778,0x8779,0xE0E0,0x877A,0x877B,0x877C,
0x877D,0x877E,0xE0DE,0x8780,0xE0E4,0x8781,0x8782,0x8783,
0xC6F7,0xD8AC,0xD4EB,0xE0E6,0xCAC9,0x8784,0x8785,0x8786,
0x8787,0xE0E5,0x8788,0x8789,0x878A,0x878B,0xB8C1,0x878C,
0x878D,0x878E,0x878F,0xE0E7,0xE0E8,0x8790,0x8791,0x8792,
0x8793,0x8794,0x8795,0x8796,0x8797,0xE0E9,0xE0E3,0x8798,
0x8799,0x879A,0x879B,0x879C,0x879D,0x879E,0xBABF,0xCCE7,
0x879F,0x87A0,0x87A1,0xE0EA,0x87A2,0x87A3,0x87A4,0x87A5,
0x87A6,0x87A7,0x87A8,0x87A9,0x87AA,0x87AB,0x87AC,0x87AD,
0x87AE,0x87AF,0x87B0,0xCFF9,0x87B1,0x87B2,0x87B3,0x87B4,
0x87B5,0x87B6,0x87B7,0x87B8,0x87B9,0x87BA,0x87BB,0xE0EB,
0x87BC,0x87BD,0x87BE,0x87BF,0x87C0,0x87C1,0x87C2,0xC8C2,
0x87C3,0x87C4,0x87C5,0x87C6,0xBDC0,0x87C7,0x87C8,0x87C9,
0x87CA,0x87CB,0x87CC,0x87CD,0x87CE,0x87CF,0x87D0,0x87D1,
0x87D2,0x87D3,0xC4D2,0x87D4,0x87D5,0x87D6,0x87D7,0x87D8,
0x87D9,0x87DA,0x87DB,0x87DC,0xE0EC,0x87DD,0x87DE,0xE0ED,
0x87DF,0x87E0,0xC7F4,0xCBC4,0x87E1,0xE0EE,0xBBD8,0xD8B6,
0xD2F2,0xE0EF,0xCDC5,0x87E2,0xB6DA,0x87E3,0x87E4,0x87E5,
0x87E6,0x87E7,0x87E8,0xE0F1,0x87E9,0xD4B0,0x87EA,0x87EB,
0xC0A7,0xB4D1,0x87EC,0x87ED,0xCEA7,0xE0F0,0x87EE,0x87EF,
0x87F0,0xE0F2,0xB9CC,0x87F1,0x87F2,0xB9FA,0xCDBC,0xE0F3,
0x87F3,0x87F4,0x87F5,0xC6D4,0xE0F4,0x87F6,0xD4B2,0x87F7,
0xC8A6,0xE0F6,0xE0F5,0x87F8,0x87F9,0x87FA,0x87FB,0x87FC,
0x87FD,0x87FE,0x8840,0x8841,0x8842,0x8843,0x8844,0x8845,
0x8846,0x8847,0x8848,0x8849,0xE0F7,0x884A,0x884B,0xCDC1,
0x884C,0x884D,0x884E,0xCAA5,0x884F,0x8850,0x8851,0x8852,
0xD4DA,0xDBD7,0xDBD9,0x8853,0xDBD8,0xB9E7,0xDBDC,0xDBDD,
0xB5D8,0x8854,0x8855,0xDBDA,0x8856,0x8857,0x8858,0x8859,
0x885A,0xDBDB,0xB3A1,0xDBDF,0x885B,0x885C,0xBBF8,0x885D,
0xD6B7,0x885E,0xDBE0,0x885F,0x8860,0x8861,0x8862,0xBEF9,
0x8863,0x8864,0xB7BB,0x8865,0xDBD0,0xCCAE,0xBFB2,0xBBB5,
0xD7F8,0xBFD3,0x8866,0x8867,0x8868,0x8869,0x886A,0xBFE9,
0x886B,0x886C,0xBCE1,0xCCB3,0xDBDE,0xB0D3,0xCEEB,0xB7D8,
0xD7B9,0xC6C2,0x886D,0x886E,0xC0A4,0x886F,0xCCB9,0x8870,
0xDBE7,0xDBE1,0xC6BA,0xDBE3,0x8871,0xDBE8,0x8872,0xC5F7,
0x8873,0x8874,0x8875,0xDBEA,0x8876,0x8877,0xDBE9,0xBFC0,
0x8878,0x8879,0x887A,0xDBE6,0xDBE5,0x887B,0x887C,0x887D,
0x887E,0x8880,0xB4B9,0xC0AC,0xC2A2,0xDBE2,0xDBE4,0x8881,
0x8882,0x8883,0x8884,0xD0CD,0xDBED,0x8885,0x8886,0x8887,
0x8888,0x8889,0xC0DD,0xDBF2,0x888A,0x888B,0x888C,0x888D,
0x888E,0x888F,0x8890,0xB6E2,0x8891,0x8892,0x8893,0x8894,
0xDBF3,0xDBD2,0xB9B8,0xD4AB,0xDBEC,0x8895,0xBFD1,0xDBF0,
0x8896,0xDBD1,0x8897,0xB5E6,0x8898,0xDBEB,0xBFE5,0x8899,
0x889A,0x889B,0xDBEE,0x889C,0xDBF1,0x889D,0x889E,0x889F,
0xDBF9,0x88A0,0x88A1,0x88A2,0x88A3,0x88A4,0x88A5,0x88A6,
0x88A7,0x88A8,0xB9A1,0xB0A3,0x88A9,0x88AA,0x88AB,0x88AC,
0x88AD,0x88AE,0x88AF,0xC2F1,0x88B0,0x88B1,0xB3C7,0xDBEF,
0x88B2,0x88B3,0xDBF8,0x88B4,0xC6D2,0xDBF4,0x88B5,0x88B6,
0xDBF5,0xDBF7,0xDBF6,0x88B7,0x88B8,0xDBFE,0x88B9,0xD3F2,
0xB2BA,0x88BA,0x88BB,0x88BC,0xDBFD,0x88BD,0x88BE,0x88BF,
0x88C0,0x88C1,0x88C2,0x88C3,0x88C4,0xDCA4,0x88C5,0xDBFB,
0x88C6,0x88C7,0x88C8,0x88C9,0xDBFA,0x88CA,0x88CB,0x88CC,
0xDBFC,0xC5E0,0xBBF9,0x88CD,0x88CE,0xDCA3,0x88CF,0x88D0,
0xDCA5,0x88D1,0xCCC3,0x88D2,0x88D3,0x88D4,0xB6D1,0xDDC0,
0x88D5,0x88D6,0x88D7,0xDCA1,0x88D8,0xDCA2,0x88D9,0x88DA,
0x88DB,0xC7B5,0x88DC,0x88DD,0x88DE,0xB6E9,0x88DF,0x88E0,
0x88E1,0xDCA7,0x88E2,0x88E3,0x88E4,0x88E5,0xDCA6,0x88E6,
0xDCA9,0xB1A4,0x88E7,0x88E8,0xB5CC,0x88E9,0x88EA,0x88EB,
0x88EC,0x88ED,0xBFB0,0x88EE,0x88EF,0x88F0,0x88F1,0x88F2,
0xD1DF,0x88F3,0x88F4,0x88F5,0x88F6,0xB6C2,0x88F7,0x88F8,
0x88F9,0x88FA,0x88FB,0x88FC,0x88FD,0x88FE,0x8940,0x8941,
0x8942,0x8943,0x8944,0x8945,0xDCA8,0x8946,0x8947,0x8948,
0x8949,0x894A,0x894B,0x894C,0xCBFA,0xEBF3,0x894D,0x894E,
0x894F,0xCBDC,0x8950,0x8951,0xCBFE,0x8952,0x8953,0x8954,
0xCCC1,0x8955,0x8956,0x8957,0x8958,0x8959,0xC8FB,0x895A,
0x895B,0x895C,0x895D,0x895E,0x895F,0xDCAA,0x8960,0x8961,
0x8962,0x8963,0x8964,0xCCEE,0xDCAB,0x8965,0x8966,0x8967,
0x8968,0x8969,0x896A,0x896B,0x896C,0x896D,0x896E,0x896F,
0x8970,0x8971,0x8972,0x8973,0x8974,0x8975,0xDBD3,0x8976,
0xDCAF,0xDCAC,0x8977,0xBEB3,0x8978,0xCAFB,0x8979,0x897A,
0x897B,0xDCAD,0x897C,0x897D,0x897E,0x8980,0x8981,0x8982,
0x8983,0x8984,0xC9CA,0xC4B9,0x8985,0x8986,0x8987,0x8988,
0x8989,0xC7BD,0xDCAE,0x898A,0x898B,0x898C,0xD4F6,0xD0E6,
0x898D,0x898E,0x898F,0x8990,0x8991,0x8992,0x8993,0x8994,
0xC4AB,0xB6D5,0x8995,0x8996,0x8997,0x8998,0x8999,0x899A,
0x899B,0x899C,0x899D,0x899E,0x899F,0x89A0,0x89A1,0x89A2,
0x89A3,0x89A4,0x89A5,0x89A6,0xDBD4,0x89A7,0x89A8,0x89A9,
0x89AA,0xB1DA,0x89AB,0x89AC,0x89AD,0xDBD5,0x89AE,0x89AF,
0x89B0,0x89B1,0x89B2,0x89B3,0x89B4,0x89B5,0x89B6,0x89B7,
0x89B8,0xDBD6,0x89B9,0x89BA,0x89BB,0xBABE,0x89BC,0x89BD,
0x89BE,0x89BF,0x89C0,0x89C1,0x89C2,0x89C3,0x89C4,0x89C5,
0x89C6,0x89C7,0x89C8,0x89C9,0xC8C0,0x89CA,0x89CB,0x89CC,
0x89CD,0x89CE,0x89CF,0xCABF,0xC8C9,0x89D0,0xD7B3,0x89D1,
0xC9F9,0x89D2,0x89D3,0xBFC7,0x89D4,0x89D5,0xBAF8,0x89D6,
0x89D7,0xD2BC,0x89D8,0x89D9,0x89DA,0x89DB,0x89DC,0x89DD,
0x89DE,0x89DF,0xE2BA,0x89E0,0xB4A6,0x89E1,0x89E2,0xB1B8,
0x89E3,0x89E4,0x89E5,0x89E6,0x89E7,0xB8B4,0x89E8,0xCFC4,
0x89E9,0x89EA,0x89EB,0x89EC,0xD9E7,0xCFA6,0xCDE2,0x89ED,
0x89EE,0xD9ED,0xB6E0,0x89EF,0xD2B9,0x89F0,0x89F1,0xB9BB,
0x89F2,0x89F3,0x89F4,0x89F5,0xE2B9,0xE2B7,0x89F6,0xB4F3,
0x89F7,0xCCEC,0xCCAB,0xB7F2,0x89F8,0xD8B2,0xD1EB,0xBABB,
0x89F9,0xCAA7,0x89FA,0x89FB,0xCDB7,0x89FC,0x89FD,0xD2C4,
0xBFE4,0xBCD0,0xB6E1,0x89FE,0xDEC5,0x8A40,0x8A41,0x8A42,
0x8A43,0xDEC6,0xDBBC,0x8A44,0xD1D9,0x8A45,0x8A46,0xC6E6,
0xC4CE,0xB7EE,0x8A47,0xB7DC,0x8A48,0x8A49,0xBFFC,0xD7E0,
0x8A4A,0xC6F5,0x8A4B,0x8A4C,0xB1BC,0xDEC8,0xBDB1,0xCCD7,
0xDECA,0x8A4D,0xDEC9,0x8A4E,0x8A4F,0x8A50,0x8A51,0x8A52,
0xB5EC,0x8A53,0xC9DD,0x8A54,0x8A55,0xB0C2,0x8A56,0x8A57,
0x8A58,0x8A59,0x8A5A,0x8A5B,0x8A5C,0x8A5D,0x8A5E,0x8A5F,
0x8A60,0x8A61,0x8A62,0xC5AE,0xC5AB,0x8A63,0xC4CC,0x8A64,
0xBCE9,0xCBFD,0x8A65,0x8A66,0x8A67,0xBAC3,0x8A68,0x8A69,
0x8A6A,0xE5F9,0xC8E7,0xE5FA,0xCDFD,0x8A6B,0xD7B1,0xB8BE,
0xC2E8,0x8A6C,0xC8D1,0x8A6D,0x8A6E,0xE5FB,0x8A6F,0x8A70,
0x8A71,0x8A72,0xB6CA,0xBCCB,0x8A73,0x8A74,0xD1FD,0xE6A1,
0x8A75,0xC3EE,0x8A76,0x8A77,0x8A78,0x8A79,0xE6A4,0x8A7A,
0x8A7B,0x8A7C,0x8A7D,0xE5FE,0xE6A5,0xCDD7,0x8A7E,0x8A80,
0xB7C1,0xE5FC,0xE5FD,0xE6A3,0x8A81,0x8A82,0xC4DD,0xE6A8,
0x8A83,0x8A84,0xE6A7,0x8A85,0x8A86,0x8A87,0x8A88,0x8A89,
0x8A8A,0xC3C3,0x8A8B,0xC6DE,0x8A8C,0x8A8D,0xE6AA,0x8A8E,
0x8A8F,0x8A90,0x8A91,0x8A92,0x8A93,0x8A94,0xC4B7,0x8A95,
0x8A96,0x8A97,0xE6A2,0xCABC,0x8A98,0x8A99,0x8A9A,0x8A9B,
0xBDE3,0xB9C3,0xE6A6,0xD0D5,0xCEAF,0x8A9C,0x8A9D,0xE6A9,
0xE6B0,0x8A9E,0xD2A6,0x8A9F,0xBDAA,0xE6AD,0x8AA0,0x8AA1,
0x8AA2,0x8AA3,0x8AA4,0xE6AF,0x8AA5,0xC0D1,0x8AA6,0x8AA7,
0xD2CC,0x8AA8,0x8AA9,0x8AAA,0xBCA7,0x8AAB,0x8AAC,0x8AAD,
0x8AAE,0x8AAF,0x8AB0,0x8AB1,0x8AB2,0x8AB3,0x8AB4,0x8AB5,
0x8AB6,0xE6B1,0x8AB7,0xD2F6,0x8AB8,0x8AB9,0x8ABA,0xD7CB,
0x8ABB,0xCDFE,0x8ABC,0xCDDE,0xC2A6,0xE6AB,0xE6AC,0xBDBF,
0xE6AE,0xE6B3,0x8ABD,0x8ABE,0xE6B2,0x8ABF,0x8AC0,0x8AC1,
0x8AC2,0xE6B6,0x8AC3,0xE6B8,0x8AC4,0x8AC5,0x8AC6,0x8AC7,
0xC4EF,0x8AC8,0x8AC9,0x8ACA,0xC4C8,0x8ACB,0x8ACC,0xBEEA,
0xC9EF,0x8ACD,0x8ACE,0xE6B7,0x8ACF,0xB6F0,0x8AD0,0x8AD1,
0x8AD2,0xC3E4,0x8AD3,0x8AD4,0x8AD5,0x8AD6,0x8AD7,0x8AD8,
0x8AD9,0xD3E9,0xE6B4,0x8ADA,0xE6B5,0x8ADB,0xC8A2,0x8ADC,
0x8ADD,0x8ADE,0x8ADF,0x8AE0,0xE6BD,0x8AE1,0x8AE2,0x8AE3,
0xE6B9,0x8AE4,0x8AE5,0x8AE6,0x8AE7,0x8AE8,0xC6C5,0x8AE9,
0x8AEA,0xCDF1,0xE6BB,0x8AEB,0x8AEC,0x8AED,0x8AEE,0x8AEF,
0x8AF0,0x8AF1,0x8AF2,0x8AF3,0x8AF4,0xE6BC,0x8AF5,0x8AF6,
0x8AF7,0x8AF8,0xBBE9,0x8AF9,0x8AFA,0x8AFB,0x8AFC,0x8AFD,
0x8AFE,0x8B40,0xE6BE,0x8B41,0x8B42,0x8B43,0x8B44,0xE6BA,
0x8B45,0x8B46,0xC0B7,0x8B47,0x8B48,0x8B49,0x8B4A,0x8B4B,
0x8B4C,0x8B4D,0x8B4E,0x8B4F,0xD3A4,0xE6BF,0xC9F4,0xE6C3,
0x8B50,0x8B51,0xE6C4,0x8B52,0x8B53,0x8B54,0x8B55,0xD0F6,
0x8B56,0x8B57,0x8B58,0x8B59,0x8B5A,0x8B5B,0x8B5C,0x8B5D,
0x8B5E,0x8B5F,0x8B60,0x8B61,0x8B62,0x8B63,0x8B64,0x8B65,
0x8B66,0x8B67,0xC3BD,0x8B68,0x8B69,0x8B6A,0x8B6B,0x8B6C,
0x8B6D,0x8B6E,0xC3C4,0xE6C2,0x8B6F,0x8B70,0x8B71,0x8B72,
0x8B73,0x8B74,0x8B75,0x8B76,0x8B77,0x8B78,0x8B79,0x8B7A,
0x8B7B,0x8B7C,0xE6C1,0x8B7D,0x8B7E,0x8B80,0x8B81,0x8B82,
0x8B83,0x8B84,0xE6C7,0xCFB1,0x8B85,0xEBF4,0x8B86,0x8B87,
0xE6CA,0x8B88,0x8B89,0x8B8A,0x8B8B,0x8B8C,0xE6C5,0x8B8D,
0x8B8E,0xBCDE,0xC9A9,0x8B8F,0x8B90,0x8B91,0x8B92,0x8B93,
0x8B94,0xBCB5,0x8B95,0x8B96,0xCFD3,0x8B97,0x8B98,0x8B99,
0x8B9A,0x8B9B,0xE6C8,0x8B9C,0xE6C9,0x8B9D,0xE6CE,0x8B9E,
0xE6D0,0x8B9F,0x8BA0,0x8BA1,0xE6D1,0x8BA2,0x8BA3,0x8BA4,
0xE6CB,0xB5D5,0x8BA5,0xE6CC,0x8BA6,0x8BA7,0xE6CF,0x8BA8,
0x8BA9,0xC4DB,0x8BAA,0xE6C6,0x8BAB,0x8BAC,0x8BAD,0x8BAE,
0x8BAF,0xE6CD,0x8BB0,0x8BB1,0x8BB2,0x8BB3,0x8BB4,0x8BB5,
0x8BB6,0x8BB7,0x8BB8,0x8BB9,0x8BBA,0x8BBB,0x8BBC,0x8BBD,
0x8BBE,0x8BBF,0x8BC0,0x8BC1,0x8BC2,0x8BC3,0x8BC4,0x8BC5,
0x8BC6,0xE6D2,0x8BC7,0x8BC8,0x8BC9,0x8BCA,0x8BCB,0x8BCC,
0x8BCD,0x8BCE,0x8BCF,0x8BD0,0x8BD1,0x8BD2,0xE6D4,0xE6D3,
0x8BD3,0x8BD4,0x8BD5,0x8BD6,0x8BD7,0x8BD8,0x8BD9,0x8BDA,
0x8BDB,0x8BDC,0x8BDD,0x8BDE,0x8BDF,0x8BE0,0x8BE1,0x8BE2,
0x8BE3,0x8BE4,0x8BE5,0x8BE6,0x8BE7,0x8BE8,0x8BE9,0x8BEA,
0x8BEB,0x8BEC,0xE6D5,0x8BED,0xD9F8,0x8BEE,0x8BEF,0xE6D6,
0x8BF0,0x8BF1,0x8BF2,0x8BF3,0x8BF4,0x8BF5,0x8BF6,0x8BF7,
0xE6D7,0x8BF8,0x8BF9,0x8BFA,0x8BFB,0x8BFC,0x8BFD,0x8BFE,
0x8C40,0x8C41,0x8C42,0x8C43,0x8C44,0x8C45,0x8C46,0x8C47,
0xD7D3,0xE6DD,0x8C48,0xE6DE,0xBFD7,0xD4D0,0x8C49,0xD7D6,
0xB4E6,0xCBEF,0xE6DA,0xD8C3,0xD7CE,0xD0A2,0x8C4A,0xC3CF,
0x8C4B,0x8C4C,0xE6DF,0xBCBE,0xB9C2,0xE6DB,0xD1A7,0x8C4D,
0x8C4E,0xBAA2,0xC2CF,0x8C4F,0xD8AB,0x8C50,0x8C51,0x8C52,
0xCAEB,0xE5EE,0x8C53,0xE6DC,0x8C54,0xB7F5,0x8C55,0x8C56,
0x8C57,0x8C58,0xC8E6,0x8C59,0x8C5A,0xC4F5,0x8C5B,0x8C5C,
0xE5B2,0xC4FE,0x8C5D,0xCBFC,0xE5B3,0xD5AC,0x8C5E,0xD3EE,
0xCAD8,0xB0B2,0x8C5F,0xCBCE,0xCDEA,0x8C60,0x8C61,0xBAEA,
0x8C62,0x8C63,0x8C64,0xE5B5,0x8C65,0xE5B4,0x8C66,0xD7DA,
0xB9D9,0xD6E6,0xB6A8,0xCDF0,0xD2CB,0xB1A6,0xCAB5,0x8C67,
0xB3E8,0xC9F3,0xBFCD,0xD0FB,0xCAD2,0xE5B6,0xBBC2,0x8C68,
0x8C69,0x8C6A,0xCFDC,0xB9AC,0x8C6B,0x8C6C,0x8C6D,0x8C6E,
0xD4D7,0x8C6F,0x8C70,0xBAA6,0xD1E7,0xCFFC,0xBCD2,0x8C71,
0xE5B7,0xC8DD,0x8C72,0x8C73,0x8C74,0xBFED,0xB1F6,0xCBDE,
0x8C75,0x8C76,0xBCC5,0x8C77,0xBCC4,0xD2FA,0xC3DC,0xBFDC,
0x8C78,0x8C79,0x8C7A,0x8C7B,0xB8BB,0x8C7C,0x8C7D,0x8C7E,
0xC3C2,0x8C80,0xBAAE,0xD4A2,0x8C81,0x8C82,0x8C83,0x8C84,
0x8C85,0x8C86,0x8C87,0x8C88,0x8C89,0xC7DE,0xC4AF,0xB2EC,
0x8C8A,0xB9D1,0x8C8B,0x8C8C,0xE5BB,0xC1C8,0x8C8D,0x8C8E,
0xD5AF,0x8C8F,0x8C90,0x8C91,0x8C92,0x8C93,0xE5BC,0x8C94,
0xE5BE,0x8C95,0x8C96,0x8C97,0x8C98,0x8C99,0x8C9A,0x8C9B,
0xB4E7,0xB6D4,0xCBC2,0xD1B0,0xB5BC,0x8C9C,0x8C9D,0xCAD9,
0x8C9E,0xB7E2,0x8C9F,0x8CA0,0xC9E4,0x8CA1,0xBDAB,0x8CA2,
0x8CA3,0xCEBE,0xD7F0,0x8CA4,0x8CA5,0x8CA6,0x8CA7,0xD0A1,
0x8CA8,0xC9D9,0x8CA9,0x8CAA,0xB6FB,0xE6D8,0xBCE2,0x8CAB,
0xB3BE,0x8CAC,0xC9D0,0x8CAD,0xE6D9,0xB3A2,0x8CAE,0x8CAF,
0x8CB0,0x8CB1,0xDECC,0x8CB2,0xD3C8,0xDECD,0x8CB3,0xD2A2,
0x8CB4,0x8CB5,0x8CB6,0x8CB7,0xDECE,0x8CB8,0x8CB9,0x8CBA,
0x8CBB,0xBECD,0x8CBC,0x8CBD,0xDECF,0x8CBE,0x8CBF,0x8CC0,
0xCAAC,0xD2FC,0xB3DF,0xE5EA,0xC4E1,0xBEA1,0xCEB2,0xC4F2,
0xBED6,0xC6A8,0xB2E3,0x8CC1,0x8CC2,0xBED3,0x8CC3,0x8CC4,
0xC7FC,0xCCEB,0xBDEC,0xCEDD,0x8CC5,0x8CC6,0xCABA,0xC6C1,
0xE5EC,0xD0BC,0x8CC7,0x8CC8,0x8CC9,0xD5B9,0x8CCA,0x8CCB,
0x8CCC,0xE5ED,0x8CCD,0x8CCE,0x8CCF,0x8CD0,0xCAF4,0x8CD1,
0xCDC0,0xC2C5,0x8CD2,0xE5EF,0x8CD3,0xC2C4,0xE5F0,0x8CD4,
0x8CD5,0x8CD6,0x8CD7,0x8CD8,0x8CD9,0x8CDA,0xE5F8,0xCDCD,
0x8CDB,0xC9BD,0x8CDC,0x8CDD,0x8CDE,0x8CDF,0x8CE0,0x8CE1,
0x8CE2,0xD2D9,0xE1A8,0x8CE3,0x8CE4,0x8CE5,0x8CE6,0xD3EC,
0x8CE7,0xCBEA,0xC6F1,0x8CE8,0x8CE9,0x8CEA,0x8CEB,0x8CEC,
0xE1AC,0x8CED,0x8CEE,0x8CEF,0xE1A7,0xE1A9,0x8CF0,0x8CF1,
0xE1AA,0xE1AF,0x8CF2,0x8CF3,0xB2ED,0x8CF4,0xE1AB,0xB8DA,
0xE1AD,0xE1AE,0xE1B0,0xB5BA,0xE1B1,0x8CF5,0x8CF6,0x8CF7,
0x8CF8,0x8CF9,0xE1B3,0xE1B8,0x8CFA,0x8CFB,0x8CFC,0x8CFD,
0x8CFE,0xD1D2,0x8D40,0xE1B6,0xE1B5,0xC1EB,0x8D41,0x8D42,
0x8D43,0xE1B7,0x8D44,0xD4C0,0x8D45,0xE1B2,0x8D46,0xE1BA,
0xB0B6,0x8D47,0x8D48,0x8D49,0x8D4A,0xE1B4,0x8D4B,0xBFF9,
0x8D4C,0xE1B9,0x8D4D,0x8D4E,0xE1BB,0x8D4F,0x8D50,0x8D51,
0x8D52,0x8D53,0x8D54,0xE1BE,0x8D55,0x8D56,0x8D57,0x8D58,
0x8D59,0x8D5A,0xE1BC,0x8D5B,0x8D5C,0x8D5D,0x8D5E,0x8D5F,
0x8D60,0xD6C5,0x8D61,0x8D62,0x8D63,0x8D64,0x8D65,0x8D66,
0x8D67,0xCFBF,0x8D68,0x8D69,0xE1BD,0xE1BF,0xC2CD,0x8D6A,
0xB6EB,0x8D6B,0xD3F8,0x8D6C,0x8D6D,0xC7CD,0x8D6E,0x8D6F,
0xB7E5,0x8D70,0x8D71,0x8D72,0x8D73,0x8D74,0x8D75,0x8D76,
0x8D77,0x8D78,0x8D79,0xBEFE,0x8D7A,0x8D7B,0x8D7C,0x8D7D,
0x8D7E,0x8D80,0xE1C0,0xE1C1,0x8D81,0x8D82,0xE1C7,0xB3E7,
0x8D83,0x8D84,0x8D85,0x8D86,0x8D87,0x8D88,0xC6E9,0x8D89,
0x8D8A,0x8D8B,0x8D8C,0x8D8D,0xB4DE,0x8D8E,0xD1C2,0x8D8F,
0x8D90,0x8D91,0x8D92,0xE1C8,0x8D93,0x8D94,0xE1C6,0x8D95,
0x8D96,0x8D97,0x8D98,0x8D99,0xE1C5,0x8D9A,0xE1C3,0xE1C2,
0x8D9B,0xB1C0,0x8D9C,0x8D9D,0x8D9E,0xD5B8,0xE1C4,0x8D9F,
0x8DA0,0x8DA1,0x8DA2,0x8DA3,0xE1CB,0x8DA4,0x8DA5,0x8DA6,
0x8DA7,0x8DA8,0x8DA9,0x8DAA,0x8DAB,0xE1CC,0xE1CA,0x8DAC,
0x8DAD,0x8DAE,0x8DAF,0x8DB0,0x8DB1,0x8DB2,0x8DB3,0xEFFA,
0x8DB4,0x8DB5,0xE1D3,0xE1D2,0xC7B6,0x8DB6,0x8DB7,0x8DB8,
0x8DB9,0x8DBA,0x8DBB,0x8DBC,0x8DBD,0x8DBE,0x8DBF,0x8DC0,
0xE1C9,0x8DC1,0x8DC2,0xE1CE,0x8DC3,0xE1D0,0x8DC4,0x8DC5,
0x8DC6,0x8DC7,0x8DC8,0x8DC9,0x8DCA,0x8DCB,0x8DCC,0x8DCD,
0x8DCE,0xE1D4,0x8DCF,0xE1D1,0xE1CD,0x8DD0,0x8DD1,0xE1CF,
0x8DD2,0x8DD3,0x8DD4,0x8DD5,0xE1D5,0x8DD6,0x8DD7,0x8DD8,
0x8DD9,0x8DDA,0x8DDB,0x8DDC,0x8DDD,0x8DDE,0x8DDF,0x8DE0,
0x8DE1,0x8DE2,0xE1D6,0x8DE3,0x8DE4,0x8DE5,0x8DE6,0x8DE7,
0x8DE8,0x8DE9,0x8DEA,0x8DEB,0x8DEC,0x8DED,0x8DEE,0x8DEF,
0x8DF0,0x8DF1,0x8DF2,0x8DF3,0x8DF4,0x8DF5,0x8DF6,0x8DF7,
0x8DF8,0xE1D7,0x8DF9,0x8DFA,0x8DFB,0xE1D8,0x8DFC,0x8DFD,
0x8DFE,0x8E40,0x8E41,0x8E42,0x8E43,0x8E44,0x8E45,0x8E46,
0x8E47,0x8E48,0x8E49,0x8E4A,0x8E4B,0x8E4C,0x8E4D,0x8E4E,
0x8E4F,0x8E50,0x8E51,0x8E52,0x8E53,0x8E54,0x8E55,0xE1DA,
0x8E56,0x8E57,0x8E58,0x8E59,0x8E5A,0x8E5B,0x8E5C,0x8E5D,
0x8E5E,0x8E5F,0x8E60,0x8E61,0x8E62,0xE1DB,0x8E63,0x8E64,
0x8E65,0x8E66,0x8E67,0x8E68,0x8E69,0xCEA1,0x8E6A,0x8E6B,
0x8E6C,0x8E6D,0x8E6E,0x8E6F,0x8E70,0x8E71,0x8E72,0x8E73,
0x8E74,0x8E75,0x8E76,0xE7DD,0x8E77,0xB4A8,0xD6DD,0x8E78,
0x8E79,0xD1B2,0xB3B2,0x8E7A,0x8E7B,0xB9A4,0xD7F3,0xC7C9,
0xBEDE,0xB9AE,0x8E7C,0xCED7,0x8E7D,0x8E7E,0xB2EE,0xDBCF,
0x8E80,0xBCBA,0xD2D1,0xCBC8,0xB0CD,0x8E81,0x8E82,0xCFEF,
0x8E83,0x8E84,0x8E85,0x8E86,0x8E87,0xD9E3,0xBDED,0x8E88,
0x8E89,0xB1D2,0xCAD0,0xB2BC,0x8E8A,0xCBA7,0xB7AB,0x8E8B,
0xCAA6,0x8E8C,0x8E8D,0x8E8E,0xCFA3,0x8E8F,0x8E90,0xE0F8,
0xD5CA,0xE0FB,0x8E91,0x8E92,0xE0FA,0xC5C1,0xCCFB,0x8E93,
0xC1B1,0xE0F9,0xD6E3,0xB2AF,0xD6C4,0xB5DB,0x8E94,0x8E95,
0x8E96,0x8E97,0x8E98,0x8E99,0x8E9A,0x8E9B,0xB4F8,0xD6A1,
0x8E9C,0x8E9D,0x8E9E,0x8E9F,0x8EA0,0xCFAF,0xB0EF,0x8EA1,
0x8EA2,0xE0FC,0x8EA3,0x8EA4,0x8EA5,0x8EA6,0x8EA7,0xE1A1,
0xB3A3,0x8EA8,0x8EA9,0xE0FD,0xE0FE,0xC3B1,0x8EAA,0x8EAB,
0x8EAC,0x8EAD,0xC3DD,0x8EAE,0xE1A2,0xB7F9,0x8EAF,0x8EB0,
0x8EB1,0x8EB2,0x8EB3,0x8EB4,0xBBCF,0x8EB5,0x8EB6,0x8EB7,
0x8EB8,0x8EB9,0x8EBA,0x8EBB,0xE1A3,0xC4BB,0x8EBC,0x8EBD,
0x8EBE,0x8EBF,0x8EC0,0xE1A4,0x8EC1,0x8EC2,0xE1A5,0x8EC3,
0x8EC4,0xE1A6,0xB4B1,0x8EC5,0x8EC6,0x8EC7,0x8EC8,0x8EC9,
0x8ECA,0x8ECB,0x8ECC,0x8ECD,0x8ECE,0x8ECF,0x8ED0,0x8ED1,
0x8ED2,0x8ED3,0xB8C9,0xC6BD,0xC4EA,0x8ED4,0xB2A2,0x8ED5,
0xD0D2,0x8ED6,0xE7DB,0xBBC3,0xD3D7,0xD3C4,0x8ED7,0xB9E3,
0xE2CF,0x8ED8,0x8ED9,0x8EDA,0xD7AF,0x8EDB,0xC7EC,0xB1D3,
0x8EDC,0x8EDD,0xB4B2,0xE2D1,0x8EDE,0x8EDF,0x8EE0,0xD0F2,
0xC2AE,0xE2D0,0x8EE1,0xBFE2,0xD3A6,0xB5D7,0xE2D2,0xB5EA,
0x8EE2,0xC3ED,0xB8FD,0x8EE3,0xB8AE,0x8EE4,0xC5D3,0xB7CF,
0xE2D4,0x8EE5,0x8EE6,0x8EE7,0x8EE8,0xE2D3,0xB6C8,0xD7F9,
0x8EE9,0x8EEA,0x8EEB,0x8EEC,0x8EED,0xCDA5,0x8EEE,0x8EEF,
0x8EF0,0x8EF1,0x8EF2,0xE2D8,0x8EF3,0xE2D6,0xCAFC,0xBFB5,
0xD3B9,0xE2D5,0x8EF4,0x8EF5,0x8EF6,0x8EF7,0xE2D7,0x8EF8,
0x8EF9,0x8EFA,0x8EFB,0x8EFC,0x8EFD,0x8EFE,0x8F40,0x8F41,
0x8F42,0xC1AE,0xC0C8,0x8F43,0x8F44,0x8F45,0x8F46,0x8F47,
0x8F48,0xE2DB,0xE2DA,0xC0AA,0x8F49,0x8F4A,0xC1CE,0x8F4B,
0x8F4C,0x8F4D,0x8F4E,0xE2DC,0x8F4F,0x8F50,0x8F51,0x8F52,
0x8F53,0x8F54,0x8F55,0x8F56,0x8F57,0x8F58,0x8F59,0x8F5A,
0xE2DD,0x8F5B,0xE2DE,0x8F5C,0x8F5D,0x8F5E,0x8F5F,0x8F60,
0x8F61,0x8F62,0x8F63,0x8F64,0xDBC8,0x8F65,0xD1D3,0xCDA2,
0x8F66,0x8F67,0xBDA8,0x8F68,0x8F69,0x8F6A,0xDEC3,0xD8A5,
0xBFAA,0xDBCD,0xD2EC,0xC6FA,0xC5AA,0x8F6B,0x8F6C,0x8F6D,
0xDEC4,0x8F6E,0xB1D7,0xDFAE,0x8F6F,0x8F70,0x8F71,0xCABD,
0x8F72,0xDFB1,0x8F73,0xB9AD,0x8F74,0xD2FD,0x8F75,0xB8A5,
0xBAEB,0x8F76,0x8F77,0xB3DA,0x8F78,0x8F79,0x8F7A,0xB5DC,
0xD5C5,0x8F7B,0x8F7C,0x8F7D,0x8F7E,0xC3D6,0xCFD2,0xBBA1,
0x8F80,0xE5F3,0xE5F2,0x8F81,0x8F82,0xE5F4,0x8F83,0xCDE4,
0x8F84,0xC8F5,0x8F85,0x8F86,0x8F87,0x8F88,0x8F89,0x8F8A,
0x8F8B,0xB5AF,0xC7BF,0x8F8C,0xE5F6,0x8F8D,0x8F8E,0x8F8F,
0xECB0,0x8F90,0x8F91,0x8F92,0x8F93,0x8F94,0x8F95,0x8F96,
0x8F97,0x8F98,0x8F99,0x8F9A,0x8F9B,0x8F9C,0x8F9D,0x8F9E,
0xE5E6,0x8F9F,0xB9E9,0xB5B1,0x8FA0,0xC2BC,0xE5E8,0xE5E7,
0xE5E9,0x8FA1,0x8FA2,0x8FA3,0x8FA4,0xD2CD,0x8FA5,0x8FA6,
0x8FA7,0xE1EA,0xD0CE,0x8FA8,0xCDAE,0x8FA9,0xD1E5,0x8FAA,
0x8FAB,0xB2CA,0xB1EB,0x8FAC,0xB1F2,0xC5ED,0x8FAD,0x8FAE,
0xD5C3,0xD3B0,0x8FAF,0xE1DC,0x8FB0,0x8FB1,0x8FB2,0xE1DD,
0x8FB3,0xD2DB,0x8FB4,0xB3B9,0xB1CB,0x8FB5,0x8FB6,0x8FB7,
0xCDF9,0xD5F7,0xE1DE,0x8FB8,0xBEB6,0xB4FD,0x8FB9,0xE1DF,
0xBADC,0xE1E0,0xBBB2,0xC2C9,0xE1E1,0x8FBA,0x8FBB,0x8FBC,
0xD0EC,0x8FBD,0xCDBD,0x8FBE,0x8FBF,0xE1E2,0x8FC0,0xB5C3,
0xC5C7,0xE1E3,0x8FC1,0x8FC2,0xE1E4,0x8FC3,0x8FC4,0x8FC5,
0x8FC6,0xD3F9,0x8FC7,0x8FC8,0x8FC9,0x8FCA,0x8FCB,0x8FCC,
0xE1E5,0x8FCD,0xD1AD,0x8FCE,0x8FCF,0xE1E6,0xCEA2,0x8FD0,
0x8FD1,0x8FD2,0x8FD3,0x8FD4,0x8FD5,0xE1E7,0x8FD6,0xB5C2,
0x8FD7,0x8FD8,0x8FD9,0x8FDA,0xE1E8,0xBBD5,0x8FDB,0x8FDC,
0x8FDD,0x8FDE,0x8FDF,0xD0C4,0xE2E0,0xB1D8,0xD2E4,0x8FE0,
0x8FE1,0xE2E1,0x8FE2,0x8FE3,0xBCC9,0xC8CC,0x8FE4,0xE2E3,
0xECFE,0xECFD,0xDFAF,0x8FE5,0x8FE6,0x8FE7,0xE2E2,0xD6BE,
0xCDFC,0xC3A6,0x8FE8,0x8FE9,0x8FEA,0xE3C3,0x8FEB,0x8FEC,
0xD6D2,0xE2E7,0x8FED,0x8FEE,0xE2E8,0x8FEF,0x8FF0,0xD3C7,
0x8FF1,0x8FF2,0xE2EC,0xBFEC,0x8FF3,0xE2ED,0xE2E5,0x8FF4,
0x8FF5,0xB3C0,0x8FF6,0x8FF7,0x8FF8,0xC4EE,0x8FF9,0x8FFA,
0xE2EE,0x8FFB,0x8FFC,0xD0C3,0x8FFD,0xBAF6,0xE2E9,0xB7DE,
0xBBB3,0xCCAC,0xCBCB,0xE2E4,0xE2E6,0xE2EA,0xE2EB,0x8FFE,
0x9040,0x9041,0xE2F7,0x9042,0x9043,0xE2F4,0xD4F5,0xE2F3,
0x9044,0x9045,0xC5AD,0x9046,0xD5FA,0xC5C2,0xB2C0,0x9047,
0x9048,0xE2EF,0x9049,0xE2F2,0xC1AF,0xCBBC,0x904A,0x904B,
0xB5A1,0xE2F9,0x904C,0x904D,0x904E,0xBCB1,0xE2F1,0xD0D4,
0xD4B9,0xE2F5,0xB9D6,0xE2F6,0x904F,0x9050,0x9051,0xC7D3,
0x9052,0x9053,0x9054,0x9055,0x9056,0xE2F0,0x9057,0x9058,
0x9059,0x905A,0x905B,0xD7DC,0xEDA1,0x905C,0x905D,0xE2F8,
0x905E,0xEDA5,0xE2FE,0xCAD1,0x905F,0x9060,0x9061,0x9062,
0x9063,0x9064,0x9065,0xC1B5,0x9066,0xBBD0,0x9067,0x9068,
0xBFD6,0x9069,0xBAE3,0x906A,0x906B,0xCBA1,0x906C,0x906D,
0x906E,0xEDA6,0xEDA3,0x906F,0x9070,0xEDA2,0x9071,0x9072,
0x9073,0x9074,0xBBD6,0xEDA7,0xD0F4,0x9075,0x9076,0xEDA4,
0xBADE,0xB6F7,0xE3A1,0xB6B2,0xCCF1,0xB9A7,0x9077,0xCFA2,
0xC7A1,0x9078,0x9079,0xBFD2,0x907A,0x907B,0xB6F1,0x907C,
0xE2FA,0xE2FB,0xE2FD,0xE2FC,0xC4D5,0xE3A2,0x907D,0xD3C1,
0x907E,0x9080,0x9081,0xE3A7,0xC7C4,0x9082,0x9083,0x9084,
0x9085,0xCFA4,0x9086,0x9087,0xE3A9,0xBAB7,0x9088,0x9089,
0x908A,0x908B,0xE3A8,0x908C,0xBBDA,0x908D,0xE3A3,0x908E,
0x908F,0x9090,0xE3A4,0xE3AA,0x9091,0xE3A6,0x9092,0xCEF2,
0xD3C6,0x9093,0x9094,0xBBBC,0x9095,0x9096,0xD4C3,0x9097,
0xC4FA,0x9098,0x9099,0xEDA8,0xD0FC,0xE3A5,0x909A,0xC3F5,
0x909B,0xE3AD,0xB1AF,0x909C,0xE3B2,0x909D,0x909E,0x909F,
0xBCC2,0x90A0,0x90A1,0xE3AC,0xB5BF,0x90A2,0x90A3,0x90A4,
0x90A5,0x90A6,0x90A7,0x90A8,0x90A9,0xC7E9,0xE3B0,0x90AA,
0x90AB,0x90AC,0xBEAA,0xCDEF,0x90AD,0x90AE,0x90AF,0x90B0,
0x90B1,0xBBF3,0x90B2,0x90B3,0x90B4,0xCCE8,0x90B5,0x90B6,
0xE3AF,0x90B7,0xE3B1,0x90B8,0xCFA7,0xE3AE,0x90B9,0xCEA9,
0xBBDD,0x90BA,0x90BB,0x90BC,0x90BD,0x90BE,0xB5EB,0xBEE5,
0xB2D2,0xB3CD,0x90BF,0xB1B9,0xE3AB,0xB2D1,0xB5AC,0xB9DF,
0xB6E8,0x90C0,0x90C1,0xCFEB,0xE3B7,0x90C2,0xBBCC,0x90C3,
0x90C4,0xC8C7,0xD0CA,0x90C5,0x90C6,0x90C7,0x90C8,0x90C9,
0xE3B8,0xB3EE,0x90CA,0x90CB,0x90CC,0x90CD,0xEDA9,0x90CE,
0xD3FA,0xD3E4,0x90CF,0x90D0,0x90D1,0xEDAA,0xE3B9,0xD2E2,
0x90D2,0x90D3,0x90D4,0x90D5,0x90D6,0xE3B5,0x90D7,0x90D8,
0x90D9,0x90DA,0xD3DE,0x90DB,0x90DC,0x90DD,0x90DE,0xB8D0,
0xE3B3,0x90DF,0x90E0,0xE3B6,0xB7DF,0x90E1,0xE3B4,0xC0A2,
0x90E2,0x90E3,0x90E4,0xE3BA,0x90E5,0x90E6,0x90E7,0x90E8,
0x90E9,0x90EA,0x90EB,0x90EC,0x90ED,0x90EE,0x90EF,0x90F0,
0x90F1,0x90F2,0x90F3,0x90F4,0x90F5,0x90F6,0x90F7,0xD4B8,
0x90F8,0x90F9,0x90FA,0x90FB,0x90FC,0x90FD,0x90FE,0x9140,
0xB4C8,0x9141,0xE3BB,0x9142,0xBBC5,0x9143,0xC9F7,0x9144,
0x9145,0xC9E5,0x9146,0x9147,0x9148,0xC4BD,0x9149,0x914A,
0x914B,0x914C,0x914D,0x914E,0x914F,0xEDAB,0x9150,0x9151,
0x9152,0x9153,0xC2FD,0x9154,0x9155,0x9156,0x9157,0xBBDB,
0xBFAE,0x9158,0x9159,0x915A,0x915B,0x915C,0x915D,0x915E,
0xCEBF,0x915F,0x9160,0x9161,0x9162,0xE3BC,0x9163,0xBFB6,
0x9164,0x9165,0x9166,0x9167,0x9168,0x9169,0x916A,0x916B,
0x916C,0x916D,0x916E,0x916F,0x9170,0x9171,0x9172,0x9173,
0x9174,0x9175,0x9176,0xB1EF,0x9177,0x9178,0xD4F7,0x9179,
0x917A,0x917B,0x917C,0x917D,0xE3BE,0x917E,0x9180,0x9181,
0x9182,0x9183,0x9184,0x9185,0x9186,0xEDAD,0x9187,0x9188,
0x9189,0x918A,0x918B,0x918C,0x918D,0x918E,0x918F,0xE3BF,
0xBAA9,0xEDAC,0x9190,0x9191,0xE3BD,0x9192,0x9193,0x9194,
0x9195,0x9196,0x9197,0x9198,0x9199,0x919A,0x919B,0xE3C0,
0x919C,0x919D,0x919E,0x919F,0x91A0,0x91A1,0xBAB6,0x91A2,
0x91A3,0x91A4,0xB6AE,0x91A5,0x91A6,0x91A7,0x91A8,0x91A9,
0xD0B8,0x91AA,0xB0C3,0xEDAE,0x91AB,0x91AC,0x91AD,0x91AE,
0x91AF,0xEDAF,0xC0C1,0x91B0,0xE3C1,0x91B1,0x91B2,0x91B3,
0x91B4,0x91B5,0x91B6,0x91B7,0x91B8,0x91B9,0x91BA,0x91BB,
0x91BC,0x91BD,0x91BE,0x91BF,0x91C0,0x91C1,0xC5B3,0x91C2,
0x91C3,0x91C4,0x91C5,0x91C6,0x91C7,0x91C8,0x91C9,0x91CA,
0x91CB,0x91CC,0x91CD,0x91CE,0x91CF,0xE3C2,0x91D0,0x91D1,
0x91D2,0x91D3,0x91D4,0x91D5,0x91D6,0x91D7,0x91D8,0xDCB2,
0x91D9,0x91DA,0x91DB,0x91DC,0x91DD,0x91DE,0xEDB0,0x91DF,
0xB8EA,0x91E0,0xCEEC,0xEAA7,0xD0E7,0xCAF9,0xC8D6,0xCFB7,
0xB3C9,0xCED2,0xBDE4,0x91E1,0x91E2,0xE3DE,0xBBF2,0xEAA8,
0xD5BD,0x91E3,0xC6DD,0xEAA9,0x91E4,0x91E5,0x91E6,0xEAAA,
0x91E7,0xEAAC,0xEAAB,0x91E8,0xEAAE,0xEAAD,0x91E9,0x91EA,
0x91EB,0x91EC,0xBDD8,0x91ED,0xEAAF,0x91EE,0xC2BE,0x91EF,
0x91F0,0x91F1,0x91F2,0xB4C1,0xB4F7,0x91F3,0x91F4,0xBBA7,
0x91F5,0x91F6,0x91F7,0x91F8,0x91F9,0xECE6,0xECE5,0xB7BF,
0xCBF9,0xB1E2,0x91FA,0xECE7,0x91FB,0x91FC,0x91FD,0xC9C8,
0xECE8,0xECE9,0x91FE,0xCAD6,0xDED0,0xB2C5,0xD4FA,0x9240,
0x9241,0xC6CB,0xB0C7,0xB4F2,0xC8D3,0x9242,0x9243,0x9244,
0xCDD0,0x9245,0x9246,0xBFB8,0x9247,0x9248,0x9249,0x924A,
0x924B,0x924C,0x924D,0xBFDB,0x924E,0x924F,0xC7A4,0xD6B4,
0x9250,0xC0A9,0xDED1,0xC9A8,0xD1EF,0xC5A4,0xB0E7,0xB3B6,
0xC8C5,0x9251,0x9252,0xB0E2,0x9253,0x9254,0xB7F6,0x9255,
0x9256,0xC5FA,0x9257,0x9258,0xB6F3,0x9259,0xD5D2,0xB3D0,
0xBCBC,0x925A,0x925B,0x925C,0xB3AD,0x925D,0x925E,0x925F,
0x9260,0xBEF1,0xB0D1,0x9261,0x9262,0x9263,0x9264,0x9265,
0x9266,0xD2D6,0xCAE3,0xD7A5,0x9267,0xCDB6,0xB6B6,0xBFB9,
0xD5DB,0x9268,0xB8A7,0xC5D7,0x9269,0x926A,0x926B,0xDED2,
0xBFD9,0xC2D5,0xC7C0,0x926C,0xBBA4,0xB1A8,0x926D,0x926E,
0xC5EA,0x926F,0x9270,0xC5FB,0xCCA7,0x9271,0x9272,0x9273,
0x9274,0xB1A7,0x9275,0x9276,0x9277,0xB5D6,0x9278,0x9279,
0x927A,0xC4A8,0x927B,0xDED3,0xD1BA,0xB3E9,0x927C,0xC3F2,
0x927D,0x927E,0xB7F7,0x9280,0xD6F4,0xB5A3,0xB2F0,0xC4B4,
0xC4E9,0xC0AD,0xDED4,0x9281,0xB0E8,0xC5C4,0xC1E0,0x9282,
0xB9D5,0x9283,0xBEDC,0xCDD8,0xB0CE,0x9284,0xCDCF,0xDED6,
0xBED0,0xD7BE,0xDED5,0xD5D0,0xB0DD,0x9285,0x9286,0xC4E2,
0x9287,0x9288,0xC2A3,0xBCF0,0x9289,0xD3B5,0xC0B9,0xC5A1,
0xB2A6,0xD4F1,0x928A,0x928B,0xC0A8,0xCAC3,0xDED7,0xD5FC,
0x928C,0xB9B0,0x928D,0xC8AD,0xCBA9,0x928E,0xDED9,0xBFBD,
0x928F,0x9290,0x9291,0x9292,0xC6B4,0xD7A7,0xCAB0,0xC4C3,
0x9293,0xB3D6,0xB9D2,0x9294,0x9295,0x9296,0x9297,0xD6B8,
0xEAFC,0xB0B4,0x9298,0x9299,0x929A,0x929B,0xBFE6,0x929C,
0x929D,0xCCF4,0x929E,0x929F,0x92A0,0x92A1,0xCDDA,0x92A2,
0x92A3,0x92A4,0xD6BF,0xC2CE,0x92A5,0xCECE,0xCCA2,0xD0AE,
0xC4D3,0xB5B2,0xDED8,0xD5F5,0xBCB7,0xBBD3,0x92A6,0x92A7,
0xB0A4,0x92A8,0xC5B2,0xB4EC,0x92A9,0x92AA,0x92AB,0xD5F1,
0x92AC,0x92AD,0xEAFD,0x92AE,0x92AF,0x92B0,0x92B1,0x92B2,
0x92B3,0xDEDA,0xCDA6,0x92B4,0x92B5,0xCDEC,0x92B6,0x92B7,
0x92B8,0x92B9,0xCEE6,0xDEDC,0x92BA,0xCDB1,0xC0A6,0x92BB,
0x92BC,0xD7BD,0x92BD,0xDEDB,0xB0C6,0xBAB4,0xC9D3,0xC4F3,
0xBEE8,0x92BE,0x92BF,0x92C0,0x92C1,0xB2B6,0x92C2,0x92C3,
0x92C4,0x92C5,0x92C6,0x92C7,0x92C8,0x92C9,0xC0CC,0xCBF0,
0x92CA,0xBCF1,0xBBBB,0xB5B7,0x92CB,0x92CC,0x92CD,0xC5F5,
0x92CE,0xDEE6,0x92CF,0x92D0,0x92D1,0xDEE3,0xBEDD,0x92D2,
0x92D3,0xDEDF,0x92D4,0x92D5,0x92D6,0x92D7,0xB4B7,0xBDDD,
0x92D8,0x92D9,0xDEE0,0xC4ED,0x92DA,0x92DB,0x92DC,0x92DD,
0xCFC6,0x92DE,0xB5E0,0x92DF,0x92E0,0x92E1,0x92E2,0xB6DE,
0xCADA,0xB5F4,0xDEE5,0x92E3,0xD5C6,0x92E4,0xDEE1,0xCCCD,
0xC6FE,0x92E5,0xC5C5,0x92E6,0x92E7,0x92E8,0xD2B4,0x92E9,
0xBEF2,0x92EA,0x92EB,0x92EC,0x92ED,0x92EE,0x92EF,0x92F0,
0xC2D3,0x92F1,0xCCBD,0xB3B8,0x92F2,0xBDD3,0x92F3,0xBFD8,
0xCDC6,0xD1DA,0xB4EB,0x92F4,0xDEE4,0xDEDD,0xDEE7,0x92F5,
0xEAFE,0x92F6,0x92F7,0xC2B0,0xDEE2,0x92F8,0x92F9,0xD6C0,
0xB5A7,0x92FA,0xB2F4,0x92FB,0xDEE8,0x92FC,0xDEF2,0x92FD,
0x92FE,0x9340,0x9341,0x9342,0xDEED,0x9343,0xDEF1,0x9344,
0x9345,0xC8E0,0x9346,0x9347,0x9348,0xD7E1,0xDEEF,0xC3E8,
0xCCE1,0x9349,0xB2E5,0x934A,0x934B,0x934C,0xD2BE,0x934D,
0x934E,0x934F,0x9350,0x9351,0x9352,0x9353,0xDEEE,0x9354,
0xDEEB,0xCED5,0x9355,0xB4A7,0x9356,0x9357,0x9358,0x9359,
0x935A,0xBFAB,0xBEBE,0x935B,0x935C,0xBDD2,0x935D,0x935E,
0x935F,0x9360,0xDEE9,0x9361,0xD4AE,0x9362,0xDEDE,0x9363,
0xDEEA,0x9364,0x9365,0x9366,0x9367,0xC0BF,0x9368,0xDEEC,
0xB2F3,0xB8E9,0xC2A7,0x9369,0x936A,0xBDC1,0x936B,0x936C,
0x936D,0x936E,0x936F,0xDEF5,0xDEF8,0x9370,0x9371,0xB2AB,
0xB4A4,0x9372,0x9373,0xB4EA,0xC9A6,0x9374,0x9375,0x9376,
0x9377,0x9378,0x9379,0xDEF6,0xCBD1,0x937A,0xB8E3,0x937B,
0xDEF7,0xDEFA,0x937C,0x937D,0x937E,0x9380,0xDEF9,0x9381,
0x9382,0x9383,0xCCC2,0x9384,0xB0E1,0xB4EE,0x9385,0x9386,
0x9387,0x9388,0x9389,0x938A,0xE5BA,0x938B,0x938C,0x938D,
0x938E,0x938F,0xD0AF,0x9390,0x9391,0xB2EB,0x9392,0xEBA1,
0x9393,0xDEF4,0x9394,0x9395,0xC9E3,0xDEF3,0xB0DA,0xD2A1,
0xB1F7,0x9396,0xCCAF,0x9397,0x9398,0x9399,0x939A,0x939B,
0x939C,0x939D,0xDEF0,0x939E,0xCBA4,0x939F,0x93A0,0x93A1,
0xD5AA,0x93A2,0x93A3,0x93A4,0x93A5,0x93A6,0xDEFB,0x93A7,
0x93A8,0x93A9,0x93AA,0x93AB,0x93AC,0x93AD,0x93AE,0xB4DD,
0x93AF,0xC4A6,0x93B0,0x93B1,0x93B2,0xDEFD,0x93B3,0x93B4,
0x93B5,0x93B6,0x93B7,0x93B8,0x93B9,0x93BA,0x93BB,0x93BC,
0xC3FE,0xC4A1,0xDFA1,0x93BD,0x93BE,0x93BF,0x93C0,0x93C1,
0x93C2,0x93C3,0xC1CC,0x93C4,0xDEFC,0xBEEF,0x93C5,0xC6B2,
0x93C6,0x93C7,0x93C8,0x93C9,0x93CA,0x93CB,0x93CC,0x93CD,
0x93CE,0xB3C5,0xC8F6,0x93CF,0x93D0,0xCBBA,0xDEFE,0x93D1,
0x93D2,0xDFA4,0x93D3,0x93D4,0x93D5,0x93D6,0xD7B2,0x93D7,
0x93D8,0x93D9,0x93DA,0x93DB,0xB3B7,0x93DC,0x93DD,0x93DE,
0x93DF,0xC1C3,0x93E0,0x93E1,0xC7CB,0xB2A5,0xB4E9,0x93E2,
0xD7AB,0x93E3,0x93E4,0x93E5,0x93E6,0xC4EC,0x93E7,0xDFA2,
0xDFA3,0x93E8,0xDFA5,0x93E9,0xBAB3,0x93EA,0x93EB,0x93EC,
0xDFA6,0x93ED,0xC0DE,0x93EE,0x93EF,0xC9C3,0x93F0,0x93F1,
0x93F2,0x93F3,0x93F4,0x93F5,0x93F6,0xB2D9,0xC7E6,0x93F7,
0xDFA7,0x93F8,0xC7DC,0x93F9,0x93FA,0x93FB,0x93FC,0xDFA8,
0xEBA2,0x93FD,0x93FE,0x9440,0x9441,0x9442,0xCBD3,0x9443,
0x9444,0x9445,0xDFAA,0x9446,0xDFA9,0x9447,0xB2C1,0x9448,
0x9449,0x944A,0x944B,0x944C,0x944D,0x944E,0x944F,0x9450,
0x9451,0x9452,0x9453,0x9454,0x9455,0x9456,0x9457,0x9458,
0x9459,0x945A,0x945B,0x945C,0x945D,0x945E,0x945F,0x9460,
0xC5CA,0x9461,0x9462,0x9463,0x9464,0x9465,0x9466,0x9467,
0x9468,0xDFAB,0x9469,0x946A,0x946B,0x946C,0x946D,0x946E,
0x946F,0x9470,0xD4DC,0x9471,0x9472,0x9473,0x9474,0x9475,
0xC8C1,0x9476,0x9477,0x9478,0x9479,0x947A,0x947B,0x947C,
0x947D,0x947E,0x9480,0x9481,0x9482,0xDFAC,0x9483,0x9484,
0x9485,0x9486,0x9487,0xBEF0,0x9488,0x9489,0xDFAD,0xD6A7,
0x948A,0x948B,0x948C,0x948D,0xEAB7,0xEBB6,0xCAD5,0x948E,
0xD8FC,0xB8C4,0x948F,0xB9A5,0x9490,0x9491,0xB7C5,0xD5FE,
0x9492,0x9493,0x9494,0x9495,0x9496,0xB9CA,0x9497,0x9498,
0xD0A7,0xF4CD,0x9499,0x949A,0xB5D0,0x949B,0x949C,0xC3F4,
0x949D,0xBEC8,0x949E,0x949F,0x94A0,0xEBB7,0xB0BD,0x94A1,
0x94A2,0xBDCC,0x94A3,0xC1B2,0x94A4,0xB1D6,0xB3A8,0x94A5,
0x94A6,0x94A7,0xB8D2,0xC9A2,0x94A8,0x94A9,0xB6D8,0x94AA,
0x94AB,0x94AC,0x94AD,0xEBB8,0xBEB4,0x94AE,0x94AF,0x94B0,
0xCAFD,0x94B1,0xC7C3,0x94B2,0xD5FB,0x94B3,0x94B4,0xB7F3,
0x94B5,0x94B6,0x94B7,0x94B8,0x94B9,0x94BA,0x94BB,0x94BC,
0x94BD,0x94BE,0x94BF,0x94C0,0x94C1,0x94C2,0x94C3,0xCEC4,
0x94C4,0x94C5,0x94C6,0xD5AB,0xB1F3,0x94C7,0x94C8,0x94C9,
0xECB3,0xB0DF,0x94CA,0xECB5,0x94CB,0x94CC,0x94CD,0xB6B7,
0x94CE,0xC1CF,0x94CF,0xF5FA,0xD0B1,0x94D0,0x94D1,0xD5E5,
0x94D2,0xCED3,0x94D3,0x94D4,0xBDEF,0xB3E2,0x94D5,0xB8AB,
0x94D6,0xD5B6,0x94D7,0xEDBD,0x94D8,0xB6CF,0x94D9,0xCBB9,
0xD0C2,0x94DA,0x94DB,0x94DC,0x94DD,0x94DE,0x94DF,0x94E0,
0x94E1,0xB7BD,0x94E2,0x94E3,0xECB6,0xCAA9,0x94E4,0x94E5,
0x94E6,0xC5D4,0x94E7,0xECB9,0xECB8,0xC2C3,0xECB7,0x94E8,
0x94E9,0x94EA,0x94EB,0xD0FD,0xECBA,0x94EC,0xECBB,0xD7E5,
0x94ED,0x94EE,0xECBC,0x94EF,0x94F0,0x94F1,0xECBD,0xC6EC,
0x94F2,0x94F3,0x94F4,0x94F5,0x94F6,0x94F7,0x94F8,0x94F9,
0xCEDE,0x94FA,0xBCC8,0x94FB,0x94FC,0xC8D5,0xB5A9,0xBEC9,
0xD6BC,0xD4E7,0x94FD,0x94FE,0xD1AE,0xD0F1,0xEAB8,0xEAB9,
0xEABA,0xBAB5,0x9540,0x9541,0x9542,0x9543,0xCAB1,0xBFF5,
0x9544,0x9545,0xCDFA,0x9546,0x9547,0x9548,0x9549,0x954A,
0xEAC0,0x954B,0xB0BA,0xEABE,0x954C,0x954D,0xC0A5,0x954E,
0x954F,0x9550,0xEABB,0x9551,0xB2FD,0x9552,0xC3F7,0xBBE8,
0x9553,0x9554,0x9555,0xD2D7,0xCEF4,0xEABF,0x9556,0x9557,
0x9558,0xEABC,0x9559,0x955A,0x955B,0xEAC3,0x955C,0xD0C7,
0xD3B3,0x955D,0x955E,0x955F,0x9560,0xB4BA,0x9561,0xC3C1,
0xD7F2,0x9562,0x9563,0x9564,0x9565,0xD5D1,0x9566,0xCAC7,
0x9567,0xEAC5,0x9568,0x9569,0xEAC4,0xEAC7,0xEAC6,0x956A,
0x956B,0x956C,0x956D,0x956E,0xD6E7,0x956F,0xCFD4,0x9570,
0x9571,0xEACB,0x9572,0xBBCE,0x9573,0x9574,0x9575,0x9576,
0x9577,0x9578,0x9579,0xBDFA,0xC9CE,0x957A,0x957B,0xEACC,
0x957C,0x957D,0xC9B9,0xCFFE,0xEACA,0xD4CE,0xEACD,0xEACF,
0x957E,0x9580,0xCDED,0x9581,0x9582,0x9583,0x9584,0xEAC9,
0x9585,0xEACE,0x9586,0x9587,0xCEEE,0x9588,0xBBDE,0x9589,
0xB3BF,0x958A,0x958B,0x958C,0x958D,0x958E,0xC6D5,0xBEB0,
0xCEFA,0x958F,0x9590,0x9591,0xC7E7,0x9592,0xBEA7,0xEAD0,
0x9593,0x9594,0xD6C7,0x9595,0x9596,0x9597,0xC1C0,0x9598,
0x9599,0x959A,0xD4DD,0x959B,0xEAD1,0x959C,0x959D,0xCFBE,
0x959E,0x959F,0x95A0,0x95A1,0xEAD2,0x95A2,0x95A3,0x95A4,
0x95A5,0xCAEE,0x95A6,0x95A7,0x95A8,0x95A9,0xC5AF,0xB0B5,
0x95AA,0x95AB,0x95AC,0x95AD,0x95AE,0xEAD4,0x95AF,0x95B0,
0x95B1,0x95B2,0x95B3,0x95B4,0x95B5,0x95B6,0x95B7,0xEAD3,
0xF4DF,0x95B8,0x95B9,0x95BA,0x95BB,0x95BC,0xC4BA,0x95BD,
0x95BE,0x95BF,0x95C0,0x95C1,0xB1A9,0x95C2,0x95C3,0x95C4,
0x95C5,0xE5DF,0x95C6,0x95C7,0x95C8,0x95C9,0xEAD5,0x95CA,
0x95CB,0x95CC,0x95CD,0x95CE,0x95CF,0x95D0,0x95D1,0x95D2,
0x95D3,0x95D4,0x95D5,0x95D6,0x95D7,0x95D8,0x95D9,0x95DA,
0x95DB,0x95DC,0x95DD,0x95DE,0x95DF,0x95E0,0x95E1,0x95E2,
0x95E3,0xCAEF,0x95E4,0xEAD6,0xEAD7,0xC6D8,0x95E5,0x95E6,
0x95E7,0x95E8,0x95E9,0x95EA,0x95EB,0x95EC,0xEAD8,0x95ED,
0x95EE,0xEAD9,0x95EF,0x95F0,0x95F1,0x95F2,0x95F3,0x95F4,
0xD4BB,0x95F5,0xC7FA,0xD2B7,0xB8FC,0x95F6,0x95F7,0xEAC2,
0x95F8,0xB2DC,0x95F9,0x95FA,0xC2FC,0x95FB,0xD4F8,0xCCE6,
0xD7EE,0x95FC,0x95FD,0x95FE,0x9640,0x9641,0x9642,0x9643,
0xD4C2,0xD3D0,0xEBC3,0xC5F3,0x9644,0xB7FE,0x9645,0x9646,
0xEBD4,0x9647,0x9648,0x9649,0xCBB7,0xEBDE,0x964A,0xC0CA,
0x964B,0x964C,0x964D,0xCDFB,0x964E,0xB3AF,0x964F,0xC6DA,
0x9650,0x9651,0x9652,0x9653,0x9654,0x9655,0xEBFC,0x9656,
0xC4BE,0x9657,0xCEB4,0xC4A9,0xB1BE,0xD4FD,0x9658,0xCAF5,
0x9659,0xD6EC,0x965A,0x965B,0xC6D3,0xB6E4,0x965C,0x965D,
0x965E,0x965F,0xBBFA,0x9660,0x9661,0xD0E0,0x9662,0x9663,
0xC9B1,0x9664,0xD4D3,0xC8A8,0x9665,0x9666,0xB8CB,0x9667,
0xE8BE,0xC9BC,0x9668,0x9669,0xE8BB,0x966A,0xC0EE,0xD0D3,
0xB2C4,0xB4E5,0x966B,0xE8BC,0x966C,0x966D,0xD5C8,0x966E,
0x966F,0x9670,0x9671,0x9672,0xB6C5,0x9673,0xE8BD,0xCAF8,
0xB8DC,0xCCF5,0x9674,0x9675,0x9676,0xC0B4,0x9677,0x9678,
0xD1EE,0xE8BF,0xE8C2,0x9679,0x967A,0xBABC,0x967B,0xB1AD,
0xBDDC,0x967C,0xEABD,0xE8C3,0x967D,0xE8C6,0x967E,0xE8CB,
0x9680,0x9681,0x9682,0x9683,0xE8CC,0x9684,0xCBC9,0xB0E5,
0x9685,0xBCAB,0x9686,0x9687,0xB9B9,0x9688,0x9689,0xE8C1,
0x968A,0xCDF7,0x968B,0xE8CA,0x968C,0x968D,0x968E,0x968F,
0xCEF6,0x9690,0x9691,0x9692,0x9693,0xD5ED,0x9694,0xC1D6,
0xE8C4,0x9695,0xC3B6,0x9696,0xB9FB,0xD6A6,0xE8C8,0x9697,
0x9698,0x9699,0xCAE0,0xD4E6,0x969A,0xE8C0,0x969B,0xE8C5,
0xE8C7,0x969C,0xC7B9,0xB7E3,0x969D,0xE8C9,0x969E,0xBFDD,
0xE8D2,0x969F,0x96A0,0xE8D7,0x96A1,0xE8D5,0xBCDC,0xBCCF,
0xE8DB,0x96A2,0x96A3,0x96A4,0x96A5,0x96A6,0x96A7,0x96A8,
0x96A9,0xE8DE,0x96AA,0xE8DA,0xB1FA,0x96AB,0x96AC,0x96AD,
0x96AE,0x96AF,0x96B0,0x96B1,0x96B2,0x96B3,0x96B4,0xB0D8,
0xC4B3,0xB8CC,0xC6E2,0xC8BE,0xC8E1,0x96B5,0x96B6,0x96B7,
0xE8CF,0xE8D4,0xE8D6,0x96B8,0xB9F1,0xE8D8,0xD7F5,0x96B9,
0xC4FB,0x96BA,0xE8DC,0x96BB,0x96BC,0xB2E9,0x96BD,0x96BE,
0x96BF,0xE8D1,0x96C0,0x96C1,0xBCED,0x96C2,0x96C3,0xBFC2,
0xE8CD,0xD6F9,0x96C4,0xC1F8,0xB2F1,0x96C5,0x96C6,0x96C7,
0x96C8,0x96C9,0x96CA,0x96CB,0x96CC,0xE8DF,0x96CD,0xCAC1,
0xE8D9,0x96CE,0x96CF,0x96D0,0x96D1,0xD5A4,0x96D2,0xB1EA,
0xD5BB,0xE8CE,0xE8D0,0xB6B0,0xE8D3,0x96D3,0xE8DD,0xC0B8,
0x96D4,0xCAF7,0x96D5,0xCBA8,0x96D6,0x96D7,0xC6DC,0xC0F5,
0x96D8,0x96D9,0x96DA,0x96DB,0x96DC,0xE8E9,0x96DD,0x96DE,
0x96DF,0xD0A3,0x96E0,0x96E1,0x96E2,0x96E3,0x96E4,0x96E5,
0x96E6,0xE8F2,0xD6EA,0x96E7,0x96E8,0x96E9,0x96EA,0x96EB,
0x96EC,0x96ED,0xE8E0,0xE8E1,0x96EE,0x96EF,0x96F0,0xD1F9,
0xBACB,0xB8F9,0x96F1,0x96F2,0xB8F1,0xD4D4,0xE8EF,0x96F3,
0xE8EE,0xE8EC,0xB9F0,0xCCD2,0xE8E6,0xCEA6,0xBFF2,0x96F4,
0xB0B8,0xE8F1,0xE8F0,0x96F5,0xD7C0,0x96F6,0xE8E4,0x96F7,
0xCDA9,0xC9A3,0x96F8,0xBBB8,0xBDDB,0xE8EA,0x96F9,0x96FA,
0x96FB,0x96FC,0x96FD,0x96FE,0x9740,0x9741,0x9742,0x9743,
0xE8E2,0xE8E3,0xE8E5,0xB5B5,0xE8E7,0xC7C5,0xE8EB,0xE8ED,
0xBDB0,0xD7AE,0x9744,0xE8F8,0x9745,0x9746,0x9747,0x9748,
0x9749,0x974A,0x974B,0x974C,0xE8F5,0x974D,0xCDB0,0xE8F6,
0x974E,0x974F,0x9750,0x9751,0x9752,0x9753,0x9754,0x9755,
0x9756,0xC1BA,0x9757,0xE8E8,0x9758,0xC3B7,0xB0F0,0x9759,
0x975A,0x975B,0x975C,0x975D,0x975E,0x975F,0x9760,0xE8F4,
0x9761,0x9762,0x9763,0xE8F7,0x9764,0x9765,0x9766,0xB9A3,
0x9767,0x9768,0x9769,0x976A,0x976B,0x976C,0x976D,0x976E,
0x976F,0x9770,0xC9D2,0x9771,0x9772,0x9773,0xC3CE,0xCEE0,
0xC0E6,0x9774,0x9775,0x9776,0x9777,0xCBF3,0x9778,0xCCDD,
0xD0B5,0x9779,0x977A,0xCAE1,0x977B,0xE8F3,0x977C,0x977D,
0x977E,0x9780,0x9781,0x9782,0x9783,0x9784,0x9785,0x9786,
0xBCEC,0x9787,0xE8F9,0x9788,0x9789,0x978A,0x978B,0x978C,
0x978D,0xC3DE,0x978E,0xC6E5,0x978F,0xB9F7,0x9790,0x9791,
0x9792,0x9793,0xB0F4,0x9794,0x9795,0xD7D8,0x9796,0x9797,
0xBCAC,0x9798,0xC5EF,0x9799,0x979A,0x979B,0x979C,0x979D,
0xCCC4,0x979E,0x979F,0xE9A6,0x97A0,0x97A1,0x97A2,0x97A3,
0x97A4,0x97A5,0x97A6,0x97A7,0x97A8,0x97A9,0xC9AD,0x97AA,
0xE9A2,0xC0E2,0x97AB,0x97AC,0x97AD,0xBFC3,0x97AE,0x97AF,
0x97B0,0xE8FE,0xB9D7,0x97B1,0xE8FB,0x97B2,0x97B3,0x97B4,
0x97B5,0xE9A4,0x97B6,0x97B7,0x97B8,0xD2CE,0x97B9,0x97BA,
0x97BB,0x97BC,0x97BD,0xE9A3,0x97BE,0xD6B2,0xD7B5,0x97BF,
0xE9A7,0x97C0,0xBDB7,0x97C1,0x97C2,0x97C3,0x97C4,0x97C5,
0x97C6,0x97C7,0x97C8,0x97C9,0x97CA,0x97CB,0x97CC,0xE8FC,
0xE8FD,0x97CD,0x97CE,0x97CF,0xE9A1,0x97D0,0x97D1,0x97D2,
0x97D3,0x97D4,0x97D5,0x97D6,0x97D7,0xCDD6,0x97D8,0x97D9,
0xD2AC,0x97DA,0x97DB,0x97DC,0xE9B2,0x97DD,0x97DE,0x97DF,
0x97E0,0xE9A9,0x97E1,0x97E2,0x97E3,0xB4AA,0x97E4,0xB4BB,
0x97E5,0x97E6,0xE9AB,0x97E7,0x97E8,0x97E9,0x97EA,0x97EB,
0x97EC,0x97ED,0x97EE,0x97EF,0x97F0,0x97F1,0x97F2,0x97F3,
0x97F4,0x97F5,0x97F6,0x97F7,0xD0A8,0x97F8,0x97F9,0xE9A5,
0x97FA,0x97FB,0xB3FE,0x97FC,0x97FD,0xE9AC,0xC0E3,0x97FE,
0xE9AA,0x9840,0x9841,0xE9B9,0x9842,0x9843,0xE9B8,0x9844,
0x9845,0x9846,0x9847,0xE9AE,0x9848,0x9849,0xE8FA,0x984A,
0x984B,0xE9A8,0x984C,0x984D,0x984E,0x984F,0x9850,0xBFAC,
0xE9B1,0xE9BA,0x9851,0x9852,0xC2A5,0x9853,0x9854,0x9855,
0xE9AF,0x9856,0xB8C5,0x9857,0xE9AD,0x9858,0xD3DC,0xE9B4,
0xE9B5,0xE9B7,0x9859,0x985A,0x985B,0xE9C7,0x985C,0x985D,
0x985E,0x985F,0x9860,0x9861,0xC0C6,0xE9C5,0x9862,0x9863,
0xE9B0,0x9864,0x9865,0xE9BB,0xB0F1,0x9866,0x9867,0x9868,
0x9869,0x986A,0x986B,0x986C,0x986D,0x986E,0x986F,0xE9BC,
0xD5A5,0x9870,0x9871,0xE9BE,0x9872,0xE9BF,0x9873,0x9874,
0x9875,0xE9C1,0x9876,0x9877,0xC1F1,0x9878,0x9879,0xC8B6,
0x987A,0x987B,0x987C,0xE9BD,0x987D,0x987E,0x9880,0x9881,
0x9882,0xE9C2,0x9883,0x9884,0x9885,0x9886,0x9887,0x9888,
0x9889,0x988A,0xE9C3,0x988B,0xE9B3,0x988C,0xE9B6,0x988D,
0xBBB1,0x988E,0x988F,0x9890,0xE9C0,0x9891,0x9892,0x9893,
0x9894,0x9895,0x9896,0xBCF7,0x9897,0x9898,0x9899,0xE9C4,
0xE9C6,0x989A,0x989B,0x989C,0x989D,0x989E,0x989F,0x98A0,
0x98A1,0x98A2,0x98A3,0x98A4,0x98A5,0xE9CA,0x98A6,0x98A7,
0x98A8,0x98A9,0xE9CE,0x98AA,0x98AB,0x98AC,0x98AD,0x98AE,
0x98AF,0x98B0,0x98B1,0x98B2,0x98B3,0xB2DB,0x98B4,0xE9C8,
0x98B5,0x98B6,0x98B7,0x98B8,0x98B9,0x98BA,0x98BB,0x98BC,
0x98BD,0x98BE,0xB7AE,0x98BF,0x98C0,0x98C1,0x98C2,0x98C3,
0x98C4,0x98C5,0x98C6,0x98C7,0x98C8,0x98C9,0x98CA,0xE9CB,
0xE9CC,0x98CB,0x98CC,0x98CD,0x98CE,0x98CF,0x98D0,0xD5C1,
0x98D1,0xC4A3,0x98D2,0x98D3,0x98D4,0x98D5,0x98D6,0x98D7,
0xE9D8,0x98D8,0xBAE1,0x98D9,0x98DA,0x98DB,0x98DC,0xE9C9,
0x98DD,0xD3A3,0x98DE,0x98DF,0x98E0,0xE9D4,0x98E1,0x98E2,
0x98E3,0x98E4,0x98E5,0x98E6,0x98E7,0xE9D7,0xE9D0,0x98E8,
0x98E9,0x98EA,0x98EB,0x98EC,0xE9CF,0x98ED,0x98EE,0xC7C1,
0x98EF,0x98F0,0x98F1,0x98F2,0x98F3,0x98F4,0x98F5,0x98F6,
0xE9D2,0x98F7,0x98F8,0x98F9,0x98FA,0x98FB,0x98FC,0x98FD,
0xE9D9,0xB3C8,0x98FE,0xE9D3,0x9940,0x9941,0x9942,0x9943,
0x9944,0xCFF0,0x9945,0x9946,0x9947,0xE9CD,0x9948,0x9949,
0x994A,0x994B,0x994C,0x994D,0x994E,0x994F,0x9950,0x9951,
0x9952,0xB3F7,0x9953,0x9954,0x9955,0x9956,0x9957,0x9958,
0x9959,0xE9D6,0x995A,0x995B,0xE9DA,0x995C,0x995D,0x995E,
0xCCB4,0x995F,0x9960,0x9961,0xCFAD,0x9962,0x9963,0x9964,
0x9965,0x9966,0x9967,0x9968,0x9969,0x996A,0xE9D5,0x996B,
0xE9DC,0xE9DB,0x996C,0x996D,0x996E,0x996F,0x9970,0xE9DE,
0x9971,0x9972,0x9973,0x9974,0x9975,0x9976,0x9977,0x9978,
0xE9D1,0x9979,0x997A,0x997B,0x997C,0x997D,0x997E,0x9980,
0x9981,0xE9DD,0x9982,0xE9DF,0xC3CA,0x9983,0x9984,0x9985,
0x9986,0x9987,0x9988,0x9989,0x998A,0x998B,0x998C,0x998D,
0x998E,0x998F,0x9990,0x9991,0x9992,0x9993,0x9994,0x9995,
0x9996,0x9997,0x9998,0x9999,0x999A,0x999B,0x999C,0x999D,
0x999E,0x999F,0x99A0,0x99A1,0x99A2,0x99A3,0x99A4,0x99A5,
0x99A6,0x99A7,0x99A8,0x99A9,0x99AA,0x99AB,0x99AC,0x99AD,
0x99AE,0x99AF,0x99B0,0x99B1,0x99B2,0x99B3,0x99B4,0x99B5,
0x99B6,0x99B7,0x99B8,0x99B9,0x99BA,0x99BB,0x99BC,0x99BD,
0x99BE,0x99BF,0x99C0,0x99C1,0x99C2,0x99C3,0x99C4,0x99C5,
0x99C6,0x99C7,0x99C8,0x99C9,0x99CA,0x99CB,0x99CC,0x99CD,
0x99CE,0x99CF,0x99D0,0x99D1,0x99D2,0x99D3,0x99D4,0x99D5,
0x99D6,0x99D7,0x99D8,0x99D9,0x99DA,0x99DB,0x99DC,0x99DD,
0x99DE,0x99DF,0x99E0,0x99E1,0x99E2,0x99E3,0x99E4,0x99E5,
0x99E6,0x99E7,0x99E8,0x99E9,0x99EA,0x99EB,0x99EC,0x99ED,
0x99EE,0x99EF,0x99F0,0x99F1,0x99F2,0x99F3,0x99F4,0x99F5,
0xC7B7,0xB4CE,0xBBB6,0xD0C0,0xECA3,0x99F6,0x99F7,0xC5B7,
0x99F8,0x99F9,0x99FA,0x99FB,0x99FC,0x99FD,0x99FE,0x9A40,
0x9A41,0x9A42,0xD3FB,0x9A43,0x9A44,0x9A45,0x9A46,0xECA4,
0x9A47,0xECA5,0xC6DB,0x9A48,0x9A49,0x9A4A,0xBFEE,0x9A4B,
0x9A4C,0x9A4D,0x9A4E,0xECA6,0x9A4F,0x9A50,0xECA7,0xD0AA,
0x9A51,0xC7B8,0x9A52,0x9A53,0xB8E8,0x9A54,0x9A55,0x9A56,
0x9A57,0x9A58,0x9A59,0x9A5A,0x9A5B,0x9A5C,0x9A5D,0x9A5E,
0x9A5F,0xECA8,0x9A60,0x9A61,0x9A62,0x9A63,0x9A64,0x9A65,
0x9A66,0x9A67,0xD6B9,0xD5FD,0xB4CB,0xB2BD,0xCEE4,0xC6E7,
0x9A68,0x9A69,0xCDE1,0x9A6A,0x9A6B,0x9A6C,0x9A6D,0x9A6E,
0x9A6F,0x9A70,0x9A71,0x9A72,0x9A73,0x9A74,0x9A75,0x9A76,
0x9A77,0xB4F5,0x9A78,0xCBC0,0xBCDF,0x9A79,0x9A7A,0x9A7B,
0x9A7C,0xE9E2,0xE9E3,0xD1EA,0xE9E5,0x9A7D,0xB4F9,0xE9E4,
0x9A7E,0xD1B3,0xCAE2,0xB2D0,0x9A80,0xE9E8,0x9A81,0x9A82,
0x9A83,0x9A84,0xE9E6,0xE9E7,0x9A85,0x9A86,0xD6B3,0x9A87,
0x9A88,0x9A89,0xE9E9,0xE9EA,0x9A8A,0x9A8B,0x9A8C,0x9A8D,
0x9A8E,0xE9EB,0x9A8F,0x9A90,0x9A91,0x9A92,0x9A93,0x9A94,
0x9A95,0x9A96,0xE9EC,0x9A97,0x9A98,0x9A99,0x9A9A,0x9A9B,
0x9A9C,0x9A9D,0x9A9E,0xECAF,0xC5B9,0xB6CE,0x9A9F,0xD2F3,
0x9AA0,0x9AA1,0x9AA2,0x9AA3,0x9AA4,0x9AA5,0x9AA6,0xB5EE,
0x9AA7,0xBBD9,0xECB1,0x9AA8,0x9AA9,0xD2E3,0x9AAA,0x9AAB,
0x9AAC,0x9AAD,0x9AAE,0xCEE3,0x9AAF,0xC4B8,0x9AB0,0xC3BF,
0x9AB1,0x9AB2,0xB6BE,0xD8B9,0xB1C8,0xB1CF,0xB1D1,0xC5FE,
0x9AB3,0xB1D0,0x9AB4,0xC3AB,0x9AB5,0x9AB6,0x9AB7,0x9AB8,
0x9AB9,0xD5B1,0x9ABA,0x9ABB,0x9ABC,0x9ABD,0x9ABE,0x9ABF,
0x9AC0,0x9AC1,0xEBA4,0xBAC1,0x9AC2,0x9AC3,0x9AC4,0xCCBA,
0x9AC5,0x9AC6,0x9AC7,0xEBA5,0x9AC8,0xEBA7,0x9AC9,0x9ACA,
0x9ACB,0xEBA8,0x9ACC,0x9ACD,0x9ACE,0xEBA6,0x9ACF,0x9AD0,
0x9AD1,0x9AD2,0x9AD3,0x9AD4,0x9AD5,0xEBA9,0xEBAB,0xEBAA,
0x9AD6,0x9AD7,0x9AD8,0x9AD9,0x9ADA,0xEBAC,0x9ADB,0xCACF,
0xD8B5,0xC3F1,0x9ADC,0xC3A5,0xC6F8,0xEBAD,0xC4CA,0x9ADD,
0xEBAE,0xEBAF,0xEBB0,0xB7D5,0x9ADE,0x9ADF,0x9AE0,0xB7FA,
0x9AE1,0xEBB1,0xC7E2,0x9AE2,0xEBB3,0x9AE3,0xBAA4,0xD1F5,
0xB0B1,0xEBB2,0xEBB4,0x9AE4,0x9AE5,0x9AE6,0xB5AA,0xC2C8,
0xC7E8,0x9AE7,0xEBB5,0x9AE8,0xCBAE,0xE3DF,0x9AE9,0x9AEA,
0xD3C0,0x9AEB,0x9AEC,0x9AED,0x9AEE,0xD9DB,0x9AEF,0x9AF0,
0xCDA1,0xD6AD,0xC7F3,0x9AF1,0x9AF2,0x9AF3,0xD9E0,0xBBE3,
0x9AF4,0xBABA,0xE3E2,0x9AF5,0x9AF6,0x9AF7,0x9AF8,0x9AF9,
0xCFAB,0x9AFA,0x9AFB,0x9AFC,0xE3E0,0xC9C7,0x9AFD,0xBAB9,
0x9AFE,0x9B40,0x9B41,0xD1B4,0xE3E1,0xC8EA,0xB9AF,0xBDAD,
0xB3D8,0xCEDB,0x9B42,0x9B43,0xCCC0,0x9B44,0x9B45,0x9B46,
0xE3E8,0xE3E9,0xCDF4,0x9B47,0x9B48,0x9B49,0x9B4A,0x9B4B,
0xCCAD,0x9B4C,0xBCB3,0x9B4D,0xE3EA,0x9B4E,0xE3EB,0x9B4F,
0x9B50,0xD0DA,0x9B51,0x9B52,0x9B53,0xC6FB,0xB7DA,0x9B54,
0x9B55,0xC7DF,0xD2CA,0xCED6,0x9B56,0xE3E4,0xE3EC,0x9B57,
0xC9F2,0xB3C1,0x9B58,0x9B59,0xE3E7,0x9B5A,0x9B5B,0xC6E3,
0xE3E5,0x9B5C,0x9B5D,0xEDB3,0xE3E6,0x9B5E,0x9B5F,0x9B60,
0x9B61,0xC9B3,0x9B62,0xC5E6,0x9B63,0x9B64,0x9B65,0xB9B5,
0x9B66,0xC3BB,0x9B67,0xE3E3,0xC5BD,0xC1A4,0xC2D9,0xB2D7,
0x9B68,0xE3ED,0xBBA6,0xC4AD,0x9B69,0xE3F0,0xBEDA,0x9B6A,
0x9B6B,0xE3FB,0xE3F5,0xBAD3,0x9B6C,0x9B6D,0x9B6E,0x9B6F,
0xB7D0,0xD3CD,0x9B70,0xD6CE,0xD5D3,0xB9C1,0xD5B4,0xD1D8,
0x9B71,0x9B72,0x9B73,0x9B74,0xD0B9,0xC7F6,0x9B75,0x9B76,
0x9B77,0xC8AA,0xB2B4,0x9B78,0xC3DA,0x9B79,0x9B7A,0x9B7B,
0xE3EE,0x9B7C,0x9B7D,0xE3FC,0xE3EF,0xB7A8,0xE3F7,0xE3F4,
0x9B7E,0x9B80,0x9B81,0xB7BA,0x9B82,0x9B83,0xC5A2,0x9B84,
0xE3F6,0xC5DD,0xB2A8,0xC6FC,0x9B85,0xC4E0,0x9B86,0x9B87,
0xD7A2,0x9B88,0xC0E1,0xE3F9,0x9B89,0x9B8A,0xE3FA,0xE3FD,
0xCCA9,0xE3F3,0x9B8B,0xD3BE,0x9B8C,0xB1C3,0xEDB4,0xE3F1,
0xE3F2,0x9B8D,0xE3F8,0xD0BA,0xC6C3,0xD4F3,0xE3FE,0x9B8E,
0x9B8F,0xBDE0,0x9B90,0x9B91,0xE4A7,0x9B92,0x9B93,0xE4A6,
0x9B94,0x9B95,0x9B96,0xD1F3,0xE4A3,0x9B97,0xE4A9,0x9B98,
0x9B99,0x9B9A,0xC8F7,0x9B9B,0x9B9C,0x9B9D,0x9B9E,0xCFB4,
0x9B9F,0xE4A8,0xE4AE,0xC2E5,0x9BA0,0x9BA1,0xB6B4,0x9BA2,
0x9BA3,0x9BA4,0x9BA5,0x9BA6,0x9BA7,0xBDF2,0x9BA8,0xE4A2,
0x9BA9,0x9BAA,0xBAE9,0xE4AA,0x9BAB,0x9BAC,0xE4AC,0x9BAD,
0x9BAE,0xB6FD,0xD6DE,0xE4B2,0x9BAF,0xE4AD,0x9BB0,0x9BB1,
0x9BB2,0xE4A1,0x9BB3,0xBBEE,0xCDDD,0xC7A2,0xC5C9,0x9BB4,
0x9BB5,0xC1F7,0x9BB6,0xE4A4,0x9BB7,0xC7B3,0xBDAC,0xBDBD,
0xE4A5,0x9BB8,0xD7C7,0xB2E2,0x9BB9,0xE4AB,0xBCC3,0xE4AF,
0x9BBA,0xBBEB,0xE4B0,0xC5A8,0xE4B1,0x9BBB,0x9BBC,0x9BBD,
0x9BBE,0xD5E3,0xBFA3,0x9BBF,0xE4BA,0x9BC0,0xE4B7,0x9BC1,
0xE4BB,0x9BC2,0x9BC3,0xE4BD,0x9BC4,0x9BC5,0xC6D6,0x9BC6,
0x9BC7,0xBAC6,0xC0CB,0x9BC8,0x9BC9,0x9BCA,0xB8A1,0xE4B4,
0x9BCB,0x9BCC,0x9BCD,0x9BCE,0xD4A1,0x9BCF,0x9BD0,0xBAA3,
0xBDFE,0x9BD1,0x9BD2,0x9BD3,0xE4BC,0x9BD4,0x9BD5,0x9BD6,
0x9BD7,0x9BD8,0xCDBF,0x9BD9,0x9BDA,0xC4F9,0x9BDB,0x9BDC,
0xCFFB,0xC9E6,0x9BDD,0x9BDE,0xD3BF,0x9BDF,0xCFD1,0x9BE0,
0x9BE1,0xE4B3,0x9BE2,0xE4B8,0xE4B9,0xCCE9,0x9BE3,0x9BE4,
0x9BE5,0x9BE6,0x9BE7,0xCCCE,0x9BE8,0xC0D4,0xE4B5,0xC1B0,
0xE4B6,0xCED0,0x9BE9,0xBBC1,0xB5D3,0x9BEA,0xC8F3,0xBDA7,
0xD5C7,0xC9AC,0xB8A2,0xE4CA,0x9BEB,0x9BEC,0xE4CC,0xD1C4,
0x9BED,0x9BEE,0xD2BA,0x9BEF,0x9BF0,0xBAAD,0x9BF1,0x9BF2,
0xBAD4,0x9BF3,0x9BF4,0x9BF5,0x9BF6,0x9BF7,0x9BF8,0xE4C3,
0xB5ED,0x9BF9,0x9BFA,0x9BFB,0xD7CD,0xE4C0,0xCFFD,0xE4BF,
0x9BFC,0x9BFD,0x9BFE,0xC1DC,0xCCCA,0x9C40,0x9C41,0x9C42,
0x9C43,0xCAE7,0x9C44,0x9C45,0x9C46,0x9C47,0xC4D7,0x9C48,
0xCCD4,0xE4C8,0x9C49,0x9C4A,0x9C4B,0xE4C7,0xE4C1,0x9C4C,
0xE4C4,0xB5AD,0x9C4D,0x9C4E,0xD3D9,0x9C4F,0xE4C6,0x9C50,
0x9C51,0x9C52,0x9C53,0xD2F9,0xB4E3,0x9C54,0xBBB4,0x9C55,
0x9C56,0xC9EE,0x9C57,0xB4BE,0x9C58,0x9C59,0x9C5A,0xBBEC,
0x9C5B,0xD1CD,0x9C5C,0xCCED,0xEDB5,0x9C5D,0x9C5E,0x9C5F,
0x9C60,0x9C61,0x9C62,0x9C63,0x9C64,0xC7E5,0x9C65,0x9C66,
0x9C67,0x9C68,0xD4A8,0x9C69,0xE4CB,0xD7D5,0xE4C2,0x9C6A,
0xBDA5,0xE4C5,0x9C6B,0x9C6C,0xD3E6,0x9C6D,0xE4C9,0xC9F8,
0x9C6E,0x9C6F,0xE4BE,0x9C70,0x9C71,0xD3E5,0x9C72,0x9C73,
0xC7FE,0xB6C9,0x9C74,0xD4FC,0xB2B3,0xE4D7,0x9C75,0x9C76,
0x9C77,0xCEC2,0x9C78,0xE4CD,0x9C79,0xCEBC,0x9C7A,0xB8DB,
0x9C7B,0x9C7C,0xE4D6,0x9C7D,0xBFCA,0x9C7E,0x9C80,0x9C81,
0xD3CE,0x9C82,0xC3EC,0x9C83,0x9C84,0x9C85,0x9C86,0x9C87,
0x9C88,0x9C89,0x9C8A,0xC5C8,0xE4D8,0x9C8B,0x9C8C,0x9C8D,
0x9C8E,0x9C8F,0x9C90,0x9C91,0x9C92,0xCDC4,0xE4CF,0x9C93,
0x9C94,0x9C95,0x9C96,0xE4D4,0xE4D5,0x9C97,0xBAFE,0x9C98,
0xCFE6,0x9C99,0x9C9A,0xD5BF,0x9C9B,0x9C9C,0x9C9D,0xE4D2,
0x9C9E,0x9C9F,0x9CA0,0x9CA1,0x9CA2,0x9CA3,0x9CA4,0x9CA5,
0x9CA6,0x9CA7,0x9CA8,0xE4D0,0x9CA9,0x9CAA,0xE4CE,0x9CAB,
0x9CAC,0x9CAD,0x9CAE,0x9CAF,0x9CB0,0x9CB1,0x9CB2,0x9CB3,
0x9CB4,0x9CB5,0x9CB6,0x9CB7,0x9CB8,0x9CB9,0xCDE5,0xCAAA,
0x9CBA,0x9CBB,0x9CBC,0xC0A3,0x9CBD,0xBDA6,0xE4D3,0x9CBE,
0x9CBF,0xB8C8,0x9CC0,0x9CC1,0x9CC2,0x9CC3,0x9CC4,0xE4E7,
0xD4B4,0x9CC5,0x9CC6,0x9CC7,0x9CC8,0x9CC9,0x9CCA,0x9CCB,
0xE4DB,0x9CCC,0x9CCD,0x9CCE,0xC1EF,0x9CCF,0x9CD0,0xE4E9,
0x9CD1,0x9CD2,0xD2E7,0x9CD3,0x9CD4,0xE4DF,0x9CD5,0xE4E0,
0x9CD6,0x9CD7,0xCFAA,0x9CD8,0x9CD9,0x9CDA,0x9CDB,0xCBDD,
0x9CDC,0xE4DA,0xE4D1,0x9CDD,0xE4E5,0x9CDE,0xC8DC,0xE4E3,
0x9CDF,0x9CE0,0xC4E7,0xE4E2,0x9CE1,0xE4E1,0x9CE2,0x9CE3,
0x9CE4,0xB3FC,0xE4E8,0x9CE5,0x9CE6,0x9CE7,0x9CE8,0xB5E1,
0x9CE9,0x9CEA,0x9CEB,0xD7CC,0x9CEC,0x9CED,0x9CEE,0xE4E6,
0x9CEF,0xBBAC,0x9CF0,0xD7D2,0xCCCF,0xEBF8,0x9CF1,0xE4E4,
0x9CF2,0x9CF3,0xB9F6,0x9CF4,0x9CF5,0x9CF6,0xD6CD,0xE4D9,
0xE4DC,0xC2FA,0xE4DE,0x9CF7,0xC2CB,0xC0C4,0xC2D0,0x9CF8,
0xB1F5,0xCCB2,0x9CF9,0x9CFA,0x9CFB,0x9CFC,0x9CFD,0x9CFE,
0x9D40,0x9D41,0x9D42,0x9D43,0xB5CE,0x9D44,0x9D45,0x9D46,
0x9D47,0xE4EF,0x9D48,0x9D49,0x9D4A,0x9D4B,0x9D4C,0x9D4D,
0x9D4E,0x9D4F,0xC6AF,0x9D50,0x9D51,0x9D52,0xC6E1,0x9D53,
0x9D54,0xE4F5,0x9D55,0x9D56,0x9D57,0x9D58,0x9D59,0xC2A9,
0x9D5A,0x9D5B,0x9D5C,0xC0EC,0xD1DD,0xE4EE,0x9D5D,0x9D5E,
0x9D5F,0x9D60,0x9D61,0x9D62,0x9D63,0x9D64,0x9D65,0x9D66,
0xC4AE,0x9D67,0x9D68,0x9D69,0xE4ED,0x9D6A,0x9D6B,0x9D6C,
0x9D6D,0xE4F6,0xE4F4,0xC2FE,0x9D6E,0xE4DD,0x9D6F,0xE4F0,
0x9D70,0xCAFE,0x9D71,0xD5C4,0x9D72,0x9D73,0xE4F1,0x9D74,
0x9D75,0x9D76,0x9D77,0x9D78,0x9D79,0x9D7A,0xD1FA,0x9D7B,
0x9D7C,0x9D7D,0x9D7E,0x9D80,0x9D81,0x9D82,0xE4EB,0xE4EC,
0x9D83,0x9D84,0x9D85,0xE4F2,0x9D86,0xCEAB,0x9D87,0x9D88,
0x9D89,0x9D8A,0x9D8B,0x9D8C,0x9D8D,0x9D8E,0x9D8F,0x9D90,
0xC5CB,0x9D91,0x9D92,0x9D93,0xC7B1,0x9D94,0xC2BA,0x9D95,
0x9D96,0x9D97,0xE4EA,0x9D98,0x9D99,0x9D9A,0xC1CA,0x9D9B,
0x9D9C,0x9D9D,0x9D9E,0x9D9F,0x9DA0,0xCCB6,0xB3B1,0x9DA1,
0x9DA2,0x9DA3,0xE4FB,0x9DA4,0xE4F3,0x9DA5,0x9DA6,0x9DA7,
0xE4FA,0x9DA8,0xE4FD,0x9DA9,0xE4FC,0x9DAA,0x9DAB,0x9DAC,
0x9DAD,0x9DAE,0x9DAF,0x9DB0,0xB3CE,0x9DB1,0x9DB2,0x9DB3,
0xB3BA,0xE4F7,0x9DB4,0x9DB5,0xE4F9,0xE4F8,0xC5EC,0x9DB6,
0x9DB7,0x9DB8,0x9DB9,0x9DBA,0x9DBB,0x9DBC,0x9DBD,0x9DBE,
0x9DBF,0x9DC0,0x9DC1,0x9DC2,0xC0BD,0x9DC3,0x9DC4,0x9DC5,
0x9DC6,0xD4E8,0x9DC7,0x9DC8,0x9DC9,0x9DCA,0x9DCB,0xE5A2,
0x9DCC,0x9DCD,0x9DCE,0x9DCF,0x9DD0,0x9DD1,0x9DD2,0x9DD3,
0x9DD4,0x9DD5,0x9DD6,0xB0C4,0x9DD7,0x9DD8,0xE5A4,0x9DD9,
0x9DDA,0xE5A3,0x9DDB,0x9DDC,0x9DDD,0x9DDE,0x9DDF,0x9DE0,
0xBCA4,0x9DE1,0xE5A5,0x9DE2,0x9DE3,0x9DE4,0x9DE5,0x9DE6,
0x9DE7,0xE5A1,0x9DE8,0x9DE9,0x9DEA,0x9DEB,0x9DEC,0x9DED,
0x9DEE,0xE4FE,0xB1F4,0x9DEF,0x9DF0,0x9DF1,0x9DF2,0x9DF3,
0x9DF4,0x9DF5,0x9DF6,0x9DF7,0x9DF8,0x9DF9,0xE5A8,0x9DFA,
0xE5A9,0xE5A6,0x9DFB,0x9DFC,0x9DFD,0x9DFE,0x9E40,0x9E41,
0x9E42,0x9E43,0x9E44,0x9E45,0x9E46,0x9E47,0xE5A7,0xE5AA,
0x9E48,0x9E49,0x9E4A,0x9E4B,0x9E4C,0x9E4D,0x9E4E,0x9E4F,
0x9E50,0x9E51,0x9E52,0x9E53,0x9E54,0x9E55,0x9E56,0x9E57,
0x9E58,0x9E59,0x9E5A,0x9E5B,0x9E5C,0x9E5D,0x9E5E,0x9E5F,
0x9E60,0x9E61,0x9E62,0x9E63,0x9E64,0x9E65,0x9E66,0x9E67,
0x9E68,0xC6D9,0x9E69,0x9E6A,0x9E6B,0x9E6C,0x9E6D,0x9E6E,
0x9E6F,0x9E70,0xE5AB,0xE5AD,0x9E71,0x9E72,0x9E73,0x9E74,
0x9E75,0x9E76,0x9E77,0xE5AC,0x9E78,0x9E79,0x9E7A,0x9E7B,
0x9E7C,0x9E7D,0x9E7E,0x9E80,0x9E81,0x9E82,0x9E83,0x9E84,
0x9E85,0x9E86,0x9E87,0x9E88,0x9E89,0xE5AF,0x9E8A,0x9E8B,
0x9E8C,0xE5AE,0x9E8D,0x9E8E,0x9E8F,0x9E90,0x9E91,0x9E92,
0x9E93,0x9E94,0x9E95,0x9E96,0x9E97,0x9E98,0x9E99,0x9E9A,
0x9E9B,0x9E9C,0x9E9D,0x9E9E,0xB9E0,0x9E9F,0x9EA0,0xE5B0,
0x9EA1,0x9EA2,0x9EA3,0x9EA4,0x9EA5,0x9EA6,0x9EA7,0x9EA8,
0x9EA9,0x9EAA,0x9EAB,0x9EAC,0x9EAD,0x9EAE,0xE5B1,0x9EAF,
0x9EB0,0x9EB1,0x9EB2,0x9EB3,0x9EB4,0x9EB5,0x9EB6,0x9EB7,
0x9EB8,0x9EB9,0x9EBA,0xBBF0,0xECE1,0xC3F0,0x9EBB,0xB5C6,
0xBBD2,0x9EBC,0x9EBD,0x9EBE,0x9EBF,0xC1E9,0xD4EE,0x9EC0,
0xBEC4,0x9EC1,0x9EC2,0x9EC3,0xD7C6,0x9EC4,0xD4D6,0xB2D3,
0xECBE,0x9EC5,0x9EC6,0x9EC7,0x9EC8,0xEAC1,0x9EC9,0x9ECA,
0x9ECB,0xC2AF,0xB4B6,0x9ECC,0x9ECD,0x9ECE,0xD1D7,0x9ECF,
0x9ED0,0x9ED1,0xB3B4,0x9ED2,0xC8B2,0xBFBB,0xECC0,0x9ED3,
0x9ED4,0xD6CB,0x9ED5,0x9ED6,0xECBF,0xECC1,0x9ED7,0x9ED8,
0x9ED9,0x9EDA,0x9EDB,0x9EDC,0x9EDD,0x9EDE,0x9EDF,0x9EE0,
0x9EE1,0x9EE2,0x9EE3,0xECC5,0xBEE6,0xCCBF,0xC5DA,0xBEBC,
0x9EE4,0xECC6,0x9EE5,0xB1FE,0x9EE6,0x9EE7,0x9EE8,0xECC4,
0xD5A8,0xB5E3,0x9EE9,0xECC2,0xC1B6,0xB3E3,0x9EEA,0x9EEB,
0xECC3,0xCBB8,0xC0C3,0xCCFE,0x9EEC,0x9EED,0x9EEE,0x9EEF,
0xC1D2,0x9EF0,0xECC8,0x9EF1,0x9EF2,0x9EF3,0x9EF4,0x9EF5,
0x9EF6,0x9EF7,0x9EF8,0x9EF9,0x9EFA,0x9EFB,0x9EFC,0x9EFD,
0xBAE6,0xC0D3,0x9EFE,0xD6F2,0x9F40,0x9F41,0x9F42,0xD1CC,
0x9F43,0x9F44,0x9F45,0x9F46,0xBFBE,0x9F47,0xB7B3,0xC9D5,
0xECC7,0xBBE2,0x9F48,0xCCCC,0xBDFD,0xC8C8,0x9F49,0xCFA9,
0x9F4A,0x9F4B,0x9F4C,0x9F4D,0x9F4E,0x9F4F,0x9F50,0xCDE9,
0x9F51,0xC5EB,0x9F52,0x9F53,0x9F54,0xB7E9,0x9F55,0x9F56,
0x9F57,0x9F58,0x9F59,0x9F5A,0x9F5B,0x9F5C,0x9F5D,0x9F5E,
0x9F5F,0xD1C9,0xBAB8,0x9F60,0x9F61,0x9F62,0x9F63,0x9F64,
0xECC9,0x9F65,0x9F66,0xECCA,0x9F67,0xBBC0,0xECCB,0x9F68,
0xECE2,0xB1BA,0xB7D9,0x9F69,0x9F6A,0x9F6B,0x9F6C,0x9F6D,
0x9F6E,0x9F6F,0x9F70,0x9F71,0x9F72,0x9F73,0xBDB9,0x9F74,
0x9F75,0x9F76,0x9F77,0x9F78,0x9F79,0x9F7A,0x9F7B,0xECCC,
0xD1E6,0xECCD,0x9F7C,0x9F7D,0x9F7E,0x9F80,0xC8BB,0x9F81,
0x9F82,0x9F83,0x9F84,0x9F85,0x9F86,0x9F87,0x9F88,0x9F89,
0x9F8A,0x9F8B,0x9F8C,0x9F8D,0x9F8E,0xECD1,0x9F8F,0x9F90,
0x9F91,0x9F92,0xECD3,0x9F93,0xBBCD,0x9F94,0xBCE5,0x9F95,
0x9F96,0x9F97,0x9F98,0x9F99,0x9F9A,0x9F9B,0x9F9C,0x9F9D,
0x9F9E,0x9F9F,0x9FA0,0x9FA1,0xECCF,0x9FA2,0xC9B7,0x9FA3,
0x9FA4,0x9FA5,0x9FA6,0x9FA7,0xC3BA,0x9FA8,0xECE3,0xD5D5,
0xECD0,0x9FA9,0x9FAA,0x9FAB,0x9FAC,0x9FAD,0xD6F3,0x9FAE,
0x9FAF,0x9FB0,0xECD2,0xECCE,0x9FB1,0x9FB2,0x9FB3,0x9FB4,
0xECD4,0x9FB5,0xECD5,0x9FB6,0x9FB7,0xC9BF,0x9FB8,0x9FB9,
0x9FBA,0x9FBB,0x9FBC,0x9FBD,0xCFA8,0x9FBE,0x9FBF,0x9FC0,
0x9FC1,0x9FC2,0xD0DC,0x9FC3,0x9FC4,0x9FC5,0x9FC6,0xD1AC,
0x9FC7,0x9FC8,0x9FC9,0x9FCA,0xC8DB,0x9FCB,0x9FCC,0x9FCD,
0xECD6,0xCEF5,0x9FCE,0x9FCF,0x9FD0,0x9FD1,0x9FD2,0xCAEC,
0xECDA,0x9FD3,0x9FD4,0x9FD5,0x9FD6,0x9FD7,0x9FD8,0x9FD9,
0xECD9,0x9FDA,0x9FDB,0x9FDC,0xB0BE,0x9FDD,0x9FDE,0x9FDF,
0x9FE0,0x9FE1,0x9FE2,0xECD7,0x9FE3,0xECD8,0x9FE4,0x9FE5,
0x9FE6,0xECE4,0x9FE7,0x9FE8,0x9FE9,0x9FEA,0x9FEB,0x9FEC,
0x9FED,0x9FEE,0x9FEF,0xC8BC,0x9FF0,0x9FF1,0x9FF2,0x9FF3,
0x9FF4,0x9FF5,0x9FF6,0x9FF7,0x9FF8,0x9FF9,0xC1C7,0x9FFA,
0x9FFB,0x9FFC,0x9FFD,0x9FFE,0xECDC,0xD1E0,0xA040,0xA041,
0xA042,0xA043,0xA044,0xA045,0xA046,0xA047,0xA048,0xA049,
0xECDB,0xA04A,0xA04B,0xA04C,0xA04D,0xD4EF,0xA04E,0xECDD,
0xA04F,0xA050,0xA051,0xA052,0xA053,0xA054,0xDBC6,0xA055,
0xA056,0xA057,0xA058,0xA059,0xA05A,0xA05B,0xA05C,0xA05D,
0xA05E,0xECDE,0xA05F,0xA060,0xA061,0xA062,0xA063,0xA064,
0xA065,0xA066,0xA067,0xA068,0xA069,0xA06A,0xB1AC,0xA06B,
0xA06C,0xA06D,0xA06E,0xA06F,0xA070,0xA071,0xA072,0xA073,
0xA074,0xA075,0xA076,0xA077,0xA078,0xA079,0xA07A,0xA07B,
0xA07C,0xA07D,0xA07E,0xA080,0xA081,0xECDF,0xA082,0xA083,
0xA084,0xA085,0xA086,0xA087,0xA088,0xA089,0xA08A,0xA08B,
0xECE0,0xA08C,0xD7A6,0xA08D,0xC5C0,0xA08E,0xA08F,0xA090,
0xEBBC,0xB0AE,0xA091,0xA092,0xA093,0xBEF4,0xB8B8,0xD2AF,
0xB0D6,0xB5F9,0xA094,0xD8B3,0xA095,0xCBAC,0xA096,0xE3DD,
0xA097,0xA098,0xA099,0xA09A,0xA09B,0xA09C,0xA09D,0xC6AC,
0xB0E6,0xA09E,0xA09F,0xA0A0,0xC5C6,0xEBB9,0xA0A1,0xA0A2,
0xA0A3,0xA0A4,0xEBBA,0xA0A5,0xA0A6,0xA0A7,0xEBBB,0xA0A8,
0xA0A9,0xD1C0,0xA0AA,0xC5A3,0xA0AB,0xEAF2,0xA0AC,0xC4B2,
0xA0AD,0xC4B5,0xC0CE,0xA0AE,0xA0AF,0xA0B0,0xEAF3,0xC4C1,
0xA0B1,0xCEEF,0xA0B2,0xA0B3,0xA0B4,0xA0B5,0xEAF0,0xEAF4,
0xA0B6,0xA0B7,0xC9FC,0xA0B8,0xA0B9,0xC7A3,0xA0BA,0xA0BB,
0xA0BC,0xCCD8,0xCEFE,0xA0BD,0xA0BE,0xA0BF,0xEAF5,0xEAF6,
0xCFAC,0xC0E7,0xA0C0,0xA0C1,0xEAF7,0xA0C2,0xA0C3,0xA0C4,
0xA0C5,0xA0C6,0xB6BF,0xEAF8,0xA0C7,0xEAF9,0xA0C8,0xEAFA,
0xA0C9,0xA0CA,0xEAFB,0xA0CB,0xA0CC,0xA0CD,0xA0CE,0xA0CF,
0xA0D0,0xA0D1,0xA0D2,0xA0D3,0xA0D4,0xA0D5,0xA0D6,0xEAF1,
0xA0D7,0xA0D8,0xA0D9,0xA0DA,0xA0DB,0xA0DC,0xA0DD,0xA0DE,
0xA0DF,0xA0E0,0xA0E1,0xA0E2,0xC8AE,0xE1EB,0xA0E3,0xB7B8,
0xE1EC,0xA0E4,0xA0E5,0xA0E6,0xE1ED,0xA0E7,0xD7B4,0xE1EE,
0xE1EF,0xD3CC,0xA0E8,0xA0E9,0xA0EA,0xA0EB,0xA0EC,0xA0ED,
0xA0EE,0xE1F1,0xBFF1,0xE1F0,0xB5D2,0xA0EF,0xA0F0,0xA0F1,
0xB1B7,0xA0F2,0xA0F3,0xA0F4,0xA0F5,0xE1F3,0xE1F2,0xA0F6,
0xBAFC,0xA0F7,0xE1F4,0xA0F8,0xA0F9,0xA0FA,0xA0FB,0xB9B7,
0xA0FC,0xBED1,0xA0FD,0xA0FE,0xAA40,0xAA41,0xC4FC,0xAA42,
0xBADD,0xBDC6,0xAA43,0xAA44,0xAA45,0xAA46,0xAA47,0xAA48,
0xE1F5,0xE1F7,0xAA49,0xAA4A,0xB6C0,0xCFC1,0xCAA8,0xE1F6,
0xD5F8,0xD3FC,0xE1F8,0xE1FC,0xE1F9,0xAA4B,0xAA4C,0xE1FA,
0xC0EA,0xAA4D,0xE1FE,0xE2A1,0xC0C7,0xAA4E,0xAA4F,0xAA50,
0xAA51,0xE1FB,0xAA52,0xE1FD,0xAA53,0xAA54,0xAA55,0xAA56,
0xAA57,0xAA58,0xE2A5,0xAA59,0xAA5A,0xAA5B,0xC1D4,0xAA5C,
0xAA5D,0xAA5E,0xAA5F,0xE2A3,0xAA60,0xE2A8,0xB2FE,0xE2A2,
0xAA61,0xAA62,0xAA63,0xC3CD,0xB2C2,0xE2A7,0xE2A6,0xAA64,
0xAA65,0xE2A4,0xE2A9,0xAA66,0xAA67,0xE2AB,0xAA68,0xAA69,
0xAA6A,0xD0C9,0xD6ED,0xC3A8,0xE2AC,0xAA6B,0xCFD7,0xAA6C,
0xAA6D,0xE2AE,0xAA6E,0xAA6F,0xBAEF,0xAA70,0xAA71,0xE9E0,
0xE2AD,0xE2AA,0xAA72,0xAA73,0xAA74,0xAA75,0xBBAB,0xD4B3,
0xAA76,0xAA77,0xAA78,0xAA79,0xAA7A,0xAA7B,0xAA7C,0xAA7D,
0xAA7E,0xAA80,0xAA81,0xAA82,0xAA83,0xE2B0,0xAA84,0xAA85,
0xE2AF,0xAA86,0xE9E1,0xAA87,0xAA88,0xAA89,0xAA8A,0xE2B1,
0xAA8B,0xAA8C,0xAA8D,0xAA8E,0xAA8F,0xAA90,0xAA91,0xAA92,
0xE2B2,0xAA93,0xAA94,0xAA95,0xAA96,0xAA97,0xAA98,0xAA99,
0xAA9A,0xAA9B,0xAA9C,0xAA9D,0xE2B3,0xCCA1,0xAA9E,0xE2B4,
0xAA9F,0xAAA0,0xAB40,0xAB41,0xAB42,0xAB43,0xAB44,0xAB45,
0xAB46,0xAB47,0xAB48,0xAB49,0xAB4A,0xAB4B,0xE2B5,0xAB4C,
0xAB4D,0xAB4E,0xAB4F,0xAB50,0xD0FE,0xAB51,0xAB52,0xC2CA,
0xAB53,0xD3F1,0xAB54,0xCDF5,0xAB55,0xAB56,0xE7E0,0xAB57,
0xAB58,0xE7E1,0xAB59,0xAB5A,0xAB5B,0xAB5C,0xBEC1,0xAB5D,
0xAB5E,0xAB5F,0xAB60,0xC2EA,0xAB61,0xAB62,0xAB63,0xE7E4,
0xAB64,0xAB65,0xE7E3,0xAB66,0xAB67,0xAB68,0xAB69,0xAB6A,
0xAB6B,0xCDE6,0xAB6C,0xC3B5,0xAB6D,0xAB6E,0xE7E2,0xBBB7,
0xCFD6,0xAB6F,0xC1E1,0xE7E9,0xAB70,0xAB71,0xAB72,0xE7E8,
0xAB73,0xAB74,0xE7F4,0xB2A3,0xAB75,0xAB76,0xAB77,0xAB78,
0xE7EA,0xAB79,0xE7E6,0xAB7A,0xAB7B,0xAB7C,0xAB7D,0xAB7E,
0xE7EC,0xE7EB,0xC9BA,0xAB80,0xAB81,0xD5E4,0xAB82,0xE7E5,
0xB7A9,0xE7E7,0xAB83,0xAB84,0xAB85,0xAB86,0xAB87,0xAB88,
0xAB89,0xE7EE,0xAB8A,0xAB8B,0xAB8C,0xAB8D,0xE7F3,0xAB8E,
0xD6E9,0xAB8F,0xAB90,0xAB91,0xAB92,0xE7ED,0xAB93,0xE7F2,
0xAB94,0xE7F1,0xAB95,0xAB96,0xAB97,0xB0E0,0xAB98,0xAB99,
0xAB9A,0xAB9B,0xE7F5,0xAB9C,0xAB9D,0xAB9E,0xAB9F,0xABA0,
0xAC40,0xAC41,0xAC42,0xAC43,0xAC44,0xAC45,0xAC46,0xAC47,
0xAC48,0xAC49,0xAC4A,0xC7F2,0xAC4B,0xC0C5,0xC0ED,0xAC4C,
0xAC4D,0xC1F0,0xE7F0,0xAC4E,0xAC4F,0xAC50,0xAC51,0xE7F6,
0xCBF6,0xAC52,0xAC53,0xAC54,0xAC55,0xAC56,0xAC57,0xAC58,
0xAC59,0xAC5A,0xE8A2,0xE8A1,0xAC5B,0xAC5C,0xAC5D,0xAC5E,
0xAC5F,0xAC60,0xD7C1,0xAC61,0xAC62,0xE7FA,0xE7F9,0xAC63,
0xE7FB,0xAC64,0xE7F7,0xAC65,0xE7FE,0xAC66,0xE7FD,0xAC67,
0xE7FC,0xAC68,0xAC69,0xC1D5,0xC7D9,0xC5FD,0xC5C3,0xAC6A,
0xAC6B,0xAC6C,0xAC6D,0xAC6E,0xC7ED,0xAC6F,0xAC70,0xAC71,
0xAC72,0xE8A3,0xAC73,0xAC74,0xAC75,0xAC76,0xAC77,0xAC78,
0xAC79,0xAC7A,0xAC7B,0xAC7C,0xAC7D,0xAC7E,0xAC80,0xAC81,
0xAC82,0xAC83,0xAC84,0xAC85,0xAC86,0xE8A6,0xAC87,0xE8A5,
0xAC88,0xE8A7,0xBAF7,0xE7F8,0xE8A4,0xAC89,0xC8F0,0xC9AA,
0xAC8A,0xAC8B,0xAC8C,0xAC8D,0xAC8E,0xAC8F,0xAC90,0xAC91,
0xAC92,0xAC93,0xAC94,0xAC95,0xAC96,0xE8A9,0xAC97,0xAC98,
0xB9E5,0xAC99,0xAC9A,0xAC9B,0xAC9C,0xAC9D,0xD1FE,0xE8A8,
0xAC9E,0xAC9F,0xACA0,0xAD40,0xAD41,0xAD42,0xE8AA,0xAD43,
0xE8AD,0xE8AE,0xAD44,0xC1A7,0xAD45,0xAD46,0xAD47,0xE8AF,
0xAD48,0xAD49,0xAD4A,0xE8B0,0xAD4B,0xAD4C,0xE8AC,0xAD4D,
0xE8B4,0xAD4E,0xAD4F,0xAD50,0xAD51,0xAD52,0xAD53,0xAD54,
0xAD55,0xAD56,0xAD57,0xAD58,0xE8AB,0xAD59,0xE8B1,0xAD5A,
0xAD5B,0xAD5C,0xAD5D,0xAD5E,0xAD5F,0xAD60,0xAD61,0xE8B5,
0xE8B2,0xE8B3,0xAD62,0xAD63,0xAD64,0xAD65,0xAD66,0xAD67,
0xAD68,0xAD69,0xAD6A,0xAD6B,0xAD6C,0xAD6D,0xAD6E,0xAD6F,
0xAD70,0xAD71,0xE8B7,0xAD72,0xAD73,0xAD74,0xAD75,0xAD76,
0xAD77,0xAD78,0xAD79,0xAD7A,0xAD7B,0xAD7C,0xAD7D,0xAD7E,
0xAD80,0xAD81,0xAD82,0xAD83,0xAD84,0xAD85,0xAD86,0xAD87,
0xAD88,0xAD89,0xE8B6,0xAD8A,0xAD8B,0xAD8C,0xAD8D,0xAD8E,
0xAD8F,0xAD90,0xAD91,0xAD92,0xB9CF,0xAD93,0xF0AC,0xAD94,
0xF0AD,0xAD95,0xC6B0,0xB0EA,0xC8BF,0xAD96,0xCDDF,0xAD97,
0xAD98,0xAD99,0xAD9A,0xAD9B,0xAD9C,0xAD9D,0xCECD,0xEAB1,
0xAD9E,0xAD9F,0xADA0,0xAE40,0xEAB2,0xAE41,0xC6BF,0xB4C9,
0xAE42,0xAE43,0xAE44,0xAE45,0xAE46,0xAE47,0xAE48,0xEAB3,
0xAE49,0xAE4A,0xAE4B,0xAE4C,0xD5E7,0xAE4D,0xAE4E,0xAE4F,
0xAE50,0xAE51,0xAE52,0xAE53,0xAE54,0xDDF9,0xAE55,0xEAB4,
0xAE56,0xEAB5,0xAE57,0xEAB6,0xAE58,0xAE59,0xAE5A,0xAE5B,
0xB8CA,0xDFB0,0xC9F5,0xAE5C,0xCCF0,0xAE5D,0xAE5E,0xC9FA,
0xAE5F,0xAE60,0xAE61,0xAE62,0xAE63,0xC9FB,0xAE64,0xAE65,
0xD3C3,0xCBA6,0xAE66,0xB8A6,0xF0AE,0xB1C2,0xAE67,0xE5B8,
0xCCEF,0xD3C9,0xBCD7,0xC9EA,0xAE68,0xB5E7,0xAE69,0xC4D0,
0xB5E9,0xAE6A,0xEEAE,0xBBAD,0xAE6B,0xAE6C,0xE7DE,0xAE6D,
0xEEAF,0xAE6E,0xAE6F,0xAE70,0xAE71,0xB3A9,0xAE72,0xAE73,
0xEEB2,0xAE74,0xAE75,0xEEB1,0xBDE7,0xAE76,0xEEB0,0xCEB7,
0xAE77,0xAE78,0xAE79,0xAE7A,0xC5CF,0xAE7B,0xAE7C,0xAE7D,
0xAE7E,0xC1F4,0xDBCE,0xEEB3,0xD0F3,0xAE80,0xAE81,0xAE82,
0xAE83,0xAE84,0xAE85,0xAE86,0xAE87,0xC2D4,0xC6E8,0xAE88,
0xAE89,0xAE8A,0xB7AC,0xAE8B,0xAE8C,0xAE8D,0xAE8E,0xAE8F,
0xAE90,0xAE91,0xEEB4,0xAE92,0xB3EB,0xAE93,0xAE94,0xAE95,
0xBBFB,0xEEB5,0xAE96,0xAE97,0xAE98,0xAE99,0xAE9A,0xE7DC,
0xAE9B,0xAE9C,0xAE9D,0xEEB6,0xAE9E,0xAE9F,0xBDAE,0xAEA0,
0xAF40,0xAF41,0xAF42,0xF1E2,0xAF43,0xAF44,0xAF45,0xCAE8,
0xAF46,0xD2C9,0xF0DA,0xAF47,0xF0DB,0xAF48,0xF0DC,0xC1C6,
0xAF49,0xB8ED,0xBECE,0xAF4A,0xAF4B,0xF0DE,0xAF4C,0xC5B1,
0xF0DD,0xD1F1,0xAF4D,0xF0E0,0xB0CC,0xBDEA,0xAF4E,0xAF4F,
0xAF50,0xAF51,0xAF52,0xD2DF,0xF0DF,0xAF53,0xB4AF,0xB7E8,
0xF0E6,0xF0E5,0xC6A3,0xF0E1,0xF0E2,0xB4C3,0xAF54,0xAF55,
0xF0E3,0xD5EE,0xAF56,0xAF57,0xCCDB,0xBED2,0xBCB2,0xAF58,
0xAF59,0xAF5A,0xF0E8,0xF0E7,0xF0E4,0xB2A1,0xAF5B,0xD6A2,
0xD3B8,0xBEB7,0xC8AC,0xAF5C,0xAF5D,0xF0EA,0xAF5E,0xAF5F,
0xAF60,0xAF61,0xD1F7,0xAF62,0xD6CC,0xBADB,0xF0E9,0xAF63,
0xB6BB,0xAF64,0xAF65,0xCDB4,0xAF66,0xAF67,0xC6A6,0xAF68,
0xAF69,0xAF6A,0xC1A1,0xF0EB,0xF0EE,0xAF6B,0xF0ED,0xF0F0,
0xF0EC,0xAF6C,0xBBBE,0xF0EF,0xAF6D,0xAF6E,0xAF6F,0xAF70,
0xCCB5,0xF0F2,0xAF71,0xAF72,0xB3D5,0xAF73,0xAF74,0xAF75,
0xAF76,0xB1D4,0xAF77,0xAF78,0xF0F3,0xAF79,0xAF7A,0xF0F4,
0xF0F6,0xB4E1,0xAF7B,0xF0F1,0xAF7C,0xF0F7,0xAF7D,0xAF7E,
0xAF80,0xAF81,0xF0FA,0xAF82,0xF0F8,0xAF83,0xAF84,0xAF85,
0xF0F5,0xAF86,0xAF87,0xAF88,0xAF89,0xF0FD,0xAF8A,0xF0F9,
0xF0FC,0xF0FE,0xAF8B,0xF1A1,0xAF8C,0xAF8D,0xAF8E,0xCEC1,
0xF1A4,0xAF8F,0xF1A3,0xAF90,0xC1F6,0xF0FB,0xCADD,0xAF91,
0xAF92,0xB4F1,0xB1F1,0xCCB1,0xAF93,0xF1A6,0xAF94,0xAF95,
0xF1A7,0xAF96,0xAF97,0xF1AC,0xD5CE,0xF1A9,0xAF98,0xAF99,
0xC8B3,0xAF9A,0xAF9B,0xAF9C,0xF1A2,0xAF9D,0xF1AB,0xF1A8,
0xF1A5,0xAF9E,0xAF9F,0xF1AA,0xAFA0,0xB040,0xB041,0xB042,
0xB043,0xB044,0xB045,0xB046,0xB0A9,0xF1AD,0xB047,0xB048,
0xB049,0xB04A,0xB04B,0xB04C,0xF1AF,0xB04D,0xF1B1,0xB04E,
0xB04F,0xB050,0xB051,0xB052,0xF1B0,0xB053,0xF1AE,0xB054,
0xB055,0xB056,0xB057,0xD1A2,0xB058,0xB059,0xB05A,0xB05B,
0xB05C,0xB05D,0xB05E,0xF1B2,0xB05F,0xB060,0xB061,0xF1B3,
0xB062,0xB063,0xB064,0xB065,0xB066,0xB067,0xB068,0xB069,
0xB9EF,0xB06A,0xB06B,0xB5C7,0xB06C,0xB0D7,0xB0D9,0xB06D,
0xB06E,0xB06F,0xD4ED,0xB070,0xB5C4,0xB071,0xBDD4,0xBBCA,
0xF0A7,0xB072,0xB073,0xB8DE,0xB074,0xB075,0xF0A8,0xB076,
0xB077,0xB0A8,0xB078,0xF0A9,0xB079,0xB07A,0xCDEE,0xB07B,
0xB07C,0xF0AA,0xB07D,0xB07E,0xB080,0xB081,0xB082,0xB083,
0xB084,0xB085,0xB086,0xB087,0xF0AB,0xB088,0xB089,0xB08A,
0xB08B,0xB08C,0xB08D,0xB08E,0xB08F,0xB090,0xC6A4,0xB091,
0xB092,0xD6E5,0xF1E4,0xB093,0xF1E5,0xB094,0xB095,0xB096,
0xB097,0xB098,0xB099,0xB09A,0xB09B,0xB09C,0xB09D,0xC3F3,
0xB09E,0xB09F,0xD3DB,0xB0A0,0xB140,0xD6D1,0xC5E8,0xB141,
0xD3AF,0xB142,0xD2E6,0xB143,0xB144,0xEEC1,0xB0BB,0xD5B5,
0xD1CE,0xBCE0,0xBAD0,0xB145,0xBFF8,0xB146,0xB8C7,0xB5C1,
0xC5CC,0xB147,0xB148,0xCAA2,0xB149,0xB14A,0xB14B,0xC3CB,
0xB14C,0xB14D,0xB14E,0xB14F,0xB150,0xEEC2,0xB151,0xB152,
0xB153,0xB154,0xB155,0xB156,0xB157,0xB158,0xC4BF,0xB6A2,
0xB159,0xEDEC,0xC3A4,0xB15A,0xD6B1,0xB15B,0xB15C,0xB15D,
0xCFE0,0xEDEF,0xB15E,0xB15F,0xC5CE,0xB160,0xB6DC,0xB161,
0xB162,0xCAA1,0xB163,0xB164,0xEDED,0xB165,0xB166,0xEDF0,
0xEDF1,0xC3BC,0xB167,0xBFB4,0xB168,0xEDEE,0xB169,0xB16A,
0xB16B,0xB16C,0xB16D,0xB16E,0xB16F,0xB170,0xB171,0xB172,
0xB173,0xEDF4,0xEDF2,0xB174,0xB175,0xB176,0xB177,0xD5E6,
0xC3DF,0xB178,0xEDF3,0xB179,0xB17A,0xB17B,0xEDF6,0xB17C,
0xD5A3,0xD1A3,0xB17D,0xB17E,0xB180,0xEDF5,0xB181,0xC3D0,
0xB182,0xB183,0xB184,0xB185,0xB186,0xEDF7,0xBFF4,0xBEEC,
0xEDF8,0xB187,0xCCF7,0xB188,0xD1DB,0xB189,0xB18A,0xB18B,
0xD7C5,0xD5F6,0xB18C,0xEDFC,0xB18D,0xB18E,0xB18F,0xEDFB,
0xB190,0xB191,0xB192,0xB193,0xB194,0xB195,0xB196,0xB197,
0xEDF9,0xEDFA,0xB198,0xB199,0xB19A,0xB19B,0xB19C,0xB19D,
0xB19E,0xB19F,0xEDFD,0xBEA6,0xB1A0,0xB240,0xB241,0xB242,
0xB243,0xCBAF,0xEEA1,0xB6BD,0xB244,0xEEA2,0xC4C0,0xB245,
0xEDFE,0xB246,0xB247,0xBDDE,0xB2C7,0xB248,0xB249,0xB24A,
0xB24B,0xB24C,0xB24D,0xB24E,0xB24F,0xB250,0xB251,0xB252,
0xB253,0xB6C3,0xB254,0xB255,0xB256,0xEEA5,0xD8BA,0xEEA3,
0xEEA6,0xB257,0xB258,0xB259,0xC3E9,0xB3F2,0xB25A,0xB25B,
0xB25C,0xB25D,0xB25E,0xB25F,0xEEA7,0xEEA4,0xCFB9,0xB260,
0xB261,0xEEA8,0xC2F7,0xB262,0xB263,0xB264,0xB265,0xB266,
0xB267,0xB268,0xB269,0xB26A,0xB26B,0xB26C,0xB26D,0xEEA9,
0xEEAA,0xB26E,0xDEAB,0xB26F,0xB270,0xC6B3,0xB271,0xC7C6,
0xB272,0xD6F5,0xB5C9,0xB273,0xCBB2,0xB274,0xB275,0xB276,
0xEEAB,0xB277,0xB278,0xCDAB,0xB279,0xEEAC,0xB27A,0xB27B,
0xB27C,0xB27D,0xB27E,0xD5B0,0xB280,0xEEAD,0xB281,0xF6C4,
0xB282,0xB283,0xB284,0xB285,0xB286,0xB287,0xB288,0xB289,
0xB28A,0xB28B,0xB28C,0xB28D,0xB28E,0xDBC7,0xB28F,0xB290,
0xB291,0xB292,0xB293,0xB294,0xB295,0xB296,0xB297,0xB4A3,
0xB298,0xB299,0xB29A,0xC3AC,0xF1E6,0xB29B,0xB29C,0xB29D,
0xB29E,0xB29F,0xCAB8,0xD2D3,0xB2A0,0xD6AA,0xB340,0xEFF2,
0xB341,0xBED8,0xB342,0xBDC3,0xEFF3,0xB6CC,0xB0AB,0xB343,
0xB344,0xB345,0xB346,0xCAAF,0xB347,0xB348,0xEDB6,0xB349,
0xEDB7,0xB34A,0xB34B,0xB34C,0xB34D,0xCEF9,0xB7AF,0xBFF3,
0xEDB8,0xC2EB,0xC9B0,0xB34E,0xB34F,0xB350,0xB351,0xB352,
0xB353,0xEDB9,0xB354,0xB355,0xC6F6,0xBFB3,0xB356,0xB357,
0xB358,0xEDBC,0xC5F8,0xB359,0xD1D0,0xB35A,0xD7A9,0xEDBA,
0xEDBB,0xB35B,0xD1E2,0xB35C,0xEDBF,0xEDC0,0xB35D,0xEDC4,
0xB35E,0xB35F,0xB360,0xEDC8,0xB361,0xEDC6,0xEDCE,0xD5E8,
0xB362,0xEDC9,0xB363,0xB364,0xEDC7,0xEDBE,0xB365,0xB366,
0xC5E9,0xB367,0xB368,0xB369,0xC6C6,0xB36A,0xB36B,0xC9E9,
0xD4D2,0xEDC1,0xEDC2,0xEDC3,0xEDC5,0xB36C,0xC0F9,0xB36D,
0xB4A1,0xB36E,0xB36F,0xB370,0xB371,0xB9E8,0xB372,0xEDD0,
0xB373,0xB374,0xB375,0xB376,0xEDD1,0xB377,0xEDCA,0xB378,
0xEDCF,0xB379,0xCEF8,0xB37A,0xB37B,0xCBB6,0xEDCC,0xEDCD,
0xB37C,0xB37D,0xB37E,0xB380,0xB381,0xCFF5,0xB382,0xB383,
0xB384,0xB385,0xB386,0xB387,0xB388,0xB389,0xB38A,0xB38B,
0xB38C,0xB38D,0xEDD2,0xC1F2,0xD3B2,0xEDCB,0xC8B7,0xB38E,
0xB38F,0xB390,0xB391,0xB392,0xB393,0xB394,0xB395,0xBCEF,
0xB396,0xB397,0xB398,0xB399,0xC5F0,0xB39A,0xB39B,0xB39C,
0xB39D,0xB39E,0xB39F,0xB3A0,0xB440,0xB441,0xB442,0xEDD6,
0xB443,0xB5EF,0xB444,0xB445,0xC2B5,0xB0AD,0xCBE9,0xB446,
0xB447,0xB1AE,0xB448,0xEDD4,0xB449,0xB44A,0xB44B,0xCDEB,
0xB5E2,0xB44C,0xEDD5,0xEDD3,0xEDD7,0xB44D,0xB44E,0xB5FA,
0xB44F,0xEDD8,0xB450,0xEDD9,0xB451,0xEDDC,0xB452,0xB1CC,
0xB453,0xB454,0xB455,0xB456,0xB457,0xB458,0xB459,0xB45A,
0xC5F6,0xBCEE,0xEDDA,0xCCBC,0xB2EA,0xB45B,0xB45C,0xB45D,
0xB45E,0xEDDB,0xB45F,0xB460,0xB461,0xB462,0xC4EB,0xB463,
0xB464,0xB4C5,0xB465,0xB466,0xB467,0xB0F5,0xB468,0xB469,
0xB46A,0xEDDF,0xC0DA,0xB4E8,0xB46B,0xB46C,0xB46D,0xB46E,
0xC5CD,0xB46F,0xB470,0xB471,0xEDDD,0xBFC4,0xB472,0xB473,
0xB474,0xEDDE,0xB475,0xB476,0xB477,0xB478,0xB479,0xB47A,
0xB47B,0xB47C,0xB47D,0xB47E,0xB480,0xB481,0xB482,0xB483,
0xC4A5,0xB484,0xB485,0xB486,0xEDE0,0xB487,0xB488,0xB489,
0xB48A,0xB48B,0xEDE1,0xB48C,0xEDE3,0xB48D,0xB48E,0xC1D7,
0xB48F,0xB490,0xBBC7,0xB491,0xB492,0xB493,0xB494,0xB495,
0xB496,0xBDB8,0xB497,0xB498,0xB499,0xEDE2,0xB49A,0xB49B,
0xB49C,0xB49D,0xB49E,0xB49F,0xB4A0,0xB540,0xB541,0xB542,
0xB543,0xB544,0xB545,0xEDE4,0xB546,0xB547,0xB548,0xB549,
0xB54A,0xB54B,0xB54C,0xB54D,0xB54E,0xB54F,0xEDE6,0xB550,
0xB551,0xB552,0xB553,0xB554,0xEDE5,0xB555,0xB556,0xB557,
0xB558,0xB559,0xB55A,0xB55B,0xB55C,0xB55D,0xB55E,0xB55F,
0xB560,0xB561,0xB562,0xB563,0xEDE7,0xB564,0xB565,0xB566,
0xB567,0xB568,0xCABE,0xECEA,0xC0F1,0xB569,0xC9E7,0xB56A,
0xECEB,0xC6EE,0xB56B,0xB56C,0xB56D,0xB56E,0xECEC,0xB56F,
0xC6ED,0xECED,0xB570,0xB571,0xB572,0xB573,0xB574,0xB575,
0xB576,0xB577,0xB578,0xECF0,0xB579,0xB57A,0xD7E6,0xECF3,
0xB57B,0xB57C,0xECF1,0xECEE,0xECEF,0xD7A3,0xC9F1,0xCBEE,
0xECF4,0xB57D,0xECF2,0xB57E,0xB580,0xCFE9,0xB581,0xECF6,
0xC6B1,0xB582,0xB583,0xB584,0xB585,0xBCC0,0xB586,0xECF5,
0xB587,0xB588,0xB589,0xB58A,0xB58B,0xB58C,0xB58D,0xB5BB,
0xBBF6,0xB58E,0xECF7,0xB58F,0xB590,0xB591,0xB592,0xB593,
0xD9F7,0xBDFB,0xB594,0xB595,0xC2BB,0xECF8,0xB596,0xB597,
0xB598,0xB599,0xECF9,0xB59A,0xB59B,0xB59C,0xB59D,0xB8A3,
0xB59E,0xB59F,0xB5A0,0xB640,0xB641,0xB642,0xB643,0xB644,
0xB645,0xB646,0xECFA,0xB647,0xB648,0xB649,0xB64A,0xB64B,
0xB64C,0xB64D,0xB64E,0xB64F,0xB650,0xB651,0xB652,0xECFB,
0xB653,0xB654,0xB655,0xB656,0xB657,0xB658,0xB659,0xB65A,
0xB65B,0xB65C,0xB65D,0xECFC,0xB65E,0xB65F,0xB660,0xB661,
0xB662,0xD3ED,0xD8AE,0xC0EB,0xB663,0xC7DD,0xBACC,0xB664,
0xD0E3,0xCBBD,0xB665,0xCDBA,0xB666,0xB667,0xB8D1,0xB668,
0xB669,0xB1FC,0xB66A,0xC7EF,0xB66B,0xD6D6,0xB66C,0xB66D,
0xB66E,0xBFC6,0xC3EB,0xB66F,0xB670,0xEFF5,0xB671,0xB672,
0xC3D8,0xB673,0xB674,0xB675,0xB676,0xB677,0xB678,0xD7E2,
0xB679,0xB67A,0xB67B,0xEFF7,0xB3D3,0xB67C,0xC7D8,0xD1ED,
0xB67D,0xD6C8,0xB67E,0xEFF8,0xB680,0xEFF6,0xB681,0xBBFD,
0xB3C6,0xB682,0xB683,0xB684,0xB685,0xB686,0xB687,0xB688,
0xBDD5,0xB689,0xB68A,0xD2C6,0xB68B,0xBBE0,0xB68C,0xB68D,
0xCFA1,0xB68E,0xEFFC,0xEFFB,0xB68F,0xB690,0xEFF9,0xB691,
0xB692,0xB693,0xB694,0xB3CC,0xB695,0xC9D4,0xCBB0,0xB696,
0xB697,0xB698,0xB699,0xB69A,0xEFFE,0xB69B,0xB69C,0xB0DE,
0xB69D,0xB69E,0xD6C9,0xB69F,0xB6A0,0xB740,0xEFFD,0xB741,
0xB3ED,0xB742,0xB743,0xF6D5,0xB744,0xB745,0xB746,0xB747,
0xB748,0xB749,0xB74A,0xB74B,0xB74C,0xB74D,0xB74E,0xB74F,
0xB750,0xB751,0xB752,0xCEC8,0xB753,0xB754,0xB755,0xF0A2,
0xB756,0xF0A1,0xB757,0xB5BE,0xBCDA,0xBBFC,0xB758,0xB8E5,
0xB759,0xB75A,0xB75B,0xB75C,0xB75D,0xB75E,0xC4C2,0xB75F,
0xB760,0xB761,0xB762,0xB763,0xB764,0xB765,0xB766,0xB767,
0xB768,0xF0A3,0xB769,0xB76A,0xB76B,0xB76C,0xB76D,0xCBEB,
0xB76E,0xB76F,0xB770,0xB771,0xB772,0xB773,0xB774,0xB775,
0xB776,0xB777,0xB778,0xB779,0xB77A,0xB77B,0xB77C,0xB77D,
0xB77E,0xB780,0xB781,0xB782,0xB783,0xB784,0xB785,0xB786,
0xF0A6,0xB787,0xB788,0xB789,0xD1A8,0xB78A,0xBEBF,0xC7EE,
0xF1B6,0xF1B7,0xBFD5,0xB78B,0xB78C,0xB78D,0xB78E,0xB4A9,
0xF1B8,0xCDBB,0xB78F,0xC7D4,0xD5AD,0xB790,0xF1B9,0xB791,
0xF1BA,0xB792,0xB793,0xB794,0xB795,0xC7CF,0xB796,0xB797,
0xB798,0xD2A4,0xD6CF,0xB799,0xB79A,0xF1BB,0xBDD1,0xB4B0,
0xBEBD,0xB79B,0xB79C,0xB79D,0xB4DC,0xCED1,0xB79E,0xBFDF,
0xF1BD,0xB79F,0xB7A0,0xB840,0xB841,0xBFFA,0xF1BC,0xB842,
0xF1BF,0xB843,0xB844,0xB845,0xF1BE,0xF1C0,0xB846,0xB847,
0xB848,0xB849,0xB84A,0xF1C1,0xB84B,0xB84C,0xB84D,0xB84E,
0xB84F,0xB850,0xB851,0xB852,0xB853,0xB854,0xB855,0xC1FE,
0xB856,0xB857,0xB858,0xB859,0xB85A,0xB85B,0xB85C,0xB85D,
0xB85E,0xB85F,0xB860,0xC1A2,0xB861,0xB862,0xB863,0xB864,
0xB865,0xB866,0xB867,0xB868,0xB869,0xB86A,0xCAFA,0xB86B,
0xB86C,0xD5BE,0xB86D,0xB86E,0xB86F,0xB870,0xBEBA,0xBEB9,
0xD5C2,0xB871,0xB872,0xBFA2,0xB873,0xCDAF,0xF1B5,0xB874,
0xB875,0xB876,0xB877,0xB878,0xB879,0xBDDF,0xB87A,0xB6CB,
0xB87B,0xB87C,0xB87D,0xB87E,0xB880,0xB881,0xB882,0xB883,
0xB884,0xD6F1,0xF3C3,0xB885,0xB886,0xF3C4,0xB887,0xB8CD,
0xB888,0xB889,0xB88A,0xF3C6,0xF3C7,0xB88B,0xB0CA,0xB88C,
0xF3C5,0xB88D,0xF3C9,0xCBF1,0xB88E,0xB88F,0xB890,0xF3CB,
0xB891,0xD0A6,0xB892,0xB893,0xB1CA,0xF3C8,0xB894,0xB895,
0xB896,0xF3CF,0xB897,0xB5D1,0xB898,0xB899,0xF3D7,0xB89A,
0xF3D2,0xB89B,0xB89C,0xB89D,0xF3D4,0xF3D3,0xB7FB,0xB89E,
0xB1BF,0xB89F,0xF3CE,0xF3CA,0xB5DA,0xB8A0,0xF3D0,0xB940,
0xB941,0xF3D1,0xB942,0xF3D5,0xB943,0xB944,0xB945,0xB946,
0xF3CD,0xB947,0xBCE3,0xB948,0xC1FD,0xB949,0xF3D6,0xB94A,
0xB94B,0xB94C,0xB94D,0xB94E,0xB94F,0xF3DA,0xB950,0xF3CC,
0xB951,0xB5C8,0xB952,0xBDEE,0xF3DC,0xB953,0xB954,0xB7A4,
0xBFF0,0xD6FE,0xCDB2,0xB955,0xB4F0,0xB956,0xB2DF,0xB957,
0xF3D8,0xB958,0xF3D9,0xC9B8,0xB959,0xF3DD,0xB95A,0xB95B,
0xF3DE,0xB95C,0xF3E1,0xB95D,0xB95E,0xB95F,0xB960,0xB961,
0xB962,0xB963,0xB964,0xB965,0xB966,0xB967,0xF3DF,0xB968,
0xB969,0xF3E3,0xF3E2,0xB96A,0xB96B,0xF3DB,0xB96C,0xBFEA,
0xB96D,0xB3EF,0xB96E,0xF3E0,0xB96F,0xB970,0xC7A9,0xB971,
0xBCF2,0xB972,0xB973,0xB974,0xB975,0xF3EB,0xB976,0xB977,
0xB978,0xB979,0xB97A,0xB97B,0xB97C,0xB9BF,0xB97D,0xB97E,
0xF3E4,0xB980,0xB981,0xB982,0xB2AD,0xBBFE,0xB983,0xCBE3,
0xB984,0xB985,0xB986,0xB987,0xF3ED,0xF3E9,0xB988,0xB989,
0xB98A,0xB9DC,0xF3EE,0xB98B,0xB98C,0xB98D,0xF3E5,0xF3E6,
0xF3EA,0xC2E1,0xF3EC,0xF3EF,0xF3E8,0xBCFD,0xB98E,0xB98F,
0xB990,0xCFE4,0xB991,0xB992,0xF3F0,0xB993,0xB994,0xB995,
0xF3E7,0xB996,0xB997,0xB998,0xB999,0xB99A,0xB99B,0xB99C,
0xB99D,0xF3F2,0xB99E,0xB99F,0xB9A0,0xBA40,0xD7AD,0xC6AA,
0xBA41,0xBA42,0xBA43,0xBA44,0xF3F3,0xBA45,0xBA46,0xBA47,
0xBA48,0xF3F1,0xBA49,0xC2A8,0xBA4A,0xBA4B,0xBA4C,0xBA4D,
0xBA4E,0xB8DD,0xF3F5,0xBA4F,0xBA50,0xF3F4,0xBA51,0xBA52,
0xBA53,0xB4DB,0xBA54,0xBA55,0xBA56,0xF3F6,0xF3F7,0xBA57,
0xBA58,0xBA59,0xF3F8,0xBA5A,0xBA5B,0xBA5C,0xC0BA,0xBA5D,
0xBA5E,0xC0E9,0xBA5F,0xBA60,0xBA61,0xBA62,0xBA63,0xC5F1,
0xBA64,0xBA65,0xBA66,0xBA67,0xF3FB,0xBA68,0xF3FA,0xBA69,
0xBA6A,0xBA6B,0xBA6C,0xBA6D,0xBA6E,0xBA6F,0xBA70,0xB4D8,
0xBA71,0xBA72,0xBA73,0xF3FE,0xF3F9,0xBA74,0xBA75,0xF3FC,
0xBA76,0xBA77,0xBA78,0xBA79,0xBA7A,0xBA7B,0xF3FD,0xBA7C,
0xBA7D,0xBA7E,0xBA80,0xBA81,0xBA82,0xBA83,0xBA84,0xF4A1,
0xBA85,0xBA86,0xBA87,0xBA88,0xBA89,0xBA8A,0xF4A3,0xBBC9,
0xBA8B,0xBA8C,0xF4A2,0xBA8D,0xBA8E,0xBA8F,0xBA90,0xBA91,
0xBA92,0xBA93,0xBA94,0xBA95,0xBA96,0xBA97,0xBA98,0xBA99,
0xF4A4,0xBA9A,0xBA9B,0xBA9C,0xBA9D,0xBA9E,0xBA9F,0xB2BE,
0xF4A6,0xF4A5,0xBAA0,0xBB40,0xBB41,0xBB42,0xBB43,0xBB44,
0xBB45,0xBB46,0xBB47,0xBB48,0xBB49,0xBCAE,0xBB4A,0xBB4B,
0xBB4C,0xBB4D,0xBB4E,0xBB4F,0xBB50,0xBB51,0xBB52,0xBB53,
0xBB54,0xBB55,0xBB56,0xBB57,0xBB58,0xBB59,0xBB5A,0xBB5B,
0xBB5C,0xBB5D,0xBB5E,0xBB5F,0xBB60,0xBB61,0xBB62,0xBB63,
0xBB64,0xBB65,0xBB66,0xBB67,0xBB68,0xBB69,0xBB6A,0xBB6B,
0xBB6C,0xBB6D,0xBB6E,0xC3D7,0xD9E1,0xBB6F,0xBB70,0xBB71,
0xBB72,0xBB73,0xBB74,0xC0E0,0xF4CC,0xD7D1,0xBB75,0xBB76,
0xBB77,0xBB78,0xBB79,0xBB7A,0xBB7B,0xBB7C,0xBB7D,0xBB7E,
0xBB80,0xB7DB,0xBB81,0xBB82,0xBB83,0xBB84,0xBB85,0xBB86,
0xBB87,0xF4CE,0xC1A3,0xBB88,0xBB89,0xC6C9,0xBB8A,0xB4D6,
0xD5B3,0xBB8B,0xBB8C,0xBB8D,0xF4D0,0xF4CF,0xF4D1,0xCBDA,
0xBB8E,0xBB8F,0xF4D2,0xBB90,0xD4C1,0xD6E0,0xBB91,0xBB92,
0xBB93,0xBB94,0xB7E0,0xBB95,0xBB96,0xBB97,0xC1B8,0xBB98,
0xBB99,0xC1BB,0xF4D3,0xBEAC,0xBB9A,0xBB9B,0xBB9C,0xBB9D,
0xBB9E,0xB4E2,0xBB9F,0xBBA0,0xF4D4,0xF4D5,0xBEAB,0xBC40,
0xBC41,0xF4D6,0xBC42,0xBC43,0xBC44,0xF4DB,0xBC45,0xF4D7,
0xF4DA,0xBC46,0xBAFD,0xBC47,0xF4D8,0xF4D9,0xBC48,0xBC49,
0xBC4A,0xBC4B,0xBC4C,0xBC4D,0xBC4E,0xB8E2,0xCCC7,0xF4DC,
0xBC4F,0xB2DA,0xBC50,0xBC51,0xC3D3,0xBC52,0xBC53,0xD4E3,
0xBFB7,0xBC54,0xBC55,0xBC56,0xBC57,0xBC58,0xBC59,0xBC5A,
0xF4DD,0xBC5B,0xBC5C,0xBC5D,0xBC5E,0xBC5F,0xBC60,0xC5B4,
0xBC61,0xBC62,0xBC63,0xBC64,0xBC65,0xBC66,0xBC67,0xBC68,
0xF4E9,0xBC69,0xBC6A,0xCFB5,0xBC6B,0xBC6C,0xBC6D,0xBC6E,
0xBC6F,0xBC70,0xBC71,0xBC72,0xBC73,0xBC74,0xBC75,0xBC76,
0xBC77,0xBC78,0xCEC9,0xBC79,0xBC7A,0xBC7B,0xBC7C,0xBC7D,
0xBC7E,0xBC80,0xBC81,0xBC82,0xBC83,0xBC84,0xBC85,0xBC86,
0xBC87,0xBC88,0xBC89,0xBC8A,0xBC8B,0xBC8C,0xBC8D,0xBC8E,
0xCBD8,0xBC8F,0xCBF7,0xBC90,0xBC91,0xBC92,0xBC93,0xBDF4,
0xBC94,0xBC95,0xBC96,0xD7CF,0xBC97,0xBC98,0xBC99,0xC0DB,
0xBC9A,0xBC9B,0xBC9C,0xBC9D,0xBC9E,0xBC9F,0xBCA0,0xBD40,
0xBD41,0xBD42,0xBD43,0xBD44,0xBD45,0xBD46,0xBD47,0xBD48,
0xBD49,0xBD4A,0xBD4B,0xBD4C,0xBD4D,0xBD4E,0xBD4F,0xBD50,
0xBD51,0xBD52,0xBD53,0xBD54,0xBD55,0xBD56,0xBD57,0xBD58,
0xBD59,0xBD5A,0xBD5B,0xBD5C,0xBD5D,0xBD5E,0xBD5F,0xBD60,
0xBD61,0xBD62,0xBD63,0xBD64,0xBD65,0xBD66,0xBD67,0xBD68,
0xBD69,0xBD6A,0xBD6B,0xBD6C,0xBD6D,0xBD6E,0xBD6F,0xBD70,
0xBD71,0xBD72,0xBD73,0xBD74,0xBD75,0xBD76,0xD0F5,0xBD77,
0xBD78,0xBD79,0xBD7A,0xBD7B,0xBD7C,0xBD7D,0xBD7E,0xF4EA,
0xBD80,0xBD81,0xBD82,0xBD83,0xBD84,0xBD85,0xBD86,0xBD87,
0xBD88,0xBD89,0xBD8A,0xBD8B,0xBD8C,0xBD8D,0xBD8E,0xBD8F,
0xBD90,0xBD91,0xBD92,0xBD93,0xBD94,0xBD95,0xBD96,0xBD97,
0xBD98,0xBD99,0xBD9A,0xBD9B,0xBD9C,0xBD9D,0xBD9E,0xBD9F,
0xBDA0,0xBE40,0xBE41,0xBE42,0xBE43,0xBE44,0xBE45,0xBE46,
0xBE47,0xBE48,0xBE49,0xBE4A,0xBE4B,0xBE4C,0xF4EB,0xBE4D,
0xBE4E,0xBE4F,0xBE50,0xBE51,0xBE52,0xBE53,0xF4EC,0xBE54,
0xBE55,0xBE56,0xBE57,0xBE58,0xBE59,0xBE5A,0xBE5B,0xBE5C,
0xBE5D,0xBE5E,0xBE5F,0xBE60,0xBE61,0xBE62,0xBE63,0xBE64,
0xBE65,0xBE66,0xBE67,0xBE68,0xBE69,0xBE6A,0xBE6B,0xBE6C,
0xBE6D,0xBE6E,0xBE6F,0xBE70,0xBE71,0xBE72,0xBE73,0xBE74,
0xBE75,0xBE76,0xBE77,0xBE78,0xBE79,0xBE7A,0xBE7B,0xBE7C,
0xBE7D,0xBE7E,0xBE80,0xBE81,0xBE82,0xBE83,0xBE84,0xBE85,
0xBE86,0xBE87,0xBE88,0xBE89,0xBE8A,0xBE8B,0xBE8C,0xBE8D,
0xBE8E,0xBE8F,0xBE90,0xBE91,0xBE92,0xBE93,0xBE94,0xBE95,
0xBE96,0xBE97,0xBE98,0xBE99,0xBE9A,0xBE9B,0xBE9C,0xBE9D,
0xBE9E,0xBE9F,0xBEA0,0xBF40,0xBF41,0xBF42,0xBF43,0xBF44,
0xBF45,0xBF46,0xBF47,0xBF48,0xBF49,0xBF4A,0xBF4B,0xBF4C,
0xBF4D,0xBF4E,0xBF4F,0xBF50,0xBF51,0xBF52,0xBF53,0xBF54,
0xBF55,0xBF56,0xBF57,0xBF58,0xBF59,0xBF5A,0xBF5B,0xBF5C,
0xBF5D,0xBF5E,0xBF5F,0xBF60,0xBF61,0xBF62,0xBF63,0xBF64,
0xBF65,0xBF66,0xBF67,0xBF68,0xBF69,0xBF6A,0xBF6B,0xBF6C,
0xBF6D,0xBF6E,0xBF6F,0xBF70,0xBF71,0xBF72,0xBF73,0xBF74,
0xBF75,0xBF76,0xBF77,0xBF78,0xBF79,0xBF7A,0xBF7B,0xBF7C,
0xBF7D,0xBF7E,0xBF80,0xF7E3,0xBF81,0xBF82,0xBF83,0xBF84,
0xBF85,0xB7B1,0xBF86,0xBF87,0xBF88,0xBF89,0xBF8A,0xF4ED,
0xBF8B,0xBF8C,0xBF8D,0xBF8E,0xBF8F,0xBF90,0xBF91,0xBF92,
0xBF93,0xBF94,0xBF95,0xBF96,0xBF97,0xBF98,0xBF99,0xBF9A,
0xBF9B,0xBF9C,0xBF9D,0xBF9E,0xBF9F,0xBFA0,0xC040,0xC041,
0xC042,0xC043,0xC044,0xC045,0xC046,0xC047,0xC048,0xC049,
0xC04A,0xC04B,0xC04C,0xC04D,0xC04E,0xC04F,0xC050,0xC051,
0xC052,0xC053,0xC054,0xC055,0xC056,0xC057,0xC058,0xC059,
0xC05A,0xC05B,0xC05C,0xC05D,0xC05E,0xC05F,0xC060,0xC061,
0xC062,0xC063,0xD7EB,0xC064,0xC065,0xC066,0xC067,0xC068,
0xC069,0xC06A,0xC06B,0xC06C,0xC06D,0xC06E,0xC06F,0xC070,
0xC071,0xC072,0xC073,0xC074,0xC075,0xC076,0xC077,0xC078,
0xC079,0xC07A,0xC07B,0xF4EE,0xC07C,0xC07D,0xC07E,0xE6F9,
0xBEC0,0xE6FA,0xBAEC,0xE6FB,0xCFCB,0xE6FC,0xD4BC,0xBCB6,
0xE6FD,0xE6FE,0xBCCD,0xC8D2,0xCEB3,0xE7A1,0xC080,0xB4BF,
0xE7A2,0xC9B4,0xB8D9,0xC4C9,0xC081,0xD7DD,0xC2DA,0xB7D7,
0xD6BD,0xCEC6,0xB7C4,0xC082,0xC083,0xC5A6,0xE7A3,0xCFDF,
0xE7A4,0xE7A5,0xE7A6,0xC1B7,0xD7E9,0xC9F0,0xCFB8,0xD6AF,
0xD6D5,0xE7A7,0xB0ED,0xE7A8,0xE7A9,0xC9DC,0xD2EF,0xBEAD,
0xE7AA,0xB0F3,0xC8DE,0xBDE1,0xE7AB,0xC8C6,0xC084,0xE7AC,
0xBBE6,0xB8F8,0xD1A4,0xE7AD,0xC2E7,0xBEF8,0xBDCA,0xCDB3,
0xE7AE,0xE7AF,0xBEEE,0xD0E5,0xC085,0xCBE7,0xCCD0,0xBCCC,
0xE7B0,0xBCA8,0xD0F7,0xE7B1,0xC086,0xD0F8,0xE7B2,0xE7B3,
0xB4C2,0xE7B4,0xE7B5,0xC9FE,0xCEAC,0xC3E0,0xE7B7,0xB1C1,
0xB3F1,0xC087,0xE7B8,0xE7B9,0xD7DB,0xD5C0,0xE7BA,0xC2CC,
0xD7BA,0xE7BB,0xE7BC,0xE7BD,0xBCEA,0xC3E5,0xC0C2,0xE7BE,
0xE7BF,0xBCA9,0xC088,0xE7C0,0xE7C1,0xE7B6,0xB6D0,0xE7C2,
0xC089,0xE7C3,0xE7C4,0xBBBA,0xB5DE,0xC2C6,0xB1E0,0xE7C5,
0xD4B5,0xE7C6,0xB8BF,0xE7C8,0xE7C7,0xB7EC,0xC08A,0xE7C9,
0xB2F8,0xE7CA,0xE7CB,0xE7CC,0xE7CD,0xE7CE,0xE7CF,0xE7D0,
0xD3A7,0xCBF5,0xE7D1,0xE7D2,0xE7D3,0xE7D4,0xC9C9,0xE7D5,
0xE7D6,0xE7D7,0xE7D8,0xE7D9,0xBDC9,0xE7DA,0xF3BE,0xC08B,
0xB8D7,0xC08C,0xC8B1,0xC08D,0xC08E,0xC08F,0xC090,0xC091,
0xC092,0xC093,0xF3BF,0xC094,0xF3C0,0xF3C1,0xC095,0xC096,
0xC097,0xC098,0xC099,0xC09A,0xC09B,0xC09C,0xC09D,0xC09E,
0xB9DE,0xCDF8,0xC09F,0xC0A0,0xD8E8,0xBAB1,0xC140,0xC2DE,
0xEEB7,0xC141,0xB7A3,0xC142,0xC143,0xC144,0xC145,0xEEB9,
0xC146,0xEEB8,0xB0D5,0xC147,0xC148,0xC149,0xC14A,0xC14B,
0xEEBB,0xD5D6,0xD7EF,0xC14C,0xC14D,0xC14E,0xD6C3,0xC14F,
0xC150,0xEEBD,0xCAF0,0xC151,0xEEBC,0xC152,0xC153,0xC154,
0xC155,0xEEBE,0xC156,0xC157,0xC158,0xC159,0xEEC0,0xC15A,
0xC15B,0xEEBF,0xC15C,0xC15D,0xC15E,0xC15F,0xC160,0xC161,
0xC162,0xC163,0xD1F2,0xC164,0xC7BC,0xC165,0xC3C0,0xC166,
0xC167,0xC168,0xC169,0xC16A,0xB8E1,0xC16B,0xC16C,0xC16D,
0xC16E,0xC16F,0xC1E7,0xC170,0xC171,0xF4C6,0xD0DF,0xF4C7,
0xC172,0xCFDB,0xC173,0xC174,0xC8BA,0xC175,0xC176,0xF4C8,
0xC177,0xC178,0xC179,0xC17A,0xC17B,0xC17C,0xC17D,0xF4C9,
0xF4CA,0xC17E,0xF4CB,0xC180,0xC181,0xC182,0xC183,0xC184,
0xD9FA,0xB8FE,0xC185,0xC186,0xE5F1,0xD3F0,0xC187,0xF4E0,
0xC188,0xCECC,0xC189,0xC18A,0xC18B,0xB3E1,0xC18C,0xC18D,
0xC18E,0xC18F,0xF1B4,0xC190,0xD2EE,0xC191,0xF4E1,0xC192,
0xC193,0xC194,0xC195,0xC196,0xCFE8,0xF4E2,0xC197,0xC198,
0xC7CC,0xC199,0xC19A,0xC19B,0xC19C,0xC19D,0xC19E,0xB5D4,
0xB4E4,0xF4E4,0xC19F,0xC1A0,0xC240,0xF4E3,0xF4E5,0xC241,
0xC242,0xF4E6,0xC243,0xC244,0xC245,0xC246,0xF4E7,0xC247,
0xBAB2,0xB0BF,0xC248,0xF4E8,0xC249,0xC24A,0xC24B,0xC24C,
0xC24D,0xC24E,0xC24F,0xB7AD,0xD2ED,0xC250,0xC251,0xC252,
0xD2AB,0xC0CF,0xC253,0xBFBC,0xEBA3,0xD5DF,0xEAC8,0xC254,
0xC255,0xC256,0xC257,0xF1F3,0xB6F8,0xCBA3,0xC258,0xC259,
0xC4CD,0xC25A,0xF1E7,0xC25B,0xF1E8,0xB8FB,0xF1E9,0xBAC4,
0xD4C5,0xB0D2,0xC25C,0xC25D,0xF1EA,0xC25E,0xC25F,0xC260,
0xF1EB,0xC261,0xF1EC,0xC262,0xC263,0xF1ED,0xF1EE,0xF1EF,
0xF1F1,0xF1F0,0xC5D5,0xC264,0xC265,0xC266,0xC267,0xC268,
0xC269,0xF1F2,0xC26A,0xB6FA,0xC26B,0xF1F4,0xD2AE,0xDEC7,
0xCBCA,0xC26C,0xC26D,0xB3DC,0xC26E,0xB5A2,0xC26F,0xB9A2,
0xC270,0xC271,0xC4F4,0xF1F5,0xC272,0xC273,0xF1F6,0xC274,
0xC275,0xC276,0xC1C4,0xC1FB,0xD6B0,0xF1F7,0xC277,0xC278,
0xC279,0xC27A,0xF1F8,0xC27B,0xC1AA,0xC27C,0xC27D,0xC27E,
0xC6B8,0xC280,0xBEDB,0xC281,0xC282,0xC283,0xC284,0xC285,
0xC286,0xC287,0xC288,0xC289,0xC28A,0xC28B,0xC28C,0xC28D,
0xC28E,0xF1F9,0xB4CF,0xC28F,0xC290,0xC291,0xC292,0xC293,
0xC294,0xF1FA,0xC295,0xC296,0xC297,0xC298,0xC299,0xC29A,
0xC29B,0xC29C,0xC29D,0xC29E,0xC29F,0xC2A0,0xC340,0xEDB2,
0xEDB1,0xC341,0xC342,0xCBE0,0xD2DE,0xC343,0xCBC1,0xD5D8,
0xC344,0xC8E2,0xC345,0xC0DF,0xBCA1,0xC346,0xC347,0xC348,
0xC349,0xC34A,0xC34B,0xEBC1,0xC34C,0xC34D,0xD0A4,0xC34E,
0xD6E2,0xC34F,0xB6C7,0xB8D8,0xEBC0,0xB8CE,0xC350,0xEBBF,
0xB3A6,0xB9C9,0xD6AB,0xC351,0xB7F4,0xB7CA,0xC352,0xC353,
0xC354,0xBCE7,0xB7BE,0xEBC6,0xC355,0xEBC7,0xB0B9,0xBFCF,
0xC356,0xEBC5,0xD3FD,0xC357,0xEBC8,0xC358,0xC359,0xEBC9,
0xC35A,0xC35B,0xB7CE,0xC35C,0xEBC2,0xEBC4,0xC9F6,0xD6D7,
0xD5CD,0xD0B2,0xEBCF,0xCEB8,0xEBD0,0xC35D,0xB5A8,0xC35E,
0xC35F,0xC360,0xC361,0xC362,0xB1B3,0xEBD2,0xCCA5,0xC363,
0xC364,0xC365,0xC366,0xC367,0xC368,0xC369,0xC5D6,0xEBD3,
0xC36A,0xEBD1,0xC5DF,0xEBCE,0xCAA4,0xEBD5,0xB0FB,0xC36B,
0xC36C,0xBAFA,0xC36D,0xC36E,0xD8B7,0xF1E3,0xC36F,0xEBCA,
0xEBCB,0xEBCC,0xEBCD,0xEBD6,0xE6C0,0xEBD9,0xC370,0xBFE8,
0xD2C8,0xEBD7,0xEBDC,0xB8EC,0xEBD8,0xC371,0xBDBA,0xC372,
0xD0D8,0xC373,0xB0B7,0xC374,0xEBDD,0xC4DC,0xC375,0xC376,
0xC377,0xC378,0xD6AC,0xC379,0xC37A,0xC37B,0xB4E0,0xC37C,
0xC37D,0xC2F6,0xBCB9,0xC37E,0xC380,0xEBDA,0xEBDB,0xD4E0,
0xC6EA,0xC4D4,0xEBDF,0xC5A7,0xD9F5,0xC381,0xB2B1,0xC382,
0xEBE4,0xC383,0xBDC5,0xC384,0xC385,0xC386,0xEBE2,0xC387,
0xC388,0xC389,0xC38A,0xC38B,0xC38C,0xC38D,0xC38E,0xC38F,
0xC390,0xC391,0xC392,0xC393,0xEBE3,0xC394,0xC395,0xB8AC,
0xC396,0xCDD1,0xEBE5,0xC397,0xC398,0xC399,0xEBE1,0xC39A,
0xC1B3,0xC39B,0xC39C,0xC39D,0xC39E,0xC39F,0xC6A2,0xC3A0,
0xC440,0xC441,0xC442,0xC443,0xC444,0xC445,0xCCF3,0xC446,
0xEBE6,0xC447,0xC0B0,0xD2B8,0xEBE7,0xC448,0xC449,0xC44A,
0xB8AF,0xB8AD,0xC44B,0xEBE8,0xC7BB,0xCDF3,0xC44C,0xC44D,
0xC44E,0xEBEA,0xEBEB,0xC44F,0xC450,0xC451,0xC452,0xC453,
0xEBED,0xC454,0xC455,0xC456,0xC457,0xD0C8,0xC458,0xEBF2,
0xC459,0xEBEE,0xC45A,0xC45B,0xC45C,0xEBF1,0xC8F9,0xC45D,
0xD1FC,0xEBEC,0xC45E,0xC45F,0xEBE9,0xC460,0xC461,0xC462,
0xC463,0xB8B9,0xCFD9,0xC4E5,0xEBEF,0xEBF0,0xCCDA,0xCDC8,
0xB0F2,0xC464,0xEBF6,0xC465,0xC466,0xC467,0xC468,0xC469,
0xEBF5,0xC46A,0xB2B2,0xC46B,0xC46C,0xC46D,0xC46E,0xB8E0,
0xC46F,0xEBF7,0xC470,0xC471,0xC472,0xC473,0xC474,0xC475,
0xB1EC,0xC476,0xC477,0xCCC5,0xC4A4,0xCFA5,0xC478,0xC479,
0xC47A,0xC47B,0xC47C,0xEBF9,0xC47D,0xC47E,0xECA2,0xC480,
0xC5F2,0xC481,0xEBFA,0xC482,0xC483,0xC484,0xC485,0xC486,
0xC487,0xC488,0xC489,0xC9C5,0xC48A,0xC48B,0xC48C,0xC48D,
0xC48E,0xC48F,0xE2DF,0xEBFE,0xC490,0xC491,0xC492,0xC493,
0xCDCE,0xECA1,0xB1DB,0xD3B7,0xC494,0xC495,0xD2DC,0xC496,
0xC497,0xC498,0xEBFD,0xC499,0xEBFB,0xC49A,0xC49B,0xC49C,
0xC49D,0xC49E,0xC49F,0xC4A0,0xC540,0xC541,0xC542,0xC543,
0xC544,0xC545,0xC546,0xC547,0xC548,0xC549,0xC54A,0xC54B,
0xC54C,0xC54D,0xC54E,0xB3BC,0xC54F,0xC550,0xC551,0xEAB0,
0xC552,0xC553,0xD7D4,0xC554,0xF4AB,0xB3F4,0xC555,0xC556,
0xC557,0xC558,0xC559,0xD6C1,0xD6C2,0xC55A,0xC55B,0xC55C,
0xC55D,0xC55E,0xC55F,0xD5E9,0xBECA,0xC560,0xF4A7,0xC561,
0xD2A8,0xF4A8,0xF4A9,0xC562,0xF4AA,0xBECB,0xD3DF,0xC563,
0xC564,0xC565,0xC566,0xC567,0xC9E0,0xC9E1,0xC568,0xC569,
0xF3C2,0xC56A,0xCAE6,0xC56B,0xCCF2,0xC56C,0xC56D,0xC56E,
0xC56F,0xC570,0xC571,0xE2B6,0xCBB4,0xC572,0xCEE8,0xD6DB,
0xC573,0xF4AD,0xF4AE,0xF4AF,0xC574,0xC575,0xC576,0xC577,
0xF4B2,0xC578,0xBABD,0xF4B3,0xB0E3,0xF4B0,0xC579,0xF4B1,
0xBDA2,0xB2D5,0xC57A,0xF4B6,0xF4B7,0xB6E6,0xB2B0,0xCFCF,
0xF4B4,0xB4AC,0xC57B,0xF4B5,0xC57C,0xC57D,0xF4B8,0xC57E,
0xC580,0xC581,0xC582,0xC583,0xF4B9,0xC584,0xC585,0xCDA7,
0xC586,0xF4BA,0xC587,0xF4BB,0xC588,0xC589,0xC58A,0xF4BC,
0xC58B,0xC58C,0xC58D,0xC58E,0xC58F,0xC590,0xC591,0xC592,
0xCBD2,0xC593,0xF4BD,0xC594,0xC595,0xC596,0xC597,0xF4BE,
0xC598,0xC599,0xC59A,0xC59B,0xC59C,0xC59D,0xC59E,0xC59F,
0xF4BF,0xC5A0,0xC640,0xC641,0xC642,0xC643,0xF4DE,0xC1BC,
0xBCE8,0xC644,0xC9AB,0xD1DE,0xE5F5,0xC645,0xC646,0xC647,
0xC648,0xDCB3,0xD2D5,0xC649,0xC64A,0xDCB4,0xB0AC,0xDCB5,
0xC64B,0xC64C,0xBDDA,0xC64D,0xDCB9,0xC64E,0xC64F,0xC650,
0xD8C2,0xC651,0xDCB7,0xD3F3,0xC652,0xC9D6,0xDCBA,0xDCB6,
0xC653,0xDCBB,0xC3A2,0xC654,0xC655,0xC656,0xC657,0xDCBC,
0xDCC5,0xDCBD,0xC658,0xC659,0xCEDF,0xD6A5,0xC65A,0xDCCF,
0xC65B,0xDCCD,0xC65C,0xC65D,0xDCD2,0xBDE6,0xC2AB,0xC65E,
0xDCB8,0xDCCB,0xDCCE,0xDCBE,0xB7D2,0xB0C5,0xDCC7,0xD0BE,
0xDCC1,0xBBA8,0xC65F,0xB7BC,0xDCCC,0xC660,0xC661,0xDCC6,
0xDCBF,0xC7DB,0xC662,0xC663,0xC664,0xD1BF,0xDCC0,0xC665,
0xC666,0xDCCA,0xC667,0xC668,0xDCD0,0xC669,0xC66A,0xCEAD,
0xDCC2,0xC66B,0xDCC3,0xDCC8,0xDCC9,0xB2D4,0xDCD1,0xCBD5,
0xC66C,0xD4B7,0xDCDB,0xDCDF,0xCCA6,0xDCE6,0xC66D,0xC3E7,
0xDCDC,0xC66E,0xC66F,0xBFC1,0xDCD9,0xC670,0xB0FA,0xB9B6,
0xDCE5,0xDCD3,0xC671,0xDCC4,0xDCD6,0xC8F4,0xBFE0,0xC672,
0xC673,0xC674,0xC675,0xC9BB,0xC676,0xC677,0xC678,0xB1BD,
0xC679,0xD3A2,0xC67A,0xC67B,0xDCDA,0xC67C,0xC67D,0xDCD5,
0xC67E,0xC6BB,0xC680,0xDCDE,0xC681,0xC682,0xC683,0xC684,
0xC685,0xD7C2,0xC3AF,0xB7B6,0xC7D1,0xC3A9,0xDCE2,0xDCD8,
0xDCEB,0xDCD4,0xC686,0xC687,0xDCDD,0xC688,0xBEA5,0xDCD7,
0xC689,0xDCE0,0xC68A,0xC68B,0xDCE3,0xDCE4,0xC68C,0xDCF8,
0xC68D,0xC68E,0xDCE1,0xDDA2,0xDCE7,0xC68F,0xC690,0xC691,
0xC692,0xC693,0xC694,0xC695,0xC696,0xC697,0xC698,0xBCEB,
0xB4C4,0xC699,0xC69A,0xC3A3,0xB2E7,0xDCFA,0xC69B,0xDCF2,
0xC69C,0xDCEF,0xC69D,0xDCFC,0xDCEE,0xD2F0,0xB2E8,0xC69E,
0xC8D7,0xC8E3,0xDCFB,0xC69F,0xDCED,0xC6A0,0xC740,0xC741,
0xDCF7,0xC742,0xC743,0xDCF5,0xC744,0xC745,0xBEA3,0xDCF4,
0xC746,0xB2DD,0xC747,0xC748,0xC749,0xC74A,0xC74B,0xDCF3,
0xBCF6,0xDCE8,0xBBC4,0xC74C,0xC0F3,0xC74D,0xC74E,0xC74F,
0xC750,0xC751,0xBCD4,0xDCE9,0xDCEA,0xC752,0xDCF1,0xDCF6,
0xDCF9,0xB5B4,0xC753,0xC8D9,0xBBE7,0xDCFE,0xDCFD,0xD3AB,
0xDDA1,0xDDA3,0xDDA5,0xD2F1,0xDDA4,0xDDA6,0xDDA7,0xD2A9,
0xC754,0xC755,0xC756,0xC757,0xC758,0xC759,0xC75A,0xBAC9,
0xDDA9,0xC75B,0xC75C,0xDDB6,0xDDB1,0xDDB4,0xC75D,0xC75E,
0xC75F,0xC760,0xC761,0xC762,0xC763,0xDDB0,0xC6CE,0xC764,
0xC765,0xC0F2,0xC766,0xC767,0xC768,0xC769,0xC9AF,0xC76A,
0xC76B,0xC76C,0xDCEC,0xDDAE,0xC76D,0xC76E,0xC76F,0xC770,
0xDDB7,0xC771,0xC772,0xDCF0,0xDDAF,0xC773,0xDDB8,0xC774,
0xDDAC,0xC775,0xC776,0xC777,0xC778,0xC779,0xC77A,0xC77B,
0xDDB9,0xDDB3,0xDDAD,0xC4AA,0xC77C,0xC77D,0xC77E,0xC780,
0xDDA8,0xC0B3,0xC1AB,0xDDAA,0xDDAB,0xC781,0xDDB2,0xBBF1,
0xDDB5,0xD3A8,0xDDBA,0xC782,0xDDBB,0xC3A7,0xC783,0xC784,
0xDDD2,0xDDBC,0xC785,0xC786,0xC787,0xDDD1,0xC788,0xB9BD,
0xC789,0xC78A,0xBED5,0xC78B,0xBEFA,0xC78C,0xC78D,0xBACA,
0xC78E,0xC78F,0xC790,0xC791,0xDDCA,0xC792,0xDDC5,0xC793,
0xDDBF,0xC794,0xC795,0xC796,0xB2CB,0xDDC3,0xC797,0xDDCB,
0xB2A4,0xDDD5,0xC798,0xC799,0xC79A,0xDDBE,0xC79B,0xC79C,
0xC79D,0xC6D0,0xDDD0,0xC79E,0xC79F,0xC7A0,0xC840,0xC841,
0xDDD4,0xC1E2,0xB7C6,0xC842,0xC843,0xC844,0xC845,0xC846,
0xDDCE,0xDDCF,0xC847,0xC848,0xC849,0xDDC4,0xC84A,0xC84B,
0xC84C,0xDDBD,0xC84D,0xDDCD,0xCCD1,0xC84E,0xDDC9,0xC84F,
0xC850,0xC851,0xC852,0xDDC2,0xC3C8,0xC6BC,0xCEAE,0xDDCC,
0xC853,0xDDC8,0xC854,0xC855,0xC856,0xC857,0xC858,0xC859,
0xDDC1,0xC85A,0xC85B,0xC85C,0xDDC6,0xC2DC,0xC85D,0xC85E,
0xC85F,0xC860,0xC861,0xC862,0xD3A9,0xD3AA,0xDDD3,0xCFF4,
0xC8F8,0xC863,0xC864,0xC865,0xC866,0xC867,0xC868,0xC869,
0xC86A,0xDDE6,0xC86B,0xC86C,0xC86D,0xC86E,0xC86F,0xC870,
0xDDC7,0xC871,0xC872,0xC873,0xDDE0,0xC2E4,0xC874,0xC875,
0xC876,0xC877,0xC878,0xC879,0xC87A,0xC87B,0xDDE1,0xC87C,
0xC87D,0xC87E,0xC880,0xC881,0xC882,0xC883,0xC884,0xC885,
0xC886,0xDDD7,0xC887,0xC888,0xC889,0xC88A,0xC88B,0xD6F8,
0xC88C,0xDDD9,0xDDD8,0xB8F0,0xDDD6,0xC88D,0xC88E,0xC88F,
0xC890,0xC6CF,0xC891,0xB6AD,0xC892,0xC893,0xC894,0xC895,
0xC896,0xDDE2,0xC897,0xBAF9,0xD4E1,0xDDE7,0xC898,0xC899,
0xC89A,0xB4D0,0xC89B,0xDDDA,0xC89C,0xBFFB,0xDDE3,0xC89D,
0xDDDF,0xC89E,0xDDDD,0xC89F,0xC8A0,0xC940,0xC941,0xC942,
0xC943,0xC944,0xB5D9,0xC945,0xC946,0xC947,0xC948,0xDDDB,
0xDDDC,0xDDDE,0xC949,0xBDAF,0xDDE4,0xC94A,0xDDE5,0xC94B,
0xC94C,0xC94D,0xC94E,0xC94F,0xC950,0xC951,0xC952,0xDDF5,
0xC953,0xC3C9,0xC954,0xC955,0xCBE2,0xC956,0xC957,0xC958,
0xC959,0xDDF2,0xC95A,0xC95B,0xC95C,0xC95D,0xC95E,0xC95F,
0xC960,0xC961,0xC962,0xC963,0xC964,0xC965,0xC966,0xD8E1,
0xC967,0xC968,0xC6D1,0xC969,0xDDF4,0xC96A,0xC96B,0xC96C,
0xD5F4,0xDDF3,0xDDF0,0xC96D,0xC96E,0xDDEC,0xC96F,0xDDEF,
0xC970,0xDDE8,0xC971,0xC972,0xD0EE,0xC973,0xC974,0xC975,
0xC976,0xC8D8,0xDDEE,0xC977,0xC978,0xDDE9,0xC979,0xC97A,
0xDDEA,0xCBF2,0xC97B,0xDDED,0xC97C,0xC97D,0xB1CD,0xC97E,
0xC980,0xC981,0xC982,0xC983,0xC984,0xC0B6,0xC985,0xBCBB,
0xDDF1,0xC986,0xC987,0xDDF7,0xC988,0xDDF6,0xDDEB,0xC989,
0xC98A,0xC98B,0xC98C,0xC98D,0xC5EE,0xC98E,0xC98F,0xC990,
0xDDFB,0xC991,0xC992,0xC993,0xC994,0xC995,0xC996,0xC997,
0xC998,0xC999,0xC99A,0xC99B,0xDEA4,0xC99C,0xC99D,0xDEA3,
0xC99E,0xC99F,0xC9A0,0xCA40,0xCA41,0xCA42,0xCA43,0xCA44,
0xCA45,0xCA46,0xCA47,0xCA48,0xDDF8,0xCA49,0xCA4A,0xCA4B,
0xCA4C,0xC3EF,0xCA4D,0xC2FB,0xCA4E,0xCA4F,0xCA50,0xD5E1,
0xCA51,0xCA52,0xCEB5,0xCA53,0xCA54,0xCA55,0xCA56,0xDDFD,
0xCA57,0xB2CC,0xCA58,0xCA59,0xCA5A,0xCA5B,0xCA5C,0xCA5D,
0xCA5E,0xCA5F,0xCA60,0xC4E8,0xCADF,0xCA61,0xCA62,0xCA63,
0xCA64,0xCA65,0xCA66,0xCA67,0xCA68,0xCA69,0xCA6A,0xC7BE,
0xDDFA,0xDDFC,0xDDFE,0xDEA2,0xB0AA,0xB1CE,0xCA6B,0xCA6C,
0xCA6D,0xCA6E,0xCA6F,0xDEAC,0xCA70,0xCA71,0xCA72,0xCA73,
0xDEA6,0xBDB6,0xC8EF,0xCA74,0xCA75,0xCA76,0xCA77,0xCA78,
0xCA79,0xCA7A,0xCA7B,0xCA7C,0xCA7D,0xCA7E,0xDEA1,0xCA80,
0xCA81,0xDEA5,0xCA82,0xCA83,0xCA84,0xCA85,0xDEA9,0xCA86,
0xCA87,0xCA88,0xCA89,0xCA8A,0xDEA8,0xCA8B,0xCA8C,0xCA8D,
0xDEA7,0xCA8E,0xCA8F,0xCA90,0xCA91,0xCA92,0xCA93,0xCA94,
0xCA95,0xCA96,0xDEAD,0xCA97,0xD4CC,0xCA98,0xCA99,0xCA9A,
0xCA9B,0xDEB3,0xDEAA,0xDEAE,0xCA9C,0xCA9D,0xC0D9,0xCA9E,
0xCA9F,0xCAA0,0xCB40,0xCB41,0xB1A1,0xDEB6,0xCB42,0xDEB1,
0xCB43,0xCB44,0xCB45,0xCB46,0xCB47,0xCB48,0xCB49,0xDEB2,
0xCB4A,0xCB4B,0xCB4C,0xCB4D,0xCB4E,0xCB4F,0xCB50,0xCB51,
0xCB52,0xCB53,0xCB54,0xD1A6,0xDEB5,0xCB55,0xCB56,0xCB57,
0xCB58,0xCB59,0xCB5A,0xCB5B,0xDEAF,0xCB5C,0xCB5D,0xCB5E,
0xDEB0,0xCB5F,0xD0BD,0xCB60,0xCB61,0xCB62,0xDEB4,0xCAED,
0xDEB9,0xCB63,0xCB64,0xCB65,0xCB66,0xCB67,0xCB68,0xDEB8,
0xCB69,0xDEB7,0xCB6A,0xCB6B,0xCB6C,0xCB6D,0xCB6E,0xCB6F,
0xCB70,0xDEBB,0xCB71,0xCB72,0xCB73,0xCB74,0xCB75,0xCB76,
0xCB77,0xBDE5,0xCB78,0xCB79,0xCB7A,0xCB7B,0xCB7C,0xB2D8,
0xC3EA,0xCB7D,0xCB7E,0xDEBA,0xCB80,0xC5BA,0xCB81,0xCB82,
0xCB83,0xCB84,0xCB85,0xCB86,0xDEBC,0xCB87,0xCB88,0xCB89,
0xCB8A,0xCB8B,0xCB8C,0xCB8D,0xCCD9,0xCB8E,0xCB8F,0xCB90,
0xCB91,0xB7AA,0xCB92,0xCB93,0xCB94,0xCB95,0xCB96,0xCB97,
0xCB98,0xCB99,0xCB9A,0xCB9B,0xCB9C,0xCB9D,0xCB9E,0xCB9F,
0xCBA0,0xCC40,0xCC41,0xD4E5,0xCC42,0xCC43,0xCC44,0xDEBD,
0xCC45,0xCC46,0xCC47,0xCC48,0xCC49,0xDEBF,0xCC4A,0xCC4B,
0xCC4C,0xCC4D,0xCC4E,0xCC4F,0xCC50,0xCC51,0xCC52,0xCC53,
0xCC54,0xC4A2,0xCC55,0xCC56,0xCC57,0xCC58,0xDEC1,0xCC59,
0xCC5A,0xCC5B,0xCC5C,0xCC5D,0xCC5E,0xCC5F,0xCC60,0xCC61,
0xCC62,0xCC63,0xCC64,0xCC65,0xCC66,0xCC67,0xCC68,0xDEBE,
0xCC69,0xDEC0,0xCC6A,0xCC6B,0xCC6C,0xCC6D,0xCC6E,0xCC6F,
0xCC70,0xCC71,0xCC72,0xCC73,0xCC74,0xCC75,0xCC76,0xCC77,
0xD5BA,0xCC78,0xCC79,0xCC7A,0xDEC2,0xCC7B,0xCC7C,0xCC7D,
0xCC7E,0xCC80,0xCC81,0xCC82,0xCC83,0xCC84,0xCC85,0xCC86,
0xCC87,0xCC88,0xCC89,0xCC8A,0xCC8B,0xF2AE,0xBBA2,0xC2B2,
0xC5B0,0xC2C7,0xCC8C,0xCC8D,0xF2AF,0xCC8E,0xCC8F,0xCC90,
0xCC91,0xCC92,0xD0E9,0xCC93,0xCC94,0xCC95,0xD3DD,0xCC96,
0xCC97,0xCC98,0xEBBD,0xCC99,0xCC9A,0xCC9B,0xCC9C,0xCC9D,
0xCC9E,0xCC9F,0xCCA0,0xB3E6,0xF2B0,0xCD40,0xF2B1,0xCD41,
0xCD42,0xCAAD,0xCD43,0xCD44,0xCD45,0xCD46,0xCD47,0xCD48,
0xCD49,0xBAE7,0xF2B3,0xF2B5,0xF2B4,0xCBE4,0xCFBA,0xF2B2,
0xCAB4,0xD2CF,0xC2EC,0xCD4A,0xCD4B,0xCD4C,0xCD4D,0xCD4E,
0xCD4F,0xCD50,0xCEC3,0xF2B8,0xB0F6,0xF2B7,0xCD51,0xCD52,
0xCD53,0xCD54,0xCD55,0xF2BE,0xCD56,0xB2CF,0xCD57,0xCD58,
0xCD59,0xCD5A,0xCD5B,0xCD5C,0xD1C1,0xF2BA,0xCD5D,0xCD5E,
0xCD5F,0xCD60,0xCD61,0xF2BC,0xD4E9,0xCD62,0xCD63,0xF2BB,
0xF2B6,0xF2BF,0xF2BD,0xCD64,0xF2B9,0xCD65,0xCD66,0xF2C7,
0xF2C4,0xF2C6,0xCD67,0xCD68,0xF2CA,0xF2C2,0xF2C0,0xCD69,
0xCD6A,0xCD6B,0xF2C5,0xCD6C,0xCD6D,0xCD6E,0xCD6F,0xCD70,
0xD6FB,0xCD71,0xCD72,0xCD73,0xF2C1,0xCD74,0xC7F9,0xC9DF,
0xCD75,0xF2C8,0xB9C6,0xB5B0,0xCD76,0xCD77,0xF2C3,0xF2C9,
0xF2D0,0xF2D6,0xCD78,0xCD79,0xBBD7,0xCD7A,0xCD7B,0xCD7C,
0xF2D5,0xCDDC,0xCD7D,0xD6EB,0xCD7E,0xCD80,0xF2D2,0xF2D4,
0xCD81,0xCD82,0xCD83,0xCD84,0xB8F2,0xCD85,0xCD86,0xCD87,
0xCD88,0xF2CB,0xCD89,0xCD8A,0xCD8B,0xF2CE,0xC2F9,0xCD8C,
0xD5DD,0xF2CC,0xF2CD,0xF2CF,0xF2D3,0xCD8D,0xCD8E,0xCD8F,
0xF2D9,0xD3BC,0xCD90,0xCD91,0xCD92,0xCD93,0xB6EA,0xCD94,
0xCAF1,0xCD95,0xB7E4,0xF2D7,0xCD96,0xCD97,0xCD98,0xF2D8,
0xF2DA,0xF2DD,0xF2DB,0xCD99,0xCD9A,0xF2DC,0xCD9B,0xCD9C,
0xCD9D,0xCD9E,0xD1D1,0xF2D1,0xCD9F,0xCDC9,0xCDA0,0xCECF,
0xD6A9,0xCE40,0xF2E3,0xCE41,0xC3DB,0xCE42,0xF2E0,0xCE43,
0xCE44,0xC0AF,0xF2EC,0xF2DE,0xCE45,0xF2E1,0xCE46,0xCE47,
0xCE48,0xF2E8,0xCE49,0xCE4A,0xCE4B,0xCE4C,0xF2E2,0xCE4D,
0xCE4E,0xF2E7,0xCE4F,0xCE50,0xF2E6,0xCE51,0xCE52,0xF2E9,
0xCE53,0xCE54,0xCE55,0xF2DF,0xCE56,0xCE57,0xF2E4,0xF2EA,
0xCE58,0xCE59,0xCE5A,0xCE5B,0xCE5C,0xCE5D,0xCE5E,0xD3AC,
0xF2E5,0xB2F5,0xCE5F,0xCE60,0xF2F2,0xCE61,0xD0AB,0xCE62,
0xCE63,0xCE64,0xCE65,0xF2F5,0xCE66,0xCE67,0xCE68,0xBBC8,
0xCE69,0xF2F9,0xCE6A,0xCE6B,0xCE6C,0xCE6D,0xCE6E,0xCE6F,
0xF2F0,0xCE70,0xCE71,0xF2F6,0xF2F8,0xF2FA,0xCE72,0xCE73,
0xCE74,0xCE75,0xCE76,0xCE77,0xCE78,0xCE79,0xF2F3,0xCE7A,
0xF2F1,0xCE7B,0xCE7C,0xCE7D,0xBAFB,0xCE7E,0xB5FB,0xCE80,
0xCE81,0xCE82,0xCE83,0xF2EF,0xF2F7,0xF2ED,0xF2EE,0xCE84,
0xCE85,0xCE86,0xF2EB,0xF3A6,0xCE87,0xF3A3,0xCE88,0xCE89,
0xF3A2,0xCE8A,0xCE8B,0xF2F4,0xCE8C,0xC8DA,0xCE8D,0xCE8E,
0xCE8F,0xCE90,0xCE91,0xF2FB,0xCE92,0xCE93,0xCE94,0xF3A5,
0xCE95,0xCE96,0xCE97,0xCE98,0xCE99,0xCE9A,0xCE9B,0xC3F8,
0xCE9C,0xCE9D,0xCE9E,0xCE9F,0xCEA0,0xCF40,0xCF41,0xCF42,
0xF2FD,0xCF43,0xCF44,0xF3A7,0xF3A9,0xF3A4,0xCF45,0xF2FC,
0xCF46,0xCF47,0xCF48,0xF3AB,0xCF49,0xF3AA,0xCF4A,0xCF4B,
0xCF4C,0xCF4D,0xC2DD,0xCF4E,0xCF4F,0xF3AE,0xCF50,0xCF51,
0xF3B0,0xCF52,0xCF53,0xCF54,0xCF55,0xCF56,0xF3A1,0xCF57,
0xCF58,0xCF59,0xF3B1,0xF3AC,0xCF5A,0xCF5B,0xCF5C,0xCF5D,
0xCF5E,0xF3AF,0xF2FE,0xF3AD,0xCF5F,0xCF60,0xCF61,0xCF62,
0xCF63,0xCF64,0xCF65,0xF3B2,0xCF66,0xCF67,0xCF68,0xCF69,
0xF3B4,0xCF6A,0xCF6B,0xCF6C,0xCF6D,0xF3A8,0xCF6E,0xCF6F,
0xCF70,0xCF71,0xF3B3,0xCF72,0xCF73,0xCF74,0xF3B5,0xCF75,
0xCF76,0xCF77,0xCF78,0xCF79,0xCF7A,0xCF7B,0xCF7C,0xCF7D,
0xCF7E,0xD0B7,0xCF80,0xCF81,0xCF82,0xCF83,0xF3B8,0xCF84,
0xCF85,0xCF86,0xCF87,0xD9F9,0xCF88,0xCF89,0xCF8A,0xCF8B,
0xCF8C,0xCF8D,0xF3B9,0xCF8E,0xCF8F,0xCF90,0xCF91,0xCF92,
0xCF93,0xCF94,0xCF95,0xF3B7,0xCF96,0xC8E4,0xF3B6,0xCF97,
0xCF98,0xCF99,0xCF9A,0xF3BA,0xCF9B,0xCF9C,0xCF9D,0xCF9E,
0xCF9F,0xF3BB,0xB4C0,0xCFA0,0xD040,0xD041,0xD042,0xD043,
0xD044,0xD045,0xD046,0xD047,0xD048,0xD049,0xD04A,0xD04B,
0xD04C,0xD04D,0xEEC3,0xD04E,0xD04F,0xD050,0xD051,0xD052,
0xD053,0xF3BC,0xD054,0xD055,0xF3BD,0xD056,0xD057,0xD058,
0xD1AA,0xD059,0xD05A,0xD05B,0xF4AC,0xD0C6,0xD05C,0xD05D,
0xD05E,0xD05F,0xD060,0xD061,0xD0D0,0xD1DC,0xD062,0xD063,
0xD064,0xD065,0xD066,0xD067,0xCFCE,0xD068,0xD069,0xBDD6,
0xD06A,0xD1C3,0xD06B,0xD06C,0xD06D,0xD06E,0xD06F,0xD070,
0xD071,0xBAE2,0xE1E9,0xD2C2,0xF1C2,0xB2B9,0xD072,0xD073,
0xB1ED,0xF1C3,0xD074,0xC9C0,0xB3C4,0xD075,0xD9F2,0xD076,
0xCBA5,0xD077,0xF1C4,0xD078,0xD079,0xD07A,0xD07B,0xD6D4,
0xD07C,0xD07D,0xD07E,0xD080,0xD081,0xF1C5,0xF4C0,0xF1C6,
0xD082,0xD4AC,0xF1C7,0xD083,0xB0C0,0xF4C1,0xD084,0xD085,
0xF4C2,0xD086,0xD087,0xB4FC,0xD088,0xC5DB,0xD089,0xD08A,
0xD08B,0xD08C,0xCCBB,0xD08D,0xD08E,0xD08F,0xD0E4,0xD090,
0xD091,0xD092,0xD093,0xD094,0xCDE0,0xD095,0xD096,0xD097,
0xD098,0xD099,0xF1C8,0xD09A,0xD9F3,0xD09B,0xD09C,0xD09D,
0xD09E,0xD09F,0xD0A0,0xB1BB,0xD140,0xCFAE,0xD141,0xD142,
0xD143,0xB8A4,0xD144,0xD145,0xD146,0xD147,0xD148,0xF1CA,
0xD149,0xD14A,0xD14B,0xD14C,0xF1CB,0xD14D,0xD14E,0xD14F,
0xD150,0xB2C3,0xC1D1,0xD151,0xD152,0xD7B0,0xF1C9,0xD153,
0xD154,0xF1CC,0xD155,0xD156,0xD157,0xD158,0xF1CE,0xD159,
0xD15A,0xD15B,0xD9F6,0xD15C,0xD2E1,0xD4A3,0xD15D,0xD15E,
0xF4C3,0xC8B9,0xD15F,0xD160,0xD161,0xD162,0xD163,0xF4C4,
0xD164,0xD165,0xF1CD,0xF1CF,0xBFE3,0xF1D0,0xD166,0xD167,
0xF1D4,0xD168,0xD169,0xD16A,0xD16B,0xD16C,0xD16D,0xD16E,
0xF1D6,0xF1D1,0xD16F,0xC9D1,0xC5E1,0xD170,0xD171,0xD172,
0xC2E3,0xB9FC,0xD173,0xD174,0xF1D3,0xD175,0xF1D5,0xD176,
0xD177,0xD178,0xB9D3,0xD179,0xD17A,0xD17B,0xD17C,0xD17D,
0xD17E,0xD180,0xF1DB,0xD181,0xD182,0xD183,0xD184,0xD185,
0xBAD6,0xD186,0xB0FD,0xF1D9,0xD187,0xD188,0xD189,0xD18A,
0xD18B,0xF1D8,0xF1D2,0xF1DA,0xD18C,0xD18D,0xD18E,0xD18F,
0xD190,0xF1D7,0xD191,0xD192,0xD193,0xC8EC,0xD194,0xD195,
0xD196,0xD197,0xCDCA,0xF1DD,0xD198,0xD199,0xD19A,0xD19B,
0xE5BD,0xD19C,0xD19D,0xD19E,0xF1DC,0xD19F,0xF1DE,0xD1A0,
0xD240,0xD241,0xD242,0xD243,0xD244,0xD245,0xD246,0xD247,
0xD248,0xF1DF,0xD249,0xD24A,0xCFE5,0xD24B,0xD24C,0xD24D,
0xD24E,0xD24F,0xD250,0xD251,0xD252,0xD253,0xD254,0xD255,
0xD256,0xD257,0xD258,0xD259,0xD25A,0xD25B,0xD25C,0xD25D,
0xD25E,0xD25F,0xD260,0xD261,0xD262,0xD263,0xF4C5,0xBDF3,
0xD264,0xD265,0xD266,0xD267,0xD268,0xD269,0xF1E0,0xD26A,
0xD26B,0xD26C,0xD26D,0xD26E,0xD26F,0xD270,0xD271,0xD272,
0xD273,0xD274,0xD275,0xD276,0xD277,0xD278,0xD279,0xD27A,
0xD27B,0xD27C,0xD27D,0xF1E1,0xD27E,0xD280,0xD281,0xCEF7,
0xD282,0xD2AA,0xD283,0xF1FB,0xD284,0xD285,0xB8B2,0xD286,
0xD287,0xD288,0xD289,0xD28A,0xD28B,0xD28C,0xD28D,0xD28E,
0xD28F,0xD290,0xD291,0xD292,0xD293,0xD294,0xD295,0xD296,
0xD297,0xD298,0xD299,0xD29A,0xD29B,0xD29C,0xD29D,0xD29E,
0xD29F,0xD2A0,0xD340,0xD341,0xD342,0xD343,0xD344,0xD345,
0xD346,0xD347,0xD348,0xD349,0xD34A,0xD34B,0xD34C,0xD34D,
0xD34E,0xD34F,0xD350,0xD351,0xD352,0xD353,0xD354,0xD355,
0xD356,0xD357,0xD358,0xD359,0xD35A,0xD35B,0xD35C,0xD35D,
0xD35E,0xBCFB,0xB9DB,0xD35F,0xB9E6,0xC3D9,0xCAD3,0xEAE8,
0xC0C0,0xBEF5,0xEAE9,0xEAEA,0xEAEB,0xD360,0xEAEC,0xEAED,
0xEAEE,0xEAEF,0xBDC7,0xD361,0xD362,0xD363,0xF5FB,0xD364,
0xD365,0xD366,0xF5FD,0xD367,0xF5FE,0xD368,0xF5FC,0xD369,
0xD36A,0xD36B,0xD36C,0xBDE2,0xD36D,0xF6A1,0xB4A5,0xD36E,
0xD36F,0xD370,0xD371,0xF6A2,0xD372,0xD373,0xD374,0xF6A3,
0xD375,0xD376,0xD377,0xECB2,0xD378,0xD379,0xD37A,0xD37B,
0xD37C,0xD37D,0xD37E,0xD380,0xD381,0xD382,0xD383,0xD384,
0xD1D4,0xD385,0xD386,0xD387,0xD388,0xD389,0xD38A,0xD9EA,
0xD38B,0xD38C,0xD38D,0xD38E,0xD38F,0xD390,0xD391,0xD392,
0xD393,0xD394,0xD395,0xD396,0xD397,0xD398,0xD399,0xD39A,
0xD39B,0xD39C,0xD39D,0xD39E,0xD39F,0xD3A0,0xD440,0xD441,
0xD442,0xD443,0xD444,0xD445,0xD446,0xD447,0xD448,0xD449,
0xD44A,0xD44B,0xD44C,0xD44D,0xD44E,0xD44F,0xD450,0xD451,
0xD452,0xD453,0xD454,0xD455,0xD456,0xD457,0xD458,0xD459,
0xD45A,0xD45B,0xD45C,0xD45D,0xD45E,0xD45F,0xF6A4,0xD460,
0xD461,0xD462,0xD463,0xD464,0xD465,0xD466,0xD467,0xD468,
0xEEBA,0xD469,0xD46A,0xD46B,0xD46C,0xD46D,0xD46E,0xD46F,
0xD470,0xD471,0xD472,0xD473,0xD474,0xD475,0xD476,0xD477,
0xD478,0xD479,0xD47A,0xD47B,0xD47C,0xD47D,0xD47E,0xD480,
0xD481,0xD482,0xD483,0xD484,0xD485,0xD486,0xD487,0xD488,
0xD489,0xD48A,0xD48B,0xD48C,0xD48D,0xD48E,0xD48F,0xD490,
0xD491,0xD492,0xD493,0xD494,0xD495,0xD496,0xD497,0xD498,
0xD499,0xD5B2,0xD49A,0xD49B,0xD49C,0xD49D,0xD49E,0xD49F,
0xD4A0,0xD540,0xD541,0xD542,0xD543,0xD544,0xD545,0xD546,
0xD547,0xD3FE,0xCCDC,0xD548,0xD549,0xD54A,0xD54B,0xD54C,
0xD54D,0xD54E,0xD54F,0xCAC4,0xD550,0xD551,0xD552,0xD553,
0xD554,0xD555,0xD556,0xD557,0xD558,0xD559,0xD55A,0xD55B,
0xD55C,0xD55D,0xD55E,0xD55F,0xD560,0xD561,0xD562,0xD563,
0xD564,0xD565,0xD566,0xD567,0xD568,0xD569,0xD56A,0xD56B,
0xD56C,0xD56D,0xD56E,0xD56F,0xD570,0xD571,0xD572,0xD573,
0xD574,0xD575,0xD576,0xD577,0xD578,0xD579,0xD57A,0xD57B,
0xD57C,0xD57D,0xD57E,0xD580,0xD581,0xD582,0xD583,0xD584,
0xD585,0xD586,0xD587,0xD588,0xD589,0xD58A,0xD58B,0xD58C,
0xD58D,0xD58E,0xD58F,0xD590,0xD591,0xD592,0xD593,0xD594,
0xD595,0xD596,0xD597,0xD598,0xD599,0xD59A,0xD59B,0xD59C,
0xD59D,0xD59E,0xD59F,0xD5A0,0xD640,0xD641,0xD642,0xD643,
0xD644,0xD645,0xD646,0xD647,0xD648,0xD649,0xD64A,0xD64B,
0xD64C,0xD64D,0xD64E,0xD64F,0xD650,0xD651,0xD652,0xD653,
0xD654,0xD655,0xD656,0xD657,0xD658,0xD659,0xD65A,0xD65B,
0xD65C,0xD65D,0xD65E,0xD65F,0xD660,0xD661,0xD662,0xE5C0,
0xD663,0xD664,0xD665,0xD666,0xD667,0xD668,0xD669,0xD66A,
0xD66B,0xD66C,0xD66D,0xD66E,0xD66F,0xD670,0xD671,0xD672,
0xD673,0xD674,0xD675,0xD676,0xD677,0xD678,0xD679,0xD67A,
0xD67B,0xD67C,0xD67D,0xD67E,0xD680,0xD681,0xF6A5,0xD682,
0xD683,0xD684,0xD685,0xD686,0xD687,0xD688,0xD689,0xD68A,
0xD68B,0xD68C,0xD68D,0xD68E,0xD68F,0xD690,0xD691,0xD692,
0xD693,0xD694,0xD695,0xD696,0xD697,0xD698,0xD699,0xD69A,
0xD69B,0xD69C,0xD69D,0xD69E,0xD69F,0xD6A0,0xD740,0xD741,
0xD742,0xD743,0xD744,0xD745,0xD746,0xD747,0xD748,0xD749,
0xD74A,0xD74B,0xD74C,0xD74D,0xD74E,0xD74F,0xD750,0xD751,
0xD752,0xD753,0xD754,0xD755,0xD756,0xD757,0xD758,0xD759,
0xD75A,0xD75B,0xD75C,0xD75D,0xD75E,0xD75F,0xBEAF,0xD760,
0xD761,0xD762,0xD763,0xD764,0xC6A9,0xD765,0xD766,0xD767,
0xD768,0xD769,0xD76A,0xD76B,0xD76C,0xD76D,0xD76E,0xD76F,
0xD770,0xD771,0xD772,0xD773,0xD774,0xD775,0xD776,0xD777,
0xD778,0xD779,0xD77A,0xD77B,0xD77C,0xD77D,0xD77E,0xD780,
0xD781,0xD782,0xD783,0xD784,0xD785,0xD786,0xD787,0xD788,
0xD789,0xD78A,0xD78B,0xD78C,0xD78D,0xD78E,0xD78F,0xD790,
0xD791,0xD792,0xD793,0xD794,0xD795,0xD796,0xD797,0xD798,
0xDAA5,0xBCC6,0xB6A9,0xB8BC,0xC8CF,0xBCA5,0xDAA6,0xDAA7,
0xCCD6,0xC8C3,0xDAA8,0xC6FD,0xD799,0xD1B5,0xD2E9,0xD1B6,
0xBCC7,0xD79A,0xBDB2,0xBBE4,0xDAA9,0xDAAA,0xD1C8,0xDAAB,
0xD0ED,0xB6EF,0xC2DB,0xD79B,0xCBCF,0xB7ED,0xC9E8,0xB7C3,
0xBEF7,0xD6A4,0xDAAC,0xDAAD,0xC6C0,0xD7E7,0xCAB6,0xD79C,
0xD5A9,0xCBDF,0xD5EF,0xDAAE,0xD6DF,0xB4CA,0xDAB0,0xDAAF,
0xD79D,0xD2EB,0xDAB1,0xDAB2,0xDAB3,0xCAD4,0xDAB4,0xCAAB,
0xDAB5,0xDAB6,0xB3CF,0xD6EF,0xDAB7,0xBBB0,0xB5AE,0xDAB8,
0xDAB9,0xB9EE,0xD1AF,0xD2E8,0xDABA,0xB8C3,0xCFEA,0xB2EF,
0xDABB,0xDABC,0xD79E,0xBDEB,0xCEDC,0xD3EF,0xDABD,0xCEF3,
0xDABE,0xD3D5,0xBBE5,0xDABF,0xCBB5,0xCBD0,0xDAC0,0xC7EB,
0xD6EE,0xDAC1,0xC5B5,0xB6C1,0xDAC2,0xB7CC,0xBFCE,0xDAC3,
0xDAC4,0xCBAD,0xDAC5,0xB5F7,0xDAC6,0xC1C2,0xD7BB,0xDAC7,
0xCCB8,0xD79F,0xD2EA,0xC4B1,0xDAC8,0xB5FD,0xBBD1,0xDAC9,
0xD0B3,0xDACA,0xDACB,0xCEBD,0xDACC,0xDACD,0xDACE,0xB2F7,
0xDAD1,0xDACF,0xD1E8,0xDAD0,0xC3D5,0xDAD2,0xD7A0,0xDAD3,
0xDAD4,0xDAD5,0xD0BB,0xD2A5,0xB0F9,0xDAD6,0xC7AB,0xDAD7,
0xBDF7,0xC3A1,0xDAD8,0xDAD9,0xC3FD,0xCCB7,0xDADA,0xDADB,
0xC0BE,0xC6D7,0xDADC,0xDADD,0xC7B4,0xDADE,0xDADF,0xB9C8,
0xD840,0xD841,0xD842,0xD843,0xD844,0xD845,0xD846,0xD847,
0xD848,0xBBED,0xD849,0xD84A,0xD84B,0xD84C,0xB6B9,0xF4F8,
0xD84D,0xF4F9,0xD84E,0xD84F,0xCDE3,0xD850,0xD851,0xD852,
0xD853,0xD854,0xD855,0xD856,0xD857,0xF5B9,0xD858,0xD859,
0xD85A,0xD85B,0xEBE0,0xD85C,0xD85D,0xD85E,0xD85F,0xD860,
0xD861,0xCFF3,0xBBBF,0xD862,0xD863,0xD864,0xD865,0xD866,
0xD867,0xD868,0xBAC0,0xD4A5,0xD869,0xD86A,0xD86B,0xD86C,
0xD86D,0xD86E,0xD86F,0xE1D9,0xD870,0xD871,0xD872,0xD873,
0xF5F4,0xB1AA,0xB2F2,0xD874,0xD875,0xD876,0xD877,0xD878,
0xD879,0xD87A,0xF5F5,0xD87B,0xD87C,0xF5F7,0xD87D,0xD87E,
0xD880,0xBAD1,0xF5F6,0xD881,0xC3B2,0xD882,0xD883,0xD884,
0xD885,0xD886,0xD887,0xD888,0xF5F9,0xD889,0xD88A,0xD88B,
0xF5F8,0xD88C,0xD88D,0xD88E,0xD88F,0xD890,0xD891,0xD892,
0xD893,0xD894,0xD895,0xD896,0xD897,0xD898,0xD899,0xD89A,
0xD89B,0xD89C,0xD89D,0xD89E,0xD89F,0xD8A0,0xD940,0xD941,
0xD942,0xD943,0xD944,0xD945,0xD946,0xD947,0xD948,0xD949,
0xD94A,0xD94B,0xD94C,0xD94D,0xD94E,0xD94F,0xD950,0xD951,
0xD952,0xD953,0xD954,0xD955,0xD956,0xD957,0xD958,0xD959,
0xD95A,0xD95B,0xD95C,0xD95D,0xD95E,0xD95F,0xD960,0xD961,
0xD962,0xD963,0xD964,0xD965,0xD966,0xD967,0xD968,0xD969,
0xD96A,0xD96B,0xD96C,0xD96D,0xD96E,0xD96F,0xD970,0xD971,
0xD972,0xD973,0xD974,0xD975,0xD976,0xD977,0xD978,0xD979,
0xD97A,0xD97B,0xD97C,0xD97D,0xD97E,0xD980,0xD981,0xD982,
0xD983,0xD984,0xD985,0xD986,0xD987,0xD988,0xD989,0xD98A,
0xD98B,0xD98C,0xD98D,0xD98E,0xD98F,0xD990,0xD991,0xD992,
0xD993,0xD994,0xD995,0xD996,0xD997,0xD998,0xD999,0xD99A,
0xD99B,0xD99C,0xD99D,0xD99E,0xD99F,0xD9A0,0xDA40,0xDA41,
0xDA42,0xDA43,0xDA44,0xDA45,0xDA46,0xDA47,0xDA48,0xDA49,
0xDA4A,0xDA4B,0xDA4C,0xDA4D,0xDA4E,0xB1B4,0xD5EA,0xB8BA,
0xDA4F,0xB9B1,0xB2C6,0xD4F0,0xCFCD,0xB0DC,0xD5CB,0xBBF5,
0xD6CA,0xB7B7,0xCCB0,0xC6B6,0xB1E1,0xB9BA,0xD6FC,0xB9E1,
0xB7A1,0xBCFA,0xEADA,0xEADB,0xCCF9,0xB9F3,0xEADC,0xB4FB,
0xC3B3,0xB7D1,0xBAD8,0xEADD,0xD4F4,0xEADE,0xBCD6,0xBBDF,
0xEADF,0xC1DE,0xC2B8,0xD4DF,0xD7CA,0xEAE0,0xEAE1,0xEAE4,
0xEAE2,0xEAE3,0xC9DE,0xB8B3,0xB6C4,0xEAE5,0xCAEA,0xC9CD,
0xB4CD,0xDA50,0xDA51,0xE2D9,0xC5E2,0xEAE6,0xC0B5,0xDA52,
0xD7B8,0xEAE7,0xD7AC,0xC8FC,0xD8D3,0xD8CD,0xD4DE,0xDA53,
0xD4F9,0xC9C4,0xD3AE,0xB8D3,0xB3E0,0xDA54,0xC9E2,0xF4F6,
0xDA55,0xDA56,0xDA57,0xBAD5,0xDA58,0xF4F7,0xDA59,0xDA5A,
0xD7DF,0xDA5B,0xDA5C,0xF4F1,0xB8B0,0xD5D4,0xB8CF,0xC6F0,
0xDA5D,0xDA5E,0xDA5F,0xDA60,0xDA61,0xDA62,0xDA63,0xDA64,
0xDA65,0xB3C3,0xDA66,0xDA67,0xF4F2,0xB3AC,0xDA68,0xDA69,
0xDA6A,0xDA6B,0xD4BD,0xC7F7,0xDA6C,0xDA6D,0xDA6E,0xDA6F,
0xDA70,0xF4F4,0xDA71,0xDA72,0xF4F3,0xDA73,0xDA74,0xDA75,
0xDA76,0xDA77,0xDA78,0xDA79,0xDA7A,0xDA7B,0xDA7C,0xCCCB,
0xDA7D,0xDA7E,0xDA80,0xC8A4,0xDA81,0xDA82,0xDA83,0xDA84,
0xDA85,0xDA86,0xDA87,0xDA88,0xDA89,0xDA8A,0xDA8B,0xDA8C,
0xDA8D,0xF4F5,0xDA8E,0xD7E3,0xC5BF,0xF5C0,0xDA8F,0xDA90,
0xF5BB,0xDA91,0xF5C3,0xDA92,0xF5C2,0xDA93,0xD6BA,0xF5C1,
0xDA94,0xDA95,0xDA96,0xD4BE,0xF5C4,0xDA97,0xF5CC,0xDA98,
0xDA99,0xDA9A,0xDA9B,0xB0CF,0xB5F8,0xDA9C,0xF5C9,0xF5CA,
0xDA9D,0xC5DC,0xDA9E,0xDA9F,0xDAA0,0xDB40,0xF5C5,0xF5C6,
0xDB41,0xDB42,0xF5C7,0xF5CB,0xDB43,0xBEE0,0xF5C8,0xB8FA,
0xDB44,0xDB45,0xDB46,0xF5D0,0xF5D3,0xDB47,0xDB48,0xDB49,
0xBFE7,0xDB4A,0xB9F2,0xF5BC,0xF5CD,0xDB4B,0xDB4C,0xC2B7,
0xDB4D,0xDB4E,0xDB4F,0xCCF8,0xDB50,0xBCF9,0xDB51,0xF5CE,
0xF5CF,0xF5D1,0xB6E5,0xF5D2,0xDB52,0xF5D5,0xDB53,0xDB54,
0xDB55,0xDB56,0xDB57,0xDB58,0xDB59,0xF5BD,0xDB5A,0xDB5B,
0xDB5C,0xF5D4,0xD3BB,0xDB5D,0xB3EC,0xDB5E,0xDB5F,0xCCA4,
0xDB60,0xDB61,0xDB62,0xDB63,0xF5D6,0xDB64,0xDB65,0xDB66,
0xDB67,0xDB68,0xDB69,0xDB6A,0xDB6B,0xF5D7,0xBEE1,0xF5D8,
0xDB6C,0xDB6D,0xCCDF,0xF5DB,0xDB6E,0xDB6F,0xDB70,0xDB71,
0xDB72,0xB2C8,0xD7D9,0xDB73,0xF5D9,0xDB74,0xF5DA,0xF5DC,
0xDB75,0xF5E2,0xDB76,0xDB77,0xDB78,0xF5E0,0xDB79,0xDB7A,
0xDB7B,0xF5DF,0xF5DD,0xDB7C,0xDB7D,0xF5E1,0xDB7E,0xDB80,
0xF5DE,0xF5E4,0xF5E5,0xDB81,0xCCE3,0xDB82,0xDB83,0xE5BF,
0xB5B8,0xF5E3,0xF5E8,0xCCA3,0xDB84,0xDB85,0xDB86,0xDB87,
0xDB88,0xF5E6,0xF5E7,0xDB89,0xDB8A,0xDB8B,0xDB8C,0xDB8D,
0xDB8E,0xF5BE,0xDB8F,0xDB90,0xDB91,0xDB92,0xDB93,0xDB94,
0xDB95,0xDB96,0xDB97,0xDB98,0xDB99,0xDB9A,0xB1C4,0xDB9B,
0xDB9C,0xF5BF,0xDB9D,0xDB9E,0xB5C5,0xB2E4,0xDB9F,0xF5EC,
0xF5E9,0xDBA0,0xB6D7,0xDC40,0xF5ED,0xDC41,0xF5EA,0xDC42,
0xDC43,0xDC44,0xDC45,0xDC46,0xF5EB,0xDC47,0xDC48,0xB4DA,
0xDC49,0xD4EA,0xDC4A,0xDC4B,0xDC4C,0xF5EE,0xDC4D,0xB3F9,
0xDC4E,0xDC4F,0xDC50,0xDC51,0xDC52,0xDC53,0xDC54,0xF5EF,
0xF5F1,0xDC55,0xDC56,0xDC57,0xF5F0,0xDC58,0xDC59,0xDC5A,
0xDC5B,0xDC5C,0xDC5D,0xDC5E,0xF5F2,0xDC5F,0xF5F3,0xDC60,
0xDC61,0xDC62,0xDC63,0xDC64,0xDC65,0xDC66,0xDC67,0xDC68,
0xDC69,0xDC6A,0xDC6B,0xC9ED,0xB9AA,0xDC6C,0xDC6D,0xC7FB,
0xDC6E,0xDC6F,0xB6E3,0xDC70,0xDC71,0xDC72,0xDC73,0xDC74,
0xDC75,0xDC76,0xCCC9,0xDC77,0xDC78,0xDC79,0xDC7A,0xDC7B,
0xDC7C,0xDC7D,0xDC7E,0xDC80,0xDC81,0xDC82,0xDC83,0xDC84,
0xDC85,0xDC86,0xDC87,0xDC88,0xDC89,0xDC8A,0xEAA6,0xDC8B,
0xDC8C,0xDC8D,0xDC8E,0xDC8F,0xDC90,0xDC91,0xDC92,0xDC93,
0xDC94,0xDC95,0xDC96,0xDC97,0xDC98,0xDC99,0xDC9A,0xDC9B,
0xDC9C,0xDC9D,0xDC9E,0xDC9F,0xDCA0,0xDD40,0xDD41,0xDD42,
0xDD43,0xDD44,0xDD45,0xDD46,0xDD47,0xDD48,0xDD49,0xDD4A,
0xDD4B,0xDD4C,0xDD4D,0xDD4E,0xDD4F,0xDD50,0xDD51,0xDD52,
0xDD53,0xDD54,0xDD55,0xDD56,0xDD57,0xDD58,0xDD59,0xDD5A,
0xDD5B,0xDD5C,0xDD5D,0xDD5E,0xDD5F,0xDD60,0xDD61,0xDD62,
0xDD63,0xDD64,0xDD65,0xDD66,0xDD67,0xDD68,0xDD69,0xDD6A,
0xDD6B,0xDD6C,0xDD6D,0xDD6E,0xDD6F,0xDD70,0xDD71,0xDD72,
0xDD73,0xDD74,0xDD75,0xDD76,0xDD77,0xDD78,0xDD79,0xDD7A,
0xDD7B,0xDD7C,0xDD7D,0xDD7E,0xDD80,0xDD81,0xDD82,0xDD83,
0xDD84,0xDD85,0xDD86,0xDD87,0xDD88,0xDD89,0xDD8A,0xDD8B,
0xDD8C,0xDD8D,0xDD8E,0xDD8F,0xDD90,0xDD91,0xDD92,0xDD93,
0xDD94,0xDD95,0xDD96,0xDD97,0xDD98,0xDD99,0xDD9A,0xDD9B,
0xDD9C,0xDD9D,0xDD9E,0xDD9F,0xDDA0,0xDE40,0xDE41,0xDE42,
0xDE43,0xDE44,0xDE45,0xDE46,0xDE47,0xDE48,0xDE49,0xDE4A,
0xDE4B,0xDE4C,0xDE4D,0xDE4E,0xDE4F,0xDE50,0xDE51,0xDE52,
0xDE53,0xDE54,0xDE55,0xDE56,0xDE57,0xDE58,0xDE59,0xDE5A,
0xDE5B,0xDE5C,0xDE5D,0xDE5E,0xDE5F,0xDE60,0xB3B5,0xD4FE,
0xB9EC,0xD0F9,0xDE61,0xE9ED,0xD7AA,0xE9EE,0xC2D6,0xC8ED,
0xBAE4,0xE9EF,0xE9F0,0xE9F1,0xD6E1,0xE9F2,0xE9F3,0xE9F5,
0xE9F4,0xE9F6,0xE9F7,0xC7E1,0xE9F8,0xD4D8,0xE9F9,0xBDCE,
0xDE62,0xE9FA,0xE9FB,0xBDCF,0xE9FC,0xB8A8,0xC1BE,0xE9FD,
0xB1B2,0xBBD4,0xB9F5,0xE9FE,0xDE63,0xEAA1,0xEAA2,0xEAA3,
0xB7F8,0xBCAD,0xDE64,0xCAE4,0xE0CE,0xD4AF,0xCFBD,0xD5B7,
0xEAA4,0xD5DE,0xEAA5,0xD0C1,0xB9BC,0xDE65,0xB4C7,0xB1D9,
0xDE66,0xDE67,0xDE68,0xC0B1,0xDE69,0xDE6A,0xDE6B,0xDE6C,
0xB1E6,0xB1E7,0xDE6D,0xB1E8,0xDE6E,0xDE6F,0xDE70,0xDE71,
0xB3BD,0xC8E8,0xDE72,0xDE73,0xDE74,0xDE75,0xE5C1,0xDE76,
0xDE77,0xB1DF,0xDE78,0xDE79,0xDE7A,0xC1C9,0xB4EF,0xDE7B,
0xDE7C,0xC7A8,0xD3D8,0xDE7D,0xC6F9,0xD1B8,0xDE7E,0xB9FD,
0xC2F5,0xDE80,0xDE81,0xDE82,0xDE83,0xDE84,0xD3AD,0xDE85,
0xD4CB,0xBDFC,0xDE86,0xE5C2,0xB7B5,0xE5C3,0xDE87,0xDE88,
0xBBB9,0xD5E2,0xDE89,0xBDF8,0xD4B6,0xCEA5,0xC1AC,0xB3D9,
0xDE8A,0xDE8B,0xCCF6,0xDE8C,0xE5C6,0xE5C4,0xE5C8,0xDE8D,
0xE5CA,0xE5C7,0xB5CF,0xC6C8,0xDE8E,0xB5FC,0xE5C5,0xDE8F,
0xCAF6,0xDE90,0xDE91,0xE5C9,0xDE92,0xDE93,0xDE94,0xC3D4,
0xB1C5,0xBCA3,0xDE95,0xDE96,0xDE97,0xD7B7,0xDE98,0xDE99,
0xCDCB,0xCBCD,0xCACA,0xCCD3,0xE5CC,0xE5CB,0xC4E6,0xDE9A,
0xDE9B,0xD1A1,0xD1B7,0xE5CD,0xDE9C,0xE5D0,0xDE9D,0xCDB8,
0xD6F0,0xE5CF,0xB5DD,0xDE9E,0xCDBE,0xDE9F,0xE5D1,0xB6BA,
0xDEA0,0xDF40,0xCDA8,0xB9E4,0xDF41,0xCAC5,0xB3D1,0xCBD9,
0xD4EC,0xE5D2,0xB7EA,0xDF42,0xDF43,0xDF44,0xE5CE,0xDF45,
0xDF46,0xDF47,0xDF48,0xDF49,0xDF4A,0xE5D5,0xB4FE,0xE5D6,
0xDF4B,0xDF4C,0xDF4D,0xDF4E,0xDF4F,0xE5D3,0xE5D4,0xDF50,
0xD2DD,0xDF51,0xDF52,0xC2DF,0xB1C6,0xDF53,0xD3E2,0xDF54,
0xDF55,0xB6DD,0xCBEC,0xDF56,0xE5D7,0xDF57,0xDF58,0xD3F6,
0xDF59,0xDF5A,0xDF5B,0xDF5C,0xDF5D,0xB1E9,0xDF5E,0xB6F4,
0xE5DA,0xE5D8,0xE5D9,0xB5C0,0xDF5F,0xDF60,0xDF61,0xD2C5,
0xE5DC,0xDF62,0xDF63,0xE5DE,0xDF64,0xDF65,0xDF66,0xDF67,
0xDF68,0xDF69,0xE5DD,0xC7B2,0xDF6A,0xD2A3,0xDF6B,0xDF6C,
0xE5DB,0xDF6D,0xDF6E,0xDF6F,0xDF70,0xD4E2,0xD5DA,0xDF71,
0xDF72,0xDF73,0xDF74,0xDF75,0xE5E0,0xD7F1,0xDF76,0xDF77,
0xDF78,0xDF79,0xDF7A,0xDF7B,0xDF7C,0xE5E1,0xDF7D,0xB1DC,
0xD1FB,0xDF7E,0xE5E2,0xE5E4,0xDF80,0xDF81,0xDF82,0xDF83,
0xE5E3,0xDF84,0xDF85,0xE5E5,0xDF86,0xDF87,0xDF88,0xDF89,
0xDF8A,0xD2D8,0xDF8B,0xB5CB,0xDF8C,0xE7DF,0xDF8D,0xDAF5,
0xDF8E,0xDAF8,0xDF8F,0xDAF6,0xDF90,0xDAF7,0xDF91,0xDF92,
0xDF93,0xDAFA,0xD0CF,0xC4C7,0xDF94,0xDF95,0xB0EE,0xDF96,
0xDF97,0xDF98,0xD0B0,0xDF99,0xDAF9,0xDF9A,0xD3CA,0xBAAA,
0xDBA2,0xC7F1,0xDF9B,0xDAFC,0xDAFB,0xC9DB,0xDAFD,0xDF9C,
0xDBA1,0xD7DE,0xDAFE,0xC1DA,0xDF9D,0xDF9E,0xDBA5,0xDF9F,
0xDFA0,0xD3F4,0xE040,0xE041,0xDBA7,0xDBA4,0xE042,0xDBA8,
0xE043,0xE044,0xBDBC,0xE045,0xE046,0xE047,0xC0C9,0xDBA3,
0xDBA6,0xD6A3,0xE048,0xDBA9,0xE049,0xE04A,0xE04B,0xDBAD,
0xE04C,0xE04D,0xE04E,0xDBAE,0xDBAC,0xBAC2,0xE04F,0xE050,
0xE051,0xBFA4,0xDBAB,0xE052,0xE053,0xE054,0xDBAA,0xD4C7,
0xB2BF,0xE055,0xE056,0xDBAF,0xE057,0xB9F9,0xE058,0xDBB0,
0xE059,0xE05A,0xE05B,0xE05C,0xB3BB,0xE05D,0xE05E,0xE05F,
0xB5A6,0xE060,0xE061,0xE062,0xE063,0xB6BC,0xDBB1,0xE064,
0xE065,0xE066,0xB6F5,0xE067,0xDBB2,0xE068,0xE069,0xE06A,
0xE06B,0xE06C,0xE06D,0xE06E,0xE06F,0xE070,0xE071,0xE072,
0xE073,0xE074,0xE075,0xE076,0xE077,0xE078,0xE079,0xE07A,
0xE07B,0xB1C9,0xE07C,0xE07D,0xE07E,0xE080,0xDBB4,0xE081,
0xE082,0xE083,0xDBB3,0xDBB5,0xE084,0xE085,0xE086,0xE087,
0xE088,0xE089,0xE08A,0xE08B,0xE08C,0xE08D,0xE08E,0xDBB7,
0xE08F,0xDBB6,0xE090,0xE091,0xE092,0xE093,0xE094,0xE095,
0xE096,0xDBB8,0xE097,0xE098,0xE099,0xE09A,0xE09B,0xE09C,
0xE09D,0xE09E,0xE09F,0xDBB9,0xE0A0,0xE140,0xDBBA,0xE141,
0xE142,0xD3CF,0xF4FA,0xC7F5,0xD7C3,0xC5E4,0xF4FC,0xF4FD,
0xF4FB,0xE143,0xBEC6,0xE144,0xE145,0xE146,0xE147,0xD0EF,
0xE148,0xE149,0xB7D3,0xE14A,0xE14B,0xD4CD,0xCCAA,0xE14C,
0xE14D,0xF5A2,0xF5A1,0xBAA8,0xF4FE,0xCBD6,0xE14E,0xE14F,
0xE150,0xF5A4,0xC0D2,0xE151,0xB3EA,0xE152,0xCDAA,0xF5A5,
0xF5A3,0xBDB4,0xF5A8,0xE153,0xF5A9,0xBDCD,0xC3B8,0xBFE1,
0xCBE1,0xF5AA,0xE154,0xE155,0xE156,0xF5A6,0xF5A7,0xC4F0,
0xE157,0xE158,0xE159,0xE15A,0xE15B,0xF5AC,0xE15C,0xB4BC,
0xE15D,0xD7ED,0xE15E,0xB4D7,0xF5AB,0xF5AE,0xE15F,0xE160,
0xF5AD,0xF5AF,0xD0D1,0xE161,0xE162,0xE163,0xE164,0xE165,
0xE166,0xE167,0xC3D1,0xC8A9,0xE168,0xE169,0xE16A,0xE16B,
0xE16C,0xE16D,0xF5B0,0xF5B1,0xE16E,0xE16F,0xE170,0xE171,
0xE172,0xE173,0xF5B2,0xE174,0xE175,0xF5B3,0xF5B4,0xF5B5,
0xE176,0xE177,0xE178,0xE179,0xF5B7,0xF5B6,0xE17A,0xE17B,
0xE17C,0xE17D,0xF5B8,0xE17E,0xE180,0xE181,0xE182,0xE183,
0xE184,0xE185,0xE186,0xE187,0xE188,0xE189,0xE18A,0xB2C9,
0xE18B,0xD3D4,0xCACD,0xE18C,0xC0EF,0xD6D8,0xD2B0,0xC1BF,
0xE18D,0xBDF0,0xE18E,0xE18F,0xE190,0xE191,0xE192,0xE193,
0xE194,0xE195,0xE196,0xE197,0xB8AA,0xE198,0xE199,0xE19A,
0xE19B,0xE19C,0xE19D,0xE19E,0xE19F,0xE1A0,0xE240,0xE241,
0xE242,0xE243,0xE244,0xE245,0xE246,0xE247,0xE248,0xE249,
0xE24A,0xE24B,0xE24C,0xE24D,0xE24E,0xE24F,0xE250,0xE251,
0xE252,0xE253,0xE254,0xE255,0xE256,0xE257,0xE258,0xE259,
0xE25A,0xE25B,0xE25C,0xE25D,0xE25E,0xE25F,0xE260,0xE261,
0xE262,0xE263,0xE264,0xE265,0xE266,0xE267,0xE268,0xE269,
0xE26A,0xE26B,0xE26C,0xE26D,0xE26E,0xE26F,0xE270,0xE271,
0xE272,0xE273,0xE274,0xE275,0xE276,0xE277,0xE278,0xE279,
0xE27A,0xE27B,0xE27C,0xE27D,0xE27E,0xE280,0xE281,0xE282,
0xE283,0xE284,0xE285,0xE286,0xE287,0xE288,0xE289,0xE28A,
0xE28B,0xE28C,0xE28D,0xE28E,0xE28F,0xE290,0xE291,0xE292,
0xE293,0xE294,0xE295,0xE296,0xE297,0xE298,0xE299,0xE29A,
0xE29B,0xE29C,0xE29D,0xE29E,0xE29F,0xE2A0,0xE340,0xE341,
0xE342,0xE343,0xE344,0xE345,0xE346,0xE347,0xE348,0xE349,
0xE34A,0xE34B,0xE34C,0xE34D,0xE34E,0xE34F,0xE350,0xE351,
0xE352,0xE353,0xE354,0xE355,0xE356,0xE357,0xE358,0xE359,
0xE35A,0xE35B,0xE35C,0xE35D,0xE35E,0xE35F,0xE360,0xE361,
0xE362,0xE363,0xE364,0xE365,0xE366,0xE367,0xE368,0xE369,
0xE36A,0xE36B,0xE36C,0xE36D,0xBCF8,0xE36E,0xE36F,0xE370,
0xE371,0xE372,0xE373,0xE374,0xE375,0xE376,0xE377,0xE378,
0xE379,0xE37A,0xE37B,0xE37C,0xE37D,0xE37E,0xE380,0xE381,
0xE382,0xE383,0xE384,0xE385,0xE386,0xE387,0xF6C6,0xE388,
0xE389,0xE38A,0xE38B,0xE38C,0xE38D,0xE38E,0xE38F,0xE390,
0xE391,0xE392,0xE393,0xE394,0xE395,0xE396,0xE397,0xE398,
0xE399,0xE39A,0xE39B,0xE39C,0xE39D,0xE39E,0xE39F,0xE3A0,
0xE440,0xE441,0xE442,0xE443,0xE444,0xE445,0xF6C7,0xE446,
0xE447,0xE448,0xE449,0xE44A,0xE44B,0xE44C,0xE44D,0xE44E,
0xE44F,0xE450,0xE451,0xE452,0xE453,0xE454,0xE455,0xE456,
0xE457,0xE458,0xE459,0xE45A,0xE45B,0xE45C,0xE45D,0xE45E,
0xF6C8,0xE45F,0xE460,0xE461,0xE462,0xE463,0xE464,0xE465,
0xE466,0xE467,0xE468,0xE469,0xE46A,0xE46B,0xE46C,0xE46D,
0xE46E,0xE46F,0xE470,0xE471,0xE472,0xE473,0xE474,0xE475,
0xE476,0xE477,0xE478,0xE479,0xE47A,0xE47B,0xE47C,0xE47D,
0xE47E,0xE480,0xE481,0xE482,0xE483,0xE484,0xE485,0xE486,
0xE487,0xE488,0xE489,0xE48A,0xE48B,0xE48C,0xE48D,0xE48E,
0xE48F,0xE490,0xE491,0xE492,0xE493,0xE494,0xE495,0xE496,
0xE497,0xE498,0xE499,0xE49A,0xE49B,0xE49C,0xE49D,0xE49E,
0xE49F,0xE4A0,0xE540,0xE541,0xE542,0xE543,0xE544,0xE545,
0xE546,0xE547,0xE548,0xE549,0xE54A,0xE54B,0xE54C,0xE54D,
0xE54E,0xE54F,0xE550,0xE551,0xE552,0xE553,0xE554,0xE555,
0xE556,0xE557,0xE558,0xE559,0xE55A,0xE55B,0xE55C,0xE55D,
0xE55E,0xE55F,0xE560,0xE561,0xE562,0xE563,0xE564,0xE565,
0xE566,0xE567,0xE568,0xE569,0xE56A,0xE56B,0xE56C,0xE56D,
0xE56E,0xE56F,0xE570,0xE571,0xE572,0xE573,0xF6C9,0xE574,
0xE575,0xE576,0xE577,0xE578,0xE579,0xE57A,0xE57B,0xE57C,
0xE57D,0xE57E,0xE580,0xE581,0xE582,0xE583,0xE584,0xE585,
0xE586,0xE587,0xE588,0xE589,0xE58A,0xE58B,0xE58C,0xE58D,
0xE58E,0xE58F,0xE590,0xE591,0xE592,0xE593,0xE594,0xE595,
0xE596,0xE597,0xE598,0xE599,0xE59A,0xE59B,0xE59C,0xE59D,
0xE59E,0xE59F,0xF6CA,0xE5A0,0xE640,0xE641,0xE642,0xE643,
0xE644,0xE645,0xE646,0xE647,0xE648,0xE649,0xE64A,0xE64B,
0xE64C,0xE64D,0xE64E,0xE64F,0xE650,0xE651,0xE652,0xE653,
0xE654,0xE655,0xE656,0xE657,0xE658,0xE659,0xE65A,0xE65B,
0xE65C,0xE65D,0xE65E,0xE65F,0xE660,0xE661,0xE662,0xF6CC,
0xE663,0xE664,0xE665,0xE666,0xE667,0xE668,0xE669,0xE66A,
0xE66B,0xE66C,0xE66D,0xE66E,0xE66F,0xE670,0xE671,0xE672,
0xE673,0xE674,0xE675,0xE676,0xE677,0xE678,0xE679,0xE67A,
0xE67B,0xE67C,0xE67D,0xE67E,0xE680,0xE681,0xE682,0xE683,
0xE684,0xE685,0xE686,0xE687,0xE688,0xE689,0xE68A,0xE68B,
0xE68C,0xE68D,0xE68E,0xE68F,0xE690,0xE691,0xE692,0xE693,
0xE694,0xE695,0xE696,0xE697,0xE698,0xE699,0xE69A,0xE69B,
0xE69C,0xE69D,0xF6CB,0xE69E,0xE69F,0xE6A0,0xE740,0xE741,
0xE742,0xE743,0xE744,0xE745,0xE746,0xE747,0xF7E9,0xE748,
0xE749,0xE74A,0xE74B,0xE74C,0xE74D,0xE74E,0xE74F,0xE750,
0xE751,0xE752,0xE753,0xE754,0xE755,0xE756,0xE757,0xE758,
0xE759,0xE75A,0xE75B,0xE75C,0xE75D,0xE75E,0xE75F,0xE760,
0xE761,0xE762,0xE763,0xE764,0xE765,0xE766,0xE767,0xE768,
0xE769,0xE76A,0xE76B,0xE76C,0xE76D,0xE76E,0xE76F,0xE770,
0xE771,0xE772,0xE773,0xE774,0xE775,0xE776,0xE777,0xE778,
0xE779,0xE77A,0xE77B,0xE77C,0xE77D,0xE77E,0xE780,0xE781,
0xE782,0xE783,0xE784,0xE785,0xE786,0xE787,0xE788,0xE789,
0xE78A,0xE78B,0xE78C,0xE78D,0xE78E,0xE78F,0xE790,0xE791,
0xE792,0xE793,0xE794,0xE795,0xE796,0xE797,0xE798,0xE799,
0xE79A,0xE79B,0xE79C,0xE79D,0xE79E,0xE79F,0xE7A0,0xE840,
0xE841,0xE842,0xE843,0xE844,0xE845,0xE846,0xE847,0xE848,
0xE849,0xE84A,0xE84B,0xE84C,0xE84D,0xE84E,0xF6CD,0xE84F,
0xE850,0xE851,0xE852,0xE853,0xE854,0xE855,0xE856,0xE857,
0xE858,0xE859,0xE85A,0xE85B,0xE85C,0xE85D,0xE85E,0xE85F,
0xE860,0xE861,0xE862,0xE863,0xE864,0xE865,0xE866,0xE867,
0xE868,0xE869,0xE86A,0xE86B,0xE86C,0xE86D,0xE86E,0xE86F,
0xE870,0xE871,0xE872,0xE873,0xE874,0xE875,0xE876,0xE877,
0xE878,0xE879,0xE87A,0xF6CE,0xE87B,0xE87C,0xE87D,0xE87E,
0xE880,0xE881,0xE882,0xE883,0xE884,0xE885,0xE886,0xE887,
0xE888,0xE889,0xE88A,0xE88B,0xE88C,0xE88D,0xE88E,0xE88F,
0xE890,0xE891,0xE892,0xE893,0xE894,0xEEC4,0xEEC5,0xEEC6,
0xD5EB,0xB6A4,0xEEC8,0xEEC7,0xEEC9,0xEECA,0xC7A5,0xEECB,
0xEECC,0xE895,0xB7B0,0xB5F6,0xEECD,0xEECF,0xE896,0xEECE,
0xE897,0xB8C6,0xEED0,0xEED1,0xEED2,0xB6DB,0xB3AE,0xD6D3,
0xC4C6,0xB1B5,0xB8D6,0xEED3,0xEED4,0xD4BF,0xC7D5,0xBEFB,
0xCED9,0xB9B3,0xEED6,0xEED5,0xEED8,0xEED7,0xC5A5,0xEED9,
0xEEDA,0xC7AE,0xEEDB,0xC7AF,0xEEDC,0xB2A7,0xEEDD,0xEEDE,
0xEEDF,0xEEE0,0xEEE1,0xD7EA,0xEEE2,0xEEE3,0xBCD8,0xEEE4,
0xD3CB,0xCCFA,0xB2AC,0xC1E5,0xEEE5,0xC7A6,0xC3AD,0xE898,
0xEEE6,0xEEE7,0xEEE8,0xEEE9,0xEEEA,0xEEEB,0xEEEC,0xE899,
0xEEED,0xEEEE,0xEEEF,0xE89A,0xE89B,0xEEF0,0xEEF1,0xEEF2,
0xEEF4,0xEEF3,0xE89C,0xEEF5,0xCDAD,0xC2C1,0xEEF6,0xEEF7,
0xEEF8,0xD5A1,0xEEF9,0xCFB3,0xEEFA,0xEEFB,0xE89D,0xEEFC,
0xEEFD,0xEFA1,0xEEFE,0xEFA2,0xB8F5,0xC3FA,0xEFA3,0xEFA4,
0xBDC2,0xD2BF,0xB2F9,0xEFA5,0xEFA6,0xEFA7,0xD2F8,0xEFA8,
0xD6FD,0xEFA9,0xC6CC,0xE89E,0xEFAA,0xEFAB,0xC1B4,0xEFAC,
0xCFFA,0xCBF8,0xEFAE,0xEFAD,0xB3FA,0xB9F8,0xEFAF,0xEFB0,
0xD0E2,0xEFB1,0xEFB2,0xB7E6,0xD0BF,0xEFB3,0xEFB4,0xEFB5,
0xC8F1,0xCCE0,0xEFB6,0xEFB7,0xEFB8,0xEFB9,0xEFBA,0xD5E0,
0xEFBB,0xB4ED,0xC3AA,0xEFBC,0xE89F,0xEFBD,0xEFBE,0xEFBF,
0xE8A0,0xCEFD,0xEFC0,0xC2E0,0xB4B8,0xD7B6,0xBDF5,0xE940,
0xCFC7,0xEFC3,0xEFC1,0xEFC2,0xEFC4,0xB6A7,0xBCFC,0xBEE2,
0xC3CC,0xEFC5,0xEFC6,0xE941,0xEFC7,0xEFCF,0xEFC8,0xEFC9,
0xEFCA,0xC7C2,0xEFF1,0xB6CD,0xEFCB,0xE942,0xEFCC,0xEFCD,
0xB6C6,0xC3BE,0xEFCE,0xE943,0xEFD0,0xEFD1,0xEFD2,0xD5F2,
0xE944,0xEFD3,0xC4F7,0xE945,0xEFD4,0xC4F8,0xEFD5,0xEFD6,
0xB8E4,0xB0F7,0xEFD7,0xEFD8,0xEFD9,0xE946,0xEFDA,0xEFDB,
0xEFDC,0xEFDD,0xE947,0xEFDE,0xBEB5,0xEFE1,0xEFDF,0xEFE0,
0xE948,0xEFE2,0xEFE3,0xC1CD,0xEFE4,0xEFE5,0xEFE6,0xEFE7,
0xEFE8,0xEFE9,0xEFEA,0xEFEB,0xEFEC,0xC0D8,0xE949,0xEFED,
0xC1AD,0xEFEE,0xEFEF,0xEFF0,0xE94A,0xE94B,0xCFE2,0xE94C,
0xE94D,0xE94E,0xE94F,0xE950,0xE951,0xE952,0xE953,0xB3A4,
0xE954,0xE955,0xE956,0xE957,0xE958,0xE959,0xE95A,0xE95B,
0xE95C,0xE95D,0xE95E,0xE95F,0xE960,0xE961,0xE962,0xE963,
0xE964,0xE965,0xE966,0xE967,0xE968,0xE969,0xE96A,0xE96B,
0xE96C,0xE96D,0xE96E,0xE96F,0xE970,0xE971,0xE972,0xE973,
0xE974,0xE975,0xE976,0xE977,0xE978,0xE979,0xE97A,0xE97B,
0xE97C,0xE97D,0xE97E,0xE980,0xE981,0xE982,0xE983,0xE984,
0xE985,0xE986,0xE987,0xE988,0xE989,0xE98A,0xE98B,0xE98C,
0xE98D,0xE98E,0xE98F,0xE990,0xE991,0xE992,0xE993,0xE994,
0xE995,0xE996,0xE997,0xE998,0xE999,0xE99A,0xE99B,0xE99C,
0xE99D,0xE99E,0xE99F,0xE9A0,0xEA40,0xEA41,0xEA42,0xEA43,
0xEA44,0xEA45,0xEA46,0xEA47,0xEA48,0xEA49,0xEA4A,0xEA4B,
0xEA4C,0xEA4D,0xEA4E,0xEA4F,0xEA50,0xEA51,0xEA52,0xEA53,
0xEA54,0xEA55,0xEA56,0xEA57,0xEA58,0xEA59,0xEA5A,0xEA5B,
0xC3C5,0xE3C5,0xC9C1,0xE3C6,0xEA5C,0xB1D5,0xCECA,0xB4B3,
0xC8F2,0xE3C7,0xCFD0,0xE3C8,0xBCE4,0xE3C9,0xE3CA,0xC3C6,
0xD5A2,0xC4D6,0xB9EB,0xCEC5,0xE3CB,0xC3F6,0xE3CC,0xEA5D,
0xB7A7,0xB8F3,0xBAD2,0xE3CD,0xE3CE,0xD4C4,0xE3CF,0xEA5E,
0xE3D0,0xD1CB,0xE3D1,0xE3D2,0xE3D3,0xE3D4,0xD1D6,0xE3D5,
0xB2FB,0xC0BB,0xE3D6,0xEA5F,0xC0AB,0xE3D7,0xE3D8,0xE3D9,
0xEA60,0xE3DA,0xE3DB,0xEA61,0xB8B7,0xDAE2,0xEA62,0xB6D3,
0xEA63,0xDAE4,0xDAE3,0xEA64,0xEA65,0xEA66,0xEA67,0xEA68,
0xEA69,0xEA6A,0xDAE6,0xEA6B,0xEA6C,0xEA6D,0xC8EE,0xEA6E,
0xEA6F,0xDAE5,0xB7C0,0xD1F4,0xD2F5,0xD5F3,0xBDD7,0xEA70,
0xEA71,0xEA72,0xEA73,0xD7E8,0xDAE8,0xDAE7,0xEA74,0xB0A2,
0xCDD3,0xEA75,0xDAE9,0xEA76,0xB8BD,0xBCCA,0xC2BD,0xC2A4,
0xB3C2,0xDAEA,0xEA77,0xC2AA,0xC4B0,0xBDB5,0xEA78,0xEA79,
0xCFDE,0xEA7A,0xEA7B,0xEA7C,0xDAEB,0xC9C2,0xEA7D,0xEA7E,
0xEA80,0xEA81,0xEA82,0xB1DD,0xEA83,0xEA84,0xEA85,0xDAEC,
0xEA86,0xB6B8,0xD4BA,0xEA87,0xB3FD,0xEA88,0xEA89,0xDAED,
0xD4C9,0xCFD5,0xC5E3,0xEA8A,0xDAEE,0xEA8B,0xEA8C,0xEA8D,
0xEA8E,0xEA8F,0xDAEF,0xEA90,0xDAF0,0xC1EA,0xCCD5,0xCFDD,
0xEA91,0xEA92,0xEA93,0xEA94,0xEA95,0xEA96,0xEA97,0xEA98,
0xEA99,0xEA9A,0xEA9B,0xEA9C,0xEA9D,0xD3E7,0xC2A1,0xEA9E,
0xDAF1,0xEA9F,0xEAA0,0xCBE5,0xEB40,0xDAF2,0xEB41,0xCBE6,
0xD2FE,0xEB42,0xEB43,0xEB44,0xB8F4,0xEB45,0xEB46,0xDAF3,
0xB0AF,0xCFB6,0xEB47,0xEB48,0xD5CF,0xEB49,0xEB4A,0xEB4B,
0xEB4C,0xEB4D,0xEB4E,0xEB4F,0xEB50,0xEB51,0xEB52,0xCBED,
0xEB53,0xEB54,0xEB55,0xEB56,0xEB57,0xEB58,0xEB59,0xEB5A,
0xDAF4,0xEB5B,0xEB5C,0xE3C4,0xEB5D,0xEB5E,0xC1A5,0xEB5F,
0xEB60,0xF6BF,0xEB61,0xEB62,0xF6C0,0xF6C1,0xC4D1,0xEB63,
0xC8B8,0xD1E3,0xEB64,0xEB65,0xD0DB,0xD1C5,0xBCAF,0xB9CD,
0xEB66,0xEFF4,0xEB67,0xEB68,0xB4C6,0xD3BA,0xF6C2,0xB3FB,
0xEB69,0xEB6A,0xF6C3,0xEB6B,0xEB6C,0xB5F1,0xEB6D,0xEB6E,
0xEB6F,0xEB70,0xEB71,0xEB72,0xEB73,0xEB74,0xEB75,0xEB76,
0xF6C5,0xEB77,0xEB78,0xEB79,0xEB7A,0xEB7B,0xEB7C,0xEB7D,
0xD3EA,0xF6A7,0xD1A9,0xEB7E,0xEB80,0xEB81,0xEB82,0xF6A9,
0xEB83,0xEB84,0xEB85,0xF6A8,0xEB86,0xEB87,0xC1E3,0xC0D7,
0xEB88,0xB1A2,0xEB89,0xEB8A,0xEB8B,0xEB8C,0xCEED,0xEB8D,
0xD0E8,0xF6AB,0xEB8E,0xEB8F,0xCFF6,0xEB90,0xF6AA,0xD5F0,
0xF6AC,0xC3B9,0xEB91,0xEB92,0xEB93,0xBBF4,0xF6AE,0xF6AD,
0xEB94,0xEB95,0xEB96,0xC4DE,0xEB97,0xEB98,0xC1D8,0xEB99,
0xEB9A,0xEB9B,0xEB9C,0xEB9D,0xCBAA,0xEB9E,0xCFBC,0xEB9F,
0xEBA0,0xEC40,0xEC41,0xEC42,0xEC43,0xEC44,0xEC45,0xEC46,
0xEC47,0xEC48,0xF6AF,0xEC49,0xEC4A,0xF6B0,0xEC4B,0xEC4C,
0xF6B1,0xEC4D,0xC2B6,0xEC4E,0xEC4F,0xEC50,0xEC51,0xEC52,
0xB0D4,0xC5F9,0xEC53,0xEC54,0xEC55,0xEC56,0xF6B2,0xEC57,
0xEC58,0xEC59,0xEC5A,0xEC5B,0xEC5C,0xEC5D,0xEC5E,0xEC5F,
0xEC60,0xEC61,0xEC62,0xEC63,0xEC64,0xEC65,0xEC66,0xEC67,
0xEC68,0xEC69,0xC7E0,0xF6A6,0xEC6A,0xEC6B,0xBEB8,0xEC6C,
0xEC6D,0xBEB2,0xEC6E,0xB5E5,0xEC6F,0xEC70,0xB7C7,0xEC71,
0xBFBF,0xC3D2,0xC3E6,0xEC72,0xEC73,0xD8CC,0xEC74,0xEC75,
0xEC76,0xB8EF,0xEC77,0xEC78,0xEC79,0xEC7A,0xEC7B,0xEC7C,
0xEC7D,0xEC7E,0xEC80,0xBDF9,0xD1A5,0xEC81,0xB0D0,0xEC82,
0xEC83,0xEC84,0xEC85,0xEC86,0xF7B0,0xEC87,0xEC88,0xEC89,
0xEC8A,0xEC8B,0xEC8C,0xEC8D,0xEC8E,0xF7B1,0xEC8F,0xEC90,
0xEC91,0xEC92,0xEC93,0xD0AC,0xEC94,0xB0B0,0xEC95,0xEC96,
0xEC97,0xF7B2,0xF7B3,0xEC98,0xF7B4,0xEC99,0xEC9A,0xEC9B,
0xC7CA,0xEC9C,0xEC9D,0xEC9E,0xEC9F,0xECA0,0xED40,0xED41,
0xBECF,0xED42,0xED43,0xF7B7,0xED44,0xED45,0xED46,0xED47,
0xED48,0xED49,0xED4A,0xF7B6,0xED4B,0xB1DE,0xED4C,0xF7B5,
0xED4D,0xED4E,0xF7B8,0xED4F,0xF7B9,0xED50,0xED51,0xED52,
0xED53,0xED54,0xED55,0xED56,0xED57,0xED58,0xED59,0xED5A,
0xED5B,0xED5C,0xED5D,0xED5E,0xED5F,0xED60,0xED61,0xED62,
0xED63,0xED64,0xED65,0xED66,0xED67,0xED68,0xED69,0xED6A,
0xED6B,0xED6C,0xED6D,0xED6E,0xED6F,0xED70,0xED71,0xED72,
0xED73,0xED74,0xED75,0xED76,0xED77,0xED78,0xED79,0xED7A,
0xED7B,0xED7C,0xED7D,0xED7E,0xED80,0xED81,0xCEA4,0xC8CD,
0xED82,0xBAAB,0xE8B8,0xE8B9,0xE8BA,0xBEC2,0xED83,0xED84,
0xED85,0xED86,0xED87,0xD2F4,0xED88,0xD4CF,0xC9D8,0xED89,
0xED8A,0xED8B,0xED8C,0xED8D,0xED8E,0xED8F,0xED90,0xED91,
0xED92,0xED93,0xED94,0xED95,0xED96,0xED97,0xED98,0xED99,
0xED9A,0xED9B,0xED9C,0xED9D,0xED9E,0xED9F,0xEDA0,0xEE40,
0xEE41,0xEE42,0xEE43,0xEE44,0xEE45,0xEE46,0xEE47,0xEE48,
0xEE49,0xEE4A,0xEE4B,0xEE4C,0xEE4D,0xEE4E,0xEE4F,0xEE50,
0xEE51,0xEE52,0xEE53,0xEE54,0xEE55,0xEE56,0xEE57,0xEE58,
0xEE59,0xEE5A,0xEE5B,0xEE5C,0xEE5D,0xEE5E,0xEE5F,0xEE60,
0xEE61,0xEE62,0xEE63,0xEE64,0xEE65,0xEE66,0xEE67,0xEE68,
0xEE69,0xEE6A,0xEE6B,0xEE6C,0xEE6D,0xEE6E,0xEE6F,0xEE70,
0xEE71,0xEE72,0xEE73,0xEE74,0xEE75,0xEE76,0xEE77,0xEE78,
0xEE79,0xEE7A,0xEE7B,0xEE7C,0xEE7D,0xEE7E,0xEE80,0xEE81,
0xEE82,0xEE83,0xEE84,0xEE85,0xEE86,0xEE87,0xEE88,0xEE89,
0xEE8A,0xEE8B,0xEE8C,0xEE8D,0xEE8E,0xEE8F,0xEE90,0xEE91,
0xEE92,0xEE93,0xEE94,0xEE95,0xEE96,0xEE97,0xEE98,0xEE99,
0xEE9A,0xEE9B,0xEE9C,0xEE9D,0xEE9E,0xEE9F,0xEEA0,0xEF40,
0xEF41,0xEF42,0xEF43,0xEF44,0xEF45,0xD2B3,0xB6A5,0xC7EA,
0xF1FC,0xCFEE,0xCBB3,0xD0EB,0xE7EF,0xCDE7,0xB9CB,0xB6D9,
0xF1FD,0xB0E4,0xCBCC,0xF1FE,0xD4A4,0xC2AD,0xC1EC,0xC6C4,
0xBEB1,0xF2A1,0xBCD5,0xEF46,0xF2A2,0xF2A3,0xEF47,0xF2A4,
0xD2C3,0xC6B5,0xEF48,0xCDC7,0xF2A5,0xEF49,0xD3B1,0xBFC5,
0xCCE2,0xEF4A,0xF2A6,0xF2A7,0xD1D5,0xB6EE,0xF2A8,0xF2A9,
0xB5DF,0xF2AA,0xF2AB,0xEF4B,0xB2FC,0xF2AC,0xF2AD,0xC8A7,
0xEF4C,0xEF4D,0xEF4E,0xEF4F,0xEF50,0xEF51,0xEF52,0xEF53,
0xEF54,0xEF55,0xEF56,0xEF57,0xEF58,0xEF59,0xEF5A,0xEF5B,
0xEF5C,0xEF5D,0xEF5E,0xEF5F,0xEF60,0xEF61,0xEF62,0xEF63,
0xEF64,0xEF65,0xEF66,0xEF67,0xEF68,0xEF69,0xEF6A,0xEF6B,
0xEF6C,0xEF6D,0xEF6E,0xEF6F,0xEF70,0xEF71,0xB7E7,0xEF72,
0xEF73,0xECA9,0xECAA,0xECAB,0xEF74,0xECAC,0xEF75,0xEF76,
0xC6AE,0xECAD,0xECAE,0xEF77,0xEF78,0xEF79,0xB7C9,0xCAB3,
0xEF7A,0xEF7B,0xEF7C,0xEF7D,0xEF7E,0xEF80,0xEF81,0xE2B8,
0xF7CF,0xEF82,0xEF83,0xEF84,0xEF85,0xEF86,0xEF87,0xEF88,
0xEF89,0xEF8A,0xEF8B,0xEF8C,0xEF8D,0xEF8E,0xEF8F,0xEF90,
0xEF91,0xEF92,0xEF93,0xEF94,0xEF95,0xEF96,0xEF97,0xEF98,
0xEF99,0xEF9A,0xEF9B,0xEF9C,0xEF9D,0xEF9E,0xEF9F,0xEFA0,
0xF040,0xF041,0xF042,0xF043,0xF044,0xF7D0,0xF045,0xF046,
0xB2CD,0xF047,0xF048,0xF049,0xF04A,0xF04B,0xF04C,0xF04D,
0xF04E,0xF04F,0xF050,0xF051,0xF052,0xF053,0xF054,0xF055,
0xF056,0xF057,0xF058,0xF059,0xF05A,0xF05B,0xF05C,0xF05D,
0xF05E,0xF05F,0xF060,0xF061,0xF062,0xF063,0xF7D1,0xF064,
0xF065,0xF066,0xF067,0xF068,0xF069,0xF06A,0xF06B,0xF06C,
0xF06D,0xF06E,0xF06F,0xF070,0xF071,0xF072,0xF073,0xF074,
0xF075,0xF076,0xF077,0xF078,0xF079,0xF07A,0xF07B,0xF07C,
0xF07D,0xF07E,0xF080,0xF081,0xF082,0xF083,0xF084,0xF085,
0xF086,0xF087,0xF088,0xF089,0xF7D3,0xF7D2,0xF08A,0xF08B,
0xF08C,0xF08D,0xF08E,0xF08F,0xF090,0xF091,0xF092,0xF093,
0xF094,0xF095,0xF096,0xE2BB,0xF097,0xBCA2,0xF098,0xE2BC,
0xE2BD,0xE2BE,0xE2BF,0xE2C0,0xE2C1,0xB7B9,0xD2FB,0xBDA4,
0xCACE,0xB1A5,0xCBC7,0xF099,0xE2C2,0xB6FC,0xC8C4,0xE2C3,
0xF09A,0xF09B,0xBDC8,0xF09C,0xB1FD,0xE2C4,0xF09D,0xB6F6,
0xE2C5,0xC4D9,0xF09E,0xF09F,0xE2C6,0xCFDA,0xB9DD,0xE2C7,
0xC0A1,0xF0A0,0xE2C8,0xB2F6,0xF140,0xE2C9,0xF141,0xC1F3,
0xE2CA,0xE2CB,0xC2F8,0xE2CC,0xE2CD,0xE2CE,0xCAD7,0xD8B8,
0xD9E5,0xCFE3,0xF142,0xF143,0xF144,0xF145,0xF146,0xF147,
0xF148,0xF149,0xF14A,0xF14B,0xF14C,0xF0A5,0xF14D,0xF14E,
0xDCB0,0xF14F,0xF150,0xF151,0xF152,0xF153,0xF154,0xF155,
0xF156,0xF157,0xF158,0xF159,0xF15A,0xF15B,0xF15C,0xF15D,
0xF15E,0xF15F,0xF160,0xF161,0xF162,0xF163,0xF164,0xF165,
0xF166,0xF167,0xF168,0xF169,0xF16A,0xF16B,0xF16C,0xF16D,
0xF16E,0xF16F,0xF170,0xF171,0xF172,0xF173,0xF174,0xF175,
0xF176,0xF177,0xF178,0xF179,0xF17A,0xF17B,0xF17C,0xF17D,
0xF17E,0xF180,0xF181,0xF182,0xF183,0xF184,0xF185,0xF186,
0xF187,0xF188,0xF189,0xF18A,0xF18B,0xF18C,0xF18D,0xF18E,
0xF18F,0xF190,0xF191,0xF192,0xF193,0xF194,0xF195,0xF196,
0xF197,0xF198,0xF199,0xF19A,0xF19B,0xF19C,0xF19D,0xF19E,
0xF19F,0xF1A0,0xF240,0xF241,0xF242,0xF243,0xF244,0xF245,
0xF246,0xF247,0xF248,0xF249,0xF24A,0xF24B,0xF24C,0xF24D,
0xF24E,0xF24F,0xF250,0xF251,0xF252,0xF253,0xF254,0xF255,
0xF256,0xF257,0xF258,0xF259,0xF25A,0xF25B,0xF25C,0xF25D,
0xF25E,0xF25F,0xF260,0xF261,0xF262,0xF263,0xF264,0xF265,
0xF266,0xF267,0xF268,0xF269,0xF26A,0xF26B,0xF26C,0xF26D,
0xF26E,0xF26F,0xF270,0xF271,0xF272,0xF273,0xF274,0xF275,
0xF276,0xF277,0xF278,0xF279,0xF27A,0xF27B,0xF27C,0xF27D,
0xF27E,0xF280,0xF281,0xF282,0xF283,0xF284,0xF285,0xF286,
0xF287,0xF288,0xF289,0xF28A,0xF28B,0xF28C,0xF28D,0xF28E,
0xF28F,0xF290,0xF291,0xF292,0xF293,0xF294,0xF295,0xF296,
0xF297,0xF298,0xF299,0xF29A,0xF29B,0xF29C,0xF29D,0xF29E,
0xF29F,0xF2A0,0xF340,0xF341,0xF342,0xF343,0xF344,0xF345,
0xF346,0xF347,0xF348,0xF349,0xF34A,0xF34B,0xF34C,0xF34D,
0xF34E,0xF34F,0xF350,0xF351,0xC2ED,0xD4A6,0xCDD4,0xD1B1,
0xB3DB,0xC7FD,0xF352,0xB2B5,0xC2BF,0xE6E0,0xCABB,0xE6E1,
0xE6E2,0xBED4,0xE6E3,0xD7A4,0xCDD5,0xE6E5,0xBCDD,0xE6E4,
0xE6E6,0xE6E7,0xC2EE,0xF353,0xBDBE,0xE6E8,0xC2E6,0xBAA7,
0xE6E9,0xF354,0xE6EA,0xB3D2,0xD1E9,0xF355,0xF356,0xBFA5,
0xE6EB,0xC6EF,0xE6EC,0xE6ED,0xF357,0xF358,0xE6EE,0xC6AD,
0xE6EF,0xF359,0xC9A7,0xE6F0,0xE6F1,0xE6F2,0xE5B9,0xE6F3,
0xE6F4,0xC2E2,0xE6F5,0xE6F6,0xD6E8,0xE6F7,0xF35A,0xE6F8,
0xB9C7,0xF35B,0xF35C,0xF35D,0xF35E,0xF35F,0xF360,0xF361,
0xF7BB,0xF7BA,0xF362,0xF363,0xF364,0xF365,0xF7BE,0xF7BC,
0xBAA1,0xF366,0xF7BF,0xF367,0xF7C0,0xF368,0xF369,0xF36A,
0xF7C2,0xF7C1,0xF7C4,0xF36B,0xF36C,0xF7C3,0xF36D,0xF36E,
0xF36F,0xF370,0xF371,0xF7C5,0xF7C6,0xF372,0xF373,0xF374,
0xF375,0xF7C7,0xF376,0xCBE8,0xF377,0xF378,0xF379,0xF37A,
0xB8DF,0xF37B,0xF37C,0xF37D,0xF37E,0xF380,0xF381,0xF7D4,
0xF382,0xF7D5,0xF383,0xF384,0xF385,0xF386,0xF7D6,0xF387,
0xF388,0xF389,0xF38A,0xF7D8,0xF38B,0xF7DA,0xF38C,0xF7D7,
0xF38D,0xF38E,0xF38F,0xF390,0xF391,0xF392,0xF393,0xF394,
0xF395,0xF7DB,0xF396,0xF7D9,0xF397,0xF398,0xF399,0xF39A,
0xF39B,0xF39C,0xF39D,0xD7D7,0xF39E,0xF39F,0xF3A0,0xF440,
0xF7DC,0xF441,0xF442,0xF443,0xF444,0xF445,0xF446,0xF7DD,
0xF447,0xF448,0xF449,0xF7DE,0xF44A,0xF44B,0xF44C,0xF44D,
0xF44E,0xF44F,0xF450,0xF451,0xF452,0xF453,0xF454,0xF7DF,
0xF455,0xF456,0xF457,0xF7E0,0xF458,0xF459,0xF45A,0xF45B,
0xF45C,0xF45D,0xF45E,0xF45F,0xF460,0xF461,0xF462,0xDBCB,
0xF463,0xF464,0xD8AA,0xF465,0xF466,0xF467,0xF468,0xF469,
0xF46A,0xF46B,0xF46C,0xE5F7,0xB9ED,0xF46D,0xF46E,0xF46F,
0xF470,0xBFFD,0xBBEA,0xF7C9,0xC6C7,0xF7C8,0xF471,0xF7CA,
0xF7CC,0xF7CB,0xF472,0xF473,0xF474,0xF7CD,0xF475,0xCEBA,
0xF476,0xF7CE,0xF477,0xF478,0xC4A7,0xF479,0xF47A,0xF47B,
0xF47C,0xF47D,0xF47E,0xF480,0xF481,0xF482,0xF483,0xF484,
0xF485,0xF486,0xF487,0xF488,0xF489,0xF48A,0xF48B,0xF48C,
0xF48D,0xF48E,0xF48F,0xF490,0xF491,0xF492,0xF493,0xF494,
0xF495,0xF496,0xF497,0xF498,0xF499,0xF49A,0xF49B,0xF49C,
0xF49D,0xF49E,0xF49F,0xF4A0,0xF540,0xF541,0xF542,0xF543,
0xF544,0xF545,0xF546,0xF547,0xF548,0xF549,0xF54A,0xF54B,
0xF54C,0xF54D,0xF54E,0xF54F,0xF550,0xF551,0xF552,0xF553,
0xF554,0xF555,0xF556,0xF557,0xF558,0xF559,0xF55A,0xF55B,
0xF55C,0xF55D,0xF55E,0xF55F,0xF560,0xF561,0xF562,0xF563,
0xF564,0xF565,0xF566,0xF567,0xF568,0xF569,0xF56A,0xF56B,
0xF56C,0xF56D,0xF56E,0xF56F,0xF570,0xF571,0xF572,0xF573,
0xF574,0xF575,0xF576,0xF577,0xF578,0xF579,0xF57A,0xF57B,
0xF57C,0xF57D,0xF57E,0xF580,0xF581,0xF582,0xF583,0xF584,
0xF585,0xF586,0xF587,0xF588,0xF589,0xF58A,0xF58B,0xF58C,
0xF58D,0xF58E,0xF58F,0xF590,0xF591,0xF592,0xF593,0xF594,
0xF595,0xF596,0xF597,0xF598,0xF599,0xF59A,0xF59B,0xF59C,
0xF59D,0xF59E,0xF59F,0xF5A0,0xF640,0xF641,0xF642,0xF643,
0xF644,0xF645,0xF646,0xF647,0xF648,0xF649,0xF64A,0xF64B,
0xF64C,0xF64D,0xF64E,0xF64F,0xF650,0xF651,0xF652,0xF653,
0xF654,0xF655,0xF656,0xF657,0xF658,0xF659,0xF65A,0xF65B,
0xF65C,0xF65D,0xF65E,0xF65F,0xF660,0xF661,0xF662,0xF663,
0xF664,0xF665,0xF666,0xF667,0xF668,0xF669,0xF66A,0xF66B,
0xF66C,0xF66D,0xF66E,0xF66F,0xF670,0xF671,0xF672,0xF673,
0xF674,0xF675,0xF676,0xF677,0xF678,0xF679,0xF67A,0xF67B,
0xF67C,0xF67D,0xF67E,0xF680,0xF681,0xF682,0xF683,0xF684,
0xF685,0xF686,0xF687,0xF688,0xF689,0xF68A,0xF68B,0xF68C,
0xF68D,0xF68E,0xF68F,0xF690,0xF691,0xF692,0xF693,0xF694,
0xF695,0xF696,0xF697,0xF698,0xF699,0xF69A,0xF69B,0xF69C,
0xF69D,0xF69E,0xF69F,0xF6A0,0xF740,0xF741,0xF742,0xF743,
0xF744,0xF745,0xF746,0xF747,0xF748,0xF749,0xF74A,0xF74B,
0xF74C,0xF74D,0xF74E,0xF74F,0xF750,0xF751,0xF752,0xF753,
0xF754,0xF755,0xF756,0xF757,0xF758,0xF759,0xF75A,0xF75B,
0xF75C,0xF75D,0xF75E,0xF75F,0xF760,0xF761,0xF762,0xF763,
0xF764,0xF765,0xF766,0xF767,0xF768,0xF769,0xF76A,0xF76B,
0xF76C,0xF76D,0xF76E,0xF76F,0xF770,0xF771,0xF772,0xF773,
0xF774,0xF775,0xF776,0xF777,0xF778,0xF779,0xF77A,0xF77B,
0xF77C,0xF77D,0xF77E,0xF780,0xD3E3,0xF781,0xF782,0xF6CF,
0xF783,0xC2B3,0xF6D0,0xF784,0xF785,0xF6D1,0xF6D2,0xF6D3,
0xF6D4,0xF786,0xF787,0xF6D6,0xF788,0xB1AB,0xF6D7,0xF789,
0xF6D8,0xF6D9,0xF6DA,0xF78A,0xF6DB,0xF6DC,0xF78B,0xF78C,
0xF78D,0xF78E,0xF6DD,0xF6DE,0xCFCA,0xF78F,0xF6DF,0xF6E0,
0xF6E1,0xF6E2,0xF6E3,0xF6E4,0xC0F0,0xF6E5,0xF6E6,0xF6E7,
0xF6E8,0xF6E9,0xF790,0xF6EA,0xF791,0xF6EB,0xF6EC,0xF792,
0xF6ED,0xF6EE,0xF6EF,0xF6F0,0xF6F1,0xF6F2,0xF6F3,0xF6F4,
0xBEA8,0xF793,0xF6F5,0xF6F6,0xF6F7,0xF6F8,0xF794,0xF795,
0xF796,0xF797,0xF798,0xC8FA,0xF6F9,0xF6FA,0xF6FB,0xF6FC,
0xF799,0xF79A,0xF6FD,0xF6FE,0xF7A1,0xF7A2,0xF7A3,0xF7A4,
0xF7A5,0xF79B,0xF79C,0xF7A6,0xF7A7,0xF7A8,0xB1EE,0xF7A9,
0xF7AA,0xF7AB,0xF79D,0xF79E,0xF7AC,0xF7AD,0xC1DB,0xF7AE,
0xF79F,0xF7A0,0xF7AF,0xF840,0xF841,0xF842,0xF843,0xF844,
0xF845,0xF846,0xF847,0xF848,0xF849,0xF84A,0xF84B,0xF84C,
0xF84D,0xF84E,0xF84F,0xF850,0xF851,0xF852,0xF853,0xF854,
0xF855,0xF856,0xF857,0xF858,0xF859,0xF85A,0xF85B,0xF85C,
0xF85D,0xF85E,0xF85F,0xF860,0xF861,0xF862,0xF863,0xF864,
0xF865,0xF866,0xF867,0xF868,0xF869,0xF86A,0xF86B,0xF86C,
0xF86D,0xF86E,0xF86F,0xF870,0xF871,0xF872,0xF873,0xF874,
0xF875,0xF876,0xF877,0xF878,0xF879,0xF87A,0xF87B,0xF87C,
0xF87D,0xF87E,0xF880,0xF881,0xF882,0xF883,0xF884,0xF885,
0xF886,0xF887,0xF888,0xF889,0xF88A,0xF88B,0xF88C,0xF88D,
0xF88E,0xF88F,0xF890,0xF891,0xF892,0xF893,0xF894,0xF895,
0xF896,0xF897,0xF898,0xF899,0xF89A,0xF89B,0xF89C,0xF89D,
0xF89E,0xF89F,0xF8A0,0xF940,0xF941,0xF942,0xF943,0xF944,
0xF945,0xF946,0xF947,0xF948,0xF949,0xF94A,0xF94B,0xF94C,
0xF94D,0xF94E,0xF94F,0xF950,0xF951,0xF952,0xF953,0xF954,
0xF955,0xF956,0xF957,0xF958,0xF959,0xF95A,0xF95B,0xF95C,
0xF95D,0xF95E,0xF95F,0xF960,0xF961,0xF962,0xF963,0xF964,
0xF965,0xF966,0xF967,0xF968,0xF969,0xF96A,0xF96B,0xF96C,
0xF96D,0xF96E,0xF96F,0xF970,0xF971,0xF972,0xF973,0xF974,
0xF975,0xF976,0xF977,0xF978,0xF979,0xF97A,0xF97B,0xF97C,
0xF97D,0xF97E,0xF980,0xF981,0xF982,0xF983,0xF984,0xF985,
0xF986,0xF987,0xF988,0xF989,0xF98A,0xF98B,0xF98C,0xF98D,
0xF98E,0xF98F,0xF990,0xF991,0xF992,0xF993,0xF994,0xF995,
0xF996,0xF997,0xF998,0xF999,0xF99A,0xF99B,0xF99C,0xF99D,
0xF99E,0xF99F,0xF9A0,0xFA40,0xFA41,0xFA42,0xFA43,0xFA44,
0xFA45,0xFA46,0xFA47,0xFA48,0xFA49,0xFA4A,0xFA4B,0xFA4C,
0xFA4D,0xFA4E,0xFA4F,0xFA50,0xFA51,0xFA52,0xFA53,0xFA54,
0xFA55,0xFA56,0xFA57,0xFA58,0xFA59,0xFA5A,0xFA5B,0xFA5C,
0xFA5D,0xFA5E,0xFA5F,0xFA60,0xFA61,0xFA62,0xFA63,0xFA64,
0xFA65,0xFA66,0xFA67,0xFA68,0xFA69,0xFA6A,0xFA6B,0xFA6C,
0xFA6D,0xFA6E,0xFA6F,0xFA70,0xFA71,0xFA72,0xFA73,0xFA74,
0xFA75,0xFA76,0xFA77,0xFA78,0xFA79,0xFA7A,0xFA7B,0xFA7C,
0xFA7D,0xFA7E,0xFA80,0xFA81,0xFA82,0xFA83,0xFA84,0xFA85,
0xFA86,0xFA87,0xFA88,0xFA89,0xFA8A,0xFA8B,0xFA8C,0xFA8D,
0xFA8E,0xFA8F,0xFA90,0xFA91,0xFA92,0xFA93,0xFA94,0xFA95,
0xFA96,0xFA97,0xFA98,0xFA99,0xFA9A,0xFA9B,0xFA9C,0xFA9D,
0xFA9E,0xFA9F,0xFAA0,0xFB40,0xFB41,0xFB42,0xFB43,0xFB44,
0xFB45,0xFB46,0xFB47,0xFB48,0xFB49,0xFB4A,0xFB4B,0xFB4C,
0xFB4D,0xFB4E,0xFB4F,0xFB50,0xFB51,0xFB52,0xFB53,0xFB54,
0xFB55,0xFB56,0xFB57,0xFB58,0xFB59,0xFB5A,0xFB5B,0xC4F1,
0xF0AF,0xBCA6,0xF0B0,0xC3F9,0xFB5C,0xC5B8,0xD1BB,0xFB5D,
0xF0B1,0xF0B2,0xF0B3,0xF0B4,0xF0B5,0xD1BC,0xFB5E,0xD1EC,
0xFB5F,0xF0B7,0xF0B6,0xD4A7,0xFB60,0xCDD2,0xF0B8,0xF0BA,
0xF0B9,0xF0BB,0xF0BC,0xFB61,0xFB62,0xB8EB,0xF0BD,0xBAE8,
0xFB63,0xF0BE,0xF0BF,0xBEE9,0xF0C0,0xB6EC,0xF0C1,0xF0C2,
0xF0C3,0xF0C4,0xC8B5,0xF0C5,0xF0C6,0xFB64,0xF0C7,0xC5F4,
0xFB65,0xF0C8,0xFB66,0xFB67,0xFB68,0xF0C9,0xFB69,0xF0CA,
0xF7BD,0xFB6A,0xF0CB,0xF0CC,0xF0CD,0xFB6B,0xF0CE,0xFB6C,
0xFB6D,0xFB6E,0xFB6F,0xF0CF,0xBAD7,0xFB70,0xF0D0,0xF0D1,
0xF0D2,0xF0D3,0xF0D4,0xF0D5,0xF0D6,0xF0D8,0xFB71,0xFB72,
0xD3A5,0xF0D7,0xFB73,0xF0D9,0xFB74,0xFB75,0xFB76,0xFB77,
0xFB78,0xFB79,0xFB7A,0xFB7B,0xFB7C,0xFB7D,0xF5BA,0xC2B9,
0xFB7E,0xFB80,0xF7E4,0xFB81,0xFB82,0xFB83,0xFB84,0xF7E5,
0xF7E6,0xFB85,0xFB86,0xF7E7,0xFB87,0xFB88,0xFB89,0xFB8A,
0xFB8B,0xFB8C,0xF7E8,0xC2B4,0xFB8D,0xFB8E,0xFB8F,0xFB90,
0xFB91,0xFB92,0xFB93,0xFB94,0xFB95,0xF7EA,0xFB96,0xF7EB,
0xFB97,0xFB98,0xFB99,0xFB9A,0xFB9B,0xFB9C,0xC2F3,0xFB9D,
0xFB9E,0xFB9F,0xFBA0,0xFC40,0xFC41,0xFC42,0xFC43,0xFC44,
0xFC45,0xFC46,0xFC47,0xFC48,0xF4F0,0xFC49,0xFC4A,0xFC4B,
0xF4EF,0xFC4C,0xFC4D,0xC2E9,0xFC4E,0xF7E1,0xF7E2,0xFC4F,
0xFC50,0xFC51,0xFC52,0xFC53,0xBBC6,0xFC54,0xFC55,0xFC56,
0xFC57,0xD9E4,0xFC58,0xFC59,0xFC5A,0xCAF2,0xC0E8,0xF0A4,
0xFC5B,0xBADA,0xFC5C,0xFC5D,0xC7AD,0xFC5E,0xFC5F,0xFC60,
0xC4AC,0xFC61,0xFC62,0xF7EC,0xF7ED,0xF7EE,0xFC63,0xF7F0,
0xF7EF,0xFC64,0xF7F1,0xFC65,0xFC66,0xF7F4,0xFC67,0xF7F3,
0xFC68,0xF7F2,0xF7F5,0xFC69,0xFC6A,0xFC6B,0xFC6C,0xF7F6,
0xFC6D,0xFC6E,0xFC6F,0xFC70,0xFC71,0xFC72,0xFC73,0xFC74,
0xFC75,0xEDE9,0xFC76,0xEDEA,0xEDEB,0xFC77,0xF6BC,0xFC78,
0xFC79,0xFC7A,0xFC7B,0xFC7C,0xFC7D,0xFC7E,0xFC80,0xFC81,
0xFC82,0xFC83,0xFC84,0xF6BD,0xFC85,0xF6BE,0xB6A6,0xFC86,
0xD8BE,0xFC87,0xFC88,0xB9C4,0xFC89,0xFC8A,0xFC8B,0xD8BB,
0xFC8C,0xDCB1,0xFC8D,0xFC8E,0xFC8F,0xFC90,0xFC91,0xFC92,
0xCAF3,0xFC93,0xF7F7,0xFC94,0xFC95,0xFC96,0xFC97,0xFC98,
0xFC99,0xFC9A,0xFC9B,0xFC9C,0xF7F8,0xFC9D,0xFC9E,0xF7F9,
0xFC9F,0xFCA0,0xFD40,0xFD41,0xFD42,0xFD43,0xFD44,0xF7FB,
0xFD45,0xF7FA,0xFD46,0xB1C7,0xFD47,0xF7FC,0xF7FD,0xFD48,
0xFD49,0xFD4A,0xFD4B,0xFD4C,0xF7FE,0xFD4D,0xFD4E,0xFD4F,
0xFD50,0xFD51,0xFD52,0xFD53,0xFD54,0xFD55,0xFD56,0xFD57,
0xC6EB,0xECB4,0xFD58,0xFD59,0xFD5A,0xFD5B,0xFD5C,0xFD5D,
0xFD5E,0xFD5F,0xFD60,0xFD61,0xFD62,0xFD63,0xFD64,0xFD65,
0xFD66,0xFD67,0xFD68,0xFD69,0xFD6A,0xFD6B,0xFD6C,0xFD6D,
0xFD6E,0xFD6F,0xFD70,0xFD71,0xFD72,0xFD73,0xFD74,0xFD75,
0xFD76,0xFD77,0xFD78,0xFD79,0xFD7A,0xFD7B,0xFD7C,0xFD7D,
0xFD7E,0xFD80,0xFD81,0xFD82,0xFD83,0xFD84,0xFD85,0xB3DD,
0xF6B3,0xFD86,0xFD87,0xF6B4,0xC1E4,0xF6B5,0xF6B6,0xF6B7,
0xF6B8,0xF6B9,0xF6BA,0xC8A3,0xF6BB,0xFD88,0xFD89,0xFD8A,
0xFD8B,0xFD8C,0xFD8D,0xFD8E,0xFD8F,0xFD90,0xFD91,0xFD92,
0xFD93,0xC1FA,0xB9A8,0xEDE8,0xFD94,0xFD95,0xFD96,0xB9EA,
0xD9DF,0xFD97,0xFD98,0xFD99,0xFD9A,0xFD9B};

/* page 7 0xF92C-0xFA29 */
static const uint16 tab_uni_gbk7[]={
0xFD9C,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xFD9D,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0xFD9E,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,0xFD9F,     0,     0,     0,     0,
     0,     0,     0,     0,     0,0xFDA0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xFE40,0xFE41,0xFE42,0xFE43,     0,0xFE44,     0,0xFE45,
0xFE46,     0,     0,     0,0xFE47,     0,     0,     0,
     0,     0,     0,0xFE48,0xFE49,0xFE4A,     0,0xFE4B,
0xFE4C,     0,     0,0xFE4D,0xFE4E,0xFE4F};

/* page 8 0xFE30-0xFFE5 */
static const uint16 tab_uni_gbk8[]={
0xA955,0xA6F2,     0,0xA6F4,0xA6F5,0xA6E0,0xA6E1,0xA6F0,
0xA6F1,0xA6E2,0xA6E3,0xA6EE,0xA6EF,0xA6E6,0xA6E7,0xA6E4,
0xA6E5,0xA6E8,0xA6E9,0xA6EA,0xA6EB,     0,     0,     0,
     0,0xA968,0xA969,0xA96A,0xA96B,0xA96C,0xA96D,0xA96E,
0xA96F,0xA970,0xA971,     0,0xA972,0xA973,0xA974,0xA975,
     0,0xA976,0xA977,0xA978,0xA979,0xA97A,0xA97B,0xA97C,
0xA97D,0xA97E,0xA980,0xA981,0xA982,0xA983,0xA984,     0,
0xA985,0xA986,0xA987,0xA988,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,0xA3A1,0xA3A2,0xA3A3,0xA1E7,0xA3A5,0xA3A6,0xA3A7,
0xA3A8,0xA3A9,0xA3AA,0xA3AB,0xA3AC,0xA3AD,0xA3AE,0xA3AF,
0xA3B0,0xA3B1,0xA3B2,0xA3B3,0xA3B4,0xA3B5,0xA3B6,0xA3B7,
0xA3B8,0xA3B9,0xA3BA,0xA3BB,0xA3BC,0xA3BD,0xA3BE,0xA3BF,
0xA3C0,0xA3C1,0xA3C2,0xA3C3,0xA3C4,0xA3C5,0xA3C6,0xA3C7,
0xA3C8,0xA3C9,0xA3CA,0xA3CB,0xA3CC,0xA3CD,0xA3CE,0xA3CF,
0xA3D0,0xA3D1,0xA3D2,0xA3D3,0xA3D4,0xA3D5,0xA3D6,0xA3D7,
0xA3D8,0xA3D9,0xA3DA,0xA3DB,0xA3DC,0xA3DD,0xA3DE,0xA3DF,
0xA3E0,0xA3E1,0xA3E2,0xA3E3,0xA3E4,0xA3E5,0xA3E6,0xA3E7,
0xA3E8,0xA3E9,0xA3EA,0xA3EB,0xA3EC,0xA3ED,0xA3EE,0xA3EF,
0xA3F0,0xA3F1,0xA3F2,0xA3F3,0xA3F4,0xA3F5,0xA3F6,0xA3F7,
0xA3F8,0xA3F9,0xA3FA,0xA3FB,0xA3FC,0xA3FD,0xA1AB,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,
0xA1E9,0xA1EA,0xA956,0xA3FE,0xA957,0xA3A4};

static int func_uni_gbk_onechar(int code){
  if ((code>=0x00A4)&&(code<=0x0451))
    return(tab_uni_gbk0[code-0x00A4]);
  if ((code>=0x2010)&&(code<=0x2312))
    return(tab_uni_gbk1[code-0x2010]);
  if ((code>=0x2460)&&(code<=0x2642))
    return(tab_uni_gbk2[code-0x2460]);
  if ((code>=0x3000)&&(code<=0x3129))
    return(tab_uni_gbk3[code-0x3000]);
  if ((code>=0x3220)&&(code<=0x32A3))
    return(tab_uni_gbk4[code-0x3220]);
  if ((code>=0x338E)&&(code<=0x33D5))
    return(tab_uni_gbk5[code-0x338E]);
  if ((code>=0x4E00)&&(code<=0x9FA5))
    return(tab_uni_gbk6[code-0x4E00]);
  if ((code>=0xF92C)&&(code<=0xFA29))
    return(tab_uni_gbk7[code-0xF92C]);
  if ((code>=0xFE30)&&(code<=0xFFE5))
    return(tab_uni_gbk8[code-0xFE30]);
  return(0);
}

static int
my_wc_mb_gbk(CHARSET_INFO *cs  __attribute__((unused)),
	      my_wc_t wc, uchar *s, uchar *e)
{
  int code;
  
  if (s >= e)
    return MY_CS_TOOSMALL;
  
  if ((uint) wc < 0x80)
  {
    s[0]= (uchar) wc;
    return 1;
  }
  
  if (!(code=func_uni_gbk_onechar(wc)))
    return MY_CS_ILUNI;
  
  if (s+2>e)
    return MY_CS_TOOSMALL2;
    
  s[0]=code>>8;
  s[1]=code&0xFF;
  return 2;
}

static int
my_mb_wc_gbk(CHARSET_INFO *cs __attribute__((unused)),
	      my_wc_t *pwc, const uchar *s, const uchar *e)
{
  int hi;
  
  if (s >= e)
    return MY_CS_TOOSMALL;
  
  hi=s[0];
  
  if (hi<0x80)
  {
    pwc[0]=hi;
    return 1;
  }
  
  if (s+2>e)
    return MY_CS_TOOSMALL2;
    
  if (!IS_MB2_CHAR(hi, s[1]))
    return MY_CS_ILSEQ;
  
  if (!(pwc[0]=func_gbk_uni_onechar( (hi<<8) + s[1])))
    return -2;
  
  return 2;
  
}


#define MY_FUNCTION_NAME(x)   my_ ## x ## _gbk_chinese_ci
#define WEIGHT_MB1(x)        (sort_order_gbk[(uchar) (x)])
#define WEIGHT_MB2(x,y)      (gbksortorder(gbkcode(x,y)))
#define DEFINE_STRNXFRM
#include "strcoll.ic"


#define MY_FUNCTION_NAME(x)   my_ ## x ## _gbk_bin
#define WEIGHT_MB1(x)        ((uchar) (x))
#define WEIGHT_MB2(x,y)      (gbkcode(x,y))
#include "strcoll.ic"


#define DEFINE_STRNNCOLLSP_NOPAD
#define MY_FUNCTION_NAME(x)   my_ ## x ## _gbk_chinese_nopad_ci
#define WEIGHT_MB1(x)        (sort_order_gbk[(uchar) (x)])
#define WEIGHT_MB2(x,y)      (gbksortorder(gbkcode(x,y)))
#define DEFINE_STRNXFRM
#include "strcoll.ic"


#define DEFINE_STRNNCOLLSP_NOPAD
#define MY_FUNCTION_NAME(x)   my_ ## x ## _gbk_nopad_bin
#define WEIGHT_MB1(x)        ((uchar) (x))
#define WEIGHT_MB2(x,y)      (gbkcode(x,y))
#include "strcoll.ic"


static MY_COLLATION_HANDLER my_collation_handler_gbk_chinese_ci=
{
  NULL,                 /* init */
  my_strnncoll_gbk_chinese_ci,
  my_strnncollsp_gbk_chinese_ci,
  my_strnxfrm_gbk_chinese_ci,
  my_strnxfrmlen_simple,
  my_like_range_mb,
  my_wildcmp_mb,
  my_strcasecmp_mb,
  my_instr_mb,
  my_hash_sort_simple,
  my_propagate_simple
};


static MY_COLLATION_HANDLER my_collation_handler_gbk_bin=
{
  NULL,                 /* init */
  my_strnncoll_gbk_bin,
  my_strnncollsp_gbk_bin,
  my_strnxfrm_mb,
  my_strnxfrmlen_simple,
  my_like_range_mb,
  my_wildcmp_mb_bin,
  my_strcasecmp_mb_bin,
  my_instr_mb,
  my_hash_sort_mb_bin,
  my_propagate_simple
};


static MY_COLLATION_HANDLER my_collation_handler_gbk_chinese_nopad_ci=
{
  NULL,                 /* init */
  my_strnncoll_gbk_chinese_ci,
  my_strnncollsp_gbk_chinese_nopad_ci,
  my_strnxfrm_gbk_chinese_nopad_ci,
  my_strnxfrmlen_simple,
  my_like_range_mb,
  my_wildcmp_mb,
  my_strcasecmp_mb,
  my_instr_mb,
  my_hash_sort_simple_nopad,
  my_propagate_simple
};


static MY_COLLATION_HANDLER my_collation_handler_gbk_nopad_bin=
{
  NULL,                 /* init */
  my_strnncoll_gbk_bin,
  my_strnncollsp_gbk_nopad_bin,
  my_strnxfrm_mb_nopad,
  my_strnxfrmlen_simple,
  my_like_range_mb,
  my_wildcmp_mb_bin,
  my_strcasecmp_mb_bin,
  my_instr_mb,
  my_hash_sort_mb_nopad_bin,
  my_propagate_simple
};

static MY_CHARSET_HANDLER my_charset_handler=
{
  NULL,			/* init */
  my_numchars_mb,
  my_charpos_mb,
  my_lengthsp_8bit,
  my_numcells_8bit,
  my_mb_wc_gbk,
  my_wc_mb_gbk,
  my_mb_ctype_mb,
  my_caseup_str_mb,
  my_casedn_str_mb,
  my_caseup_mb,
  my_casedn_mb,
  my_snprintf_8bit,
  my_long10_to_str_8bit,
  my_longlong10_to_str_8bit,
  my_fill_8bit,
  my_strntol_8bit,
  my_strntoul_8bit,
  my_strntoll_8bit,
  my_strntoull_8bit,
  my_strntod_8bit,
  my_strtoll10_8bit,
  my_strntoull10rnd_8bit,
  my_scan_8bit,
  my_charlen_gbk,
  my_well_formed_char_length_gbk,
  my_copy_fix_mb,
  my_native_to_mb_gbk,
  my_wc_to_printable_generic
};


struct charset_info_st my_charset_gbk_chinese_ci=
{
    28,0,0,		/* number */
    MY_CS_COMPILED|MY_CS_PRIMARY|MY_CS_STRNXFRM,	/* state      */
    "gbk",		/* cs name    */
    "gbk_chinese_ci",	/* name */
    "",			/* comment    */
    NULL,		/* tailoring */
    ctype_gbk,
    to_lower_gbk,
    to_upper_gbk,
    sort_order_gbk,
    NULL,		/* uca          */
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    &my_caseinfo_gbk,   /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    1,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen   */
    2,			/* mbmaxlen */
    0,			/* min_sort_char */
    0xA967,		/* max_sort_char */
    ' ',                /* pad char      */
    1,                  /* escape_with_backslash_is_dangerous */
    1,                  /* levels_for_order   */
    &my_charset_handler,
    &my_collation_handler_gbk_chinese_ci
};

struct charset_info_st my_charset_gbk_bin=
{
    87,0,0,		/* number */
    MY_CS_COMPILED|MY_CS_BINSORT,	/* state      */
    "gbk",		/* cs name    */
    "gbk_bin",		/* name */
    "",			/* comment    */
    NULL,		/* tailoring */
    ctype_gbk,
    to_lower_gbk,
    to_upper_gbk,
    NULL,		/* sort_order   */
    NULL,		/* uca          */
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    &my_caseinfo_gbk,   /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    1,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen   */
    2,			/* mbmaxlen */
    0,			/* min_sort_char */
    0xFEFE,		/* max_sort_char */
    ' ',                /* pad char      */
    1,                  /* escape_with_backslash_is_dangerous */
    1,                  /* levels_for_order   */
    &my_charset_handler,
    &my_collation_handler_gbk_bin
};


struct charset_info_st my_charset_gbk_chinese_nopad_ci=
{
    MY_NOPAD_ID(28),0,0,/* number           */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_NOPAD, /* state */
    "gbk",              /* cs name          */
    "gbk_chinese_nopad_ci",/* name          */
    "",                 /* comment          */
    NULL,               /* tailoring        */
    ctype_gbk,
    to_lower_gbk,
    to_upper_gbk,
    sort_order_gbk,
    NULL,               /* uca              */
    NULL,               /* tab_to_uni       */
    NULL,               /* tab_from_uni     */
    &my_caseinfo_gbk,   /* caseinfo         */
    NULL,               /* state_map        */
    NULL,               /* ident_map        */
    1,                  /* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,                  /* mbminlen         */
    2,                  /* mbmaxlen         */
    0,                  /* min_sort_char    */
    0xA967,             /* max_sort_char    */
    ' ',                /* pad char         */
    1,                  /* escape_with_backslash_is_dangerous */
    1,                  /* levels_for_order */
    &my_charset_handler,
    &my_collation_handler_gbk_chinese_nopad_ci
};

struct charset_info_st my_charset_gbk_nopad_bin=
{
    MY_NOPAD_ID(87),0,0,/* number           */
    MY_CS_COMPILED|MY_CS_BINSORT|MY_CS_NOPAD, /* state */
    "gbk",              /* cs name          */
    "gbk_nopad_bin",    /* name             */
    "",                 /* comment          */
    NULL,               /* tailoring        */
    ctype_gbk,
    to_lower_gbk,
    to_upper_gbk,
    NULL,               /* sort_order       */
    NULL,               /* uca              */
    NULL,               /* tab_to_uni       */
    NULL,               /* tab_from_uni     */
    &my_caseinfo_gbk,   /* caseinfo         */
    NULL,               /* state_map        */
    NULL,               /* ident_map        */
    1,                  /* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,                  /* mbminlen         */
    2,                  /* mbmaxlen         */
    0,                  /* min_sort_char    */
    0xFEFE,             /* max_sort_char    */
    ' ',                /* pad char         */
    1,                  /* escape_with_backslash_is_dangerous */
    1,                  /* levels_for_order */
    &my_charset_handler,
    &my_collation_handler_gbk_nopad_bin
};

#endif
