/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.io.IOException;
import java.io.InputStream;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.util.buffer.Buffer;

public class BinaryRowPacket
implements RowPacket {
    private final ColumnInformation[] columnInformation;
    private final int columnInformationLength;

    public BinaryRowPacket(ColumnInformation[] columnInformation, int columnInformationLength) {
        this.columnInformation = columnInformation;
        this.columnInformationLength = columnInformationLength;
    }

    public long appendPacketIfNeeded(Buffer buffer, ReadPacketFetcher packetFetcher) throws IOException {
        long encLength = buffer.getLengthEncodedBinary();
        while (encLength > (long)buffer.remaining()) {
            buffer.appendPacket(packetFetcher.getPacket());
        }
        return encLength;
    }

    public void appendPacketIfNeeded(Buffer buffer, ReadPacketFetcher packetFetcher, long encLength) throws IOException {
        while (encLength > (long)buffer.remaining()) {
            buffer.appendPacket(packetFetcher.getPacket());
        }
    }

    @Override
    public byte[][] getRow(ReadPacketFetcher packetFetcher, Buffer buffer) throws IOException {
        byte[][] valueObjects = new byte[this.columnInformationLength][];
        buffer.skipByte();
        int nullCount = (this.columnInformationLength + 9) / 8;
        byte[] nullBitsBuffer = buffer.readRawBytes(nullCount);
        block9: for (int i2 = 0; i2 < this.columnInformationLength; ++i2) {
            if ((nullBitsBuffer[(i2 + 2) / 8] & 1 << (i2 + 2) % 8) > 0) {
                valueObjects[i2] = null;
                continue;
            }
            switch (this.columnInformation[i2].getType()) {
                case VARCHAR: 
                case BIT: 
                case ENUM: 
                case SET: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case VARSTRING: 
                case STRING: 
                case GEOMETRY: 
                case OLDDECIMAL: 
                case DECIMAL: 
                case TIME: 
                case DATE: 
                case DATETIME: 
                case TIMESTAMP: {
                    long length = this.appendPacketIfNeeded(buffer, packetFetcher);
                    valueObjects[i2] = buffer.getLengthEncodedBytesWithLength(length);
                    continue block9;
                }
                case BIGINT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 8L);
                    valueObjects[i2] = buffer.getLengthEncodedBytesWithLength(8L);
                    continue block9;
                }
                case INTEGER: 
                case MEDIUMINT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 4L);
                    valueObjects[i2] = buffer.getLengthEncodedBytesWithLength(4L);
                    continue block9;
                }
                case SMALLINT: 
                case YEAR: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 2L);
                    valueObjects[i2] = buffer.getLengthEncodedBytesWithLength(2L);
                    continue block9;
                }
                case TINYINT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 1L);
                    valueObjects[i2] = buffer.getLengthEncodedBytesWithLength(1L);
                    continue block9;
                }
                case DOUBLE: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 8L);
                    valueObjects[i2] = buffer.getLengthEncodedBytesWithLength(8L);
                    continue block9;
                }
                case FLOAT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 4L);
                    valueObjects[i2] = buffer.getLengthEncodedBytesWithLength(4L);
                    continue block9;
                }
                default: {
                    this.appendPacketIfNeeded(buffer, packetFetcher);
                    valueObjects[i2] = null;
                }
            }
        }
        return valueObjects;
    }

    @Override
    public byte[][] getRow(ReadPacketFetcher packetFetcher, InputStream inputStream, int remaining, int read) throws IOException {
        byte[][] valueObjects = new byte[this.columnInformationLength][];
        int nullCount = (this.columnInformationLength + 9) / 8;
        byte[] nullBitsBuffer = packetFetcher.readLength(nullCount);
        remaining -= nullCount;
        block13: for (int i2 = 0; i2 < this.columnInformationLength; ++i2) {
            if ((nullBitsBuffer[(i2 + 2) / 8] & 1 << (i2 + 2) % 8) > 0) {
                valueObjects[i2] = null;
                continue;
            }
            switch (this.columnInformation[i2].getType()) {
                case VARCHAR: 
                case BIT: 
                case ENUM: 
                case SET: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case VARSTRING: 
                case STRING: 
                case GEOMETRY: 
                case OLDDECIMAL: 
                case DECIMAL: 
                case TIME: 
                case DATE: 
                case DATETIME: 
                case TIMESTAMP: {
                    int toReadLen;
                    read = inputStream.read() & 0xFF;
                    --remaining;
                    switch (read) {
                        case 251: {
                            toReadLen = -1;
                            break;
                        }
                        case 252: {
                            toReadLen = (inputStream.read() & 0xFF) + ((inputStream.read() & 0xFF) << 8);
                            remaining -= 2;
                            break;
                        }
                        case 253: {
                            toReadLen = (inputStream.read() & 0xFF) + ((inputStream.read() & 0xFF) << 8) + ((inputStream.read() & 0xFF) << 16);
                            remaining -= 3;
                            break;
                        }
                        case 254: {
                            toReadLen = (int)((long)(inputStream.read() & 0xFF) + ((long)(inputStream.read() & 0xFF) << 8) + ((long)(inputStream.read() & 0xFF) << 16) + ((long)(inputStream.read() & 0xFF) << 24) + ((long)(inputStream.read() & 0xFF) << 32) + ((long)(inputStream.read() & 0xFF) << 40) + ((long)(inputStream.read() & 0xFF) << 48) + ((long)(inputStream.read() & 0xFF) << 56));
                            remaining -= 8;
                            break;
                        }
                        default: {
                            toReadLen = read;
                        }
                    }
                    if (toReadLen == -1) {
                        valueObjects[i2] = null;
                        continue block13;
                    }
                    if (toReadLen == 0) {
                        valueObjects[i2] = new byte[0];
                        continue block13;
                    }
                    valueObjects[i2] = packetFetcher.readLength(toReadLen);
                    remaining -= toReadLen;
                    continue block13;
                }
                case BIGINT: 
                case DOUBLE: {
                    valueObjects[i2] = packetFetcher.readLength(8);
                    remaining -= 8;
                    continue block13;
                }
                case INTEGER: 
                case MEDIUMINT: 
                case FLOAT: {
                    valueObjects[i2] = packetFetcher.readLength(4);
                    remaining -= 4;
                    continue block13;
                }
                case SMALLINT: 
                case YEAR: {
                    valueObjects[i2] = packetFetcher.readLength(2);
                    remaining -= 2;
                    continue block13;
                }
                case TINYINT: {
                    valueObjects[i2] = new byte[]{(byte)inputStream.read()};
                    --remaining;
                    continue block13;
                }
                default: {
                    valueObjects[i2] = null;
                }
            }
        }
        return valueObjects;
    }
}

